﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/cloudformation/model/ListStackRefactorActionsResult.h>
#include <aws/core/utils/xml/XmlSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/logging/LogMacros.h>

#include <utility>

using namespace Aws::CloudFormation::Model;
using namespace Aws::Utils::Xml;
using namespace Aws::Utils::Logging;
using namespace Aws::Utils;
using namespace Aws;

ListStackRefactorActionsResult::ListStackRefactorActionsResult(const Aws::AmazonWebServiceResult<XmlDocument>& result)
{
  *this = result;
}

ListStackRefactorActionsResult& ListStackRefactorActionsResult::operator =(const Aws::AmazonWebServiceResult<XmlDocument>& result)
{
  const XmlDocument& xmlDocument = result.GetPayload();
  XmlNode rootNode = xmlDocument.GetRootElement();
  XmlNode resultNode = rootNode;
  if (!rootNode.IsNull() && (rootNode.GetName() != "ListStackRefactorActionsResult"))
  {
    resultNode = rootNode.FirstChild("ListStackRefactorActionsResult");
  }

  if(!resultNode.IsNull())
  {
    XmlNode stackRefactorActionsNode = resultNode.FirstChild("StackRefactorActions");
    if(!stackRefactorActionsNode.IsNull())
    {
      XmlNode stackRefactorActionsMember = stackRefactorActionsNode.FirstChild("member");
      m_stackRefactorActionsHasBeenSet = !stackRefactorActionsMember.IsNull();
      while(!stackRefactorActionsMember.IsNull())
      {
        m_stackRefactorActions.push_back(stackRefactorActionsMember);
        stackRefactorActionsMember = stackRefactorActionsMember.NextNode("member");
      }

      m_stackRefactorActionsHasBeenSet = true;
    }
    XmlNode nextTokenNode = resultNode.FirstChild("NextToken");
    if(!nextTokenNode.IsNull())
    {
      m_nextToken = Aws::Utils::Xml::DecodeEscapedXmlText(nextTokenNode.GetText());
      m_nextTokenHasBeenSet = true;
    }
  }

  if (!rootNode.IsNull()) {
    XmlNode responseMetadataNode = rootNode.FirstChild("ResponseMetadata");
    m_responseMetadata = responseMetadataNode;
    m_responseMetadataHasBeenSet = true;
    AWS_LOGSTREAM_DEBUG("Aws::CloudFormation::Model::ListStackRefactorActionsResult", "x-amzn-request-id: " << m_responseMetadata.GetRequestId() );
  }
  return *this;
}
