﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/cleanrooms/model/ProtectedJobWorkerComputeConfiguration.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace CleanRooms
{
namespace Model
{

ProtectedJobWorkerComputeConfiguration::ProtectedJobWorkerComputeConfiguration(JsonView jsonValue)
{
  *this = jsonValue;
}

ProtectedJobWorkerComputeConfiguration& ProtectedJobWorkerComputeConfiguration::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("type"))
  {
    m_type = ProtectedJobWorkerComputeTypeMapper::GetProtectedJobWorkerComputeTypeForName(jsonValue.GetString("type"));
    m_typeHasBeenSet = true;
  }
  if(jsonValue.ValueExists("number"))
  {
    m_number = jsonValue.GetInteger("number");
    m_numberHasBeenSet = true;
  }
  return *this;
}

JsonValue ProtectedJobWorkerComputeConfiguration::Jsonize() const
{
  JsonValue payload;

  if(m_typeHasBeenSet)
  {
   payload.WithString("type", ProtectedJobWorkerComputeTypeMapper::GetNameForProtectedJobWorkerComputeType(m_type));
  }

  if(m_numberHasBeenSet)
  {
   payload.WithInteger("number", m_number);

  }

  return payload;
}

} // namespace Model
} // namespace CleanRooms
} // namespace Aws
