﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/chime/model/UserSettings.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace Chime
{
namespace Model
{

UserSettings::UserSettings(JsonView jsonValue)
{
  *this = jsonValue;
}

UserSettings& UserSettings::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("Telephony"))
  {
    m_telephony = jsonValue.GetObject("Telephony");
    m_telephonyHasBeenSet = true;
  }
  return *this;
}

JsonValue UserSettings::Jsonize() const
{
  JsonValue payload;

  if(m_telephonyHasBeenSet)
  {
   payload.WithObject("Telephony", m_telephony.Jsonize());

  }

  return payload;
}

} // namespace Model
} // namespace Chime
} // namespace Aws
