﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/autoscaling/model/DescribeAutoScalingInstancesRequest.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

using namespace Aws::AutoScaling::Model;
using namespace Aws::Utils;

Aws::String DescribeAutoScalingInstancesRequest::SerializePayload() const
{
  Aws::StringStream ss;
  ss << "Action=DescribeAutoScalingInstances&";
  if(m_instanceIdsHasBeenSet)
  {
    if (m_instanceIds.empty())
    {
      ss << "InstanceIds=&";
    }
    else
    {
      unsigned instanceIdsCount = 1;
      for(auto& item : m_instanceIds)
      {
        ss << "InstanceIds.member." << instanceIdsCount << "="
            << StringUtils::URLEncode(item.c_str()) << "&";
        instanceIdsCount++;
      }
    }
  }

  if(m_maxRecordsHasBeenSet)
  {
    ss << "MaxRecords=" << m_maxRecords << "&";
  }

  if(m_nextTokenHasBeenSet)
  {
    ss << "NextToken=" << StringUtils::URLEncode(m_nextToken.c_str()) << "&";
  }

  ss << "Version=2011-01-01";
  return ss.str();
}


void  DescribeAutoScalingInstancesRequest::DumpBodyToUrl(Aws::Http::URI& uri ) const
{
  uri.SetQueryString(SerializePayload());
}
