
/* Copyright © 2015-2021 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */
/* This file generated from vk_entrypoints_gen.py, don't edit directly. */

#include "vk_dispatch_table.h"

#include "adreno_common.xml.h"

#ifndef TU_ENTRYPOINTS_H
#define TU_ENTRYPOINTS_H


/* Entrypoint symbols are optional, and resolves to NULL if undefined.
 * On Unix, this semantics is achieved through weak symbols.
 * Note that we only declare the symbols as weak when it needs to be optional;
 * otherwise, the symbol is declared as a regular symbol.
 * This is to workaround a MinGW limitation: on MinGW, the definition for a
 * weak symbol must be regular, or the linker will end up resolving to one of
 * the fallback symbols with the absolute value of 0.
 * On MSVC, weak symbols are not well supported, so we use the functionally
 * equivalent /alternatename.
 */
#if !defined(_MSC_VER) && defined(VK_ENTRY_USE_WEAK)
#define VK_ENTRY_WEAK __attribute__ ((weak))
#else
#define VK_ENTRY_WEAK
#endif

/* On Unix, we explicitly declare the symbols as hidden, as -fvisibility=hidden
 * only applies to definitions, not declarations.
 * Windows uses hidden visibility by default (requiring dllexport for public
 * symbols), so we don't need to deal with visibility there.
 */
#ifndef _WIN32
#define VK_ENTRY_HIDDEN __attribute__ ((visibility("hidden")))
#else
#define VK_ENTRY_HIDDEN
#endif

extern const struct vk_instance_entrypoint_table tu_instance_entrypoints;

extern const struct vk_physical_device_entrypoint_table tu_physical_device_entrypoints;

extern const struct vk_device_entrypoint_table tu_device_entrypoints;
extern const struct vk_device_entrypoint_table tu_rmv_device_entrypoints;

extern const struct vk_device_entrypoint_table tu_device_entrypoints_a6xx;
extern const struct vk_device_entrypoint_table tu_device_entrypoints_a7xx;
extern const struct vk_device_entrypoint_table tu_device_entrypoints_a8xx;

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateInstance(const VkInstanceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkInstance* pInstance) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_DestroyInstance(VkInstance instance, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_EnumeratePhysicalDevices(VkInstance instance, uint32_t* pPhysicalDeviceCount, VkPhysicalDevice* pPhysicalDevices) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR PFN_vkVoidFunction VKAPI_CALL tu_GetInstanceProcAddr(VkInstance instance, const char* pName) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_EnumerateInstanceVersion(uint32_t* pApiVersion) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_EnumerateInstanceLayerProperties(uint32_t* pPropertyCount, VkLayerProperties* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_EnumerateInstanceExtensionProperties(const char* pLayerName, uint32_t* pPropertyCount, VkExtensionProperties* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
#ifdef VK_USE_PLATFORM_ANDROID_KHR
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateAndroidSurfaceKHR(VkInstance instance, const VkAndroidSurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
#endif // VK_USE_PLATFORM_ANDROID_KHR
#ifdef VK_USE_PLATFORM_OHOS
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateSurfaceOHOS(VkInstance instance, const VkSurfaceCreateInfoOHOS* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
#endif // VK_USE_PLATFORM_OHOS
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateDisplayPlaneSurfaceKHR(VkInstance instance, const VkDisplaySurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_DestroySurfaceKHR(VkInstance instance, VkSurfaceKHR surface, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
#ifdef VK_USE_PLATFORM_VI_NN
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateViSurfaceNN(VkInstance instance, const VkViSurfaceCreateInfoNN* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
#endif // VK_USE_PLATFORM_VI_NN
#ifdef VK_USE_PLATFORM_WAYLAND_KHR
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateWaylandSurfaceKHR(VkInstance instance, const VkWaylandSurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
#endif // VK_USE_PLATFORM_WAYLAND_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateWin32SurfaceKHR(VkInstance instance, const VkWin32SurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_XLIB_KHR
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateXlibSurfaceKHR(VkInstance instance, const VkXlibSurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
#endif // VK_USE_PLATFORM_XLIB_KHR
#ifdef VK_USE_PLATFORM_XCB_KHR
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateXcbSurfaceKHR(VkInstance instance, const VkXcbSurfaceCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
#endif // VK_USE_PLATFORM_XCB_KHR
#ifdef VK_USE_PLATFORM_DIRECTFB_EXT
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateDirectFBSurfaceEXT(VkInstance instance, const VkDirectFBSurfaceCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
#endif // VK_USE_PLATFORM_DIRECTFB_EXT
#ifdef VK_USE_PLATFORM_FUCHSIA
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateImagePipeSurfaceFUCHSIA(VkInstance instance, const VkImagePipeSurfaceCreateInfoFUCHSIA* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
#endif // VK_USE_PLATFORM_FUCHSIA
#ifdef VK_USE_PLATFORM_GGP
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateStreamDescriptorSurfaceGGP(VkInstance instance, const VkStreamDescriptorSurfaceCreateInfoGGP* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
#endif // VK_USE_PLATFORM_GGP
#ifdef VK_USE_PLATFORM_SCREEN_QNX
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateScreenSurfaceQNX(VkInstance instance, const VkScreenSurfaceCreateInfoQNX* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
#endif // VK_USE_PLATFORM_SCREEN_QNX
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateDebugReportCallbackEXT(VkInstance instance, const VkDebugReportCallbackCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDebugReportCallbackEXT* pCallback) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_DestroyDebugReportCallbackEXT(VkInstance instance, VkDebugReportCallbackEXT callback, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_DebugReportMessageEXT(VkInstance instance, VkDebugReportFlagsEXT flags, VkDebugReportObjectTypeEXT objectType, uint64_t object, size_t location, int32_t messageCode, const char* pLayerPrefix, const char* pMessage) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_EnumeratePhysicalDeviceGroups(VkInstance instance, uint32_t* pPhysicalDeviceGroupCount, VkPhysicalDeviceGroupProperties* pPhysicalDeviceGroupProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_EnumeratePhysicalDeviceGroupsKHR(VkInstance instance, uint32_t* pPhysicalDeviceGroupCount, VkPhysicalDeviceGroupProperties* pPhysicalDeviceGroupProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
#ifdef VK_USE_PLATFORM_IOS_MVK
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateIOSSurfaceMVK(VkInstance instance, const VkIOSSurfaceCreateInfoMVK* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
#endif // VK_USE_PLATFORM_IOS_MVK
#ifdef VK_USE_PLATFORM_MACOS_MVK
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateMacOSSurfaceMVK(VkInstance instance, const VkMacOSSurfaceCreateInfoMVK* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
#endif // VK_USE_PLATFORM_MACOS_MVK
#ifdef VK_USE_PLATFORM_METAL_EXT
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateMetalSurfaceEXT(VkInstance instance, const VkMetalSurfaceCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
#endif // VK_USE_PLATFORM_METAL_EXT
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateDebugUtilsMessengerEXT(VkInstance instance, const VkDebugUtilsMessengerCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDebugUtilsMessengerEXT* pMessenger) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_DestroyDebugUtilsMessengerEXT(VkInstance instance, VkDebugUtilsMessengerEXT messenger, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_SubmitDebugUtilsMessageEXT(VkInstance instance, VkDebugUtilsMessageSeverityFlagBitsEXT messageSeverity, VkDebugUtilsMessageTypeFlagsEXT messageTypes, const VkDebugUtilsMessengerCallbackDataEXT* pCallbackData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateHeadlessSurfaceEXT(VkInstance instance, const VkHeadlessSurfaceCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_GetExternalComputeQueueDataNV(VkExternalComputeQueueNV externalQueue, VkExternalComputeQueueDataParamsNV* params, void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  VKAPI_ATTR void VKAPI_CALL tu_GetPhysicalDeviceProperties(VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_GetPhysicalDeviceQueueFamilyProperties(VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties* pQueueFamilyProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_GetPhysicalDeviceMemoryProperties(VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties* pMemoryProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_GetPhysicalDeviceFeatures(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures* pFeatures) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_GetPhysicalDeviceFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties* pFormatProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPhysicalDeviceImageFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkImageTiling tiling, VkImageUsageFlags usage, VkImageCreateFlags flags, VkImageFormatProperties* pImageFormatProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateDevice(VkPhysicalDevice physicalDevice, const VkDeviceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDevice* pDevice) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_EnumerateDeviceLayerProperties(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkLayerProperties* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_EnumerateDeviceExtensionProperties(VkPhysicalDevice physicalDevice, const char* pLayerName, uint32_t* pPropertyCount, VkExtensionProperties* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_GetPhysicalDeviceSparseImageFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkSampleCountFlagBits samples, VkImageUsageFlags usage, VkImageTiling tiling, uint32_t* pPropertyCount, VkSparseImageFormatProperties* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPhysicalDeviceDisplayPropertiesKHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkDisplayPropertiesKHR* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPhysicalDeviceDisplayPlanePropertiesKHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkDisplayPlanePropertiesKHR* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetDisplayPlaneSupportedDisplaysKHR(VkPhysicalDevice physicalDevice, uint32_t planeIndex, uint32_t* pDisplayCount, VkDisplayKHR* pDisplays) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetDisplayModePropertiesKHR(VkPhysicalDevice physicalDevice, VkDisplayKHR display, uint32_t* pPropertyCount, VkDisplayModePropertiesKHR* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateDisplayModeKHR(VkPhysicalDevice physicalDevice, VkDisplayKHR display, const VkDisplayModeCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDisplayModeKHR* pMode) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetDisplayPlaneCapabilitiesKHR(VkPhysicalDevice physicalDevice, VkDisplayModeKHR mode, uint32_t planeIndex, VkDisplayPlaneCapabilitiesKHR* pCapabilities) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPhysicalDeviceSurfaceSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, VkSurfaceKHR surface, VkBool32* pSupported) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPhysicalDeviceSurfaceCapabilitiesKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, VkSurfaceCapabilitiesKHR* pSurfaceCapabilities) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPhysicalDeviceSurfaceFormatsKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, uint32_t* pSurfaceFormatCount, VkSurfaceFormatKHR* pSurfaceFormats) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPhysicalDeviceSurfacePresentModesKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, uint32_t* pPresentModeCount, VkPresentModeKHR* pPresentModes) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
#ifdef VK_USE_PLATFORM_WAYLAND_KHR
  VKAPI_ATTR VkBool32 VKAPI_CALL tu_GetPhysicalDeviceWaylandPresentationSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, struct wl_display* display) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
#endif // VK_USE_PLATFORM_WAYLAND_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
  VKAPI_ATTR VkBool32 VKAPI_CALL tu_GetPhysicalDeviceWin32PresentationSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_XLIB_KHR
  VKAPI_ATTR VkBool32 VKAPI_CALL tu_GetPhysicalDeviceXlibPresentationSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, Display* dpy, VisualID visualID) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
#endif // VK_USE_PLATFORM_XLIB_KHR
#ifdef VK_USE_PLATFORM_XCB_KHR
  VKAPI_ATTR VkBool32 VKAPI_CALL tu_GetPhysicalDeviceXcbPresentationSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, xcb_connection_t* connection, xcb_visualid_t visual_id) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
#endif // VK_USE_PLATFORM_XCB_KHR
#ifdef VK_USE_PLATFORM_DIRECTFB_EXT
  VKAPI_ATTR VkBool32 VKAPI_CALL tu_GetPhysicalDeviceDirectFBPresentationSupportEXT(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, IDirectFB* dfb) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
#endif // VK_USE_PLATFORM_DIRECTFB_EXT
#ifdef VK_USE_PLATFORM_SCREEN_QNX
  VKAPI_ATTR VkBool32 VKAPI_CALL tu_GetPhysicalDeviceScreenPresentationSupportQNX(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, struct _screen_window* window) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
#endif // VK_USE_PLATFORM_SCREEN_QNX
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPhysicalDeviceExternalImageFormatPropertiesNV(VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkImageTiling tiling, VkImageUsageFlags usage, VkImageCreateFlags flags, VkExternalMemoryHandleTypeFlagsNV externalHandleType, VkExternalImageFormatPropertiesNV* pExternalImageFormatProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_GetPhysicalDeviceFeatures2(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures2* pFeatures) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_GetPhysicalDeviceFeatures2KHR(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures2* pFeatures) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_GetPhysicalDeviceProperties2(VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties2* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_GetPhysicalDeviceProperties2KHR(VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties2* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_GetPhysicalDeviceFormatProperties2(VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties2* pFormatProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_GetPhysicalDeviceFormatProperties2KHR(VkPhysicalDevice physicalDevice, VkFormat format, VkFormatProperties2* pFormatProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPhysicalDeviceImageFormatProperties2(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo, VkImageFormatProperties2* pImageFormatProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPhysicalDeviceImageFormatProperties2KHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo, VkImageFormatProperties2* pImageFormatProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_GetPhysicalDeviceQueueFamilyProperties2(VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties2* pQueueFamilyProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_GetPhysicalDeviceQueueFamilyProperties2KHR(VkPhysicalDevice physicalDevice, uint32_t* pQueueFamilyPropertyCount, VkQueueFamilyProperties2* pQueueFamilyProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_GetPhysicalDeviceMemoryProperties2(VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties2* pMemoryProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_GetPhysicalDeviceMemoryProperties2KHR(VkPhysicalDevice physicalDevice, VkPhysicalDeviceMemoryProperties2* pMemoryProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_GetPhysicalDeviceSparseImageFormatProperties2(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo, uint32_t* pPropertyCount, VkSparseImageFormatProperties2* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_GetPhysicalDeviceSparseImageFormatProperties2KHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo, uint32_t* pPropertyCount, VkSparseImageFormatProperties2* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_GetPhysicalDeviceExternalBufferProperties(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo, VkExternalBufferProperties* pExternalBufferProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_GetPhysicalDeviceExternalBufferPropertiesKHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo, VkExternalBufferProperties* pExternalBufferProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_GetPhysicalDeviceExternalSemaphoreProperties(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo, VkExternalSemaphoreProperties* pExternalSemaphoreProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_GetPhysicalDeviceExternalSemaphorePropertiesKHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo, VkExternalSemaphoreProperties* pExternalSemaphoreProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_GetPhysicalDeviceExternalFenceProperties(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo, VkExternalFenceProperties* pExternalFenceProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_GetPhysicalDeviceExternalFencePropertiesKHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo, VkExternalFenceProperties* pExternalFenceProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_ReleaseDisplayEXT(VkPhysicalDevice physicalDevice, VkDisplayKHR display) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
#ifdef VK_USE_PLATFORM_XLIB_XRANDR_EXT
  VKAPI_ATTR VkResult VKAPI_CALL tu_AcquireXlibDisplayEXT(VkPhysicalDevice physicalDevice, Display* dpy, VkDisplayKHR display) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
#endif // VK_USE_PLATFORM_XLIB_XRANDR_EXT
#ifdef VK_USE_PLATFORM_XLIB_XRANDR_EXT
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetRandROutputDisplayEXT(VkPhysicalDevice physicalDevice, Display* dpy, RROutput rrOutput, VkDisplayKHR* pDisplay) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
#endif // VK_USE_PLATFORM_XLIB_XRANDR_EXT
#ifdef VK_USE_PLATFORM_WIN32_KHR
  VKAPI_ATTR VkResult VKAPI_CALL tu_AcquireWinrtDisplayNV(VkPhysicalDevice physicalDevice, VkDisplayKHR display) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetWinrtDisplayNV(VkPhysicalDevice physicalDevice, uint32_t deviceRelativeId, VkDisplayKHR* pDisplay) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
#endif // VK_USE_PLATFORM_WIN32_KHR
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPhysicalDeviceSurfaceCapabilities2EXT(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, VkSurfaceCapabilities2EXT* pSurfaceCapabilities) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPhysicalDevicePresentRectanglesKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface, uint32_t* pRectCount, VkRect2D* pRects) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_GetPhysicalDeviceMultisamplePropertiesEXT(VkPhysicalDevice physicalDevice, VkSampleCountFlagBits samples, VkMultisamplePropertiesEXT* pMultisampleProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPhysicalDeviceSurfaceCapabilities2KHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo, VkSurfaceCapabilities2KHR* pSurfaceCapabilities) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPhysicalDeviceSurfaceFormats2KHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo, uint32_t* pSurfaceFormatCount, VkSurfaceFormat2KHR* pSurfaceFormats) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPhysicalDeviceDisplayProperties2KHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkDisplayProperties2KHR* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPhysicalDeviceDisplayPlaneProperties2KHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkDisplayPlaneProperties2KHR* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetDisplayModeProperties2KHR(VkPhysicalDevice physicalDevice, VkDisplayKHR display, uint32_t* pPropertyCount, VkDisplayModeProperties2KHR* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetDisplayPlaneCapabilities2KHR(VkPhysicalDevice physicalDevice, const VkDisplayPlaneInfo2KHR* pDisplayPlaneInfo, VkDisplayPlaneCapabilities2KHR* pCapabilities) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPhysicalDeviceCalibrateableTimeDomainsKHR(VkPhysicalDevice physicalDevice, uint32_t* pTimeDomainCount, VkTimeDomainKHR* pTimeDomains) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPhysicalDeviceCalibrateableTimeDomainsEXT(VkPhysicalDevice physicalDevice, uint32_t* pTimeDomainCount, VkTimeDomainKHR* pTimeDomains) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPhysicalDeviceCooperativeMatrixPropertiesNV(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkCooperativeMatrixPropertiesNV* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
#ifdef VK_USE_PLATFORM_WIN32_KHR
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPhysicalDeviceSurfacePresentModes2EXT(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo, uint32_t* pPresentModeCount, VkPresentModeKHR* pPresentModes) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
#endif // VK_USE_PLATFORM_WIN32_KHR
  VKAPI_ATTR VkResult VKAPI_CALL tu_EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, uint32_t* pCounterCount, VkPerformanceCounterKHR* pCounters, VkPerformanceCounterDescriptionKHR* pCounterDescriptions) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR(VkPhysicalDevice physicalDevice, const VkQueryPoolPerformanceCreateInfoKHR* pPerformanceQueryCreateInfo, uint32_t* pNumPasses) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV(VkPhysicalDevice physicalDevice, uint32_t* pCombinationCount, VkFramebufferMixedSamplesCombinationNV* pCombinations) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPhysicalDeviceToolProperties(VkPhysicalDevice physicalDevice, uint32_t* pToolCount, VkPhysicalDeviceToolProperties* pToolProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPhysicalDeviceToolPropertiesEXT(VkPhysicalDevice physicalDevice, uint32_t* pToolCount, VkPhysicalDeviceToolProperties* pToolProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPhysicalDeviceFragmentShadingRatesKHR(VkPhysicalDevice physicalDevice, uint32_t* pFragmentShadingRateCount, VkPhysicalDeviceFragmentShadingRateKHR* pFragmentShadingRates) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPhysicalDeviceVideoCapabilitiesKHR(VkPhysicalDevice physicalDevice, const VkVideoProfileInfoKHR* pVideoProfile, VkVideoCapabilitiesKHR* pCapabilities) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPhysicalDeviceVideoFormatPropertiesKHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceVideoFormatInfoKHR* pVideoFormatInfo, uint32_t* pVideoFormatPropertyCount, VkVideoFormatPropertiesKHR* pVideoFormatProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR(VkPhysicalDevice physicalDevice, const VkPhysicalDeviceVideoEncodeQualityLevelInfoKHR* pQualityLevelInfo, VkVideoEncodeQualityLevelPropertiesKHR* pQualityLevelProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_AcquireDrmDisplayEXT(VkPhysicalDevice physicalDevice, int32_t drmFd, VkDisplayKHR display) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetDrmDisplayEXT(VkPhysicalDevice physicalDevice, int32_t drmFd, uint32_t connectorId, VkDisplayKHR* display) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPhysicalDeviceOpticalFlowImageFormatsNV(VkPhysicalDevice physicalDevice, const VkOpticalFlowImageFormatInfoNV* pOpticalFlowImageFormatInfo, uint32_t* pFormatCount, VkOpticalFlowImageFormatPropertiesNV* pImageFormatProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPhysicalDeviceCooperativeMatrixPropertiesKHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkCooperativeMatrixPropertiesKHR* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPhysicalDeviceCooperativeMatrixFlexibleDimensionsPropertiesNV(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkCooperativeMatrixFlexibleDimensionsPropertiesNV* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPhysicalDeviceCooperativeVectorPropertiesNV(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount, VkCooperativeVectorPropertiesNV* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_GetPhysicalDeviceExternalTensorPropertiesARM(VkPhysicalDevice                             physicalDevice, const VkPhysicalDeviceExternalTensorInfoARM* pExternalTensorInfo, VkExternalTensorPropertiesARM*               pExternalTensorProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPhysicalDeviceQueueFamilyDataGraphPropertiesARM(VkPhysicalDevice                     physicalDevice, uint32_t                             queueFamilyIndex, uint32_t*                            pQueueFamilyDataGraphPropertyCount, VkQueueFamilyDataGraphPropertiesARM* pQueueFamilyDataGraphProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_GetPhysicalDeviceQueueFamilyDataGraphProcessingEnginePropertiesARM(VkPhysicalDevice                                 physicalDevice, const VkPhysicalDeviceQueueFamilyDataGraphProcessingEngineInfoARM* pQueueFamilyDataGraphProcessingEngineInfo, VkQueueFamilyDataGraphProcessingEnginePropertiesARM*               pQueueFamilyDataGraphProcessingEngineProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_EnumeratePhysicalDeviceQueueFamilyPerformanceCountersByRegionARM(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, uint32_t* pCounterCount, VkPerformanceCounterARM* pCounters, VkPerformanceCounterDescriptionARM* pCounterDescriptions) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  VKAPI_ATTR PFN_vkVoidFunction VKAPI_CALL tu_GetDeviceProcAddr(VkDevice device, const char* pName) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR PFN_vkVoidFunction VKAPI_CALL tu_rmv_GetDeviceProcAddr(VkDevice device, const char* pName) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR PFN_vkVoidFunction VKAPI_CALL tu_GetDeviceProcAddr(VkDevice device, const char* pName);

  #define tu_GetDeviceProcAddr_GENS(X)   template VKAPI_ATTR PFN_vkVoidFunction VKAPI_CALL tu_GetDeviceProcAddr<X>(VkDevice device, const char* pName);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyDevice(VkDevice device, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyDevice(VkDevice device, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyDevice(VkDevice device, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyDevice_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyDevice<X>(VkDevice device, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR void VKAPI_CALL tu_GetDeviceQueue(VkDevice device, uint32_t queueFamilyIndex, uint32_t queueIndex, VkQueue* pQueue) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetDeviceQueue(VkDevice device, uint32_t queueFamilyIndex, uint32_t queueIndex, VkQueue* pQueue) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetDeviceQueue(VkDevice device, uint32_t queueFamilyIndex, uint32_t queueIndex, VkQueue* pQueue);

  #define tu_GetDeviceQueue_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetDeviceQueue<X>(VkDevice device, uint32_t queueFamilyIndex, uint32_t queueIndex, VkQueue* pQueue);

  VKAPI_ATTR VkResult VKAPI_CALL tu_QueueSubmit(VkQueue queue, uint32_t submitCount, const VkSubmitInfo* pSubmits, VkFence fence) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_QueueSubmit(VkQueue queue, uint32_t submitCount, const VkSubmitInfo* pSubmits, VkFence fence) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_QueueSubmit(VkQueue queue, uint32_t submitCount, const VkSubmitInfo* pSubmits, VkFence fence);

  #define tu_QueueSubmit_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_QueueSubmit<X>(VkQueue queue, uint32_t submitCount, const VkSubmitInfo* pSubmits, VkFence fence);

  VKAPI_ATTR VkResult VKAPI_CALL tu_QueueWaitIdle(VkQueue queue) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_QueueWaitIdle(VkQueue queue) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_QueueWaitIdle(VkQueue queue);

  #define tu_QueueWaitIdle_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_QueueWaitIdle<X>(VkQueue queue);

  VKAPI_ATTR VkResult VKAPI_CALL tu_DeviceWaitIdle(VkDevice device) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_DeviceWaitIdle(VkDevice device) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_DeviceWaitIdle(VkDevice device);

  #define tu_DeviceWaitIdle_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_DeviceWaitIdle<X>(VkDevice device);

  VKAPI_ATTR VkResult VKAPI_CALL tu_AllocateMemory(VkDevice device, const VkMemoryAllocateInfo* pAllocateInfo, const VkAllocationCallbacks* pAllocator, VkDeviceMemory* pMemory) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_AllocateMemory(VkDevice device, const VkMemoryAllocateInfo* pAllocateInfo, const VkAllocationCallbacks* pAllocator, VkDeviceMemory* pMemory) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_AllocateMemory(VkDevice device, const VkMemoryAllocateInfo* pAllocateInfo, const VkAllocationCallbacks* pAllocator, VkDeviceMemory* pMemory);

  #define tu_AllocateMemory_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_AllocateMemory<X>(VkDevice device, const VkMemoryAllocateInfo* pAllocateInfo, const VkAllocationCallbacks* pAllocator, VkDeviceMemory* pMemory);

  VKAPI_ATTR void VKAPI_CALL tu_FreeMemory(VkDevice device, VkDeviceMemory memory, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_FreeMemory(VkDevice device, VkDeviceMemory memory, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_FreeMemory(VkDevice device, VkDeviceMemory memory, const VkAllocationCallbacks* pAllocator);

  #define tu_FreeMemory_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_FreeMemory<X>(VkDevice device, VkDeviceMemory memory, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR VkResult VKAPI_CALL tu_MapMemory(VkDevice device, VkDeviceMemory memory, VkDeviceSize offset, VkDeviceSize size, VkMemoryMapFlags flags, void** ppData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_MapMemory(VkDevice device, VkDeviceMemory memory, VkDeviceSize offset, VkDeviceSize size, VkMemoryMapFlags flags, void** ppData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_MapMemory(VkDevice device, VkDeviceMemory memory, VkDeviceSize offset, VkDeviceSize size, VkMemoryMapFlags flags, void** ppData);

  #define tu_MapMemory_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_MapMemory<X>(VkDevice device, VkDeviceMemory memory, VkDeviceSize offset, VkDeviceSize size, VkMemoryMapFlags flags, void** ppData);

  VKAPI_ATTR void VKAPI_CALL tu_UnmapMemory(VkDevice device, VkDeviceMemory memory) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_UnmapMemory(VkDevice device, VkDeviceMemory memory) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_UnmapMemory(VkDevice device, VkDeviceMemory memory);

  #define tu_UnmapMemory_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_UnmapMemory<X>(VkDevice device, VkDeviceMemory memory);

  VKAPI_ATTR VkResult VKAPI_CALL tu_FlushMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_FlushMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_FlushMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges);

  #define tu_FlushMappedMemoryRanges_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_FlushMappedMemoryRanges<X>(VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges);

  VKAPI_ATTR VkResult VKAPI_CALL tu_InvalidateMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_InvalidateMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_InvalidateMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges);

  #define tu_InvalidateMappedMemoryRanges_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_InvalidateMappedMemoryRanges<X>(VkDevice device, uint32_t memoryRangeCount, const VkMappedMemoryRange* pMemoryRanges);

  VKAPI_ATTR void VKAPI_CALL tu_GetDeviceMemoryCommitment(VkDevice device, VkDeviceMemory memory, VkDeviceSize* pCommittedMemoryInBytes) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetDeviceMemoryCommitment(VkDevice device, VkDeviceMemory memory, VkDeviceSize* pCommittedMemoryInBytes) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetDeviceMemoryCommitment(VkDevice device, VkDeviceMemory memory, VkDeviceSize* pCommittedMemoryInBytes);

  #define tu_GetDeviceMemoryCommitment_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetDeviceMemoryCommitment<X>(VkDevice device, VkDeviceMemory memory, VkDeviceSize* pCommittedMemoryInBytes);

  VKAPI_ATTR void VKAPI_CALL tu_GetBufferMemoryRequirements(VkDevice device, VkBuffer buffer, VkMemoryRequirements* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetBufferMemoryRequirements(VkDevice device, VkBuffer buffer, VkMemoryRequirements* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetBufferMemoryRequirements(VkDevice device, VkBuffer buffer, VkMemoryRequirements* pMemoryRequirements);

  #define tu_GetBufferMemoryRequirements_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetBufferMemoryRequirements<X>(VkDevice device, VkBuffer buffer, VkMemoryRequirements* pMemoryRequirements);

  VKAPI_ATTR VkResult VKAPI_CALL tu_BindBufferMemory(VkDevice device, VkBuffer buffer, VkDeviceMemory memory, VkDeviceSize memoryOffset) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_BindBufferMemory(VkDevice device, VkBuffer buffer, VkDeviceMemory memory, VkDeviceSize memoryOffset) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_BindBufferMemory(VkDevice device, VkBuffer buffer, VkDeviceMemory memory, VkDeviceSize memoryOffset);

  #define tu_BindBufferMemory_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_BindBufferMemory<X>(VkDevice device, VkBuffer buffer, VkDeviceMemory memory, VkDeviceSize memoryOffset);

  VKAPI_ATTR void VKAPI_CALL tu_GetImageMemoryRequirements(VkDevice device, VkImage image, VkMemoryRequirements* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetImageMemoryRequirements(VkDevice device, VkImage image, VkMemoryRequirements* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetImageMemoryRequirements(VkDevice device, VkImage image, VkMemoryRequirements* pMemoryRequirements);

  #define tu_GetImageMemoryRequirements_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetImageMemoryRequirements<X>(VkDevice device, VkImage image, VkMemoryRequirements* pMemoryRequirements);

  VKAPI_ATTR VkResult VKAPI_CALL tu_BindImageMemory(VkDevice device, VkImage image, VkDeviceMemory memory, VkDeviceSize memoryOffset) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_BindImageMemory(VkDevice device, VkImage image, VkDeviceMemory memory, VkDeviceSize memoryOffset) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_BindImageMemory(VkDevice device, VkImage image, VkDeviceMemory memory, VkDeviceSize memoryOffset);

  #define tu_BindImageMemory_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_BindImageMemory<X>(VkDevice device, VkImage image, VkDeviceMemory memory, VkDeviceSize memoryOffset);

  VKAPI_ATTR void VKAPI_CALL tu_GetImageSparseMemoryRequirements(VkDevice device, VkImage image, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements* pSparseMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetImageSparseMemoryRequirements(VkDevice device, VkImage image, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements* pSparseMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetImageSparseMemoryRequirements(VkDevice device, VkImage image, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements* pSparseMemoryRequirements);

  #define tu_GetImageSparseMemoryRequirements_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetImageSparseMemoryRequirements<X>(VkDevice device, VkImage image, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements* pSparseMemoryRequirements);

  VKAPI_ATTR VkResult VKAPI_CALL tu_QueueBindSparse(VkQueue queue, uint32_t bindInfoCount, const VkBindSparseInfo* pBindInfo, VkFence fence) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_QueueBindSparse(VkQueue queue, uint32_t bindInfoCount, const VkBindSparseInfo* pBindInfo, VkFence fence) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_QueueBindSparse(VkQueue queue, uint32_t bindInfoCount, const VkBindSparseInfo* pBindInfo, VkFence fence);

  #define tu_QueueBindSparse_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_QueueBindSparse<X>(VkQueue queue, uint32_t bindInfoCount, const VkBindSparseInfo* pBindInfo, VkFence fence);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateFence(VkDevice device, const VkFenceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateFence(VkDevice device, const VkFenceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateFence(VkDevice device, const VkFenceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence);

  #define tu_CreateFence_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateFence<X>(VkDevice device, const VkFenceCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyFence(VkDevice device, VkFence fence, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyFence(VkDevice device, VkFence fence, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyFence(VkDevice device, VkFence fence, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyFence_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyFence<X>(VkDevice device, VkFence fence, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR VkResult VKAPI_CALL tu_ResetFences(VkDevice device, uint32_t fenceCount, const VkFence* pFences) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_ResetFences(VkDevice device, uint32_t fenceCount, const VkFence* pFences) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_ResetFences(VkDevice device, uint32_t fenceCount, const VkFence* pFences);

  #define tu_ResetFences_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_ResetFences<X>(VkDevice device, uint32_t fenceCount, const VkFence* pFences);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetFenceStatus(VkDevice device, VkFence fence) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetFenceStatus(VkDevice device, VkFence fence) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetFenceStatus(VkDevice device, VkFence fence);

  #define tu_GetFenceStatus_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetFenceStatus<X>(VkDevice device, VkFence fence);

  VKAPI_ATTR VkResult VKAPI_CALL tu_WaitForFences(VkDevice device, uint32_t fenceCount, const VkFence* pFences, VkBool32 waitAll, uint64_t timeout) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_WaitForFences(VkDevice device, uint32_t fenceCount, const VkFence* pFences, VkBool32 waitAll, uint64_t timeout) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_WaitForFences(VkDevice device, uint32_t fenceCount, const VkFence* pFences, VkBool32 waitAll, uint64_t timeout);

  #define tu_WaitForFences_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_WaitForFences<X>(VkDevice device, uint32_t fenceCount, const VkFence* pFences, VkBool32 waitAll, uint64_t timeout);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateSemaphore(VkDevice device, const VkSemaphoreCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSemaphore* pSemaphore) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateSemaphore(VkDevice device, const VkSemaphoreCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSemaphore* pSemaphore) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateSemaphore(VkDevice device, const VkSemaphoreCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSemaphore* pSemaphore);

  #define tu_CreateSemaphore_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateSemaphore<X>(VkDevice device, const VkSemaphoreCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSemaphore* pSemaphore);

  VKAPI_ATTR void VKAPI_CALL tu_DestroySemaphore(VkDevice device, VkSemaphore semaphore, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroySemaphore(VkDevice device, VkSemaphore semaphore, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroySemaphore(VkDevice device, VkSemaphore semaphore, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroySemaphore_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroySemaphore<X>(VkDevice device, VkSemaphore semaphore, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateEvent(VkDevice device, const VkEventCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkEvent* pEvent) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateEvent(VkDevice device, const VkEventCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkEvent* pEvent) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateEvent(VkDevice device, const VkEventCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkEvent* pEvent);

  #define tu_CreateEvent_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateEvent<X>(VkDevice device, const VkEventCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkEvent* pEvent);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyEvent(VkDevice device, VkEvent event, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyEvent(VkDevice device, VkEvent event, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyEvent(VkDevice device, VkEvent event, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyEvent_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyEvent<X>(VkDevice device, VkEvent event, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetEventStatus(VkDevice device, VkEvent event) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetEventStatus(VkDevice device, VkEvent event) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetEventStatus(VkDevice device, VkEvent event);

  #define tu_GetEventStatus_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetEventStatus<X>(VkDevice device, VkEvent event);

  VKAPI_ATTR VkResult VKAPI_CALL tu_SetEvent(VkDevice device, VkEvent event) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_SetEvent(VkDevice device, VkEvent event) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_SetEvent(VkDevice device, VkEvent event);

  #define tu_SetEvent_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_SetEvent<X>(VkDevice device, VkEvent event);

  VKAPI_ATTR VkResult VKAPI_CALL tu_ResetEvent(VkDevice device, VkEvent event) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_ResetEvent(VkDevice device, VkEvent event) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_ResetEvent(VkDevice device, VkEvent event);

  #define tu_ResetEvent_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_ResetEvent<X>(VkDevice device, VkEvent event);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateQueryPool(VkDevice device, const VkQueryPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkQueryPool* pQueryPool) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateQueryPool(VkDevice device, const VkQueryPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkQueryPool* pQueryPool) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateQueryPool(VkDevice device, const VkQueryPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkQueryPool* pQueryPool);

  #define tu_CreateQueryPool_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateQueryPool<X>(VkDevice device, const VkQueryPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkQueryPool* pQueryPool);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyQueryPool(VkDevice device, VkQueryPool queryPool, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyQueryPool(VkDevice device, VkQueryPool queryPool, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyQueryPool(VkDevice device, VkQueryPool queryPool, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyQueryPool_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyQueryPool<X>(VkDevice device, VkQueryPool queryPool, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetQueryPoolResults(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, size_t dataSize, void* pData, VkDeviceSize stride, VkQueryResultFlags flags) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetQueryPoolResults(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, size_t dataSize, void* pData, VkDeviceSize stride, VkQueryResultFlags flags) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetQueryPoolResults(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, size_t dataSize, void* pData, VkDeviceSize stride, VkQueryResultFlags flags);

  #define tu_GetQueryPoolResults_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetQueryPoolResults<X>(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, size_t dataSize, void* pData, VkDeviceSize stride, VkQueryResultFlags flags);

  VKAPI_ATTR void VKAPI_CALL tu_ResetQueryPool(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_ResetQueryPool(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_ResetQueryPool(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount);

  #define tu_ResetQueryPool_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_ResetQueryPool<X>(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount);

  VKAPI_ATTR void VKAPI_CALL tu_ResetQueryPoolEXT(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_ResetQueryPoolEXT(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_ResetQueryPoolEXT(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount);

  #define tu_ResetQueryPoolEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_ResetQueryPoolEXT<X>(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateBuffer(VkDevice device, const VkBufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBuffer* pBuffer) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateBuffer(VkDevice device, const VkBufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBuffer* pBuffer) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateBuffer(VkDevice device, const VkBufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBuffer* pBuffer);

  #define tu_CreateBuffer_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateBuffer<X>(VkDevice device, const VkBufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBuffer* pBuffer);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyBuffer(VkDevice device, VkBuffer buffer, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyBuffer(VkDevice device, VkBuffer buffer, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyBuffer(VkDevice device, VkBuffer buffer, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyBuffer_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyBuffer<X>(VkDevice device, VkBuffer buffer, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateBufferView(VkDevice device, const VkBufferViewCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBufferView* pView) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateBufferView(VkDevice device, const VkBufferViewCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBufferView* pView) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateBufferView(VkDevice device, const VkBufferViewCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBufferView* pView);

  #define tu_CreateBufferView_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateBufferView<X>(VkDevice device, const VkBufferViewCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBufferView* pView);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyBufferView(VkDevice device, VkBufferView bufferView, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyBufferView(VkDevice device, VkBufferView bufferView, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyBufferView(VkDevice device, VkBufferView bufferView, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyBufferView_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyBufferView<X>(VkDevice device, VkBufferView bufferView, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateImage(VkDevice device, const VkImageCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImage* pImage) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateImage(VkDevice device, const VkImageCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImage* pImage) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateImage(VkDevice device, const VkImageCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImage* pImage);

  #define tu_CreateImage_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateImage<X>(VkDevice device, const VkImageCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImage* pImage);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyImage(VkDevice device, VkImage image, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyImage(VkDevice device, VkImage image, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyImage(VkDevice device, VkImage image, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyImage_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyImage<X>(VkDevice device, VkImage image, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR void VKAPI_CALL tu_GetImageSubresourceLayout(VkDevice device, VkImage image, const VkImageSubresource* pSubresource, VkSubresourceLayout* pLayout) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetImageSubresourceLayout(VkDevice device, VkImage image, const VkImageSubresource* pSubresource, VkSubresourceLayout* pLayout) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetImageSubresourceLayout(VkDevice device, VkImage image, const VkImageSubresource* pSubresource, VkSubresourceLayout* pLayout);

  #define tu_GetImageSubresourceLayout_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetImageSubresourceLayout<X>(VkDevice device, VkImage image, const VkImageSubresource* pSubresource, VkSubresourceLayout* pLayout);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateImageView(VkDevice device, const VkImageViewCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImageView* pView) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateImageView(VkDevice device, const VkImageViewCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImageView* pView) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateImageView(VkDevice device, const VkImageViewCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImageView* pView);

  #define tu_CreateImageView_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateImageView<X>(VkDevice device, const VkImageViewCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkImageView* pView);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyImageView(VkDevice device, VkImageView imageView, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyImageView(VkDevice device, VkImageView imageView, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyImageView(VkDevice device, VkImageView imageView, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyImageView_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyImageView<X>(VkDevice device, VkImageView imageView, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateShaderModule(VkDevice device, const VkShaderModuleCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkShaderModule* pShaderModule) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateShaderModule(VkDevice device, const VkShaderModuleCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkShaderModule* pShaderModule) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateShaderModule(VkDevice device, const VkShaderModuleCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkShaderModule* pShaderModule);

  #define tu_CreateShaderModule_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateShaderModule<X>(VkDevice device, const VkShaderModuleCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkShaderModule* pShaderModule);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyShaderModule(VkDevice device, VkShaderModule shaderModule, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyShaderModule(VkDevice device, VkShaderModule shaderModule, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyShaderModule(VkDevice device, VkShaderModule shaderModule, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyShaderModule_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyShaderModule<X>(VkDevice device, VkShaderModule shaderModule, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreatePipelineCache(VkDevice device, const VkPipelineCacheCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineCache* pPipelineCache) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreatePipelineCache(VkDevice device, const VkPipelineCacheCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineCache* pPipelineCache) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreatePipelineCache(VkDevice device, const VkPipelineCacheCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineCache* pPipelineCache);

  #define tu_CreatePipelineCache_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreatePipelineCache<X>(VkDevice device, const VkPipelineCacheCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineCache* pPipelineCache);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyPipelineCache(VkDevice device, VkPipelineCache pipelineCache, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyPipelineCache(VkDevice device, VkPipelineCache pipelineCache, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyPipelineCache(VkDevice device, VkPipelineCache pipelineCache, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyPipelineCache_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyPipelineCache<X>(VkDevice device, VkPipelineCache pipelineCache, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPipelineCacheData(VkDevice device, VkPipelineCache pipelineCache, size_t* pDataSize, void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetPipelineCacheData(VkDevice device, VkPipelineCache pipelineCache, size_t* pDataSize, void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPipelineCacheData(VkDevice device, VkPipelineCache pipelineCache, size_t* pDataSize, void* pData);

  #define tu_GetPipelineCacheData_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetPipelineCacheData<X>(VkDevice device, VkPipelineCache pipelineCache, size_t* pDataSize, void* pData);

  VKAPI_ATTR VkResult VKAPI_CALL tu_MergePipelineCaches(VkDevice device, VkPipelineCache dstCache, uint32_t srcCacheCount, const VkPipelineCache* pSrcCaches) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_MergePipelineCaches(VkDevice device, VkPipelineCache dstCache, uint32_t srcCacheCount, const VkPipelineCache* pSrcCaches) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_MergePipelineCaches(VkDevice device, VkPipelineCache dstCache, uint32_t srcCacheCount, const VkPipelineCache* pSrcCaches);

  #define tu_MergePipelineCaches_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_MergePipelineCaches<X>(VkDevice device, VkPipelineCache dstCache, uint32_t srcCacheCount, const VkPipelineCache* pSrcCaches);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreatePipelineBinariesKHR(VkDevice device, const VkPipelineBinaryCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineBinaryHandlesInfoKHR* pBinaries) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreatePipelineBinariesKHR(VkDevice device, const VkPipelineBinaryCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineBinaryHandlesInfoKHR* pBinaries) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreatePipelineBinariesKHR(VkDevice device, const VkPipelineBinaryCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineBinaryHandlesInfoKHR* pBinaries);

  #define tu_CreatePipelineBinariesKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreatePipelineBinariesKHR<X>(VkDevice device, const VkPipelineBinaryCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineBinaryHandlesInfoKHR* pBinaries);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyPipelineBinaryKHR(VkDevice device, VkPipelineBinaryKHR pipelineBinary, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyPipelineBinaryKHR(VkDevice device, VkPipelineBinaryKHR pipelineBinary, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyPipelineBinaryKHR(VkDevice device, VkPipelineBinaryKHR pipelineBinary, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyPipelineBinaryKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyPipelineBinaryKHR<X>(VkDevice device, VkPipelineBinaryKHR pipelineBinary, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPipelineKeyKHR(VkDevice device, const VkPipelineCreateInfoKHR* pPipelineCreateInfo, VkPipelineBinaryKeyKHR* pPipelineKey) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetPipelineKeyKHR(VkDevice device, const VkPipelineCreateInfoKHR* pPipelineCreateInfo, VkPipelineBinaryKeyKHR* pPipelineKey) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPipelineKeyKHR(VkDevice device, const VkPipelineCreateInfoKHR* pPipelineCreateInfo, VkPipelineBinaryKeyKHR* pPipelineKey);

  #define tu_GetPipelineKeyKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetPipelineKeyKHR<X>(VkDevice device, const VkPipelineCreateInfoKHR* pPipelineCreateInfo, VkPipelineBinaryKeyKHR* pPipelineKey);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPipelineBinaryDataKHR(VkDevice device, const VkPipelineBinaryDataInfoKHR* pInfo, VkPipelineBinaryKeyKHR* pPipelineBinaryKey, size_t* pPipelineBinaryDataSize, void* pPipelineBinaryData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetPipelineBinaryDataKHR(VkDevice device, const VkPipelineBinaryDataInfoKHR* pInfo, VkPipelineBinaryKeyKHR* pPipelineBinaryKey, size_t* pPipelineBinaryDataSize, void* pPipelineBinaryData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPipelineBinaryDataKHR(VkDevice device, const VkPipelineBinaryDataInfoKHR* pInfo, VkPipelineBinaryKeyKHR* pPipelineBinaryKey, size_t* pPipelineBinaryDataSize, void* pPipelineBinaryData);

  #define tu_GetPipelineBinaryDataKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetPipelineBinaryDataKHR<X>(VkDevice device, const VkPipelineBinaryDataInfoKHR* pInfo, VkPipelineBinaryKeyKHR* pPipelineBinaryKey, size_t* pPipelineBinaryDataSize, void* pPipelineBinaryData);

  VKAPI_ATTR VkResult VKAPI_CALL tu_ReleaseCapturedPipelineDataKHR(VkDevice device, const VkReleaseCapturedPipelineDataInfoKHR* pInfo, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_ReleaseCapturedPipelineDataKHR(VkDevice device, const VkReleaseCapturedPipelineDataInfoKHR* pInfo, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_ReleaseCapturedPipelineDataKHR(VkDevice device, const VkReleaseCapturedPipelineDataInfoKHR* pInfo, const VkAllocationCallbacks* pAllocator);

  #define tu_ReleaseCapturedPipelineDataKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_ReleaseCapturedPipelineDataKHR<X>(VkDevice device, const VkReleaseCapturedPipelineDataInfoKHR* pInfo, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateGraphicsPipelines(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkGraphicsPipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateGraphicsPipelines(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkGraphicsPipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateGraphicsPipelines(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkGraphicsPipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines);

  #define tu_CreateGraphicsPipelines_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateGraphicsPipelines<X>(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkGraphicsPipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateComputePipelines(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkComputePipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateComputePipelines(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkComputePipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateComputePipelines(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkComputePipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines);

  #define tu_CreateComputePipelines_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateComputePipelines<X>(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkComputePipelineCreateInfo* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI(VkDevice device, VkRenderPass renderpass, VkExtent2D* pMaxWorkgroupSize) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI(VkDevice device, VkRenderPass renderpass, VkExtent2D* pMaxWorkgroupSize) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI(VkDevice device, VkRenderPass renderpass, VkExtent2D* pMaxWorkgroupSize);

  #define tu_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI<X>(VkDevice device, VkRenderPass renderpass, VkExtent2D* pMaxWorkgroupSize);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyPipeline(VkDevice device, VkPipeline pipeline, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyPipeline(VkDevice device, VkPipeline pipeline, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyPipeline(VkDevice device, VkPipeline pipeline, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyPipeline_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyPipeline<X>(VkDevice device, VkPipeline pipeline, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreatePipelineLayout(VkDevice device, const VkPipelineLayoutCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineLayout* pPipelineLayout) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreatePipelineLayout(VkDevice device, const VkPipelineLayoutCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineLayout* pPipelineLayout) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreatePipelineLayout(VkDevice device, const VkPipelineLayoutCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineLayout* pPipelineLayout);

  #define tu_CreatePipelineLayout_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreatePipelineLayout<X>(VkDevice device, const VkPipelineLayoutCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPipelineLayout* pPipelineLayout);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyPipelineLayout(VkDevice device, VkPipelineLayout pipelineLayout, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyPipelineLayout(VkDevice device, VkPipelineLayout pipelineLayout, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyPipelineLayout(VkDevice device, VkPipelineLayout pipelineLayout, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyPipelineLayout_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyPipelineLayout<X>(VkDevice device, VkPipelineLayout pipelineLayout, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateSampler(VkDevice device, const VkSamplerCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSampler* pSampler) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateSampler(VkDevice device, const VkSamplerCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSampler* pSampler) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateSampler(VkDevice device, const VkSamplerCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSampler* pSampler);

  #define tu_CreateSampler_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateSampler<X>(VkDevice device, const VkSamplerCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSampler* pSampler);

  VKAPI_ATTR void VKAPI_CALL tu_DestroySampler(VkDevice device, VkSampler sampler, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroySampler(VkDevice device, VkSampler sampler, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroySampler(VkDevice device, VkSampler sampler, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroySampler_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroySampler<X>(VkDevice device, VkSampler sampler, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateDescriptorSetLayout(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorSetLayout* pSetLayout) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateDescriptorSetLayout(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorSetLayout* pSetLayout) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateDescriptorSetLayout(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorSetLayout* pSetLayout);

  #define tu_CreateDescriptorSetLayout_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateDescriptorSetLayout<X>(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorSetLayout* pSetLayout);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyDescriptorSetLayout(VkDevice device, VkDescriptorSetLayout descriptorSetLayout, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyDescriptorSetLayout(VkDevice device, VkDescriptorSetLayout descriptorSetLayout, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyDescriptorSetLayout(VkDevice device, VkDescriptorSetLayout descriptorSetLayout, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyDescriptorSetLayout_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyDescriptorSetLayout<X>(VkDevice device, VkDescriptorSetLayout descriptorSetLayout, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateDescriptorPool(VkDevice device, const VkDescriptorPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorPool* pDescriptorPool) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateDescriptorPool(VkDevice device, const VkDescriptorPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorPool* pDescriptorPool) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateDescriptorPool(VkDevice device, const VkDescriptorPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorPool* pDescriptorPool);

  #define tu_CreateDescriptorPool_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateDescriptorPool<X>(VkDevice device, const VkDescriptorPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorPool* pDescriptorPool);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyDescriptorPool(VkDevice device, VkDescriptorPool descriptorPool, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyDescriptorPool(VkDevice device, VkDescriptorPool descriptorPool, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyDescriptorPool(VkDevice device, VkDescriptorPool descriptorPool, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyDescriptorPool_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyDescriptorPool<X>(VkDevice device, VkDescriptorPool descriptorPool, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR VkResult VKAPI_CALL tu_ResetDescriptorPool(VkDevice device, VkDescriptorPool descriptorPool, VkDescriptorPoolResetFlags flags) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_ResetDescriptorPool(VkDevice device, VkDescriptorPool descriptorPool, VkDescriptorPoolResetFlags flags) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_ResetDescriptorPool(VkDevice device, VkDescriptorPool descriptorPool, VkDescriptorPoolResetFlags flags);

  #define tu_ResetDescriptorPool_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_ResetDescriptorPool<X>(VkDevice device, VkDescriptorPool descriptorPool, VkDescriptorPoolResetFlags flags);

  VKAPI_ATTR VkResult VKAPI_CALL tu_AllocateDescriptorSets(VkDevice device, const VkDescriptorSetAllocateInfo* pAllocateInfo, VkDescriptorSet* pDescriptorSets) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_AllocateDescriptorSets(VkDevice device, const VkDescriptorSetAllocateInfo* pAllocateInfo, VkDescriptorSet* pDescriptorSets) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_AllocateDescriptorSets(VkDevice device, const VkDescriptorSetAllocateInfo* pAllocateInfo, VkDescriptorSet* pDescriptorSets);

  #define tu_AllocateDescriptorSets_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_AllocateDescriptorSets<X>(VkDevice device, const VkDescriptorSetAllocateInfo* pAllocateInfo, VkDescriptorSet* pDescriptorSets);

  VKAPI_ATTR VkResult VKAPI_CALL tu_FreeDescriptorSets(VkDevice device, VkDescriptorPool descriptorPool, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_FreeDescriptorSets(VkDevice device, VkDescriptorPool descriptorPool, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_FreeDescriptorSets(VkDevice device, VkDescriptorPool descriptorPool, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets);

  #define tu_FreeDescriptorSets_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_FreeDescriptorSets<X>(VkDevice device, VkDescriptorPool descriptorPool, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets);

  VKAPI_ATTR void VKAPI_CALL tu_UpdateDescriptorSets(VkDevice device, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites, uint32_t descriptorCopyCount, const VkCopyDescriptorSet* pDescriptorCopies) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_UpdateDescriptorSets(VkDevice device, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites, uint32_t descriptorCopyCount, const VkCopyDescriptorSet* pDescriptorCopies) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_UpdateDescriptorSets(VkDevice device, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites, uint32_t descriptorCopyCount, const VkCopyDescriptorSet* pDescriptorCopies);

  #define tu_UpdateDescriptorSets_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_UpdateDescriptorSets<X>(VkDevice device, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites, uint32_t descriptorCopyCount, const VkCopyDescriptorSet* pDescriptorCopies);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateFramebuffer(VkDevice device, const VkFramebufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFramebuffer* pFramebuffer) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateFramebuffer(VkDevice device, const VkFramebufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFramebuffer* pFramebuffer) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateFramebuffer(VkDevice device, const VkFramebufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFramebuffer* pFramebuffer);

  #define tu_CreateFramebuffer_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateFramebuffer<X>(VkDevice device, const VkFramebufferCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkFramebuffer* pFramebuffer);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyFramebuffer(VkDevice device, VkFramebuffer framebuffer, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyFramebuffer(VkDevice device, VkFramebuffer framebuffer, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyFramebuffer(VkDevice device, VkFramebuffer framebuffer, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyFramebuffer_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyFramebuffer<X>(VkDevice device, VkFramebuffer framebuffer, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateRenderPass(VkDevice device, const VkRenderPassCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateRenderPass(VkDevice device, const VkRenderPassCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateRenderPass(VkDevice device, const VkRenderPassCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass);

  #define tu_CreateRenderPass_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateRenderPass<X>(VkDevice device, const VkRenderPassCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyRenderPass(VkDevice device, VkRenderPass renderPass, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyRenderPass(VkDevice device, VkRenderPass renderPass, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyRenderPass(VkDevice device, VkRenderPass renderPass, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyRenderPass_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyRenderPass<X>(VkDevice device, VkRenderPass renderPass, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR void VKAPI_CALL tu_GetRenderAreaGranularity(VkDevice device, VkRenderPass renderPass, VkExtent2D* pGranularity) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetRenderAreaGranularity(VkDevice device, VkRenderPass renderPass, VkExtent2D* pGranularity) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetRenderAreaGranularity(VkDevice device, VkRenderPass renderPass, VkExtent2D* pGranularity);

  #define tu_GetRenderAreaGranularity_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetRenderAreaGranularity<X>(VkDevice device, VkRenderPass renderPass, VkExtent2D* pGranularity);

  VKAPI_ATTR void VKAPI_CALL tu_GetRenderingAreaGranularity(VkDevice device, const VkRenderingAreaInfo* pRenderingAreaInfo, VkExtent2D* pGranularity) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetRenderingAreaGranularity(VkDevice device, const VkRenderingAreaInfo* pRenderingAreaInfo, VkExtent2D* pGranularity) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetRenderingAreaGranularity(VkDevice device, const VkRenderingAreaInfo* pRenderingAreaInfo, VkExtent2D* pGranularity);

  #define tu_GetRenderingAreaGranularity_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetRenderingAreaGranularity<X>(VkDevice device, const VkRenderingAreaInfo* pRenderingAreaInfo, VkExtent2D* pGranularity);

  VKAPI_ATTR void VKAPI_CALL tu_GetRenderingAreaGranularityKHR(VkDevice device, const VkRenderingAreaInfo* pRenderingAreaInfo, VkExtent2D* pGranularity) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetRenderingAreaGranularityKHR(VkDevice device, const VkRenderingAreaInfo* pRenderingAreaInfo, VkExtent2D* pGranularity) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetRenderingAreaGranularityKHR(VkDevice device, const VkRenderingAreaInfo* pRenderingAreaInfo, VkExtent2D* pGranularity);

  #define tu_GetRenderingAreaGranularityKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetRenderingAreaGranularityKHR<X>(VkDevice device, const VkRenderingAreaInfo* pRenderingAreaInfo, VkExtent2D* pGranularity);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateCommandPool(VkDevice device, const VkCommandPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCommandPool* pCommandPool) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateCommandPool(VkDevice device, const VkCommandPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCommandPool* pCommandPool) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateCommandPool(VkDevice device, const VkCommandPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCommandPool* pCommandPool);

  #define tu_CreateCommandPool_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateCommandPool<X>(VkDevice device, const VkCommandPoolCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCommandPool* pCommandPool);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyCommandPool(VkDevice device, VkCommandPool commandPool, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyCommandPool(VkDevice device, VkCommandPool commandPool, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyCommandPool(VkDevice device, VkCommandPool commandPool, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyCommandPool_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyCommandPool<X>(VkDevice device, VkCommandPool commandPool, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR VkResult VKAPI_CALL tu_ResetCommandPool(VkDevice device, VkCommandPool commandPool, VkCommandPoolResetFlags flags) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_ResetCommandPool(VkDevice device, VkCommandPool commandPool, VkCommandPoolResetFlags flags) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_ResetCommandPool(VkDevice device, VkCommandPool commandPool, VkCommandPoolResetFlags flags);

  #define tu_ResetCommandPool_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_ResetCommandPool<X>(VkDevice device, VkCommandPool commandPool, VkCommandPoolResetFlags flags);

  VKAPI_ATTR VkResult VKAPI_CALL tu_AllocateCommandBuffers(VkDevice device, const VkCommandBufferAllocateInfo* pAllocateInfo, VkCommandBuffer* pCommandBuffers) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_AllocateCommandBuffers(VkDevice device, const VkCommandBufferAllocateInfo* pAllocateInfo, VkCommandBuffer* pCommandBuffers) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_AllocateCommandBuffers(VkDevice device, const VkCommandBufferAllocateInfo* pAllocateInfo, VkCommandBuffer* pCommandBuffers);

  #define tu_AllocateCommandBuffers_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_AllocateCommandBuffers<X>(VkDevice device, const VkCommandBufferAllocateInfo* pAllocateInfo, VkCommandBuffer* pCommandBuffers);

  VKAPI_ATTR void VKAPI_CALL tu_FreeCommandBuffers(VkDevice device, VkCommandPool commandPool, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_FreeCommandBuffers(VkDevice device, VkCommandPool commandPool, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_FreeCommandBuffers(VkDevice device, VkCommandPool commandPool, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers);

  #define tu_FreeCommandBuffers_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_FreeCommandBuffers<X>(VkDevice device, VkCommandPool commandPool, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers);

  VKAPI_ATTR VkResult VKAPI_CALL tu_BeginCommandBuffer(VkCommandBuffer commandBuffer, const VkCommandBufferBeginInfo* pBeginInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_BeginCommandBuffer(VkCommandBuffer commandBuffer, const VkCommandBufferBeginInfo* pBeginInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_BeginCommandBuffer(VkCommandBuffer commandBuffer, const VkCommandBufferBeginInfo* pBeginInfo);

  #define tu_BeginCommandBuffer_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_BeginCommandBuffer<X>(VkCommandBuffer commandBuffer, const VkCommandBufferBeginInfo* pBeginInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_EndCommandBuffer(VkCommandBuffer commandBuffer) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_EndCommandBuffer(VkCommandBuffer commandBuffer) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_EndCommandBuffer(VkCommandBuffer commandBuffer);

  #define tu_EndCommandBuffer_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_EndCommandBuffer<X>(VkCommandBuffer commandBuffer);

  VKAPI_ATTR VkResult VKAPI_CALL tu_ResetCommandBuffer(VkCommandBuffer commandBuffer, VkCommandBufferResetFlags flags) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_ResetCommandBuffer(VkCommandBuffer commandBuffer, VkCommandBufferResetFlags flags) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_ResetCommandBuffer(VkCommandBuffer commandBuffer, VkCommandBufferResetFlags flags);

  #define tu_ResetCommandBuffer_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_ResetCommandBuffer<X>(VkCommandBuffer commandBuffer, VkCommandBufferResetFlags flags);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBindPipeline(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBindPipeline(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBindPipeline(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline);

  #define tu_CmdBindPipeline_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBindPipeline<X>(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetAttachmentFeedbackLoopEnableEXT(VkCommandBuffer commandBuffer, VkImageAspectFlags aspectMask) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetAttachmentFeedbackLoopEnableEXT(VkCommandBuffer commandBuffer, VkImageAspectFlags aspectMask) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetAttachmentFeedbackLoopEnableEXT(VkCommandBuffer commandBuffer, VkImageAspectFlags aspectMask);

  #define tu_CmdSetAttachmentFeedbackLoopEnableEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetAttachmentFeedbackLoopEnableEXT<X>(VkCommandBuffer commandBuffer, VkImageAspectFlags aspectMask);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetViewport(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewport* pViewports) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetViewport(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewport* pViewports) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetViewport(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewport* pViewports);

  #define tu_CmdSetViewport_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetViewport<X>(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewport* pViewports);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetScissor(VkCommandBuffer commandBuffer, uint32_t firstScissor, uint32_t scissorCount, const VkRect2D* pScissors) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetScissor(VkCommandBuffer commandBuffer, uint32_t firstScissor, uint32_t scissorCount, const VkRect2D* pScissors) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetScissor(VkCommandBuffer commandBuffer, uint32_t firstScissor, uint32_t scissorCount, const VkRect2D* pScissors);

  #define tu_CmdSetScissor_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetScissor<X>(VkCommandBuffer commandBuffer, uint32_t firstScissor, uint32_t scissorCount, const VkRect2D* pScissors);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetLineWidth(VkCommandBuffer commandBuffer, float lineWidth) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetLineWidth(VkCommandBuffer commandBuffer, float lineWidth) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetLineWidth(VkCommandBuffer commandBuffer, float lineWidth);

  #define tu_CmdSetLineWidth_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetLineWidth<X>(VkCommandBuffer commandBuffer, float lineWidth);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthBias(VkCommandBuffer commandBuffer, float depthBiasConstantFactor, float depthBiasClamp, float depthBiasSlopeFactor) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetDepthBias(VkCommandBuffer commandBuffer, float depthBiasConstantFactor, float depthBiasClamp, float depthBiasSlopeFactor) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthBias(VkCommandBuffer commandBuffer, float depthBiasConstantFactor, float depthBiasClamp, float depthBiasSlopeFactor);

  #define tu_CmdSetDepthBias_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthBias<X>(VkCommandBuffer commandBuffer, float depthBiasConstantFactor, float depthBiasClamp, float depthBiasSlopeFactor);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetBlendConstants(VkCommandBuffer commandBuffer, const float blendConstants[4]) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetBlendConstants(VkCommandBuffer commandBuffer, const float blendConstants[4]) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetBlendConstants(VkCommandBuffer commandBuffer, const float blendConstants[4]);

  #define tu_CmdSetBlendConstants_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetBlendConstants<X>(VkCommandBuffer commandBuffer, const float blendConstants[4]);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthBounds(VkCommandBuffer commandBuffer, float minDepthBounds, float maxDepthBounds) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetDepthBounds(VkCommandBuffer commandBuffer, float minDepthBounds, float maxDepthBounds) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthBounds(VkCommandBuffer commandBuffer, float minDepthBounds, float maxDepthBounds);

  #define tu_CmdSetDepthBounds_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthBounds<X>(VkCommandBuffer commandBuffer, float minDepthBounds, float maxDepthBounds);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetStencilCompareMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t compareMask) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetStencilCompareMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t compareMask) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetStencilCompareMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t compareMask);

  #define tu_CmdSetStencilCompareMask_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetStencilCompareMask<X>(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t compareMask);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetStencilWriteMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t writeMask) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetStencilWriteMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t writeMask) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetStencilWriteMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t writeMask);

  #define tu_CmdSetStencilWriteMask_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetStencilWriteMask<X>(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t writeMask);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetStencilReference(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t reference) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetStencilReference(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t reference) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetStencilReference(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t reference);

  #define tu_CmdSetStencilReference_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetStencilReference<X>(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t reference);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBindDescriptorSets(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets, uint32_t dynamicOffsetCount, const uint32_t* pDynamicOffsets) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBindDescriptorSets(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets, uint32_t dynamicOffsetCount, const uint32_t* pDynamicOffsets) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBindDescriptorSets(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets, uint32_t dynamicOffsetCount, const uint32_t* pDynamicOffsets);

  #define tu_CmdBindDescriptorSets_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBindDescriptorSets<X>(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t descriptorSetCount, const VkDescriptorSet* pDescriptorSets, uint32_t dynamicOffsetCount, const uint32_t* pDynamicOffsets);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBindIndexBuffer(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkIndexType indexType) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBindIndexBuffer(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkIndexType indexType) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBindIndexBuffer(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkIndexType indexType);

  #define tu_CmdBindIndexBuffer_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBindIndexBuffer<X>(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkIndexType indexType);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBindVertexBuffers(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBindVertexBuffers(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBindVertexBuffers(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets);

  #define tu_CmdBindVertexBuffers_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBindVertexBuffers<X>(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets);

  VKAPI_ATTR void VKAPI_CALL tu_CmdDraw(VkCommandBuffer commandBuffer, uint32_t vertexCount, uint32_t instanceCount, uint32_t firstVertex, uint32_t firstInstance) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDraw(VkCommandBuffer commandBuffer, uint32_t vertexCount, uint32_t instanceCount, uint32_t firstVertex, uint32_t firstInstance) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDraw(VkCommandBuffer commandBuffer, uint32_t vertexCount, uint32_t instanceCount, uint32_t firstVertex, uint32_t firstInstance);

  #define tu_CmdDraw_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDraw<X>(VkCommandBuffer commandBuffer, uint32_t vertexCount, uint32_t instanceCount, uint32_t firstVertex, uint32_t firstInstance);

  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawIndexed(VkCommandBuffer commandBuffer, uint32_t indexCount, uint32_t instanceCount, uint32_t firstIndex, int32_t vertexOffset, uint32_t firstInstance) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDrawIndexed(VkCommandBuffer commandBuffer, uint32_t indexCount, uint32_t instanceCount, uint32_t firstIndex, int32_t vertexOffset, uint32_t firstInstance) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawIndexed(VkCommandBuffer commandBuffer, uint32_t indexCount, uint32_t instanceCount, uint32_t firstIndex, int32_t vertexOffset, uint32_t firstInstance);

  #define tu_CmdDrawIndexed_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDrawIndexed<X>(VkCommandBuffer commandBuffer, uint32_t indexCount, uint32_t instanceCount, uint32_t firstIndex, int32_t vertexOffset, uint32_t firstInstance);

  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawMultiEXT(VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawInfoEXT* pVertexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDrawMultiEXT(VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawInfoEXT* pVertexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawMultiEXT(VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawInfoEXT* pVertexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride);

  #define tu_CmdDrawMultiEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDrawMultiEXT<X>(VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawInfoEXT* pVertexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride);

  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawMultiIndexedEXT(VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawIndexedInfoEXT* pIndexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride, const int32_t* pVertexOffset) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDrawMultiIndexedEXT(VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawIndexedInfoEXT* pIndexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride, const int32_t* pVertexOffset) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawMultiIndexedEXT(VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawIndexedInfoEXT* pIndexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride, const int32_t* pVertexOffset);

  #define tu_CmdDrawMultiIndexedEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDrawMultiIndexedEXT<X>(VkCommandBuffer commandBuffer, uint32_t drawCount, const VkMultiDrawIndexedInfoEXT* pIndexInfo, uint32_t instanceCount, uint32_t firstInstance, uint32_t stride, const int32_t* pVertexOffset);

  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDrawIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride);

  #define tu_CmdDrawIndirect_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDrawIndirect<X>(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride);

  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawIndexedIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDrawIndexedIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawIndexedIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride);

  #define tu_CmdDrawIndexedIndirect_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDrawIndexedIndirect<X>(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride);

  VKAPI_ATTR void VKAPI_CALL tu_CmdDispatch(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDispatch(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDispatch(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ);

  #define tu_CmdDispatch_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDispatch<X>(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ);

  VKAPI_ATTR void VKAPI_CALL tu_CmdDispatchIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDispatchIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDispatchIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset);

  #define tu_CmdDispatchIndirect_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDispatchIndirect<X>(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSubpassShadingHUAWEI(VkCommandBuffer commandBuffer) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSubpassShadingHUAWEI(VkCommandBuffer commandBuffer) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSubpassShadingHUAWEI(VkCommandBuffer commandBuffer);

  #define tu_CmdSubpassShadingHUAWEI_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSubpassShadingHUAWEI<X>(VkCommandBuffer commandBuffer);

  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawClusterHUAWEI(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDrawClusterHUAWEI(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawClusterHUAWEI(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ);

  #define tu_CmdDrawClusterHUAWEI_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDrawClusterHUAWEI<X>(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ);

  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawClusterIndirectHUAWEI(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDrawClusterIndirectHUAWEI(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawClusterIndirectHUAWEI(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset);

  #define tu_CmdDrawClusterIndirectHUAWEI_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDrawClusterIndirectHUAWEI<X>(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset);

  VKAPI_ATTR void VKAPI_CALL tu_CmdUpdatePipelineIndirectBufferNV(VkCommandBuffer commandBuffer, VkPipelineBindPoint           pipelineBindPoint, VkPipeline                    pipeline) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdUpdatePipelineIndirectBufferNV(VkCommandBuffer commandBuffer, VkPipelineBindPoint           pipelineBindPoint, VkPipeline                    pipeline) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdUpdatePipelineIndirectBufferNV(VkCommandBuffer commandBuffer, VkPipelineBindPoint           pipelineBindPoint, VkPipeline                    pipeline);

  #define tu_CmdUpdatePipelineIndirectBufferNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdUpdatePipelineIndirectBufferNV<X>(VkCommandBuffer commandBuffer, VkPipelineBindPoint           pipelineBindPoint, VkPipeline                    pipeline);

  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyBuffer(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferCopy* pRegions) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdCopyBuffer(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferCopy* pRegions) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyBuffer(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferCopy* pRegions);

  #define tu_CmdCopyBuffer_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdCopyBuffer<X>(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferCopy* pRegions);

  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageCopy* pRegions) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdCopyImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageCopy* pRegions) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageCopy* pRegions);

  #define tu_CmdCopyImage_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdCopyImage<X>(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageCopy* pRegions);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBlitImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageBlit* pRegions, VkFilter filter) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBlitImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageBlit* pRegions, VkFilter filter) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBlitImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageBlit* pRegions, VkFilter filter);

  #define tu_CmdBlitImage_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBlitImage<X>(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageBlit* pRegions, VkFilter filter);

  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyBufferToImage(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkBufferImageCopy* pRegions) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdCopyBufferToImage(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkBufferImageCopy* pRegions) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyBufferToImage(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkBufferImageCopy* pRegions);

  #define tu_CmdCopyBufferToImage_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdCopyBufferToImage<X>(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkBufferImageCopy* pRegions);

  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyImageToBuffer(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferImageCopy* pRegions) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdCopyImageToBuffer(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferImageCopy* pRegions) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyImageToBuffer(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferImageCopy* pRegions);

  #define tu_CmdCopyImageToBuffer_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdCopyImageToBuffer<X>(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkBuffer dstBuffer, uint32_t regionCount, const VkBufferImageCopy* pRegions);

  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyMemoryIndirectNV(VkCommandBuffer commandBuffer, VkDeviceAddress copyBufferAddress, uint32_t copyCount, uint32_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdCopyMemoryIndirectNV(VkCommandBuffer commandBuffer, VkDeviceAddress copyBufferAddress, uint32_t copyCount, uint32_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyMemoryIndirectNV(VkCommandBuffer commandBuffer, VkDeviceAddress copyBufferAddress, uint32_t copyCount, uint32_t stride);

  #define tu_CmdCopyMemoryIndirectNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdCopyMemoryIndirectNV<X>(VkCommandBuffer commandBuffer, VkDeviceAddress copyBufferAddress, uint32_t copyCount, uint32_t stride);

  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyMemoryIndirectKHR(VkCommandBuffer commandBuffer, const VkCopyMemoryIndirectInfoKHR* pCopyMemoryIndirectInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdCopyMemoryIndirectKHR(VkCommandBuffer commandBuffer, const VkCopyMemoryIndirectInfoKHR* pCopyMemoryIndirectInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyMemoryIndirectKHR(VkCommandBuffer commandBuffer, const VkCopyMemoryIndirectInfoKHR* pCopyMemoryIndirectInfo);

  #define tu_CmdCopyMemoryIndirectKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdCopyMemoryIndirectKHR<X>(VkCommandBuffer commandBuffer, const VkCopyMemoryIndirectInfoKHR* pCopyMemoryIndirectInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyMemoryToImageIndirectNV(VkCommandBuffer commandBuffer, VkDeviceAddress copyBufferAddress, uint32_t copyCount, uint32_t stride, VkImage dstImage, VkImageLayout dstImageLayout, const VkImageSubresourceLayers* pImageSubresources) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdCopyMemoryToImageIndirectNV(VkCommandBuffer commandBuffer, VkDeviceAddress copyBufferAddress, uint32_t copyCount, uint32_t stride, VkImage dstImage, VkImageLayout dstImageLayout, const VkImageSubresourceLayers* pImageSubresources) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyMemoryToImageIndirectNV(VkCommandBuffer commandBuffer, VkDeviceAddress copyBufferAddress, uint32_t copyCount, uint32_t stride, VkImage dstImage, VkImageLayout dstImageLayout, const VkImageSubresourceLayers* pImageSubresources);

  #define tu_CmdCopyMemoryToImageIndirectNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdCopyMemoryToImageIndirectNV<X>(VkCommandBuffer commandBuffer, VkDeviceAddress copyBufferAddress, uint32_t copyCount, uint32_t stride, VkImage dstImage, VkImageLayout dstImageLayout, const VkImageSubresourceLayers* pImageSubresources);

  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyMemoryToImageIndirectKHR(VkCommandBuffer commandBuffer, const VkCopyMemoryToImageIndirectInfoKHR* pCopyMemoryToImageIndirectInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdCopyMemoryToImageIndirectKHR(VkCommandBuffer commandBuffer, const VkCopyMemoryToImageIndirectInfoKHR* pCopyMemoryToImageIndirectInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyMemoryToImageIndirectKHR(VkCommandBuffer commandBuffer, const VkCopyMemoryToImageIndirectInfoKHR* pCopyMemoryToImageIndirectInfo);

  #define tu_CmdCopyMemoryToImageIndirectKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdCopyMemoryToImageIndirectKHR<X>(VkCommandBuffer commandBuffer, const VkCopyMemoryToImageIndirectInfoKHR* pCopyMemoryToImageIndirectInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdUpdateBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize dataSize, const void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdUpdateBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize dataSize, const void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdUpdateBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize dataSize, const void* pData);

  #define tu_CmdUpdateBuffer_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdUpdateBuffer<X>(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize dataSize, const void* pData);

  VKAPI_ATTR void VKAPI_CALL tu_CmdFillBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize size, uint32_t data) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdFillBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize size, uint32_t data) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdFillBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize size, uint32_t data);

  #define tu_CmdFillBuffer_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdFillBuffer<X>(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize size, uint32_t data);

  VKAPI_ATTR void VKAPI_CALL tu_CmdClearColorImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearColorValue* pColor, uint32_t rangeCount, const VkImageSubresourceRange* pRanges) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdClearColorImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearColorValue* pColor, uint32_t rangeCount, const VkImageSubresourceRange* pRanges) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdClearColorImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearColorValue* pColor, uint32_t rangeCount, const VkImageSubresourceRange* pRanges);

  #define tu_CmdClearColorImage_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdClearColorImage<X>(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearColorValue* pColor, uint32_t rangeCount, const VkImageSubresourceRange* pRanges);

  VKAPI_ATTR void VKAPI_CALL tu_CmdClearDepthStencilImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearDepthStencilValue* pDepthStencil, uint32_t rangeCount, const VkImageSubresourceRange* pRanges) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdClearDepthStencilImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearDepthStencilValue* pDepthStencil, uint32_t rangeCount, const VkImageSubresourceRange* pRanges) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdClearDepthStencilImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearDepthStencilValue* pDepthStencil, uint32_t rangeCount, const VkImageSubresourceRange* pRanges);

  #define tu_CmdClearDepthStencilImage_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdClearDepthStencilImage<X>(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout, const VkClearDepthStencilValue* pDepthStencil, uint32_t rangeCount, const VkImageSubresourceRange* pRanges);

  VKAPI_ATTR void VKAPI_CALL tu_CmdClearAttachments(VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkClearAttachment* pAttachments, uint32_t rectCount, const VkClearRect* pRects) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdClearAttachments(VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkClearAttachment* pAttachments, uint32_t rectCount, const VkClearRect* pRects) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdClearAttachments(VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkClearAttachment* pAttachments, uint32_t rectCount, const VkClearRect* pRects);

  #define tu_CmdClearAttachments_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdClearAttachments<X>(VkCommandBuffer commandBuffer, uint32_t attachmentCount, const VkClearAttachment* pAttachments, uint32_t rectCount, const VkClearRect* pRects);

  VKAPI_ATTR void VKAPI_CALL tu_CmdResolveImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageResolve* pRegions) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdResolveImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageResolve* pRegions) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdResolveImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageResolve* pRegions);

  #define tu_CmdResolveImage_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdResolveImage<X>(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout, VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount, const VkImageResolve* pRegions);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask);

  #define tu_CmdSetEvent_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetEvent<X>(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask);

  VKAPI_ATTR void VKAPI_CALL tu_CmdResetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdResetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdResetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask);

  #define tu_CmdResetEvent_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdResetEvent<X>(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask);

  VKAPI_ATTR void VKAPI_CALL tu_CmdWaitEvents(VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdWaitEvents(VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdWaitEvents(VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers);

  #define tu_CmdWaitEvents_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdWaitEvents<X>(VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers);

  VKAPI_ATTR void VKAPI_CALL tu_CmdPipelineBarrier(VkCommandBuffer commandBuffer, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, VkDependencyFlags dependencyFlags, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdPipelineBarrier(VkCommandBuffer commandBuffer, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, VkDependencyFlags dependencyFlags, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdPipelineBarrier(VkCommandBuffer commandBuffer, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, VkDependencyFlags dependencyFlags, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers);

  #define tu_CmdPipelineBarrier_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdPipelineBarrier<X>(VkCommandBuffer commandBuffer, VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask, VkDependencyFlags dependencyFlags, uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers, uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers, uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBeginQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBeginQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBeginQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags);

  #define tu_CmdBeginQuery_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBeginQuery<X>(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags);

  VKAPI_ATTR void VKAPI_CALL tu_CmdEndQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdEndQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdEndQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query);

  #define tu_CmdEndQuery_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdEndQuery<X>(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBeginConditionalRenderingEXT(VkCommandBuffer commandBuffer, const VkConditionalRenderingBeginInfoEXT* pConditionalRenderingBegin) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBeginConditionalRenderingEXT(VkCommandBuffer commandBuffer, const VkConditionalRenderingBeginInfoEXT* pConditionalRenderingBegin) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBeginConditionalRenderingEXT(VkCommandBuffer commandBuffer, const VkConditionalRenderingBeginInfoEXT* pConditionalRenderingBegin);

  #define tu_CmdBeginConditionalRenderingEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBeginConditionalRenderingEXT<X>(VkCommandBuffer commandBuffer, const VkConditionalRenderingBeginInfoEXT* pConditionalRenderingBegin);

  VKAPI_ATTR void VKAPI_CALL tu_CmdEndConditionalRenderingEXT(VkCommandBuffer commandBuffer) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdEndConditionalRenderingEXT(VkCommandBuffer commandBuffer) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdEndConditionalRenderingEXT(VkCommandBuffer commandBuffer);

  #define tu_CmdEndConditionalRenderingEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdEndConditionalRenderingEXT<X>(VkCommandBuffer commandBuffer);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBeginCustomResolveEXT(VkCommandBuffer commandBuffer, const VkBeginCustomResolveInfoEXT* pBeginCustomResolveInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBeginCustomResolveEXT(VkCommandBuffer commandBuffer, const VkBeginCustomResolveInfoEXT* pBeginCustomResolveInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBeginCustomResolveEXT(VkCommandBuffer commandBuffer, const VkBeginCustomResolveInfoEXT* pBeginCustomResolveInfo);

  #define tu_CmdBeginCustomResolveEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBeginCustomResolveEXT<X>(VkCommandBuffer commandBuffer, const VkBeginCustomResolveInfoEXT* pBeginCustomResolveInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdResetQueryPool(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdResetQueryPool(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdResetQueryPool(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount);

  #define tu_CmdResetQueryPool_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdResetQueryPool<X>(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount);

  VKAPI_ATTR void VKAPI_CALL tu_CmdWriteTimestamp(VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkQueryPool queryPool, uint32_t query) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdWriteTimestamp(VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkQueryPool queryPool, uint32_t query) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdWriteTimestamp(VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkQueryPool queryPool, uint32_t query);

  #define tu_CmdWriteTimestamp_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdWriteTimestamp<X>(VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkQueryPool queryPool, uint32_t query);

  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyQueryPoolResults(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize stride, VkQueryResultFlags flags) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdCopyQueryPoolResults(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize stride, VkQueryResultFlags flags) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyQueryPoolResults(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize stride, VkQueryResultFlags flags);

  #define tu_CmdCopyQueryPoolResults_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdCopyQueryPoolResults<X>(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount, VkBuffer dstBuffer, VkDeviceSize dstOffset, VkDeviceSize stride, VkQueryResultFlags flags);

  VKAPI_ATTR void VKAPI_CALL tu_CmdPushConstants(VkCommandBuffer commandBuffer, VkPipelineLayout layout, VkShaderStageFlags stageFlags, uint32_t offset, uint32_t size, const void* pValues) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdPushConstants(VkCommandBuffer commandBuffer, VkPipelineLayout layout, VkShaderStageFlags stageFlags, uint32_t offset, uint32_t size, const void* pValues) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdPushConstants(VkCommandBuffer commandBuffer, VkPipelineLayout layout, VkShaderStageFlags stageFlags, uint32_t offset, uint32_t size, const void* pValues);

  #define tu_CmdPushConstants_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdPushConstants<X>(VkCommandBuffer commandBuffer, VkPipelineLayout layout, VkShaderStageFlags stageFlags, uint32_t offset, uint32_t size, const void* pValues);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBeginRenderPass(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, VkSubpassContents contents) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBeginRenderPass(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, VkSubpassContents contents) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBeginRenderPass(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, VkSubpassContents contents);

  #define tu_CmdBeginRenderPass_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBeginRenderPass<X>(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin, VkSubpassContents contents);

  VKAPI_ATTR void VKAPI_CALL tu_CmdNextSubpass(VkCommandBuffer commandBuffer, VkSubpassContents contents) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdNextSubpass(VkCommandBuffer commandBuffer, VkSubpassContents contents) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdNextSubpass(VkCommandBuffer commandBuffer, VkSubpassContents contents);

  #define tu_CmdNextSubpass_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdNextSubpass<X>(VkCommandBuffer commandBuffer, VkSubpassContents contents);

  VKAPI_ATTR void VKAPI_CALL tu_CmdEndRenderPass(VkCommandBuffer commandBuffer) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdEndRenderPass(VkCommandBuffer commandBuffer) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdEndRenderPass(VkCommandBuffer commandBuffer);

  #define tu_CmdEndRenderPass_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdEndRenderPass<X>(VkCommandBuffer commandBuffer);

  VKAPI_ATTR void VKAPI_CALL tu_CmdExecuteCommands(VkCommandBuffer commandBuffer, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdExecuteCommands(VkCommandBuffer commandBuffer, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdExecuteCommands(VkCommandBuffer commandBuffer, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers);

  #define tu_CmdExecuteCommands_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdExecuteCommands<X>(VkCommandBuffer commandBuffer, uint32_t commandBufferCount, const VkCommandBuffer* pCommandBuffers);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateSharedSwapchainsKHR(VkDevice device, uint32_t swapchainCount, const VkSwapchainCreateInfoKHR* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkSwapchainKHR* pSwapchains) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateSharedSwapchainsKHR(VkDevice device, uint32_t swapchainCount, const VkSwapchainCreateInfoKHR* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkSwapchainKHR* pSwapchains) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateSharedSwapchainsKHR(VkDevice device, uint32_t swapchainCount, const VkSwapchainCreateInfoKHR* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkSwapchainKHR* pSwapchains);

  #define tu_CreateSharedSwapchainsKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateSharedSwapchainsKHR<X>(VkDevice device, uint32_t swapchainCount, const VkSwapchainCreateInfoKHR* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkSwapchainKHR* pSwapchains);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateSwapchainKHR(VkDevice device, const VkSwapchainCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSwapchainKHR* pSwapchain) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateSwapchainKHR(VkDevice device, const VkSwapchainCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSwapchainKHR* pSwapchain) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateSwapchainKHR(VkDevice device, const VkSwapchainCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSwapchainKHR* pSwapchain);

  #define tu_CreateSwapchainKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateSwapchainKHR<X>(VkDevice device, const VkSwapchainCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSwapchainKHR* pSwapchain);

  VKAPI_ATTR void VKAPI_CALL tu_DestroySwapchainKHR(VkDevice device, VkSwapchainKHR swapchain, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroySwapchainKHR(VkDevice device, VkSwapchainKHR swapchain, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroySwapchainKHR(VkDevice device, VkSwapchainKHR swapchain, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroySwapchainKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroySwapchainKHR<X>(VkDevice device, VkSwapchainKHR swapchain, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetSwapchainImagesKHR(VkDevice device, VkSwapchainKHR swapchain, uint32_t* pSwapchainImageCount, VkImage* pSwapchainImages) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetSwapchainImagesKHR(VkDevice device, VkSwapchainKHR swapchain, uint32_t* pSwapchainImageCount, VkImage* pSwapchainImages) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetSwapchainImagesKHR(VkDevice device, VkSwapchainKHR swapchain, uint32_t* pSwapchainImageCount, VkImage* pSwapchainImages);

  #define tu_GetSwapchainImagesKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetSwapchainImagesKHR<X>(VkDevice device, VkSwapchainKHR swapchain, uint32_t* pSwapchainImageCount, VkImage* pSwapchainImages);

  VKAPI_ATTR VkResult VKAPI_CALL tu_AcquireNextImageKHR(VkDevice device, VkSwapchainKHR swapchain, uint64_t timeout, VkSemaphore semaphore, VkFence fence, uint32_t* pImageIndex) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_AcquireNextImageKHR(VkDevice device, VkSwapchainKHR swapchain, uint64_t timeout, VkSemaphore semaphore, VkFence fence, uint32_t* pImageIndex) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_AcquireNextImageKHR(VkDevice device, VkSwapchainKHR swapchain, uint64_t timeout, VkSemaphore semaphore, VkFence fence, uint32_t* pImageIndex);

  #define tu_AcquireNextImageKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_AcquireNextImageKHR<X>(VkDevice device, VkSwapchainKHR swapchain, uint64_t timeout, VkSemaphore semaphore, VkFence fence, uint32_t* pImageIndex);

  VKAPI_ATTR VkResult VKAPI_CALL tu_QueuePresentKHR(VkQueue queue, const VkPresentInfoKHR* pPresentInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_QueuePresentKHR(VkQueue queue, const VkPresentInfoKHR* pPresentInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_QueuePresentKHR(VkQueue queue, const VkPresentInfoKHR* pPresentInfo);

  #define tu_QueuePresentKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_QueuePresentKHR<X>(VkQueue queue, const VkPresentInfoKHR* pPresentInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_DebugMarkerSetObjectNameEXT(VkDevice device, const VkDebugMarkerObjectNameInfoEXT* pNameInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_DebugMarkerSetObjectNameEXT(VkDevice device, const VkDebugMarkerObjectNameInfoEXT* pNameInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_DebugMarkerSetObjectNameEXT(VkDevice device, const VkDebugMarkerObjectNameInfoEXT* pNameInfo);

  #define tu_DebugMarkerSetObjectNameEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_DebugMarkerSetObjectNameEXT<X>(VkDevice device, const VkDebugMarkerObjectNameInfoEXT* pNameInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_DebugMarkerSetObjectTagEXT(VkDevice device, const VkDebugMarkerObjectTagInfoEXT* pTagInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_DebugMarkerSetObjectTagEXT(VkDevice device, const VkDebugMarkerObjectTagInfoEXT* pTagInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_DebugMarkerSetObjectTagEXT(VkDevice device, const VkDebugMarkerObjectTagInfoEXT* pTagInfo);

  #define tu_DebugMarkerSetObjectTagEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_DebugMarkerSetObjectTagEXT<X>(VkDevice device, const VkDebugMarkerObjectTagInfoEXT* pTagInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdDebugMarkerBeginEXT(VkCommandBuffer commandBuffer, const VkDebugMarkerMarkerInfoEXT* pMarkerInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDebugMarkerBeginEXT(VkCommandBuffer commandBuffer, const VkDebugMarkerMarkerInfoEXT* pMarkerInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDebugMarkerBeginEXT(VkCommandBuffer commandBuffer, const VkDebugMarkerMarkerInfoEXT* pMarkerInfo);

  #define tu_CmdDebugMarkerBeginEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDebugMarkerBeginEXT<X>(VkCommandBuffer commandBuffer, const VkDebugMarkerMarkerInfoEXT* pMarkerInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdDebugMarkerEndEXT(VkCommandBuffer commandBuffer) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDebugMarkerEndEXT(VkCommandBuffer commandBuffer) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDebugMarkerEndEXT(VkCommandBuffer commandBuffer);

  #define tu_CmdDebugMarkerEndEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDebugMarkerEndEXT<X>(VkCommandBuffer commandBuffer);

  VKAPI_ATTR void VKAPI_CALL tu_CmdDebugMarkerInsertEXT(VkCommandBuffer commandBuffer, const VkDebugMarkerMarkerInfoEXT* pMarkerInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDebugMarkerInsertEXT(VkCommandBuffer commandBuffer, const VkDebugMarkerMarkerInfoEXT* pMarkerInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDebugMarkerInsertEXT(VkCommandBuffer commandBuffer, const VkDebugMarkerMarkerInfoEXT* pMarkerInfo);

  #define tu_CmdDebugMarkerInsertEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDebugMarkerInsertEXT<X>(VkCommandBuffer commandBuffer, const VkDebugMarkerMarkerInfoEXT* pMarkerInfo);

#ifdef VK_USE_PLATFORM_WIN32_KHR
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryWin32HandleNV(VkDevice device, VkDeviceMemory memory, VkExternalMemoryHandleTypeFlagsNV handleType, HANDLE* pHandle) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetMemoryWin32HandleNV(VkDevice device, VkDeviceMemory memory, VkExternalMemoryHandleTypeFlagsNV handleType, HANDLE* pHandle) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryWin32HandleNV(VkDevice device, VkDeviceMemory memory, VkExternalMemoryHandleTypeFlagsNV handleType, HANDLE* pHandle);

  #define tu_GetMemoryWin32HandleNV_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryWin32HandleNV<X>(VkDevice device, VkDeviceMemory memory, VkExternalMemoryHandleTypeFlagsNV handleType, HANDLE* pHandle);

#endif // VK_USE_PLATFORM_WIN32_KHR
  VKAPI_ATTR void VKAPI_CALL tu_CmdExecuteGeneratedCommandsNV(VkCommandBuffer commandBuffer, VkBool32 isPreprocessed, const VkGeneratedCommandsInfoNV* pGeneratedCommandsInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdExecuteGeneratedCommandsNV(VkCommandBuffer commandBuffer, VkBool32 isPreprocessed, const VkGeneratedCommandsInfoNV* pGeneratedCommandsInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdExecuteGeneratedCommandsNV(VkCommandBuffer commandBuffer, VkBool32 isPreprocessed, const VkGeneratedCommandsInfoNV* pGeneratedCommandsInfo);

  #define tu_CmdExecuteGeneratedCommandsNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdExecuteGeneratedCommandsNV<X>(VkCommandBuffer commandBuffer, VkBool32 isPreprocessed, const VkGeneratedCommandsInfoNV* pGeneratedCommandsInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdPreprocessGeneratedCommandsNV(VkCommandBuffer commandBuffer, const VkGeneratedCommandsInfoNV* pGeneratedCommandsInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdPreprocessGeneratedCommandsNV(VkCommandBuffer commandBuffer, const VkGeneratedCommandsInfoNV* pGeneratedCommandsInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdPreprocessGeneratedCommandsNV(VkCommandBuffer commandBuffer, const VkGeneratedCommandsInfoNV* pGeneratedCommandsInfo);

  #define tu_CmdPreprocessGeneratedCommandsNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdPreprocessGeneratedCommandsNV<X>(VkCommandBuffer commandBuffer, const VkGeneratedCommandsInfoNV* pGeneratedCommandsInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBindPipelineShaderGroupNV(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline, uint32_t groupIndex) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBindPipelineShaderGroupNV(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline, uint32_t groupIndex) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBindPipelineShaderGroupNV(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline, uint32_t groupIndex);

  #define tu_CmdBindPipelineShaderGroupNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBindPipelineShaderGroupNV<X>(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipeline pipeline, uint32_t groupIndex);

  VKAPI_ATTR void VKAPI_CALL tu_GetGeneratedCommandsMemoryRequirementsNV(VkDevice device, const VkGeneratedCommandsMemoryRequirementsInfoNV* pInfo, VkMemoryRequirements2* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetGeneratedCommandsMemoryRequirementsNV(VkDevice device, const VkGeneratedCommandsMemoryRequirementsInfoNV* pInfo, VkMemoryRequirements2* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetGeneratedCommandsMemoryRequirementsNV(VkDevice device, const VkGeneratedCommandsMemoryRequirementsInfoNV* pInfo, VkMemoryRequirements2* pMemoryRequirements);

  #define tu_GetGeneratedCommandsMemoryRequirementsNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetGeneratedCommandsMemoryRequirementsNV<X>(VkDevice device, const VkGeneratedCommandsMemoryRequirementsInfoNV* pInfo, VkMemoryRequirements2* pMemoryRequirements);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateIndirectCommandsLayoutNV(VkDevice device, const VkIndirectCommandsLayoutCreateInfoNV* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkIndirectCommandsLayoutNV* pIndirectCommandsLayout) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateIndirectCommandsLayoutNV(VkDevice device, const VkIndirectCommandsLayoutCreateInfoNV* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkIndirectCommandsLayoutNV* pIndirectCommandsLayout) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateIndirectCommandsLayoutNV(VkDevice device, const VkIndirectCommandsLayoutCreateInfoNV* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkIndirectCommandsLayoutNV* pIndirectCommandsLayout);

  #define tu_CreateIndirectCommandsLayoutNV_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateIndirectCommandsLayoutNV<X>(VkDevice device, const VkIndirectCommandsLayoutCreateInfoNV* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkIndirectCommandsLayoutNV* pIndirectCommandsLayout);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyIndirectCommandsLayoutNV(VkDevice device, VkIndirectCommandsLayoutNV indirectCommandsLayout, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyIndirectCommandsLayoutNV(VkDevice device, VkIndirectCommandsLayoutNV indirectCommandsLayout, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyIndirectCommandsLayoutNV(VkDevice device, VkIndirectCommandsLayoutNV indirectCommandsLayout, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyIndirectCommandsLayoutNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyIndirectCommandsLayoutNV<X>(VkDevice device, VkIndirectCommandsLayoutNV indirectCommandsLayout, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR void VKAPI_CALL tu_CmdExecuteGeneratedCommandsEXT(VkCommandBuffer commandBuffer, VkBool32 isPreprocessed, const VkGeneratedCommandsInfoEXT* pGeneratedCommandsInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdExecuteGeneratedCommandsEXT(VkCommandBuffer commandBuffer, VkBool32 isPreprocessed, const VkGeneratedCommandsInfoEXT* pGeneratedCommandsInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdExecuteGeneratedCommandsEXT(VkCommandBuffer commandBuffer, VkBool32 isPreprocessed, const VkGeneratedCommandsInfoEXT* pGeneratedCommandsInfo);

  #define tu_CmdExecuteGeneratedCommandsEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdExecuteGeneratedCommandsEXT<X>(VkCommandBuffer commandBuffer, VkBool32 isPreprocessed, const VkGeneratedCommandsInfoEXT* pGeneratedCommandsInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdPreprocessGeneratedCommandsEXT(VkCommandBuffer commandBuffer, const VkGeneratedCommandsInfoEXT* pGeneratedCommandsInfo, VkCommandBuffer stateCommandBuffer) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdPreprocessGeneratedCommandsEXT(VkCommandBuffer commandBuffer, const VkGeneratedCommandsInfoEXT* pGeneratedCommandsInfo, VkCommandBuffer stateCommandBuffer) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdPreprocessGeneratedCommandsEXT(VkCommandBuffer commandBuffer, const VkGeneratedCommandsInfoEXT* pGeneratedCommandsInfo, VkCommandBuffer stateCommandBuffer);

  #define tu_CmdPreprocessGeneratedCommandsEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdPreprocessGeneratedCommandsEXT<X>(VkCommandBuffer commandBuffer, const VkGeneratedCommandsInfoEXT* pGeneratedCommandsInfo, VkCommandBuffer stateCommandBuffer);

  VKAPI_ATTR void VKAPI_CALL tu_GetGeneratedCommandsMemoryRequirementsEXT(VkDevice device, const VkGeneratedCommandsMemoryRequirementsInfoEXT* pInfo, VkMemoryRequirements2* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetGeneratedCommandsMemoryRequirementsEXT(VkDevice device, const VkGeneratedCommandsMemoryRequirementsInfoEXT* pInfo, VkMemoryRequirements2* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetGeneratedCommandsMemoryRequirementsEXT(VkDevice device, const VkGeneratedCommandsMemoryRequirementsInfoEXT* pInfo, VkMemoryRequirements2* pMemoryRequirements);

  #define tu_GetGeneratedCommandsMemoryRequirementsEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetGeneratedCommandsMemoryRequirementsEXT<X>(VkDevice device, const VkGeneratedCommandsMemoryRequirementsInfoEXT* pInfo, VkMemoryRequirements2* pMemoryRequirements);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateIndirectCommandsLayoutEXT(VkDevice device, const VkIndirectCommandsLayoutCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkIndirectCommandsLayoutEXT* pIndirectCommandsLayout) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateIndirectCommandsLayoutEXT(VkDevice device, const VkIndirectCommandsLayoutCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkIndirectCommandsLayoutEXT* pIndirectCommandsLayout) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateIndirectCommandsLayoutEXT(VkDevice device, const VkIndirectCommandsLayoutCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkIndirectCommandsLayoutEXT* pIndirectCommandsLayout);

  #define tu_CreateIndirectCommandsLayoutEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateIndirectCommandsLayoutEXT<X>(VkDevice device, const VkIndirectCommandsLayoutCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkIndirectCommandsLayoutEXT* pIndirectCommandsLayout);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyIndirectCommandsLayoutEXT(VkDevice device, VkIndirectCommandsLayoutEXT indirectCommandsLayout, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyIndirectCommandsLayoutEXT(VkDevice device, VkIndirectCommandsLayoutEXT indirectCommandsLayout, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyIndirectCommandsLayoutEXT(VkDevice device, VkIndirectCommandsLayoutEXT indirectCommandsLayout, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyIndirectCommandsLayoutEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyIndirectCommandsLayoutEXT<X>(VkDevice device, VkIndirectCommandsLayoutEXT indirectCommandsLayout, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateIndirectExecutionSetEXT(VkDevice device, const VkIndirectExecutionSetCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkIndirectExecutionSetEXT* pIndirectExecutionSet) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateIndirectExecutionSetEXT(VkDevice device, const VkIndirectExecutionSetCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkIndirectExecutionSetEXT* pIndirectExecutionSet) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateIndirectExecutionSetEXT(VkDevice device, const VkIndirectExecutionSetCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkIndirectExecutionSetEXT* pIndirectExecutionSet);

  #define tu_CreateIndirectExecutionSetEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateIndirectExecutionSetEXT<X>(VkDevice device, const VkIndirectExecutionSetCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkIndirectExecutionSetEXT* pIndirectExecutionSet);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyIndirectExecutionSetEXT(VkDevice device, VkIndirectExecutionSetEXT indirectExecutionSet, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyIndirectExecutionSetEXT(VkDevice device, VkIndirectExecutionSetEXT indirectExecutionSet, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyIndirectExecutionSetEXT(VkDevice device, VkIndirectExecutionSetEXT indirectExecutionSet, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyIndirectExecutionSetEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyIndirectExecutionSetEXT<X>(VkDevice device, VkIndirectExecutionSetEXT indirectExecutionSet, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR void VKAPI_CALL tu_UpdateIndirectExecutionSetPipelineEXT(VkDevice device, VkIndirectExecutionSetEXT indirectExecutionSet, uint32_t executionSetWriteCount, const VkWriteIndirectExecutionSetPipelineEXT* pExecutionSetWrites) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_UpdateIndirectExecutionSetPipelineEXT(VkDevice device, VkIndirectExecutionSetEXT indirectExecutionSet, uint32_t executionSetWriteCount, const VkWriteIndirectExecutionSetPipelineEXT* pExecutionSetWrites) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_UpdateIndirectExecutionSetPipelineEXT(VkDevice device, VkIndirectExecutionSetEXT indirectExecutionSet, uint32_t executionSetWriteCount, const VkWriteIndirectExecutionSetPipelineEXT* pExecutionSetWrites);

  #define tu_UpdateIndirectExecutionSetPipelineEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_UpdateIndirectExecutionSetPipelineEXT<X>(VkDevice device, VkIndirectExecutionSetEXT indirectExecutionSet, uint32_t executionSetWriteCount, const VkWriteIndirectExecutionSetPipelineEXT* pExecutionSetWrites);

  VKAPI_ATTR void VKAPI_CALL tu_UpdateIndirectExecutionSetShaderEXT(VkDevice device, VkIndirectExecutionSetEXT indirectExecutionSet, uint32_t executionSetWriteCount, const VkWriteIndirectExecutionSetShaderEXT* pExecutionSetWrites) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_UpdateIndirectExecutionSetShaderEXT(VkDevice device, VkIndirectExecutionSetEXT indirectExecutionSet, uint32_t executionSetWriteCount, const VkWriteIndirectExecutionSetShaderEXT* pExecutionSetWrites) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_UpdateIndirectExecutionSetShaderEXT(VkDevice device, VkIndirectExecutionSetEXT indirectExecutionSet, uint32_t executionSetWriteCount, const VkWriteIndirectExecutionSetShaderEXT* pExecutionSetWrites);

  #define tu_UpdateIndirectExecutionSetShaderEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_UpdateIndirectExecutionSetShaderEXT<X>(VkDevice device, VkIndirectExecutionSetEXT indirectExecutionSet, uint32_t executionSetWriteCount, const VkWriteIndirectExecutionSetShaderEXT* pExecutionSetWrites);

  VKAPI_ATTR void VKAPI_CALL tu_CmdPushDescriptorSet(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t set, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdPushDescriptorSet(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t set, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdPushDescriptorSet(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t set, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites);

  #define tu_CmdPushDescriptorSet_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdPushDescriptorSet<X>(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t set, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites);

  VKAPI_ATTR void VKAPI_CALL tu_CmdPushDescriptorSetKHR(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t set, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdPushDescriptorSetKHR(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t set, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdPushDescriptorSetKHR(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t set, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites);

  #define tu_CmdPushDescriptorSetKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdPushDescriptorSetKHR<X>(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t set, uint32_t descriptorWriteCount, const VkWriteDescriptorSet* pDescriptorWrites);

  VKAPI_ATTR void VKAPI_CALL tu_TrimCommandPool(VkDevice device, VkCommandPool commandPool, VkCommandPoolTrimFlags flags) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_TrimCommandPool(VkDevice device, VkCommandPool commandPool, VkCommandPoolTrimFlags flags) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_TrimCommandPool(VkDevice device, VkCommandPool commandPool, VkCommandPoolTrimFlags flags);

  #define tu_TrimCommandPool_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_TrimCommandPool<X>(VkDevice device, VkCommandPool commandPool, VkCommandPoolTrimFlags flags);

  VKAPI_ATTR void VKAPI_CALL tu_TrimCommandPoolKHR(VkDevice device, VkCommandPool commandPool, VkCommandPoolTrimFlags flags) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_TrimCommandPoolKHR(VkDevice device, VkCommandPool commandPool, VkCommandPoolTrimFlags flags) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_TrimCommandPoolKHR(VkDevice device, VkCommandPool commandPool, VkCommandPoolTrimFlags flags);

  #define tu_TrimCommandPoolKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_TrimCommandPoolKHR<X>(VkDevice device, VkCommandPool commandPool, VkCommandPoolTrimFlags flags);

#ifdef VK_USE_PLATFORM_WIN32_KHR
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryWin32HandleKHR(VkDevice device, const VkMemoryGetWin32HandleInfoKHR* pGetWin32HandleInfo, HANDLE* pHandle) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetMemoryWin32HandleKHR(VkDevice device, const VkMemoryGetWin32HandleInfoKHR* pGetWin32HandleInfo, HANDLE* pHandle) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryWin32HandleKHR(VkDevice device, const VkMemoryGetWin32HandleInfoKHR* pGetWin32HandleInfo, HANDLE* pHandle);

  #define tu_GetMemoryWin32HandleKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryWin32HandleKHR<X>(VkDevice device, const VkMemoryGetWin32HandleInfoKHR* pGetWin32HandleInfo, HANDLE* pHandle);

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryWin32HandlePropertiesKHR(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, HANDLE handle, VkMemoryWin32HandlePropertiesKHR* pMemoryWin32HandleProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetMemoryWin32HandlePropertiesKHR(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, HANDLE handle, VkMemoryWin32HandlePropertiesKHR* pMemoryWin32HandleProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryWin32HandlePropertiesKHR(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, HANDLE handle, VkMemoryWin32HandlePropertiesKHR* pMemoryWin32HandleProperties);

  #define tu_GetMemoryWin32HandlePropertiesKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryWin32HandlePropertiesKHR<X>(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, HANDLE handle, VkMemoryWin32HandlePropertiesKHR* pMemoryWin32HandleProperties);

#endif // VK_USE_PLATFORM_WIN32_KHR
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryFdKHR(VkDevice device, const VkMemoryGetFdInfoKHR* pGetFdInfo, int* pFd) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetMemoryFdKHR(VkDevice device, const VkMemoryGetFdInfoKHR* pGetFdInfo, int* pFd) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryFdKHR(VkDevice device, const VkMemoryGetFdInfoKHR* pGetFdInfo, int* pFd);

  #define tu_GetMemoryFdKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryFdKHR<X>(VkDevice device, const VkMemoryGetFdInfoKHR* pGetFdInfo, int* pFd);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryFdPropertiesKHR(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, int fd, VkMemoryFdPropertiesKHR* pMemoryFdProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetMemoryFdPropertiesKHR(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, int fd, VkMemoryFdPropertiesKHR* pMemoryFdProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryFdPropertiesKHR(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, int fd, VkMemoryFdPropertiesKHR* pMemoryFdProperties);

  #define tu_GetMemoryFdPropertiesKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryFdPropertiesKHR<X>(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, int fd, VkMemoryFdPropertiesKHR* pMemoryFdProperties);

#ifdef VK_USE_PLATFORM_FUCHSIA
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryZirconHandleFUCHSIA(VkDevice device, const VkMemoryGetZirconHandleInfoFUCHSIA* pGetZirconHandleInfo, zx_handle_t* pZirconHandle) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetMemoryZirconHandleFUCHSIA(VkDevice device, const VkMemoryGetZirconHandleInfoFUCHSIA* pGetZirconHandleInfo, zx_handle_t* pZirconHandle) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryZirconHandleFUCHSIA(VkDevice device, const VkMemoryGetZirconHandleInfoFUCHSIA* pGetZirconHandleInfo, zx_handle_t* pZirconHandle);

  #define tu_GetMemoryZirconHandleFUCHSIA_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryZirconHandleFUCHSIA<X>(VkDevice device, const VkMemoryGetZirconHandleInfoFUCHSIA* pGetZirconHandleInfo, zx_handle_t* pZirconHandle);

#endif // VK_USE_PLATFORM_FUCHSIA
#ifdef VK_USE_PLATFORM_FUCHSIA
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryZirconHandlePropertiesFUCHSIA(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, zx_handle_t zirconHandle, VkMemoryZirconHandlePropertiesFUCHSIA* pMemoryZirconHandleProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetMemoryZirconHandlePropertiesFUCHSIA(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, zx_handle_t zirconHandle, VkMemoryZirconHandlePropertiesFUCHSIA* pMemoryZirconHandleProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryZirconHandlePropertiesFUCHSIA(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, zx_handle_t zirconHandle, VkMemoryZirconHandlePropertiesFUCHSIA* pMemoryZirconHandleProperties);

  #define tu_GetMemoryZirconHandlePropertiesFUCHSIA_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryZirconHandlePropertiesFUCHSIA<X>(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, zx_handle_t zirconHandle, VkMemoryZirconHandlePropertiesFUCHSIA* pMemoryZirconHandleProperties);

#endif // VK_USE_PLATFORM_FUCHSIA
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryRemoteAddressNV(VkDevice device, const VkMemoryGetRemoteAddressInfoNV* pMemoryGetRemoteAddressInfo, VkRemoteAddressNV* pAddress) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetMemoryRemoteAddressNV(VkDevice device, const VkMemoryGetRemoteAddressInfoNV* pMemoryGetRemoteAddressInfo, VkRemoteAddressNV* pAddress) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryRemoteAddressNV(VkDevice device, const VkMemoryGetRemoteAddressInfoNV* pMemoryGetRemoteAddressInfo, VkRemoteAddressNV* pAddress);

  #define tu_GetMemoryRemoteAddressNV_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryRemoteAddressNV<X>(VkDevice device, const VkMemoryGetRemoteAddressInfoNV* pMemoryGetRemoteAddressInfo, VkRemoteAddressNV* pAddress);

#ifdef VK_USE_PLATFORM_WIN32_KHR
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetSemaphoreWin32HandleKHR(VkDevice device, const VkSemaphoreGetWin32HandleInfoKHR* pGetWin32HandleInfo, HANDLE* pHandle) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetSemaphoreWin32HandleKHR(VkDevice device, const VkSemaphoreGetWin32HandleInfoKHR* pGetWin32HandleInfo, HANDLE* pHandle) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetSemaphoreWin32HandleKHR(VkDevice device, const VkSemaphoreGetWin32HandleInfoKHR* pGetWin32HandleInfo, HANDLE* pHandle);

  #define tu_GetSemaphoreWin32HandleKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetSemaphoreWin32HandleKHR<X>(VkDevice device, const VkSemaphoreGetWin32HandleInfoKHR* pGetWin32HandleInfo, HANDLE* pHandle);

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
  VKAPI_ATTR VkResult VKAPI_CALL tu_ImportSemaphoreWin32HandleKHR(VkDevice device, const VkImportSemaphoreWin32HandleInfoKHR* pImportSemaphoreWin32HandleInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_ImportSemaphoreWin32HandleKHR(VkDevice device, const VkImportSemaphoreWin32HandleInfoKHR* pImportSemaphoreWin32HandleInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_ImportSemaphoreWin32HandleKHR(VkDevice device, const VkImportSemaphoreWin32HandleInfoKHR* pImportSemaphoreWin32HandleInfo);

  #define tu_ImportSemaphoreWin32HandleKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_ImportSemaphoreWin32HandleKHR<X>(VkDevice device, const VkImportSemaphoreWin32HandleInfoKHR* pImportSemaphoreWin32HandleInfo);

#endif // VK_USE_PLATFORM_WIN32_KHR
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetSemaphoreFdKHR(VkDevice device, const VkSemaphoreGetFdInfoKHR* pGetFdInfo, int* pFd) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetSemaphoreFdKHR(VkDevice device, const VkSemaphoreGetFdInfoKHR* pGetFdInfo, int* pFd) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetSemaphoreFdKHR(VkDevice device, const VkSemaphoreGetFdInfoKHR* pGetFdInfo, int* pFd);

  #define tu_GetSemaphoreFdKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetSemaphoreFdKHR<X>(VkDevice device, const VkSemaphoreGetFdInfoKHR* pGetFdInfo, int* pFd);

  VKAPI_ATTR VkResult VKAPI_CALL tu_ImportSemaphoreFdKHR(VkDevice device, const VkImportSemaphoreFdInfoKHR* pImportSemaphoreFdInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_ImportSemaphoreFdKHR(VkDevice device, const VkImportSemaphoreFdInfoKHR* pImportSemaphoreFdInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_ImportSemaphoreFdKHR(VkDevice device, const VkImportSemaphoreFdInfoKHR* pImportSemaphoreFdInfo);

  #define tu_ImportSemaphoreFdKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_ImportSemaphoreFdKHR<X>(VkDevice device, const VkImportSemaphoreFdInfoKHR* pImportSemaphoreFdInfo);

#ifdef VK_USE_PLATFORM_FUCHSIA
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetSemaphoreZirconHandleFUCHSIA(VkDevice device, const VkSemaphoreGetZirconHandleInfoFUCHSIA* pGetZirconHandleInfo, zx_handle_t* pZirconHandle) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetSemaphoreZirconHandleFUCHSIA(VkDevice device, const VkSemaphoreGetZirconHandleInfoFUCHSIA* pGetZirconHandleInfo, zx_handle_t* pZirconHandle) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetSemaphoreZirconHandleFUCHSIA(VkDevice device, const VkSemaphoreGetZirconHandleInfoFUCHSIA* pGetZirconHandleInfo, zx_handle_t* pZirconHandle);

  #define tu_GetSemaphoreZirconHandleFUCHSIA_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetSemaphoreZirconHandleFUCHSIA<X>(VkDevice device, const VkSemaphoreGetZirconHandleInfoFUCHSIA* pGetZirconHandleInfo, zx_handle_t* pZirconHandle);

#endif // VK_USE_PLATFORM_FUCHSIA
#ifdef VK_USE_PLATFORM_FUCHSIA
  VKAPI_ATTR VkResult VKAPI_CALL tu_ImportSemaphoreZirconHandleFUCHSIA(VkDevice device, const VkImportSemaphoreZirconHandleInfoFUCHSIA* pImportSemaphoreZirconHandleInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_ImportSemaphoreZirconHandleFUCHSIA(VkDevice device, const VkImportSemaphoreZirconHandleInfoFUCHSIA* pImportSemaphoreZirconHandleInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_ImportSemaphoreZirconHandleFUCHSIA(VkDevice device, const VkImportSemaphoreZirconHandleInfoFUCHSIA* pImportSemaphoreZirconHandleInfo);

  #define tu_ImportSemaphoreZirconHandleFUCHSIA_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_ImportSemaphoreZirconHandleFUCHSIA<X>(VkDevice device, const VkImportSemaphoreZirconHandleInfoFUCHSIA* pImportSemaphoreZirconHandleInfo);

#endif // VK_USE_PLATFORM_FUCHSIA
#ifdef VK_USE_PLATFORM_WIN32_KHR
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetFenceWin32HandleKHR(VkDevice device, const VkFenceGetWin32HandleInfoKHR* pGetWin32HandleInfo, HANDLE* pHandle) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetFenceWin32HandleKHR(VkDevice device, const VkFenceGetWin32HandleInfoKHR* pGetWin32HandleInfo, HANDLE* pHandle) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetFenceWin32HandleKHR(VkDevice device, const VkFenceGetWin32HandleInfoKHR* pGetWin32HandleInfo, HANDLE* pHandle);

  #define tu_GetFenceWin32HandleKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetFenceWin32HandleKHR<X>(VkDevice device, const VkFenceGetWin32HandleInfoKHR* pGetWin32HandleInfo, HANDLE* pHandle);

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
  VKAPI_ATTR VkResult VKAPI_CALL tu_ImportFenceWin32HandleKHR(VkDevice device, const VkImportFenceWin32HandleInfoKHR* pImportFenceWin32HandleInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_ImportFenceWin32HandleKHR(VkDevice device, const VkImportFenceWin32HandleInfoKHR* pImportFenceWin32HandleInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_ImportFenceWin32HandleKHR(VkDevice device, const VkImportFenceWin32HandleInfoKHR* pImportFenceWin32HandleInfo);

  #define tu_ImportFenceWin32HandleKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_ImportFenceWin32HandleKHR<X>(VkDevice device, const VkImportFenceWin32HandleInfoKHR* pImportFenceWin32HandleInfo);

#endif // VK_USE_PLATFORM_WIN32_KHR
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetFenceFdKHR(VkDevice device, const VkFenceGetFdInfoKHR* pGetFdInfo, int* pFd) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetFenceFdKHR(VkDevice device, const VkFenceGetFdInfoKHR* pGetFdInfo, int* pFd) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetFenceFdKHR(VkDevice device, const VkFenceGetFdInfoKHR* pGetFdInfo, int* pFd);

  #define tu_GetFenceFdKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetFenceFdKHR<X>(VkDevice device, const VkFenceGetFdInfoKHR* pGetFdInfo, int* pFd);

  VKAPI_ATTR VkResult VKAPI_CALL tu_ImportFenceFdKHR(VkDevice device, const VkImportFenceFdInfoKHR* pImportFenceFdInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_ImportFenceFdKHR(VkDevice device, const VkImportFenceFdInfoKHR* pImportFenceFdInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_ImportFenceFdKHR(VkDevice device, const VkImportFenceFdInfoKHR* pImportFenceFdInfo);

  #define tu_ImportFenceFdKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_ImportFenceFdKHR<X>(VkDevice device, const VkImportFenceFdInfoKHR* pImportFenceFdInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_DisplayPowerControlEXT(VkDevice device, VkDisplayKHR display, const VkDisplayPowerInfoEXT* pDisplayPowerInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_DisplayPowerControlEXT(VkDevice device, VkDisplayKHR display, const VkDisplayPowerInfoEXT* pDisplayPowerInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_DisplayPowerControlEXT(VkDevice device, VkDisplayKHR display, const VkDisplayPowerInfoEXT* pDisplayPowerInfo);

  #define tu_DisplayPowerControlEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_DisplayPowerControlEXT<X>(VkDevice device, VkDisplayKHR display, const VkDisplayPowerInfoEXT* pDisplayPowerInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_RegisterDeviceEventEXT(VkDevice device, const VkDeviceEventInfoEXT* pDeviceEventInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_RegisterDeviceEventEXT(VkDevice device, const VkDeviceEventInfoEXT* pDeviceEventInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_RegisterDeviceEventEXT(VkDevice device, const VkDeviceEventInfoEXT* pDeviceEventInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence);

  #define tu_RegisterDeviceEventEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_RegisterDeviceEventEXT<X>(VkDevice device, const VkDeviceEventInfoEXT* pDeviceEventInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence);

  VKAPI_ATTR VkResult VKAPI_CALL tu_RegisterDisplayEventEXT(VkDevice device, VkDisplayKHR display, const VkDisplayEventInfoEXT* pDisplayEventInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_RegisterDisplayEventEXT(VkDevice device, VkDisplayKHR display, const VkDisplayEventInfoEXT* pDisplayEventInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_RegisterDisplayEventEXT(VkDevice device, VkDisplayKHR display, const VkDisplayEventInfoEXT* pDisplayEventInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence);

  #define tu_RegisterDisplayEventEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_RegisterDisplayEventEXT<X>(VkDevice device, VkDisplayKHR display, const VkDisplayEventInfoEXT* pDisplayEventInfo, const VkAllocationCallbacks* pAllocator, VkFence* pFence);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetSwapchainCounterEXT(VkDevice device, VkSwapchainKHR swapchain, VkSurfaceCounterFlagBitsEXT counter, uint64_t* pCounterValue) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetSwapchainCounterEXT(VkDevice device, VkSwapchainKHR swapchain, VkSurfaceCounterFlagBitsEXT counter, uint64_t* pCounterValue) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetSwapchainCounterEXT(VkDevice device, VkSwapchainKHR swapchain, VkSurfaceCounterFlagBitsEXT counter, uint64_t* pCounterValue);

  #define tu_GetSwapchainCounterEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetSwapchainCounterEXT<X>(VkDevice device, VkSwapchainKHR swapchain, VkSurfaceCounterFlagBitsEXT counter, uint64_t* pCounterValue);

  VKAPI_ATTR void VKAPI_CALL tu_GetDeviceGroupPeerMemoryFeatures(VkDevice device, uint32_t heapIndex, uint32_t localDeviceIndex, uint32_t remoteDeviceIndex, VkPeerMemoryFeatureFlags* pPeerMemoryFeatures) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetDeviceGroupPeerMemoryFeatures(VkDevice device, uint32_t heapIndex, uint32_t localDeviceIndex, uint32_t remoteDeviceIndex, VkPeerMemoryFeatureFlags* pPeerMemoryFeatures) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetDeviceGroupPeerMemoryFeatures(VkDevice device, uint32_t heapIndex, uint32_t localDeviceIndex, uint32_t remoteDeviceIndex, VkPeerMemoryFeatureFlags* pPeerMemoryFeatures);

  #define tu_GetDeviceGroupPeerMemoryFeatures_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetDeviceGroupPeerMemoryFeatures<X>(VkDevice device, uint32_t heapIndex, uint32_t localDeviceIndex, uint32_t remoteDeviceIndex, VkPeerMemoryFeatureFlags* pPeerMemoryFeatures);

  VKAPI_ATTR void VKAPI_CALL tu_GetDeviceGroupPeerMemoryFeaturesKHR(VkDevice device, uint32_t heapIndex, uint32_t localDeviceIndex, uint32_t remoteDeviceIndex, VkPeerMemoryFeatureFlags* pPeerMemoryFeatures) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetDeviceGroupPeerMemoryFeaturesKHR(VkDevice device, uint32_t heapIndex, uint32_t localDeviceIndex, uint32_t remoteDeviceIndex, VkPeerMemoryFeatureFlags* pPeerMemoryFeatures) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetDeviceGroupPeerMemoryFeaturesKHR(VkDevice device, uint32_t heapIndex, uint32_t localDeviceIndex, uint32_t remoteDeviceIndex, VkPeerMemoryFeatureFlags* pPeerMemoryFeatures);

  #define tu_GetDeviceGroupPeerMemoryFeaturesKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetDeviceGroupPeerMemoryFeaturesKHR<X>(VkDevice device, uint32_t heapIndex, uint32_t localDeviceIndex, uint32_t remoteDeviceIndex, VkPeerMemoryFeatureFlags* pPeerMemoryFeatures);

  VKAPI_ATTR VkResult VKAPI_CALL tu_BindBufferMemory2(VkDevice device, uint32_t bindInfoCount, const VkBindBufferMemoryInfo* pBindInfos) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_BindBufferMemory2(VkDevice device, uint32_t bindInfoCount, const VkBindBufferMemoryInfo* pBindInfos) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_BindBufferMemory2(VkDevice device, uint32_t bindInfoCount, const VkBindBufferMemoryInfo* pBindInfos);

  #define tu_BindBufferMemory2_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_BindBufferMemory2<X>(VkDevice device, uint32_t bindInfoCount, const VkBindBufferMemoryInfo* pBindInfos);

  VKAPI_ATTR VkResult VKAPI_CALL tu_BindBufferMemory2KHR(VkDevice device, uint32_t bindInfoCount, const VkBindBufferMemoryInfo* pBindInfos) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_BindBufferMemory2KHR(VkDevice device, uint32_t bindInfoCount, const VkBindBufferMemoryInfo* pBindInfos) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_BindBufferMemory2KHR(VkDevice device, uint32_t bindInfoCount, const VkBindBufferMemoryInfo* pBindInfos);

  #define tu_BindBufferMemory2KHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_BindBufferMemory2KHR<X>(VkDevice device, uint32_t bindInfoCount, const VkBindBufferMemoryInfo* pBindInfos);

  VKAPI_ATTR VkResult VKAPI_CALL tu_BindImageMemory2(VkDevice device, uint32_t bindInfoCount, const VkBindImageMemoryInfo* pBindInfos) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_BindImageMemory2(VkDevice device, uint32_t bindInfoCount, const VkBindImageMemoryInfo* pBindInfos) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_BindImageMemory2(VkDevice device, uint32_t bindInfoCount, const VkBindImageMemoryInfo* pBindInfos);

  #define tu_BindImageMemory2_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_BindImageMemory2<X>(VkDevice device, uint32_t bindInfoCount, const VkBindImageMemoryInfo* pBindInfos);

  VKAPI_ATTR VkResult VKAPI_CALL tu_BindImageMemory2KHR(VkDevice device, uint32_t bindInfoCount, const VkBindImageMemoryInfo* pBindInfos) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_BindImageMemory2KHR(VkDevice device, uint32_t bindInfoCount, const VkBindImageMemoryInfo* pBindInfos) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_BindImageMemory2KHR(VkDevice device, uint32_t bindInfoCount, const VkBindImageMemoryInfo* pBindInfos);

  #define tu_BindImageMemory2KHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_BindImageMemory2KHR<X>(VkDevice device, uint32_t bindInfoCount, const VkBindImageMemoryInfo* pBindInfos);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDeviceMask(VkCommandBuffer commandBuffer, uint32_t deviceMask) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetDeviceMask(VkCommandBuffer commandBuffer, uint32_t deviceMask) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDeviceMask(VkCommandBuffer commandBuffer, uint32_t deviceMask);

  #define tu_CmdSetDeviceMask_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetDeviceMask<X>(VkCommandBuffer commandBuffer, uint32_t deviceMask);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDeviceMaskKHR(VkCommandBuffer commandBuffer, uint32_t deviceMask) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetDeviceMaskKHR(VkCommandBuffer commandBuffer, uint32_t deviceMask) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDeviceMaskKHR(VkCommandBuffer commandBuffer, uint32_t deviceMask);

  #define tu_CmdSetDeviceMaskKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetDeviceMaskKHR<X>(VkCommandBuffer commandBuffer, uint32_t deviceMask);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetDeviceGroupPresentCapabilitiesKHR(VkDevice device, VkDeviceGroupPresentCapabilitiesKHR* pDeviceGroupPresentCapabilities) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetDeviceGroupPresentCapabilitiesKHR(VkDevice device, VkDeviceGroupPresentCapabilitiesKHR* pDeviceGroupPresentCapabilities) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetDeviceGroupPresentCapabilitiesKHR(VkDevice device, VkDeviceGroupPresentCapabilitiesKHR* pDeviceGroupPresentCapabilities);

  #define tu_GetDeviceGroupPresentCapabilitiesKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetDeviceGroupPresentCapabilitiesKHR<X>(VkDevice device, VkDeviceGroupPresentCapabilitiesKHR* pDeviceGroupPresentCapabilities);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetDeviceGroupSurfacePresentModesKHR(VkDevice device, VkSurfaceKHR surface, VkDeviceGroupPresentModeFlagsKHR* pModes) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetDeviceGroupSurfacePresentModesKHR(VkDevice device, VkSurfaceKHR surface, VkDeviceGroupPresentModeFlagsKHR* pModes) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetDeviceGroupSurfacePresentModesKHR(VkDevice device, VkSurfaceKHR surface, VkDeviceGroupPresentModeFlagsKHR* pModes);

  #define tu_GetDeviceGroupSurfacePresentModesKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetDeviceGroupSurfacePresentModesKHR<X>(VkDevice device, VkSurfaceKHR surface, VkDeviceGroupPresentModeFlagsKHR* pModes);

  VKAPI_ATTR VkResult VKAPI_CALL tu_AcquireNextImage2KHR(VkDevice device, const VkAcquireNextImageInfoKHR* pAcquireInfo, uint32_t* pImageIndex) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_AcquireNextImage2KHR(VkDevice device, const VkAcquireNextImageInfoKHR* pAcquireInfo, uint32_t* pImageIndex) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_AcquireNextImage2KHR(VkDevice device, const VkAcquireNextImageInfoKHR* pAcquireInfo, uint32_t* pImageIndex);

  #define tu_AcquireNextImage2KHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_AcquireNextImage2KHR<X>(VkDevice device, const VkAcquireNextImageInfoKHR* pAcquireInfo, uint32_t* pImageIndex);

  VKAPI_ATTR void VKAPI_CALL tu_CmdDispatchBase(VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDispatchBase(VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDispatchBase(VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ);

  #define tu_CmdDispatchBase_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDispatchBase<X>(VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ);

  VKAPI_ATTR void VKAPI_CALL tu_CmdDispatchBaseKHR(VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDispatchBaseKHR(VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDispatchBaseKHR(VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ);

  #define tu_CmdDispatchBaseKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDispatchBaseKHR<X>(VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY, uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateDescriptorUpdateTemplate(VkDevice device, const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorUpdateTemplate* pDescriptorUpdateTemplate) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateDescriptorUpdateTemplate(VkDevice device, const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorUpdateTemplate* pDescriptorUpdateTemplate) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateDescriptorUpdateTemplate(VkDevice device, const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorUpdateTemplate* pDescriptorUpdateTemplate);

  #define tu_CreateDescriptorUpdateTemplate_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateDescriptorUpdateTemplate<X>(VkDevice device, const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorUpdateTemplate* pDescriptorUpdateTemplate);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateDescriptorUpdateTemplateKHR(VkDevice device, const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorUpdateTemplate* pDescriptorUpdateTemplate) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateDescriptorUpdateTemplateKHR(VkDevice device, const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorUpdateTemplate* pDescriptorUpdateTemplate) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateDescriptorUpdateTemplateKHR(VkDevice device, const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorUpdateTemplate* pDescriptorUpdateTemplate);

  #define tu_CreateDescriptorUpdateTemplateKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateDescriptorUpdateTemplateKHR<X>(VkDevice device, const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDescriptorUpdateTemplate* pDescriptorUpdateTemplate);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyDescriptorUpdateTemplate(VkDevice device, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyDescriptorUpdateTemplate(VkDevice device, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyDescriptorUpdateTemplate(VkDevice device, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyDescriptorUpdateTemplate_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyDescriptorUpdateTemplate<X>(VkDevice device, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyDescriptorUpdateTemplateKHR(VkDevice device, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyDescriptorUpdateTemplateKHR(VkDevice device, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyDescriptorUpdateTemplateKHR(VkDevice device, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyDescriptorUpdateTemplateKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyDescriptorUpdateTemplateKHR<X>(VkDevice device, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR void VKAPI_CALL tu_UpdateDescriptorSetWithTemplate(VkDevice device, VkDescriptorSet descriptorSet, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_UpdateDescriptorSetWithTemplate(VkDevice device, VkDescriptorSet descriptorSet, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_UpdateDescriptorSetWithTemplate(VkDevice device, VkDescriptorSet descriptorSet, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const void* pData);

  #define tu_UpdateDescriptorSetWithTemplate_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_UpdateDescriptorSetWithTemplate<X>(VkDevice device, VkDescriptorSet descriptorSet, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const void* pData);

  VKAPI_ATTR void VKAPI_CALL tu_UpdateDescriptorSetWithTemplateKHR(VkDevice device, VkDescriptorSet descriptorSet, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_UpdateDescriptorSetWithTemplateKHR(VkDevice device, VkDescriptorSet descriptorSet, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_UpdateDescriptorSetWithTemplateKHR(VkDevice device, VkDescriptorSet descriptorSet, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const void* pData);

  #define tu_UpdateDescriptorSetWithTemplateKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_UpdateDescriptorSetWithTemplateKHR<X>(VkDevice device, VkDescriptorSet descriptorSet, VkDescriptorUpdateTemplate descriptorUpdateTemplate, const void* pData);

  VKAPI_ATTR void VKAPI_CALL tu_CmdPushDescriptorSetWithTemplate(VkCommandBuffer commandBuffer, VkDescriptorUpdateTemplate descriptorUpdateTemplate, VkPipelineLayout layout, uint32_t set, const void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdPushDescriptorSetWithTemplate(VkCommandBuffer commandBuffer, VkDescriptorUpdateTemplate descriptorUpdateTemplate, VkPipelineLayout layout, uint32_t set, const void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdPushDescriptorSetWithTemplate(VkCommandBuffer commandBuffer, VkDescriptorUpdateTemplate descriptorUpdateTemplate, VkPipelineLayout layout, uint32_t set, const void* pData);

  #define tu_CmdPushDescriptorSetWithTemplate_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdPushDescriptorSetWithTemplate<X>(VkCommandBuffer commandBuffer, VkDescriptorUpdateTemplate descriptorUpdateTemplate, VkPipelineLayout layout, uint32_t set, const void* pData);

  VKAPI_ATTR void VKAPI_CALL tu_CmdPushDescriptorSetWithTemplateKHR(VkCommandBuffer commandBuffer, VkDescriptorUpdateTemplate descriptorUpdateTemplate, VkPipelineLayout layout, uint32_t set, const void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdPushDescriptorSetWithTemplateKHR(VkCommandBuffer commandBuffer, VkDescriptorUpdateTemplate descriptorUpdateTemplate, VkPipelineLayout layout, uint32_t set, const void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdPushDescriptorSetWithTemplateKHR(VkCommandBuffer commandBuffer, VkDescriptorUpdateTemplate descriptorUpdateTemplate, VkPipelineLayout layout, uint32_t set, const void* pData);

  #define tu_CmdPushDescriptorSetWithTemplateKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdPushDescriptorSetWithTemplateKHR<X>(VkCommandBuffer commandBuffer, VkDescriptorUpdateTemplate descriptorUpdateTemplate, VkPipelineLayout layout, uint32_t set, const void* pData);

  VKAPI_ATTR void VKAPI_CALL tu_SetHdrMetadataEXT(VkDevice device, uint32_t swapchainCount, const VkSwapchainKHR* pSwapchains, const VkHdrMetadataEXT* pMetadata) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_SetHdrMetadataEXT(VkDevice device, uint32_t swapchainCount, const VkSwapchainKHR* pSwapchains, const VkHdrMetadataEXT* pMetadata) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_SetHdrMetadataEXT(VkDevice device, uint32_t swapchainCount, const VkSwapchainKHR* pSwapchains, const VkHdrMetadataEXT* pMetadata);

  #define tu_SetHdrMetadataEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_SetHdrMetadataEXT<X>(VkDevice device, uint32_t swapchainCount, const VkSwapchainKHR* pSwapchains, const VkHdrMetadataEXT* pMetadata);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetSwapchainStatusKHR(VkDevice device, VkSwapchainKHR swapchain) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetSwapchainStatusKHR(VkDevice device, VkSwapchainKHR swapchain) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetSwapchainStatusKHR(VkDevice device, VkSwapchainKHR swapchain);

  #define tu_GetSwapchainStatusKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetSwapchainStatusKHR<X>(VkDevice device, VkSwapchainKHR swapchain);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetRefreshCycleDurationGOOGLE(VkDevice device, VkSwapchainKHR swapchain, VkRefreshCycleDurationGOOGLE* pDisplayTimingProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetRefreshCycleDurationGOOGLE(VkDevice device, VkSwapchainKHR swapchain, VkRefreshCycleDurationGOOGLE* pDisplayTimingProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetRefreshCycleDurationGOOGLE(VkDevice device, VkSwapchainKHR swapchain, VkRefreshCycleDurationGOOGLE* pDisplayTimingProperties);

  #define tu_GetRefreshCycleDurationGOOGLE_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetRefreshCycleDurationGOOGLE<X>(VkDevice device, VkSwapchainKHR swapchain, VkRefreshCycleDurationGOOGLE* pDisplayTimingProperties);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPastPresentationTimingGOOGLE(VkDevice device, VkSwapchainKHR swapchain, uint32_t* pPresentationTimingCount, VkPastPresentationTimingGOOGLE* pPresentationTimings) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetPastPresentationTimingGOOGLE(VkDevice device, VkSwapchainKHR swapchain, uint32_t* pPresentationTimingCount, VkPastPresentationTimingGOOGLE* pPresentationTimings) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPastPresentationTimingGOOGLE(VkDevice device, VkSwapchainKHR swapchain, uint32_t* pPresentationTimingCount, VkPastPresentationTimingGOOGLE* pPresentationTimings);

  #define tu_GetPastPresentationTimingGOOGLE_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetPastPresentationTimingGOOGLE<X>(VkDevice device, VkSwapchainKHR swapchain, uint32_t* pPresentationTimingCount, VkPastPresentationTimingGOOGLE* pPresentationTimings);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetViewportWScalingNV(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewportWScalingNV* pViewportWScalings) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetViewportWScalingNV(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewportWScalingNV* pViewportWScalings) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetViewportWScalingNV(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewportWScalingNV* pViewportWScalings);

  #define tu_CmdSetViewportWScalingNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetViewportWScalingNV<X>(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewportWScalingNV* pViewportWScalings);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDiscardRectangleEXT(VkCommandBuffer commandBuffer, uint32_t firstDiscardRectangle, uint32_t discardRectangleCount, const VkRect2D* pDiscardRectangles) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetDiscardRectangleEXT(VkCommandBuffer commandBuffer, uint32_t firstDiscardRectangle, uint32_t discardRectangleCount, const VkRect2D* pDiscardRectangles) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDiscardRectangleEXT(VkCommandBuffer commandBuffer, uint32_t firstDiscardRectangle, uint32_t discardRectangleCount, const VkRect2D* pDiscardRectangles);

  #define tu_CmdSetDiscardRectangleEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetDiscardRectangleEXT<X>(VkCommandBuffer commandBuffer, uint32_t firstDiscardRectangle, uint32_t discardRectangleCount, const VkRect2D* pDiscardRectangles);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDiscardRectangleEnableEXT(VkCommandBuffer commandBuffer, VkBool32 discardRectangleEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetDiscardRectangleEnableEXT(VkCommandBuffer commandBuffer, VkBool32 discardRectangleEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDiscardRectangleEnableEXT(VkCommandBuffer commandBuffer, VkBool32 discardRectangleEnable);

  #define tu_CmdSetDiscardRectangleEnableEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetDiscardRectangleEnableEXT<X>(VkCommandBuffer commandBuffer, VkBool32 discardRectangleEnable);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDiscardRectangleModeEXT(VkCommandBuffer commandBuffer, VkDiscardRectangleModeEXT discardRectangleMode) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetDiscardRectangleModeEXT(VkCommandBuffer commandBuffer, VkDiscardRectangleModeEXT discardRectangleMode) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDiscardRectangleModeEXT(VkCommandBuffer commandBuffer, VkDiscardRectangleModeEXT discardRectangleMode);

  #define tu_CmdSetDiscardRectangleModeEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetDiscardRectangleModeEXT<X>(VkCommandBuffer commandBuffer, VkDiscardRectangleModeEXT discardRectangleMode);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetSampleLocationsEXT(VkCommandBuffer commandBuffer, const VkSampleLocationsInfoEXT* pSampleLocationsInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetSampleLocationsEXT(VkCommandBuffer commandBuffer, const VkSampleLocationsInfoEXT* pSampleLocationsInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetSampleLocationsEXT(VkCommandBuffer commandBuffer, const VkSampleLocationsInfoEXT* pSampleLocationsInfo);

  #define tu_CmdSetSampleLocationsEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetSampleLocationsEXT<X>(VkCommandBuffer commandBuffer, const VkSampleLocationsInfoEXT* pSampleLocationsInfo);

  VKAPI_ATTR void VKAPI_CALL tu_GetBufferMemoryRequirements2(VkDevice device, const VkBufferMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetBufferMemoryRequirements2(VkDevice device, const VkBufferMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetBufferMemoryRequirements2(VkDevice device, const VkBufferMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements);

  #define tu_GetBufferMemoryRequirements2_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetBufferMemoryRequirements2<X>(VkDevice device, const VkBufferMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements);

  VKAPI_ATTR void VKAPI_CALL tu_GetBufferMemoryRequirements2KHR(VkDevice device, const VkBufferMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetBufferMemoryRequirements2KHR(VkDevice device, const VkBufferMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetBufferMemoryRequirements2KHR(VkDevice device, const VkBufferMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements);

  #define tu_GetBufferMemoryRequirements2KHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetBufferMemoryRequirements2KHR<X>(VkDevice device, const VkBufferMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements);

  VKAPI_ATTR void VKAPI_CALL tu_GetImageMemoryRequirements2(VkDevice device, const VkImageMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetImageMemoryRequirements2(VkDevice device, const VkImageMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetImageMemoryRequirements2(VkDevice device, const VkImageMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements);

  #define tu_GetImageMemoryRequirements2_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetImageMemoryRequirements2<X>(VkDevice device, const VkImageMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements);

  VKAPI_ATTR void VKAPI_CALL tu_GetImageMemoryRequirements2KHR(VkDevice device, const VkImageMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetImageMemoryRequirements2KHR(VkDevice device, const VkImageMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetImageMemoryRequirements2KHR(VkDevice device, const VkImageMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements);

  #define tu_GetImageMemoryRequirements2KHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetImageMemoryRequirements2KHR<X>(VkDevice device, const VkImageMemoryRequirementsInfo2* pInfo, VkMemoryRequirements2* pMemoryRequirements);

  VKAPI_ATTR void VKAPI_CALL tu_GetImageSparseMemoryRequirements2(VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetImageSparseMemoryRequirements2(VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetImageSparseMemoryRequirements2(VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements);

  #define tu_GetImageSparseMemoryRequirements2_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetImageSparseMemoryRequirements2<X>(VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements);

  VKAPI_ATTR void VKAPI_CALL tu_GetImageSparseMemoryRequirements2KHR(VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetImageSparseMemoryRequirements2KHR(VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetImageSparseMemoryRequirements2KHR(VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements);

  #define tu_GetImageSparseMemoryRequirements2KHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetImageSparseMemoryRequirements2KHR<X>(VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements);

  VKAPI_ATTR void VKAPI_CALL tu_GetDeviceBufferMemoryRequirements(VkDevice device, const VkDeviceBufferMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetDeviceBufferMemoryRequirements(VkDevice device, const VkDeviceBufferMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetDeviceBufferMemoryRequirements(VkDevice device, const VkDeviceBufferMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements);

  #define tu_GetDeviceBufferMemoryRequirements_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetDeviceBufferMemoryRequirements<X>(VkDevice device, const VkDeviceBufferMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements);

  VKAPI_ATTR void VKAPI_CALL tu_GetDeviceBufferMemoryRequirementsKHR(VkDevice device, const VkDeviceBufferMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetDeviceBufferMemoryRequirementsKHR(VkDevice device, const VkDeviceBufferMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetDeviceBufferMemoryRequirementsKHR(VkDevice device, const VkDeviceBufferMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements);

  #define tu_GetDeviceBufferMemoryRequirementsKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetDeviceBufferMemoryRequirementsKHR<X>(VkDevice device, const VkDeviceBufferMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements);

  VKAPI_ATTR void VKAPI_CALL tu_GetDeviceImageMemoryRequirements(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetDeviceImageMemoryRequirements(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetDeviceImageMemoryRequirements(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements);

  #define tu_GetDeviceImageMemoryRequirements_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetDeviceImageMemoryRequirements<X>(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements);

  VKAPI_ATTR void VKAPI_CALL tu_GetDeviceImageMemoryRequirementsKHR(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetDeviceImageMemoryRequirementsKHR(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetDeviceImageMemoryRequirementsKHR(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements);

  #define tu_GetDeviceImageMemoryRequirementsKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetDeviceImageMemoryRequirementsKHR<X>(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, VkMemoryRequirements2* pMemoryRequirements);

  VKAPI_ATTR void VKAPI_CALL tu_GetDeviceImageSparseMemoryRequirements(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetDeviceImageSparseMemoryRequirements(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetDeviceImageSparseMemoryRequirements(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements);

  #define tu_GetDeviceImageSparseMemoryRequirements_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetDeviceImageSparseMemoryRequirements<X>(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements);

  VKAPI_ATTR void VKAPI_CALL tu_GetDeviceImageSparseMemoryRequirementsKHR(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetDeviceImageSparseMemoryRequirementsKHR(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetDeviceImageSparseMemoryRequirementsKHR(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements);

  #define tu_GetDeviceImageSparseMemoryRequirementsKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetDeviceImageSparseMemoryRequirementsKHR<X>(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo, uint32_t* pSparseMemoryRequirementCount, VkSparseImageMemoryRequirements2* pSparseMemoryRequirements);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateSamplerYcbcrConversion(VkDevice device, const VkSamplerYcbcrConversionCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSamplerYcbcrConversion* pYcbcrConversion) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateSamplerYcbcrConversion(VkDevice device, const VkSamplerYcbcrConversionCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSamplerYcbcrConversion* pYcbcrConversion) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateSamplerYcbcrConversion(VkDevice device, const VkSamplerYcbcrConversionCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSamplerYcbcrConversion* pYcbcrConversion);

  #define tu_CreateSamplerYcbcrConversion_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateSamplerYcbcrConversion<X>(VkDevice device, const VkSamplerYcbcrConversionCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSamplerYcbcrConversion* pYcbcrConversion);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateSamplerYcbcrConversionKHR(VkDevice device, const VkSamplerYcbcrConversionCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSamplerYcbcrConversion* pYcbcrConversion) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateSamplerYcbcrConversionKHR(VkDevice device, const VkSamplerYcbcrConversionCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSamplerYcbcrConversion* pYcbcrConversion) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateSamplerYcbcrConversionKHR(VkDevice device, const VkSamplerYcbcrConversionCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSamplerYcbcrConversion* pYcbcrConversion);

  #define tu_CreateSamplerYcbcrConversionKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateSamplerYcbcrConversionKHR<X>(VkDevice device, const VkSamplerYcbcrConversionCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkSamplerYcbcrConversion* pYcbcrConversion);

  VKAPI_ATTR void VKAPI_CALL tu_DestroySamplerYcbcrConversion(VkDevice device, VkSamplerYcbcrConversion ycbcrConversion, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroySamplerYcbcrConversion(VkDevice device, VkSamplerYcbcrConversion ycbcrConversion, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroySamplerYcbcrConversion(VkDevice device, VkSamplerYcbcrConversion ycbcrConversion, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroySamplerYcbcrConversion_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroySamplerYcbcrConversion<X>(VkDevice device, VkSamplerYcbcrConversion ycbcrConversion, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR void VKAPI_CALL tu_DestroySamplerYcbcrConversionKHR(VkDevice device, VkSamplerYcbcrConversion ycbcrConversion, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroySamplerYcbcrConversionKHR(VkDevice device, VkSamplerYcbcrConversion ycbcrConversion, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroySamplerYcbcrConversionKHR(VkDevice device, VkSamplerYcbcrConversion ycbcrConversion, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroySamplerYcbcrConversionKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroySamplerYcbcrConversionKHR<X>(VkDevice device, VkSamplerYcbcrConversion ycbcrConversion, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR void VKAPI_CALL tu_GetDeviceQueue2(VkDevice device, const VkDeviceQueueInfo2* pQueueInfo, VkQueue* pQueue) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetDeviceQueue2(VkDevice device, const VkDeviceQueueInfo2* pQueueInfo, VkQueue* pQueue) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetDeviceQueue2(VkDevice device, const VkDeviceQueueInfo2* pQueueInfo, VkQueue* pQueue);

  #define tu_GetDeviceQueue2_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetDeviceQueue2<X>(VkDevice device, const VkDeviceQueueInfo2* pQueueInfo, VkQueue* pQueue);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateValidationCacheEXT(VkDevice device, const VkValidationCacheCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkValidationCacheEXT* pValidationCache) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateValidationCacheEXT(VkDevice device, const VkValidationCacheCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkValidationCacheEXT* pValidationCache) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateValidationCacheEXT(VkDevice device, const VkValidationCacheCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkValidationCacheEXT* pValidationCache);

  #define tu_CreateValidationCacheEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateValidationCacheEXT<X>(VkDevice device, const VkValidationCacheCreateInfoEXT* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkValidationCacheEXT* pValidationCache);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyValidationCacheEXT(VkDevice device, VkValidationCacheEXT validationCache, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyValidationCacheEXT(VkDevice device, VkValidationCacheEXT validationCache, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyValidationCacheEXT(VkDevice device, VkValidationCacheEXT validationCache, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyValidationCacheEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyValidationCacheEXT<X>(VkDevice device, VkValidationCacheEXT validationCache, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetValidationCacheDataEXT(VkDevice device, VkValidationCacheEXT validationCache, size_t* pDataSize, void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetValidationCacheDataEXT(VkDevice device, VkValidationCacheEXT validationCache, size_t* pDataSize, void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetValidationCacheDataEXT(VkDevice device, VkValidationCacheEXT validationCache, size_t* pDataSize, void* pData);

  #define tu_GetValidationCacheDataEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetValidationCacheDataEXT<X>(VkDevice device, VkValidationCacheEXT validationCache, size_t* pDataSize, void* pData);

  VKAPI_ATTR VkResult VKAPI_CALL tu_MergeValidationCachesEXT(VkDevice device, VkValidationCacheEXT dstCache, uint32_t srcCacheCount, const VkValidationCacheEXT* pSrcCaches) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_MergeValidationCachesEXT(VkDevice device, VkValidationCacheEXT dstCache, uint32_t srcCacheCount, const VkValidationCacheEXT* pSrcCaches) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_MergeValidationCachesEXT(VkDevice device, VkValidationCacheEXT dstCache, uint32_t srcCacheCount, const VkValidationCacheEXT* pSrcCaches);

  #define tu_MergeValidationCachesEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_MergeValidationCachesEXT<X>(VkDevice device, VkValidationCacheEXT dstCache, uint32_t srcCacheCount, const VkValidationCacheEXT* pSrcCaches);

  VKAPI_ATTR void VKAPI_CALL tu_GetDescriptorSetLayoutSupport(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, VkDescriptorSetLayoutSupport* pSupport) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetDescriptorSetLayoutSupport(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, VkDescriptorSetLayoutSupport* pSupport) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetDescriptorSetLayoutSupport(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, VkDescriptorSetLayoutSupport* pSupport);

  #define tu_GetDescriptorSetLayoutSupport_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetDescriptorSetLayoutSupport<X>(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, VkDescriptorSetLayoutSupport* pSupport);

  VKAPI_ATTR void VKAPI_CALL tu_GetDescriptorSetLayoutSupportKHR(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, VkDescriptorSetLayoutSupport* pSupport) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetDescriptorSetLayoutSupportKHR(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, VkDescriptorSetLayoutSupport* pSupport) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetDescriptorSetLayoutSupportKHR(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, VkDescriptorSetLayoutSupport* pSupport);

  #define tu_GetDescriptorSetLayoutSupportKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetDescriptorSetLayoutSupportKHR<X>(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo, VkDescriptorSetLayoutSupport* pSupport);

#ifdef VK_USE_PLATFORM_ANDROID_KHR
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetSwapchainGrallocUsageANDROID(VkDevice device, VkFormat format, VkImageUsageFlags imageUsage, int* grallocUsage) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetSwapchainGrallocUsageANDROID(VkDevice device, VkFormat format, VkImageUsageFlags imageUsage, int* grallocUsage) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetSwapchainGrallocUsageANDROID(VkDevice device, VkFormat format, VkImageUsageFlags imageUsage, int* grallocUsage);

  #define tu_GetSwapchainGrallocUsageANDROID_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetSwapchainGrallocUsageANDROID<X>(VkDevice device, VkFormat format, VkImageUsageFlags imageUsage, int* grallocUsage);

#endif // VK_USE_PLATFORM_ANDROID_KHR
#ifdef VK_USE_PLATFORM_ANDROID_KHR
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetSwapchainGrallocUsage2ANDROID(VkDevice device, VkFormat format, VkImageUsageFlags imageUsage, VkSwapchainImageUsageFlagsANDROID swapchainImageUsage, uint64_t* grallocConsumerUsage, uint64_t* grallocProducerUsage) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetSwapchainGrallocUsage2ANDROID(VkDevice device, VkFormat format, VkImageUsageFlags imageUsage, VkSwapchainImageUsageFlagsANDROID swapchainImageUsage, uint64_t* grallocConsumerUsage, uint64_t* grallocProducerUsage) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetSwapchainGrallocUsage2ANDROID(VkDevice device, VkFormat format, VkImageUsageFlags imageUsage, VkSwapchainImageUsageFlagsANDROID swapchainImageUsage, uint64_t* grallocConsumerUsage, uint64_t* grallocProducerUsage);

  #define tu_GetSwapchainGrallocUsage2ANDROID_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetSwapchainGrallocUsage2ANDROID<X>(VkDevice device, VkFormat format, VkImageUsageFlags imageUsage, VkSwapchainImageUsageFlagsANDROID swapchainImageUsage, uint64_t* grallocConsumerUsage, uint64_t* grallocProducerUsage);

#endif // VK_USE_PLATFORM_ANDROID_KHR
#ifdef VK_USE_PLATFORM_ANDROID_KHR
  VKAPI_ATTR VkResult VKAPI_CALL tu_AcquireImageANDROID(VkDevice device, VkImage image, int nativeFenceFd, VkSemaphore semaphore, VkFence fence) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_AcquireImageANDROID(VkDevice device, VkImage image, int nativeFenceFd, VkSemaphore semaphore, VkFence fence) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_AcquireImageANDROID(VkDevice device, VkImage image, int nativeFenceFd, VkSemaphore semaphore, VkFence fence);

  #define tu_AcquireImageANDROID_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_AcquireImageANDROID<X>(VkDevice device, VkImage image, int nativeFenceFd, VkSemaphore semaphore, VkFence fence);

#endif // VK_USE_PLATFORM_ANDROID_KHR
#ifdef VK_USE_PLATFORM_ANDROID_KHR
  VKAPI_ATTR VkResult VKAPI_CALL tu_QueueSignalReleaseImageANDROID(VkQueue queue, uint32_t waitSemaphoreCount, const VkSemaphore* pWaitSemaphores, VkImage image, int* pNativeFenceFd) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_QueueSignalReleaseImageANDROID(VkQueue queue, uint32_t waitSemaphoreCount, const VkSemaphore* pWaitSemaphores, VkImage image, int* pNativeFenceFd) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_QueueSignalReleaseImageANDROID(VkQueue queue, uint32_t waitSemaphoreCount, const VkSemaphore* pWaitSemaphores, VkImage image, int* pNativeFenceFd);

  #define tu_QueueSignalReleaseImageANDROID_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_QueueSignalReleaseImageANDROID<X>(VkQueue queue, uint32_t waitSemaphoreCount, const VkSemaphore* pWaitSemaphores, VkImage image, int* pNativeFenceFd);

#endif // VK_USE_PLATFORM_ANDROID_KHR
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetShaderInfoAMD(VkDevice device, VkPipeline pipeline, VkShaderStageFlagBits shaderStage, VkShaderInfoTypeAMD infoType, size_t* pInfoSize, void* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetShaderInfoAMD(VkDevice device, VkPipeline pipeline, VkShaderStageFlagBits shaderStage, VkShaderInfoTypeAMD infoType, size_t* pInfoSize, void* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetShaderInfoAMD(VkDevice device, VkPipeline pipeline, VkShaderStageFlagBits shaderStage, VkShaderInfoTypeAMD infoType, size_t* pInfoSize, void* pInfo);

  #define tu_GetShaderInfoAMD_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetShaderInfoAMD<X>(VkDevice device, VkPipeline pipeline, VkShaderStageFlagBits shaderStage, VkShaderInfoTypeAMD infoType, size_t* pInfoSize, void* pInfo);

  VKAPI_ATTR void VKAPI_CALL tu_SetLocalDimmingAMD(VkDevice device, VkSwapchainKHR swapChain, VkBool32 localDimmingEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_SetLocalDimmingAMD(VkDevice device, VkSwapchainKHR swapChain, VkBool32 localDimmingEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_SetLocalDimmingAMD(VkDevice device, VkSwapchainKHR swapChain, VkBool32 localDimmingEnable);

  #define tu_SetLocalDimmingAMD_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_SetLocalDimmingAMD<X>(VkDevice device, VkSwapchainKHR swapChain, VkBool32 localDimmingEnable);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetCalibratedTimestampsKHR(VkDevice device, uint32_t timestampCount, const VkCalibratedTimestampInfoKHR* pTimestampInfos, uint64_t* pTimestamps, uint64_t* pMaxDeviation) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetCalibratedTimestampsKHR(VkDevice device, uint32_t timestampCount, const VkCalibratedTimestampInfoKHR* pTimestampInfos, uint64_t* pTimestamps, uint64_t* pMaxDeviation) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetCalibratedTimestampsKHR(VkDevice device, uint32_t timestampCount, const VkCalibratedTimestampInfoKHR* pTimestampInfos, uint64_t* pTimestamps, uint64_t* pMaxDeviation);

  #define tu_GetCalibratedTimestampsKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetCalibratedTimestampsKHR<X>(VkDevice device, uint32_t timestampCount, const VkCalibratedTimestampInfoKHR* pTimestampInfos, uint64_t* pTimestamps, uint64_t* pMaxDeviation);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetCalibratedTimestampsEXT(VkDevice device, uint32_t timestampCount, const VkCalibratedTimestampInfoKHR* pTimestampInfos, uint64_t* pTimestamps, uint64_t* pMaxDeviation) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetCalibratedTimestampsEXT(VkDevice device, uint32_t timestampCount, const VkCalibratedTimestampInfoKHR* pTimestampInfos, uint64_t* pTimestamps, uint64_t* pMaxDeviation) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetCalibratedTimestampsEXT(VkDevice device, uint32_t timestampCount, const VkCalibratedTimestampInfoKHR* pTimestampInfos, uint64_t* pTimestamps, uint64_t* pMaxDeviation);

  #define tu_GetCalibratedTimestampsEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetCalibratedTimestampsEXT<X>(VkDevice device, uint32_t timestampCount, const VkCalibratedTimestampInfoKHR* pTimestampInfos, uint64_t* pTimestamps, uint64_t* pMaxDeviation);

  VKAPI_ATTR VkResult VKAPI_CALL tu_SetDebugUtilsObjectNameEXT(VkDevice device, const VkDebugUtilsObjectNameInfoEXT* pNameInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_SetDebugUtilsObjectNameEXT(VkDevice device, const VkDebugUtilsObjectNameInfoEXT* pNameInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_SetDebugUtilsObjectNameEXT(VkDevice device, const VkDebugUtilsObjectNameInfoEXT* pNameInfo);

  #define tu_SetDebugUtilsObjectNameEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_SetDebugUtilsObjectNameEXT<X>(VkDevice device, const VkDebugUtilsObjectNameInfoEXT* pNameInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_SetDebugUtilsObjectTagEXT(VkDevice device, const VkDebugUtilsObjectTagInfoEXT* pTagInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_SetDebugUtilsObjectTagEXT(VkDevice device, const VkDebugUtilsObjectTagInfoEXT* pTagInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_SetDebugUtilsObjectTagEXT(VkDevice device, const VkDebugUtilsObjectTagInfoEXT* pTagInfo);

  #define tu_SetDebugUtilsObjectTagEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_SetDebugUtilsObjectTagEXT<X>(VkDevice device, const VkDebugUtilsObjectTagInfoEXT* pTagInfo);

  VKAPI_ATTR void VKAPI_CALL tu_QueueBeginDebugUtilsLabelEXT(VkQueue queue, const VkDebugUtilsLabelEXT* pLabelInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_QueueBeginDebugUtilsLabelEXT(VkQueue queue, const VkDebugUtilsLabelEXT* pLabelInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_QueueBeginDebugUtilsLabelEXT(VkQueue queue, const VkDebugUtilsLabelEXT* pLabelInfo);

  #define tu_QueueBeginDebugUtilsLabelEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_QueueBeginDebugUtilsLabelEXT<X>(VkQueue queue, const VkDebugUtilsLabelEXT* pLabelInfo);

  VKAPI_ATTR void VKAPI_CALL tu_QueueEndDebugUtilsLabelEXT(VkQueue queue) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_QueueEndDebugUtilsLabelEXT(VkQueue queue) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_QueueEndDebugUtilsLabelEXT(VkQueue queue);

  #define tu_QueueEndDebugUtilsLabelEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_QueueEndDebugUtilsLabelEXT<X>(VkQueue queue);

  VKAPI_ATTR void VKAPI_CALL tu_QueueInsertDebugUtilsLabelEXT(VkQueue queue, const VkDebugUtilsLabelEXT* pLabelInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_QueueInsertDebugUtilsLabelEXT(VkQueue queue, const VkDebugUtilsLabelEXT* pLabelInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_QueueInsertDebugUtilsLabelEXT(VkQueue queue, const VkDebugUtilsLabelEXT* pLabelInfo);

  #define tu_QueueInsertDebugUtilsLabelEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_QueueInsertDebugUtilsLabelEXT<X>(VkQueue queue, const VkDebugUtilsLabelEXT* pLabelInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBeginDebugUtilsLabelEXT(VkCommandBuffer commandBuffer, const VkDebugUtilsLabelEXT* pLabelInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBeginDebugUtilsLabelEXT(VkCommandBuffer commandBuffer, const VkDebugUtilsLabelEXT* pLabelInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBeginDebugUtilsLabelEXT(VkCommandBuffer commandBuffer, const VkDebugUtilsLabelEXT* pLabelInfo);

  #define tu_CmdBeginDebugUtilsLabelEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBeginDebugUtilsLabelEXT<X>(VkCommandBuffer commandBuffer, const VkDebugUtilsLabelEXT* pLabelInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdEndDebugUtilsLabelEXT(VkCommandBuffer commandBuffer) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdEndDebugUtilsLabelEXT(VkCommandBuffer commandBuffer) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdEndDebugUtilsLabelEXT(VkCommandBuffer commandBuffer);

  #define tu_CmdEndDebugUtilsLabelEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdEndDebugUtilsLabelEXT<X>(VkCommandBuffer commandBuffer);

  VKAPI_ATTR void VKAPI_CALL tu_CmdInsertDebugUtilsLabelEXT(VkCommandBuffer commandBuffer, const VkDebugUtilsLabelEXT* pLabelInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdInsertDebugUtilsLabelEXT(VkCommandBuffer commandBuffer, const VkDebugUtilsLabelEXT* pLabelInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdInsertDebugUtilsLabelEXT(VkCommandBuffer commandBuffer, const VkDebugUtilsLabelEXT* pLabelInfo);

  #define tu_CmdInsertDebugUtilsLabelEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdInsertDebugUtilsLabelEXT<X>(VkCommandBuffer commandBuffer, const VkDebugUtilsLabelEXT* pLabelInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryHostPointerPropertiesEXT(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, const void* pHostPointer, VkMemoryHostPointerPropertiesEXT* pMemoryHostPointerProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetMemoryHostPointerPropertiesEXT(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, const void* pHostPointer, VkMemoryHostPointerPropertiesEXT* pMemoryHostPointerProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryHostPointerPropertiesEXT(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, const void* pHostPointer, VkMemoryHostPointerPropertiesEXT* pMemoryHostPointerProperties);

  #define tu_GetMemoryHostPointerPropertiesEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryHostPointerPropertiesEXT<X>(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, const void* pHostPointer, VkMemoryHostPointerPropertiesEXT* pMemoryHostPointerProperties);

  VKAPI_ATTR void VKAPI_CALL tu_CmdWriteBufferMarkerAMD(VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkBuffer dstBuffer, VkDeviceSize dstOffset, uint32_t marker) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdWriteBufferMarkerAMD(VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkBuffer dstBuffer, VkDeviceSize dstOffset, uint32_t marker) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdWriteBufferMarkerAMD(VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkBuffer dstBuffer, VkDeviceSize dstOffset, uint32_t marker);

  #define tu_CmdWriteBufferMarkerAMD_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdWriteBufferMarkerAMD<X>(VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage, VkBuffer dstBuffer, VkDeviceSize dstOffset, uint32_t marker);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateRenderPass2(VkDevice device, const VkRenderPassCreateInfo2* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateRenderPass2(VkDevice device, const VkRenderPassCreateInfo2* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateRenderPass2(VkDevice device, const VkRenderPassCreateInfo2* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass);

  #define tu_CreateRenderPass2_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateRenderPass2<X>(VkDevice device, const VkRenderPassCreateInfo2* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateRenderPass2KHR(VkDevice device, const VkRenderPassCreateInfo2* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateRenderPass2KHR(VkDevice device, const VkRenderPassCreateInfo2* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateRenderPass2KHR(VkDevice device, const VkRenderPassCreateInfo2* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass);

  #define tu_CreateRenderPass2KHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateRenderPass2KHR<X>(VkDevice device, const VkRenderPassCreateInfo2* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBeginRenderPass2(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo*      pRenderPassBegin, const VkSubpassBeginInfo*      pSubpassBeginInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBeginRenderPass2(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo*      pRenderPassBegin, const VkSubpassBeginInfo*      pSubpassBeginInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBeginRenderPass2(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo*      pRenderPassBegin, const VkSubpassBeginInfo*      pSubpassBeginInfo);

  #define tu_CmdBeginRenderPass2_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBeginRenderPass2<X>(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo*      pRenderPassBegin, const VkSubpassBeginInfo*      pSubpassBeginInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBeginRenderPass2KHR(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo*      pRenderPassBegin, const VkSubpassBeginInfo*      pSubpassBeginInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBeginRenderPass2KHR(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo*      pRenderPassBegin, const VkSubpassBeginInfo*      pSubpassBeginInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBeginRenderPass2KHR(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo*      pRenderPassBegin, const VkSubpassBeginInfo*      pSubpassBeginInfo);

  #define tu_CmdBeginRenderPass2KHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBeginRenderPass2KHR<X>(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo*      pRenderPassBegin, const VkSubpassBeginInfo*      pSubpassBeginInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdNextSubpass2(VkCommandBuffer commandBuffer, const VkSubpassBeginInfo*      pSubpassBeginInfo, const VkSubpassEndInfo*        pSubpassEndInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdNextSubpass2(VkCommandBuffer commandBuffer, const VkSubpassBeginInfo*      pSubpassBeginInfo, const VkSubpassEndInfo*        pSubpassEndInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdNextSubpass2(VkCommandBuffer commandBuffer, const VkSubpassBeginInfo*      pSubpassBeginInfo, const VkSubpassEndInfo*        pSubpassEndInfo);

  #define tu_CmdNextSubpass2_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdNextSubpass2<X>(VkCommandBuffer commandBuffer, const VkSubpassBeginInfo*      pSubpassBeginInfo, const VkSubpassEndInfo*        pSubpassEndInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdNextSubpass2KHR(VkCommandBuffer commandBuffer, const VkSubpassBeginInfo*      pSubpassBeginInfo, const VkSubpassEndInfo*        pSubpassEndInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdNextSubpass2KHR(VkCommandBuffer commandBuffer, const VkSubpassBeginInfo*      pSubpassBeginInfo, const VkSubpassEndInfo*        pSubpassEndInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdNextSubpass2KHR(VkCommandBuffer commandBuffer, const VkSubpassBeginInfo*      pSubpassBeginInfo, const VkSubpassEndInfo*        pSubpassEndInfo);

  #define tu_CmdNextSubpass2KHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdNextSubpass2KHR<X>(VkCommandBuffer commandBuffer, const VkSubpassBeginInfo*      pSubpassBeginInfo, const VkSubpassEndInfo*        pSubpassEndInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdEndRenderPass2(VkCommandBuffer commandBuffer, const VkSubpassEndInfo*        pSubpassEndInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdEndRenderPass2(VkCommandBuffer commandBuffer, const VkSubpassEndInfo*        pSubpassEndInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdEndRenderPass2(VkCommandBuffer commandBuffer, const VkSubpassEndInfo*        pSubpassEndInfo);

  #define tu_CmdEndRenderPass2_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdEndRenderPass2<X>(VkCommandBuffer commandBuffer, const VkSubpassEndInfo*        pSubpassEndInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdEndRenderPass2KHR(VkCommandBuffer commandBuffer, const VkSubpassEndInfo*        pSubpassEndInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdEndRenderPass2KHR(VkCommandBuffer commandBuffer, const VkSubpassEndInfo*        pSubpassEndInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdEndRenderPass2KHR(VkCommandBuffer commandBuffer, const VkSubpassEndInfo*        pSubpassEndInfo);

  #define tu_CmdEndRenderPass2KHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdEndRenderPass2KHR<X>(VkCommandBuffer commandBuffer, const VkSubpassEndInfo*        pSubpassEndInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetSemaphoreCounterValue(VkDevice device, VkSemaphore semaphore, uint64_t* pValue) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetSemaphoreCounterValue(VkDevice device, VkSemaphore semaphore, uint64_t* pValue) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetSemaphoreCounterValue(VkDevice device, VkSemaphore semaphore, uint64_t* pValue);

  #define tu_GetSemaphoreCounterValue_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetSemaphoreCounterValue<X>(VkDevice device, VkSemaphore semaphore, uint64_t* pValue);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetSemaphoreCounterValueKHR(VkDevice device, VkSemaphore semaphore, uint64_t* pValue) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetSemaphoreCounterValueKHR(VkDevice device, VkSemaphore semaphore, uint64_t* pValue) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetSemaphoreCounterValueKHR(VkDevice device, VkSemaphore semaphore, uint64_t* pValue);

  #define tu_GetSemaphoreCounterValueKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetSemaphoreCounterValueKHR<X>(VkDevice device, VkSemaphore semaphore, uint64_t* pValue);

  VKAPI_ATTR VkResult VKAPI_CALL tu_WaitSemaphores(VkDevice device, const VkSemaphoreWaitInfo* pWaitInfo, uint64_t timeout) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_WaitSemaphores(VkDevice device, const VkSemaphoreWaitInfo* pWaitInfo, uint64_t timeout) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_WaitSemaphores(VkDevice device, const VkSemaphoreWaitInfo* pWaitInfo, uint64_t timeout);

  #define tu_WaitSemaphores_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_WaitSemaphores<X>(VkDevice device, const VkSemaphoreWaitInfo* pWaitInfo, uint64_t timeout);

  VKAPI_ATTR VkResult VKAPI_CALL tu_WaitSemaphoresKHR(VkDevice device, const VkSemaphoreWaitInfo* pWaitInfo, uint64_t timeout) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_WaitSemaphoresKHR(VkDevice device, const VkSemaphoreWaitInfo* pWaitInfo, uint64_t timeout) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_WaitSemaphoresKHR(VkDevice device, const VkSemaphoreWaitInfo* pWaitInfo, uint64_t timeout);

  #define tu_WaitSemaphoresKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_WaitSemaphoresKHR<X>(VkDevice device, const VkSemaphoreWaitInfo* pWaitInfo, uint64_t timeout);

  VKAPI_ATTR VkResult VKAPI_CALL tu_SignalSemaphore(VkDevice device, const VkSemaphoreSignalInfo* pSignalInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_SignalSemaphore(VkDevice device, const VkSemaphoreSignalInfo* pSignalInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_SignalSemaphore(VkDevice device, const VkSemaphoreSignalInfo* pSignalInfo);

  #define tu_SignalSemaphore_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_SignalSemaphore<X>(VkDevice device, const VkSemaphoreSignalInfo* pSignalInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_SignalSemaphoreKHR(VkDevice device, const VkSemaphoreSignalInfo* pSignalInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_SignalSemaphoreKHR(VkDevice device, const VkSemaphoreSignalInfo* pSignalInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_SignalSemaphoreKHR(VkDevice device, const VkSemaphoreSignalInfo* pSignalInfo);

  #define tu_SignalSemaphoreKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_SignalSemaphoreKHR<X>(VkDevice device, const VkSemaphoreSignalInfo* pSignalInfo);

#ifdef VK_USE_PLATFORM_ANDROID_KHR
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetAndroidHardwareBufferPropertiesANDROID(VkDevice device, const struct AHardwareBuffer* buffer, VkAndroidHardwareBufferPropertiesANDROID* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetAndroidHardwareBufferPropertiesANDROID(VkDevice device, const struct AHardwareBuffer* buffer, VkAndroidHardwareBufferPropertiesANDROID* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetAndroidHardwareBufferPropertiesANDROID(VkDevice device, const struct AHardwareBuffer* buffer, VkAndroidHardwareBufferPropertiesANDROID* pProperties);

  #define tu_GetAndroidHardwareBufferPropertiesANDROID_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetAndroidHardwareBufferPropertiesANDROID<X>(VkDevice device, const struct AHardwareBuffer* buffer, VkAndroidHardwareBufferPropertiesANDROID* pProperties);

#endif // VK_USE_PLATFORM_ANDROID_KHR
#ifdef VK_USE_PLATFORM_ANDROID_KHR
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryAndroidHardwareBufferANDROID(VkDevice device, const VkMemoryGetAndroidHardwareBufferInfoANDROID* pInfo, struct AHardwareBuffer** pBuffer) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetMemoryAndroidHardwareBufferANDROID(VkDevice device, const VkMemoryGetAndroidHardwareBufferInfoANDROID* pInfo, struct AHardwareBuffer** pBuffer) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryAndroidHardwareBufferANDROID(VkDevice device, const VkMemoryGetAndroidHardwareBufferInfoANDROID* pInfo, struct AHardwareBuffer** pBuffer);

  #define tu_GetMemoryAndroidHardwareBufferANDROID_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryAndroidHardwareBufferANDROID<X>(VkDevice device, const VkMemoryGetAndroidHardwareBufferInfoANDROID* pInfo, struct AHardwareBuffer** pBuffer);

#endif // VK_USE_PLATFORM_ANDROID_KHR
  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawIndirectCount(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDrawIndirectCount(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawIndirectCount(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride);

  #define tu_CmdDrawIndirectCount_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDrawIndirectCount<X>(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride);

  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawIndirectCountKHR(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDrawIndirectCountKHR(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawIndirectCountKHR(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride);

  #define tu_CmdDrawIndirectCountKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDrawIndirectCountKHR<X>(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride);

  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawIndirectCountAMD(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDrawIndirectCountAMD(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawIndirectCountAMD(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride);

  #define tu_CmdDrawIndirectCountAMD_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDrawIndirectCountAMD<X>(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride);

  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawIndexedIndirectCount(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDrawIndexedIndirectCount(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawIndexedIndirectCount(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride);

  #define tu_CmdDrawIndexedIndirectCount_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDrawIndexedIndirectCount<X>(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride);

  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawIndexedIndirectCountKHR(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDrawIndexedIndirectCountKHR(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawIndexedIndirectCountKHR(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride);

  #define tu_CmdDrawIndexedIndirectCountKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDrawIndexedIndirectCountKHR<X>(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride);

  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawIndexedIndirectCountAMD(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDrawIndexedIndirectCountAMD(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawIndexedIndirectCountAMD(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride);

  #define tu_CmdDrawIndexedIndirectCountAMD_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDrawIndexedIndirectCountAMD<X>(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetCheckpointNV(VkCommandBuffer commandBuffer, const void* pCheckpointMarker) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetCheckpointNV(VkCommandBuffer commandBuffer, const void* pCheckpointMarker) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetCheckpointNV(VkCommandBuffer commandBuffer, const void* pCheckpointMarker);

  #define tu_CmdSetCheckpointNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetCheckpointNV<X>(VkCommandBuffer commandBuffer, const void* pCheckpointMarker);

  VKAPI_ATTR void VKAPI_CALL tu_GetQueueCheckpointDataNV(VkQueue queue, uint32_t* pCheckpointDataCount, VkCheckpointDataNV* pCheckpointData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetQueueCheckpointDataNV(VkQueue queue, uint32_t* pCheckpointDataCount, VkCheckpointDataNV* pCheckpointData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetQueueCheckpointDataNV(VkQueue queue, uint32_t* pCheckpointDataCount, VkCheckpointDataNV* pCheckpointData);

  #define tu_GetQueueCheckpointDataNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetQueueCheckpointDataNV<X>(VkQueue queue, uint32_t* pCheckpointDataCount, VkCheckpointDataNV* pCheckpointData);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBindTransformFeedbackBuffersEXT(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBindTransformFeedbackBuffersEXT(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBindTransformFeedbackBuffersEXT(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes);

  #define tu_CmdBindTransformFeedbackBuffersEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBindTransformFeedbackBuffersEXT<X>(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBeginTransformFeedbackEXT(VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBeginTransformFeedbackEXT(VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBeginTransformFeedbackEXT(VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets);

  #define tu_CmdBeginTransformFeedbackEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBeginTransformFeedbackEXT<X>(VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets);

  VKAPI_ATTR void VKAPI_CALL tu_CmdEndTransformFeedbackEXT(VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdEndTransformFeedbackEXT(VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdEndTransformFeedbackEXT(VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets);

  #define tu_CmdEndTransformFeedbackEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdEndTransformFeedbackEXT<X>(VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer, uint32_t counterBufferCount, const VkBuffer* pCounterBuffers, const VkDeviceSize* pCounterBufferOffsets);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBeginQueryIndexedEXT(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags, uint32_t index) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBeginQueryIndexedEXT(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags, uint32_t index) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBeginQueryIndexedEXT(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags, uint32_t index);

  #define tu_CmdBeginQueryIndexedEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBeginQueryIndexedEXT<X>(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, VkQueryControlFlags flags, uint32_t index);

  VKAPI_ATTR void VKAPI_CALL tu_CmdEndQueryIndexedEXT(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, uint32_t index) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdEndQueryIndexedEXT(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, uint32_t index) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdEndQueryIndexedEXT(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, uint32_t index);

  #define tu_CmdEndQueryIndexedEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdEndQueryIndexedEXT<X>(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query, uint32_t index);

  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawIndirectByteCountEXT(VkCommandBuffer commandBuffer, uint32_t instanceCount, uint32_t firstInstance, VkBuffer counterBuffer, VkDeviceSize counterBufferOffset, uint32_t counterOffset, uint32_t vertexStride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDrawIndirectByteCountEXT(VkCommandBuffer commandBuffer, uint32_t instanceCount, uint32_t firstInstance, VkBuffer counterBuffer, VkDeviceSize counterBufferOffset, uint32_t counterOffset, uint32_t vertexStride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawIndirectByteCountEXT(VkCommandBuffer commandBuffer, uint32_t instanceCount, uint32_t firstInstance, VkBuffer counterBuffer, VkDeviceSize counterBufferOffset, uint32_t counterOffset, uint32_t vertexStride);

  #define tu_CmdDrawIndirectByteCountEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDrawIndirectByteCountEXT<X>(VkCommandBuffer commandBuffer, uint32_t instanceCount, uint32_t firstInstance, VkBuffer counterBuffer, VkDeviceSize counterBufferOffset, uint32_t counterOffset, uint32_t vertexStride);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetExclusiveScissorNV(VkCommandBuffer commandBuffer, uint32_t firstExclusiveScissor, uint32_t exclusiveScissorCount, const VkRect2D* pExclusiveScissors) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetExclusiveScissorNV(VkCommandBuffer commandBuffer, uint32_t firstExclusiveScissor, uint32_t exclusiveScissorCount, const VkRect2D* pExclusiveScissors) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetExclusiveScissorNV(VkCommandBuffer commandBuffer, uint32_t firstExclusiveScissor, uint32_t exclusiveScissorCount, const VkRect2D* pExclusiveScissors);

  #define tu_CmdSetExclusiveScissorNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetExclusiveScissorNV<X>(VkCommandBuffer commandBuffer, uint32_t firstExclusiveScissor, uint32_t exclusiveScissorCount, const VkRect2D* pExclusiveScissors);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetExclusiveScissorEnableNV(VkCommandBuffer commandBuffer, uint32_t firstExclusiveScissor, uint32_t exclusiveScissorCount, const VkBool32* pExclusiveScissorEnables) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetExclusiveScissorEnableNV(VkCommandBuffer commandBuffer, uint32_t firstExclusiveScissor, uint32_t exclusiveScissorCount, const VkBool32* pExclusiveScissorEnables) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetExclusiveScissorEnableNV(VkCommandBuffer commandBuffer, uint32_t firstExclusiveScissor, uint32_t exclusiveScissorCount, const VkBool32* pExclusiveScissorEnables);

  #define tu_CmdSetExclusiveScissorEnableNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetExclusiveScissorEnableNV<X>(VkCommandBuffer commandBuffer, uint32_t firstExclusiveScissor, uint32_t exclusiveScissorCount, const VkBool32* pExclusiveScissorEnables);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBindShadingRateImageNV(VkCommandBuffer commandBuffer, VkImageView imageView, VkImageLayout imageLayout) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBindShadingRateImageNV(VkCommandBuffer commandBuffer, VkImageView imageView, VkImageLayout imageLayout) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBindShadingRateImageNV(VkCommandBuffer commandBuffer, VkImageView imageView, VkImageLayout imageLayout);

  #define tu_CmdBindShadingRateImageNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBindShadingRateImageNV<X>(VkCommandBuffer commandBuffer, VkImageView imageView, VkImageLayout imageLayout);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetViewportShadingRatePaletteNV(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkShadingRatePaletteNV* pShadingRatePalettes) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetViewportShadingRatePaletteNV(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkShadingRatePaletteNV* pShadingRatePalettes) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetViewportShadingRatePaletteNV(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkShadingRatePaletteNV* pShadingRatePalettes);

  #define tu_CmdSetViewportShadingRatePaletteNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetViewportShadingRatePaletteNV<X>(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkShadingRatePaletteNV* pShadingRatePalettes);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetCoarseSampleOrderNV(VkCommandBuffer commandBuffer, VkCoarseSampleOrderTypeNV sampleOrderType, uint32_t customSampleOrderCount, const VkCoarseSampleOrderCustomNV* pCustomSampleOrders) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetCoarseSampleOrderNV(VkCommandBuffer commandBuffer, VkCoarseSampleOrderTypeNV sampleOrderType, uint32_t customSampleOrderCount, const VkCoarseSampleOrderCustomNV* pCustomSampleOrders) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetCoarseSampleOrderNV(VkCommandBuffer commandBuffer, VkCoarseSampleOrderTypeNV sampleOrderType, uint32_t customSampleOrderCount, const VkCoarseSampleOrderCustomNV* pCustomSampleOrders);

  #define tu_CmdSetCoarseSampleOrderNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetCoarseSampleOrderNV<X>(VkCommandBuffer commandBuffer, VkCoarseSampleOrderTypeNV sampleOrderType, uint32_t customSampleOrderCount, const VkCoarseSampleOrderCustomNV* pCustomSampleOrders);

  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawMeshTasksNV(VkCommandBuffer commandBuffer, uint32_t taskCount, uint32_t firstTask) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDrawMeshTasksNV(VkCommandBuffer commandBuffer, uint32_t taskCount, uint32_t firstTask) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawMeshTasksNV(VkCommandBuffer commandBuffer, uint32_t taskCount, uint32_t firstTask);

  #define tu_CmdDrawMeshTasksNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDrawMeshTasksNV<X>(VkCommandBuffer commandBuffer, uint32_t taskCount, uint32_t firstTask);

  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawMeshTasksIndirectNV(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDrawMeshTasksIndirectNV(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawMeshTasksIndirectNV(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride);

  #define tu_CmdDrawMeshTasksIndirectNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDrawMeshTasksIndirectNV<X>(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride);

  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawMeshTasksIndirectCountNV(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDrawMeshTasksIndirectCountNV(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawMeshTasksIndirectCountNV(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride);

  #define tu_CmdDrawMeshTasksIndirectCountNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDrawMeshTasksIndirectCountNV<X>(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride);

  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawMeshTasksEXT(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDrawMeshTasksEXT(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawMeshTasksEXT(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ);

  #define tu_CmdDrawMeshTasksEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDrawMeshTasksEXT<X>(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ);

  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawMeshTasksIndirectEXT(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDrawMeshTasksIndirectEXT(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawMeshTasksIndirectEXT(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride);

  #define tu_CmdDrawMeshTasksIndirectEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDrawMeshTasksIndirectEXT<X>(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount, uint32_t stride);

  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawMeshTasksIndirectCountEXT(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDrawMeshTasksIndirectCountEXT(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDrawMeshTasksIndirectCountEXT(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride);

  #define tu_CmdDrawMeshTasksIndirectCountEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDrawMeshTasksIndirectCountEXT<X>(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount, uint32_t stride);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CompileDeferredNV(VkDevice device, VkPipeline pipeline, uint32_t shader) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CompileDeferredNV(VkDevice device, VkPipeline pipeline, uint32_t shader) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CompileDeferredNV(VkDevice device, VkPipeline pipeline, uint32_t shader);

  #define tu_CompileDeferredNV_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CompileDeferredNV<X>(VkDevice device, VkPipeline pipeline, uint32_t shader);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateAccelerationStructureNV(VkDevice device, const VkAccelerationStructureCreateInfoNV* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkAccelerationStructureNV* pAccelerationStructure) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateAccelerationStructureNV(VkDevice device, const VkAccelerationStructureCreateInfoNV* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkAccelerationStructureNV* pAccelerationStructure) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateAccelerationStructureNV(VkDevice device, const VkAccelerationStructureCreateInfoNV* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkAccelerationStructureNV* pAccelerationStructure);

  #define tu_CreateAccelerationStructureNV_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateAccelerationStructureNV<X>(VkDevice device, const VkAccelerationStructureCreateInfoNV* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkAccelerationStructureNV* pAccelerationStructure);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBindInvocationMaskHUAWEI(VkCommandBuffer commandBuffer, VkImageView imageView, VkImageLayout imageLayout) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBindInvocationMaskHUAWEI(VkCommandBuffer commandBuffer, VkImageView imageView, VkImageLayout imageLayout) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBindInvocationMaskHUAWEI(VkCommandBuffer commandBuffer, VkImageView imageView, VkImageLayout imageLayout);

  #define tu_CmdBindInvocationMaskHUAWEI_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBindInvocationMaskHUAWEI<X>(VkCommandBuffer commandBuffer, VkImageView imageView, VkImageLayout imageLayout);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyAccelerationStructureKHR(VkDevice device, VkAccelerationStructureKHR accelerationStructure, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyAccelerationStructureKHR(VkDevice device, VkAccelerationStructureKHR accelerationStructure, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyAccelerationStructureKHR(VkDevice device, VkAccelerationStructureKHR accelerationStructure, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyAccelerationStructureKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyAccelerationStructureKHR<X>(VkDevice device, VkAccelerationStructureKHR accelerationStructure, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyAccelerationStructureNV(VkDevice device, VkAccelerationStructureNV accelerationStructure, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyAccelerationStructureNV(VkDevice device, VkAccelerationStructureNV accelerationStructure, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyAccelerationStructureNV(VkDevice device, VkAccelerationStructureNV accelerationStructure, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyAccelerationStructureNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyAccelerationStructureNV<X>(VkDevice device, VkAccelerationStructureNV accelerationStructure, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR void VKAPI_CALL tu_GetAccelerationStructureMemoryRequirementsNV(VkDevice device, const VkAccelerationStructureMemoryRequirementsInfoNV* pInfo, VkMemoryRequirements2KHR* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetAccelerationStructureMemoryRequirementsNV(VkDevice device, const VkAccelerationStructureMemoryRequirementsInfoNV* pInfo, VkMemoryRequirements2KHR* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetAccelerationStructureMemoryRequirementsNV(VkDevice device, const VkAccelerationStructureMemoryRequirementsInfoNV* pInfo, VkMemoryRequirements2KHR* pMemoryRequirements);

  #define tu_GetAccelerationStructureMemoryRequirementsNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetAccelerationStructureMemoryRequirementsNV<X>(VkDevice device, const VkAccelerationStructureMemoryRequirementsInfoNV* pInfo, VkMemoryRequirements2KHR* pMemoryRequirements);

  VKAPI_ATTR VkResult VKAPI_CALL tu_BindAccelerationStructureMemoryNV(VkDevice device, uint32_t bindInfoCount, const VkBindAccelerationStructureMemoryInfoNV* pBindInfos) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_BindAccelerationStructureMemoryNV(VkDevice device, uint32_t bindInfoCount, const VkBindAccelerationStructureMemoryInfoNV* pBindInfos) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_BindAccelerationStructureMemoryNV(VkDevice device, uint32_t bindInfoCount, const VkBindAccelerationStructureMemoryInfoNV* pBindInfos);

  #define tu_BindAccelerationStructureMemoryNV_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_BindAccelerationStructureMemoryNV<X>(VkDevice device, uint32_t bindInfoCount, const VkBindAccelerationStructureMemoryInfoNV* pBindInfos);

  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyAccelerationStructureNV(VkCommandBuffer commandBuffer, VkAccelerationStructureNV dst, VkAccelerationStructureNV src, VkCopyAccelerationStructureModeKHR mode) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdCopyAccelerationStructureNV(VkCommandBuffer commandBuffer, VkAccelerationStructureNV dst, VkAccelerationStructureNV src, VkCopyAccelerationStructureModeKHR mode) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyAccelerationStructureNV(VkCommandBuffer commandBuffer, VkAccelerationStructureNV dst, VkAccelerationStructureNV src, VkCopyAccelerationStructureModeKHR mode);

  #define tu_CmdCopyAccelerationStructureNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdCopyAccelerationStructureNV<X>(VkCommandBuffer commandBuffer, VkAccelerationStructureNV dst, VkAccelerationStructureNV src, VkCopyAccelerationStructureModeKHR mode);

  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyAccelerationStructureKHR(VkCommandBuffer commandBuffer, const VkCopyAccelerationStructureInfoKHR* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdCopyAccelerationStructureKHR(VkCommandBuffer commandBuffer, const VkCopyAccelerationStructureInfoKHR* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyAccelerationStructureKHR(VkCommandBuffer commandBuffer, const VkCopyAccelerationStructureInfoKHR* pInfo);

  #define tu_CmdCopyAccelerationStructureKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdCopyAccelerationStructureKHR<X>(VkCommandBuffer commandBuffer, const VkCopyAccelerationStructureInfoKHR* pInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CopyAccelerationStructureKHR(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyAccelerationStructureInfoKHR* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CopyAccelerationStructureKHR(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyAccelerationStructureInfoKHR* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CopyAccelerationStructureKHR(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyAccelerationStructureInfoKHR* pInfo);

  #define tu_CopyAccelerationStructureKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CopyAccelerationStructureKHR<X>(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyAccelerationStructureInfoKHR* pInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyAccelerationStructureToMemoryKHR(VkCommandBuffer commandBuffer, const VkCopyAccelerationStructureToMemoryInfoKHR* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdCopyAccelerationStructureToMemoryKHR(VkCommandBuffer commandBuffer, const VkCopyAccelerationStructureToMemoryInfoKHR* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyAccelerationStructureToMemoryKHR(VkCommandBuffer commandBuffer, const VkCopyAccelerationStructureToMemoryInfoKHR* pInfo);

  #define tu_CmdCopyAccelerationStructureToMemoryKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdCopyAccelerationStructureToMemoryKHR<X>(VkCommandBuffer commandBuffer, const VkCopyAccelerationStructureToMemoryInfoKHR* pInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CopyAccelerationStructureToMemoryKHR(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyAccelerationStructureToMemoryInfoKHR* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CopyAccelerationStructureToMemoryKHR(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyAccelerationStructureToMemoryInfoKHR* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CopyAccelerationStructureToMemoryKHR(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyAccelerationStructureToMemoryInfoKHR* pInfo);

  #define tu_CopyAccelerationStructureToMemoryKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CopyAccelerationStructureToMemoryKHR<X>(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyAccelerationStructureToMemoryInfoKHR* pInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyMemoryToAccelerationStructureKHR(VkCommandBuffer commandBuffer, const VkCopyMemoryToAccelerationStructureInfoKHR* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdCopyMemoryToAccelerationStructureKHR(VkCommandBuffer commandBuffer, const VkCopyMemoryToAccelerationStructureInfoKHR* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyMemoryToAccelerationStructureKHR(VkCommandBuffer commandBuffer, const VkCopyMemoryToAccelerationStructureInfoKHR* pInfo);

  #define tu_CmdCopyMemoryToAccelerationStructureKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdCopyMemoryToAccelerationStructureKHR<X>(VkCommandBuffer commandBuffer, const VkCopyMemoryToAccelerationStructureInfoKHR* pInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CopyMemoryToAccelerationStructureKHR(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyMemoryToAccelerationStructureInfoKHR* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CopyMemoryToAccelerationStructureKHR(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyMemoryToAccelerationStructureInfoKHR* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CopyMemoryToAccelerationStructureKHR(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyMemoryToAccelerationStructureInfoKHR* pInfo);

  #define tu_CopyMemoryToAccelerationStructureKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CopyMemoryToAccelerationStructureKHR<X>(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyMemoryToAccelerationStructureInfoKHR* pInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdWriteAccelerationStructuresPropertiesKHR(VkCommandBuffer commandBuffer, uint32_t accelerationStructureCount, const VkAccelerationStructureKHR* pAccelerationStructures, VkQueryType queryType, VkQueryPool queryPool, uint32_t firstQuery) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdWriteAccelerationStructuresPropertiesKHR(VkCommandBuffer commandBuffer, uint32_t accelerationStructureCount, const VkAccelerationStructureKHR* pAccelerationStructures, VkQueryType queryType, VkQueryPool queryPool, uint32_t firstQuery) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdWriteAccelerationStructuresPropertiesKHR(VkCommandBuffer commandBuffer, uint32_t accelerationStructureCount, const VkAccelerationStructureKHR* pAccelerationStructures, VkQueryType queryType, VkQueryPool queryPool, uint32_t firstQuery);

  #define tu_CmdWriteAccelerationStructuresPropertiesKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdWriteAccelerationStructuresPropertiesKHR<X>(VkCommandBuffer commandBuffer, uint32_t accelerationStructureCount, const VkAccelerationStructureKHR* pAccelerationStructures, VkQueryType queryType, VkQueryPool queryPool, uint32_t firstQuery);

  VKAPI_ATTR void VKAPI_CALL tu_CmdWriteAccelerationStructuresPropertiesNV(VkCommandBuffer commandBuffer, uint32_t accelerationStructureCount, const VkAccelerationStructureNV* pAccelerationStructures, VkQueryType queryType, VkQueryPool queryPool, uint32_t firstQuery) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdWriteAccelerationStructuresPropertiesNV(VkCommandBuffer commandBuffer, uint32_t accelerationStructureCount, const VkAccelerationStructureNV* pAccelerationStructures, VkQueryType queryType, VkQueryPool queryPool, uint32_t firstQuery) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdWriteAccelerationStructuresPropertiesNV(VkCommandBuffer commandBuffer, uint32_t accelerationStructureCount, const VkAccelerationStructureNV* pAccelerationStructures, VkQueryType queryType, VkQueryPool queryPool, uint32_t firstQuery);

  #define tu_CmdWriteAccelerationStructuresPropertiesNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdWriteAccelerationStructuresPropertiesNV<X>(VkCommandBuffer commandBuffer, uint32_t accelerationStructureCount, const VkAccelerationStructureNV* pAccelerationStructures, VkQueryType queryType, VkQueryPool queryPool, uint32_t firstQuery);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBuildAccelerationStructureNV(VkCommandBuffer commandBuffer, const VkAccelerationStructureInfoNV* pInfo, VkBuffer instanceData, VkDeviceSize instanceOffset, VkBool32 update, VkAccelerationStructureNV dst, VkAccelerationStructureNV src, VkBuffer scratch, VkDeviceSize scratchOffset) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBuildAccelerationStructureNV(VkCommandBuffer commandBuffer, const VkAccelerationStructureInfoNV* pInfo, VkBuffer instanceData, VkDeviceSize instanceOffset, VkBool32 update, VkAccelerationStructureNV dst, VkAccelerationStructureNV src, VkBuffer scratch, VkDeviceSize scratchOffset) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBuildAccelerationStructureNV(VkCommandBuffer commandBuffer, const VkAccelerationStructureInfoNV* pInfo, VkBuffer instanceData, VkDeviceSize instanceOffset, VkBool32 update, VkAccelerationStructureNV dst, VkAccelerationStructureNV src, VkBuffer scratch, VkDeviceSize scratchOffset);

  #define tu_CmdBuildAccelerationStructureNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBuildAccelerationStructureNV<X>(VkCommandBuffer commandBuffer, const VkAccelerationStructureInfoNV* pInfo, VkBuffer instanceData, VkDeviceSize instanceOffset, VkBool32 update, VkAccelerationStructureNV dst, VkAccelerationStructureNV src, VkBuffer scratch, VkDeviceSize scratchOffset);

  VKAPI_ATTR VkResult VKAPI_CALL tu_WriteAccelerationStructuresPropertiesKHR(VkDevice device, uint32_t accelerationStructureCount, const VkAccelerationStructureKHR* pAccelerationStructures, VkQueryType  queryType, size_t       dataSize, void* pData, size_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_WriteAccelerationStructuresPropertiesKHR(VkDevice device, uint32_t accelerationStructureCount, const VkAccelerationStructureKHR* pAccelerationStructures, VkQueryType  queryType, size_t       dataSize, void* pData, size_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_WriteAccelerationStructuresPropertiesKHR(VkDevice device, uint32_t accelerationStructureCount, const VkAccelerationStructureKHR* pAccelerationStructures, VkQueryType  queryType, size_t       dataSize, void* pData, size_t stride);

  #define tu_WriteAccelerationStructuresPropertiesKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_WriteAccelerationStructuresPropertiesKHR<X>(VkDevice device, uint32_t accelerationStructureCount, const VkAccelerationStructureKHR* pAccelerationStructures, VkQueryType  queryType, size_t       dataSize, void* pData, size_t stride);

  VKAPI_ATTR void VKAPI_CALL tu_CmdTraceRaysKHR(VkCommandBuffer commandBuffer, const VkStridedDeviceAddressRegionKHR* pRaygenShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pMissShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pHitShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pCallableShaderBindingTable, uint32_t width, uint32_t height, uint32_t depth) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdTraceRaysKHR(VkCommandBuffer commandBuffer, const VkStridedDeviceAddressRegionKHR* pRaygenShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pMissShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pHitShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pCallableShaderBindingTable, uint32_t width, uint32_t height, uint32_t depth) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdTraceRaysKHR(VkCommandBuffer commandBuffer, const VkStridedDeviceAddressRegionKHR* pRaygenShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pMissShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pHitShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pCallableShaderBindingTable, uint32_t width, uint32_t height, uint32_t depth);

  #define tu_CmdTraceRaysKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdTraceRaysKHR<X>(VkCommandBuffer commandBuffer, const VkStridedDeviceAddressRegionKHR* pRaygenShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pMissShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pHitShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pCallableShaderBindingTable, uint32_t width, uint32_t height, uint32_t depth);

  VKAPI_ATTR void VKAPI_CALL tu_CmdTraceRaysNV(VkCommandBuffer commandBuffer, VkBuffer raygenShaderBindingTableBuffer, VkDeviceSize raygenShaderBindingOffset, VkBuffer missShaderBindingTableBuffer, VkDeviceSize missShaderBindingOffset, VkDeviceSize missShaderBindingStride, VkBuffer hitShaderBindingTableBuffer, VkDeviceSize hitShaderBindingOffset, VkDeviceSize hitShaderBindingStride, VkBuffer callableShaderBindingTableBuffer, VkDeviceSize callableShaderBindingOffset, VkDeviceSize callableShaderBindingStride, uint32_t width, uint32_t height, uint32_t depth) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdTraceRaysNV(VkCommandBuffer commandBuffer, VkBuffer raygenShaderBindingTableBuffer, VkDeviceSize raygenShaderBindingOffset, VkBuffer missShaderBindingTableBuffer, VkDeviceSize missShaderBindingOffset, VkDeviceSize missShaderBindingStride, VkBuffer hitShaderBindingTableBuffer, VkDeviceSize hitShaderBindingOffset, VkDeviceSize hitShaderBindingStride, VkBuffer callableShaderBindingTableBuffer, VkDeviceSize callableShaderBindingOffset, VkDeviceSize callableShaderBindingStride, uint32_t width, uint32_t height, uint32_t depth) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdTraceRaysNV(VkCommandBuffer commandBuffer, VkBuffer raygenShaderBindingTableBuffer, VkDeviceSize raygenShaderBindingOffset, VkBuffer missShaderBindingTableBuffer, VkDeviceSize missShaderBindingOffset, VkDeviceSize missShaderBindingStride, VkBuffer hitShaderBindingTableBuffer, VkDeviceSize hitShaderBindingOffset, VkDeviceSize hitShaderBindingStride, VkBuffer callableShaderBindingTableBuffer, VkDeviceSize callableShaderBindingOffset, VkDeviceSize callableShaderBindingStride, uint32_t width, uint32_t height, uint32_t depth);

  #define tu_CmdTraceRaysNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdTraceRaysNV<X>(VkCommandBuffer commandBuffer, VkBuffer raygenShaderBindingTableBuffer, VkDeviceSize raygenShaderBindingOffset, VkBuffer missShaderBindingTableBuffer, VkDeviceSize missShaderBindingOffset, VkDeviceSize missShaderBindingStride, VkBuffer hitShaderBindingTableBuffer, VkDeviceSize hitShaderBindingOffset, VkDeviceSize hitShaderBindingStride, VkBuffer callableShaderBindingTableBuffer, VkDeviceSize callableShaderBindingOffset, VkDeviceSize callableShaderBindingStride, uint32_t width, uint32_t height, uint32_t depth);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetRayTracingShaderGroupHandlesKHR(VkDevice device, VkPipeline pipeline, uint32_t firstGroup, uint32_t groupCount, size_t dataSize, void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetRayTracingShaderGroupHandlesKHR(VkDevice device, VkPipeline pipeline, uint32_t firstGroup, uint32_t groupCount, size_t dataSize, void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetRayTracingShaderGroupHandlesKHR(VkDevice device, VkPipeline pipeline, uint32_t firstGroup, uint32_t groupCount, size_t dataSize, void* pData);

  #define tu_GetRayTracingShaderGroupHandlesKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetRayTracingShaderGroupHandlesKHR<X>(VkDevice device, VkPipeline pipeline, uint32_t firstGroup, uint32_t groupCount, size_t dataSize, void* pData);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetRayTracingShaderGroupHandlesNV(VkDevice device, VkPipeline pipeline, uint32_t firstGroup, uint32_t groupCount, size_t dataSize, void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetRayTracingShaderGroupHandlesNV(VkDevice device, VkPipeline pipeline, uint32_t firstGroup, uint32_t groupCount, size_t dataSize, void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetRayTracingShaderGroupHandlesNV(VkDevice device, VkPipeline pipeline, uint32_t firstGroup, uint32_t groupCount, size_t dataSize, void* pData);

  #define tu_GetRayTracingShaderGroupHandlesNV_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetRayTracingShaderGroupHandlesNV<X>(VkDevice device, VkPipeline pipeline, uint32_t firstGroup, uint32_t groupCount, size_t dataSize, void* pData);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetRayTracingCaptureReplayShaderGroupHandlesKHR(VkDevice device, VkPipeline pipeline, uint32_t firstGroup, uint32_t groupCount, size_t dataSize, void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetRayTracingCaptureReplayShaderGroupHandlesKHR(VkDevice device, VkPipeline pipeline, uint32_t firstGroup, uint32_t groupCount, size_t dataSize, void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetRayTracingCaptureReplayShaderGroupHandlesKHR(VkDevice device, VkPipeline pipeline, uint32_t firstGroup, uint32_t groupCount, size_t dataSize, void* pData);

  #define tu_GetRayTracingCaptureReplayShaderGroupHandlesKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetRayTracingCaptureReplayShaderGroupHandlesKHR<X>(VkDevice device, VkPipeline pipeline, uint32_t firstGroup, uint32_t groupCount, size_t dataSize, void* pData);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetAccelerationStructureHandleNV(VkDevice device, VkAccelerationStructureNV accelerationStructure, size_t dataSize, void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetAccelerationStructureHandleNV(VkDevice device, VkAccelerationStructureNV accelerationStructure, size_t dataSize, void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetAccelerationStructureHandleNV(VkDevice device, VkAccelerationStructureNV accelerationStructure, size_t dataSize, void* pData);

  #define tu_GetAccelerationStructureHandleNV_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetAccelerationStructureHandleNV<X>(VkDevice device, VkAccelerationStructureNV accelerationStructure, size_t dataSize, void* pData);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateRayTracingPipelinesNV(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkRayTracingPipelineCreateInfoNV* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateRayTracingPipelinesNV(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkRayTracingPipelineCreateInfoNV* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateRayTracingPipelinesNV(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkRayTracingPipelineCreateInfoNV* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines);

  #define tu_CreateRayTracingPipelinesNV_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateRayTracingPipelinesNV<X>(VkDevice device, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkRayTracingPipelineCreateInfoNV* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateRayTracingPipelinesKHR(VkDevice device, VkDeferredOperationKHR deferredOperation, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkRayTracingPipelineCreateInfoKHR* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateRayTracingPipelinesKHR(VkDevice device, VkDeferredOperationKHR deferredOperation, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkRayTracingPipelineCreateInfoKHR* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateRayTracingPipelinesKHR(VkDevice device, VkDeferredOperationKHR deferredOperation, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkRayTracingPipelineCreateInfoKHR* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines);

  #define tu_CreateRayTracingPipelinesKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateRayTracingPipelinesKHR<X>(VkDevice device, VkDeferredOperationKHR deferredOperation, VkPipelineCache pipelineCache, uint32_t createInfoCount, const VkRayTracingPipelineCreateInfoKHR* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines);

  VKAPI_ATTR void VKAPI_CALL tu_CmdTraceRaysIndirectKHR(VkCommandBuffer commandBuffer, const VkStridedDeviceAddressRegionKHR* pRaygenShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pMissShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pHitShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pCallableShaderBindingTable, VkDeviceAddress indirectDeviceAddress) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdTraceRaysIndirectKHR(VkCommandBuffer commandBuffer, const VkStridedDeviceAddressRegionKHR* pRaygenShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pMissShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pHitShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pCallableShaderBindingTable, VkDeviceAddress indirectDeviceAddress) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdTraceRaysIndirectKHR(VkCommandBuffer commandBuffer, const VkStridedDeviceAddressRegionKHR* pRaygenShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pMissShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pHitShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pCallableShaderBindingTable, VkDeviceAddress indirectDeviceAddress);

  #define tu_CmdTraceRaysIndirectKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdTraceRaysIndirectKHR<X>(VkCommandBuffer commandBuffer, const VkStridedDeviceAddressRegionKHR* pRaygenShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pMissShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pHitShaderBindingTable, const VkStridedDeviceAddressRegionKHR* pCallableShaderBindingTable, VkDeviceAddress indirectDeviceAddress);

  VKAPI_ATTR void VKAPI_CALL tu_CmdTraceRaysIndirect2KHR(VkCommandBuffer commandBuffer, VkDeviceAddress indirectDeviceAddress) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdTraceRaysIndirect2KHR(VkCommandBuffer commandBuffer, VkDeviceAddress indirectDeviceAddress) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdTraceRaysIndirect2KHR(VkCommandBuffer commandBuffer, VkDeviceAddress indirectDeviceAddress);

  #define tu_CmdTraceRaysIndirect2KHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdTraceRaysIndirect2KHR<X>(VkCommandBuffer commandBuffer, VkDeviceAddress indirectDeviceAddress);

  VKAPI_ATTR void VKAPI_CALL tu_GetClusterAccelerationStructureBuildSizesNV(VkDevice device, const VkClusterAccelerationStructureInputInfoNV* pInfo, VkAccelerationStructureBuildSizesInfoKHR* pSizeInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetClusterAccelerationStructureBuildSizesNV(VkDevice device, const VkClusterAccelerationStructureInputInfoNV* pInfo, VkAccelerationStructureBuildSizesInfoKHR* pSizeInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetClusterAccelerationStructureBuildSizesNV(VkDevice device, const VkClusterAccelerationStructureInputInfoNV* pInfo, VkAccelerationStructureBuildSizesInfoKHR* pSizeInfo);

  #define tu_GetClusterAccelerationStructureBuildSizesNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetClusterAccelerationStructureBuildSizesNV<X>(VkDevice device, const VkClusterAccelerationStructureInputInfoNV* pInfo, VkAccelerationStructureBuildSizesInfoKHR* pSizeInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBuildClusterAccelerationStructureIndirectNV(VkCommandBuffer                     commandBuffer, const VkClusterAccelerationStructureCommandsInfoNV*  pCommandInfos) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBuildClusterAccelerationStructureIndirectNV(VkCommandBuffer                     commandBuffer, const VkClusterAccelerationStructureCommandsInfoNV*  pCommandInfos) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBuildClusterAccelerationStructureIndirectNV(VkCommandBuffer                     commandBuffer, const VkClusterAccelerationStructureCommandsInfoNV*  pCommandInfos);

  #define tu_CmdBuildClusterAccelerationStructureIndirectNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBuildClusterAccelerationStructureIndirectNV<X>(VkCommandBuffer                     commandBuffer, const VkClusterAccelerationStructureCommandsInfoNV*  pCommandInfos);

  VKAPI_ATTR void VKAPI_CALL tu_GetDeviceAccelerationStructureCompatibilityKHR(VkDevice device, const VkAccelerationStructureVersionInfoKHR* pVersionInfo, VkAccelerationStructureCompatibilityKHR* pCompatibility) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetDeviceAccelerationStructureCompatibilityKHR(VkDevice device, const VkAccelerationStructureVersionInfoKHR* pVersionInfo, VkAccelerationStructureCompatibilityKHR* pCompatibility) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetDeviceAccelerationStructureCompatibilityKHR(VkDevice device, const VkAccelerationStructureVersionInfoKHR* pVersionInfo, VkAccelerationStructureCompatibilityKHR* pCompatibility);

  #define tu_GetDeviceAccelerationStructureCompatibilityKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetDeviceAccelerationStructureCompatibilityKHR<X>(VkDevice device, const VkAccelerationStructureVersionInfoKHR* pVersionInfo, VkAccelerationStructureCompatibilityKHR* pCompatibility);

  VKAPI_ATTR VkDeviceSize VKAPI_CALL tu_GetRayTracingShaderGroupStackSizeKHR(VkDevice device, VkPipeline pipeline, uint32_t group, VkShaderGroupShaderKHR groupShader) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkDeviceSize VKAPI_CALL tu_rmv_GetRayTracingShaderGroupStackSizeKHR(VkDevice device, VkPipeline pipeline, uint32_t group, VkShaderGroupShaderKHR groupShader) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkDeviceSize VKAPI_CALL tu_GetRayTracingShaderGroupStackSizeKHR(VkDevice device, VkPipeline pipeline, uint32_t group, VkShaderGroupShaderKHR groupShader);

  #define tu_GetRayTracingShaderGroupStackSizeKHR_GENS(X)   template VKAPI_ATTR VkDeviceSize VKAPI_CALL tu_GetRayTracingShaderGroupStackSizeKHR<X>(VkDevice device, VkPipeline pipeline, uint32_t group, VkShaderGroupShaderKHR groupShader);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetRayTracingPipelineStackSizeKHR(VkCommandBuffer commandBuffer, uint32_t pipelineStackSize) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetRayTracingPipelineStackSizeKHR(VkCommandBuffer commandBuffer, uint32_t pipelineStackSize) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetRayTracingPipelineStackSizeKHR(VkCommandBuffer commandBuffer, uint32_t pipelineStackSize);

  #define tu_CmdSetRayTracingPipelineStackSizeKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetRayTracingPipelineStackSizeKHR<X>(VkCommandBuffer commandBuffer, uint32_t pipelineStackSize);

  VKAPI_ATTR uint32_t VKAPI_CALL tu_GetImageViewHandleNVX(VkDevice device, const VkImageViewHandleInfoNVX* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR uint32_t VKAPI_CALL tu_rmv_GetImageViewHandleNVX(VkDevice device, const VkImageViewHandleInfoNVX* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR uint32_t VKAPI_CALL tu_GetImageViewHandleNVX(VkDevice device, const VkImageViewHandleInfoNVX* pInfo);

  #define tu_GetImageViewHandleNVX_GENS(X)   template VKAPI_ATTR uint32_t VKAPI_CALL tu_GetImageViewHandleNVX<X>(VkDevice device, const VkImageViewHandleInfoNVX* pInfo);

  VKAPI_ATTR uint64_t VKAPI_CALL tu_GetImageViewHandle64NVX(VkDevice device, const VkImageViewHandleInfoNVX* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR uint64_t VKAPI_CALL tu_rmv_GetImageViewHandle64NVX(VkDevice device, const VkImageViewHandleInfoNVX* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR uint64_t VKAPI_CALL tu_GetImageViewHandle64NVX(VkDevice device, const VkImageViewHandleInfoNVX* pInfo);

  #define tu_GetImageViewHandle64NVX_GENS(X)   template VKAPI_ATTR uint64_t VKAPI_CALL tu_GetImageViewHandle64NVX<X>(VkDevice device, const VkImageViewHandleInfoNVX* pInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetImageViewAddressNVX(VkDevice device, VkImageView imageView, VkImageViewAddressPropertiesNVX* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetImageViewAddressNVX(VkDevice device, VkImageView imageView, VkImageViewAddressPropertiesNVX* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetImageViewAddressNVX(VkDevice device, VkImageView imageView, VkImageViewAddressPropertiesNVX* pProperties);

  #define tu_GetImageViewAddressNVX_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetImageViewAddressNVX<X>(VkDevice device, VkImageView imageView, VkImageViewAddressPropertiesNVX* pProperties);

#ifdef VK_USE_PLATFORM_WIN32_KHR
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetDeviceGroupSurfacePresentModes2EXT(VkDevice device, const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo, VkDeviceGroupPresentModeFlagsKHR* pModes) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetDeviceGroupSurfacePresentModes2EXT(VkDevice device, const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo, VkDeviceGroupPresentModeFlagsKHR* pModes) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetDeviceGroupSurfacePresentModes2EXT(VkDevice device, const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo, VkDeviceGroupPresentModeFlagsKHR* pModes);

  #define tu_GetDeviceGroupSurfacePresentModes2EXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetDeviceGroupSurfacePresentModes2EXT<X>(VkDevice device, const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo, VkDeviceGroupPresentModeFlagsKHR* pModes);

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
  VKAPI_ATTR VkResult VKAPI_CALL tu_AcquireFullScreenExclusiveModeEXT(VkDevice device, VkSwapchainKHR swapchain) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_AcquireFullScreenExclusiveModeEXT(VkDevice device, VkSwapchainKHR swapchain) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_AcquireFullScreenExclusiveModeEXT(VkDevice device, VkSwapchainKHR swapchain);

  #define tu_AcquireFullScreenExclusiveModeEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_AcquireFullScreenExclusiveModeEXT<X>(VkDevice device, VkSwapchainKHR swapchain);

#endif // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
  VKAPI_ATTR VkResult VKAPI_CALL tu_ReleaseFullScreenExclusiveModeEXT(VkDevice device, VkSwapchainKHR swapchain) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_ReleaseFullScreenExclusiveModeEXT(VkDevice device, VkSwapchainKHR swapchain) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_ReleaseFullScreenExclusiveModeEXT(VkDevice device, VkSwapchainKHR swapchain);

  #define tu_ReleaseFullScreenExclusiveModeEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_ReleaseFullScreenExclusiveModeEXT<X>(VkDevice device, VkSwapchainKHR swapchain);

#endif // VK_USE_PLATFORM_WIN32_KHR
  VKAPI_ATTR VkResult VKAPI_CALL tu_AcquireProfilingLockKHR(VkDevice device, const VkAcquireProfilingLockInfoKHR* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_AcquireProfilingLockKHR(VkDevice device, const VkAcquireProfilingLockInfoKHR* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_AcquireProfilingLockKHR(VkDevice device, const VkAcquireProfilingLockInfoKHR* pInfo);

  #define tu_AcquireProfilingLockKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_AcquireProfilingLockKHR<X>(VkDevice device, const VkAcquireProfilingLockInfoKHR* pInfo);

  VKAPI_ATTR void VKAPI_CALL tu_ReleaseProfilingLockKHR(VkDevice device) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_ReleaseProfilingLockKHR(VkDevice device) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_ReleaseProfilingLockKHR(VkDevice device);

  #define tu_ReleaseProfilingLockKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_ReleaseProfilingLockKHR<X>(VkDevice device);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetImageDrmFormatModifierPropertiesEXT(VkDevice device, VkImage image, VkImageDrmFormatModifierPropertiesEXT* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetImageDrmFormatModifierPropertiesEXT(VkDevice device, VkImage image, VkImageDrmFormatModifierPropertiesEXT* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetImageDrmFormatModifierPropertiesEXT(VkDevice device, VkImage image, VkImageDrmFormatModifierPropertiesEXT* pProperties);

  #define tu_GetImageDrmFormatModifierPropertiesEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetImageDrmFormatModifierPropertiesEXT<X>(VkDevice device, VkImage image, VkImageDrmFormatModifierPropertiesEXT* pProperties);

  VKAPI_ATTR uint64_t VKAPI_CALL tu_GetBufferOpaqueCaptureAddress(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR uint64_t VKAPI_CALL tu_rmv_GetBufferOpaqueCaptureAddress(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR uint64_t VKAPI_CALL tu_GetBufferOpaqueCaptureAddress(VkDevice device, const VkBufferDeviceAddressInfo* pInfo);

  #define tu_GetBufferOpaqueCaptureAddress_GENS(X)   template VKAPI_ATTR uint64_t VKAPI_CALL tu_GetBufferOpaqueCaptureAddress<X>(VkDevice device, const VkBufferDeviceAddressInfo* pInfo);

  VKAPI_ATTR uint64_t VKAPI_CALL tu_GetBufferOpaqueCaptureAddressKHR(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR uint64_t VKAPI_CALL tu_rmv_GetBufferOpaqueCaptureAddressKHR(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR uint64_t VKAPI_CALL tu_GetBufferOpaqueCaptureAddressKHR(VkDevice device, const VkBufferDeviceAddressInfo* pInfo);

  #define tu_GetBufferOpaqueCaptureAddressKHR_GENS(X)   template VKAPI_ATTR uint64_t VKAPI_CALL tu_GetBufferOpaqueCaptureAddressKHR<X>(VkDevice device, const VkBufferDeviceAddressInfo* pInfo);

  VKAPI_ATTR VkDeviceAddress VKAPI_CALL tu_GetBufferDeviceAddress(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkDeviceAddress VKAPI_CALL tu_rmv_GetBufferDeviceAddress(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkDeviceAddress VKAPI_CALL tu_GetBufferDeviceAddress(VkDevice device, const VkBufferDeviceAddressInfo* pInfo);

  #define tu_GetBufferDeviceAddress_GENS(X)   template VKAPI_ATTR VkDeviceAddress VKAPI_CALL tu_GetBufferDeviceAddress<X>(VkDevice device, const VkBufferDeviceAddressInfo* pInfo);

  VKAPI_ATTR VkDeviceAddress VKAPI_CALL tu_GetBufferDeviceAddressKHR(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkDeviceAddress VKAPI_CALL tu_rmv_GetBufferDeviceAddressKHR(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkDeviceAddress VKAPI_CALL tu_GetBufferDeviceAddressKHR(VkDevice device, const VkBufferDeviceAddressInfo* pInfo);

  #define tu_GetBufferDeviceAddressKHR_GENS(X)   template VKAPI_ATTR VkDeviceAddress VKAPI_CALL tu_GetBufferDeviceAddressKHR<X>(VkDevice device, const VkBufferDeviceAddressInfo* pInfo);

  VKAPI_ATTR VkDeviceAddress VKAPI_CALL tu_GetBufferDeviceAddressEXT(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkDeviceAddress VKAPI_CALL tu_rmv_GetBufferDeviceAddressEXT(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkDeviceAddress VKAPI_CALL tu_GetBufferDeviceAddressEXT(VkDevice device, const VkBufferDeviceAddressInfo* pInfo);

  #define tu_GetBufferDeviceAddressEXT_GENS(X)   template VKAPI_ATTR VkDeviceAddress VKAPI_CALL tu_GetBufferDeviceAddressEXT<X>(VkDevice device, const VkBufferDeviceAddressInfo* pInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_InitializePerformanceApiINTEL(VkDevice device, const VkInitializePerformanceApiInfoINTEL* pInitializeInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_InitializePerformanceApiINTEL(VkDevice device, const VkInitializePerformanceApiInfoINTEL* pInitializeInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_InitializePerformanceApiINTEL(VkDevice device, const VkInitializePerformanceApiInfoINTEL* pInitializeInfo);

  #define tu_InitializePerformanceApiINTEL_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_InitializePerformanceApiINTEL<X>(VkDevice device, const VkInitializePerformanceApiInfoINTEL* pInitializeInfo);

  VKAPI_ATTR void VKAPI_CALL tu_UninitializePerformanceApiINTEL(VkDevice device) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_UninitializePerformanceApiINTEL(VkDevice device) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_UninitializePerformanceApiINTEL(VkDevice device);

  #define tu_UninitializePerformanceApiINTEL_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_UninitializePerformanceApiINTEL<X>(VkDevice device);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CmdSetPerformanceMarkerINTEL(VkCommandBuffer commandBuffer, const VkPerformanceMarkerInfoINTEL* pMarkerInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CmdSetPerformanceMarkerINTEL(VkCommandBuffer commandBuffer, const VkPerformanceMarkerInfoINTEL* pMarkerInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CmdSetPerformanceMarkerINTEL(VkCommandBuffer commandBuffer, const VkPerformanceMarkerInfoINTEL* pMarkerInfo);

  #define tu_CmdSetPerformanceMarkerINTEL_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CmdSetPerformanceMarkerINTEL<X>(VkCommandBuffer commandBuffer, const VkPerformanceMarkerInfoINTEL* pMarkerInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CmdSetPerformanceStreamMarkerINTEL(VkCommandBuffer commandBuffer, const VkPerformanceStreamMarkerInfoINTEL* pMarkerInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CmdSetPerformanceStreamMarkerINTEL(VkCommandBuffer commandBuffer, const VkPerformanceStreamMarkerInfoINTEL* pMarkerInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CmdSetPerformanceStreamMarkerINTEL(VkCommandBuffer commandBuffer, const VkPerformanceStreamMarkerInfoINTEL* pMarkerInfo);

  #define tu_CmdSetPerformanceStreamMarkerINTEL_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CmdSetPerformanceStreamMarkerINTEL<X>(VkCommandBuffer commandBuffer, const VkPerformanceStreamMarkerInfoINTEL* pMarkerInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CmdSetPerformanceOverrideINTEL(VkCommandBuffer commandBuffer, const VkPerformanceOverrideInfoINTEL* pOverrideInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CmdSetPerformanceOverrideINTEL(VkCommandBuffer commandBuffer, const VkPerformanceOverrideInfoINTEL* pOverrideInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CmdSetPerformanceOverrideINTEL(VkCommandBuffer commandBuffer, const VkPerformanceOverrideInfoINTEL* pOverrideInfo);

  #define tu_CmdSetPerformanceOverrideINTEL_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CmdSetPerformanceOverrideINTEL<X>(VkCommandBuffer commandBuffer, const VkPerformanceOverrideInfoINTEL* pOverrideInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_AcquirePerformanceConfigurationINTEL(VkDevice device, const VkPerformanceConfigurationAcquireInfoINTEL* pAcquireInfo, VkPerformanceConfigurationINTEL* pConfiguration) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_AcquirePerformanceConfigurationINTEL(VkDevice device, const VkPerformanceConfigurationAcquireInfoINTEL* pAcquireInfo, VkPerformanceConfigurationINTEL* pConfiguration) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_AcquirePerformanceConfigurationINTEL(VkDevice device, const VkPerformanceConfigurationAcquireInfoINTEL* pAcquireInfo, VkPerformanceConfigurationINTEL* pConfiguration);

  #define tu_AcquirePerformanceConfigurationINTEL_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_AcquirePerformanceConfigurationINTEL<X>(VkDevice device, const VkPerformanceConfigurationAcquireInfoINTEL* pAcquireInfo, VkPerformanceConfigurationINTEL* pConfiguration);

  VKAPI_ATTR VkResult VKAPI_CALL tu_ReleasePerformanceConfigurationINTEL(VkDevice device, VkPerformanceConfigurationINTEL configuration) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_ReleasePerformanceConfigurationINTEL(VkDevice device, VkPerformanceConfigurationINTEL configuration) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_ReleasePerformanceConfigurationINTEL(VkDevice device, VkPerformanceConfigurationINTEL configuration);

  #define tu_ReleasePerformanceConfigurationINTEL_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_ReleasePerformanceConfigurationINTEL<X>(VkDevice device, VkPerformanceConfigurationINTEL configuration);

  VKAPI_ATTR VkResult VKAPI_CALL tu_QueueSetPerformanceConfigurationINTEL(VkQueue queue, VkPerformanceConfigurationINTEL configuration) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_QueueSetPerformanceConfigurationINTEL(VkQueue queue, VkPerformanceConfigurationINTEL configuration) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_QueueSetPerformanceConfigurationINTEL(VkQueue queue, VkPerformanceConfigurationINTEL configuration);

  #define tu_QueueSetPerformanceConfigurationINTEL_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_QueueSetPerformanceConfigurationINTEL<X>(VkQueue queue, VkPerformanceConfigurationINTEL configuration);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPerformanceParameterINTEL(VkDevice device, VkPerformanceParameterTypeINTEL parameter, VkPerformanceValueINTEL* pValue) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetPerformanceParameterINTEL(VkDevice device, VkPerformanceParameterTypeINTEL parameter, VkPerformanceValueINTEL* pValue) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPerformanceParameterINTEL(VkDevice device, VkPerformanceParameterTypeINTEL parameter, VkPerformanceValueINTEL* pValue);

  #define tu_GetPerformanceParameterINTEL_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetPerformanceParameterINTEL<X>(VkDevice device, VkPerformanceParameterTypeINTEL parameter, VkPerformanceValueINTEL* pValue);

  VKAPI_ATTR uint64_t VKAPI_CALL tu_GetDeviceMemoryOpaqueCaptureAddress(VkDevice device, const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR uint64_t VKAPI_CALL tu_rmv_GetDeviceMemoryOpaqueCaptureAddress(VkDevice device, const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR uint64_t VKAPI_CALL tu_GetDeviceMemoryOpaqueCaptureAddress(VkDevice device, const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo);

  #define tu_GetDeviceMemoryOpaqueCaptureAddress_GENS(X)   template VKAPI_ATTR uint64_t VKAPI_CALL tu_GetDeviceMemoryOpaqueCaptureAddress<X>(VkDevice device, const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo);

  VKAPI_ATTR uint64_t VKAPI_CALL tu_GetDeviceMemoryOpaqueCaptureAddressKHR(VkDevice device, const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR uint64_t VKAPI_CALL tu_rmv_GetDeviceMemoryOpaqueCaptureAddressKHR(VkDevice device, const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR uint64_t VKAPI_CALL tu_GetDeviceMemoryOpaqueCaptureAddressKHR(VkDevice device, const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo);

  #define tu_GetDeviceMemoryOpaqueCaptureAddressKHR_GENS(X)   template VKAPI_ATTR uint64_t VKAPI_CALL tu_GetDeviceMemoryOpaqueCaptureAddressKHR<X>(VkDevice device, const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPipelineExecutablePropertiesKHR(VkDevice                        device, const VkPipelineInfoKHR*        pPipelineInfo, uint32_t* pExecutableCount, VkPipelineExecutablePropertiesKHR* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetPipelineExecutablePropertiesKHR(VkDevice                        device, const VkPipelineInfoKHR*        pPipelineInfo, uint32_t* pExecutableCount, VkPipelineExecutablePropertiesKHR* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPipelineExecutablePropertiesKHR(VkDevice                        device, const VkPipelineInfoKHR*        pPipelineInfo, uint32_t* pExecutableCount, VkPipelineExecutablePropertiesKHR* pProperties);

  #define tu_GetPipelineExecutablePropertiesKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetPipelineExecutablePropertiesKHR<X>(VkDevice                        device, const VkPipelineInfoKHR*        pPipelineInfo, uint32_t* pExecutableCount, VkPipelineExecutablePropertiesKHR* pProperties);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPipelineExecutableStatisticsKHR(VkDevice                        device, const VkPipelineExecutableInfoKHR*  pExecutableInfo, uint32_t* pStatisticCount, VkPipelineExecutableStatisticKHR* pStatistics) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetPipelineExecutableStatisticsKHR(VkDevice                        device, const VkPipelineExecutableInfoKHR*  pExecutableInfo, uint32_t* pStatisticCount, VkPipelineExecutableStatisticKHR* pStatistics) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPipelineExecutableStatisticsKHR(VkDevice                        device, const VkPipelineExecutableInfoKHR*  pExecutableInfo, uint32_t* pStatisticCount, VkPipelineExecutableStatisticKHR* pStatistics);

  #define tu_GetPipelineExecutableStatisticsKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetPipelineExecutableStatisticsKHR<X>(VkDevice                        device, const VkPipelineExecutableInfoKHR*  pExecutableInfo, uint32_t* pStatisticCount, VkPipelineExecutableStatisticKHR* pStatistics);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPipelineExecutableInternalRepresentationsKHR(VkDevice                        device, const VkPipelineExecutableInfoKHR*  pExecutableInfo, uint32_t* pInternalRepresentationCount, VkPipelineExecutableInternalRepresentationKHR* pInternalRepresentations) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetPipelineExecutableInternalRepresentationsKHR(VkDevice                        device, const VkPipelineExecutableInfoKHR*  pExecutableInfo, uint32_t* pInternalRepresentationCount, VkPipelineExecutableInternalRepresentationKHR* pInternalRepresentations) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPipelineExecutableInternalRepresentationsKHR(VkDevice                        device, const VkPipelineExecutableInfoKHR*  pExecutableInfo, uint32_t* pInternalRepresentationCount, VkPipelineExecutableInternalRepresentationKHR* pInternalRepresentations);

  #define tu_GetPipelineExecutableInternalRepresentationsKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetPipelineExecutableInternalRepresentationsKHR<X>(VkDevice                        device, const VkPipelineExecutableInfoKHR*  pExecutableInfo, uint32_t* pInternalRepresentationCount, VkPipelineExecutableInternalRepresentationKHR* pInternalRepresentations);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetLineStipple(VkCommandBuffer commandBuffer, uint32_t lineStippleFactor, uint16_t lineStipplePattern) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetLineStipple(VkCommandBuffer commandBuffer, uint32_t lineStippleFactor, uint16_t lineStipplePattern) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetLineStipple(VkCommandBuffer commandBuffer, uint32_t lineStippleFactor, uint16_t lineStipplePattern);

  #define tu_CmdSetLineStipple_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetLineStipple<X>(VkCommandBuffer commandBuffer, uint32_t lineStippleFactor, uint16_t lineStipplePattern);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetLineStippleKHR(VkCommandBuffer commandBuffer, uint32_t lineStippleFactor, uint16_t lineStipplePattern) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetLineStippleKHR(VkCommandBuffer commandBuffer, uint32_t lineStippleFactor, uint16_t lineStipplePattern) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetLineStippleKHR(VkCommandBuffer commandBuffer, uint32_t lineStippleFactor, uint16_t lineStipplePattern);

  #define tu_CmdSetLineStippleKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetLineStippleKHR<X>(VkCommandBuffer commandBuffer, uint32_t lineStippleFactor, uint16_t lineStipplePattern);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetLineStippleEXT(VkCommandBuffer commandBuffer, uint32_t lineStippleFactor, uint16_t lineStipplePattern) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetLineStippleEXT(VkCommandBuffer commandBuffer, uint32_t lineStippleFactor, uint16_t lineStipplePattern) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetLineStippleEXT(VkCommandBuffer commandBuffer, uint32_t lineStippleFactor, uint16_t lineStipplePattern);

  #define tu_CmdSetLineStippleEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetLineStippleEXT<X>(VkCommandBuffer commandBuffer, uint32_t lineStippleFactor, uint16_t lineStipplePattern);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateAccelerationStructureKHR(VkDevice                                           device, const VkAccelerationStructureCreateInfoKHR*        pCreateInfo, const VkAllocationCallbacks*       pAllocator, VkAccelerationStructureKHR*                        pAccelerationStructure) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateAccelerationStructureKHR(VkDevice                                           device, const VkAccelerationStructureCreateInfoKHR*        pCreateInfo, const VkAllocationCallbacks*       pAllocator, VkAccelerationStructureKHR*                        pAccelerationStructure) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateAccelerationStructureKHR(VkDevice                                           device, const VkAccelerationStructureCreateInfoKHR*        pCreateInfo, const VkAllocationCallbacks*       pAllocator, VkAccelerationStructureKHR*                        pAccelerationStructure);

  #define tu_CreateAccelerationStructureKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateAccelerationStructureKHR<X>(VkDevice                                           device, const VkAccelerationStructureCreateInfoKHR*        pCreateInfo, const VkAllocationCallbacks*       pAllocator, VkAccelerationStructureKHR*                        pAccelerationStructure);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBuildAccelerationStructuresKHR(VkCommandBuffer                                    commandBuffer, uint32_t infoCount, const VkAccelerationStructureBuildGeometryInfoKHR* pInfos, const VkAccelerationStructureBuildRangeInfoKHR* const* ppBuildRangeInfos) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBuildAccelerationStructuresKHR(VkCommandBuffer                                    commandBuffer, uint32_t infoCount, const VkAccelerationStructureBuildGeometryInfoKHR* pInfos, const VkAccelerationStructureBuildRangeInfoKHR* const* ppBuildRangeInfos) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBuildAccelerationStructuresKHR(VkCommandBuffer                                    commandBuffer, uint32_t infoCount, const VkAccelerationStructureBuildGeometryInfoKHR* pInfos, const VkAccelerationStructureBuildRangeInfoKHR* const* ppBuildRangeInfos);

  #define tu_CmdBuildAccelerationStructuresKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBuildAccelerationStructuresKHR<X>(VkCommandBuffer                                    commandBuffer, uint32_t infoCount, const VkAccelerationStructureBuildGeometryInfoKHR* pInfos, const VkAccelerationStructureBuildRangeInfoKHR* const* ppBuildRangeInfos);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBuildAccelerationStructuresIndirectKHR(VkCommandBuffer                  commandBuffer, uint32_t                                           infoCount, const VkAccelerationStructureBuildGeometryInfoKHR* pInfos, const VkDeviceAddress*             pIndirectDeviceAddresses, const uint32_t*                    pIndirectStrides, const uint32_t* const*             ppMaxPrimitiveCounts) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBuildAccelerationStructuresIndirectKHR(VkCommandBuffer                  commandBuffer, uint32_t                                           infoCount, const VkAccelerationStructureBuildGeometryInfoKHR* pInfos, const VkDeviceAddress*             pIndirectDeviceAddresses, const uint32_t*                    pIndirectStrides, const uint32_t* const*             ppMaxPrimitiveCounts) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBuildAccelerationStructuresIndirectKHR(VkCommandBuffer                  commandBuffer, uint32_t                                           infoCount, const VkAccelerationStructureBuildGeometryInfoKHR* pInfos, const VkDeviceAddress*             pIndirectDeviceAddresses, const uint32_t*                    pIndirectStrides, const uint32_t* const*             ppMaxPrimitiveCounts);

  #define tu_CmdBuildAccelerationStructuresIndirectKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBuildAccelerationStructuresIndirectKHR<X>(VkCommandBuffer                  commandBuffer, uint32_t                                           infoCount, const VkAccelerationStructureBuildGeometryInfoKHR* pInfos, const VkDeviceAddress*             pIndirectDeviceAddresses, const uint32_t*                    pIndirectStrides, const uint32_t* const*             ppMaxPrimitiveCounts);

  VKAPI_ATTR VkResult VKAPI_CALL tu_BuildAccelerationStructuresKHR(VkDevice                                           device, VkDeferredOperationKHR deferredOperation, uint32_t infoCount, const VkAccelerationStructureBuildGeometryInfoKHR* pInfos, const VkAccelerationStructureBuildRangeInfoKHR* const* ppBuildRangeInfos) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_BuildAccelerationStructuresKHR(VkDevice                                           device, VkDeferredOperationKHR deferredOperation, uint32_t infoCount, const VkAccelerationStructureBuildGeometryInfoKHR* pInfos, const VkAccelerationStructureBuildRangeInfoKHR* const* ppBuildRangeInfos) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_BuildAccelerationStructuresKHR(VkDevice                                           device, VkDeferredOperationKHR deferredOperation, uint32_t infoCount, const VkAccelerationStructureBuildGeometryInfoKHR* pInfos, const VkAccelerationStructureBuildRangeInfoKHR* const* ppBuildRangeInfos);

  #define tu_BuildAccelerationStructuresKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_BuildAccelerationStructuresKHR<X>(VkDevice                                           device, VkDeferredOperationKHR deferredOperation, uint32_t infoCount, const VkAccelerationStructureBuildGeometryInfoKHR* pInfos, const VkAccelerationStructureBuildRangeInfoKHR* const* ppBuildRangeInfos);

  VKAPI_ATTR VkDeviceAddress VKAPI_CALL tu_GetAccelerationStructureDeviceAddressKHR(VkDevice device, const VkAccelerationStructureDeviceAddressInfoKHR* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkDeviceAddress VKAPI_CALL tu_rmv_GetAccelerationStructureDeviceAddressKHR(VkDevice device, const VkAccelerationStructureDeviceAddressInfoKHR* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkDeviceAddress VKAPI_CALL tu_GetAccelerationStructureDeviceAddressKHR(VkDevice device, const VkAccelerationStructureDeviceAddressInfoKHR* pInfo);

  #define tu_GetAccelerationStructureDeviceAddressKHR_GENS(X)   template VKAPI_ATTR VkDeviceAddress VKAPI_CALL tu_GetAccelerationStructureDeviceAddressKHR<X>(VkDevice device, const VkAccelerationStructureDeviceAddressInfoKHR* pInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateDeferredOperationKHR(VkDevice device, const VkAllocationCallbacks* pAllocator, VkDeferredOperationKHR* pDeferredOperation) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateDeferredOperationKHR(VkDevice device, const VkAllocationCallbacks* pAllocator, VkDeferredOperationKHR* pDeferredOperation) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateDeferredOperationKHR(VkDevice device, const VkAllocationCallbacks* pAllocator, VkDeferredOperationKHR* pDeferredOperation);

  #define tu_CreateDeferredOperationKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateDeferredOperationKHR<X>(VkDevice device, const VkAllocationCallbacks* pAllocator, VkDeferredOperationKHR* pDeferredOperation);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyDeferredOperationKHR(VkDevice device, VkDeferredOperationKHR operation, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyDeferredOperationKHR(VkDevice device, VkDeferredOperationKHR operation, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyDeferredOperationKHR(VkDevice device, VkDeferredOperationKHR operation, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyDeferredOperationKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyDeferredOperationKHR<X>(VkDevice device, VkDeferredOperationKHR operation, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR uint32_t VKAPI_CALL tu_GetDeferredOperationMaxConcurrencyKHR(VkDevice device, VkDeferredOperationKHR operation) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR uint32_t VKAPI_CALL tu_rmv_GetDeferredOperationMaxConcurrencyKHR(VkDevice device, VkDeferredOperationKHR operation) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR uint32_t VKAPI_CALL tu_GetDeferredOperationMaxConcurrencyKHR(VkDevice device, VkDeferredOperationKHR operation);

  #define tu_GetDeferredOperationMaxConcurrencyKHR_GENS(X)   template VKAPI_ATTR uint32_t VKAPI_CALL tu_GetDeferredOperationMaxConcurrencyKHR<X>(VkDevice device, VkDeferredOperationKHR operation);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetDeferredOperationResultKHR(VkDevice device, VkDeferredOperationKHR operation) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetDeferredOperationResultKHR(VkDevice device, VkDeferredOperationKHR operation) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetDeferredOperationResultKHR(VkDevice device, VkDeferredOperationKHR operation);

  #define tu_GetDeferredOperationResultKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetDeferredOperationResultKHR<X>(VkDevice device, VkDeferredOperationKHR operation);

  VKAPI_ATTR VkResult VKAPI_CALL tu_DeferredOperationJoinKHR(VkDevice device, VkDeferredOperationKHR operation) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_DeferredOperationJoinKHR(VkDevice device, VkDeferredOperationKHR operation) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_DeferredOperationJoinKHR(VkDevice device, VkDeferredOperationKHR operation);

  #define tu_DeferredOperationJoinKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_DeferredOperationJoinKHR<X>(VkDevice device, VkDeferredOperationKHR operation);

  VKAPI_ATTR void VKAPI_CALL tu_GetPipelineIndirectMemoryRequirementsNV(VkDevice device, const VkComputePipelineCreateInfo* pCreateInfo, VkMemoryRequirements2* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetPipelineIndirectMemoryRequirementsNV(VkDevice device, const VkComputePipelineCreateInfo* pCreateInfo, VkMemoryRequirements2* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetPipelineIndirectMemoryRequirementsNV(VkDevice device, const VkComputePipelineCreateInfo* pCreateInfo, VkMemoryRequirements2* pMemoryRequirements);

  #define tu_GetPipelineIndirectMemoryRequirementsNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetPipelineIndirectMemoryRequirementsNV<X>(VkDevice device, const VkComputePipelineCreateInfo* pCreateInfo, VkMemoryRequirements2* pMemoryRequirements);

  VKAPI_ATTR VkDeviceAddress VKAPI_CALL tu_GetPipelineIndirectDeviceAddressNV(VkDevice device, const VkPipelineIndirectDeviceAddressInfoNV* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkDeviceAddress VKAPI_CALL tu_rmv_GetPipelineIndirectDeviceAddressNV(VkDevice device, const VkPipelineIndirectDeviceAddressInfoNV* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkDeviceAddress VKAPI_CALL tu_GetPipelineIndirectDeviceAddressNV(VkDevice device, const VkPipelineIndirectDeviceAddressInfoNV* pInfo);

  #define tu_GetPipelineIndirectDeviceAddressNV_GENS(X)   template VKAPI_ATTR VkDeviceAddress VKAPI_CALL tu_GetPipelineIndirectDeviceAddressNV<X>(VkDevice device, const VkPipelineIndirectDeviceAddressInfoNV* pInfo);

  VKAPI_ATTR void VKAPI_CALL tu_AntiLagUpdateAMD(VkDevice device, const VkAntiLagDataAMD* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_AntiLagUpdateAMD(VkDevice device, const VkAntiLagDataAMD* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_AntiLagUpdateAMD(VkDevice device, const VkAntiLagDataAMD* pData);

  #define tu_AntiLagUpdateAMD_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_AntiLagUpdateAMD<X>(VkDevice device, const VkAntiLagDataAMD* pData);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetCullMode(VkCommandBuffer commandBuffer, VkCullModeFlags cullMode) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetCullMode(VkCommandBuffer commandBuffer, VkCullModeFlags cullMode) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetCullMode(VkCommandBuffer commandBuffer, VkCullModeFlags cullMode);

  #define tu_CmdSetCullMode_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetCullMode<X>(VkCommandBuffer commandBuffer, VkCullModeFlags cullMode);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetCullModeEXT(VkCommandBuffer commandBuffer, VkCullModeFlags cullMode) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetCullModeEXT(VkCommandBuffer commandBuffer, VkCullModeFlags cullMode) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetCullModeEXT(VkCommandBuffer commandBuffer, VkCullModeFlags cullMode);

  #define tu_CmdSetCullModeEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetCullModeEXT<X>(VkCommandBuffer commandBuffer, VkCullModeFlags cullMode);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetFrontFace(VkCommandBuffer commandBuffer, VkFrontFace frontFace) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetFrontFace(VkCommandBuffer commandBuffer, VkFrontFace frontFace) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetFrontFace(VkCommandBuffer commandBuffer, VkFrontFace frontFace);

  #define tu_CmdSetFrontFace_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetFrontFace<X>(VkCommandBuffer commandBuffer, VkFrontFace frontFace);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetFrontFaceEXT(VkCommandBuffer commandBuffer, VkFrontFace frontFace) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetFrontFaceEXT(VkCommandBuffer commandBuffer, VkFrontFace frontFace) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetFrontFaceEXT(VkCommandBuffer commandBuffer, VkFrontFace frontFace);

  #define tu_CmdSetFrontFaceEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetFrontFaceEXT<X>(VkCommandBuffer commandBuffer, VkFrontFace frontFace);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetPrimitiveTopology(VkCommandBuffer commandBuffer, VkPrimitiveTopology primitiveTopology) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetPrimitiveTopology(VkCommandBuffer commandBuffer, VkPrimitiveTopology primitiveTopology) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetPrimitiveTopology(VkCommandBuffer commandBuffer, VkPrimitiveTopology primitiveTopology);

  #define tu_CmdSetPrimitiveTopology_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetPrimitiveTopology<X>(VkCommandBuffer commandBuffer, VkPrimitiveTopology primitiveTopology);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetPrimitiveTopologyEXT(VkCommandBuffer commandBuffer, VkPrimitiveTopology primitiveTopology) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetPrimitiveTopologyEXT(VkCommandBuffer commandBuffer, VkPrimitiveTopology primitiveTopology) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetPrimitiveTopologyEXT(VkCommandBuffer commandBuffer, VkPrimitiveTopology primitiveTopology);

  #define tu_CmdSetPrimitiveTopologyEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetPrimitiveTopologyEXT<X>(VkCommandBuffer commandBuffer, VkPrimitiveTopology primitiveTopology);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetViewportWithCount(VkCommandBuffer commandBuffer, uint32_t viewportCount, const VkViewport* pViewports) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetViewportWithCount(VkCommandBuffer commandBuffer, uint32_t viewportCount, const VkViewport* pViewports) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetViewportWithCount(VkCommandBuffer commandBuffer, uint32_t viewportCount, const VkViewport* pViewports);

  #define tu_CmdSetViewportWithCount_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetViewportWithCount<X>(VkCommandBuffer commandBuffer, uint32_t viewportCount, const VkViewport* pViewports);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetViewportWithCountEXT(VkCommandBuffer commandBuffer, uint32_t viewportCount, const VkViewport* pViewports) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetViewportWithCountEXT(VkCommandBuffer commandBuffer, uint32_t viewportCount, const VkViewport* pViewports) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetViewportWithCountEXT(VkCommandBuffer commandBuffer, uint32_t viewportCount, const VkViewport* pViewports);

  #define tu_CmdSetViewportWithCountEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetViewportWithCountEXT<X>(VkCommandBuffer commandBuffer, uint32_t viewportCount, const VkViewport* pViewports);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetScissorWithCount(VkCommandBuffer commandBuffer, uint32_t scissorCount, const VkRect2D* pScissors) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetScissorWithCount(VkCommandBuffer commandBuffer, uint32_t scissorCount, const VkRect2D* pScissors) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetScissorWithCount(VkCommandBuffer commandBuffer, uint32_t scissorCount, const VkRect2D* pScissors);

  #define tu_CmdSetScissorWithCount_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetScissorWithCount<X>(VkCommandBuffer commandBuffer, uint32_t scissorCount, const VkRect2D* pScissors);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetScissorWithCountEXT(VkCommandBuffer commandBuffer, uint32_t scissorCount, const VkRect2D* pScissors) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetScissorWithCountEXT(VkCommandBuffer commandBuffer, uint32_t scissorCount, const VkRect2D* pScissors) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetScissorWithCountEXT(VkCommandBuffer commandBuffer, uint32_t scissorCount, const VkRect2D* pScissors);

  #define tu_CmdSetScissorWithCountEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetScissorWithCountEXT<X>(VkCommandBuffer commandBuffer, uint32_t scissorCount, const VkRect2D* pScissors);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBindIndexBuffer2(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkDeviceSize size, VkIndexType indexType) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBindIndexBuffer2(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkDeviceSize size, VkIndexType indexType) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBindIndexBuffer2(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkDeviceSize size, VkIndexType indexType);

  #define tu_CmdBindIndexBuffer2_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBindIndexBuffer2<X>(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkDeviceSize size, VkIndexType indexType);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBindIndexBuffer2KHR(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkDeviceSize size, VkIndexType indexType) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBindIndexBuffer2KHR(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkDeviceSize size, VkIndexType indexType) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBindIndexBuffer2KHR(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkDeviceSize size, VkIndexType indexType);

  #define tu_CmdBindIndexBuffer2KHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBindIndexBuffer2KHR<X>(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, VkDeviceSize size, VkIndexType indexType);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBindVertexBuffers2(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes, const VkDeviceSize* pStrides) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBindVertexBuffers2(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes, const VkDeviceSize* pStrides) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBindVertexBuffers2(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes, const VkDeviceSize* pStrides);

  #define tu_CmdBindVertexBuffers2_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBindVertexBuffers2<X>(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes, const VkDeviceSize* pStrides);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBindVertexBuffers2EXT(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes, const VkDeviceSize* pStrides) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBindVertexBuffers2EXT(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes, const VkDeviceSize* pStrides) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBindVertexBuffers2EXT(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes, const VkDeviceSize* pStrides);

  #define tu_CmdBindVertexBuffers2EXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBindVertexBuffers2EXT<X>(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount, const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes, const VkDeviceSize* pStrides);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthTestEnable(VkCommandBuffer commandBuffer, VkBool32 depthTestEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetDepthTestEnable(VkCommandBuffer commandBuffer, VkBool32 depthTestEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthTestEnable(VkCommandBuffer commandBuffer, VkBool32 depthTestEnable);

  #define tu_CmdSetDepthTestEnable_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthTestEnable<X>(VkCommandBuffer commandBuffer, VkBool32 depthTestEnable);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthTestEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthTestEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetDepthTestEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthTestEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthTestEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthTestEnable);

  #define tu_CmdSetDepthTestEnableEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthTestEnableEXT<X>(VkCommandBuffer commandBuffer, VkBool32 depthTestEnable);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthWriteEnable(VkCommandBuffer commandBuffer, VkBool32 depthWriteEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetDepthWriteEnable(VkCommandBuffer commandBuffer, VkBool32 depthWriteEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthWriteEnable(VkCommandBuffer commandBuffer, VkBool32 depthWriteEnable);

  #define tu_CmdSetDepthWriteEnable_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthWriteEnable<X>(VkCommandBuffer commandBuffer, VkBool32 depthWriteEnable);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthWriteEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthWriteEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetDepthWriteEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthWriteEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthWriteEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthWriteEnable);

  #define tu_CmdSetDepthWriteEnableEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthWriteEnableEXT<X>(VkCommandBuffer commandBuffer, VkBool32 depthWriteEnable);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthCompareOp(VkCommandBuffer commandBuffer, VkCompareOp depthCompareOp) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetDepthCompareOp(VkCommandBuffer commandBuffer, VkCompareOp depthCompareOp) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthCompareOp(VkCommandBuffer commandBuffer, VkCompareOp depthCompareOp);

  #define tu_CmdSetDepthCompareOp_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthCompareOp<X>(VkCommandBuffer commandBuffer, VkCompareOp depthCompareOp);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthCompareOpEXT(VkCommandBuffer commandBuffer, VkCompareOp depthCompareOp) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetDepthCompareOpEXT(VkCommandBuffer commandBuffer, VkCompareOp depthCompareOp) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthCompareOpEXT(VkCommandBuffer commandBuffer, VkCompareOp depthCompareOp);

  #define tu_CmdSetDepthCompareOpEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthCompareOpEXT<X>(VkCommandBuffer commandBuffer, VkCompareOp depthCompareOp);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthBoundsTestEnable(VkCommandBuffer commandBuffer, VkBool32 depthBoundsTestEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetDepthBoundsTestEnable(VkCommandBuffer commandBuffer, VkBool32 depthBoundsTestEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthBoundsTestEnable(VkCommandBuffer commandBuffer, VkBool32 depthBoundsTestEnable);

  #define tu_CmdSetDepthBoundsTestEnable_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthBoundsTestEnable<X>(VkCommandBuffer commandBuffer, VkBool32 depthBoundsTestEnable);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthBoundsTestEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthBoundsTestEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetDepthBoundsTestEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthBoundsTestEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthBoundsTestEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthBoundsTestEnable);

  #define tu_CmdSetDepthBoundsTestEnableEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthBoundsTestEnableEXT<X>(VkCommandBuffer commandBuffer, VkBool32 depthBoundsTestEnable);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetStencilTestEnable(VkCommandBuffer commandBuffer, VkBool32 stencilTestEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetStencilTestEnable(VkCommandBuffer commandBuffer, VkBool32 stencilTestEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetStencilTestEnable(VkCommandBuffer commandBuffer, VkBool32 stencilTestEnable);

  #define tu_CmdSetStencilTestEnable_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetStencilTestEnable<X>(VkCommandBuffer commandBuffer, VkBool32 stencilTestEnable);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetStencilTestEnableEXT(VkCommandBuffer commandBuffer, VkBool32 stencilTestEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetStencilTestEnableEXT(VkCommandBuffer commandBuffer, VkBool32 stencilTestEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetStencilTestEnableEXT(VkCommandBuffer commandBuffer, VkBool32 stencilTestEnable);

  #define tu_CmdSetStencilTestEnableEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetStencilTestEnableEXT<X>(VkCommandBuffer commandBuffer, VkBool32 stencilTestEnable);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetStencilOp(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, VkStencilOp failOp, VkStencilOp passOp, VkStencilOp depthFailOp, VkCompareOp compareOp) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetStencilOp(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, VkStencilOp failOp, VkStencilOp passOp, VkStencilOp depthFailOp, VkCompareOp compareOp) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetStencilOp(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, VkStencilOp failOp, VkStencilOp passOp, VkStencilOp depthFailOp, VkCompareOp compareOp);

  #define tu_CmdSetStencilOp_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetStencilOp<X>(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, VkStencilOp failOp, VkStencilOp passOp, VkStencilOp depthFailOp, VkCompareOp compareOp);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetStencilOpEXT(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, VkStencilOp failOp, VkStencilOp passOp, VkStencilOp depthFailOp, VkCompareOp compareOp) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetStencilOpEXT(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, VkStencilOp failOp, VkStencilOp passOp, VkStencilOp depthFailOp, VkCompareOp compareOp) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetStencilOpEXT(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, VkStencilOp failOp, VkStencilOp passOp, VkStencilOp depthFailOp, VkCompareOp compareOp);

  #define tu_CmdSetStencilOpEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetStencilOpEXT<X>(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, VkStencilOp failOp, VkStencilOp passOp, VkStencilOp depthFailOp, VkCompareOp compareOp);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetPatchControlPointsEXT(VkCommandBuffer commandBuffer, uint32_t patchControlPoints) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetPatchControlPointsEXT(VkCommandBuffer commandBuffer, uint32_t patchControlPoints) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetPatchControlPointsEXT(VkCommandBuffer commandBuffer, uint32_t patchControlPoints);

  #define tu_CmdSetPatchControlPointsEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetPatchControlPointsEXT<X>(VkCommandBuffer commandBuffer, uint32_t patchControlPoints);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetRasterizerDiscardEnable(VkCommandBuffer commandBuffer, VkBool32 rasterizerDiscardEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetRasterizerDiscardEnable(VkCommandBuffer commandBuffer, VkBool32 rasterizerDiscardEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetRasterizerDiscardEnable(VkCommandBuffer commandBuffer, VkBool32 rasterizerDiscardEnable);

  #define tu_CmdSetRasterizerDiscardEnable_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetRasterizerDiscardEnable<X>(VkCommandBuffer commandBuffer, VkBool32 rasterizerDiscardEnable);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetRasterizerDiscardEnableEXT(VkCommandBuffer commandBuffer, VkBool32 rasterizerDiscardEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetRasterizerDiscardEnableEXT(VkCommandBuffer commandBuffer, VkBool32 rasterizerDiscardEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetRasterizerDiscardEnableEXT(VkCommandBuffer commandBuffer, VkBool32 rasterizerDiscardEnable);

  #define tu_CmdSetRasterizerDiscardEnableEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetRasterizerDiscardEnableEXT<X>(VkCommandBuffer commandBuffer, VkBool32 rasterizerDiscardEnable);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthBiasEnable(VkCommandBuffer commandBuffer, VkBool32 depthBiasEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetDepthBiasEnable(VkCommandBuffer commandBuffer, VkBool32 depthBiasEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthBiasEnable(VkCommandBuffer commandBuffer, VkBool32 depthBiasEnable);

  #define tu_CmdSetDepthBiasEnable_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthBiasEnable<X>(VkCommandBuffer commandBuffer, VkBool32 depthBiasEnable);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthBiasEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthBiasEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetDepthBiasEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthBiasEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthBiasEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthBiasEnable);

  #define tu_CmdSetDepthBiasEnableEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthBiasEnableEXT<X>(VkCommandBuffer commandBuffer, VkBool32 depthBiasEnable);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetLogicOpEXT(VkCommandBuffer commandBuffer, VkLogicOp logicOp) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetLogicOpEXT(VkCommandBuffer commandBuffer, VkLogicOp logicOp) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetLogicOpEXT(VkCommandBuffer commandBuffer, VkLogicOp logicOp);

  #define tu_CmdSetLogicOpEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetLogicOpEXT<X>(VkCommandBuffer commandBuffer, VkLogicOp logicOp);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetPrimitiveRestartEnable(VkCommandBuffer commandBuffer, VkBool32 primitiveRestartEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetPrimitiveRestartEnable(VkCommandBuffer commandBuffer, VkBool32 primitiveRestartEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetPrimitiveRestartEnable(VkCommandBuffer commandBuffer, VkBool32 primitiveRestartEnable);

  #define tu_CmdSetPrimitiveRestartEnable_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetPrimitiveRestartEnable<X>(VkCommandBuffer commandBuffer, VkBool32 primitiveRestartEnable);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetPrimitiveRestartEnableEXT(VkCommandBuffer commandBuffer, VkBool32 primitiveRestartEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetPrimitiveRestartEnableEXT(VkCommandBuffer commandBuffer, VkBool32 primitiveRestartEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetPrimitiveRestartEnableEXT(VkCommandBuffer commandBuffer, VkBool32 primitiveRestartEnable);

  #define tu_CmdSetPrimitiveRestartEnableEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetPrimitiveRestartEnableEXT<X>(VkCommandBuffer commandBuffer, VkBool32 primitiveRestartEnable);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetTessellationDomainOriginEXT(VkCommandBuffer commandBuffer, VkTessellationDomainOrigin domainOrigin) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetTessellationDomainOriginEXT(VkCommandBuffer commandBuffer, VkTessellationDomainOrigin domainOrigin) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetTessellationDomainOriginEXT(VkCommandBuffer commandBuffer, VkTessellationDomainOrigin domainOrigin);

  #define tu_CmdSetTessellationDomainOriginEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetTessellationDomainOriginEXT<X>(VkCommandBuffer commandBuffer, VkTessellationDomainOrigin domainOrigin);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthClampEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthClampEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetDepthClampEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthClampEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthClampEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthClampEnable);

  #define tu_CmdSetDepthClampEnableEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthClampEnableEXT<X>(VkCommandBuffer commandBuffer, VkBool32 depthClampEnable);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetPolygonModeEXT(VkCommandBuffer commandBuffer, VkPolygonMode polygonMode) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetPolygonModeEXT(VkCommandBuffer commandBuffer, VkPolygonMode polygonMode) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetPolygonModeEXT(VkCommandBuffer commandBuffer, VkPolygonMode polygonMode);

  #define tu_CmdSetPolygonModeEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetPolygonModeEXT<X>(VkCommandBuffer commandBuffer, VkPolygonMode polygonMode);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetRasterizationSamplesEXT(VkCommandBuffer commandBuffer, VkSampleCountFlagBits  rasterizationSamples) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetRasterizationSamplesEXT(VkCommandBuffer commandBuffer, VkSampleCountFlagBits  rasterizationSamples) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetRasterizationSamplesEXT(VkCommandBuffer commandBuffer, VkSampleCountFlagBits  rasterizationSamples);

  #define tu_CmdSetRasterizationSamplesEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetRasterizationSamplesEXT<X>(VkCommandBuffer commandBuffer, VkSampleCountFlagBits  rasterizationSamples);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetSampleMaskEXT(VkCommandBuffer commandBuffer, VkSampleCountFlagBits  samples, const VkSampleMask*    pSampleMask) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetSampleMaskEXT(VkCommandBuffer commandBuffer, VkSampleCountFlagBits  samples, const VkSampleMask*    pSampleMask) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetSampleMaskEXT(VkCommandBuffer commandBuffer, VkSampleCountFlagBits  samples, const VkSampleMask*    pSampleMask);

  #define tu_CmdSetSampleMaskEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetSampleMaskEXT<X>(VkCommandBuffer commandBuffer, VkSampleCountFlagBits  samples, const VkSampleMask*    pSampleMask);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetAlphaToCoverageEnableEXT(VkCommandBuffer commandBuffer, VkBool32 alphaToCoverageEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetAlphaToCoverageEnableEXT(VkCommandBuffer commandBuffer, VkBool32 alphaToCoverageEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetAlphaToCoverageEnableEXT(VkCommandBuffer commandBuffer, VkBool32 alphaToCoverageEnable);

  #define tu_CmdSetAlphaToCoverageEnableEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetAlphaToCoverageEnableEXT<X>(VkCommandBuffer commandBuffer, VkBool32 alphaToCoverageEnable);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetAlphaToOneEnableEXT(VkCommandBuffer commandBuffer, VkBool32 alphaToOneEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetAlphaToOneEnableEXT(VkCommandBuffer commandBuffer, VkBool32 alphaToOneEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetAlphaToOneEnableEXT(VkCommandBuffer commandBuffer, VkBool32 alphaToOneEnable);

  #define tu_CmdSetAlphaToOneEnableEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetAlphaToOneEnableEXT<X>(VkCommandBuffer commandBuffer, VkBool32 alphaToOneEnable);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetLogicOpEnableEXT(VkCommandBuffer commandBuffer, VkBool32 logicOpEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetLogicOpEnableEXT(VkCommandBuffer commandBuffer, VkBool32 logicOpEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetLogicOpEnableEXT(VkCommandBuffer commandBuffer, VkBool32 logicOpEnable);

  #define tu_CmdSetLogicOpEnableEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetLogicOpEnableEXT<X>(VkCommandBuffer commandBuffer, VkBool32 logicOpEnable);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetColorBlendEnableEXT(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkBool32* pColorBlendEnables) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetColorBlendEnableEXT(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkBool32* pColorBlendEnables) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetColorBlendEnableEXT(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkBool32* pColorBlendEnables);

  #define tu_CmdSetColorBlendEnableEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetColorBlendEnableEXT<X>(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkBool32* pColorBlendEnables);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetColorBlendEquationEXT(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorBlendEquationEXT* pColorBlendEquations) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetColorBlendEquationEXT(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorBlendEquationEXT* pColorBlendEquations) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetColorBlendEquationEXT(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorBlendEquationEXT* pColorBlendEquations);

  #define tu_CmdSetColorBlendEquationEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetColorBlendEquationEXT<X>(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorBlendEquationEXT* pColorBlendEquations);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetColorWriteMaskEXT(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorComponentFlags* pColorWriteMasks) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetColorWriteMaskEXT(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorComponentFlags* pColorWriteMasks) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetColorWriteMaskEXT(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorComponentFlags* pColorWriteMasks);

  #define tu_CmdSetColorWriteMaskEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetColorWriteMaskEXT<X>(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorComponentFlags* pColorWriteMasks);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetRasterizationStreamEXT(VkCommandBuffer commandBuffer, uint32_t rasterizationStream) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetRasterizationStreamEXT(VkCommandBuffer commandBuffer, uint32_t rasterizationStream) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetRasterizationStreamEXT(VkCommandBuffer commandBuffer, uint32_t rasterizationStream);

  #define tu_CmdSetRasterizationStreamEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetRasterizationStreamEXT<X>(VkCommandBuffer commandBuffer, uint32_t rasterizationStream);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetConservativeRasterizationModeEXT(VkCommandBuffer commandBuffer, VkConservativeRasterizationModeEXT conservativeRasterizationMode) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetConservativeRasterizationModeEXT(VkCommandBuffer commandBuffer, VkConservativeRasterizationModeEXT conservativeRasterizationMode) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetConservativeRasterizationModeEXT(VkCommandBuffer commandBuffer, VkConservativeRasterizationModeEXT conservativeRasterizationMode);

  #define tu_CmdSetConservativeRasterizationModeEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetConservativeRasterizationModeEXT<X>(VkCommandBuffer commandBuffer, VkConservativeRasterizationModeEXT conservativeRasterizationMode);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetExtraPrimitiveOverestimationSizeEXT(VkCommandBuffer commandBuffer, float extraPrimitiveOverestimationSize) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetExtraPrimitiveOverestimationSizeEXT(VkCommandBuffer commandBuffer, float extraPrimitiveOverestimationSize) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetExtraPrimitiveOverestimationSizeEXT(VkCommandBuffer commandBuffer, float extraPrimitiveOverestimationSize);

  #define tu_CmdSetExtraPrimitiveOverestimationSizeEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetExtraPrimitiveOverestimationSizeEXT<X>(VkCommandBuffer commandBuffer, float extraPrimitiveOverestimationSize);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthClipEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthClipEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetDepthClipEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthClipEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthClipEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthClipEnable);

  #define tu_CmdSetDepthClipEnableEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthClipEnableEXT<X>(VkCommandBuffer commandBuffer, VkBool32 depthClipEnable);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetSampleLocationsEnableEXT(VkCommandBuffer commandBuffer, VkBool32 sampleLocationsEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetSampleLocationsEnableEXT(VkCommandBuffer commandBuffer, VkBool32 sampleLocationsEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetSampleLocationsEnableEXT(VkCommandBuffer commandBuffer, VkBool32 sampleLocationsEnable);

  #define tu_CmdSetSampleLocationsEnableEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetSampleLocationsEnableEXT<X>(VkCommandBuffer commandBuffer, VkBool32 sampleLocationsEnable);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetColorBlendAdvancedEXT(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorBlendAdvancedEXT* pColorBlendAdvanced) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetColorBlendAdvancedEXT(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorBlendAdvancedEXT* pColorBlendAdvanced) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetColorBlendAdvancedEXT(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorBlendAdvancedEXT* pColorBlendAdvanced);

  #define tu_CmdSetColorBlendAdvancedEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetColorBlendAdvancedEXT<X>(VkCommandBuffer commandBuffer, uint32_t firstAttachment, uint32_t attachmentCount, const VkColorBlendAdvancedEXT* pColorBlendAdvanced);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetProvokingVertexModeEXT(VkCommandBuffer commandBuffer, VkProvokingVertexModeEXT provokingVertexMode) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetProvokingVertexModeEXT(VkCommandBuffer commandBuffer, VkProvokingVertexModeEXT provokingVertexMode) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetProvokingVertexModeEXT(VkCommandBuffer commandBuffer, VkProvokingVertexModeEXT provokingVertexMode);

  #define tu_CmdSetProvokingVertexModeEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetProvokingVertexModeEXT<X>(VkCommandBuffer commandBuffer, VkProvokingVertexModeEXT provokingVertexMode);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetLineRasterizationModeEXT(VkCommandBuffer commandBuffer, VkLineRasterizationModeEXT lineRasterizationMode) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetLineRasterizationModeEXT(VkCommandBuffer commandBuffer, VkLineRasterizationModeEXT lineRasterizationMode) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetLineRasterizationModeEXT(VkCommandBuffer commandBuffer, VkLineRasterizationModeEXT lineRasterizationMode);

  #define tu_CmdSetLineRasterizationModeEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetLineRasterizationModeEXT<X>(VkCommandBuffer commandBuffer, VkLineRasterizationModeEXT lineRasterizationMode);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetLineStippleEnableEXT(VkCommandBuffer commandBuffer, VkBool32 stippledLineEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetLineStippleEnableEXT(VkCommandBuffer commandBuffer, VkBool32 stippledLineEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetLineStippleEnableEXT(VkCommandBuffer commandBuffer, VkBool32 stippledLineEnable);

  #define tu_CmdSetLineStippleEnableEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetLineStippleEnableEXT<X>(VkCommandBuffer commandBuffer, VkBool32 stippledLineEnable);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthClipNegativeOneToOneEXT(VkCommandBuffer commandBuffer, VkBool32 negativeOneToOne) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetDepthClipNegativeOneToOneEXT(VkCommandBuffer commandBuffer, VkBool32 negativeOneToOne) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthClipNegativeOneToOneEXT(VkCommandBuffer commandBuffer, VkBool32 negativeOneToOne);

  #define tu_CmdSetDepthClipNegativeOneToOneEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthClipNegativeOneToOneEXT<X>(VkCommandBuffer commandBuffer, VkBool32 negativeOneToOne);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetViewportWScalingEnableNV(VkCommandBuffer commandBuffer, VkBool32 viewportWScalingEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetViewportWScalingEnableNV(VkCommandBuffer commandBuffer, VkBool32 viewportWScalingEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetViewportWScalingEnableNV(VkCommandBuffer commandBuffer, VkBool32 viewportWScalingEnable);

  #define tu_CmdSetViewportWScalingEnableNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetViewportWScalingEnableNV<X>(VkCommandBuffer commandBuffer, VkBool32 viewportWScalingEnable);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetViewportSwizzleNV(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewportSwizzleNV* pViewportSwizzles) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetViewportSwizzleNV(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewportSwizzleNV* pViewportSwizzles) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetViewportSwizzleNV(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewportSwizzleNV* pViewportSwizzles);

  #define tu_CmdSetViewportSwizzleNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetViewportSwizzleNV<X>(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount, const VkViewportSwizzleNV* pViewportSwizzles);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetCoverageToColorEnableNV(VkCommandBuffer commandBuffer, VkBool32 coverageToColorEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetCoverageToColorEnableNV(VkCommandBuffer commandBuffer, VkBool32 coverageToColorEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetCoverageToColorEnableNV(VkCommandBuffer commandBuffer, VkBool32 coverageToColorEnable);

  #define tu_CmdSetCoverageToColorEnableNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetCoverageToColorEnableNV<X>(VkCommandBuffer commandBuffer, VkBool32 coverageToColorEnable);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetCoverageToColorLocationNV(VkCommandBuffer commandBuffer, uint32_t coverageToColorLocation) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetCoverageToColorLocationNV(VkCommandBuffer commandBuffer, uint32_t coverageToColorLocation) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetCoverageToColorLocationNV(VkCommandBuffer commandBuffer, uint32_t coverageToColorLocation);

  #define tu_CmdSetCoverageToColorLocationNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetCoverageToColorLocationNV<X>(VkCommandBuffer commandBuffer, uint32_t coverageToColorLocation);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetCoverageModulationModeNV(VkCommandBuffer commandBuffer, VkCoverageModulationModeNV coverageModulationMode) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetCoverageModulationModeNV(VkCommandBuffer commandBuffer, VkCoverageModulationModeNV coverageModulationMode) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetCoverageModulationModeNV(VkCommandBuffer commandBuffer, VkCoverageModulationModeNV coverageModulationMode);

  #define tu_CmdSetCoverageModulationModeNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetCoverageModulationModeNV<X>(VkCommandBuffer commandBuffer, VkCoverageModulationModeNV coverageModulationMode);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetCoverageModulationTableEnableNV(VkCommandBuffer commandBuffer, VkBool32 coverageModulationTableEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetCoverageModulationTableEnableNV(VkCommandBuffer commandBuffer, VkBool32 coverageModulationTableEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetCoverageModulationTableEnableNV(VkCommandBuffer commandBuffer, VkBool32 coverageModulationTableEnable);

  #define tu_CmdSetCoverageModulationTableEnableNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetCoverageModulationTableEnableNV<X>(VkCommandBuffer commandBuffer, VkBool32 coverageModulationTableEnable);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetCoverageModulationTableNV(VkCommandBuffer commandBuffer, uint32_t coverageModulationTableCount, const float* pCoverageModulationTable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetCoverageModulationTableNV(VkCommandBuffer commandBuffer, uint32_t coverageModulationTableCount, const float* pCoverageModulationTable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetCoverageModulationTableNV(VkCommandBuffer commandBuffer, uint32_t coverageModulationTableCount, const float* pCoverageModulationTable);

  #define tu_CmdSetCoverageModulationTableNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetCoverageModulationTableNV<X>(VkCommandBuffer commandBuffer, uint32_t coverageModulationTableCount, const float* pCoverageModulationTable);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetShadingRateImageEnableNV(VkCommandBuffer commandBuffer, VkBool32 shadingRateImageEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetShadingRateImageEnableNV(VkCommandBuffer commandBuffer, VkBool32 shadingRateImageEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetShadingRateImageEnableNV(VkCommandBuffer commandBuffer, VkBool32 shadingRateImageEnable);

  #define tu_CmdSetShadingRateImageEnableNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetShadingRateImageEnableNV<X>(VkCommandBuffer commandBuffer, VkBool32 shadingRateImageEnable);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetCoverageReductionModeNV(VkCommandBuffer commandBuffer, VkCoverageReductionModeNV coverageReductionMode) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetCoverageReductionModeNV(VkCommandBuffer commandBuffer, VkCoverageReductionModeNV coverageReductionMode) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetCoverageReductionModeNV(VkCommandBuffer commandBuffer, VkCoverageReductionModeNV coverageReductionMode);

  #define tu_CmdSetCoverageReductionModeNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetCoverageReductionModeNV<X>(VkCommandBuffer commandBuffer, VkCoverageReductionModeNV coverageReductionMode);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetRepresentativeFragmentTestEnableNV(VkCommandBuffer commandBuffer, VkBool32 representativeFragmentTestEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetRepresentativeFragmentTestEnableNV(VkCommandBuffer commandBuffer, VkBool32 representativeFragmentTestEnable) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetRepresentativeFragmentTestEnableNV(VkCommandBuffer commandBuffer, VkBool32 representativeFragmentTestEnable);

  #define tu_CmdSetRepresentativeFragmentTestEnableNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetRepresentativeFragmentTestEnableNV<X>(VkCommandBuffer commandBuffer, VkBool32 representativeFragmentTestEnable);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreatePrivateDataSlot(VkDevice device, const VkPrivateDataSlotCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPrivateDataSlot* pPrivateDataSlot) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreatePrivateDataSlot(VkDevice device, const VkPrivateDataSlotCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPrivateDataSlot* pPrivateDataSlot) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreatePrivateDataSlot(VkDevice device, const VkPrivateDataSlotCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPrivateDataSlot* pPrivateDataSlot);

  #define tu_CreatePrivateDataSlot_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreatePrivateDataSlot<X>(VkDevice device, const VkPrivateDataSlotCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPrivateDataSlot* pPrivateDataSlot);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreatePrivateDataSlotEXT(VkDevice device, const VkPrivateDataSlotCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPrivateDataSlot* pPrivateDataSlot) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreatePrivateDataSlotEXT(VkDevice device, const VkPrivateDataSlotCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPrivateDataSlot* pPrivateDataSlot) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreatePrivateDataSlotEXT(VkDevice device, const VkPrivateDataSlotCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPrivateDataSlot* pPrivateDataSlot);

  #define tu_CreatePrivateDataSlotEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreatePrivateDataSlotEXT<X>(VkDevice device, const VkPrivateDataSlotCreateInfo* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkPrivateDataSlot* pPrivateDataSlot);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyPrivateDataSlot(VkDevice device, VkPrivateDataSlot privateDataSlot, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyPrivateDataSlot(VkDevice device, VkPrivateDataSlot privateDataSlot, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyPrivateDataSlot(VkDevice device, VkPrivateDataSlot privateDataSlot, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyPrivateDataSlot_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyPrivateDataSlot<X>(VkDevice device, VkPrivateDataSlot privateDataSlot, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyPrivateDataSlotEXT(VkDevice device, VkPrivateDataSlot privateDataSlot, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyPrivateDataSlotEXT(VkDevice device, VkPrivateDataSlot privateDataSlot, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyPrivateDataSlotEXT(VkDevice device, VkPrivateDataSlot privateDataSlot, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyPrivateDataSlotEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyPrivateDataSlotEXT<X>(VkDevice device, VkPrivateDataSlot privateDataSlot, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR VkResult VKAPI_CALL tu_SetPrivateData(VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t data) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_SetPrivateData(VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t data) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_SetPrivateData(VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t data);

  #define tu_SetPrivateData_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_SetPrivateData<X>(VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t data);

  VKAPI_ATTR VkResult VKAPI_CALL tu_SetPrivateDataEXT(VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t data) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_SetPrivateDataEXT(VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t data) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_SetPrivateDataEXT(VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t data);

  #define tu_SetPrivateDataEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_SetPrivateDataEXT<X>(VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t data);

  VKAPI_ATTR void VKAPI_CALL tu_GetPrivateData(VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetPrivateData(VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetPrivateData(VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t* pData);

  #define tu_GetPrivateData_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetPrivateData<X>(VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t* pData);

  VKAPI_ATTR void VKAPI_CALL tu_GetPrivateDataEXT(VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetPrivateDataEXT(VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetPrivateDataEXT(VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t* pData);

  #define tu_GetPrivateDataEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetPrivateDataEXT<X>(VkDevice device, VkObjectType objectType, uint64_t objectHandle, VkPrivateDataSlot privateDataSlot, uint64_t* pData);

  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyBuffer2(VkCommandBuffer commandBuffer, const VkCopyBufferInfo2* pCopyBufferInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdCopyBuffer2(VkCommandBuffer commandBuffer, const VkCopyBufferInfo2* pCopyBufferInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyBuffer2(VkCommandBuffer commandBuffer, const VkCopyBufferInfo2* pCopyBufferInfo);

  #define tu_CmdCopyBuffer2_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdCopyBuffer2<X>(VkCommandBuffer commandBuffer, const VkCopyBufferInfo2* pCopyBufferInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyBuffer2KHR(VkCommandBuffer commandBuffer, const VkCopyBufferInfo2* pCopyBufferInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdCopyBuffer2KHR(VkCommandBuffer commandBuffer, const VkCopyBufferInfo2* pCopyBufferInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyBuffer2KHR(VkCommandBuffer commandBuffer, const VkCopyBufferInfo2* pCopyBufferInfo);

  #define tu_CmdCopyBuffer2KHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdCopyBuffer2KHR<X>(VkCommandBuffer commandBuffer, const VkCopyBufferInfo2* pCopyBufferInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyImage2(VkCommandBuffer commandBuffer, const VkCopyImageInfo2* pCopyImageInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdCopyImage2(VkCommandBuffer commandBuffer, const VkCopyImageInfo2* pCopyImageInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyImage2(VkCommandBuffer commandBuffer, const VkCopyImageInfo2* pCopyImageInfo);

  #define tu_CmdCopyImage2_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdCopyImage2<X>(VkCommandBuffer commandBuffer, const VkCopyImageInfo2* pCopyImageInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyImage2KHR(VkCommandBuffer commandBuffer, const VkCopyImageInfo2* pCopyImageInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdCopyImage2KHR(VkCommandBuffer commandBuffer, const VkCopyImageInfo2* pCopyImageInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyImage2KHR(VkCommandBuffer commandBuffer, const VkCopyImageInfo2* pCopyImageInfo);

  #define tu_CmdCopyImage2KHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdCopyImage2KHR<X>(VkCommandBuffer commandBuffer, const VkCopyImageInfo2* pCopyImageInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBlitImage2(VkCommandBuffer commandBuffer, const VkBlitImageInfo2* pBlitImageInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBlitImage2(VkCommandBuffer commandBuffer, const VkBlitImageInfo2* pBlitImageInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBlitImage2(VkCommandBuffer commandBuffer, const VkBlitImageInfo2* pBlitImageInfo);

  #define tu_CmdBlitImage2_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBlitImage2<X>(VkCommandBuffer commandBuffer, const VkBlitImageInfo2* pBlitImageInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBlitImage2KHR(VkCommandBuffer commandBuffer, const VkBlitImageInfo2* pBlitImageInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBlitImage2KHR(VkCommandBuffer commandBuffer, const VkBlitImageInfo2* pBlitImageInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBlitImage2KHR(VkCommandBuffer commandBuffer, const VkBlitImageInfo2* pBlitImageInfo);

  #define tu_CmdBlitImage2KHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBlitImage2KHR<X>(VkCommandBuffer commandBuffer, const VkBlitImageInfo2* pBlitImageInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyBufferToImage2(VkCommandBuffer commandBuffer, const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdCopyBufferToImage2(VkCommandBuffer commandBuffer, const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyBufferToImage2(VkCommandBuffer commandBuffer, const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo);

  #define tu_CmdCopyBufferToImage2_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdCopyBufferToImage2<X>(VkCommandBuffer commandBuffer, const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyBufferToImage2KHR(VkCommandBuffer commandBuffer, const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdCopyBufferToImage2KHR(VkCommandBuffer commandBuffer, const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyBufferToImage2KHR(VkCommandBuffer commandBuffer, const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo);

  #define tu_CmdCopyBufferToImage2KHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdCopyBufferToImage2KHR<X>(VkCommandBuffer commandBuffer, const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyImageToBuffer2(VkCommandBuffer commandBuffer, const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdCopyImageToBuffer2(VkCommandBuffer commandBuffer, const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyImageToBuffer2(VkCommandBuffer commandBuffer, const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo);

  #define tu_CmdCopyImageToBuffer2_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdCopyImageToBuffer2<X>(VkCommandBuffer commandBuffer, const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyImageToBuffer2KHR(VkCommandBuffer commandBuffer, const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdCopyImageToBuffer2KHR(VkCommandBuffer commandBuffer, const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyImageToBuffer2KHR(VkCommandBuffer commandBuffer, const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo);

  #define tu_CmdCopyImageToBuffer2KHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdCopyImageToBuffer2KHR<X>(VkCommandBuffer commandBuffer, const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdResolveImage2(VkCommandBuffer commandBuffer, const VkResolveImageInfo2* pResolveImageInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdResolveImage2(VkCommandBuffer commandBuffer, const VkResolveImageInfo2* pResolveImageInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdResolveImage2(VkCommandBuffer commandBuffer, const VkResolveImageInfo2* pResolveImageInfo);

  #define tu_CmdResolveImage2_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdResolveImage2<X>(VkCommandBuffer commandBuffer, const VkResolveImageInfo2* pResolveImageInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdResolveImage2KHR(VkCommandBuffer commandBuffer, const VkResolveImageInfo2* pResolveImageInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdResolveImage2KHR(VkCommandBuffer commandBuffer, const VkResolveImageInfo2* pResolveImageInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdResolveImage2KHR(VkCommandBuffer commandBuffer, const VkResolveImageInfo2* pResolveImageInfo);

  #define tu_CmdResolveImage2KHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdResolveImage2KHR<X>(VkCommandBuffer commandBuffer, const VkResolveImageInfo2* pResolveImageInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetFragmentShadingRateKHR(VkCommandBuffer           commandBuffer, const VkExtent2D*                           pFragmentSize, const VkFragmentShadingRateCombinerOpKHR    combinerOps[2]) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetFragmentShadingRateKHR(VkCommandBuffer           commandBuffer, const VkExtent2D*                           pFragmentSize, const VkFragmentShadingRateCombinerOpKHR    combinerOps[2]) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetFragmentShadingRateKHR(VkCommandBuffer           commandBuffer, const VkExtent2D*                           pFragmentSize, const VkFragmentShadingRateCombinerOpKHR    combinerOps[2]);

  #define tu_CmdSetFragmentShadingRateKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetFragmentShadingRateKHR<X>(VkCommandBuffer           commandBuffer, const VkExtent2D*                           pFragmentSize, const VkFragmentShadingRateCombinerOpKHR    combinerOps[2]);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetFragmentShadingRateEnumNV(VkCommandBuffer           commandBuffer, VkFragmentShadingRateNV                     shadingRate, const VkFragmentShadingRateCombinerOpKHR    combinerOps[2]) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetFragmentShadingRateEnumNV(VkCommandBuffer           commandBuffer, VkFragmentShadingRateNV                     shadingRate, const VkFragmentShadingRateCombinerOpKHR    combinerOps[2]) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetFragmentShadingRateEnumNV(VkCommandBuffer           commandBuffer, VkFragmentShadingRateNV                     shadingRate, const VkFragmentShadingRateCombinerOpKHR    combinerOps[2]);

  #define tu_CmdSetFragmentShadingRateEnumNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetFragmentShadingRateEnumNV<X>(VkCommandBuffer           commandBuffer, VkFragmentShadingRateNV                     shadingRate, const VkFragmentShadingRateCombinerOpKHR    combinerOps[2]);

  VKAPI_ATTR void VKAPI_CALL tu_GetAccelerationStructureBuildSizesKHR(VkDevice                                            device, VkAccelerationStructureBuildTypeKHR                 buildType, const VkAccelerationStructureBuildGeometryInfoKHR*  pBuildInfo, const uint32_t*  pMaxPrimitiveCounts, VkAccelerationStructureBuildSizesInfoKHR*           pSizeInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetAccelerationStructureBuildSizesKHR(VkDevice                                            device, VkAccelerationStructureBuildTypeKHR                 buildType, const VkAccelerationStructureBuildGeometryInfoKHR*  pBuildInfo, const uint32_t*  pMaxPrimitiveCounts, VkAccelerationStructureBuildSizesInfoKHR*           pSizeInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetAccelerationStructureBuildSizesKHR(VkDevice                                            device, VkAccelerationStructureBuildTypeKHR                 buildType, const VkAccelerationStructureBuildGeometryInfoKHR*  pBuildInfo, const uint32_t*  pMaxPrimitiveCounts, VkAccelerationStructureBuildSizesInfoKHR*           pSizeInfo);

  #define tu_GetAccelerationStructureBuildSizesKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetAccelerationStructureBuildSizesKHR<X>(VkDevice                                            device, VkAccelerationStructureBuildTypeKHR                 buildType, const VkAccelerationStructureBuildGeometryInfoKHR*  pBuildInfo, const uint32_t*  pMaxPrimitiveCounts, VkAccelerationStructureBuildSizesInfoKHR*           pSizeInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetVertexInputEXT(VkCommandBuffer commandBuffer, uint32_t vertexBindingDescriptionCount, const VkVertexInputBindingDescription2EXT* pVertexBindingDescriptions, uint32_t vertexAttributeDescriptionCount, const VkVertexInputAttributeDescription2EXT* pVertexAttributeDescriptions) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetVertexInputEXT(VkCommandBuffer commandBuffer, uint32_t vertexBindingDescriptionCount, const VkVertexInputBindingDescription2EXT* pVertexBindingDescriptions, uint32_t vertexAttributeDescriptionCount, const VkVertexInputAttributeDescription2EXT* pVertexAttributeDescriptions) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetVertexInputEXT(VkCommandBuffer commandBuffer, uint32_t vertexBindingDescriptionCount, const VkVertexInputBindingDescription2EXT* pVertexBindingDescriptions, uint32_t vertexAttributeDescriptionCount, const VkVertexInputAttributeDescription2EXT* pVertexAttributeDescriptions);

  #define tu_CmdSetVertexInputEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetVertexInputEXT<X>(VkCommandBuffer commandBuffer, uint32_t vertexBindingDescriptionCount, const VkVertexInputBindingDescription2EXT* pVertexBindingDescriptions, uint32_t vertexAttributeDescriptionCount, const VkVertexInputAttributeDescription2EXT* pVertexAttributeDescriptions);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetColorWriteEnableEXT(VkCommandBuffer       commandBuffer, uint32_t                                attachmentCount, const VkBool32*   pColorWriteEnables) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetColorWriteEnableEXT(VkCommandBuffer       commandBuffer, uint32_t                                attachmentCount, const VkBool32*   pColorWriteEnables) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetColorWriteEnableEXT(VkCommandBuffer       commandBuffer, uint32_t                                attachmentCount, const VkBool32*   pColorWriteEnables);

  #define tu_CmdSetColorWriteEnableEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetColorWriteEnableEXT<X>(VkCommandBuffer       commandBuffer, uint32_t                                attachmentCount, const VkBool32*   pColorWriteEnables);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetEvent2(VkCommandBuffer                   commandBuffer, VkEvent                                             event, const VkDependencyInfo*                             pDependencyInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetEvent2(VkCommandBuffer                   commandBuffer, VkEvent                                             event, const VkDependencyInfo*                             pDependencyInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetEvent2(VkCommandBuffer                   commandBuffer, VkEvent                                             event, const VkDependencyInfo*                             pDependencyInfo);

  #define tu_CmdSetEvent2_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetEvent2<X>(VkCommandBuffer                   commandBuffer, VkEvent                                             event, const VkDependencyInfo*                             pDependencyInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetEvent2KHR(VkCommandBuffer                   commandBuffer, VkEvent                                             event, const VkDependencyInfo*                             pDependencyInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetEvent2KHR(VkCommandBuffer                   commandBuffer, VkEvent                                             event, const VkDependencyInfo*                             pDependencyInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetEvent2KHR(VkCommandBuffer                   commandBuffer, VkEvent                                             event, const VkDependencyInfo*                             pDependencyInfo);

  #define tu_CmdSetEvent2KHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetEvent2KHR<X>(VkCommandBuffer                   commandBuffer, VkEvent                                             event, const VkDependencyInfo*                             pDependencyInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdResetEvent2(VkCommandBuffer                   commandBuffer, VkEvent                                             event, VkPipelineStageFlags2               stageMask) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdResetEvent2(VkCommandBuffer                   commandBuffer, VkEvent                                             event, VkPipelineStageFlags2               stageMask) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdResetEvent2(VkCommandBuffer                   commandBuffer, VkEvent                                             event, VkPipelineStageFlags2               stageMask);

  #define tu_CmdResetEvent2_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdResetEvent2<X>(VkCommandBuffer                   commandBuffer, VkEvent                                             event, VkPipelineStageFlags2               stageMask);

  VKAPI_ATTR void VKAPI_CALL tu_CmdResetEvent2KHR(VkCommandBuffer                   commandBuffer, VkEvent                                             event, VkPipelineStageFlags2               stageMask) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdResetEvent2KHR(VkCommandBuffer                   commandBuffer, VkEvent                                             event, VkPipelineStageFlags2               stageMask) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdResetEvent2KHR(VkCommandBuffer                   commandBuffer, VkEvent                                             event, VkPipelineStageFlags2               stageMask);

  #define tu_CmdResetEvent2KHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdResetEvent2KHR<X>(VkCommandBuffer                   commandBuffer, VkEvent                                             event, VkPipelineStageFlags2               stageMask);

  VKAPI_ATTR void VKAPI_CALL tu_CmdWaitEvents2(VkCommandBuffer                   commandBuffer, uint32_t                                            eventCount, const VkEvent*                     pEvents, const VkDependencyInfo*            pDependencyInfos) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdWaitEvents2(VkCommandBuffer                   commandBuffer, uint32_t                                            eventCount, const VkEvent*                     pEvents, const VkDependencyInfo*            pDependencyInfos) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdWaitEvents2(VkCommandBuffer                   commandBuffer, uint32_t                                            eventCount, const VkEvent*                     pEvents, const VkDependencyInfo*            pDependencyInfos);

  #define tu_CmdWaitEvents2_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdWaitEvents2<X>(VkCommandBuffer                   commandBuffer, uint32_t                                            eventCount, const VkEvent*                     pEvents, const VkDependencyInfo*            pDependencyInfos);

  VKAPI_ATTR void VKAPI_CALL tu_CmdWaitEvents2KHR(VkCommandBuffer                   commandBuffer, uint32_t                                            eventCount, const VkEvent*                     pEvents, const VkDependencyInfo*            pDependencyInfos) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdWaitEvents2KHR(VkCommandBuffer                   commandBuffer, uint32_t                                            eventCount, const VkEvent*                     pEvents, const VkDependencyInfo*            pDependencyInfos) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdWaitEvents2KHR(VkCommandBuffer                   commandBuffer, uint32_t                                            eventCount, const VkEvent*                     pEvents, const VkDependencyInfo*            pDependencyInfos);

  #define tu_CmdWaitEvents2KHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdWaitEvents2KHR<X>(VkCommandBuffer                   commandBuffer, uint32_t                                            eventCount, const VkEvent*                     pEvents, const VkDependencyInfo*            pDependencyInfos);

  VKAPI_ATTR void VKAPI_CALL tu_CmdPipelineBarrier2(VkCommandBuffer                   commandBuffer, const VkDependencyInfo*                             pDependencyInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdPipelineBarrier2(VkCommandBuffer                   commandBuffer, const VkDependencyInfo*                             pDependencyInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdPipelineBarrier2(VkCommandBuffer                   commandBuffer, const VkDependencyInfo*                             pDependencyInfo);

  #define tu_CmdPipelineBarrier2_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdPipelineBarrier2<X>(VkCommandBuffer                   commandBuffer, const VkDependencyInfo*                             pDependencyInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdPipelineBarrier2KHR(VkCommandBuffer                   commandBuffer, const VkDependencyInfo*                             pDependencyInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdPipelineBarrier2KHR(VkCommandBuffer                   commandBuffer, const VkDependencyInfo*                             pDependencyInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdPipelineBarrier2KHR(VkCommandBuffer                   commandBuffer, const VkDependencyInfo*                             pDependencyInfo);

  #define tu_CmdPipelineBarrier2KHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdPipelineBarrier2KHR<X>(VkCommandBuffer                   commandBuffer, const VkDependencyInfo*                             pDependencyInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_QueueSubmit2(VkQueue                           queue, uint32_t                            submitCount, const VkSubmitInfo2*              pSubmits, VkFence           fence) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_QueueSubmit2(VkQueue                           queue, uint32_t                            submitCount, const VkSubmitInfo2*              pSubmits, VkFence           fence) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_QueueSubmit2(VkQueue                           queue, uint32_t                            submitCount, const VkSubmitInfo2*              pSubmits, VkFence           fence);

  #define tu_QueueSubmit2_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_QueueSubmit2<X>(VkQueue                           queue, uint32_t                            submitCount, const VkSubmitInfo2*              pSubmits, VkFence           fence);

  VKAPI_ATTR VkResult VKAPI_CALL tu_QueueSubmit2KHR(VkQueue                           queue, uint32_t                            submitCount, const VkSubmitInfo2*              pSubmits, VkFence           fence) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_QueueSubmit2KHR(VkQueue                           queue, uint32_t                            submitCount, const VkSubmitInfo2*              pSubmits, VkFence           fence) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_QueueSubmit2KHR(VkQueue                           queue, uint32_t                            submitCount, const VkSubmitInfo2*              pSubmits, VkFence           fence);

  #define tu_QueueSubmit2KHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_QueueSubmit2KHR<X>(VkQueue                           queue, uint32_t                            submitCount, const VkSubmitInfo2*              pSubmits, VkFence           fence);

  VKAPI_ATTR void VKAPI_CALL tu_CmdWriteTimestamp2(VkCommandBuffer                   commandBuffer, VkPipelineStageFlags2               stage, VkQueryPool                                         queryPool, uint32_t                                            query) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdWriteTimestamp2(VkCommandBuffer                   commandBuffer, VkPipelineStageFlags2               stage, VkQueryPool                                         queryPool, uint32_t                                            query) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdWriteTimestamp2(VkCommandBuffer                   commandBuffer, VkPipelineStageFlags2               stage, VkQueryPool                                         queryPool, uint32_t                                            query);

  #define tu_CmdWriteTimestamp2_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdWriteTimestamp2<X>(VkCommandBuffer                   commandBuffer, VkPipelineStageFlags2               stage, VkQueryPool                                         queryPool, uint32_t                                            query);

  VKAPI_ATTR void VKAPI_CALL tu_CmdWriteTimestamp2KHR(VkCommandBuffer                   commandBuffer, VkPipelineStageFlags2               stage, VkQueryPool                                         queryPool, uint32_t                                            query) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdWriteTimestamp2KHR(VkCommandBuffer                   commandBuffer, VkPipelineStageFlags2               stage, VkQueryPool                                         queryPool, uint32_t                                            query) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdWriteTimestamp2KHR(VkCommandBuffer                   commandBuffer, VkPipelineStageFlags2               stage, VkQueryPool                                         queryPool, uint32_t                                            query);

  #define tu_CmdWriteTimestamp2KHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdWriteTimestamp2KHR<X>(VkCommandBuffer                   commandBuffer, VkPipelineStageFlags2               stage, VkQueryPool                                         queryPool, uint32_t                                            query);

  VKAPI_ATTR void VKAPI_CALL tu_CmdWriteBufferMarker2AMD(VkCommandBuffer                   commandBuffer, VkPipelineStageFlags2               stage, VkBuffer                                            dstBuffer, VkDeviceSize                                        dstOffset, uint32_t                                            marker) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdWriteBufferMarker2AMD(VkCommandBuffer                   commandBuffer, VkPipelineStageFlags2               stage, VkBuffer                                            dstBuffer, VkDeviceSize                                        dstOffset, uint32_t                                            marker) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdWriteBufferMarker2AMD(VkCommandBuffer                   commandBuffer, VkPipelineStageFlags2               stage, VkBuffer                                            dstBuffer, VkDeviceSize                                        dstOffset, uint32_t                                            marker);

  #define tu_CmdWriteBufferMarker2AMD_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdWriteBufferMarker2AMD<X>(VkCommandBuffer                   commandBuffer, VkPipelineStageFlags2               stage, VkBuffer                                            dstBuffer, VkDeviceSize                                        dstOffset, uint32_t                                            marker);

  VKAPI_ATTR void VKAPI_CALL tu_GetQueueCheckpointData2NV(VkQueue queue, uint32_t* pCheckpointDataCount, VkCheckpointData2NV* pCheckpointData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetQueueCheckpointData2NV(VkQueue queue, uint32_t* pCheckpointDataCount, VkCheckpointData2NV* pCheckpointData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetQueueCheckpointData2NV(VkQueue queue, uint32_t* pCheckpointDataCount, VkCheckpointData2NV* pCheckpointData);

  #define tu_GetQueueCheckpointData2NV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetQueueCheckpointData2NV<X>(VkQueue queue, uint32_t* pCheckpointDataCount, VkCheckpointData2NV* pCheckpointData);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CopyMemoryToImage(VkDevice device, const VkCopyMemoryToImageInfo*    pCopyMemoryToImageInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CopyMemoryToImage(VkDevice device, const VkCopyMemoryToImageInfo*    pCopyMemoryToImageInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CopyMemoryToImage(VkDevice device, const VkCopyMemoryToImageInfo*    pCopyMemoryToImageInfo);

  #define tu_CopyMemoryToImage_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CopyMemoryToImage<X>(VkDevice device, const VkCopyMemoryToImageInfo*    pCopyMemoryToImageInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CopyMemoryToImageEXT(VkDevice device, const VkCopyMemoryToImageInfo*    pCopyMemoryToImageInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CopyMemoryToImageEXT(VkDevice device, const VkCopyMemoryToImageInfo*    pCopyMemoryToImageInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CopyMemoryToImageEXT(VkDevice device, const VkCopyMemoryToImageInfo*    pCopyMemoryToImageInfo);

  #define tu_CopyMemoryToImageEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CopyMemoryToImageEXT<X>(VkDevice device, const VkCopyMemoryToImageInfo*    pCopyMemoryToImageInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CopyImageToMemory(VkDevice device, const VkCopyImageToMemoryInfo*    pCopyImageToMemoryInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CopyImageToMemory(VkDevice device, const VkCopyImageToMemoryInfo*    pCopyImageToMemoryInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CopyImageToMemory(VkDevice device, const VkCopyImageToMemoryInfo*    pCopyImageToMemoryInfo);

  #define tu_CopyImageToMemory_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CopyImageToMemory<X>(VkDevice device, const VkCopyImageToMemoryInfo*    pCopyImageToMemoryInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CopyImageToMemoryEXT(VkDevice device, const VkCopyImageToMemoryInfo*    pCopyImageToMemoryInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CopyImageToMemoryEXT(VkDevice device, const VkCopyImageToMemoryInfo*    pCopyImageToMemoryInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CopyImageToMemoryEXT(VkDevice device, const VkCopyImageToMemoryInfo*    pCopyImageToMemoryInfo);

  #define tu_CopyImageToMemoryEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CopyImageToMemoryEXT<X>(VkDevice device, const VkCopyImageToMemoryInfo*    pCopyImageToMemoryInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CopyImageToImage(VkDevice device, const VkCopyImageToImageInfo*    pCopyImageToImageInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CopyImageToImage(VkDevice device, const VkCopyImageToImageInfo*    pCopyImageToImageInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CopyImageToImage(VkDevice device, const VkCopyImageToImageInfo*    pCopyImageToImageInfo);

  #define tu_CopyImageToImage_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CopyImageToImage<X>(VkDevice device, const VkCopyImageToImageInfo*    pCopyImageToImageInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CopyImageToImageEXT(VkDevice device, const VkCopyImageToImageInfo*    pCopyImageToImageInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CopyImageToImageEXT(VkDevice device, const VkCopyImageToImageInfo*    pCopyImageToImageInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CopyImageToImageEXT(VkDevice device, const VkCopyImageToImageInfo*    pCopyImageToImageInfo);

  #define tu_CopyImageToImageEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CopyImageToImageEXT<X>(VkDevice device, const VkCopyImageToImageInfo*    pCopyImageToImageInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_TransitionImageLayout(VkDevice device, uint32_t transitionCount, const VkHostImageLayoutTransitionInfo*    pTransitions) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_TransitionImageLayout(VkDevice device, uint32_t transitionCount, const VkHostImageLayoutTransitionInfo*    pTransitions) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_TransitionImageLayout(VkDevice device, uint32_t transitionCount, const VkHostImageLayoutTransitionInfo*    pTransitions);

  #define tu_TransitionImageLayout_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_TransitionImageLayout<X>(VkDevice device, uint32_t transitionCount, const VkHostImageLayoutTransitionInfo*    pTransitions);

  VKAPI_ATTR VkResult VKAPI_CALL tu_TransitionImageLayoutEXT(VkDevice device, uint32_t transitionCount, const VkHostImageLayoutTransitionInfo*    pTransitions) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_TransitionImageLayoutEXT(VkDevice device, uint32_t transitionCount, const VkHostImageLayoutTransitionInfo*    pTransitions) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_TransitionImageLayoutEXT(VkDevice device, uint32_t transitionCount, const VkHostImageLayoutTransitionInfo*    pTransitions);

  #define tu_TransitionImageLayoutEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_TransitionImageLayoutEXT<X>(VkDevice device, uint32_t transitionCount, const VkHostImageLayoutTransitionInfo*    pTransitions);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateVideoSessionKHR(VkDevice device, const VkVideoSessionCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkVideoSessionKHR* pVideoSession) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateVideoSessionKHR(VkDevice device, const VkVideoSessionCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkVideoSessionKHR* pVideoSession) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateVideoSessionKHR(VkDevice device, const VkVideoSessionCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkVideoSessionKHR* pVideoSession);

  #define tu_CreateVideoSessionKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateVideoSessionKHR<X>(VkDevice device, const VkVideoSessionCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkVideoSessionKHR* pVideoSession);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyVideoSessionKHR(VkDevice device, VkVideoSessionKHR videoSession, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyVideoSessionKHR(VkDevice device, VkVideoSessionKHR videoSession, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyVideoSessionKHR(VkDevice device, VkVideoSessionKHR videoSession, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyVideoSessionKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyVideoSessionKHR<X>(VkDevice device, VkVideoSessionKHR videoSession, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateVideoSessionParametersKHR(VkDevice device, const VkVideoSessionParametersCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkVideoSessionParametersKHR* pVideoSessionParameters) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateVideoSessionParametersKHR(VkDevice device, const VkVideoSessionParametersCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkVideoSessionParametersKHR* pVideoSessionParameters) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateVideoSessionParametersKHR(VkDevice device, const VkVideoSessionParametersCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkVideoSessionParametersKHR* pVideoSessionParameters);

  #define tu_CreateVideoSessionParametersKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateVideoSessionParametersKHR<X>(VkDevice device, const VkVideoSessionParametersCreateInfoKHR* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkVideoSessionParametersKHR* pVideoSessionParameters);

  VKAPI_ATTR VkResult VKAPI_CALL tu_UpdateVideoSessionParametersKHR(VkDevice device, VkVideoSessionParametersKHR videoSessionParameters, const VkVideoSessionParametersUpdateInfoKHR* pUpdateInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_UpdateVideoSessionParametersKHR(VkDevice device, VkVideoSessionParametersKHR videoSessionParameters, const VkVideoSessionParametersUpdateInfoKHR* pUpdateInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_UpdateVideoSessionParametersKHR(VkDevice device, VkVideoSessionParametersKHR videoSessionParameters, const VkVideoSessionParametersUpdateInfoKHR* pUpdateInfo);

  #define tu_UpdateVideoSessionParametersKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_UpdateVideoSessionParametersKHR<X>(VkDevice device, VkVideoSessionParametersKHR videoSessionParameters, const VkVideoSessionParametersUpdateInfoKHR* pUpdateInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetEncodedVideoSessionParametersKHR(VkDevice device, const VkVideoEncodeSessionParametersGetInfoKHR* pVideoSessionParametersInfo, VkVideoEncodeSessionParametersFeedbackInfoKHR* pFeedbackInfo, size_t* pDataSize, void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetEncodedVideoSessionParametersKHR(VkDevice device, const VkVideoEncodeSessionParametersGetInfoKHR* pVideoSessionParametersInfo, VkVideoEncodeSessionParametersFeedbackInfoKHR* pFeedbackInfo, size_t* pDataSize, void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetEncodedVideoSessionParametersKHR(VkDevice device, const VkVideoEncodeSessionParametersGetInfoKHR* pVideoSessionParametersInfo, VkVideoEncodeSessionParametersFeedbackInfoKHR* pFeedbackInfo, size_t* pDataSize, void* pData);

  #define tu_GetEncodedVideoSessionParametersKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetEncodedVideoSessionParametersKHR<X>(VkDevice device, const VkVideoEncodeSessionParametersGetInfoKHR* pVideoSessionParametersInfo, VkVideoEncodeSessionParametersFeedbackInfoKHR* pFeedbackInfo, size_t* pDataSize, void* pData);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyVideoSessionParametersKHR(VkDevice device, VkVideoSessionParametersKHR videoSessionParameters, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyVideoSessionParametersKHR(VkDevice device, VkVideoSessionParametersKHR videoSessionParameters, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyVideoSessionParametersKHR(VkDevice device, VkVideoSessionParametersKHR videoSessionParameters, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyVideoSessionParametersKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyVideoSessionParametersKHR<X>(VkDevice device, VkVideoSessionParametersKHR videoSessionParameters, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetVideoSessionMemoryRequirementsKHR(VkDevice device, VkVideoSessionKHR videoSession, uint32_t* pMemoryRequirementsCount, VkVideoSessionMemoryRequirementsKHR* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetVideoSessionMemoryRequirementsKHR(VkDevice device, VkVideoSessionKHR videoSession, uint32_t* pMemoryRequirementsCount, VkVideoSessionMemoryRequirementsKHR* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetVideoSessionMemoryRequirementsKHR(VkDevice device, VkVideoSessionKHR videoSession, uint32_t* pMemoryRequirementsCount, VkVideoSessionMemoryRequirementsKHR* pMemoryRequirements);

  #define tu_GetVideoSessionMemoryRequirementsKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetVideoSessionMemoryRequirementsKHR<X>(VkDevice device, VkVideoSessionKHR videoSession, uint32_t* pMemoryRequirementsCount, VkVideoSessionMemoryRequirementsKHR* pMemoryRequirements);

  VKAPI_ATTR VkResult VKAPI_CALL tu_BindVideoSessionMemoryKHR(VkDevice device, VkVideoSessionKHR videoSession, uint32_t bindSessionMemoryInfoCount, const VkBindVideoSessionMemoryInfoKHR* pBindSessionMemoryInfos) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_BindVideoSessionMemoryKHR(VkDevice device, VkVideoSessionKHR videoSession, uint32_t bindSessionMemoryInfoCount, const VkBindVideoSessionMemoryInfoKHR* pBindSessionMemoryInfos) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_BindVideoSessionMemoryKHR(VkDevice device, VkVideoSessionKHR videoSession, uint32_t bindSessionMemoryInfoCount, const VkBindVideoSessionMemoryInfoKHR* pBindSessionMemoryInfos);

  #define tu_BindVideoSessionMemoryKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_BindVideoSessionMemoryKHR<X>(VkDevice device, VkVideoSessionKHR videoSession, uint32_t bindSessionMemoryInfoCount, const VkBindVideoSessionMemoryInfoKHR* pBindSessionMemoryInfos);

  VKAPI_ATTR void VKAPI_CALL tu_CmdDecodeVideoKHR(VkCommandBuffer commandBuffer, const VkVideoDecodeInfoKHR* pDecodeInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDecodeVideoKHR(VkCommandBuffer commandBuffer, const VkVideoDecodeInfoKHR* pDecodeInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDecodeVideoKHR(VkCommandBuffer commandBuffer, const VkVideoDecodeInfoKHR* pDecodeInfo);

  #define tu_CmdDecodeVideoKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDecodeVideoKHR<X>(VkCommandBuffer commandBuffer, const VkVideoDecodeInfoKHR* pDecodeInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBeginVideoCodingKHR(VkCommandBuffer commandBuffer, const VkVideoBeginCodingInfoKHR* pBeginInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBeginVideoCodingKHR(VkCommandBuffer commandBuffer, const VkVideoBeginCodingInfoKHR* pBeginInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBeginVideoCodingKHR(VkCommandBuffer commandBuffer, const VkVideoBeginCodingInfoKHR* pBeginInfo);

  #define tu_CmdBeginVideoCodingKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBeginVideoCodingKHR<X>(VkCommandBuffer commandBuffer, const VkVideoBeginCodingInfoKHR* pBeginInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdControlVideoCodingKHR(VkCommandBuffer commandBuffer, const VkVideoCodingControlInfoKHR* pCodingControlInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdControlVideoCodingKHR(VkCommandBuffer commandBuffer, const VkVideoCodingControlInfoKHR* pCodingControlInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdControlVideoCodingKHR(VkCommandBuffer commandBuffer, const VkVideoCodingControlInfoKHR* pCodingControlInfo);

  #define tu_CmdControlVideoCodingKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdControlVideoCodingKHR<X>(VkCommandBuffer commandBuffer, const VkVideoCodingControlInfoKHR* pCodingControlInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdEndVideoCodingKHR(VkCommandBuffer commandBuffer, const VkVideoEndCodingInfoKHR* pEndCodingInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdEndVideoCodingKHR(VkCommandBuffer commandBuffer, const VkVideoEndCodingInfoKHR* pEndCodingInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdEndVideoCodingKHR(VkCommandBuffer commandBuffer, const VkVideoEndCodingInfoKHR* pEndCodingInfo);

  #define tu_CmdEndVideoCodingKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdEndVideoCodingKHR<X>(VkCommandBuffer commandBuffer, const VkVideoEndCodingInfoKHR* pEndCodingInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdEncodeVideoKHR(VkCommandBuffer commandBuffer, const VkVideoEncodeInfoKHR* pEncodeInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdEncodeVideoKHR(VkCommandBuffer commandBuffer, const VkVideoEncodeInfoKHR* pEncodeInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdEncodeVideoKHR(VkCommandBuffer commandBuffer, const VkVideoEncodeInfoKHR* pEncodeInfo);

  #define tu_CmdEncodeVideoKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdEncodeVideoKHR<X>(VkCommandBuffer commandBuffer, const VkVideoEncodeInfoKHR* pEncodeInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdDecompressMemoryNV(VkCommandBuffer commandBuffer, uint32_t decompressRegionCount, const VkDecompressMemoryRegionNV* pDecompressMemoryRegions) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDecompressMemoryNV(VkCommandBuffer commandBuffer, uint32_t decompressRegionCount, const VkDecompressMemoryRegionNV* pDecompressMemoryRegions) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDecompressMemoryNV(VkCommandBuffer commandBuffer, uint32_t decompressRegionCount, const VkDecompressMemoryRegionNV* pDecompressMemoryRegions);

  #define tu_CmdDecompressMemoryNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDecompressMemoryNV<X>(VkCommandBuffer commandBuffer, uint32_t decompressRegionCount, const VkDecompressMemoryRegionNV* pDecompressMemoryRegions);

  VKAPI_ATTR void VKAPI_CALL tu_CmdDecompressMemoryIndirectCountNV(VkCommandBuffer commandBuffer, VkDeviceAddress indirectCommandsAddress, VkDeviceAddress indirectCommandsCountAddress, uint32_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDecompressMemoryIndirectCountNV(VkCommandBuffer commandBuffer, VkDeviceAddress indirectCommandsAddress, VkDeviceAddress indirectCommandsCountAddress, uint32_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDecompressMemoryIndirectCountNV(VkCommandBuffer commandBuffer, VkDeviceAddress indirectCommandsAddress, VkDeviceAddress indirectCommandsCountAddress, uint32_t stride);

  #define tu_CmdDecompressMemoryIndirectCountNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDecompressMemoryIndirectCountNV<X>(VkCommandBuffer commandBuffer, VkDeviceAddress indirectCommandsAddress, VkDeviceAddress indirectCommandsCountAddress, uint32_t stride);

  VKAPI_ATTR void VKAPI_CALL tu_GetPartitionedAccelerationStructuresBuildSizesNV(VkDevice device, const VkPartitionedAccelerationStructureInstancesInputNV* pInfo, VkAccelerationStructureBuildSizesInfoKHR*                  pSizeInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetPartitionedAccelerationStructuresBuildSizesNV(VkDevice device, const VkPartitionedAccelerationStructureInstancesInputNV* pInfo, VkAccelerationStructureBuildSizesInfoKHR*                  pSizeInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetPartitionedAccelerationStructuresBuildSizesNV(VkDevice device, const VkPartitionedAccelerationStructureInstancesInputNV* pInfo, VkAccelerationStructureBuildSizesInfoKHR*                  pSizeInfo);

  #define tu_GetPartitionedAccelerationStructuresBuildSizesNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetPartitionedAccelerationStructuresBuildSizesNV<X>(VkDevice device, const VkPartitionedAccelerationStructureInstancesInputNV* pInfo, VkAccelerationStructureBuildSizesInfoKHR*                  pSizeInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBuildPartitionedAccelerationStructuresNV(VkCommandBuffer                     commandBuffer, const VkBuildPartitionedAccelerationStructureInfoNV*  pBuildInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBuildPartitionedAccelerationStructuresNV(VkCommandBuffer                     commandBuffer, const VkBuildPartitionedAccelerationStructureInfoNV*  pBuildInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBuildPartitionedAccelerationStructuresNV(VkCommandBuffer                     commandBuffer, const VkBuildPartitionedAccelerationStructureInfoNV*  pBuildInfo);

  #define tu_CmdBuildPartitionedAccelerationStructuresNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBuildPartitionedAccelerationStructuresNV<X>(VkCommandBuffer                     commandBuffer, const VkBuildPartitionedAccelerationStructureInfoNV*  pBuildInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdDecompressMemoryEXT(VkCommandBuffer commandBuffer, const VkDecompressMemoryInfoEXT* pDecompressMemoryInfoEXT) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDecompressMemoryEXT(VkCommandBuffer commandBuffer, const VkDecompressMemoryInfoEXT* pDecompressMemoryInfoEXT) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDecompressMemoryEXT(VkCommandBuffer commandBuffer, const VkDecompressMemoryInfoEXT* pDecompressMemoryInfoEXT);

  #define tu_CmdDecompressMemoryEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDecompressMemoryEXT<X>(VkCommandBuffer commandBuffer, const VkDecompressMemoryInfoEXT* pDecompressMemoryInfoEXT);

  VKAPI_ATTR void VKAPI_CALL tu_CmdDecompressMemoryIndirectCountEXT(VkCommandBuffer commandBuffer, VkMemoryDecompressionMethodFlagsEXT decompressionMethod, VkDeviceAddress indirectCommandsAddress, VkDeviceAddress indirectCommandsCountAddress, uint32_t maxDecompressionCount, uint32_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDecompressMemoryIndirectCountEXT(VkCommandBuffer commandBuffer, VkMemoryDecompressionMethodFlagsEXT decompressionMethod, VkDeviceAddress indirectCommandsAddress, VkDeviceAddress indirectCommandsCountAddress, uint32_t maxDecompressionCount, uint32_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDecompressMemoryIndirectCountEXT(VkCommandBuffer commandBuffer, VkMemoryDecompressionMethodFlagsEXT decompressionMethod, VkDeviceAddress indirectCommandsAddress, VkDeviceAddress indirectCommandsCountAddress, uint32_t maxDecompressionCount, uint32_t stride);

  #define tu_CmdDecompressMemoryIndirectCountEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDecompressMemoryIndirectCountEXT<X>(VkCommandBuffer commandBuffer, VkMemoryDecompressionMethodFlagsEXT decompressionMethod, VkDeviceAddress indirectCommandsAddress, VkDeviceAddress indirectCommandsCountAddress, uint32_t maxDecompressionCount, uint32_t stride);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateCuModuleNVX(VkDevice device, const VkCuModuleCreateInfoNVX* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCuModuleNVX* pModule) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateCuModuleNVX(VkDevice device, const VkCuModuleCreateInfoNVX* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCuModuleNVX* pModule) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateCuModuleNVX(VkDevice device, const VkCuModuleCreateInfoNVX* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCuModuleNVX* pModule);

  #define tu_CreateCuModuleNVX_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateCuModuleNVX<X>(VkDevice device, const VkCuModuleCreateInfoNVX* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCuModuleNVX* pModule);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateCuFunctionNVX(VkDevice device, const VkCuFunctionCreateInfoNVX* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCuFunctionNVX* pFunction) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateCuFunctionNVX(VkDevice device, const VkCuFunctionCreateInfoNVX* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCuFunctionNVX* pFunction) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateCuFunctionNVX(VkDevice device, const VkCuFunctionCreateInfoNVX* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCuFunctionNVX* pFunction);

  #define tu_CreateCuFunctionNVX_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateCuFunctionNVX<X>(VkDevice device, const VkCuFunctionCreateInfoNVX* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkCuFunctionNVX* pFunction);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyCuModuleNVX(VkDevice device, VkCuModuleNVX module, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyCuModuleNVX(VkDevice device, VkCuModuleNVX module, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyCuModuleNVX(VkDevice device, VkCuModuleNVX module, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyCuModuleNVX_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyCuModuleNVX<X>(VkDevice device, VkCuModuleNVX module, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyCuFunctionNVX(VkDevice device, VkCuFunctionNVX function, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyCuFunctionNVX(VkDevice device, VkCuFunctionNVX function, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyCuFunctionNVX(VkDevice device, VkCuFunctionNVX function, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyCuFunctionNVX_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyCuFunctionNVX<X>(VkDevice device, VkCuFunctionNVX function, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR void VKAPI_CALL tu_CmdCuLaunchKernelNVX(VkCommandBuffer commandBuffer, const VkCuLaunchInfoNVX* pLaunchInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdCuLaunchKernelNVX(VkCommandBuffer commandBuffer, const VkCuLaunchInfoNVX* pLaunchInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdCuLaunchKernelNVX(VkCommandBuffer commandBuffer, const VkCuLaunchInfoNVX* pLaunchInfo);

  #define tu_CmdCuLaunchKernelNVX_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdCuLaunchKernelNVX<X>(VkCommandBuffer commandBuffer, const VkCuLaunchInfoNVX* pLaunchInfo);

  VKAPI_ATTR void VKAPI_CALL tu_GetDescriptorSetLayoutSizeEXT(VkDevice device, VkDescriptorSetLayout layout, VkDeviceSize* pLayoutSizeInBytes) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetDescriptorSetLayoutSizeEXT(VkDevice device, VkDescriptorSetLayout layout, VkDeviceSize* pLayoutSizeInBytes) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetDescriptorSetLayoutSizeEXT(VkDevice device, VkDescriptorSetLayout layout, VkDeviceSize* pLayoutSizeInBytes);

  #define tu_GetDescriptorSetLayoutSizeEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetDescriptorSetLayoutSizeEXT<X>(VkDevice device, VkDescriptorSetLayout layout, VkDeviceSize* pLayoutSizeInBytes);

  VKAPI_ATTR void VKAPI_CALL tu_GetDescriptorSetLayoutBindingOffsetEXT(VkDevice device, VkDescriptorSetLayout layout, uint32_t binding, VkDeviceSize* pOffset) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetDescriptorSetLayoutBindingOffsetEXT(VkDevice device, VkDescriptorSetLayout layout, uint32_t binding, VkDeviceSize* pOffset) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetDescriptorSetLayoutBindingOffsetEXT(VkDevice device, VkDescriptorSetLayout layout, uint32_t binding, VkDeviceSize* pOffset);

  #define tu_GetDescriptorSetLayoutBindingOffsetEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetDescriptorSetLayoutBindingOffsetEXT<X>(VkDevice device, VkDescriptorSetLayout layout, uint32_t binding, VkDeviceSize* pOffset);

  VKAPI_ATTR void VKAPI_CALL tu_GetDescriptorEXT(VkDevice device, const VkDescriptorGetInfoEXT* pDescriptorInfo, size_t dataSize, void* pDescriptor) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetDescriptorEXT(VkDevice device, const VkDescriptorGetInfoEXT* pDescriptorInfo, size_t dataSize, void* pDescriptor) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetDescriptorEXT(VkDevice device, const VkDescriptorGetInfoEXT* pDescriptorInfo, size_t dataSize, void* pDescriptor);

  #define tu_GetDescriptorEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetDescriptorEXT<X>(VkDevice device, const VkDescriptorGetInfoEXT* pDescriptorInfo, size_t dataSize, void* pDescriptor);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBindDescriptorBuffersEXT(VkCommandBuffer commandBuffer, uint32_t bufferCount, const VkDescriptorBufferBindingInfoEXT* pBindingInfos) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBindDescriptorBuffersEXT(VkCommandBuffer commandBuffer, uint32_t bufferCount, const VkDescriptorBufferBindingInfoEXT* pBindingInfos) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBindDescriptorBuffersEXT(VkCommandBuffer commandBuffer, uint32_t bufferCount, const VkDescriptorBufferBindingInfoEXT* pBindingInfos);

  #define tu_CmdBindDescriptorBuffersEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBindDescriptorBuffersEXT<X>(VkCommandBuffer commandBuffer, uint32_t bufferCount, const VkDescriptorBufferBindingInfoEXT* pBindingInfos);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDescriptorBufferOffsetsEXT(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t setCount, const uint32_t* pBufferIndices, const VkDeviceSize* pOffsets) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetDescriptorBufferOffsetsEXT(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t setCount, const uint32_t* pBufferIndices, const VkDeviceSize* pOffsets) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDescriptorBufferOffsetsEXT(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t setCount, const uint32_t* pBufferIndices, const VkDeviceSize* pOffsets);

  #define tu_CmdSetDescriptorBufferOffsetsEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetDescriptorBufferOffsetsEXT<X>(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t firstSet, uint32_t setCount, const uint32_t* pBufferIndices, const VkDeviceSize* pOffsets);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBindDescriptorBufferEmbeddedSamplersEXT(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t set) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBindDescriptorBufferEmbeddedSamplersEXT(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t set) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBindDescriptorBufferEmbeddedSamplersEXT(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t set);

  #define tu_CmdBindDescriptorBufferEmbeddedSamplersEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBindDescriptorBufferEmbeddedSamplersEXT<X>(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint, VkPipelineLayout layout, uint32_t set);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetBufferOpaqueCaptureDescriptorDataEXT(VkDevice device, const VkBufferCaptureDescriptorDataInfoEXT* pInfo, void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetBufferOpaqueCaptureDescriptorDataEXT(VkDevice device, const VkBufferCaptureDescriptorDataInfoEXT* pInfo, void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetBufferOpaqueCaptureDescriptorDataEXT(VkDevice device, const VkBufferCaptureDescriptorDataInfoEXT* pInfo, void* pData);

  #define tu_GetBufferOpaqueCaptureDescriptorDataEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetBufferOpaqueCaptureDescriptorDataEXT<X>(VkDevice device, const VkBufferCaptureDescriptorDataInfoEXT* pInfo, void* pData);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetImageOpaqueCaptureDescriptorDataEXT(VkDevice device, const VkImageCaptureDescriptorDataInfoEXT* pInfo, void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetImageOpaqueCaptureDescriptorDataEXT(VkDevice device, const VkImageCaptureDescriptorDataInfoEXT* pInfo, void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetImageOpaqueCaptureDescriptorDataEXT(VkDevice device, const VkImageCaptureDescriptorDataInfoEXT* pInfo, void* pData);

  #define tu_GetImageOpaqueCaptureDescriptorDataEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetImageOpaqueCaptureDescriptorDataEXT<X>(VkDevice device, const VkImageCaptureDescriptorDataInfoEXT* pInfo, void* pData);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetImageViewOpaqueCaptureDescriptorDataEXT(VkDevice device, const VkImageViewCaptureDescriptorDataInfoEXT* pInfo, void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetImageViewOpaqueCaptureDescriptorDataEXT(VkDevice device, const VkImageViewCaptureDescriptorDataInfoEXT* pInfo, void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetImageViewOpaqueCaptureDescriptorDataEXT(VkDevice device, const VkImageViewCaptureDescriptorDataInfoEXT* pInfo, void* pData);

  #define tu_GetImageViewOpaqueCaptureDescriptorDataEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetImageViewOpaqueCaptureDescriptorDataEXT<X>(VkDevice device, const VkImageViewCaptureDescriptorDataInfoEXT* pInfo, void* pData);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetSamplerOpaqueCaptureDescriptorDataEXT(VkDevice device, const VkSamplerCaptureDescriptorDataInfoEXT* pInfo, void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetSamplerOpaqueCaptureDescriptorDataEXT(VkDevice device, const VkSamplerCaptureDescriptorDataInfoEXT* pInfo, void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetSamplerOpaqueCaptureDescriptorDataEXT(VkDevice device, const VkSamplerCaptureDescriptorDataInfoEXT* pInfo, void* pData);

  #define tu_GetSamplerOpaqueCaptureDescriptorDataEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetSamplerOpaqueCaptureDescriptorDataEXT<X>(VkDevice device, const VkSamplerCaptureDescriptorDataInfoEXT* pInfo, void* pData);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetAccelerationStructureOpaqueCaptureDescriptorDataEXT(VkDevice device, const VkAccelerationStructureCaptureDescriptorDataInfoEXT* pInfo, void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetAccelerationStructureOpaqueCaptureDescriptorDataEXT(VkDevice device, const VkAccelerationStructureCaptureDescriptorDataInfoEXT* pInfo, void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetAccelerationStructureOpaqueCaptureDescriptorDataEXT(VkDevice device, const VkAccelerationStructureCaptureDescriptorDataInfoEXT* pInfo, void* pData);

  #define tu_GetAccelerationStructureOpaqueCaptureDescriptorDataEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetAccelerationStructureOpaqueCaptureDescriptorDataEXT<X>(VkDevice device, const VkAccelerationStructureCaptureDescriptorDataInfoEXT* pInfo, void* pData);

  VKAPI_ATTR void VKAPI_CALL tu_SetDeviceMemoryPriorityEXT(VkDevice       device, VkDeviceMemory memory, float          priority) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_SetDeviceMemoryPriorityEXT(VkDevice       device, VkDeviceMemory memory, float          priority) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_SetDeviceMemoryPriorityEXT(VkDevice       device, VkDeviceMemory memory, float          priority);

  #define tu_SetDeviceMemoryPriorityEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_SetDeviceMemoryPriorityEXT<X>(VkDevice       device, VkDeviceMemory memory, float          priority);

  VKAPI_ATTR VkResult VKAPI_CALL tu_WaitForPresent2KHR(VkDevice device, VkSwapchainKHR swapchain, const VkPresentWait2InfoKHR* pPresentWait2Info) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_WaitForPresent2KHR(VkDevice device, VkSwapchainKHR swapchain, const VkPresentWait2InfoKHR* pPresentWait2Info) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_WaitForPresent2KHR(VkDevice device, VkSwapchainKHR swapchain, const VkPresentWait2InfoKHR* pPresentWait2Info);

  #define tu_WaitForPresent2KHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_WaitForPresent2KHR<X>(VkDevice device, VkSwapchainKHR swapchain, const VkPresentWait2InfoKHR* pPresentWait2Info);

  VKAPI_ATTR VkResult VKAPI_CALL tu_WaitForPresentKHR(VkDevice device, VkSwapchainKHR swapchain, uint64_t presentId, uint64_t timeout) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_WaitForPresentKHR(VkDevice device, VkSwapchainKHR swapchain, uint64_t presentId, uint64_t timeout) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_WaitForPresentKHR(VkDevice device, VkSwapchainKHR swapchain, uint64_t presentId, uint64_t timeout);

  #define tu_WaitForPresentKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_WaitForPresentKHR<X>(VkDevice device, VkSwapchainKHR swapchain, uint64_t presentId, uint64_t timeout);

#ifdef VK_USE_PLATFORM_FUCHSIA
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateBufferCollectionFUCHSIA(VkDevice device, const VkBufferCollectionCreateInfoFUCHSIA* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBufferCollectionFUCHSIA* pCollection) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateBufferCollectionFUCHSIA(VkDevice device, const VkBufferCollectionCreateInfoFUCHSIA* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBufferCollectionFUCHSIA* pCollection) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateBufferCollectionFUCHSIA(VkDevice device, const VkBufferCollectionCreateInfoFUCHSIA* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBufferCollectionFUCHSIA* pCollection);

  #define tu_CreateBufferCollectionFUCHSIA_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateBufferCollectionFUCHSIA<X>(VkDevice device, const VkBufferCollectionCreateInfoFUCHSIA* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkBufferCollectionFUCHSIA* pCollection);

#endif // VK_USE_PLATFORM_FUCHSIA
#ifdef VK_USE_PLATFORM_FUCHSIA
  VKAPI_ATTR VkResult VKAPI_CALL tu_SetBufferCollectionBufferConstraintsFUCHSIA(VkDevice device, VkBufferCollectionFUCHSIA collection, const VkBufferConstraintsInfoFUCHSIA* pBufferConstraintsInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_SetBufferCollectionBufferConstraintsFUCHSIA(VkDevice device, VkBufferCollectionFUCHSIA collection, const VkBufferConstraintsInfoFUCHSIA* pBufferConstraintsInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_SetBufferCollectionBufferConstraintsFUCHSIA(VkDevice device, VkBufferCollectionFUCHSIA collection, const VkBufferConstraintsInfoFUCHSIA* pBufferConstraintsInfo);

  #define tu_SetBufferCollectionBufferConstraintsFUCHSIA_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_SetBufferCollectionBufferConstraintsFUCHSIA<X>(VkDevice device, VkBufferCollectionFUCHSIA collection, const VkBufferConstraintsInfoFUCHSIA* pBufferConstraintsInfo);

#endif // VK_USE_PLATFORM_FUCHSIA
#ifdef VK_USE_PLATFORM_FUCHSIA
  VKAPI_ATTR VkResult VKAPI_CALL tu_SetBufferCollectionImageConstraintsFUCHSIA(VkDevice device, VkBufferCollectionFUCHSIA collection, const VkImageConstraintsInfoFUCHSIA* pImageConstraintsInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_SetBufferCollectionImageConstraintsFUCHSIA(VkDevice device, VkBufferCollectionFUCHSIA collection, const VkImageConstraintsInfoFUCHSIA* pImageConstraintsInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_SetBufferCollectionImageConstraintsFUCHSIA(VkDevice device, VkBufferCollectionFUCHSIA collection, const VkImageConstraintsInfoFUCHSIA* pImageConstraintsInfo);

  #define tu_SetBufferCollectionImageConstraintsFUCHSIA_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_SetBufferCollectionImageConstraintsFUCHSIA<X>(VkDevice device, VkBufferCollectionFUCHSIA collection, const VkImageConstraintsInfoFUCHSIA* pImageConstraintsInfo);

#endif // VK_USE_PLATFORM_FUCHSIA
#ifdef VK_USE_PLATFORM_FUCHSIA
  VKAPI_ATTR void VKAPI_CALL tu_DestroyBufferCollectionFUCHSIA(VkDevice device, VkBufferCollectionFUCHSIA collection, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyBufferCollectionFUCHSIA(VkDevice device, VkBufferCollectionFUCHSIA collection, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyBufferCollectionFUCHSIA(VkDevice device, VkBufferCollectionFUCHSIA collection, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyBufferCollectionFUCHSIA_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyBufferCollectionFUCHSIA<X>(VkDevice device, VkBufferCollectionFUCHSIA collection, const VkAllocationCallbacks* pAllocator);

#endif // VK_USE_PLATFORM_FUCHSIA
#ifdef VK_USE_PLATFORM_FUCHSIA
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetBufferCollectionPropertiesFUCHSIA(VkDevice device, VkBufferCollectionFUCHSIA collection, VkBufferCollectionPropertiesFUCHSIA* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetBufferCollectionPropertiesFUCHSIA(VkDevice device, VkBufferCollectionFUCHSIA collection, VkBufferCollectionPropertiesFUCHSIA* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetBufferCollectionPropertiesFUCHSIA(VkDevice device, VkBufferCollectionFUCHSIA collection, VkBufferCollectionPropertiesFUCHSIA* pProperties);

  #define tu_GetBufferCollectionPropertiesFUCHSIA_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetBufferCollectionPropertiesFUCHSIA<X>(VkDevice device, VkBufferCollectionFUCHSIA collection, VkBufferCollectionPropertiesFUCHSIA* pProperties);

#endif // VK_USE_PLATFORM_FUCHSIA
  VKAPI_ATTR void VKAPI_CALL tu_CmdBeginRendering(VkCommandBuffer                   commandBuffer, const VkRenderingInfo*                              pRenderingInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBeginRendering(VkCommandBuffer                   commandBuffer, const VkRenderingInfo*                              pRenderingInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBeginRendering(VkCommandBuffer                   commandBuffer, const VkRenderingInfo*                              pRenderingInfo);

  #define tu_CmdBeginRendering_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBeginRendering<X>(VkCommandBuffer                   commandBuffer, const VkRenderingInfo*                              pRenderingInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBeginRenderingKHR(VkCommandBuffer                   commandBuffer, const VkRenderingInfo*                              pRenderingInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBeginRenderingKHR(VkCommandBuffer                   commandBuffer, const VkRenderingInfo*                              pRenderingInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBeginRenderingKHR(VkCommandBuffer                   commandBuffer, const VkRenderingInfo*                              pRenderingInfo);

  #define tu_CmdBeginRenderingKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBeginRenderingKHR<X>(VkCommandBuffer                   commandBuffer, const VkRenderingInfo*                              pRenderingInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdEndRendering(VkCommandBuffer                   commandBuffer) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdEndRendering(VkCommandBuffer                   commandBuffer) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdEndRendering(VkCommandBuffer                   commandBuffer);

  #define tu_CmdEndRendering_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdEndRendering<X>(VkCommandBuffer                   commandBuffer);

  VKAPI_ATTR void VKAPI_CALL tu_CmdEndRendering2KHR(VkCommandBuffer                   commandBuffer, const VkRenderingEndInfoKHR*        pRenderingEndInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdEndRendering2KHR(VkCommandBuffer                   commandBuffer, const VkRenderingEndInfoKHR*        pRenderingEndInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdEndRendering2KHR(VkCommandBuffer                   commandBuffer, const VkRenderingEndInfoKHR*        pRenderingEndInfo);

  #define tu_CmdEndRendering2KHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdEndRendering2KHR<X>(VkCommandBuffer                   commandBuffer, const VkRenderingEndInfoKHR*        pRenderingEndInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdEndRendering2EXT(VkCommandBuffer                   commandBuffer, const VkRenderingEndInfoKHR*        pRenderingEndInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdEndRendering2EXT(VkCommandBuffer                   commandBuffer, const VkRenderingEndInfoKHR*        pRenderingEndInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdEndRendering2EXT(VkCommandBuffer                   commandBuffer, const VkRenderingEndInfoKHR*        pRenderingEndInfo);

  #define tu_CmdEndRendering2EXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdEndRendering2EXT<X>(VkCommandBuffer                   commandBuffer, const VkRenderingEndInfoKHR*        pRenderingEndInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdEndRenderingKHR(VkCommandBuffer                   commandBuffer) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdEndRenderingKHR(VkCommandBuffer                   commandBuffer) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdEndRenderingKHR(VkCommandBuffer                   commandBuffer);

  #define tu_CmdEndRenderingKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdEndRenderingKHR<X>(VkCommandBuffer                   commandBuffer);

  VKAPI_ATTR void VKAPI_CALL tu_GetDescriptorSetLayoutHostMappingInfoVALVE(VkDevice device, const VkDescriptorSetBindingReferenceVALVE* pBindingReference, VkDescriptorSetLayoutHostMappingInfoVALVE* pHostMapping) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetDescriptorSetLayoutHostMappingInfoVALVE(VkDevice device, const VkDescriptorSetBindingReferenceVALVE* pBindingReference, VkDescriptorSetLayoutHostMappingInfoVALVE* pHostMapping) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetDescriptorSetLayoutHostMappingInfoVALVE(VkDevice device, const VkDescriptorSetBindingReferenceVALVE* pBindingReference, VkDescriptorSetLayoutHostMappingInfoVALVE* pHostMapping);

  #define tu_GetDescriptorSetLayoutHostMappingInfoVALVE_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetDescriptorSetLayoutHostMappingInfoVALVE<X>(VkDevice device, const VkDescriptorSetBindingReferenceVALVE* pBindingReference, VkDescriptorSetLayoutHostMappingInfoVALVE* pHostMapping);

  VKAPI_ATTR void VKAPI_CALL tu_GetDescriptorSetHostMappingVALVE(VkDevice device, VkDescriptorSet descriptorSet, void** ppData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetDescriptorSetHostMappingVALVE(VkDevice device, VkDescriptorSet descriptorSet, void** ppData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetDescriptorSetHostMappingVALVE(VkDevice device, VkDescriptorSet descriptorSet, void** ppData);

  #define tu_GetDescriptorSetHostMappingVALVE_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetDescriptorSetHostMappingVALVE<X>(VkDevice device, VkDescriptorSet descriptorSet, void** ppData);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateMicromapEXT(VkDevice                                           device, const VkMicromapCreateInfoEXT*        pCreateInfo, const VkAllocationCallbacks*       pAllocator, VkMicromapEXT*                        pMicromap) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateMicromapEXT(VkDevice                                           device, const VkMicromapCreateInfoEXT*        pCreateInfo, const VkAllocationCallbacks*       pAllocator, VkMicromapEXT*                        pMicromap) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateMicromapEXT(VkDevice                                           device, const VkMicromapCreateInfoEXT*        pCreateInfo, const VkAllocationCallbacks*       pAllocator, VkMicromapEXT*                        pMicromap);

  #define tu_CreateMicromapEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateMicromapEXT<X>(VkDevice                                           device, const VkMicromapCreateInfoEXT*        pCreateInfo, const VkAllocationCallbacks*       pAllocator, VkMicromapEXT*                        pMicromap);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBuildMicromapsEXT(VkCommandBuffer                                    commandBuffer, uint32_t infoCount, const VkMicromapBuildInfoEXT* pInfos) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBuildMicromapsEXT(VkCommandBuffer                                    commandBuffer, uint32_t infoCount, const VkMicromapBuildInfoEXT* pInfos) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBuildMicromapsEXT(VkCommandBuffer                                    commandBuffer, uint32_t infoCount, const VkMicromapBuildInfoEXT* pInfos);

  #define tu_CmdBuildMicromapsEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBuildMicromapsEXT<X>(VkCommandBuffer                                    commandBuffer, uint32_t infoCount, const VkMicromapBuildInfoEXT* pInfos);

  VKAPI_ATTR VkResult VKAPI_CALL tu_BuildMicromapsEXT(VkDevice                                           device, VkDeferredOperationKHR deferredOperation, uint32_t infoCount, const VkMicromapBuildInfoEXT* pInfos) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_BuildMicromapsEXT(VkDevice                                           device, VkDeferredOperationKHR deferredOperation, uint32_t infoCount, const VkMicromapBuildInfoEXT* pInfos) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_BuildMicromapsEXT(VkDevice                                           device, VkDeferredOperationKHR deferredOperation, uint32_t infoCount, const VkMicromapBuildInfoEXT* pInfos);

  #define tu_BuildMicromapsEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_BuildMicromapsEXT<X>(VkDevice                                           device, VkDeferredOperationKHR deferredOperation, uint32_t infoCount, const VkMicromapBuildInfoEXT* pInfos);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyMicromapEXT(VkDevice device, VkMicromapEXT micromap, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyMicromapEXT(VkDevice device, VkMicromapEXT micromap, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyMicromapEXT(VkDevice device, VkMicromapEXT micromap, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyMicromapEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyMicromapEXT<X>(VkDevice device, VkMicromapEXT micromap, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyMicromapEXT(VkCommandBuffer commandBuffer, const VkCopyMicromapInfoEXT* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdCopyMicromapEXT(VkCommandBuffer commandBuffer, const VkCopyMicromapInfoEXT* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyMicromapEXT(VkCommandBuffer commandBuffer, const VkCopyMicromapInfoEXT* pInfo);

  #define tu_CmdCopyMicromapEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdCopyMicromapEXT<X>(VkCommandBuffer commandBuffer, const VkCopyMicromapInfoEXT* pInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CopyMicromapEXT(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyMicromapInfoEXT* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CopyMicromapEXT(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyMicromapInfoEXT* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CopyMicromapEXT(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyMicromapInfoEXT* pInfo);

  #define tu_CopyMicromapEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CopyMicromapEXT<X>(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyMicromapInfoEXT* pInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyMicromapToMemoryEXT(VkCommandBuffer commandBuffer, const VkCopyMicromapToMemoryInfoEXT* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdCopyMicromapToMemoryEXT(VkCommandBuffer commandBuffer, const VkCopyMicromapToMemoryInfoEXT* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyMicromapToMemoryEXT(VkCommandBuffer commandBuffer, const VkCopyMicromapToMemoryInfoEXT* pInfo);

  #define tu_CmdCopyMicromapToMemoryEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdCopyMicromapToMemoryEXT<X>(VkCommandBuffer commandBuffer, const VkCopyMicromapToMemoryInfoEXT* pInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CopyMicromapToMemoryEXT(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyMicromapToMemoryInfoEXT* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CopyMicromapToMemoryEXT(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyMicromapToMemoryInfoEXT* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CopyMicromapToMemoryEXT(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyMicromapToMemoryInfoEXT* pInfo);

  #define tu_CopyMicromapToMemoryEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CopyMicromapToMemoryEXT<X>(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyMicromapToMemoryInfoEXT* pInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyMemoryToMicromapEXT(VkCommandBuffer commandBuffer, const VkCopyMemoryToMicromapInfoEXT* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdCopyMemoryToMicromapEXT(VkCommandBuffer commandBuffer, const VkCopyMemoryToMicromapInfoEXT* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyMemoryToMicromapEXT(VkCommandBuffer commandBuffer, const VkCopyMemoryToMicromapInfoEXT* pInfo);

  #define tu_CmdCopyMemoryToMicromapEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdCopyMemoryToMicromapEXT<X>(VkCommandBuffer commandBuffer, const VkCopyMemoryToMicromapInfoEXT* pInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CopyMemoryToMicromapEXT(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyMemoryToMicromapInfoEXT* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CopyMemoryToMicromapEXT(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyMemoryToMicromapInfoEXT* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CopyMemoryToMicromapEXT(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyMemoryToMicromapInfoEXT* pInfo);

  #define tu_CopyMemoryToMicromapEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CopyMemoryToMicromapEXT<X>(VkDevice device, VkDeferredOperationKHR deferredOperation, const VkCopyMemoryToMicromapInfoEXT* pInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdWriteMicromapsPropertiesEXT(VkCommandBuffer commandBuffer, uint32_t micromapCount, const VkMicromapEXT* pMicromaps, VkQueryType queryType, VkQueryPool queryPool, uint32_t firstQuery) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdWriteMicromapsPropertiesEXT(VkCommandBuffer commandBuffer, uint32_t micromapCount, const VkMicromapEXT* pMicromaps, VkQueryType queryType, VkQueryPool queryPool, uint32_t firstQuery) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdWriteMicromapsPropertiesEXT(VkCommandBuffer commandBuffer, uint32_t micromapCount, const VkMicromapEXT* pMicromaps, VkQueryType queryType, VkQueryPool queryPool, uint32_t firstQuery);

  #define tu_CmdWriteMicromapsPropertiesEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdWriteMicromapsPropertiesEXT<X>(VkCommandBuffer commandBuffer, uint32_t micromapCount, const VkMicromapEXT* pMicromaps, VkQueryType queryType, VkQueryPool queryPool, uint32_t firstQuery);

  VKAPI_ATTR VkResult VKAPI_CALL tu_WriteMicromapsPropertiesEXT(VkDevice device, uint32_t micromapCount, const VkMicromapEXT* pMicromaps, VkQueryType  queryType, size_t       dataSize, void* pData, size_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_WriteMicromapsPropertiesEXT(VkDevice device, uint32_t micromapCount, const VkMicromapEXT* pMicromaps, VkQueryType  queryType, size_t       dataSize, void* pData, size_t stride) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_WriteMicromapsPropertiesEXT(VkDevice device, uint32_t micromapCount, const VkMicromapEXT* pMicromaps, VkQueryType  queryType, size_t       dataSize, void* pData, size_t stride);

  #define tu_WriteMicromapsPropertiesEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_WriteMicromapsPropertiesEXT<X>(VkDevice device, uint32_t micromapCount, const VkMicromapEXT* pMicromaps, VkQueryType  queryType, size_t       dataSize, void* pData, size_t stride);

  VKAPI_ATTR void VKAPI_CALL tu_GetDeviceMicromapCompatibilityEXT(VkDevice device, const VkMicromapVersionInfoEXT* pVersionInfo, VkAccelerationStructureCompatibilityKHR* pCompatibility) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetDeviceMicromapCompatibilityEXT(VkDevice device, const VkMicromapVersionInfoEXT* pVersionInfo, VkAccelerationStructureCompatibilityKHR* pCompatibility) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetDeviceMicromapCompatibilityEXT(VkDevice device, const VkMicromapVersionInfoEXT* pVersionInfo, VkAccelerationStructureCompatibilityKHR* pCompatibility);

  #define tu_GetDeviceMicromapCompatibilityEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetDeviceMicromapCompatibilityEXT<X>(VkDevice device, const VkMicromapVersionInfoEXT* pVersionInfo, VkAccelerationStructureCompatibilityKHR* pCompatibility);

  VKAPI_ATTR void VKAPI_CALL tu_GetMicromapBuildSizesEXT(VkDevice                                            device, VkAccelerationStructureBuildTypeKHR                 buildType, const VkMicromapBuildInfoEXT*  pBuildInfo, VkMicromapBuildSizesInfoEXT*           pSizeInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetMicromapBuildSizesEXT(VkDevice                                            device, VkAccelerationStructureBuildTypeKHR                 buildType, const VkMicromapBuildInfoEXT*  pBuildInfo, VkMicromapBuildSizesInfoEXT*           pSizeInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetMicromapBuildSizesEXT(VkDevice                                            device, VkAccelerationStructureBuildTypeKHR                 buildType, const VkMicromapBuildInfoEXT*  pBuildInfo, VkMicromapBuildSizesInfoEXT*           pSizeInfo);

  #define tu_GetMicromapBuildSizesEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetMicromapBuildSizesEXT<X>(VkDevice                                            device, VkAccelerationStructureBuildTypeKHR                 buildType, const VkMicromapBuildInfoEXT*  pBuildInfo, VkMicromapBuildSizesInfoEXT*           pSizeInfo);

  VKAPI_ATTR void VKAPI_CALL tu_GetShaderModuleIdentifierEXT(VkDevice device, VkShaderModule shaderModule, VkShaderModuleIdentifierEXT* pIdentifier) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetShaderModuleIdentifierEXT(VkDevice device, VkShaderModule shaderModule, VkShaderModuleIdentifierEXT* pIdentifier) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetShaderModuleIdentifierEXT(VkDevice device, VkShaderModule shaderModule, VkShaderModuleIdentifierEXT* pIdentifier);

  #define tu_GetShaderModuleIdentifierEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetShaderModuleIdentifierEXT<X>(VkDevice device, VkShaderModule shaderModule, VkShaderModuleIdentifierEXT* pIdentifier);

  VKAPI_ATTR void VKAPI_CALL tu_GetShaderModuleCreateInfoIdentifierEXT(VkDevice device, const VkShaderModuleCreateInfo* pCreateInfo, VkShaderModuleIdentifierEXT* pIdentifier) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetShaderModuleCreateInfoIdentifierEXT(VkDevice device, const VkShaderModuleCreateInfo* pCreateInfo, VkShaderModuleIdentifierEXT* pIdentifier) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetShaderModuleCreateInfoIdentifierEXT(VkDevice device, const VkShaderModuleCreateInfo* pCreateInfo, VkShaderModuleIdentifierEXT* pIdentifier);

  #define tu_GetShaderModuleCreateInfoIdentifierEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetShaderModuleCreateInfoIdentifierEXT<X>(VkDevice device, const VkShaderModuleCreateInfo* pCreateInfo, VkShaderModuleIdentifierEXT* pIdentifier);

  VKAPI_ATTR void VKAPI_CALL tu_GetImageSubresourceLayout2(VkDevice device, VkImage image, const VkImageSubresource2* pSubresource, VkSubresourceLayout2* pLayout) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetImageSubresourceLayout2(VkDevice device, VkImage image, const VkImageSubresource2* pSubresource, VkSubresourceLayout2* pLayout) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetImageSubresourceLayout2(VkDevice device, VkImage image, const VkImageSubresource2* pSubresource, VkSubresourceLayout2* pLayout);

  #define tu_GetImageSubresourceLayout2_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetImageSubresourceLayout2<X>(VkDevice device, VkImage image, const VkImageSubresource2* pSubresource, VkSubresourceLayout2* pLayout);

  VKAPI_ATTR void VKAPI_CALL tu_GetImageSubresourceLayout2KHR(VkDevice device, VkImage image, const VkImageSubresource2* pSubresource, VkSubresourceLayout2* pLayout) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetImageSubresourceLayout2KHR(VkDevice device, VkImage image, const VkImageSubresource2* pSubresource, VkSubresourceLayout2* pLayout) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetImageSubresourceLayout2KHR(VkDevice device, VkImage image, const VkImageSubresource2* pSubresource, VkSubresourceLayout2* pLayout);

  #define tu_GetImageSubresourceLayout2KHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetImageSubresourceLayout2KHR<X>(VkDevice device, VkImage image, const VkImageSubresource2* pSubresource, VkSubresourceLayout2* pLayout);

  VKAPI_ATTR void VKAPI_CALL tu_GetImageSubresourceLayout2EXT(VkDevice device, VkImage image, const VkImageSubresource2* pSubresource, VkSubresourceLayout2* pLayout) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetImageSubresourceLayout2EXT(VkDevice device, VkImage image, const VkImageSubresource2* pSubresource, VkSubresourceLayout2* pLayout) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetImageSubresourceLayout2EXT(VkDevice device, VkImage image, const VkImageSubresource2* pSubresource, VkSubresourceLayout2* pLayout);

  #define tu_GetImageSubresourceLayout2EXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetImageSubresourceLayout2EXT<X>(VkDevice device, VkImage image, const VkImageSubresource2* pSubresource, VkSubresourceLayout2* pLayout);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPipelinePropertiesEXT(VkDevice device, const VkPipelineInfoEXT* pPipelineInfo, VkBaseOutStructure* pPipelineProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetPipelinePropertiesEXT(VkDevice device, const VkPipelineInfoEXT* pPipelineInfo, VkBaseOutStructure* pPipelineProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPipelinePropertiesEXT(VkDevice device, const VkPipelineInfoEXT* pPipelineInfo, VkBaseOutStructure* pPipelineProperties);

  #define tu_GetPipelinePropertiesEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetPipelinePropertiesEXT<X>(VkDevice device, const VkPipelineInfoEXT* pPipelineInfo, VkBaseOutStructure* pPipelineProperties);

#ifdef VK_USE_PLATFORM_METAL_EXT
  VKAPI_ATTR void VKAPI_CALL tu_ExportMetalObjectsEXT(VkDevice device, VkExportMetalObjectsInfoEXT* pMetalObjectsInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_ExportMetalObjectsEXT(VkDevice device, VkExportMetalObjectsInfoEXT* pMetalObjectsInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_ExportMetalObjectsEXT(VkDevice device, VkExportMetalObjectsInfoEXT* pMetalObjectsInfo);

  #define tu_ExportMetalObjectsEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_ExportMetalObjectsEXT<X>(VkDevice device, VkExportMetalObjectsInfoEXT* pMetalObjectsInfo);

#endif // VK_USE_PLATFORM_METAL_EXT
  VKAPI_ATTR void VKAPI_CALL tu_CmdBindTileMemoryQCOM(VkCommandBuffer commandBuffer, const VkTileMemoryBindInfoQCOM* pTileMemoryBindInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBindTileMemoryQCOM(VkCommandBuffer commandBuffer, const VkTileMemoryBindInfoQCOM* pTileMemoryBindInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBindTileMemoryQCOM(VkCommandBuffer commandBuffer, const VkTileMemoryBindInfoQCOM* pTileMemoryBindInfo);

  #define tu_CmdBindTileMemoryQCOM_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBindTileMemoryQCOM<X>(VkCommandBuffer commandBuffer, const VkTileMemoryBindInfoQCOM* pTileMemoryBindInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetFramebufferTilePropertiesQCOM(VkDevice device, VkFramebuffer framebuffer, uint32_t* pPropertiesCount, VkTilePropertiesQCOM* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetFramebufferTilePropertiesQCOM(VkDevice device, VkFramebuffer framebuffer, uint32_t* pPropertiesCount, VkTilePropertiesQCOM* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetFramebufferTilePropertiesQCOM(VkDevice device, VkFramebuffer framebuffer, uint32_t* pPropertiesCount, VkTilePropertiesQCOM* pProperties);

  #define tu_GetFramebufferTilePropertiesQCOM_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetFramebufferTilePropertiesQCOM<X>(VkDevice device, VkFramebuffer framebuffer, uint32_t* pPropertiesCount, VkTilePropertiesQCOM* pProperties);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetDynamicRenderingTilePropertiesQCOM(VkDevice device, const VkRenderingInfo* pRenderingInfo, VkTilePropertiesQCOM* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetDynamicRenderingTilePropertiesQCOM(VkDevice device, const VkRenderingInfo* pRenderingInfo, VkTilePropertiesQCOM* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetDynamicRenderingTilePropertiesQCOM(VkDevice device, const VkRenderingInfo* pRenderingInfo, VkTilePropertiesQCOM* pProperties);

  #define tu_GetDynamicRenderingTilePropertiesQCOM_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetDynamicRenderingTilePropertiesQCOM<X>(VkDevice device, const VkRenderingInfo* pRenderingInfo, VkTilePropertiesQCOM* pProperties);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateOpticalFlowSessionNV(VkDevice device, const VkOpticalFlowSessionCreateInfoNV* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkOpticalFlowSessionNV* pSession) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateOpticalFlowSessionNV(VkDevice device, const VkOpticalFlowSessionCreateInfoNV* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkOpticalFlowSessionNV* pSession) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateOpticalFlowSessionNV(VkDevice device, const VkOpticalFlowSessionCreateInfoNV* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkOpticalFlowSessionNV* pSession);

  #define tu_CreateOpticalFlowSessionNV_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateOpticalFlowSessionNV<X>(VkDevice device, const VkOpticalFlowSessionCreateInfoNV* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkOpticalFlowSessionNV* pSession);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyOpticalFlowSessionNV(VkDevice device, VkOpticalFlowSessionNV session, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyOpticalFlowSessionNV(VkDevice device, VkOpticalFlowSessionNV session, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyOpticalFlowSessionNV(VkDevice device, VkOpticalFlowSessionNV session, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyOpticalFlowSessionNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyOpticalFlowSessionNV<X>(VkDevice device, VkOpticalFlowSessionNV session, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR VkResult VKAPI_CALL tu_BindOpticalFlowSessionImageNV(VkDevice device, VkOpticalFlowSessionNV session, VkOpticalFlowSessionBindingPointNV bindingPoint, VkImageView view, VkImageLayout layout) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_BindOpticalFlowSessionImageNV(VkDevice device, VkOpticalFlowSessionNV session, VkOpticalFlowSessionBindingPointNV bindingPoint, VkImageView view, VkImageLayout layout) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_BindOpticalFlowSessionImageNV(VkDevice device, VkOpticalFlowSessionNV session, VkOpticalFlowSessionBindingPointNV bindingPoint, VkImageView view, VkImageLayout layout);

  #define tu_BindOpticalFlowSessionImageNV_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_BindOpticalFlowSessionImageNV<X>(VkDevice device, VkOpticalFlowSessionNV session, VkOpticalFlowSessionBindingPointNV bindingPoint, VkImageView view, VkImageLayout layout);

  VKAPI_ATTR void VKAPI_CALL tu_CmdOpticalFlowExecuteNV(VkCommandBuffer commandBuffer, VkOpticalFlowSessionNV session, const VkOpticalFlowExecuteInfoNV* pExecuteInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdOpticalFlowExecuteNV(VkCommandBuffer commandBuffer, VkOpticalFlowSessionNV session, const VkOpticalFlowExecuteInfoNV* pExecuteInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdOpticalFlowExecuteNV(VkCommandBuffer commandBuffer, VkOpticalFlowSessionNV session, const VkOpticalFlowExecuteInfoNV* pExecuteInfo);

  #define tu_CmdOpticalFlowExecuteNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdOpticalFlowExecuteNV<X>(VkCommandBuffer commandBuffer, VkOpticalFlowSessionNV session, const VkOpticalFlowExecuteInfoNV* pExecuteInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetDeviceFaultInfoEXT(VkDevice device, VkDeviceFaultCountsEXT* pFaultCounts, VkDeviceFaultInfoEXT* pFaultInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetDeviceFaultInfoEXT(VkDevice device, VkDeviceFaultCountsEXT* pFaultCounts, VkDeviceFaultInfoEXT* pFaultInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetDeviceFaultInfoEXT(VkDevice device, VkDeviceFaultCountsEXT* pFaultCounts, VkDeviceFaultInfoEXT* pFaultInfo);

  #define tu_GetDeviceFaultInfoEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetDeviceFaultInfoEXT<X>(VkDevice device, VkDeviceFaultCountsEXT* pFaultCounts, VkDeviceFaultInfoEXT* pFaultInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthBias2EXT(VkCommandBuffer commandBuffer, const VkDepthBiasInfoEXT*         pDepthBiasInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetDepthBias2EXT(VkCommandBuffer commandBuffer, const VkDepthBiasInfoEXT*         pDepthBiasInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthBias2EXT(VkCommandBuffer commandBuffer, const VkDepthBiasInfoEXT*         pDepthBiasInfo);

  #define tu_CmdSetDepthBias2EXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthBias2EXT<X>(VkCommandBuffer commandBuffer, const VkDepthBiasInfoEXT*         pDepthBiasInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_ReleaseSwapchainImagesKHR(VkDevice device, const VkReleaseSwapchainImagesInfoKHR* pReleaseInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_ReleaseSwapchainImagesKHR(VkDevice device, const VkReleaseSwapchainImagesInfoKHR* pReleaseInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_ReleaseSwapchainImagesKHR(VkDevice device, const VkReleaseSwapchainImagesInfoKHR* pReleaseInfo);

  #define tu_ReleaseSwapchainImagesKHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_ReleaseSwapchainImagesKHR<X>(VkDevice device, const VkReleaseSwapchainImagesInfoKHR* pReleaseInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_ReleaseSwapchainImagesEXT(VkDevice device, const VkReleaseSwapchainImagesInfoKHR* pReleaseInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_ReleaseSwapchainImagesEXT(VkDevice device, const VkReleaseSwapchainImagesInfoKHR* pReleaseInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_ReleaseSwapchainImagesEXT(VkDevice device, const VkReleaseSwapchainImagesInfoKHR* pReleaseInfo);

  #define tu_ReleaseSwapchainImagesEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_ReleaseSwapchainImagesEXT<X>(VkDevice device, const VkReleaseSwapchainImagesInfoKHR* pReleaseInfo);

  VKAPI_ATTR void VKAPI_CALL tu_GetDeviceImageSubresourceLayout(VkDevice device, const VkDeviceImageSubresourceInfo* pInfo, VkSubresourceLayout2* pLayout) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetDeviceImageSubresourceLayout(VkDevice device, const VkDeviceImageSubresourceInfo* pInfo, VkSubresourceLayout2* pLayout) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetDeviceImageSubresourceLayout(VkDevice device, const VkDeviceImageSubresourceInfo* pInfo, VkSubresourceLayout2* pLayout);

  #define tu_GetDeviceImageSubresourceLayout_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetDeviceImageSubresourceLayout<X>(VkDevice device, const VkDeviceImageSubresourceInfo* pInfo, VkSubresourceLayout2* pLayout);

  VKAPI_ATTR void VKAPI_CALL tu_GetDeviceImageSubresourceLayoutKHR(VkDevice device, const VkDeviceImageSubresourceInfo* pInfo, VkSubresourceLayout2* pLayout) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetDeviceImageSubresourceLayoutKHR(VkDevice device, const VkDeviceImageSubresourceInfo* pInfo, VkSubresourceLayout2* pLayout) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetDeviceImageSubresourceLayoutKHR(VkDevice device, const VkDeviceImageSubresourceInfo* pInfo, VkSubresourceLayout2* pLayout);

  #define tu_GetDeviceImageSubresourceLayoutKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetDeviceImageSubresourceLayoutKHR<X>(VkDevice device, const VkDeviceImageSubresourceInfo* pInfo, VkSubresourceLayout2* pLayout);

  VKAPI_ATTR VkResult VKAPI_CALL tu_MapMemory2(VkDevice device, const VkMemoryMapInfo* pMemoryMapInfo, void** ppData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_MapMemory2(VkDevice device, const VkMemoryMapInfo* pMemoryMapInfo, void** ppData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_MapMemory2(VkDevice device, const VkMemoryMapInfo* pMemoryMapInfo, void** ppData);

  #define tu_MapMemory2_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_MapMemory2<X>(VkDevice device, const VkMemoryMapInfo* pMemoryMapInfo, void** ppData);

  VKAPI_ATTR VkResult VKAPI_CALL tu_MapMemory2KHR(VkDevice device, const VkMemoryMapInfo* pMemoryMapInfo, void** ppData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_MapMemory2KHR(VkDevice device, const VkMemoryMapInfo* pMemoryMapInfo, void** ppData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_MapMemory2KHR(VkDevice device, const VkMemoryMapInfo* pMemoryMapInfo, void** ppData);

  #define tu_MapMemory2KHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_MapMemory2KHR<X>(VkDevice device, const VkMemoryMapInfo* pMemoryMapInfo, void** ppData);

  VKAPI_ATTR VkResult VKAPI_CALL tu_UnmapMemory2(VkDevice device, const VkMemoryUnmapInfo* pMemoryUnmapInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_UnmapMemory2(VkDevice device, const VkMemoryUnmapInfo* pMemoryUnmapInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_UnmapMemory2(VkDevice device, const VkMemoryUnmapInfo* pMemoryUnmapInfo);

  #define tu_UnmapMemory2_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_UnmapMemory2<X>(VkDevice device, const VkMemoryUnmapInfo* pMemoryUnmapInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_UnmapMemory2KHR(VkDevice device, const VkMemoryUnmapInfo* pMemoryUnmapInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_UnmapMemory2KHR(VkDevice device, const VkMemoryUnmapInfo* pMemoryUnmapInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_UnmapMemory2KHR(VkDevice device, const VkMemoryUnmapInfo* pMemoryUnmapInfo);

  #define tu_UnmapMemory2KHR_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_UnmapMemory2KHR<X>(VkDevice device, const VkMemoryUnmapInfo* pMemoryUnmapInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateShadersEXT(VkDevice device, uint32_t createInfoCount, const VkShaderCreateInfoEXT* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkShaderEXT* pShaders) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateShadersEXT(VkDevice device, uint32_t createInfoCount, const VkShaderCreateInfoEXT* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkShaderEXT* pShaders) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateShadersEXT(VkDevice device, uint32_t createInfoCount, const VkShaderCreateInfoEXT* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkShaderEXT* pShaders);

  #define tu_CreateShadersEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateShadersEXT<X>(VkDevice device, uint32_t createInfoCount, const VkShaderCreateInfoEXT* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkShaderEXT* pShaders);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyShaderEXT(VkDevice device, VkShaderEXT shader, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyShaderEXT(VkDevice device, VkShaderEXT shader, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyShaderEXT(VkDevice device, VkShaderEXT shader, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyShaderEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyShaderEXT<X>(VkDevice device, VkShaderEXT shader, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetShaderBinaryDataEXT(VkDevice device, VkShaderEXT shader, size_t* pDataSize, void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetShaderBinaryDataEXT(VkDevice device, VkShaderEXT shader, size_t* pDataSize, void* pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetShaderBinaryDataEXT(VkDevice device, VkShaderEXT shader, size_t* pDataSize, void* pData);

  #define tu_GetShaderBinaryDataEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetShaderBinaryDataEXT<X>(VkDevice device, VkShaderEXT shader, size_t* pDataSize, void* pData);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBindShadersEXT(VkCommandBuffer commandBuffer, uint32_t stageCount, const VkShaderStageFlagBits* pStages, const VkShaderEXT* pShaders) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBindShadersEXT(VkCommandBuffer commandBuffer, uint32_t stageCount, const VkShaderStageFlagBits* pStages, const VkShaderEXT* pShaders) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBindShadersEXT(VkCommandBuffer commandBuffer, uint32_t stageCount, const VkShaderStageFlagBits* pStages, const VkShaderEXT* pShaders);

  #define tu_CmdBindShadersEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBindShadersEXT<X>(VkCommandBuffer commandBuffer, uint32_t stageCount, const VkShaderStageFlagBits* pStages, const VkShaderEXT* pShaders);

  VKAPI_ATTR VkResult VKAPI_CALL tu_SetSwapchainPresentTimingQueueSizeEXT(VkDevice device, VkSwapchainKHR swapchain, uint32_t size) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_SetSwapchainPresentTimingQueueSizeEXT(VkDevice device, VkSwapchainKHR swapchain, uint32_t size) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_SetSwapchainPresentTimingQueueSizeEXT(VkDevice device, VkSwapchainKHR swapchain, uint32_t size);

  #define tu_SetSwapchainPresentTimingQueueSizeEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_SetSwapchainPresentTimingQueueSizeEXT<X>(VkDevice device, VkSwapchainKHR swapchain, uint32_t size);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetSwapchainTimingPropertiesEXT(VkDevice device, VkSwapchainKHR swapchain, VkSwapchainTimingPropertiesEXT* pSwapchainTimingProperties, uint64_t* pSwapchainTimingPropertiesCounter) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetSwapchainTimingPropertiesEXT(VkDevice device, VkSwapchainKHR swapchain, VkSwapchainTimingPropertiesEXT* pSwapchainTimingProperties, uint64_t* pSwapchainTimingPropertiesCounter) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetSwapchainTimingPropertiesEXT(VkDevice device, VkSwapchainKHR swapchain, VkSwapchainTimingPropertiesEXT* pSwapchainTimingProperties, uint64_t* pSwapchainTimingPropertiesCounter);

  #define tu_GetSwapchainTimingPropertiesEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetSwapchainTimingPropertiesEXT<X>(VkDevice device, VkSwapchainKHR swapchain, VkSwapchainTimingPropertiesEXT* pSwapchainTimingProperties, uint64_t* pSwapchainTimingPropertiesCounter);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetSwapchainTimeDomainPropertiesEXT(VkDevice device, VkSwapchainKHR swapchain, VkSwapchainTimeDomainPropertiesEXT* pSwapchainTimeDomainProperties, uint64_t* pTimeDomainsCounter) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetSwapchainTimeDomainPropertiesEXT(VkDevice device, VkSwapchainKHR swapchain, VkSwapchainTimeDomainPropertiesEXT* pSwapchainTimeDomainProperties, uint64_t* pTimeDomainsCounter) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetSwapchainTimeDomainPropertiesEXT(VkDevice device, VkSwapchainKHR swapchain, VkSwapchainTimeDomainPropertiesEXT* pSwapchainTimeDomainProperties, uint64_t* pTimeDomainsCounter);

  #define tu_GetSwapchainTimeDomainPropertiesEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetSwapchainTimeDomainPropertiesEXT<X>(VkDevice device, VkSwapchainKHR swapchain, VkSwapchainTimeDomainPropertiesEXT* pSwapchainTimeDomainProperties, uint64_t* pTimeDomainsCounter);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPastPresentationTimingEXT(VkDevice device, const VkPastPresentationTimingInfoEXT* pPastPresentationTimingInfo, VkPastPresentationTimingPropertiesEXT* pPastPresentationTimingProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetPastPresentationTimingEXT(VkDevice device, const VkPastPresentationTimingInfoEXT* pPastPresentationTimingInfo, VkPastPresentationTimingPropertiesEXT* pPastPresentationTimingProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetPastPresentationTimingEXT(VkDevice device, const VkPastPresentationTimingInfoEXT* pPastPresentationTimingInfo, VkPastPresentationTimingPropertiesEXT* pPastPresentationTimingProperties);

  #define tu_GetPastPresentationTimingEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetPastPresentationTimingEXT<X>(VkDevice device, const VkPastPresentationTimingInfoEXT* pPastPresentationTimingInfo, VkPastPresentationTimingPropertiesEXT* pPastPresentationTimingProperties);

#ifdef VK_USE_PLATFORM_SCREEN_QNX
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetScreenBufferPropertiesQNX(VkDevice device, const struct _screen_buffer* buffer, VkScreenBufferPropertiesQNX* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetScreenBufferPropertiesQNX(VkDevice device, const struct _screen_buffer* buffer, VkScreenBufferPropertiesQNX* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetScreenBufferPropertiesQNX(VkDevice device, const struct _screen_buffer* buffer, VkScreenBufferPropertiesQNX* pProperties);

  #define tu_GetScreenBufferPropertiesQNX_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetScreenBufferPropertiesQNX<X>(VkDevice device, const struct _screen_buffer* buffer, VkScreenBufferPropertiesQNX* pProperties);

#endif // VK_USE_PLATFORM_SCREEN_QNX
  VKAPI_ATTR void VKAPI_CALL tu_CmdBindDescriptorSets2(VkCommandBuffer commandBuffer, const VkBindDescriptorSetsInfo*   pBindDescriptorSetsInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBindDescriptorSets2(VkCommandBuffer commandBuffer, const VkBindDescriptorSetsInfo*   pBindDescriptorSetsInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBindDescriptorSets2(VkCommandBuffer commandBuffer, const VkBindDescriptorSetsInfo*   pBindDescriptorSetsInfo);

  #define tu_CmdBindDescriptorSets2_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBindDescriptorSets2<X>(VkCommandBuffer commandBuffer, const VkBindDescriptorSetsInfo*   pBindDescriptorSetsInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBindDescriptorSets2KHR(VkCommandBuffer commandBuffer, const VkBindDescriptorSetsInfo*   pBindDescriptorSetsInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBindDescriptorSets2KHR(VkCommandBuffer commandBuffer, const VkBindDescriptorSetsInfo*   pBindDescriptorSetsInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBindDescriptorSets2KHR(VkCommandBuffer commandBuffer, const VkBindDescriptorSetsInfo*   pBindDescriptorSetsInfo);

  #define tu_CmdBindDescriptorSets2KHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBindDescriptorSets2KHR<X>(VkCommandBuffer commandBuffer, const VkBindDescriptorSetsInfo*   pBindDescriptorSetsInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdPushConstants2(VkCommandBuffer commandBuffer, const VkPushConstantsInfo*        pPushConstantsInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdPushConstants2(VkCommandBuffer commandBuffer, const VkPushConstantsInfo*        pPushConstantsInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdPushConstants2(VkCommandBuffer commandBuffer, const VkPushConstantsInfo*        pPushConstantsInfo);

  #define tu_CmdPushConstants2_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdPushConstants2<X>(VkCommandBuffer commandBuffer, const VkPushConstantsInfo*        pPushConstantsInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdPushConstants2KHR(VkCommandBuffer commandBuffer, const VkPushConstantsInfo*        pPushConstantsInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdPushConstants2KHR(VkCommandBuffer commandBuffer, const VkPushConstantsInfo*        pPushConstantsInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdPushConstants2KHR(VkCommandBuffer commandBuffer, const VkPushConstantsInfo*        pPushConstantsInfo);

  #define tu_CmdPushConstants2KHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdPushConstants2KHR<X>(VkCommandBuffer commandBuffer, const VkPushConstantsInfo*        pPushConstantsInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdPushDescriptorSet2(VkCommandBuffer commandBuffer, const VkPushDescriptorSetInfo*    pPushDescriptorSetInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdPushDescriptorSet2(VkCommandBuffer commandBuffer, const VkPushDescriptorSetInfo*    pPushDescriptorSetInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdPushDescriptorSet2(VkCommandBuffer commandBuffer, const VkPushDescriptorSetInfo*    pPushDescriptorSetInfo);

  #define tu_CmdPushDescriptorSet2_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdPushDescriptorSet2<X>(VkCommandBuffer commandBuffer, const VkPushDescriptorSetInfo*    pPushDescriptorSetInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdPushDescriptorSet2KHR(VkCommandBuffer commandBuffer, const VkPushDescriptorSetInfo*    pPushDescriptorSetInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdPushDescriptorSet2KHR(VkCommandBuffer commandBuffer, const VkPushDescriptorSetInfo*    pPushDescriptorSetInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdPushDescriptorSet2KHR(VkCommandBuffer commandBuffer, const VkPushDescriptorSetInfo*    pPushDescriptorSetInfo);

  #define tu_CmdPushDescriptorSet2KHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdPushDescriptorSet2KHR<X>(VkCommandBuffer commandBuffer, const VkPushDescriptorSetInfo*    pPushDescriptorSetInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdPushDescriptorSetWithTemplate2(VkCommandBuffer commandBuffer, const VkPushDescriptorSetWithTemplateInfo* pPushDescriptorSetWithTemplateInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdPushDescriptorSetWithTemplate2(VkCommandBuffer commandBuffer, const VkPushDescriptorSetWithTemplateInfo* pPushDescriptorSetWithTemplateInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdPushDescriptorSetWithTemplate2(VkCommandBuffer commandBuffer, const VkPushDescriptorSetWithTemplateInfo* pPushDescriptorSetWithTemplateInfo);

  #define tu_CmdPushDescriptorSetWithTemplate2_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdPushDescriptorSetWithTemplate2<X>(VkCommandBuffer commandBuffer, const VkPushDescriptorSetWithTemplateInfo* pPushDescriptorSetWithTemplateInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdPushDescriptorSetWithTemplate2KHR(VkCommandBuffer commandBuffer, const VkPushDescriptorSetWithTemplateInfo* pPushDescriptorSetWithTemplateInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdPushDescriptorSetWithTemplate2KHR(VkCommandBuffer commandBuffer, const VkPushDescriptorSetWithTemplateInfo* pPushDescriptorSetWithTemplateInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdPushDescriptorSetWithTemplate2KHR(VkCommandBuffer commandBuffer, const VkPushDescriptorSetWithTemplateInfo* pPushDescriptorSetWithTemplateInfo);

  #define tu_CmdPushDescriptorSetWithTemplate2KHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdPushDescriptorSetWithTemplate2KHR<X>(VkCommandBuffer commandBuffer, const VkPushDescriptorSetWithTemplateInfo* pPushDescriptorSetWithTemplateInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDescriptorBufferOffsets2EXT(VkCommandBuffer commandBuffer, const VkSetDescriptorBufferOffsetsInfoEXT* pSetDescriptorBufferOffsetsInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetDescriptorBufferOffsets2EXT(VkCommandBuffer commandBuffer, const VkSetDescriptorBufferOffsetsInfoEXT* pSetDescriptorBufferOffsetsInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDescriptorBufferOffsets2EXT(VkCommandBuffer commandBuffer, const VkSetDescriptorBufferOffsetsInfoEXT* pSetDescriptorBufferOffsetsInfo);

  #define tu_CmdSetDescriptorBufferOffsets2EXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetDescriptorBufferOffsets2EXT<X>(VkCommandBuffer commandBuffer, const VkSetDescriptorBufferOffsetsInfoEXT* pSetDescriptorBufferOffsetsInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBindDescriptorBufferEmbeddedSamplers2EXT(VkCommandBuffer commandBuffer, const VkBindDescriptorBufferEmbeddedSamplersInfoEXT* pBindDescriptorBufferEmbeddedSamplersInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBindDescriptorBufferEmbeddedSamplers2EXT(VkCommandBuffer commandBuffer, const VkBindDescriptorBufferEmbeddedSamplersInfoEXT* pBindDescriptorBufferEmbeddedSamplersInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBindDescriptorBufferEmbeddedSamplers2EXT(VkCommandBuffer commandBuffer, const VkBindDescriptorBufferEmbeddedSamplersInfoEXT* pBindDescriptorBufferEmbeddedSamplersInfo);

  #define tu_CmdBindDescriptorBufferEmbeddedSamplers2EXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBindDescriptorBufferEmbeddedSamplers2EXT<X>(VkCommandBuffer commandBuffer, const VkBindDescriptorBufferEmbeddedSamplersInfoEXT* pBindDescriptorBufferEmbeddedSamplersInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_SetLatencySleepModeNV(VkDevice device, VkSwapchainKHR swapchain, const VkLatencySleepModeInfoNV* pSleepModeInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_SetLatencySleepModeNV(VkDevice device, VkSwapchainKHR swapchain, const VkLatencySleepModeInfoNV* pSleepModeInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_SetLatencySleepModeNV(VkDevice device, VkSwapchainKHR swapchain, const VkLatencySleepModeInfoNV* pSleepModeInfo);

  #define tu_SetLatencySleepModeNV_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_SetLatencySleepModeNV<X>(VkDevice device, VkSwapchainKHR swapchain, const VkLatencySleepModeInfoNV* pSleepModeInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_LatencySleepNV(VkDevice device, VkSwapchainKHR swapchain, const VkLatencySleepInfoNV* pSleepInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_LatencySleepNV(VkDevice device, VkSwapchainKHR swapchain, const VkLatencySleepInfoNV* pSleepInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_LatencySleepNV(VkDevice device, VkSwapchainKHR swapchain, const VkLatencySleepInfoNV* pSleepInfo);

  #define tu_LatencySleepNV_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_LatencySleepNV<X>(VkDevice device, VkSwapchainKHR swapchain, const VkLatencySleepInfoNV* pSleepInfo);

  VKAPI_ATTR void VKAPI_CALL tu_SetLatencyMarkerNV(VkDevice device, VkSwapchainKHR swapchain, const VkSetLatencyMarkerInfoNV* pLatencyMarkerInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_SetLatencyMarkerNV(VkDevice device, VkSwapchainKHR swapchain, const VkSetLatencyMarkerInfoNV* pLatencyMarkerInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_SetLatencyMarkerNV(VkDevice device, VkSwapchainKHR swapchain, const VkSetLatencyMarkerInfoNV* pLatencyMarkerInfo);

  #define tu_SetLatencyMarkerNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_SetLatencyMarkerNV<X>(VkDevice device, VkSwapchainKHR swapchain, const VkSetLatencyMarkerInfoNV* pLatencyMarkerInfo);

  VKAPI_ATTR void VKAPI_CALL tu_GetLatencyTimingsNV(VkDevice device, VkSwapchainKHR swapchain, VkGetLatencyMarkerInfoNV* pLatencyMarkerInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetLatencyTimingsNV(VkDevice device, VkSwapchainKHR swapchain, VkGetLatencyMarkerInfoNV* pLatencyMarkerInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetLatencyTimingsNV(VkDevice device, VkSwapchainKHR swapchain, VkGetLatencyMarkerInfoNV* pLatencyMarkerInfo);

  #define tu_GetLatencyTimingsNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetLatencyTimingsNV<X>(VkDevice device, VkSwapchainKHR swapchain, VkGetLatencyMarkerInfoNV* pLatencyMarkerInfo);

  VKAPI_ATTR void VKAPI_CALL tu_QueueNotifyOutOfBandNV(VkQueue queue, const VkOutOfBandQueueTypeInfoNV* pQueueTypeInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_QueueNotifyOutOfBandNV(VkQueue queue, const VkOutOfBandQueueTypeInfoNV* pQueueTypeInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_QueueNotifyOutOfBandNV(VkQueue queue, const VkOutOfBandQueueTypeInfoNV* pQueueTypeInfo);

  #define tu_QueueNotifyOutOfBandNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_QueueNotifyOutOfBandNV<X>(VkQueue queue, const VkOutOfBandQueueTypeInfoNV* pQueueTypeInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetRenderingAttachmentLocations(VkCommandBuffer commandBuffer, const VkRenderingAttachmentLocationInfo* pLocationInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetRenderingAttachmentLocations(VkCommandBuffer commandBuffer, const VkRenderingAttachmentLocationInfo* pLocationInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetRenderingAttachmentLocations(VkCommandBuffer commandBuffer, const VkRenderingAttachmentLocationInfo* pLocationInfo);

  #define tu_CmdSetRenderingAttachmentLocations_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetRenderingAttachmentLocations<X>(VkCommandBuffer commandBuffer, const VkRenderingAttachmentLocationInfo* pLocationInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetRenderingAttachmentLocationsKHR(VkCommandBuffer commandBuffer, const VkRenderingAttachmentLocationInfo* pLocationInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetRenderingAttachmentLocationsKHR(VkCommandBuffer commandBuffer, const VkRenderingAttachmentLocationInfo* pLocationInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetRenderingAttachmentLocationsKHR(VkCommandBuffer commandBuffer, const VkRenderingAttachmentLocationInfo* pLocationInfo);

  #define tu_CmdSetRenderingAttachmentLocationsKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetRenderingAttachmentLocationsKHR<X>(VkCommandBuffer commandBuffer, const VkRenderingAttachmentLocationInfo* pLocationInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetRenderingInputAttachmentIndices(VkCommandBuffer commandBuffer, const VkRenderingInputAttachmentIndexInfo* pInputAttachmentIndexInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetRenderingInputAttachmentIndices(VkCommandBuffer commandBuffer, const VkRenderingInputAttachmentIndexInfo* pInputAttachmentIndexInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetRenderingInputAttachmentIndices(VkCommandBuffer commandBuffer, const VkRenderingInputAttachmentIndexInfo* pInputAttachmentIndexInfo);

  #define tu_CmdSetRenderingInputAttachmentIndices_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetRenderingInputAttachmentIndices<X>(VkCommandBuffer commandBuffer, const VkRenderingInputAttachmentIndexInfo* pInputAttachmentIndexInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetRenderingInputAttachmentIndicesKHR(VkCommandBuffer commandBuffer, const VkRenderingInputAttachmentIndexInfo* pInputAttachmentIndexInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetRenderingInputAttachmentIndicesKHR(VkCommandBuffer commandBuffer, const VkRenderingInputAttachmentIndexInfo* pInputAttachmentIndexInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetRenderingInputAttachmentIndicesKHR(VkCommandBuffer commandBuffer, const VkRenderingInputAttachmentIndexInfo* pInputAttachmentIndexInfo);

  #define tu_CmdSetRenderingInputAttachmentIndicesKHR_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetRenderingInputAttachmentIndicesKHR<X>(VkCommandBuffer commandBuffer, const VkRenderingInputAttachmentIndexInfo* pInputAttachmentIndexInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthClampRangeEXT(VkCommandBuffer commandBuffer, VkDepthClampModeEXT depthClampMode, const VkDepthClampRangeEXT* pDepthClampRange) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdSetDepthClampRangeEXT(VkCommandBuffer commandBuffer, VkDepthClampModeEXT depthClampMode, const VkDepthClampRangeEXT* pDepthClampRange) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthClampRangeEXT(VkCommandBuffer commandBuffer, VkDepthClampModeEXT depthClampMode, const VkDepthClampRangeEXT* pDepthClampRange);

  #define tu_CmdSetDepthClampRangeEXT_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdSetDepthClampRangeEXT<X>(VkCommandBuffer commandBuffer, VkDepthClampModeEXT depthClampMode, const VkDepthClampRangeEXT* pDepthClampRange);

#ifdef VK_USE_PLATFORM_METAL_EXT
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryMetalHandleEXT(VkDevice device, const VkMemoryGetMetalHandleInfoEXT* pGetMetalHandleInfo, void** pHandle) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetMemoryMetalHandleEXT(VkDevice device, const VkMemoryGetMetalHandleInfoEXT* pGetMetalHandleInfo, void** pHandle) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryMetalHandleEXT(VkDevice device, const VkMemoryGetMetalHandleInfoEXT* pGetMetalHandleInfo, void** pHandle);

  #define tu_GetMemoryMetalHandleEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryMetalHandleEXT<X>(VkDevice device, const VkMemoryGetMetalHandleInfoEXT* pGetMetalHandleInfo, void** pHandle);

#endif // VK_USE_PLATFORM_METAL_EXT
#ifdef VK_USE_PLATFORM_METAL_EXT
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryMetalHandlePropertiesEXT(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, const void* pHandle, VkMemoryMetalHandlePropertiesEXT* pMemoryMetalHandleProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetMemoryMetalHandlePropertiesEXT(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, const void* pHandle, VkMemoryMetalHandlePropertiesEXT* pMemoryMetalHandleProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryMetalHandlePropertiesEXT(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, const void* pHandle, VkMemoryMetalHandlePropertiesEXT* pMemoryMetalHandleProperties);

  #define tu_GetMemoryMetalHandlePropertiesEXT_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryMetalHandlePropertiesEXT<X>(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, const void* pHandle, VkMemoryMetalHandlePropertiesEXT* pMemoryMetalHandleProperties);

#endif // VK_USE_PLATFORM_METAL_EXT
  VKAPI_ATTR VkResult VKAPI_CALL tu_ConvertCooperativeVectorMatrixNV(VkDevice device, const VkConvertCooperativeVectorMatrixInfoNV* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_ConvertCooperativeVectorMatrixNV(VkDevice device, const VkConvertCooperativeVectorMatrixInfoNV* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_ConvertCooperativeVectorMatrixNV(VkDevice device, const VkConvertCooperativeVectorMatrixInfoNV* pInfo);

  #define tu_ConvertCooperativeVectorMatrixNV_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_ConvertCooperativeVectorMatrixNV<X>(VkDevice device, const VkConvertCooperativeVectorMatrixInfoNV* pInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdConvertCooperativeVectorMatrixNV(VkCommandBuffer commandBuffer, uint32_t infoCount, const VkConvertCooperativeVectorMatrixInfoNV* pInfos) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdConvertCooperativeVectorMatrixNV(VkCommandBuffer commandBuffer, uint32_t infoCount, const VkConvertCooperativeVectorMatrixInfoNV* pInfos) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdConvertCooperativeVectorMatrixNV(VkCommandBuffer commandBuffer, uint32_t infoCount, const VkConvertCooperativeVectorMatrixInfoNV* pInfos);

  #define tu_CmdConvertCooperativeVectorMatrixNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdConvertCooperativeVectorMatrixNV<X>(VkCommandBuffer commandBuffer, uint32_t infoCount, const VkConvertCooperativeVectorMatrixInfoNV* pInfos);

  VKAPI_ATTR void VKAPI_CALL tu_CmdDispatchTileQCOM(VkCommandBuffer commandBuffer, const VkDispatchTileInfoQCOM* pDispatchTileInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDispatchTileQCOM(VkCommandBuffer commandBuffer, const VkDispatchTileInfoQCOM* pDispatchTileInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDispatchTileQCOM(VkCommandBuffer commandBuffer, const VkDispatchTileInfoQCOM* pDispatchTileInfo);

  #define tu_CmdDispatchTileQCOM_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDispatchTileQCOM<X>(VkCommandBuffer commandBuffer, const VkDispatchTileInfoQCOM* pDispatchTileInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdBeginPerTileExecutionQCOM(VkCommandBuffer commandBuffer, const VkPerTileBeginInfoQCOM* pPerTileBeginInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdBeginPerTileExecutionQCOM(VkCommandBuffer commandBuffer, const VkPerTileBeginInfoQCOM* pPerTileBeginInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdBeginPerTileExecutionQCOM(VkCommandBuffer commandBuffer, const VkPerTileBeginInfoQCOM* pPerTileBeginInfo);

  #define tu_CmdBeginPerTileExecutionQCOM_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdBeginPerTileExecutionQCOM<X>(VkCommandBuffer commandBuffer, const VkPerTileBeginInfoQCOM* pPerTileBeginInfo);

  VKAPI_ATTR void VKAPI_CALL tu_CmdEndPerTileExecutionQCOM(VkCommandBuffer commandBuffer, const VkPerTileEndInfoQCOM* pPerTileEndInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdEndPerTileExecutionQCOM(VkCommandBuffer commandBuffer, const VkPerTileEndInfoQCOM* pPerTileEndInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdEndPerTileExecutionQCOM(VkCommandBuffer commandBuffer, const VkPerTileEndInfoQCOM* pPerTileEndInfo);

  #define tu_CmdEndPerTileExecutionQCOM_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdEndPerTileExecutionQCOM<X>(VkCommandBuffer commandBuffer, const VkPerTileEndInfoQCOM* pPerTileEndInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateExternalComputeQueueNV(VkDevice device, const VkExternalComputeQueueCreateInfoNV* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkExternalComputeQueueNV* pExternalQueue) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateExternalComputeQueueNV(VkDevice device, const VkExternalComputeQueueCreateInfoNV* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkExternalComputeQueueNV* pExternalQueue) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateExternalComputeQueueNV(VkDevice device, const VkExternalComputeQueueCreateInfoNV* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkExternalComputeQueueNV* pExternalQueue);

  #define tu_CreateExternalComputeQueueNV_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateExternalComputeQueueNV<X>(VkDevice device, const VkExternalComputeQueueCreateInfoNV* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkExternalComputeQueueNV* pExternalQueue);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyExternalComputeQueueNV(VkDevice device, VkExternalComputeQueueNV externalQueue, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyExternalComputeQueueNV(VkDevice device, VkExternalComputeQueueNV externalQueue, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyExternalComputeQueueNV(VkDevice device, VkExternalComputeQueueNV externalQueue, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyExternalComputeQueueNV_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyExternalComputeQueueNV<X>(VkDevice device, VkExternalComputeQueueNV externalQueue, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateTensorARM(VkDevice device, const VkTensorCreateInfoARM* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkTensorARM* pTensor) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateTensorARM(VkDevice device, const VkTensorCreateInfoARM* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkTensorARM* pTensor) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateTensorARM(VkDevice device, const VkTensorCreateInfoARM* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkTensorARM* pTensor);

  #define tu_CreateTensorARM_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateTensorARM<X>(VkDevice device, const VkTensorCreateInfoARM* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkTensorARM* pTensor);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyTensorARM(VkDevice device, VkTensorARM tensor, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyTensorARM(VkDevice device, VkTensorARM tensor, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyTensorARM(VkDevice device, VkTensorARM tensor, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyTensorARM_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyTensorARM<X>(VkDevice device, VkTensorARM tensor, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateTensorViewARM(VkDevice device, const VkTensorViewCreateInfoARM* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkTensorViewARM* pView) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateTensorViewARM(VkDevice device, const VkTensorViewCreateInfoARM* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkTensorViewARM* pView) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateTensorViewARM(VkDevice device, const VkTensorViewCreateInfoARM* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkTensorViewARM* pView);

  #define tu_CreateTensorViewARM_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateTensorViewARM<X>(VkDevice device, const VkTensorViewCreateInfoARM* pCreateInfo, const VkAllocationCallbacks* pAllocator, VkTensorViewARM* pView);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyTensorViewARM(VkDevice device, VkTensorViewARM tensorView, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyTensorViewARM(VkDevice device, VkTensorViewARM tensorView, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyTensorViewARM(VkDevice device, VkTensorViewARM tensorView, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyTensorViewARM_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyTensorViewARM<X>(VkDevice device, VkTensorViewARM tensorView, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR void VKAPI_CALL tu_GetTensorMemoryRequirementsARM(VkDevice device, const VkTensorMemoryRequirementsInfoARM* pInfo, VkMemoryRequirements2* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetTensorMemoryRequirementsARM(VkDevice device, const VkTensorMemoryRequirementsInfoARM* pInfo, VkMemoryRequirements2* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetTensorMemoryRequirementsARM(VkDevice device, const VkTensorMemoryRequirementsInfoARM* pInfo, VkMemoryRequirements2* pMemoryRequirements);

  #define tu_GetTensorMemoryRequirementsARM_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetTensorMemoryRequirementsARM<X>(VkDevice device, const VkTensorMemoryRequirementsInfoARM* pInfo, VkMemoryRequirements2* pMemoryRequirements);

  VKAPI_ATTR VkResult VKAPI_CALL tu_BindTensorMemoryARM(VkDevice device, uint32_t bindInfoCount, const VkBindTensorMemoryInfoARM* pBindInfos) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_BindTensorMemoryARM(VkDevice device, uint32_t bindInfoCount, const VkBindTensorMemoryInfoARM* pBindInfos) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_BindTensorMemoryARM(VkDevice device, uint32_t bindInfoCount, const VkBindTensorMemoryInfoARM* pBindInfos);

  #define tu_BindTensorMemoryARM_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_BindTensorMemoryARM<X>(VkDevice device, uint32_t bindInfoCount, const VkBindTensorMemoryInfoARM* pBindInfos);

  VKAPI_ATTR void VKAPI_CALL tu_GetDeviceTensorMemoryRequirementsARM(VkDevice device, const VkDeviceTensorMemoryRequirementsARM* pInfo, VkMemoryRequirements2* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetDeviceTensorMemoryRequirementsARM(VkDevice device, const VkDeviceTensorMemoryRequirementsARM* pInfo, VkMemoryRequirements2* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetDeviceTensorMemoryRequirementsARM(VkDevice device, const VkDeviceTensorMemoryRequirementsARM* pInfo, VkMemoryRequirements2* pMemoryRequirements);

  #define tu_GetDeviceTensorMemoryRequirementsARM_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetDeviceTensorMemoryRequirementsARM<X>(VkDevice device, const VkDeviceTensorMemoryRequirementsARM* pInfo, VkMemoryRequirements2* pMemoryRequirements);

  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyTensorARM(VkCommandBuffer commandBuffer, const VkCopyTensorInfoARM* pCopyTensorInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdCopyTensorARM(VkCommandBuffer commandBuffer, const VkCopyTensorInfoARM* pCopyTensorInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdCopyTensorARM(VkCommandBuffer commandBuffer, const VkCopyTensorInfoARM* pCopyTensorInfo);

  #define tu_CmdCopyTensorARM_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdCopyTensorARM<X>(VkCommandBuffer commandBuffer, const VkCopyTensorInfoARM* pCopyTensorInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetTensorOpaqueCaptureDescriptorDataARM(VkDevice                                    device, const VkTensorCaptureDescriptorDataInfoARM* pInfo, void*                                       pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetTensorOpaqueCaptureDescriptorDataARM(VkDevice                                    device, const VkTensorCaptureDescriptorDataInfoARM* pInfo, void*                                       pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetTensorOpaqueCaptureDescriptorDataARM(VkDevice                                    device, const VkTensorCaptureDescriptorDataInfoARM* pInfo, void*                                       pData);

  #define tu_GetTensorOpaqueCaptureDescriptorDataARM_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetTensorOpaqueCaptureDescriptorDataARM<X>(VkDevice                                    device, const VkTensorCaptureDescriptorDataInfoARM* pInfo, void*                                       pData);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetTensorViewOpaqueCaptureDescriptorDataARM(VkDevice                                        device, const VkTensorViewCaptureDescriptorDataInfoARM* pInfo, void*                                           pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetTensorViewOpaqueCaptureDescriptorDataARM(VkDevice                                        device, const VkTensorViewCaptureDescriptorDataInfoARM* pInfo, void*                                           pData) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetTensorViewOpaqueCaptureDescriptorDataARM(VkDevice                                        device, const VkTensorViewCaptureDescriptorDataInfoARM* pInfo, void*                                           pData);

  #define tu_GetTensorViewOpaqueCaptureDescriptorDataARM_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetTensorViewOpaqueCaptureDescriptorDataARM<X>(VkDevice                                        device, const VkTensorViewCaptureDescriptorDataInfoARM* pInfo, void*                                           pData);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateDataGraphPipelinesARM(VkDevice               device, VkDeferredOperationKHR deferredOperation, VkPipelineCache        pipelineCache, uint32_t               createInfoCount, const VkDataGraphPipelineCreateInfoARM* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline*     pPipelines) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateDataGraphPipelinesARM(VkDevice               device, VkDeferredOperationKHR deferredOperation, VkPipelineCache        pipelineCache, uint32_t               createInfoCount, const VkDataGraphPipelineCreateInfoARM* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline*     pPipelines) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateDataGraphPipelinesARM(VkDevice               device, VkDeferredOperationKHR deferredOperation, VkPipelineCache        pipelineCache, uint32_t               createInfoCount, const VkDataGraphPipelineCreateInfoARM* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline*     pPipelines);

  #define tu_CreateDataGraphPipelinesARM_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateDataGraphPipelinesARM<X>(VkDevice               device, VkDeferredOperationKHR deferredOperation, VkPipelineCache        pipelineCache, uint32_t               createInfoCount, const VkDataGraphPipelineCreateInfoARM* pCreateInfos, const VkAllocationCallbacks* pAllocator, VkPipeline*     pPipelines);

  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateDataGraphPipelineSessionARM(VkDevice                                     device, const VkDataGraphPipelineSessionCreateInfoARM*   pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDataGraphPipelineSessionARM*                   pSession) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_CreateDataGraphPipelineSessionARM(VkDevice                                     device, const VkDataGraphPipelineSessionCreateInfoARM*   pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDataGraphPipelineSessionARM*                   pSession) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_CreateDataGraphPipelineSessionARM(VkDevice                                     device, const VkDataGraphPipelineSessionCreateInfoARM*   pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDataGraphPipelineSessionARM*                   pSession);

  #define tu_CreateDataGraphPipelineSessionARM_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_CreateDataGraphPipelineSessionARM<X>(VkDevice                                     device, const VkDataGraphPipelineSessionCreateInfoARM*   pCreateInfo, const VkAllocationCallbacks* pAllocator, VkDataGraphPipelineSessionARM*                   pSession);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetDataGraphPipelineSessionBindPointRequirementsARM(VkDevice device, const VkDataGraphPipelineSessionBindPointRequirementsInfoARM* pInfo, uint32_t* pBindPointRequirementCount, VkDataGraphPipelineSessionBindPointRequirementARM* pBindPointRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetDataGraphPipelineSessionBindPointRequirementsARM(VkDevice device, const VkDataGraphPipelineSessionBindPointRequirementsInfoARM* pInfo, uint32_t* pBindPointRequirementCount, VkDataGraphPipelineSessionBindPointRequirementARM* pBindPointRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetDataGraphPipelineSessionBindPointRequirementsARM(VkDevice device, const VkDataGraphPipelineSessionBindPointRequirementsInfoARM* pInfo, uint32_t* pBindPointRequirementCount, VkDataGraphPipelineSessionBindPointRequirementARM* pBindPointRequirements);

  #define tu_GetDataGraphPipelineSessionBindPointRequirementsARM_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetDataGraphPipelineSessionBindPointRequirementsARM<X>(VkDevice device, const VkDataGraphPipelineSessionBindPointRequirementsInfoARM* pInfo, uint32_t* pBindPointRequirementCount, VkDataGraphPipelineSessionBindPointRequirementARM* pBindPointRequirements);

  VKAPI_ATTR void VKAPI_CALL tu_GetDataGraphPipelineSessionMemoryRequirementsARM(VkDevice device, const VkDataGraphPipelineSessionMemoryRequirementsInfoARM* pInfo, VkMemoryRequirements2* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_GetDataGraphPipelineSessionMemoryRequirementsARM(VkDevice device, const VkDataGraphPipelineSessionMemoryRequirementsInfoARM* pInfo, VkMemoryRequirements2* pMemoryRequirements) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_GetDataGraphPipelineSessionMemoryRequirementsARM(VkDevice device, const VkDataGraphPipelineSessionMemoryRequirementsInfoARM* pInfo, VkMemoryRequirements2* pMemoryRequirements);

  #define tu_GetDataGraphPipelineSessionMemoryRequirementsARM_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_GetDataGraphPipelineSessionMemoryRequirementsARM<X>(VkDevice device, const VkDataGraphPipelineSessionMemoryRequirementsInfoARM* pInfo, VkMemoryRequirements2* pMemoryRequirements);

  VKAPI_ATTR VkResult VKAPI_CALL tu_BindDataGraphPipelineSessionMemoryARM(VkDevice device, uint32_t bindInfoCount, const VkBindDataGraphPipelineSessionMemoryInfoARM* pBindInfos) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_BindDataGraphPipelineSessionMemoryARM(VkDevice device, uint32_t bindInfoCount, const VkBindDataGraphPipelineSessionMemoryInfoARM* pBindInfos) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_BindDataGraphPipelineSessionMemoryARM(VkDevice device, uint32_t bindInfoCount, const VkBindDataGraphPipelineSessionMemoryInfoARM* pBindInfos);

  #define tu_BindDataGraphPipelineSessionMemoryARM_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_BindDataGraphPipelineSessionMemoryARM<X>(VkDevice device, uint32_t bindInfoCount, const VkBindDataGraphPipelineSessionMemoryInfoARM* pBindInfos);

  VKAPI_ATTR void VKAPI_CALL tu_DestroyDataGraphPipelineSessionARM(VkDevice device, VkDataGraphPipelineSessionARM session, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_DestroyDataGraphPipelineSessionARM(VkDevice device, VkDataGraphPipelineSessionARM session, const VkAllocationCallbacks* pAllocator) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_DestroyDataGraphPipelineSessionARM(VkDevice device, VkDataGraphPipelineSessionARM session, const VkAllocationCallbacks* pAllocator);

  #define tu_DestroyDataGraphPipelineSessionARM_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_DestroyDataGraphPipelineSessionARM<X>(VkDevice device, VkDataGraphPipelineSessionARM session, const VkAllocationCallbacks* pAllocator);

  VKAPI_ATTR void VKAPI_CALL tu_CmdDispatchDataGraphARM(VkCommandBuffer commandBuffer, VkDataGraphPipelineSessionARM session, const VkDataGraphPipelineDispatchInfoARM* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR void VKAPI_CALL tu_rmv_CmdDispatchDataGraphARM(VkCommandBuffer commandBuffer, VkDataGraphPipelineSessionARM session, const VkDataGraphPipelineDispatchInfoARM* pInfo) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR void VKAPI_CALL tu_CmdDispatchDataGraphARM(VkCommandBuffer commandBuffer, VkDataGraphPipelineSessionARM session, const VkDataGraphPipelineDispatchInfoARM* pInfo);

  #define tu_CmdDispatchDataGraphARM_GENS(X)   template VKAPI_ATTR void VKAPI_CALL tu_CmdDispatchDataGraphARM<X>(VkCommandBuffer commandBuffer, VkDataGraphPipelineSessionARM session, const VkDataGraphPipelineDispatchInfoARM* pInfo);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetDataGraphPipelineAvailablePropertiesARM(VkDevice device, const VkDataGraphPipelineInfoARM* pPipelineInfo, uint32_t* pPropertiesCount, VkDataGraphPipelinePropertyARM* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetDataGraphPipelineAvailablePropertiesARM(VkDevice device, const VkDataGraphPipelineInfoARM* pPipelineInfo, uint32_t* pPropertiesCount, VkDataGraphPipelinePropertyARM* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetDataGraphPipelineAvailablePropertiesARM(VkDevice device, const VkDataGraphPipelineInfoARM* pPipelineInfo, uint32_t* pPropertiesCount, VkDataGraphPipelinePropertyARM* pProperties);

  #define tu_GetDataGraphPipelineAvailablePropertiesARM_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetDataGraphPipelineAvailablePropertiesARM<X>(VkDevice device, const VkDataGraphPipelineInfoARM* pPipelineInfo, uint32_t* pPropertiesCount, VkDataGraphPipelinePropertyARM* pProperties);

  VKAPI_ATTR VkResult VKAPI_CALL tu_GetDataGraphPipelinePropertiesARM(VkDevice                          device, const VkDataGraphPipelineInfoARM* pPipelineInfo, uint32_t                          propertiesCount, VkDataGraphPipelinePropertyQueryResultARM* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetDataGraphPipelinePropertiesARM(VkDevice                          device, const VkDataGraphPipelineInfoARM* pPipelineInfo, uint32_t                          propertiesCount, VkDataGraphPipelinePropertyQueryResultARM* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetDataGraphPipelinePropertiesARM(VkDevice                          device, const VkDataGraphPipelineInfoARM* pPipelineInfo, uint32_t                          propertiesCount, VkDataGraphPipelinePropertyQueryResultARM* pProperties);

  #define tu_GetDataGraphPipelinePropertiesARM_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetDataGraphPipelinePropertiesARM<X>(VkDevice                          device, const VkDataGraphPipelineInfoARM* pPipelineInfo, uint32_t                          propertiesCount, VkDataGraphPipelinePropertyQueryResultARM* pProperties);

#ifdef VK_USE_PLATFORM_OHOS
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetNativeBufferPropertiesOHOS(VkDevice device, const struct OH_NativeBuffer* buffer, VkNativeBufferPropertiesOHOS* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetNativeBufferPropertiesOHOS(VkDevice device, const struct OH_NativeBuffer* buffer, VkNativeBufferPropertiesOHOS* pProperties) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetNativeBufferPropertiesOHOS(VkDevice device, const struct OH_NativeBuffer* buffer, VkNativeBufferPropertiesOHOS* pProperties);

  #define tu_GetNativeBufferPropertiesOHOS_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetNativeBufferPropertiesOHOS<X>(VkDevice device, const struct OH_NativeBuffer* buffer, VkNativeBufferPropertiesOHOS* pProperties);

#endif // VK_USE_PLATFORM_OHOS
#ifdef VK_USE_PLATFORM_OHOS
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryNativeBufferOHOS(VkDevice device, const VkMemoryGetNativeBufferInfoOHOS* pInfo, struct OH_NativeBuffer** pBuffer) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetMemoryNativeBufferOHOS(VkDevice device, const VkMemoryGetNativeBufferInfoOHOS* pInfo, struct OH_NativeBuffer** pBuffer) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryNativeBufferOHOS(VkDevice device, const VkMemoryGetNativeBufferInfoOHOS* pInfo, struct OH_NativeBuffer** pBuffer);

  #define tu_GetMemoryNativeBufferOHOS_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetMemoryNativeBufferOHOS<X>(VkDevice device, const VkMemoryGetNativeBufferInfoOHOS* pInfo, struct OH_NativeBuffer** pBuffer);

#endif // VK_USE_PLATFORM_OHOS
#ifdef VK_USE_PLATFORM_OHOS
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetSwapchainGrallocUsageOHOS(VkDevice device, VkFormat format, VkImageUsageFlags imageUsage, uint64_t* grallocUsage) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_GetSwapchainGrallocUsageOHOS(VkDevice device, VkFormat format, VkImageUsageFlags imageUsage, uint64_t* grallocUsage) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_GetSwapchainGrallocUsageOHOS(VkDevice device, VkFormat format, VkImageUsageFlags imageUsage, uint64_t* grallocUsage);

  #define tu_GetSwapchainGrallocUsageOHOS_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_GetSwapchainGrallocUsageOHOS<X>(VkDevice device, VkFormat format, VkImageUsageFlags imageUsage, uint64_t* grallocUsage);

#endif // VK_USE_PLATFORM_OHOS
#ifdef VK_USE_PLATFORM_OHOS
  VKAPI_ATTR VkResult VKAPI_CALL tu_AcquireImageOHOS(VkDevice device, VkImage image, int32_t nativeFenceFd, VkSemaphore semaphore, VkFence fence) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_AcquireImageOHOS(VkDevice device, VkImage image, int32_t nativeFenceFd, VkSemaphore semaphore, VkFence fence) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_AcquireImageOHOS(VkDevice device, VkImage image, int32_t nativeFenceFd, VkSemaphore semaphore, VkFence fence);

  #define tu_AcquireImageOHOS_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_AcquireImageOHOS<X>(VkDevice device, VkImage image, int32_t nativeFenceFd, VkSemaphore semaphore, VkFence fence);

#endif // VK_USE_PLATFORM_OHOS
#ifdef VK_USE_PLATFORM_OHOS
  VKAPI_ATTR VkResult VKAPI_CALL tu_QueueSignalReleaseImageOHOS(VkQueue queue, uint32_t waitSemaphoreCount, const VkSemaphore* pWaitSemaphores, VkImage image, int32_t* pNativeFenceFd) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;
  VKAPI_ATTR VkResult VKAPI_CALL tu_rmv_QueueSignalReleaseImageOHOS(VkQueue queue, uint32_t waitSemaphoreCount, const VkSemaphore* pWaitSemaphores, VkImage image, int32_t* pNativeFenceFd) VK_ENTRY_WEAK VK_ENTRY_HIDDEN;

  template <chip CHIP>
  VKAPI_ATTR VkResult VKAPI_CALL tu_QueueSignalReleaseImageOHOS(VkQueue queue, uint32_t waitSemaphoreCount, const VkSemaphore* pWaitSemaphores, VkImage image, int32_t* pNativeFenceFd);

  #define tu_QueueSignalReleaseImageOHOS_GENS(X)   template VKAPI_ATTR VkResult VKAPI_CALL tu_QueueSignalReleaseImageOHOS<X>(VkQueue queue, uint32_t waitSemaphoreCount, const VkSemaphore* pWaitSemaphores, VkImage image, int32_t* pNativeFenceFd);

#endif // VK_USE_PLATFORM_OHOS


#endif /* TU_ENTRYPOINTS_H */
