// storage/browser/quota/quota_internals.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "storage/browser/quota/quota_internals.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "storage/browser/quota/quota_internals.mojom-params-data.h"
namespace storage {
namespace mojom {

namespace internal {


// static
bool BucketTableEntry_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BucketTableEntry_Data* object =
      static_cast<const BucketTableEntry_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->storage_key, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& storage_key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->storage_key, validation_context,
                                         &storage_key_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::StorageType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_accessed, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->last_accessed, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_modified, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->last_modified, validation_context))
    return false;

  return true;
}

BucketTableEntry_Data::BucketTableEntry_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_Params_Data* object =
      static_cast<const QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_Params_Data*>(data);

  return true;
}

QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_Params_Data::QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ResponseParams_Data* object =
      static_cast<const QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ResponseParams_Data*>(data);

  return true;
}

QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ResponseParams_Data::QuotaInternalsHandler_GetDiskAvailabilityAndTempPoolSize_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuotaInternalsHandler_GetStatistics_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const QuotaInternalsHandler_GetStatistics_Params_Data* object =
      static_cast<const QuotaInternalsHandler_GetStatistics_Params_Data*>(data);

  return true;
}

QuotaInternalsHandler_GetStatistics_Params_Data::QuotaInternalsHandler_GetStatistics_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuotaInternalsHandler_GetStatistics_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const QuotaInternalsHandler_GetStatistics_ResponseParams_Data* object =
      static_cast<const QuotaInternalsHandler_GetStatistics_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->eviction_statistics, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& eviction_statistics_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->eviction_statistics, validation_context,
                                         &eviction_statistics_validate_params)) {
    return false;
  }

  return true;
}

QuotaInternalsHandler_GetStatistics_ResponseParams_Data::QuotaInternalsHandler_GetStatistics_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuotaInternalsHandler_SimulateStoragePressure_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const QuotaInternalsHandler_SimulateStoragePressure_Params_Data* object =
      static_cast<const QuotaInternalsHandler_SimulateStoragePressure_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin_url, validation_context))
    return false;

  return true;
}

QuotaInternalsHandler_SimulateStoragePressure_Params_Data::QuotaInternalsHandler_SimulateStoragePressure_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuotaInternalsHandler_RetrieveBucketsTable_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const QuotaInternalsHandler_RetrieveBucketsTable_Params_Data* object =
      static_cast<const QuotaInternalsHandler_RetrieveBucketsTable_Params_Data*>(data);

  return true;
}

QuotaInternalsHandler_RetrieveBucketsTable_Params_Data::QuotaInternalsHandler_RetrieveBucketsTable_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuotaInternalsHandler_RetrieveBucketsTable_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const QuotaInternalsHandler_RetrieveBucketsTable_ResponseParams_Data* object =
      static_cast<const QuotaInternalsHandler_RetrieveBucketsTable_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->entries, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& entries_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->entries, validation_context,
                                         &entries_validate_params)) {
    return false;
  }

  return true;
}

QuotaInternalsHandler_RetrieveBucketsTable_ResponseParams_Data::QuotaInternalsHandler_RetrieveBucketsTable_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuotaInternalsHandler_GetGlobalUsageForInternals_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const QuotaInternalsHandler_GetGlobalUsageForInternals_Params_Data* object =
      static_cast<const QuotaInternalsHandler_GetGlobalUsageForInternals_Params_Data*>(data);


  if (!::blink::mojom::internal::StorageType_Data
        ::Validate(object->storage_type, validation_context))
    return false;

  return true;
}

QuotaInternalsHandler_GetGlobalUsageForInternals_Params_Data::QuotaInternalsHandler_GetGlobalUsageForInternals_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuotaInternalsHandler_GetGlobalUsageForInternals_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const QuotaInternalsHandler_GetGlobalUsageForInternals_ResponseParams_Data* object =
      static_cast<const QuotaInternalsHandler_GetGlobalUsageForInternals_ResponseParams_Data*>(data);

  return true;
}

QuotaInternalsHandler_GetGlobalUsageForInternals_ResponseParams_Data::QuotaInternalsHandler_GetGlobalUsageForInternals_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuotaInternalsHandler_IsSimulateStoragePressureAvailable_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const QuotaInternalsHandler_IsSimulateStoragePressureAvailable_Params_Data* object =
      static_cast<const QuotaInternalsHandler_IsSimulateStoragePressureAvailable_Params_Data*>(data);

  return true;
}

QuotaInternalsHandler_IsSimulateStoragePressureAvailable_Params_Data::QuotaInternalsHandler_IsSimulateStoragePressureAvailable_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ResponseParams_Data* object =
      static_cast<const QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ResponseParams_Data*>(data);

  return true;
}

QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ResponseParams_Data::QuotaInternalsHandler_IsSimulateStoragePressureAvailable_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace storage