// skia/public/mojom/image_info.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "skia/public/mojom/image_info.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "skia/public/mojom/image_info.mojom-params-data.h"
namespace skia {
namespace mojom {

NOINLINE static const char* ColorTypeToStringHelper(ColorType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ColorType::UNKNOWN:
      return "UNKNOWN";
    case ColorType::ALPHA_8:
      return "ALPHA_8";
    case ColorType::RGB_565:
      return "RGB_565";
    case ColorType::ARGB_4444:
      return "ARGB_4444";
    case ColorType::RGBA_8888:
      return "RGBA_8888";
    case ColorType::BGRA_8888:
      return "BGRA_8888";
    case ColorType::DEPRECATED_INDEX_8:
      return "DEPRECATED_INDEX_8";
    case ColorType::GRAY_8:
      return "GRAY_8";
    default:
      return nullptr;
  }
}

std::string ColorTypeToString(ColorType value) {
  const char *str = ColorTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ColorType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ColorType value) {
  return os << ColorTypeToString(value);
}

NOINLINE static const char* AlphaTypeToStringHelper(AlphaType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AlphaType::UNKNOWN:
      return "UNKNOWN";
    case AlphaType::ALPHA_TYPE_OPAQUE:
      return "ALPHA_TYPE_OPAQUE";
    case AlphaType::PREMUL:
      return "PREMUL";
    case AlphaType::UNPREMUL:
      return "UNPREMUL";
    default:
      return nullptr;
  }
}

std::string AlphaTypeToString(AlphaType value) {
  const char *str = AlphaTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AlphaType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AlphaType value) {
  return os << AlphaTypeToString(value);
}

namespace internal {


// static
bool ImageInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ImageInfo_Data* object =
      static_cast<const ImageInfo_Data*>(data);


  if (!::skia::mojom::internal::ColorType_Data
        ::Validate(object->color_type, validation_context))
    return false;


  if (!::skia::mojom::internal::AlphaType_Data
        ::Validate(object->alpha_type, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& color_transfer_function_validate_params =
      mojo::internal::GetArrayValidator<7, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->color_transfer_function, validation_context,
                                         &color_transfer_function_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& color_to_xyz_matrix_validate_params =
      mojo::internal::GetArrayValidator<9, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->color_to_xyz_matrix, validation_context,
                                         &color_to_xyz_matrix_validate_params)) {
    return false;
  }

  return true;
}

ImageInfo_Data::ImageInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BitmapN32ImageInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BitmapN32ImageInfo_Data* object =
      static_cast<const BitmapN32ImageInfo_Data*>(data);


  if (!::skia::mojom::internal::AlphaType_Data
        ::Validate(object->alpha_type, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& color_transfer_function_validate_params =
      mojo::internal::GetArrayValidator<7, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->color_transfer_function, validation_context,
                                         &color_transfer_function_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& color_to_xyz_matrix_validate_params =
      mojo::internal::GetArrayValidator<9, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->color_to_xyz_matrix, validation_context,
                                         &color_to_xyz_matrix_validate_params)) {
    return false;
  }

  return true;
}

BitmapN32ImageInfo_Data::BitmapN32ImageInfo_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace skia

namespace perfetto {

// static
void TraceFormatTraits<::skia::mojom::ColorType>::WriteIntoTrace(
   perfetto::TracedValue context, ::skia::mojom::ColorType value) {
  return std::move(context).WriteString(::skia::mojom::ColorTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::skia::mojom::AlphaType>::WriteIntoTrace(
   perfetto::TracedValue context, ::skia::mojom::AlphaType value) {
  return std::move(context).WriteString(::skia::mojom::AlphaTypeToString(value));
}

} // namespace perfetto