// services/viz/public/mojom/compositing/frame_interval_inputs.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_INTERVAL_INPUTS_MOJOM_BLINK_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_INTERVAL_INPUTS_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/viz/public/mojom/compositing/frame_interval_inputs.mojom-features.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/frame_interval_inputs.mojom-shared.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/frame_interval_inputs.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace viz::mojom::blink {









class BLINK_PLATFORM_EXPORT ContentFrameIntervalInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ContentFrameIntervalInfo, T>::value>;
  using DataView = ContentFrameIntervalInfoDataView;
  using Data_ = internal::ContentFrameIntervalInfo_Data;

  template <typename... Args>
  static ContentFrameIntervalInfoPtr New(Args&&... args) {
    return ContentFrameIntervalInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ContentFrameIntervalInfoPtr From(const U& u) {
    return mojo::TypeConverter<ContentFrameIntervalInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ContentFrameIntervalInfo>::Convert(*this);
  }


  ContentFrameIntervalInfo();

  ContentFrameIntervalInfo(
      ContentFrameIntervalType type,
      ::base::TimeDelta frame_interval,
      uint32_t duplicate_count);


  ~ContentFrameIntervalInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ContentFrameIntervalInfoPtr>
  ContentFrameIntervalInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ContentFrameIntervalInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ContentFrameIntervalInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ContentFrameIntervalInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ContentFrameIntervalInfo::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ContentFrameIntervalInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ContentFrameIntervalInfo_UnserializedMessageContext<
            UserType, ContentFrameIntervalInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ContentFrameIntervalInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ContentFrameIntervalInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ContentFrameIntervalInfo_UnserializedMessageContext<
            UserType, ContentFrameIntervalInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ContentFrameIntervalInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ContentFrameIntervalType type;
  
  ::base::TimeDelta frame_interval;
  
  uint32_t duplicate_count;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ContentFrameIntervalInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ContentFrameIntervalInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ContentFrameIntervalInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ContentFrameIntervalInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT FrameIntervalInputs {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FrameIntervalInputs, T>::value>;
  using DataView = FrameIntervalInputsDataView;
  using Data_ = internal::FrameIntervalInputs_Data;

  template <typename... Args>
  static FrameIntervalInputsPtr New(Args&&... args) {
    return FrameIntervalInputsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FrameIntervalInputsPtr From(const U& u) {
    return mojo::TypeConverter<FrameIntervalInputsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FrameIntervalInputs>::Convert(*this);
  }


  FrameIntervalInputs();

  FrameIntervalInputs(
      ::base::TimeTicks frame_time,
      bool has_input,
      WTF::Vector<ContentFrameIntervalInfoPtr> content_interval_info,
      bool has_only_content_frame_interval_updates);

FrameIntervalInputs(const FrameIntervalInputs&) = delete;
FrameIntervalInputs& operator=(const FrameIntervalInputs&) = delete;

  ~FrameIntervalInputs();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FrameIntervalInputsPtr>
  FrameIntervalInputsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FrameIntervalInputs::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FrameIntervalInputs::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FrameIntervalInputs::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameIntervalInputs::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FrameIntervalInputs::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FrameIntervalInputs_UnserializedMessageContext<
            UserType, FrameIntervalInputs::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FrameIntervalInputs::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FrameIntervalInputs::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FrameIntervalInputs_UnserializedMessageContext<
            UserType, FrameIntervalInputs::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FrameIntervalInputs::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::TimeTicks frame_time;
  
  bool has_input;
  
  WTF::Vector<ContentFrameIntervalInfoPtr> content_interval_info;
  
  bool has_only_content_frame_interval_updates;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FrameIntervalInputs::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FrameIntervalInputs::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FrameIntervalInputs::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FrameIntervalInputs::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ContentFrameIntervalInfoPtr ContentFrameIntervalInfo::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(frame_interval),
      mojo::Clone(duplicate_count)
  );
}

template <typename T, ContentFrameIntervalInfo::EnableIfSame<T>*>
bool ContentFrameIntervalInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->frame_interval, other_struct.frame_interval))
    return false;
  if (!mojo::Equals(this->duplicate_count, other_struct.duplicate_count))
    return false;
  return true;
}

template <typename T, ContentFrameIntervalInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.frame_interval < rhs.frame_interval)
    return true;
  if (rhs.frame_interval < lhs.frame_interval)
    return false;
  if (lhs.duplicate_count < rhs.duplicate_count)
    return true;
  if (rhs.duplicate_count < lhs.duplicate_count)
    return false;
  return false;
}
template <typename StructPtrType>
FrameIntervalInputsPtr FrameIntervalInputs::Clone() const {
  return New(
      mojo::Clone(frame_time),
      mojo::Clone(has_input),
      mojo::Clone(content_interval_info),
      mojo::Clone(has_only_content_frame_interval_updates)
  );
}

template <typename T, FrameIntervalInputs::EnableIfSame<T>*>
bool FrameIntervalInputs::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->frame_time, other_struct.frame_time))
    return false;
  if (!mojo::Equals(this->has_input, other_struct.has_input))
    return false;
  if (!mojo::Equals(this->content_interval_info, other_struct.content_interval_info))
    return false;
  if (!mojo::Equals(this->has_only_content_frame_interval_updates, other_struct.has_only_content_frame_interval_updates))
    return false;
  return true;
}

template <typename T, FrameIntervalInputs::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.frame_time < rhs.frame_time)
    return true;
  if (rhs.frame_time < lhs.frame_time)
    return false;
  if (lhs.has_input < rhs.has_input)
    return true;
  if (rhs.has_input < lhs.has_input)
    return false;
  if (lhs.content_interval_info < rhs.content_interval_info)
    return true;
  if (rhs.content_interval_info < lhs.content_interval_info)
    return false;
  if (lhs.has_only_content_frame_interval_updates < rhs.has_only_content_frame_interval_updates)
    return true;
  if (rhs.has_only_content_frame_interval_updates < lhs.has_only_content_frame_interval_updates)
    return false;
  return false;
}


}  // viz::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::ContentFrameIntervalInfo::DataView,
                                         ::viz::mojom::blink::ContentFrameIntervalInfoPtr> {
  static bool IsNull(const ::viz::mojom::blink::ContentFrameIntervalInfoPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::ContentFrameIntervalInfoPtr* output) { output->reset(); }

  static decltype(::viz::mojom::blink::ContentFrameIntervalInfo::type) type(
      const ::viz::mojom::blink::ContentFrameIntervalInfoPtr& input) {
    return input->type;
  }

  static const decltype(::viz::mojom::blink::ContentFrameIntervalInfo::frame_interval)& frame_interval(
      const ::viz::mojom::blink::ContentFrameIntervalInfoPtr& input) {
    return input->frame_interval;
  }

  static decltype(::viz::mojom::blink::ContentFrameIntervalInfo::duplicate_count) duplicate_count(
      const ::viz::mojom::blink::ContentFrameIntervalInfoPtr& input) {
    return input->duplicate_count;
  }

  static bool Read(::viz::mojom::blink::ContentFrameIntervalInfo::DataView input, ::viz::mojom::blink::ContentFrameIntervalInfoPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::viz::mojom::blink::FrameIntervalInputs::DataView,
                                         ::viz::mojom::blink::FrameIntervalInputsPtr> {
  static bool IsNull(const ::viz::mojom::blink::FrameIntervalInputsPtr& input) { return !input; }
  static void SetToNull(::viz::mojom::blink::FrameIntervalInputsPtr* output) { output->reset(); }

  static const decltype(::viz::mojom::blink::FrameIntervalInputs::frame_time)& frame_time(
      const ::viz::mojom::blink::FrameIntervalInputsPtr& input) {
    return input->frame_time;
  }

  static decltype(::viz::mojom::blink::FrameIntervalInputs::has_input) has_input(
      const ::viz::mojom::blink::FrameIntervalInputsPtr& input) {
    return input->has_input;
  }

  static const decltype(::viz::mojom::blink::FrameIntervalInputs::content_interval_info)& content_interval_info(
      const ::viz::mojom::blink::FrameIntervalInputsPtr& input) {
    return input->content_interval_info;
  }

  static decltype(::viz::mojom::blink::FrameIntervalInputs::has_only_content_frame_interval_updates) has_only_content_frame_interval_updates(
      const ::viz::mojom::blink::FrameIntervalInputsPtr& input) {
    return input->has_only_content_frame_interval_updates;
  }

  static bool Read(::viz::mojom::blink::FrameIntervalInputs::DataView input, ::viz::mojom::blink::FrameIntervalInputsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_FRAME_INTERVAL_INPUTS_MOJOM_BLINK_H_