// services/network/public/mojom/schemeful_site.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SCHEMEFUL_SITE_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SCHEMEFUL_SITE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/schemeful_site.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared.h"







namespace network::mojom {
class SchemefulSiteDataView;



}  // network::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::SchemefulSiteDataView> {
  using Data = ::network::mojom::internal::SchemefulSite_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


class SchemefulSiteDataView {
 public:
  SchemefulSiteDataView() = default;

  SchemefulSiteDataView(
      internal::SchemefulSite_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSiteAsOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSiteAsOrigin(UserType* output) {
    
    auto* pointer = data_->site_as_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
 private:
  internal::SchemefulSite_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SchemefulSiteDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SchemefulSiteDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SchemefulSite_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::site_as_origin(input)) in_site_as_origin = Traits::site_as_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->site_as_origin)::BaseType> site_as_origin_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_site_as_origin, site_as_origin_fragment);
    fragment->site_as_origin.Set(
        site_as_origin_fragment.is_null() ? nullptr : site_as_origin_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->site_as_origin.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null site_as_origin in SchemefulSite struct");
  }

  static bool Deserialize(::network::mojom::internal::SchemefulSite_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SchemefulSiteDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void SchemefulSiteDataView::GetSiteAsOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->site_as_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SCHEMEFUL_SITE_MOJOM_SHARED_H_