// media/mojo/mojom/stable/stable_video_decoder.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_STABLE_STABLE_VIDEO_DECODER_MOJOM_H_
#define MEDIA_MOJO_MOJOM_STABLE_STABLE_VIDEO_DECODER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/stable/stable_video_decoder.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/stable/stable_video_decoder.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/stable/stable_video_decoder.mojom-forward.h"  // IWYU pragma: export
#include "gpu/ipc/common/gpu_feature_info.mojom.h"
#include "media/mojo/mojom/stable/stable_video_decoder_types.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "sandbox/policy/mojom/sandbox.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "base/token.h"



constexpr ::sandbox::mojom::Sandbox kStableVideoDecoderFactoryServiceSandbox = ::sandbox::mojom::Sandbox::kHardwareVideoDecoding;


namespace media::stable::mojom {

class MediaLogProxy;

template <typename ImplRefTraits>
class MediaLogStub;

class MediaLogRequestValidator;


class MediaLog
    : public MediaLogInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr base::Token Uuid_{ 3336071033435341030ULL,
                                      9656251706715031232ULL };
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MediaLogInterfaceBase;
  using Proxy_ = MediaLogProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaLogStub<ImplRefTraits>;

  using RequestValidator_ = MediaLogRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAddLogRecordMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AddLogRecord_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MediaLog() = default;

  
  virtual void AddLogRecord(const ::media::MediaLogRecord& event) = 0;
};

class VideoFrameHandleReleaserProxy;

template <typename ImplRefTraits>
class VideoFrameHandleReleaserStub;

class VideoFrameHandleReleaserRequestValidator;


class VideoFrameHandleReleaser
    : public VideoFrameHandleReleaserInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr base::Token Uuid_{ 10015388889563744356ULL,
                                      12202351263003803046ULL };
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = VideoFrameHandleReleaserInterfaceBase;
  using Proxy_ = VideoFrameHandleReleaserProxy;

  template <typename ImplRefTraits>
  using Stub_ = VideoFrameHandleReleaserStub<ImplRefTraits>;

  using RequestValidator_ = VideoFrameHandleReleaserRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kReleaseVideoFrameMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ReleaseVideoFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~VideoFrameHandleReleaser() = default;

  
  virtual void ReleaseVideoFrame(const ::base::UnguessableToken& release_token) = 0;
};

class VideoDecoderClientProxy;

template <typename ImplRefTraits>
class VideoDecoderClientStub;

class VideoDecoderClientRequestValidator;


class VideoDecoderClient
    : public VideoDecoderClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr base::Token Uuid_{ 9975418712289460961ULL,
                                      12426632280624305814ULL };
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = VideoDecoderClientInterfaceBase;
  using Proxy_ = VideoDecoderClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = VideoDecoderClientStub<ImplRefTraits>;

  using RequestValidator_ = VideoDecoderClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnVideoFrameDecodedMinVersion = 0,
    kOnWaitingMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnVideoFrameDecoded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnWaiting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~VideoDecoderClient() = default;

  
  virtual void OnVideoFrameDecoded(::media::stable::mojom::VideoFramePtr frame, bool can_read_without_stalling, const ::base::UnguessableToken& release_token) = 0;

  
  virtual void OnWaiting(::media::WaitingReason reason) = 0;
};

class CdmContextEventCallbackProxy;

template <typename ImplRefTraits>
class CdmContextEventCallbackStub;

class CdmContextEventCallbackRequestValidator;


class CdmContextEventCallback
    : public CdmContextEventCallbackInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr base::Token Uuid_{ 11648347265467632034ULL,
                                      11882148964314953246ULL };
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CdmContextEventCallbackInterfaceBase;
  using Proxy_ = CdmContextEventCallbackProxy;

  template <typename ImplRefTraits>
  using Stub_ = CdmContextEventCallbackStub<ImplRefTraits>;

  using RequestValidator_ = CdmContextEventCallbackRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kEventCallbackMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct EventCallback_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CdmContextEventCallback() = default;

  
  virtual void EventCallback(::media::CdmContext::Event event) = 0;
};

class StableCdmContextProxy;

template <typename ImplRefTraits>
class StableCdmContextStub;

class StableCdmContextRequestValidator;
class StableCdmContextResponseValidator;


class StableCdmContext
    : public StableCdmContextInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr base::Token Uuid_{ 3731126798984954291ULL,
                                      10122949601059379008ULL };
  static constexpr uint32_t Version_ = 4;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = StableCdmContextInterfaceBase;
  using Proxy_ = StableCdmContextProxy;

  template <typename ImplRefTraits>
  using Stub_ = StableCdmContextStub<ImplRefTraits>;

  using RequestValidator_ = StableCdmContextRequestValidator;
  using ResponseValidator_ = StableCdmContextResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetHwKeyDataMinVersion = 1,
    kRegisterEventCallbackMinVersion = 1,
    kGetHwConfigDataMinVersion = 1,
    kGetScreenResolutionsMinVersion = 1,
    kAllocateSecureBufferMinVersion = 2,
    kParseEncryptedSliceHeaderMinVersion = 3,
    kDecryptVideoBufferMinVersion = 4,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetHwKeyData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RegisterEventCallback_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetHwConfigData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetScreenResolutions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AllocateSecureBuffer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ParseEncryptedSliceHeader_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DecryptVideoBuffer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~StableCdmContext() = default;


  using GetHwKeyDataCallback = base::OnceCallback<void(::media::Decryptor::Status, const std::vector<uint8_t>&)>;
  
  virtual void GetHwKeyData(::std::unique_ptr<::media::DecryptConfig> decrypt_config, const std::vector<uint8_t>& hw_identifier, GetHwKeyDataCallback callback) = 0;

  
  virtual void RegisterEventCallback(::mojo::PendingRemote<CdmContextEventCallback> callback) = 0;


  using GetHwConfigDataCallback = base::OnceCallback<void(bool, const std::vector<uint8_t>&)>;
  
  virtual void GetHwConfigData(GetHwConfigDataCallback callback) = 0;


  using GetScreenResolutionsCallback = base::OnceCallback<void(const std::vector<::gfx::Size>&)>;
  
  virtual void GetScreenResolutions(GetScreenResolutionsCallback callback) = 0;


  using AllocateSecureBufferCallback = base::OnceCallback<void(::mojo::PlatformHandle)>;
  
  virtual void AllocateSecureBuffer(uint32_t size, AllocateSecureBufferCallback callback) = 0;


  using ParseEncryptedSliceHeaderCallback = base::OnceCallback<void(bool, const std::vector<uint8_t>&)>;
  
  virtual void ParseEncryptedSliceHeader(uint64_t secure_handle, uint32_t offset, const std::vector<uint8_t>& stream_data, ParseEncryptedSliceHeaderCallback callback) = 0;


  using DecryptVideoBufferCallback = base::OnceCallback<void(::media::Decryptor::Status, const ::scoped_refptr<::media::DecoderBuffer>&, const std::vector<uint8_t>&)>;
  
  virtual void DecryptVideoBuffer(const ::scoped_refptr<::media::DecoderBuffer>& buffer, const std::vector<uint8_t>& bytes, DecryptVideoBufferCallback callback) = 0;
};

class StableVideoDecoderProxy;

template <typename ImplRefTraits>
class StableVideoDecoderStub;

class StableVideoDecoderRequestValidator;
class StableVideoDecoderResponseValidator;


class StableVideoDecoder
    : public StableVideoDecoderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr base::Token Uuid_{ 9610985552103293865ULL,
                                      12427015881516082197ULL };
  static constexpr uint32_t Version_ = 1;
  static constexpr bool PassesAssociatedKinds_ = true;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    0
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = StableVideoDecoderInterfaceBase;
  using Proxy_ = StableVideoDecoderProxy;

  template <typename ImplRefTraits>
  using Stub_ = StableVideoDecoderStub<ImplRefTraits>;

  using RequestValidator_ = StableVideoDecoderRequestValidator;
  using ResponseValidator_ = StableVideoDecoderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetSupportedConfigsMinVersion = 0,
    kConstructMinVersion = 0,
    kInitializeMinVersion = 0,
    kDecodeMinVersion = 0,
    kResetMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetSupportedConfigs_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Construct_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Initialize_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Decode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Reset_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~StableVideoDecoder() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetSupportedConfigs(std::vector<::media::SupportedVideoDecoderConfig>* out_supported_configs, ::media::VideoDecoderType* out_decoder_type);

  using GetSupportedConfigsCallback = base::OnceCallback<void(const std::vector<::media::SupportedVideoDecoderConfig>&, ::media::VideoDecoderType)>;
  
  virtual void GetSupportedConfigs(GetSupportedConfigsCallback callback) = 0;

  
  virtual void Construct(::mojo::PendingAssociatedRemote<VideoDecoderClient> client, ::mojo::PendingRemote<MediaLog> media_log, ::mojo::PendingReceiver<VideoFrameHandleReleaser> video_frame_handle_releaser, ::mojo::ScopedDataPipeConsumerHandle decoder_buffer_pipe, const ::gfx::ColorSpace& target_color_space) = 0;


  using InitializeCallback = base::OnceCallback<void(const ::media::DecoderStatus&, bool, int32_t, ::media::VideoDecoderType, bool)>;
  
  virtual void Initialize(const ::media::VideoDecoderConfig& config, bool low_delay, ::mojo::PendingRemote<StableCdmContext> cdm_context, InitializeCallback callback) = 0;


  using DecodeCallback = base::OnceCallback<void(const ::media::DecoderStatus&)>;
  
  virtual void Decode(const ::scoped_refptr<::media::DecoderBuffer>& buffer, DecodeCallback callback) = 0;


  using ResetCallback = base::OnceCallback<void()>;
  
  virtual void Reset(ResetCallback callback) = 0;
};

class StableVideoDecoderTrackerProxy;

template <typename ImplRefTraits>
class StableVideoDecoderTrackerStub;

class StableVideoDecoderTrackerRequestValidator;


class StableVideoDecoderTracker
    : public StableVideoDecoderTrackerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr base::Token Uuid_{ 12835569732457939750ULL,
                                      10125683690457735218ULL };
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = StableVideoDecoderTrackerInterfaceBase;
  using Proxy_ = StableVideoDecoderTrackerProxy;

  template <typename ImplRefTraits>
  using Stub_ = StableVideoDecoderTrackerStub<ImplRefTraits>;

  using RequestValidator_ = StableVideoDecoderTrackerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~StableVideoDecoderTracker() = default;
};

class StableVideoDecoderFactoryProxy;

template <typename ImplRefTraits>
class StableVideoDecoderFactoryStub;

class StableVideoDecoderFactoryRequestValidator;


class StableVideoDecoderFactory
    : public StableVideoDecoderFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr base::Token Uuid_{ 15421591598302711351ULL,
                                      12509654212191067437ULL };
  static constexpr uint32_t Version_ = 1;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = StableVideoDecoderFactoryInterfaceBase;
  using Proxy_ = StableVideoDecoderFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = StableVideoDecoderFactoryStub<ImplRefTraits>;

  using RequestValidator_ = StableVideoDecoderFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateStableVideoDecoderMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateStableVideoDecoder_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~StableVideoDecoderFactory() = default;

  
  virtual void CreateStableVideoDecoder(::mojo::PendingReceiver<StableVideoDecoder> receiver, ::mojo::PendingRemote<StableVideoDecoderTracker> tracker) = 0;
};

class StableVideoDecoderFactoryProcessProxy;

template <typename ImplRefTraits>
class StableVideoDecoderFactoryProcessStub;

class StableVideoDecoderFactoryProcessRequestValidator;


class StableVideoDecoderFactoryProcess
    : public StableVideoDecoderFactoryProcessInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kHardwareVideoDecoding;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = StableVideoDecoderFactoryProcessInterfaceBase;
  using Proxy_ = StableVideoDecoderFactoryProcessProxy;

  template <typename ImplRefTraits>
  using Stub_ = StableVideoDecoderFactoryProcessStub<ImplRefTraits>;

  using RequestValidator_ = StableVideoDecoderFactoryProcessRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kInitializeStableVideoDecoderFactoryMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct InitializeStableVideoDecoderFactory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~StableVideoDecoderFactoryProcess() = default;

  
  virtual void InitializeStableVideoDecoderFactory(const ::gpu::GpuFeatureInfo& gpu_feature_info, ::mojo::PendingReceiver<StableVideoDecoderFactory> receiver) = 0;
};



class  MediaLogProxy
    : public MediaLog {
 public:
  using InterfaceType = MediaLog;

  explicit MediaLogProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AddLogRecord(const ::media::MediaLogRecord& event) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  VideoFrameHandleReleaserProxy
    : public VideoFrameHandleReleaser {
 public:
  using InterfaceType = VideoFrameHandleReleaser;

  explicit VideoFrameHandleReleaserProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ReleaseVideoFrame(const ::base::UnguessableToken& release_token) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  VideoDecoderClientProxy
    : public VideoDecoderClient {
 public:
  using InterfaceType = VideoDecoderClient;

  explicit VideoDecoderClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnVideoFrameDecoded(::media::stable::mojom::VideoFramePtr frame, bool can_read_without_stalling, const ::base::UnguessableToken& release_token) final;
  
  void OnWaiting(::media::WaitingReason reason) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  CdmContextEventCallbackProxy
    : public CdmContextEventCallback {
 public:
  using InterfaceType = CdmContextEventCallback;

  explicit CdmContextEventCallbackProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void EventCallback(::media::CdmContext::Event event) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  StableCdmContextProxy
    : public StableCdmContext {
 public:
  using InterfaceType = StableCdmContext;

  explicit StableCdmContextProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetHwKeyData(::std::unique_ptr<::media::DecryptConfig> decrypt_config, const std::vector<uint8_t>& hw_identifier, GetHwKeyDataCallback callback) final;
  
  void RegisterEventCallback(::mojo::PendingRemote<CdmContextEventCallback> callback) final;
  
  void GetHwConfigData(GetHwConfigDataCallback callback) final;
  
  void GetScreenResolutions(GetScreenResolutionsCallback callback) final;
  
  void AllocateSecureBuffer(uint32_t size, AllocateSecureBufferCallback callback) final;
  
  void ParseEncryptedSliceHeader(uint64_t secure_handle, uint32_t offset, const std::vector<uint8_t>& stream_data, ParseEncryptedSliceHeaderCallback callback) final;
  
  void DecryptVideoBuffer(const ::scoped_refptr<::media::DecoderBuffer>& buffer, const std::vector<uint8_t>& bytes, DecryptVideoBufferCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  StableVideoDecoderProxy
    : public StableVideoDecoder {
 public:
  using InterfaceType = StableVideoDecoder;

  explicit StableVideoDecoderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool GetSupportedConfigs(std::vector<::media::SupportedVideoDecoderConfig>* out_supported_configs, ::media::VideoDecoderType* out_decoder_type) final;
  
  void GetSupportedConfigs(GetSupportedConfigsCallback callback) final;
  
  void Construct(::mojo::PendingAssociatedRemote<VideoDecoderClient> client, ::mojo::PendingRemote<MediaLog> media_log, ::mojo::PendingReceiver<VideoFrameHandleReleaser> video_frame_handle_releaser, ::mojo::ScopedDataPipeConsumerHandle decoder_buffer_pipe, const ::gfx::ColorSpace& target_color_space) final;
  
  void Initialize(const ::media::VideoDecoderConfig& config, bool low_delay, ::mojo::PendingRemote<StableCdmContext> cdm_context, InitializeCallback callback) final;
  
  void Decode(const ::scoped_refptr<::media::DecoderBuffer>& buffer, DecodeCallback callback) final;
  
  void Reset(ResetCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  StableVideoDecoderTrackerProxy
    : public StableVideoDecoderTracker {
 public:
  using InterfaceType = StableVideoDecoderTracker;

  explicit StableVideoDecoderTrackerProxy(mojo::MessageReceiverWithResponder* receiver);

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  StableVideoDecoderFactoryProxy
    : public StableVideoDecoderFactory {
 public:
  using InterfaceType = StableVideoDecoderFactory;

  explicit StableVideoDecoderFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateStableVideoDecoder(::mojo::PendingReceiver<StableVideoDecoder> receiver, ::mojo::PendingRemote<StableVideoDecoderTracker> tracker) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  StableVideoDecoderFactoryProcessProxy
    : public StableVideoDecoderFactoryProcess {
 public:
  using InterfaceType = StableVideoDecoderFactoryProcess;

  explicit StableVideoDecoderFactoryProcessProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void InitializeStableVideoDecoderFactory(const ::gpu::GpuFeatureInfo& gpu_feature_info, ::mojo::PendingReceiver<StableVideoDecoderFactory> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  MediaLogStubDispatch {
 public:
  static bool Accept(MediaLog* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaLog* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaLog>>
class MediaLogStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaLogStub() = default;
  ~MediaLogStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaLogStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaLogStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  VideoFrameHandleReleaserStubDispatch {
 public:
  static bool Accept(VideoFrameHandleReleaser* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VideoFrameHandleReleaser* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VideoFrameHandleReleaser>>
class VideoFrameHandleReleaserStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VideoFrameHandleReleaserStub() = default;
  ~VideoFrameHandleReleaserStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoFrameHandleReleaserStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoFrameHandleReleaserStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  VideoDecoderClientStubDispatch {
 public:
  static bool Accept(VideoDecoderClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VideoDecoderClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VideoDecoderClient>>
class VideoDecoderClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VideoDecoderClientStub() = default;
  ~VideoDecoderClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoDecoderClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoDecoderClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CdmContextEventCallbackStubDispatch {
 public:
  static bool Accept(CdmContextEventCallback* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CdmContextEventCallback* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CdmContextEventCallback>>
class CdmContextEventCallbackStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CdmContextEventCallbackStub() = default;
  ~CdmContextEventCallbackStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CdmContextEventCallbackStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CdmContextEventCallbackStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  StableCdmContextStubDispatch {
 public:
  static bool Accept(StableCdmContext* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      StableCdmContext* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<StableCdmContext>>
class StableCdmContextStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  StableCdmContextStub() = default;
  ~StableCdmContextStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return StableCdmContextStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return StableCdmContextStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  StableVideoDecoderStubDispatch {
 public:
  static bool Accept(StableVideoDecoder* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      StableVideoDecoder* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<StableVideoDecoder>>
class StableVideoDecoderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  StableVideoDecoderStub() = default;
  ~StableVideoDecoderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return StableVideoDecoderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return StableVideoDecoderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  StableVideoDecoderTrackerStubDispatch {
 public:
  static bool Accept(StableVideoDecoderTracker* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      StableVideoDecoderTracker* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<StableVideoDecoderTracker>>
class StableVideoDecoderTrackerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  StableVideoDecoderTrackerStub() = default;
  ~StableVideoDecoderTrackerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return StableVideoDecoderTrackerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return StableVideoDecoderTrackerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  StableVideoDecoderFactoryStubDispatch {
 public:
  static bool Accept(StableVideoDecoderFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      StableVideoDecoderFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<StableVideoDecoderFactory>>
class StableVideoDecoderFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  StableVideoDecoderFactoryStub() = default;
  ~StableVideoDecoderFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return StableVideoDecoderFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return StableVideoDecoderFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  StableVideoDecoderFactoryProcessStubDispatch {
 public:
  static bool Accept(StableVideoDecoderFactoryProcess* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      StableVideoDecoderFactoryProcess* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<StableVideoDecoderFactoryProcess>>
class StableVideoDecoderFactoryProcessStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  StableVideoDecoderFactoryProcessStub() = default;
  ~StableVideoDecoderFactoryProcessStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return StableVideoDecoderFactoryProcessStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return StableVideoDecoderFactoryProcessStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MediaLogRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  VideoFrameHandleReleaserRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  VideoDecoderClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CdmContextEventCallbackRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  StableCdmContextRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  StableVideoDecoderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  StableVideoDecoderTrackerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  StableVideoDecoderFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  StableVideoDecoderFactoryProcessRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  StableCdmContextResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  StableVideoDecoderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // media::stable::mojom

namespace mojo {

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_STABLE_STABLE_VIDEO_DECODER_MOJOM_H_