// media/mojo/mojom/audio_output_stream.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "media/mojo/mojom/audio_output_stream.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/audio_output_stream.mojom-params-data.h"
namespace media {
namespace mojom {

NOINLINE static const char* AudioOutputStreamObserver_DisconnectReasonToStringHelper(AudioOutputStreamObserver_DisconnectReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AudioOutputStreamObserver_DisconnectReason::kDefault:
      return "kDefault";
    case AudioOutputStreamObserver_DisconnectReason::kPlatformError:
      return "kPlatformError";
    case AudioOutputStreamObserver_DisconnectReason::kTerminatedByClient:
      return "kTerminatedByClient";
    case AudioOutputStreamObserver_DisconnectReason::kStreamCreationFailed:
      return "kStreamCreationFailed";
    case AudioOutputStreamObserver_DisconnectReason::kDocumentDestroyed:
      return "kDocumentDestroyed";
    default:
      return nullptr;
  }
}

std::string AudioOutputStreamObserver_DisconnectReasonToString(AudioOutputStreamObserver_DisconnectReason value) {
  const char *str = AudioOutputStreamObserver_DisconnectReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AudioOutputStreamObserver_DisconnectReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AudioOutputStreamObserver_DisconnectReason value) {
  return os << AudioOutputStreamObserver_DisconnectReasonToString(value);
}

namespace internal {


// static
bool AudioOutputStream_Play_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioOutputStream_Play_Params_Data* object =
      static_cast<const AudioOutputStream_Play_Params_Data*>(data);

  return true;
}

AudioOutputStream_Play_Params_Data::AudioOutputStream_Play_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioOutputStream_Pause_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioOutputStream_Pause_Params_Data* object =
      static_cast<const AudioOutputStream_Pause_Params_Data*>(data);

  return true;
}

AudioOutputStream_Pause_Params_Data::AudioOutputStream_Pause_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioOutputStream_Flush_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioOutputStream_Flush_Params_Data* object =
      static_cast<const AudioOutputStream_Flush_Params_Data*>(data);

  return true;
}

AudioOutputStream_Flush_Params_Data::AudioOutputStream_Flush_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioOutputStream_SetVolume_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioOutputStream_SetVolume_Params_Data* object =
      static_cast<const AudioOutputStream_SetVolume_Params_Data*>(data);

  return true;
}

AudioOutputStream_SetVolume_Params_Data::AudioOutputStream_SetVolume_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioOutputStreamObserver_DidStartPlaying_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioOutputStreamObserver_DidStartPlaying_Params_Data* object =
      static_cast<const AudioOutputStreamObserver_DidStartPlaying_Params_Data*>(data);

  return true;
}

AudioOutputStreamObserver_DidStartPlaying_Params_Data::AudioOutputStreamObserver_DidStartPlaying_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioOutputStreamObserver_DidStopPlaying_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioOutputStreamObserver_DidStopPlaying_Params_Data* object =
      static_cast<const AudioOutputStreamObserver_DidStopPlaying_Params_Data*>(data);

  return true;
}

AudioOutputStreamObserver_DidStopPlaying_Params_Data::AudioOutputStreamObserver_DidStopPlaying_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioOutputStreamObserver_DidChangeAudibleState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioOutputStreamObserver_DidChangeAudibleState_Params_Data* object =
      static_cast<const AudioOutputStreamObserver_DidChangeAudibleState_Params_Data*>(data);

  return true;
}

AudioOutputStreamObserver_DidChangeAudibleState_Params_Data::AudioOutputStreamObserver_DidChangeAudibleState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioOutputStreamProvider_Acquire_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioOutputStreamProvider_Acquire_Params_Data* object =
      static_cast<const AudioOutputStreamProvider_Acquire_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

AudioOutputStreamProvider_Acquire_Params_Data::AudioOutputStreamProvider_Acquire_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AudioOutputStreamProviderClient_Created_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AudioOutputStreamProviderClient_Created_Params_Data* object =
      static_cast<const AudioOutputStreamProviderClient_Created_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->stream, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->stream,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data_pipe, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data_pipe, validation_context))
    return false;

  return true;
}

AudioOutputStreamProviderClient_Created_Params_Data::AudioOutputStreamProviderClient_Created_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceSwitchInterface_SwitchAudioOutputDeviceId_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceSwitchInterface_SwitchAudioOutputDeviceId_Params_Data* object =
      static_cast<const DeviceSwitchInterface_SwitchAudioOutputDeviceId_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->output_device_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& output_device_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->output_device_id, validation_context,
                                         &output_device_id_validate_params)) {
    return false;
  }

  return true;
}

DeviceSwitchInterface_SwitchAudioOutputDeviceId_Params_Data::DeviceSwitchInterface_SwitchAudioOutputDeviceId_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media

namespace perfetto {

// static
void TraceFormatTraits<::media::mojom::AudioOutputStreamObserver_DisconnectReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::media::mojom::AudioOutputStreamObserver_DisconnectReason value) {
  return std::move(context).WriteString(::media::mojom::AudioOutputStreamObserver_DisconnectReasonToString(value));
}

} // namespace perfetto