// media/learning/mojo/public/mojom/learning_task_controller.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/learning/mojo/public/mojom/learning_task_controller.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/learning/mojo/public/mojom/learning_task_controller.mojom-params-data.h"
#include "media/learning/mojo/public/mojom/learning_task_controller.mojom-shared-message-ids.h"

#include "media/learning/mojo/public/mojom/learning_task_controller.mojom-import-headers.h"
#include "media/learning/mojo/public/mojom/learning_task_controller.mojom-test-utils.h"


namespace media::learning::mojom {
const char LearningTaskController::Name_[] = "media.learning.mojom.LearningTaskController";

LearningTaskController::IPCStableHashFunction LearningTaskController::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::LearningTaskController>(message.name())) {
    case messages::LearningTaskController::kBeginObservation: {
      return &LearningTaskController::BeginObservation_Sym::IPCStableHash;
    }
    case messages::LearningTaskController::kCompleteObservation: {
      return &LearningTaskController::CompleteObservation_Sym::IPCStableHash;
    }
    case messages::LearningTaskController::kCancelObservation: {
      return &LearningTaskController::CancelObservation_Sym::IPCStableHash;
    }
    case messages::LearningTaskController::kUpdateDefaultTarget: {
      return &LearningTaskController::UpdateDefaultTarget_Sym::IPCStableHash;
    }
    case messages::LearningTaskController::kPredictDistribution: {
      return &LearningTaskController::PredictDistribution_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* LearningTaskController::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::LearningTaskController>(message.name())) {
      case messages::LearningTaskController::kBeginObservation:
            return "Receive media::learning::mojom::LearningTaskController::BeginObservation";
      case messages::LearningTaskController::kCompleteObservation:
            return "Receive media::learning::mojom::LearningTaskController::CompleteObservation";
      case messages::LearningTaskController::kCancelObservation:
            return "Receive media::learning::mojom::LearningTaskController::CancelObservation";
      case messages::LearningTaskController::kUpdateDefaultTarget:
            return "Receive media::learning::mojom::LearningTaskController::UpdateDefaultTarget";
      case messages::LearningTaskController::kPredictDistribution:
            return "Receive media::learning::mojom::LearningTaskController::PredictDistribution";
    }
  } else {
    switch (static_cast<messages::LearningTaskController>(message.name())) {
      case messages::LearningTaskController::kBeginObservation:
            return "Receive reply media::learning::mojom::LearningTaskController::BeginObservation";
      case messages::LearningTaskController::kCompleteObservation:
            return "Receive reply media::learning::mojom::LearningTaskController::CompleteObservation";
      case messages::LearningTaskController::kCancelObservation:
            return "Receive reply media::learning::mojom::LearningTaskController::CancelObservation";
      case messages::LearningTaskController::kUpdateDefaultTarget:
            return "Receive reply media::learning::mojom::LearningTaskController::UpdateDefaultTarget";
      case messages::LearningTaskController::kPredictDistribution:
            return "Receive reply media::learning::mojom::LearningTaskController::PredictDistribution";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t LearningTaskController::BeginObservation_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::learning::mojom::LearningTaskController::BeginObservation");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LearningTaskController::CompleteObservation_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::learning::mojom::LearningTaskController::CompleteObservation");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LearningTaskController::CancelObservation_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::learning::mojom::LearningTaskController::CancelObservation");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LearningTaskController::UpdateDefaultTarget_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::learning::mojom::LearningTaskController::UpdateDefaultTarget");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t LearningTaskController::PredictDistribution_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)media::learning::mojom::LearningTaskController::PredictDistribution");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class LearningTaskController_PredictDistribution_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LearningTaskController_PredictDistribution_ForwardToCallback(
      LearningTaskController::PredictDistributionCallback callback
      ) : callback_(std::move(callback)) {
  }

  LearningTaskController_PredictDistribution_ForwardToCallback(const LearningTaskController_PredictDistribution_ForwardToCallback&) = delete;
  LearningTaskController_PredictDistribution_ForwardToCallback& operator=(const LearningTaskController_PredictDistribution_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LearningTaskController::PredictDistributionCallback callback_;
};

LearningTaskControllerProxy::LearningTaskControllerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LearningTaskControllerProxy::BeginObservation(
    const ::base::UnguessableToken& in_id, const std::vector<::media::learning::FeatureValue>& in_features, const std::optional<::media::learning::TargetValue>& in_default_target) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::learning::mojom::LearningTaskController::BeginObservation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("features"), in_features,
                        "<value of type const std::vector<::media::learning::FeatureValue>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("default_target"), in_default_target,
                        "<value of type const std::optional<::media::learning::TargetValue>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LearningTaskController::kBeginObservation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::learning::mojom::internal::LearningTaskController_BeginObservation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_id, id_fragment);
  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in LearningTaskController.BeginObservation request");
  mojo::internal::MessageFragment<
      typename decltype(params->features)::BaseType>
      features_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& features_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::media::learning::mojom::FeatureValueDataView>>(
      in_features, features_fragment, &features_validate_params);
  params->features.Set(
      features_fragment.is_null() ? nullptr : features_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->features.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null features in LearningTaskController.BeginObservation request");
  mojo::internal::MessageFragment<
      typename decltype(params->default_target)::BaseType> default_target_fragment(
          params.message());
  mojo::internal::Serialize<::media::learning::mojom::TargetValueDataView>(
      in_default_target, default_target_fragment);
  params->default_target.Set(
      default_target_fragment.is_null() ? nullptr : default_target_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LearningTaskController::Name_);
  message.set_method_name("BeginObservation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LearningTaskControllerProxy::CompleteObservation(
    const ::base::UnguessableToken& in_id, const ::media::learning::ObservationCompletion& in_completion) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::learning::mojom::LearningTaskController::CompleteObservation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("completion"), in_completion,
                        "<value of type const ::media::learning::ObservationCompletion&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LearningTaskController::kCompleteObservation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::learning::mojom::internal::LearningTaskController_CompleteObservation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_id, id_fragment);
  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in LearningTaskController.CompleteObservation request");
  mojo::internal::MessageFragment<
      typename decltype(params->completion)::BaseType> completion_fragment(
          params.message());
  mojo::internal::Serialize<::media::learning::mojom::ObservationCompletionDataView>(
      in_completion, completion_fragment);
  params->completion.Set(
      completion_fragment.is_null() ? nullptr : completion_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->completion.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null completion in LearningTaskController.CompleteObservation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LearningTaskController::Name_);
  message.set_method_name("CompleteObservation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LearningTaskControllerProxy::CancelObservation(
    const ::base::UnguessableToken& in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::learning::mojom::LearningTaskController::CancelObservation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LearningTaskController::kCancelObservation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::learning::mojom::internal::LearningTaskController_CancelObservation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_id, id_fragment);
  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in LearningTaskController.CancelObservation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LearningTaskController::Name_);
  message.set_method_name("CancelObservation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LearningTaskControllerProxy::UpdateDefaultTarget(
    const ::base::UnguessableToken& in_id, const std::optional<::media::learning::TargetValue>& in_default_target) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::learning::mojom::LearningTaskController::UpdateDefaultTarget", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("default_target"), in_default_target,
                        "<value of type const std::optional<::media::learning::TargetValue>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LearningTaskController::kUpdateDefaultTarget), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::learning::mojom::internal::LearningTaskController_UpdateDefaultTarget_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_id, id_fragment);
  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in LearningTaskController.UpdateDefaultTarget request");
  mojo::internal::MessageFragment<
      typename decltype(params->default_target)::BaseType> default_target_fragment(
          params.message());
  mojo::internal::Serialize<::media::learning::mojom::TargetValueDataView>(
      in_default_target, default_target_fragment);
  params->default_target.Set(
      default_target_fragment.is_null() ? nullptr : default_target_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LearningTaskController::Name_);
  message.set_method_name("UpdateDefaultTarget");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void LearningTaskControllerProxy::PredictDistribution(
    const std::vector<::media::learning::FeatureValue>& in_features, PredictDistributionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media::learning::mojom::LearningTaskController::PredictDistribution", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("features"), in_features,
                        "<value of type const std::vector<::media::learning::FeatureValue>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LearningTaskController::kPredictDistribution), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::learning::mojom::internal::LearningTaskController_PredictDistribution_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->features)::BaseType>
      features_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& features_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::media::learning::mojom::FeatureValueDataView>>(
      in_features, features_fragment, &features_validate_params);
  params->features.Set(
      features_fragment.is_null() ? nullptr : features_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->features.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null features in LearningTaskController.PredictDistribution request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LearningTaskController::Name_);
  message.set_method_name("PredictDistribution");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LearningTaskController_PredictDistribution_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class LearningTaskController_PredictDistribution_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LearningTaskController::PredictDistributionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LearningTaskController_PredictDistribution_ProxyToResponder> proxy(
        new LearningTaskController_PredictDistribution_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LearningTaskController_PredictDistribution_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LearningTaskController_PredictDistribution_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LearningTaskController_PredictDistribution_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "LearningTaskController::PredictDistributionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<::media::learning::TargetHistogram>& in_predicted);
};

bool LearningTaskController_PredictDistribution_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LearningTaskController_PredictDistribution_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LearningTaskController_PredictDistribution_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for LearningTaskController.4
  bool success = true;
  std::optional<::media::learning::TargetHistogram> p_predicted{};
  LearningTaskController_PredictDistribution_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPredicted(&p_predicted))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LearningTaskController::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_predicted));
  return true;
}

void LearningTaskController_PredictDistribution_ProxyToResponder::Run(
    const std::optional<::media::learning::TargetHistogram>& in_predicted) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply media::learning::mojom::LearningTaskController::PredictDistribution", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("predicted"), in_predicted,
                        "<value of type const std::optional<::media::learning::TargetHistogram>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LearningTaskController::kPredictDistribution), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media::learning::mojom::internal::LearningTaskController_PredictDistribution_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->predicted)::BaseType> predicted_fragment(
          params.message());
  mojo::internal::Serialize<::media::learning::mojom::TargetHistogramDataView>(
      in_predicted, predicted_fragment);
  params->predicted.Set(
      predicted_fragment.is_null() ? nullptr : predicted_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LearningTaskController::Name_);
  message.set_method_name("PredictDistribution");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool LearningTaskControllerStubDispatch::Accept(
    LearningTaskController* impl,
    mojo::Message* message) {
  switch (static_cast<messages::LearningTaskController>(message->header()->name)) {
    case messages::LearningTaskController::kBeginObservation: {
      DCHECK(message->is_serialized());
      internal::LearningTaskController_BeginObservation_Params_Data* params =
          reinterpret_cast<internal::LearningTaskController_BeginObservation_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for LearningTaskController.0
      bool success = true;
      ::base::UnguessableToken p_id{};
      std::vector<::media::learning::FeatureValue> p_features{};
      std::optional<::media::learning::TargetValue> p_default_target{};
      LearningTaskController_BeginObservation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (success && !input_data_view.ReadFeatures(&p_features))
        success = false;
      if (success && !input_data_view.ReadDefaultTarget(&p_default_target))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LearningTaskController::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BeginObservation(        
        std::move(p_id), 
        std::move(p_features), 
        std::move(p_default_target));
      return true;
    }
    case messages::LearningTaskController::kCompleteObservation: {
      DCHECK(message->is_serialized());
      internal::LearningTaskController_CompleteObservation_Params_Data* params =
          reinterpret_cast<internal::LearningTaskController_CompleteObservation_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for LearningTaskController.1
      bool success = true;
      ::base::UnguessableToken p_id{};
      ::media::learning::ObservationCompletion p_completion{};
      LearningTaskController_CompleteObservation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (success && !input_data_view.ReadCompletion(&p_completion))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LearningTaskController::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CompleteObservation(        
        std::move(p_id), 
        std::move(p_completion));
      return true;
    }
    case messages::LearningTaskController::kCancelObservation: {
      DCHECK(message->is_serialized());
      internal::LearningTaskController_CancelObservation_Params_Data* params =
          reinterpret_cast<internal::LearningTaskController_CancelObservation_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for LearningTaskController.2
      bool success = true;
      ::base::UnguessableToken p_id{};
      LearningTaskController_CancelObservation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LearningTaskController::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelObservation(        
        std::move(p_id));
      return true;
    }
    case messages::LearningTaskController::kUpdateDefaultTarget: {
      DCHECK(message->is_serialized());
      internal::LearningTaskController_UpdateDefaultTarget_Params_Data* params =
          reinterpret_cast<internal::LearningTaskController_UpdateDefaultTarget_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for LearningTaskController.3
      bool success = true;
      ::base::UnguessableToken p_id{};
      std::optional<::media::learning::TargetValue> p_default_target{};
      LearningTaskController_UpdateDefaultTarget_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (success && !input_data_view.ReadDefaultTarget(&p_default_target))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LearningTaskController::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateDefaultTarget(        
        std::move(p_id), 
        std::move(p_default_target));
      return true;
    }
    case messages::LearningTaskController::kPredictDistribution: {
      break;
    }
  }
  return false;
}

// static
bool LearningTaskControllerStubDispatch::AcceptWithResponder(
    LearningTaskController* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::LearningTaskController>(message->header()->name)) {
    case messages::LearningTaskController::kBeginObservation: {
      break;
    }
    case messages::LearningTaskController::kCompleteObservation: {
      break;
    }
    case messages::LearningTaskController::kCancelObservation: {
      break;
    }
    case messages::LearningTaskController::kUpdateDefaultTarget: {
      break;
    }
    case messages::LearningTaskController::kPredictDistribution: {
      internal::LearningTaskController_PredictDistribution_Params_Data* params =
          reinterpret_cast<
              internal::LearningTaskController_PredictDistribution_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for LearningTaskController.4
      bool success = true;
      std::vector<::media::learning::FeatureValue> p_features{};
      LearningTaskController_PredictDistribution_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFeatures(&p_features))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LearningTaskController::Name_, 4, false);
        return false;
      }
      LearningTaskController::PredictDistributionCallback callback =
          LearningTaskController_PredictDistribution_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PredictDistribution(        
        std::move(p_features), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kLearningTaskControllerValidationInfo[] = {
    {base::to_underlying(messages::LearningTaskController::kBeginObservation),
     { &internal::LearningTaskController_BeginObservation_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::LearningTaskController::kCompleteObservation),
     { &internal::LearningTaskController_CompleteObservation_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::LearningTaskController::kCancelObservation),
     { &internal::LearningTaskController_CancelObservation_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::LearningTaskController::kUpdateDefaultTarget),
     { &internal::LearningTaskController_UpdateDefaultTarget_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::LearningTaskController::kPredictDistribution),
     { &internal::LearningTaskController_PredictDistribution_Params_Data::Validate,
      &internal::LearningTaskController_PredictDistribution_ResponseParams_Data::Validate}},
};

bool LearningTaskControllerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::learning::mojom::LearningTaskController::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kLearningTaskControllerValidationInfo);
}

bool LearningTaskControllerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media::learning::mojom::LearningTaskController::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kLearningTaskControllerValidationInfo);

}


}  // media::learning::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::learning::mojom {


void LearningTaskControllerInterceptorForTesting::BeginObservation(const ::base::UnguessableToken& id, const std::vector<::media::learning::FeatureValue>& features, const std::optional<::media::learning::TargetValue>& default_target) {
  GetForwardingInterface()->BeginObservation(
    std::move(id)
    , 
    std::move(features)
    , 
    std::move(default_target)
    );
}
void LearningTaskControllerInterceptorForTesting::CompleteObservation(const ::base::UnguessableToken& id, const ::media::learning::ObservationCompletion& completion) {
  GetForwardingInterface()->CompleteObservation(
    std::move(id)
    , 
    std::move(completion)
    );
}
void LearningTaskControllerInterceptorForTesting::CancelObservation(const ::base::UnguessableToken& id) {
  GetForwardingInterface()->CancelObservation(
    std::move(id)
    );
}
void LearningTaskControllerInterceptorForTesting::UpdateDefaultTarget(const ::base::UnguessableToken& id, const std::optional<::media::learning::TargetValue>& default_target) {
  GetForwardingInterface()->UpdateDefaultTarget(
    std::move(id)
    , 
    std::move(default_target)
    );
}
void LearningTaskControllerInterceptorForTesting::PredictDistribution(const std::vector<::media::learning::FeatureValue>& features, PredictDistributionCallback callback) {
  GetForwardingInterface()->PredictDistribution(
    std::move(features)
    , std::move(callback));
}
LearningTaskControllerAsyncWaiter::LearningTaskControllerAsyncWaiter(
    LearningTaskController* proxy) : proxy_(proxy) {}

LearningTaskControllerAsyncWaiter::~LearningTaskControllerAsyncWaiter() = default;

void LearningTaskControllerAsyncWaiter::PredictDistribution(
    const std::vector<::media::learning::FeatureValue>& features, std::optional<::media::learning::TargetHistogram>* out_predicted) {
  base::RunLoop loop;
  proxy_->PredictDistribution(
      std::move(features),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::media::learning::TargetHistogram>* out_predicted
,
             const std::optional<::media::learning::TargetHistogram>& predicted) {*out_predicted = std::move(predicted);
            loop->Quit();
          },
          &loop,
          out_predicted));
  loop.Run();
}

std::optional<::media::learning::TargetHistogram> LearningTaskControllerAsyncWaiter::PredictDistribution(
    const std::vector<::media::learning::FeatureValue>& features) {
  std::optional<::media::learning::TargetHistogram> async_wait_result;
  PredictDistribution(std::move(features),&async_wait_result);
  return async_wait_result;
}






}  // media::learning::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif