// gpu/ipc/common/client_gmb_interface.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "gpu/ipc/common/client_gmb_interface.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "gpu/ipc/common/client_gmb_interface.mojom-params-data.h"
#include "gpu/ipc/common/client_gmb_interface.mojom-shared-message-ids.h"

#include "gpu/ipc/common/client_gmb_interface.mojom-import-headers.h"
#include "gpu/ipc/common/client_gmb_interface.mojom-test-utils.h"


namespace gpu::mojom {
const char ClientGmbInterface::Name_[] = "gpu.mojom.ClientGmbInterface";

ClientGmbInterface::IPCStableHashFunction ClientGmbInterface::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ClientGmbInterface>(message.name())) {
    case messages::ClientGmbInterface::kCreateGpuMemoryBuffer: {
      return &ClientGmbInterface::CreateGpuMemoryBuffer_Sym::IPCStableHash;
    }
    case messages::ClientGmbInterface::kDestroyGpuMemoryBuffer: {
      return &ClientGmbInterface::DestroyGpuMemoryBuffer_Sym::IPCStableHash;
    }
    case messages::ClientGmbInterface::kCopyGpuMemoryBuffer: {
      return &ClientGmbInterface::CopyGpuMemoryBuffer_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ClientGmbInterface::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ClientGmbInterface>(message.name())) {
      case messages::ClientGmbInterface::kCreateGpuMemoryBuffer:
            return "Receive gpu::mojom::ClientGmbInterface::CreateGpuMemoryBuffer";
      case messages::ClientGmbInterface::kDestroyGpuMemoryBuffer:
            return "Receive gpu::mojom::ClientGmbInterface::DestroyGpuMemoryBuffer";
      case messages::ClientGmbInterface::kCopyGpuMemoryBuffer:
            return "Receive gpu::mojom::ClientGmbInterface::CopyGpuMemoryBuffer";
    }
  } else {
    switch (static_cast<messages::ClientGmbInterface>(message.name())) {
      case messages::ClientGmbInterface::kCreateGpuMemoryBuffer:
            return "Receive reply gpu::mojom::ClientGmbInterface::CreateGpuMemoryBuffer";
      case messages::ClientGmbInterface::kDestroyGpuMemoryBuffer:
            return "Receive reply gpu::mojom::ClientGmbInterface::DestroyGpuMemoryBuffer";
      case messages::ClientGmbInterface::kCopyGpuMemoryBuffer:
            return "Receive reply gpu::mojom::ClientGmbInterface::CopyGpuMemoryBuffer";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ClientGmbInterface::CreateGpuMemoryBuffer_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)gpu::mojom::ClientGmbInterface::CreateGpuMemoryBuffer");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ClientGmbInterface::DestroyGpuMemoryBuffer_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)gpu::mojom::ClientGmbInterface::DestroyGpuMemoryBuffer");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ClientGmbInterface::CopyGpuMemoryBuffer_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)gpu::mojom::ClientGmbInterface::CopyGpuMemoryBuffer");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ClientGmbInterface_CreateGpuMemoryBuffer_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ClientGmbInterface_CreateGpuMemoryBuffer_ForwardToCallback(
      ClientGmbInterface::CreateGpuMemoryBufferCallback callback
      ) : callback_(std::move(callback)) {
  }

  ClientGmbInterface_CreateGpuMemoryBuffer_ForwardToCallback(const ClientGmbInterface_CreateGpuMemoryBuffer_ForwardToCallback&) = delete;
  ClientGmbInterface_CreateGpuMemoryBuffer_ForwardToCallback& operator=(const ClientGmbInterface_CreateGpuMemoryBuffer_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ClientGmbInterface::CreateGpuMemoryBufferCallback callback_;
};

class ClientGmbInterface_CopyGpuMemoryBuffer_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ClientGmbInterface_CopyGpuMemoryBuffer_ForwardToCallback(
      ClientGmbInterface::CopyGpuMemoryBufferCallback callback
      ) : callback_(std::move(callback)) {
  }

  ClientGmbInterface_CopyGpuMemoryBuffer_ForwardToCallback(const ClientGmbInterface_CopyGpuMemoryBuffer_ForwardToCallback&) = delete;
  ClientGmbInterface_CopyGpuMemoryBuffer_ForwardToCallback& operator=(const ClientGmbInterface_CopyGpuMemoryBuffer_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ClientGmbInterface::CopyGpuMemoryBufferCallback callback_;
};

ClientGmbInterfaceProxy::ClientGmbInterfaceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ClientGmbInterfaceProxy::CreateGpuMemoryBuffer(
    ::gfx::GpuMemoryBufferId in_id, const ::gfx::Size& in_size, ::gfx::BufferFormat in_format, ::gfx::BufferUsage in_usage, ::gpu::SurfaceHandle in_surface_handle, CreateGpuMemoryBufferCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send gpu::mojom::ClientGmbInterface::CreateGpuMemoryBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type ::gfx::GpuMemoryBufferId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("size"), in_size,
                        "<value of type const ::gfx::Size&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("format"), in_format,
                        "<value of type ::gfx::BufferFormat>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("usage"), in_usage,
                        "<value of type ::gfx::BufferUsage>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("surface_handle"), in_surface_handle,
                        "<value of type ::gpu::SurfaceHandle>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClientGmbInterface::kCreateGpuMemoryBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::ClientGmbInterface_CreateGpuMemoryBuffer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferIdDataView>(
      in_id, id_fragment);
  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in ClientGmbInterface.CreateGpuMemoryBuffer request");
  mojo::internal::MessageFragment<
      typename decltype(params->size)::BaseType> size_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
      in_size, size_fragment);
  params->size.Set(
      size_fragment.is_null() ? nullptr : size_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->size.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null size in ClientGmbInterface.CreateGpuMemoryBuffer request");
  mojo::internal::Serialize<::gfx::mojom::BufferFormat>(
      in_format, &params->format);
  mojo::internal::Serialize<::gfx::mojom::BufferUsage>(
      in_usage, &params->usage);
  mojo::internal::MessageFragment<
      typename decltype(params->surface_handle)::BaseType> surface_handle_fragment(
          params.message());
  mojo::internal::Serialize<::gpu::mojom::SurfaceHandleDataView>(
      in_surface_handle, surface_handle_fragment);
  params->surface_handle.Set(
      surface_handle_fragment.is_null() ? nullptr : surface_handle_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->surface_handle.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null surface_handle in ClientGmbInterface.CreateGpuMemoryBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClientGmbInterface::Name_);
  message.set_method_name("CreateGpuMemoryBuffer");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClientGmbInterface_CreateGpuMemoryBuffer_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ClientGmbInterfaceProxy::DestroyGpuMemoryBuffer(
    ::gfx::GpuMemoryBufferId in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send gpu::mojom::ClientGmbInterface::DestroyGpuMemoryBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type ::gfx::GpuMemoryBufferId>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClientGmbInterface::kDestroyGpuMemoryBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::ClientGmbInterface_DestroyGpuMemoryBuffer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferIdDataView>(
      in_id, id_fragment);
  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in ClientGmbInterface.DestroyGpuMemoryBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClientGmbInterface::Name_);
  message.set_method_name("DestroyGpuMemoryBuffer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ClientGmbInterfaceProxy::CopyGpuMemoryBuffer(
    ::gfx::GpuMemoryBufferHandle in_buffer_handle, ::base::UnsafeSharedMemoryRegion in_shared_memory, CopyGpuMemoryBufferCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send gpu::mojom::ClientGmbInterface::CopyGpuMemoryBuffer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_handle"), in_buffer_handle,
                        "<value of type ::gfx::GpuMemoryBufferHandle>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("shared_memory"), in_shared_memory,
                        "<value of type ::base::UnsafeSharedMemoryRegion>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClientGmbInterface::kCopyGpuMemoryBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::ClientGmbInterface_CopyGpuMemoryBuffer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->buffer_handle)::BaseType> buffer_handle_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferHandleDataView>(
      in_buffer_handle, buffer_handle_fragment);
  params->buffer_handle.Set(
      buffer_handle_fragment.is_null() ? nullptr : buffer_handle_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->buffer_handle.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null buffer_handle in ClientGmbInterface.CopyGpuMemoryBuffer request");
  mojo::internal::MessageFragment<
      typename decltype(params->shared_memory)::BaseType> shared_memory_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
      in_shared_memory, shared_memory_fragment);
  params->shared_memory.Set(
      shared_memory_fragment.is_null() ? nullptr : shared_memory_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->shared_memory.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null shared_memory in ClientGmbInterface.CopyGpuMemoryBuffer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClientGmbInterface::Name_);
  message.set_method_name("CopyGpuMemoryBuffer");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ClientGmbInterface_CopyGpuMemoryBuffer_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ClientGmbInterface_CreateGpuMemoryBuffer_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ClientGmbInterface::CreateGpuMemoryBufferCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ClientGmbInterface_CreateGpuMemoryBuffer_ProxyToResponder> proxy(
        new ClientGmbInterface_CreateGpuMemoryBuffer_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ClientGmbInterface_CreateGpuMemoryBuffer_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ClientGmbInterface_CreateGpuMemoryBuffer_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ClientGmbInterface_CreateGpuMemoryBuffer_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ClientGmbInterface::CreateGpuMemoryBufferCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::gfx::GpuMemoryBufferHandle in_buffer_handle);
};

bool ClientGmbInterface_CreateGpuMemoryBuffer_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ClientGmbInterface_CreateGpuMemoryBuffer_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ClientGmbInterface_CreateGpuMemoryBuffer_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for ClientGmbInterface.0
  bool success = true;
  ::gfx::GpuMemoryBufferHandle p_buffer_handle{};
  ClientGmbInterface_CreateGpuMemoryBuffer_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadBufferHandle(&p_buffer_handle))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClientGmbInterface::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_buffer_handle));
  return true;
}

void ClientGmbInterface_CreateGpuMemoryBuffer_ProxyToResponder::Run(
    ::gfx::GpuMemoryBufferHandle in_buffer_handle) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply gpu::mojom::ClientGmbInterface::CreateGpuMemoryBuffer", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer_handle"), in_buffer_handle,
                        "<value of type ::gfx::GpuMemoryBufferHandle>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClientGmbInterface::kCreateGpuMemoryBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::ClientGmbInterface_CreateGpuMemoryBuffer_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->buffer_handle)::BaseType> buffer_handle_fragment(
          params.message());
  mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferHandleDataView>(
      in_buffer_handle, buffer_handle_fragment);
  params->buffer_handle.Set(
      buffer_handle_fragment.is_null() ? nullptr : buffer_handle_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->buffer_handle.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null buffer_handle in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClientGmbInterface::Name_);
  message.set_method_name("CreateGpuMemoryBuffer");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ClientGmbInterface_CopyGpuMemoryBuffer_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ClientGmbInterface::CopyGpuMemoryBufferCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ClientGmbInterface_CopyGpuMemoryBuffer_ProxyToResponder> proxy(
        new ClientGmbInterface_CopyGpuMemoryBuffer_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ClientGmbInterface_CopyGpuMemoryBuffer_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ClientGmbInterface_CopyGpuMemoryBuffer_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ClientGmbInterface_CopyGpuMemoryBuffer_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ClientGmbInterface::CopyGpuMemoryBufferCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool ClientGmbInterface_CopyGpuMemoryBuffer_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ClientGmbInterface_CopyGpuMemoryBuffer_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ClientGmbInterface_CopyGpuMemoryBuffer_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for ClientGmbInterface.2
  bool success = true;
  bool p_success{};
  ClientGmbInterface_CopyGpuMemoryBuffer_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ClientGmbInterface::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void ClientGmbInterface_CopyGpuMemoryBuffer_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply gpu::mojom::ClientGmbInterface::CopyGpuMemoryBuffer", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ClientGmbInterface::kCopyGpuMemoryBuffer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::gpu::mojom::internal::ClientGmbInterface_CopyGpuMemoryBuffer_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClientGmbInterface::Name_);
  message.set_method_name("CopyGpuMemoryBuffer");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ClientGmbInterfaceStubDispatch::Accept(
    ClientGmbInterface* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ClientGmbInterface>(message->header()->name)) {
    case messages::ClientGmbInterface::kCreateGpuMemoryBuffer: {
      break;
    }
    case messages::ClientGmbInterface::kDestroyGpuMemoryBuffer: {
      DCHECK(message->is_serialized());
      internal::ClientGmbInterface_DestroyGpuMemoryBuffer_Params_Data* params =
          reinterpret_cast<internal::ClientGmbInterface_DestroyGpuMemoryBuffer_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for ClientGmbInterface.1
      bool success = true;
      ::gfx::GpuMemoryBufferId p_id{};
      ClientGmbInterface_DestroyGpuMemoryBuffer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClientGmbInterface::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DestroyGpuMemoryBuffer(        
        std::move(p_id));
      return true;
    }
    case messages::ClientGmbInterface::kCopyGpuMemoryBuffer: {
      break;
    }
  }
  return false;
}

// static
bool ClientGmbInterfaceStubDispatch::AcceptWithResponder(
    ClientGmbInterface* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ClientGmbInterface>(message->header()->name)) {
    case messages::ClientGmbInterface::kCreateGpuMemoryBuffer: {
      internal::ClientGmbInterface_CreateGpuMemoryBuffer_Params_Data* params =
          reinterpret_cast<
              internal::ClientGmbInterface_CreateGpuMemoryBuffer_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for ClientGmbInterface.0
      bool success = true;
      ::gfx::GpuMemoryBufferId p_id{};
      ::gfx::Size p_size{};
      ::gfx::BufferFormat p_format{};
      ::gfx::BufferUsage p_usage{};
      ::gpu::SurfaceHandle p_surface_handle{};
      ClientGmbInterface_CreateGpuMemoryBuffer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (success && !input_data_view.ReadSize(&p_size))
        success = false;
      if (success && !input_data_view.ReadFormat(&p_format))
        success = false;
      if (success && !input_data_view.ReadUsage(&p_usage))
        success = false;
      if (success && !input_data_view.ReadSurfaceHandle(&p_surface_handle))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClientGmbInterface::Name_, 0, false);
        return false;
      }
      ClientGmbInterface::CreateGpuMemoryBufferCallback callback =
          ClientGmbInterface_CreateGpuMemoryBuffer_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateGpuMemoryBuffer(        
        std::move(p_id), 
        std::move(p_size), 
        std::move(p_format), 
        std::move(p_usage), 
        std::move(p_surface_handle), std::move(callback));
      return true;
    }
    case messages::ClientGmbInterface::kDestroyGpuMemoryBuffer: {
      break;
    }
    case messages::ClientGmbInterface::kCopyGpuMemoryBuffer: {
      internal::ClientGmbInterface_CopyGpuMemoryBuffer_Params_Data* params =
          reinterpret_cast<
              internal::ClientGmbInterface_CopyGpuMemoryBuffer_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for ClientGmbInterface.2
      bool success = true;
      ::gfx::GpuMemoryBufferHandle p_buffer_handle{};
      ::base::UnsafeSharedMemoryRegion p_shared_memory{};
      ClientGmbInterface_CopyGpuMemoryBuffer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBufferHandle(&p_buffer_handle))
        success = false;
      if (success && !input_data_view.ReadSharedMemory(&p_shared_memory))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClientGmbInterface::Name_, 2, false);
        return false;
      }
      ClientGmbInterface::CopyGpuMemoryBufferCallback callback =
          ClientGmbInterface_CopyGpuMemoryBuffer_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CopyGpuMemoryBuffer(        
        std::move(p_buffer_handle), 
        std::move(p_shared_memory), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kClientGmbInterfaceValidationInfo[] = {
    {base::to_underlying(messages::ClientGmbInterface::kCreateGpuMemoryBuffer),
     { &internal::ClientGmbInterface_CreateGpuMemoryBuffer_Params_Data::Validate,
      &internal::ClientGmbInterface_CreateGpuMemoryBuffer_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::ClientGmbInterface::kDestroyGpuMemoryBuffer),
     { &internal::ClientGmbInterface_DestroyGpuMemoryBuffer_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::ClientGmbInterface::kCopyGpuMemoryBuffer),
     { &internal::ClientGmbInterface_CopyGpuMemoryBuffer_Params_Data::Validate,
      &internal::ClientGmbInterface_CopyGpuMemoryBuffer_ResponseParams_Data::Validate}},
};

bool ClientGmbInterfaceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::gpu::mojom::ClientGmbInterface::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kClientGmbInterfaceValidationInfo);
}

bool ClientGmbInterfaceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::gpu::mojom::ClientGmbInterface::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kClientGmbInterfaceValidationInfo);

}


}  // gpu::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace gpu::mojom {


void ClientGmbInterfaceInterceptorForTesting::CreateGpuMemoryBuffer(::gfx::GpuMemoryBufferId id, const ::gfx::Size& size, ::gfx::BufferFormat format, ::gfx::BufferUsage usage, ::gpu::SurfaceHandle surface_handle, CreateGpuMemoryBufferCallback callback) {
  GetForwardingInterface()->CreateGpuMemoryBuffer(
    std::move(id)
    , 
    std::move(size)
    , 
    std::move(format)
    , 
    std::move(usage)
    , 
    std::move(surface_handle)
    , std::move(callback));
}
void ClientGmbInterfaceInterceptorForTesting::DestroyGpuMemoryBuffer(::gfx::GpuMemoryBufferId id) {
  GetForwardingInterface()->DestroyGpuMemoryBuffer(
    std::move(id)
    );
}
void ClientGmbInterfaceInterceptorForTesting::CopyGpuMemoryBuffer(::gfx::GpuMemoryBufferHandle buffer_handle, ::base::UnsafeSharedMemoryRegion shared_memory, CopyGpuMemoryBufferCallback callback) {
  GetForwardingInterface()->CopyGpuMemoryBuffer(
    std::move(buffer_handle)
    , 
    std::move(shared_memory)
    , std::move(callback));
}
ClientGmbInterfaceAsyncWaiter::ClientGmbInterfaceAsyncWaiter(
    ClientGmbInterface* proxy) : proxy_(proxy) {}

ClientGmbInterfaceAsyncWaiter::~ClientGmbInterfaceAsyncWaiter() = default;

void ClientGmbInterfaceAsyncWaiter::CreateGpuMemoryBuffer(
    ::gfx::GpuMemoryBufferId id, const ::gfx::Size& size, ::gfx::BufferFormat format, ::gfx::BufferUsage usage, ::gpu::SurfaceHandle surface_handle, ::gfx::GpuMemoryBufferHandle* out_buffer_handle) {
  base::RunLoop loop;
  proxy_->CreateGpuMemoryBuffer(
      std::move(id),
      std::move(size),
      std::move(format),
      std::move(usage),
      std::move(surface_handle),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::gfx::GpuMemoryBufferHandle* out_buffer_handle
,
             ::gfx::GpuMemoryBufferHandle buffer_handle) {*out_buffer_handle = std::move(buffer_handle);
            loop->Quit();
          },
          &loop,
          out_buffer_handle));
  loop.Run();
}

::gfx::GpuMemoryBufferHandle ClientGmbInterfaceAsyncWaiter::CreateGpuMemoryBuffer(
    ::gfx::GpuMemoryBufferId id, const ::gfx::Size& size, ::gfx::BufferFormat format, ::gfx::BufferUsage usage, ::gpu::SurfaceHandle surface_handle) {
  ::gfx::GpuMemoryBufferHandle async_wait_result;
  CreateGpuMemoryBuffer(std::move(id),std::move(size),std::move(format),std::move(usage),std::move(surface_handle),&async_wait_result);
  return async_wait_result;
}

void ClientGmbInterfaceAsyncWaiter::CopyGpuMemoryBuffer(
    ::gfx::GpuMemoryBufferHandle buffer_handle, ::base::UnsafeSharedMemoryRegion shared_memory, bool* out_success) {
  base::RunLoop loop;
  proxy_->CopyGpuMemoryBuffer(
      std::move(buffer_handle),
      std::move(shared_memory),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool ClientGmbInterfaceAsyncWaiter::CopyGpuMemoryBuffer(
    ::gfx::GpuMemoryBufferHandle buffer_handle, ::base::UnsafeSharedMemoryRegion shared_memory) {
  bool async_wait_result;
  CopyGpuMemoryBuffer(std::move(buffer_handle),std::move(shared_memory),&async_wait_result);
  return async_wait_result;
}






}  // gpu::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif