"use strict";
/* --------------------------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 * ------------------------------------------------------------------------------------------ */
Object.defineProperty(exports, "__esModule", { value: true });
exports.TextDocumentContentFeature = void 0;
const vscode_languageserver_protocol_1 = require("vscode-languageserver-protocol");
const TextDocumentContentFeature = (Base) => {
    return class extends Base {
        get textDocumentContent() {
            return {
                refresh: (uri) => {
                    return this.connection.sendRequest(vscode_languageserver_protocol_1.TextDocumentContentRefreshRequest.type, { uri });
                },
                on: (handler) => {
                    return this.connection.onRequest(vscode_languageserver_protocol_1.TextDocumentContentRequest.type, (params, cancel) => {
                        return handler(params, cancel);
                    });
                }
            };
        }
    };
};
exports.TextDocumentContentFeature = TextDocumentContentFeature;
