/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.descriptor.web;

import java.io.IOException;
import java.net.URL;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.descriptor.DigesterFactory;
import org.apache.tomcat.util.descriptor.InputSourceUtil;
import org.apache.tomcat.util.descriptor.XmlErrorHandler;
import org.apache.tomcat.util.descriptor.web.Constants;
import org.apache.tomcat.util.descriptor.web.WebRuleSet;
import org.apache.tomcat.util.descriptor.web.WebXml;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.res.StringManager;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class WebXmlParser {
    private final Log log = LogFactory.getLog(WebXmlParser.class);
    private static final StringManager sm = StringManager.getManager((String)Constants.PACKAGE_NAME);
    private final Digester webDigester;
    private final WebRuleSet webRuleSet = new WebRuleSet(false);
    private final Digester webFragmentDigester;
    private final WebRuleSet webFragmentRuleSet;

    public WebXmlParser(boolean bl, boolean bl2, boolean bl3) {
        this.webDigester = DigesterFactory.newDigester(bl2, bl, this.webRuleSet, bl3);
        this.webDigester.getParser();
        this.webFragmentRuleSet = new WebRuleSet(true);
        this.webFragmentDigester = DigesterFactory.newDigester(bl2, bl, this.webFragmentRuleSet, bl3);
        this.webFragmentDigester.getParser();
    }

    public boolean parseWebXml(URL uRL, WebXml webXml, boolean bl) throws IOException {
        if (uRL == null) {
            return true;
        }
        InputSource inputSource = new InputSource(uRL.toExternalForm());
        inputSource.setByteStream(uRL.openStream());
        return this.parseWebXml(inputSource, webXml, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseWebXml(InputSource inputSource, WebXml webXml, boolean bl) {
        WebRuleSet webRuleSet;
        Digester digester;
        if (inputSource == null) {
            return true;
        }
        XmlErrorHandler xmlErrorHandler = new XmlErrorHandler();
        if (bl) {
            digester = this.webFragmentDigester;
            webRuleSet = this.webFragmentRuleSet;
        } else {
            digester = this.webDigester;
            webRuleSet = this.webRuleSet;
        }
        digester.push(webXml);
        digester.setErrorHandler(xmlErrorHandler);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("webXmlParser.applicationStart", new Object[]{inputSource.getSystemId()}));
        }
        boolean bl2 = true;
        try {
            digester.parse(inputSource);
            if (!xmlErrorHandler.getWarnings().isEmpty() || !xmlErrorHandler.getErrors().isEmpty()) {
                bl2 = false;
                xmlErrorHandler.logFindings(this.log, inputSource.getSystemId());
            }
        }
        catch (SAXParseException sAXParseException) {
            this.log.error((Object)sm.getString("webXmlParser.applicationParse", new Object[]{inputSource.getSystemId()}), (Throwable)sAXParseException);
            this.log.error((Object)sm.getString("webXmlParser.applicationPosition", new Object[]{"" + sAXParseException.getLineNumber(), "" + sAXParseException.getColumnNumber()}));
            bl2 = false;
        }
        catch (Exception exception) {
            this.log.error((Object)sm.getString("webXmlParser.applicationParse", new Object[]{inputSource.getSystemId()}), (Throwable)exception);
            bl2 = false;
        }
        finally {
            InputSourceUtil.close(inputSource);
            digester.reset();
            webRuleSet.recycle();
        }
        return bl2;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.webDigester.setClassLoader(classLoader);
        this.webFragmentDigester.setClassLoader(classLoader);
    }
}

