/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorComponentInfo;
import com.github.ajalt.colormath.ColorSpace;
import com.github.ajalt.colormath.internal.ColorSpaceUtilsKt;
import com.github.ajalt.colormath.model.Ansi16;
import com.github.ajalt.colormath.model.Ansi256;
import com.github.ajalt.colormath.model.HPLuv;
import com.github.ajalt.colormath.model.HSL;
import com.github.ajalt.colormath.model.HSLuv;
import com.github.ajalt.colormath.model.HSV;
import com.github.ajalt.colormath.model.HWB;
import com.github.ajalt.colormath.model.ICtCp;
import com.github.ajalt.colormath.model.JzAzBz;
import com.github.ajalt.colormath.model.JzCzHz;
import com.github.ajalt.colormath.model.LAB;
import com.github.ajalt.colormath.model.LCHab;
import com.github.ajalt.colormath.model.LCHuv;
import com.github.ajalt.colormath.model.LUV;
import com.github.ajalt.colormath.model.Oklab;
import com.github.ajalt.colormath.model.Oklch;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.XYZ;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 *2\u00020\u0001:\u0001*B1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bB1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\t\u0012\u0006\u0010\u0005\u001a\u00020\t\u0012\u0006\u0010\u0006\u001a\u00020\t\u0012\b\b\u0002\u0010\u0007\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB/\u0012\u0006\u0010\u0002\u001a\u00020\n\u0012\u0006\u0010\u0004\u001a\u00020\n\u0012\u0006\u0010\u0005\u001a\u00020\n\u0012\u0006\u0010\u0006\u001a\u00020\n\u0012\b\b\u0002\u0010\u0007\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0017\u001a\u00020\u0001H\u0016J\t\u0010\u0018\u001a\u00020\nH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\nH\u00c6\u0003J;\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\n2\b\b\u0002\u0010\u0004\u001a\u00020\n2\b\b\u0002\u0010\u0005\u001a\u00020\n2\b\b\u0002\u0010\u0006\u001a\u00020\n2\b\b\u0002\u0010\u0007\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u00d6\u0003J\t\u0010\"\u001a\u00020\tH\u00d6\u0001J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0000H\u0016J\b\u0010&\u001a\u00020'H\u0016J\t\u0010(\u001a\u00020)H\u00d6\u0001R\u0014\u0010\u0007\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00000\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000e\u00a8\u0006+"}, d2={"Lcom/github/ajalt/colormath/model/CMYK;", "Lcom/github/ajalt/colormath/Color;", "c", "", "m", "y", "k", "alpha", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "", "", "(IIIIF)V", "(FFFFF)V", "getAlpha", "()F", "getC", "getK", "getM", "space", "Lcom/github/ajalt/colormath/ColorSpace;", "getSpace", "()Lcom/github/ajalt/colormath/ColorSpace;", "getY", "clamp", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "toArray", "", "toCMYK", "toSRGB", "Lcom/github/ajalt/colormath/model/RGB;", "toString", "", "Companion", "colormath"})
public final class CMYK
implements Color {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float c;
    private final float m;
    private final float y;
    private final float k;
    private final float alpha;
    @NotNull
    private static final List<ColorComponentInfo> components = ColorSpaceUtilsKt.zeroOneComponentInfo("CMYK");

    public CMYK(float c, float m, float y, float k, float alpha) {
        this.c = c;
        this.m = m;
        this.y = y;
        this.k = k;
        this.alpha = alpha;
    }

    public /* synthetic */ CMYK(float f, float f2, float f3, float f4, float f5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            f5 = 1.0f;
        }
        this(f, f2, f3, f4, f5);
    }

    public final float getC() {
        return this.c;
    }

    public final float getM() {
        return this.m;
    }

    public final float getY() {
        return this.y;
    }

    public final float getK() {
        return this.k;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    public CMYK(@NotNull Number c, @NotNull Number m, @NotNull Number y, @NotNull Number k, @NotNull Number alpha) {
        Intrinsics.checkNotNullParameter(c, "c");
        Intrinsics.checkNotNullParameter(m, "m");
        Intrinsics.checkNotNullParameter(y, "y");
        Intrinsics.checkNotNullParameter(k, "k");
        Intrinsics.checkNotNullParameter(alpha, "alpha");
        this(c.floatValue(), m.floatValue(), y.floatValue(), k.floatValue(), alpha.floatValue());
    }

    public /* synthetic */ CMYK(Number number, Number number2, Number number3, Number number4, Number number5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            number5 = Float.valueOf(1.0f);
        }
        this(number, number2, number3, number4, number5);
    }

    public CMYK(int c, int m, int y, int k, float alpha) {
        this((float)c / 100.0f, (float)m / 100.0f, (float)y / 100.0f, (float)k / 100.0f, alpha);
    }

    public /* synthetic */ CMYK(int n, int n2, int n3, int n4, float f, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 0x10) != 0) {
            f = 1.0f;
        }
        this(n, n2, n3, n4, f);
    }

    @NotNull
    public ColorSpace<CMYK> getSpace() {
        return Companion;
    }

    @Override
    @NotNull
    public RGB toSRGB() {
        float r = (1.0f - this.c) * (1.0f - this.k);
        float g = (1.0f - this.m) * (1.0f - this.k);
        float b = (1.0f - this.y) * (1.0f - this.k);
        return RGB.Companion.invoke(r, g, b, this.getAlpha());
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        return this;
    }

    @Override
    @NotNull
    public float[] toArray() {
        float[] fArray = new float[]{this.c, this.m, this.y, this.k, this.getAlpha()};
        return fArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Color clamp() {
        Color color;
        float f = this.c;
        boolean bl = 0.0f <= f ? f <= 1.0f : false;
        if (bl) {
            f = this.m;
            boolean bl2 = 0.0f <= f ? f <= 1.0f : false;
            if (bl2) {
                f = this.y;
                boolean bl3 = 0.0f <= f ? f <= 1.0f : false;
                if (bl3) {
                    f = this.k;
                    boolean bl4 = 0.0f <= f ? f <= 1.0f : false;
                    if (bl4) {
                        f = this.getAlpha();
                        boolean bl5 = 0.0f <= f ? f <= 1.0f : false;
                        if (bl5) {
                            color = this;
                            return color;
                        }
                    }
                }
            }
        }
        color = this.copy(RangesKt.coerceIn(this.c, 0.0f, 1.0f), RangesKt.coerceIn(this.m, 0.0f, 1.0f), RangesKt.coerceIn(this.y, 0.0f, 1.0f), RangesKt.coerceIn(this.k, 0.0f, 1.0f), RangesKt.coerceIn(this.getAlpha(), 0.0f, 1.0f));
        return color;
    }

    @Override
    @NotNull
    public HSL toHSL() {
        return Color.DefaultImpls.toHSL(this);
    }

    @Override
    @NotNull
    public HSV toHSV() {
        return Color.DefaultImpls.toHSV(this);
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        return Color.DefaultImpls.toAnsi16(this);
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        return Color.DefaultImpls.toAnsi256(this);
    }

    @Override
    @NotNull
    public XYZ toXYZ() {
        return Color.DefaultImpls.toXYZ(this);
    }

    @Override
    @NotNull
    public LAB toLAB() {
        return Color.DefaultImpls.toLAB(this);
    }

    @Override
    @NotNull
    public LCHab toLCHab() {
        return Color.DefaultImpls.toLCHab(this);
    }

    @Override
    @NotNull
    public LUV toLUV() {
        return Color.DefaultImpls.toLUV(this);
    }

    @Override
    @NotNull
    public LCHuv toLCHuv() {
        return Color.DefaultImpls.toLCHuv(this);
    }

    @Override
    @NotNull
    public HWB toHWB() {
        return Color.DefaultImpls.toHWB(this);
    }

    @Override
    @NotNull
    public Oklab toOklab() {
        return Color.DefaultImpls.toOklab(this);
    }

    @Override
    @NotNull
    public Oklch toOklch() {
        return Color.DefaultImpls.toOklch(this);
    }

    @Override
    @NotNull
    public JzAzBz toJzAzBz() {
        return Color.DefaultImpls.toJzAzBz(this);
    }

    @Override
    @NotNull
    public JzCzHz toJzCzHz() {
        return Color.DefaultImpls.toJzCzHz(this);
    }

    @Override
    @NotNull
    public ICtCp toICtCp() {
        return Color.DefaultImpls.toICtCp(this);
    }

    @Override
    @NotNull
    public HSLuv toHSLuv() {
        return Color.DefaultImpls.toHSLuv(this);
    }

    @Override
    @NotNull
    public HPLuv toHPLuv() {
        return Color.DefaultImpls.toHPLuv(this);
    }

    public final float component1() {
        return this.c;
    }

    public final float component2() {
        return this.m;
    }

    public final float component3() {
        return this.y;
    }

    public final float component4() {
        return this.k;
    }

    public final float component5() {
        return this.alpha;
    }

    @NotNull
    public final CMYK copy(float c, float m, float y, float k, float alpha) {
        return new CMYK(c, m, y, k, alpha);
    }

    public static /* synthetic */ CMYK copy$default(CMYK cMYK, float f, float f2, float f3, float f4, float f5, int n, Object object) {
        if ((n & 1) != 0) {
            f = cMYK.c;
        }
        if ((n & 2) != 0) {
            f2 = cMYK.m;
        }
        if ((n & 4) != 0) {
            f3 = cMYK.y;
        }
        if ((n & 8) != 0) {
            f4 = cMYK.k;
        }
        if ((n & 0x10) != 0) {
            f5 = cMYK.alpha;
        }
        return cMYK.copy(f, f2, f3, f4, f5);
    }

    @NotNull
    public String toString() {
        return "CMYK(c=" + this.c + ", m=" + this.m + ", y=" + this.y + ", k=" + this.k + ", alpha=" + this.alpha + ')';
    }

    public int hashCode() {
        int result2 = Float.hashCode(this.c);
        result2 = result2 * 31 + Float.hashCode(this.m);
        result2 = result2 * 31 + Float.hashCode(this.y);
        result2 = result2 * 31 + Float.hashCode(this.k);
        result2 = result2 * 31 + Float.hashCode(this.alpha);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CMYK)) {
            return false;
        }
        CMYK cMYK = (CMYK)other;
        if (Float.compare(this.c, cMYK.c) != 0) {
            return false;
        }
        if (Float.compare(this.m, cMYK.m) != 0) {
            return false;
        }
        if (Float.compare(this.y, cMYK.y) != 0) {
            return false;
        }
        if (Float.compare(this.k, cMYK.k) != 0) {
            return false;
        }
        return Float.compare(this.alpha, cMYK.alpha) == 0;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0011H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/github/ajalt/colormath/model/CMYK$Companion;", "Lcom/github/ajalt/colormath/ColorSpace;", "Lcom/github/ajalt/colormath/model/CMYK;", "()V", "components", "", "Lcom/github/ajalt/colormath/ColorComponentInfo;", "getComponents", "()Ljava/util/List;", "name", "", "getName", "()Ljava/lang/String;", "convert", "color", "Lcom/github/ajalt/colormath/Color;", "create", "", "colormath"})
    @SourceDebugExtension(value={"SMAP\nCMYK.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CMYK.kt\ncom/github/ajalt/colormath/model/CMYK$Companion\n+ 2 ColorSpaceUtils.kt\ncom/github/ajalt/colormath/internal/ColorSpaceUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n15#2,5:72\n1#3:77\n*S KotlinDebug\n*F\n+ 1 CMYK.kt\ncom/github/ajalt/colormath/model/CMYK$Companion\n*L\n33#1:72,5\n*E\n"})
    public static final class Companion
    implements ColorSpace<CMYK> {
        private Companion() {
        }

        @Override
        @NotNull
        public String getName() {
            return "CMYK";
        }

        @Override
        @NotNull
        public List<ColorComponentInfo> getComponents() {
            return components;
        }

        @Override
        @NotNull
        public CMYK convert(@NotNull Color color) {
            Intrinsics.checkNotNullParameter(color, "color");
            return color.toCMYK();
        }

        @Override
        @NotNull
        public CMYK create(@NotNull float[] components) {
            float f;
            Intrinsics.checkNotNullParameter(components, "components");
            ColorSpace $this$withValidComps$iv = this;
            boolean $i$f$withValidComps = false;
            int size$iv = $this$withValidComps$iv.getComponents().size();
            int n = size$iv - 1;
            int n2 = components.length;
            if (!(n <= n2 ? n2 <= size$iv : false)) {
                boolean bl = false;
                String string = "Invalid component array length: " + components.length + ", expected " + (size$iv - 1) + " or " + size$iv;
                throw new IllegalArgumentException(string.toString());
            }
            float[] it = components;
            boolean bl = false;
            float f2 = it[0];
            float f3 = it[1];
            float f4 = it[2];
            float f5 = it[3];
            int n3 = 4;
            float[] fArray = it;
            if (n3 <= ArraysKt.getLastIndex(fArray)) {
                f = fArray[n3];
            } else {
                int n4 = n3;
                float f6 = f5;
                float f7 = f4;
                float f8 = f3;
                float f9 = f2;
                boolean bl2 = false;
                float f10 = 1.0f;
                f2 = f9;
                f3 = f8;
                f4 = f7;
                f5 = f6;
                f = f10;
            }
            float f11 = f;
            float f12 = f5;
            float f13 = f4;
            float f14 = f3;
            float f15 = f2;
            return (CMYK)((Color)new CMYK(f15, f14, f13, f12, f11));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

