/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis;

import java.io.Serializable;
import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealSolver;

public abstract class UnivariateRealSolverImpl
implements UnivariateRealSolver,
Serializable {
    static final long serialVersionUID = 1112491292565386596L;
    protected double absoluteAccuracy;
    protected double relativeAccuracy;
    protected double functionValueAccuracy;
    protected int maximalIterationCount;
    protected double defaultAbsoluteAccuracy;
    protected double defaultRelativeAccuracy;
    protected double defaultFunctionValueAccuracy;
    protected int defaultMaximalIterationCount;
    protected boolean resultComputed = false;
    protected double result;
    protected int iterationCount;
    protected UnivariateRealFunction f;

    protected UnivariateRealSolverImpl(UnivariateRealFunction f, int defaultMaximalIterationCount, double defaultAbsoluteAccuracy) {
        if (f == null) {
            throw new IllegalArgumentException("function can not be null.");
        }
        this.f = f;
        this.defaultAbsoluteAccuracy = defaultAbsoluteAccuracy;
        this.defaultRelativeAccuracy = 1.0E-14;
        this.defaultFunctionValueAccuracy = 1.0E-15;
        this.absoluteAccuracy = defaultAbsoluteAccuracy;
        this.relativeAccuracy = this.defaultRelativeAccuracy;
        this.functionValueAccuracy = this.defaultFunctionValueAccuracy;
        this.defaultMaximalIterationCount = defaultMaximalIterationCount;
        this.maximalIterationCount = defaultMaximalIterationCount;
    }

    public double getResult() {
        if (this.resultComputed) {
            return this.result;
        }
        throw new IllegalStateException("No result available");
    }

    public int getIterationCount() {
        if (this.resultComputed) {
            return this.iterationCount;
        }
        throw new IllegalStateException("No result available");
    }

    protected final void setResult(double result, int iterationCount) {
        this.result = result;
        this.iterationCount = iterationCount;
        this.resultComputed = true;
    }

    protected final void clearResult() {
        this.resultComputed = false;
    }

    public void setAbsoluteAccuracy(double accuracy) {
        this.absoluteAccuracy = accuracy;
    }

    public double getAbsoluteAccuracy() {
        return this.absoluteAccuracy;
    }

    public void resetAbsoluteAccuracy() {
        this.absoluteAccuracy = this.defaultAbsoluteAccuracy;
    }

    public void setMaximalIterationCount(int count) {
        this.maximalIterationCount = count;
    }

    public int getMaximalIterationCount() {
        return this.maximalIterationCount;
    }

    public void resetMaximalIterationCount() {
        this.maximalIterationCount = this.defaultMaximalIterationCount;
    }

    public void setRelativeAccuracy(double accuracy) {
        this.relativeAccuracy = accuracy;
    }

    public double getRelativeAccuracy() {
        return this.relativeAccuracy;
    }

    public void resetRelativeAccuracy() {
        this.relativeAccuracy = this.defaultRelativeAccuracy;
    }

    public void setFunctionValueAccuracy(double accuracy) {
        this.functionValueAccuracy = accuracy;
    }

    public double getFunctionValueAccuracy() {
        return this.functionValueAccuracy;
    }

    public void resetFunctionValueAccuracy() {
        this.functionValueAccuracy = this.defaultFunctionValueAccuracy;
    }

    protected boolean isBracketing(double lower, double upper, UnivariateRealFunction f) throws FunctionEvaluationException {
        return f.value(lower) * f.value(upper) < 0.0;
    }

    protected boolean isSequence(double start, double mid, double end) {
        return start < mid && mid < end;
    }

    protected void verifyInterval(double lower, double upper) {
        if (lower >= upper) {
            throw new IllegalArgumentException("Endpoints do not specify an interval: [" + lower + "," + upper + "]");
        }
    }

    protected void verifySequence(double lower, double initial, double upper) {
        if (!this.isSequence(lower, initial, upper)) {
            throw new IllegalArgumentException("Invalid interval, initial value parameters:  lower=" + lower + " initial=" + initial + " upper=" + upper);
        }
    }

    protected void verifyBracketing(double lower, double upper, UnivariateRealFunction f) throws FunctionEvaluationException {
        this.verifyInterval(lower, upper);
        if (!this.isBracketing(lower, upper, f)) {
            throw new IllegalArgumentException("Function values at endpoints do not have different signs.  Endpoints: [" + lower + "," + upper + "]" + "  Values: [" + f.value(lower) + "," + f.value(upper) + "]");
        }
    }

    public abstract /* synthetic */ double solve(double var1, double var3, double var5) throws ConvergenceException, FunctionEvaluationException;

    public abstract /* synthetic */ double solve(double var1, double var3) throws ConvergenceException, FunctionEvaluationException;
}

