/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.search;

import com.dickimawbooks.texparserlib.search.SearchMatcher;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileNameMatcher
implements SearchMatcher {
    private Pattern pattern;
    private int type;
    public static final int FULL_PATH = 0;
    public static final int CANONICAL_PATH = 1;
    public static final int LEAF = 2;
    public static final int BASE_NAME = 3;
    public static final int EXTENSION = 4;

    public FileNameMatcher(Pattern pattern, int n) {
        this.pattern = pattern;
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.type = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type: " + n);
            }
        }
    }

    @Override
    public boolean isMatch(Object object) {
        if (!(object instanceof File)) {
            return false;
        }
        File file = (File)object;
        String string = "";
        switch (this.type) {
            case 0: {
                string = file.getAbsolutePath();
                break;
            }
            case 1: {
                try {
                    string = file.getCanonicalPath();
                    break;
                }
                catch (IOException | SecurityException exception) {
                    return false;
                }
            }
            case 2: {
                string = file.getName();
                break;
            }
            case 3: {
                String string2 = file.getName();
                int n = string2.lastIndexOf(".");
                if (n == -1) {
                    string = string2;
                    break;
                }
                if (n <= 0) break;
                string = string2.substring(0, n);
                break;
            }
            case 4: {
                String string3 = file.getName();
                int n = string3.lastIndexOf(".");
                if (n <= -1) break;
                string = string3.substring(n + 1);
            }
        }
        Matcher matcher = this.pattern.matcher(string);
        return matcher.matches();
    }

    public String toString() {
        return String.format("%s[pattern=%s,type=%d]", this.getClass().getSimpleName(), this.pattern, this.type);
    }
}

