/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.NumericRegister;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSettings;
import com.dickimawbooks.texparserlib.TextualContentCommand;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.ListDec;
import com.dickimawbooks.texparserlib.primitives.RomanNumeral;
import java.io.IOException;

public class ItemizeDec
extends ListDec {
    public ItemizeDec() {
        this("itemize");
    }

    public ItemizeDec(String string) {
        super(string);
    }

    @Override
    public Object clone() {
        return new ItemizeDec(this.getName());
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.setup(teXParser, teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.setup(teXParser, teXObjectList);
    }

    @Override
    public void setup(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        super.setup(teXParser, teXObjectList);
        TeXSettings teXSettings = teXParser.getSettings();
        NumericRegister numericRegister = teXSettings.globalAdvanceRegister("@itemdepth", LaTeXParserListener.ONE);
        String string = "labelitem" + RomanNumeral.romannumeral(numericRegister.number(teXParser));
        teXParser.putControlSequence(true, new TextualContentCommand("@itemitem", string));
        ControlSequence controlSequence = teXParser.getControlSequence(string);
        if (controlSequence == null) {
            controlSequence = teXParser.getListener().getControlSequence("relax");
        }
        TeXObjectList teXObjectList2 = new TeXObjectList();
        this.setup(teXParser, teXObjectList, controlSequence, teXObjectList2);
    }

    @Override
    public void end(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXSettings teXSettings = teXParser.getSettings();
        NumericRegister numericRegister = teXSettings.globalAdvanceRegister("@itemdepth", LaTeXParserListener.MINUS_ONE);
        super.end(teXParser, teXObjectList);
    }
}

