/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.html.DocumentBlockType;
import com.dickimawbooks.texparserlib.html.HtmlTag;
import com.dickimawbooks.texparserlib.html.L2HConverter;
import java.io.IOException;

public class EndElement
extends HtmlTag {
    private String name;
    private boolean appendCR = false;
    private boolean isBlock = false;

    public EndElement(String string) {
        this(string, false);
    }

    public EndElement(String string, boolean bl) {
        this(string, bl, string.equals("div"));
    }

    public EndElement(String string, boolean bl, boolean bl2) {
        super(String.format("</%s>", string));
        if (string.contains("[^a-zA-Z]")) {
            throw new IllegalArgumentException(String.format("Invalid element name '%s'", string));
        }
        this.name = string;
        this.appendCR = bl;
        this.isBlock = bl2;
    }

    @Override
    public Object clone() {
        return new EndElement(this.getName(), this.appendCR);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        if (this.isBlock) {
            l2HConverter.endParagraph();
            l2HConverter.setCurrentBlockType(DocumentBlockType.BODY);
        }
        super.process(teXParser);
        if (this.appendCR) {
            l2HConverter.writeln();
        }
    }
}

