/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;

public class TeXCellAlign {
    private TeXObject before = null;
    private TeXObject after = null;
    private TeXObject preShift = null;
    private TeXObject postShift = null;
    private int preRules = 0;
    private int postRules = 0;
    private int align;
    private TeXDimension width;

    public TeXCellAlign(int n) {
        this(null, null, 0, 0, null, null, n, null);
    }

    public TeXCellAlign(TeXObject teXObject, TeXObject teXObject2, int n, int n2, TeXObject teXObject3, TeXObject teXObject4, int n3, TeXDimension teXDimension) {
        this.before = teXObject;
        this.after = teXObject2;
        this.preRules = n;
        this.postRules = n2;
        this.preShift = teXObject3;
        this.postShift = teXObject4;
        this.align = n3;
        this.width = teXDimension;
    }

    public TeXObject getBefore() {
        return this.before;
    }

    public TeXObject getAfter() {
        return this.after;
    }

    public int preRuleCount() {
        return this.preRules;
    }

    public int postRuleCount() {
        return this.postRules;
    }

    public int getAlign() {
        return this.align;
    }

    public TeXDimension getWidth() {
        return this.width;
    }

    public TeXObject getPreShift() {
        return this.preShift;
    }

    public TeXObject getPostShift() {
        return this.postShift;
    }

    public void addBefore(TeXObject teXObject) {
        if (this.before == null) {
            this.before = teXObject;
            return;
        }
        if (!(this.before instanceof TeXObjectList) || this.before instanceof Group) {
            TeXObjectList teXObjectList = new TeXObjectList();
            teXObjectList.add(this.before);
            this.before = teXObjectList;
        }
        ((TeXObjectList)this.before).add(teXObject);
    }

    public void addAfter(TeXObject teXObject) {
        if (this.after == null) {
            this.after = teXObject;
            return;
        }
        if (!(this.after instanceof TeXObjectList) || this.after instanceof Group) {
            TeXObjectList teXObjectList = new TeXObjectList();
            teXObjectList.add(this.after);
            this.after = teXObjectList;
        }
        ((TeXObjectList)this.after).add(teXObject);
    }

    public void addPreShift(TeXObject teXObject) {
        if (this.preShift == null) {
            this.preShift = teXObject;
            return;
        }
        if (!(this.preShift instanceof TeXObjectList) || this.preShift instanceof Group) {
            TeXObjectList teXObjectList = new TeXObjectList();
            teXObjectList.add(this.preShift);
            this.preShift = teXObjectList;
        }
        ((TeXObjectList)this.preShift).add(teXObject);
    }

    public void addPostShift(TeXObject teXObject) {
        if (this.postShift == null) {
            this.postShift = teXObject;
            return;
        }
        if (!(this.postShift instanceof TeXObjectList) || this.postShift instanceof Group) {
            TeXObjectList teXObjectList = new TeXObjectList();
            teXObjectList.add(this.postShift);
            this.postShift = teXObjectList;
        }
        ((TeXObjectList)this.postShift).add(teXObject);
    }

    public void addPreRule() {
        ++this.preRules;
    }

    public void addPostRule() {
        ++this.postRules;
    }

    public void setAlign(int n) {
        this.align = n;
    }

    public void setWidth(TeXDimension teXDimension) {
        this.width = teXDimension;
    }

    public String toString() {
        return String.format("%s[format=%s]", this.getClass().getSimpleName(), this.format());
    }

    public String format() {
        String string = "";
        for (int i = 0; i < this.preRules; ++i) {
            string = string + "|";
        }
        String string2 = "";
        for (int i = 0; i < this.postRules; ++i) {
            string2 = string2 + "|";
        }
        return String.format("%s%s%s%s%s%s%s", string, this.before == null ? "" : "@{" + this.before.format() + "}", this.preShift == null ? "" : this.preShift.format(), this.align == -1 ? "" : Character.valueOf((char)this.align), this.postShift == null ? "" : this.postShift.format(), this.after == null ? "" : "@{" + this.after.format() + "}", string2);
    }
}

