/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.Macro;
import com.dickimawbooks.texparserlib.SingleToken;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import java.io.IOException;

public class SbChar
extends Macro
implements SingleToken {
    protected int charCode;

    public SbChar() {
        this(95);
    }

    public SbChar(int n) {
        this.charCode = n;
    }

    public SbChar(TeXParser teXParser) {
        this(teXParser.getSbChar());
    }

    @Override
    public Object clone() {
        return new SbChar(this.charCode);
    }

    @Override
    public String toString(TeXParser teXParser) {
        return this.format();
    }

    @Override
    public int getCharCode() {
        return this.charCode;
    }

    @Override
    public int getCatCode() {
        return 8;
    }

    @Override
    public String format() {
        return new String(Character.toChars(this.charCode));
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add(teXParser.getListener().getOther(this.charCode));
        return teXObjectList;
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = teXObjectList.popArg(teXParser);
        TeXObject teXObject2 = teXObjectList.peekStack();
        if (teXObject2 instanceof SbChar) {
            teXObjectList.push(teXParser.getListener().createGroup());
            teXParser.error(new TeXSyntaxException(teXParser, "tex.error.double_subscript", teXObject.toString(teXParser)));
        }
        teXParser.getListener().subscript(teXObject);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        TeXObject teXObject = teXParser.popNextArg();
        TeXObject teXObject2 = teXParser.peekStack();
        if (teXObject2 instanceof SbChar) {
            teXParser.push(teXParser.getListener().createGroup());
            teXParser.error(new TeXSyntaxException(teXParser, "tex.error.double_subscript", teXObject.toString(teXParser)));
        }
        teXParser.getListener().subscript(teXObject);
    }

    public String show(TeXParser teXParser) throws IOException {
        return String.format("subscript character %s", this.format());
    }
}

