/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bibgls.bib2gls;

import com.dickimawbooks.bibgls.bib2gls.AuxInputAction;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsBibParser;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bibgls.bib2gls.BibGlsAuxParser;
import com.dickimawbooks.bibgls.bib2gls.BibGlsContributor;
import com.dickimawbooks.bibgls.bib2gls.BibGlsDateTime;
import com.dickimawbooks.bibgls.bib2gls.BibGlsDefinitionIndex;
import com.dickimawbooks.bibgls.bib2gls.BibGlsUseIndex;
import com.dickimawbooks.bibgls.bib2gls.CompoundEntry;
import com.dickimawbooks.bibgls.bib2gls.EnableTagging;
import com.dickimawbooks.bibgls.bib2gls.FlattenedPostSort;
import com.dickimawbooks.bibgls.bib2gls.FlattenedPreSort;
import com.dickimawbooks.bibgls.bib2gls.GlsCombinedSep;
import com.dickimawbooks.bibgls.bib2gls.GlsDisp;
import com.dickimawbooks.bibgls.bib2gls.GlsEntryFieldValue;
import com.dickimawbooks.bibgls.bib2gls.GlsEntryParentName;
import com.dickimawbooks.bibgls.bib2gls.GlsHierName;
import com.dickimawbooks.bibgls.bib2gls.GlsHyperLink;
import com.dickimawbooks.bibgls.bib2gls.GlsIfHasKey;
import com.dickimawbooks.bibgls.bib2gls.GlsLike;
import com.dickimawbooks.bibgls.bib2gls.GlsLikeFamily;
import com.dickimawbooks.bibgls.bib2gls.GlsRecord;
import com.dickimawbooks.bibgls.bib2gls.GlsRecordNameRef;
import com.dickimawbooks.bibgls.bib2gls.GlsRecordNameRefSelection;
import com.dickimawbooks.bibgls.bib2gls.GlsRecordSelection;
import com.dickimawbooks.bibgls.bib2gls.GlsResource;
import com.dickimawbooks.bibgls.bib2gls.GlsSeeRecord;
import com.dickimawbooks.bibgls.bib2gls.GlsUseField;
import com.dickimawbooks.bibgls.bib2gls.GlsXtrIfFieldEqStr;
import com.dickimawbooks.bibgls.bib2gls.GlsXtrIfHasField;
import com.dickimawbooks.bibgls.bib2gls.GlsXtrIfHasNonZeroChildCount;
import com.dickimawbooks.bibgls.bib2gls.GlsXtrMultiEntryAdjustedName;
import com.dickimawbooks.bibgls.bib2gls.HexUnicodeChar;
import com.dickimawbooks.bibgls.bib2gls.HrefChar;
import com.dickimawbooks.bibgls.bib2gls.IfGlsFieldVoid;
import com.dickimawbooks.bibgls.bib2gls.IfGlsHasChildren;
import com.dickimawbooks.bibgls.bib2gls.InterpreterListener;
import com.dickimawbooks.bibgls.bib2gls.PatternReplace;
import com.dickimawbooks.bibgls.bib2gls.RecordCountRule;
import com.dickimawbooks.bibgls.common.Bib2GlsException;
import com.dickimawbooks.bibgls.common.Bib2GlsSyntaxException;
import com.dickimawbooks.bibgls.common.BibGlsArgValue;
import com.dickimawbooks.bibgls.common.BibGlsTeXApp;
import com.dickimawbooks.texparserlib.CaseChange;
import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.FontEncoding;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.Other;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXPath;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TextualContentCommand;
import com.dickimawbooks.texparserlib.WhiteSpace;
import com.dickimawbooks.texparserlib.auxfile.AuxData;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import com.dickimawbooks.texparserlib.html.L2HStringConverter;
import com.dickimawbooks.texparserlib.latex.AtFirstOfOne;
import com.dickimawbooks.texparserlib.latex.AtFirstOfTwo;
import com.dickimawbooks.texparserlib.latex.AtSecondOfTwo;
import com.dickimawbooks.texparserlib.latex.CsvList;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXGenericCommand;
import com.dickimawbooks.texparserlib.latex.NewCommand;
import com.dickimawbooks.texparserlib.latex.Overwrite;
import com.dickimawbooks.texparserlib.latex.datatool.DTLpadleadingzeros;
import com.dickimawbooks.texparserlib.latex.fontenc.FontEncSty;
import com.dickimawbooks.texparserlib.latex.mfirstuc.CapitaliseWords;
import com.dickimawbooks.texparserlib.latex.mfirstuc.MfirstucSty;
import com.dickimawbooks.texparserlib.latex.textcase.MakeTextLowercase;
import com.dickimawbooks.texparserlib.latex.textcase.MakeTextUppercase;
import com.dickimawbooks.texparserlib.latex.textcase.NoCaseChange;
import com.dickimawbooks.texparserlib.primitives.Relax;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.IllformedLocaleException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Bib2Gls
extends BibGlsTeXApp {
    public static final String NAME = "bib2gls";
    String dirName = null;
    String auxFileName = null;
    boolean provideknownGlossaries = false;
    private char openout_any = (char)112;
    private char openin_any = (char)97;
    private Path cwd;
    private Path texmfoutput = null;
    private Path dirPath;
    private File dirFile = null;
    private Path basePath;
    private File auxFile;
    private File texLogFile;
    private StringWriter pending = null;
    private PrintWriter pendingWriter = null;
    public static final Pattern PATTERN_PACKAGE = Pattern.compile("Package: ([^\\s]+)(?:\\s+(\\d{4})/(\\d{2})/(\\d{2}))?.*");
    public static final Pattern PATTERN_ENCDEF = Pattern.compile("File: ([^ ]+)enc\\.def .*");
    private Vector<String> fontencList = null;
    private boolean fontspec = false;
    private boolean hyperref = false;
    private boolean createHyperGroups = true;
    private boolean checkNonBibFields = true;
    private boolean warnUnknownEntryTypes = true;
    private boolean allowAuxCatChangers = false;
    private int altModifier = -1;
    private Vector<GlsResource> glsresources;
    private Vector<String> fields;
    private Vector<GlsRecord> records;
    private Vector<GlsSeeRecord> seeRecords;
    private Vector<String> selectedEntries;
    private Vector<String> knownGlossaries = null;
    private HashMap<String, CompoundEntry> compoundEntries;
    private Vector<String> mglsRefs;
    private Vector<String> mglsCs;
    public static final String[] SPAWN_SPECIAL_FIELDS = new String[]{"progeny", "progenitor", "adoptparents"};
    public static final String[] DUAL_SPECIAL_FIELDS = new String[]{"dualprefix", "dualprefixplural", "dualprefixfirst", "dualprefixfirstplural", "dualdescription"};
    public static final String[] OTHER_SPECIAL_FIELDS = new String[]{"definitionindex", "useindex"};
    private static final String[] NON_BIB_FIELDS = new String[]{"bibtexcontributor", "bibtexentry", "dual", "group", "progenitor", "progeny", "secondarygroup", "secondarysort"};
    private static final String[] PRIVATE_NON_BIB_FIELDS = new String[]{"childcount", "childlist", "currcount", "desc", "descplural", "firstpl", "flag", "index", "indexcounter", "level", "location", "loclist", "longpl", "originalentrytype", "originalid", "shortpl", "siblingcount", "siblinglist", "sortvalue", "prenumberlist", "prevcount", "prevunitmax", "prevunittotal", "primarylocations", "recordcount", "unitlist", "useri", "userii", "useriii", "useriv", "userv", "uservi"};
    private HashMap<String, GlsLike> glsLikeMap;
    private Vector<GlsLikeFamily> glsLikeFamilies;
    private HashMap<String, String> fieldMap;
    private HashMap<String, String> formatMap;
    private HashMap<GlsRecord, Integer> recordCount = null;
    private Vector<File> texFiles;
    private boolean addGroupField = false;
    private boolean saveRecordCount = false;
    private boolean saveRecordCountUnit = false;
    private boolean commonCommandsDone = false;
    private Charset texCharset = null;
    private Charset texLogCharset;
    private boolean useCiteAsRecord = false;
    private boolean mergeWrGlossaryLocations = true;
    private byte mergeNameRefOn = (byte)3;
    private static final byte MERGE_NAMEREF_ON_HREF = 0;
    private static final byte MERGE_NAMEREF_ON_TITLE = 1;
    private static final byte MERGE_NAMEREF_ON_LOCATION = 2;
    private static final byte MERGE_NAMEREF_ON_HCOUNTER = 3;
    private boolean mfirstucProtect = true;
    private boolean mfirstucMProtect = true;
    private String[] mfirstucProtectFields = null;
    private boolean mfirstucProtectWasSet = false;
    private boolean mfirstucMProtectWasSet = false;
    private String shortcuts = null;
    private boolean checkAcroShortcuts = false;
    private boolean checkAbbrvShortcuts = false;
    private GlsResource currentResource = null;
    private boolean trimFields = false;
    private Vector<String> trimOnlyFields = null;
    private Vector<String> trimExceptFields = null;
    private Vector<String> retainFormatList = null;
    private boolean expandFields = false;
    private boolean dateInHeader = false;
    private boolean interpret = true;
    private Vector<String> packages = null;
    private Vector<String> ignorePackages = null;
    private Vector<String> customPackages = null;
    public static final String[] AUTO_SUPPORT_PACKAGES = new String[]{"amsmath", "amssymb", "bpchem", "fontenc", "fontspec", "fourier", "hyperref", "lipsum", "mfirstuc", "mhchem", "MnSymbol", "natbib", "pifont", "siunitx", "stix", "textcase", "textcomp", "tipa", "upgreek", "wasysym", "texjavahelp"};
    public static final String[] EXTRA_SUPPORTED_PACKAGES = new String[]{"booktabs", "color", "datatool-base", "datatool", "etoolbox", "fontawesome", "graphics", "graphicx", "ifthen", "jmlrutils", "mfirstuc-english", "probsoln", "shortvrb", "twemojis", "xfor", "xspace"};
    private TeXParser interpreter = null;
    private MfirstucSty mfirstucSty = null;
    private boolean useNonBreakSpace = true;
    private boolean forceCrossResourceRefs = false;
    private boolean supportUnicodeSubSuperScripts = true;
    private boolean multiSuppSupported = false;
    private boolean collapseSamePageRange = true;
    private String glossariesExtraVersion = "????/??/??";
    private String glossariesVersion = "????/??/??";
    private String mfirstucVersion = "????/??/??";
    private static final String MFIRSTUC208 = "2022/10/14";
    private boolean hasNewCaseSupport = false;
    private static final String GLOSSARIES4_47 = "2021/09/20";
    private static final String GLOSSARIES_EXTRA_1_46 = "2021/09/20";
    private boolean hasNewHyperGroupSupport = false;
    private static final String GLOSSARIES_4_53 = "2023/09/29";
    private static final String GLOSSARIES_EXTRA_1_53 = "2023/09/29";
    private boolean hasNonASCIILabelSupport = false;
    private Vector<String> mfirstucExclusions;
    private Vector<String> mfirstucBlockers;
    private HashMap<String, String> mfirstucMappings;
    private Vector<String> dependencies = null;
    private HashMap<String, String> kpsewhichResults;
    private RecordCountRule recordCountRule;
    private boolean replaceQuotes = false;
    private boolean datatoolSortMarkers = false;
    private AuxInputAction auxInputAction = AuxInputAction.SKIP_AFTER_BIBGLSAUX;
    private String[] nestedLinkCheckFields = new String[]{"name", "text", "plural", "first", "firstplural", "long", "longplural", "short", "shortplural", "symbol"};
    public static final String MIN_MULTI_SUPP_VERSION = "1.36";
    public static final int MIN_MULTI_SUPP_YEAR = 2018;
    public static final int MIN_MULTI_SUPP_MONTH = 8;
    public static final int MIN_MULTI_SUPP_DAY = 18;
    public static final int SUPERSCRIPT_ZERO = 8304;
    public static final int SUPERSCRIPT_ONE = 185;
    public static final int SUPERSCRIPT_TWO = 178;
    public static final int SUPERSCRIPT_THREE = 179;
    public static final int SUPERSCRIPT_FOUR = 8308;
    public static final int SUPERSCRIPT_FIVE = 8309;
    public static final int SUPERSCRIPT_SIX = 8310;
    public static final int SUPERSCRIPT_SEVEN = 8311;
    public static final int SUPERSCRIPT_EIGHT = 8312;
    public static final int SUPERSCRIPT_NINE = 8313;
    public static final int SUPERSCRIPT_PLUS = 8314;
    public static final int SUPERSCRIPT_MINUS = 8315;
    public static final int SUBSCRIPT_ZERO = 8320;
    public static final int SUBSCRIPT_ONE = 8321;
    public static final int SUBSCRIPT_TWO = 8322;
    public static final int SUBSCRIPT_THREE = 8323;
    public static final int SUBSCRIPT_FOUR = 8324;
    public static final int SUBSCRIPT_FIVE = 8325;
    public static final int SUBSCRIPT_SIX = 8326;
    public static final int SUBSCRIPT_SEVEN = 8327;
    public static final int SUBSCRIPT_EIGHT = 8328;
    public static final int SUBSCRIPT_NINE = 8329;
    public static final int SUBSCRIPT_PLUS = 8330;
    public static final int SUBSCRIPT_MINUS = 8331;
    public static final int MINUS = 8722;
    public static final String SUBSCRIPT_INT_PATTERN = String.format("[%c%c]?[%c%c%c%c%c%c%c%c%c%c]+", 8330, 8331, 8320, 8321, 8322, 8323, 8324, 8325, 8326, 8327, 8328, 8329);
    public static final String SUPERSCRIPT_INT_PATTERN = String.format("[%c%c]?[%c%c%c%c%c%c%c%c%c%c]+", 8314, 8315, 8304, 185, 178, 179, 8308, 8309, 8310, 8311, 8312, 8313);
    public static final Pattern INT_PATTERN = Pattern.compile(String.format("([+-%c]?\\p{javaDigit}+|%s|%s).*", 8722, SUBSCRIPT_INT_PATTERN, SUPERSCRIPT_INT_PATTERN));
    public static final int TRUNCATE_MAX_OBJECTS = 40;
    public static final int TRUNCATE_MAX_CHARS = 160;

    @Override
    protected void preInitMessages() throws Bib2GlsException, IOException {
        this.kpsewhichResults = new HashMap();
        try {
            this.pending = new StringWriter();
            this.pendingWriter = new PrintWriter(this.pending);
        }
        catch (Throwable throwable) {
            this.pendingWriter = null;
        }
        if (!this.isSilent()) {
            this.version();
        }
    }

    @Override
    protected void postInitMessages() throws Bib2GlsException, IOException {
        try {
            this.initSecuritySettings();
        }
        catch (InterruptedException interruptedException) {
            this.warningMessage("error.interrupted", new Object[0]);
            this.debug(interruptedException);
        }
        if (!this.isSilent()) {
            this.version();
        }
        this.formatMap = new HashMap();
        this.texFiles = new Vector();
        this.packages = new Vector();
    }

    private void initSecuritySettings() throws IOException, InterruptedException, Bib2GlsException {
        File file;
        String string;
        int n;
        String string2 = this.kpsewhich("--var-value=openin_any");
        String string3 = this.kpsewhich("--var-value=openout_any");
        int n2 = string2 == null || string2.isEmpty() ? -1 : (int)string2.charAt(0);
        int n3 = n = string3 == null || string3.isEmpty() ? -1 : (int)string3.charAt(0);
        if (n2 == 97 || n2 == 112 || n2 == 114) {
            this.openin_any = (char)n2;
        } else if (n2 == -1) {
            this.logMessage(this.getMessage("warning.missing_variable.assuming", "openin_any", "a"));
            this.openin_any = (char)97;
        } else {
            this.warningMessage("warning.invalid_variable.assuming", "openin_any", string2, "a");
            this.openin_any = (char)97;
        }
        if (n == 97 || n == 112 || n == 114) {
            this.openout_any = (char)n;
        } else if (n == -1) {
            this.logMessage(this.getMessage("warning.missing_variable.assuming", "openout_any", "p"));
            this.openout_any = (char)112;
        } else {
            this.warningMessage("warning.invalid_variable.assuming", "openout_any", string3, "p");
            this.openout_any = (char)112;
        }
        try {
            string = null;
            try {
                string = System.getenv("TEXMFOUTPUT");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (string == null || string.isEmpty()) {
                string = this.kpsewhich("--var-value=TEXMFOUTPUT");
            }
            if (string != null && !string.isEmpty()) {
                file = new TeXPath(null, string, false).getFile();
                if (file.isDirectory()) {
                    this.texmfoutput = file.toPath();
                } else if (file.exists()) {
                    this.warningMessage("warning.ignoring_var.not_dir", "TEXMFOUTPUT", string);
                } else {
                    this.logMessage(this.getMessage("warning.ignoring_var.no_exists", "TEXMFOUTPUT", string));
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        string = System.getProperty("user.dir");
        if (string == null) {
            throw new IOException("Can't determine current working directory");
        }
        file = new File(string);
        if (!file.isDirectory()) {
            throw new IOException("CWD is not a directory: " + string);
        }
        this.cwd = file.toPath();
        this.verboseMessage("message.cwd", this.cwd);
    }

    public void checkReadAccess(TeXPath teXPath) throws IOException {
        if (!this.isReadAccessAllowed(teXPath)) {
            throw new IOException(this.getMessage("error.openin.forbidden", teXPath));
        }
    }

    public void checkReadAccess(Path path) throws IOException {
        if (!this.isReadAccessAllowed(path)) {
            throw new IOException(this.getMessage("error.openin.forbidden", path));
        }
    }

    public void checkReadAccess(File file) throws IOException {
        if (!this.isReadAccessAllowed(file.toPath())) {
            throw new IOException(this.getMessage("error.openin.forbidden", Character.valueOf(this.openin_any), file));
        }
    }

    protected boolean isOnOutputPath(Path path) {
        if (this.texmfoutput != null && path.startsWith(this.texmfoutput)) {
            return true;
        }
        return this.dirPath != null && path.startsWith(this.dirPath);
    }

    @Override
    public boolean isReadAccessAllowed(TeXPath teXPath) {
        Comparable<File> comparable;
        this.debugMessage("message.checking.read", teXPath);
        Path path = teXPath.getBaseDir();
        Path path2 = teXPath.getRelativePath();
        Path path3 = path == null ? path2.normalize() : path.resolve(path2).normalize();
        try {
            comparable = path3.toFile();
            if (comparable.exists() && !comparable.canRead()) {
                this.warningMessage("warning.read_forbidden.io", teXPath);
                return false;
            }
        }
        catch (SecurityException securityException) {
            this.warningMessage("warning.read_forbidden.security_manager", teXPath);
            this.debug(securityException);
            return false;
        }
        if (this.openin_any == 'a') {
            return true;
        }
        Comparable<Path> comparable2 = comparable = path3.isAbsolute() ? path3 : path3.toAbsolutePath().normalize();
        if (this.isOnOutputPath((Path)comparable)) {
            return true;
        }
        if (teXPath.isHidden()) {
            this.warningMessage("warning.read_forbidden.hidden", "openin_any", Character.valueOf(this.openin_any), teXPath);
            return false;
        }
        if (this.openin_any == 'r') {
            return true;
        }
        if (teXPath.wasFoundByKpsewhich()) {
            return true;
        }
        if (path3.isAbsolute()) {
            if (path3.startsWith(this.cwd)) {
                return true;
            }
            this.warningMessage("warning.read_forbidden.hidden", "openin_any", Character.valueOf(this.openin_any), teXPath);
            return false;
        }
        if (path3.toAbsolutePath().normalize().startsWith(this.cwd)) {
            return true;
        }
        this.warningMessage("warning.read_forbidden.cwd", "openin_any", Character.valueOf(this.openin_any), teXPath);
        return false;
    }

    @Override
    public boolean isReadAccessAllowed(File file) {
        return this.isReadAccessAllowed(file.toPath());
    }

    public boolean isReadAccessAllowed(Path path) {
        Comparable<File> comparable;
        this.debugMessage("message.checking.read", path);
        try {
            comparable = path.toFile();
            if (((File)comparable).exists() && !((File)comparable).canRead()) {
                this.warningMessage("warning.read_forbidden.io", path);
                return false;
            }
        }
        catch (SecurityException securityException) {
            this.warningMessage("warning.read_forbidden.security_manager", path);
            this.debug(securityException);
            return false;
        }
        if (this.openin_any == 'a') {
            return true;
        }
        comparable = path.normalize();
        Path path2 = path.toAbsolutePath().normalize();
        if (this.isOnOutputPath(path2)) {
            return true;
        }
        if (this.isHidden(path)) {
            this.warningMessage("warning.read_forbidden.hidden", "openin_any", Character.valueOf(this.openin_any), path);
            return false;
        }
        if (this.openin_any == 'r') {
            return true;
        }
        if (path.isAbsolute()) {
            if (comparable.startsWith(this.cwd)) {
                return true;
            }
            String string = this.kpsewhichResults.get(comparable.getName(comparable.getNameCount() - 1).toString());
            if (string != null) {
                File file;
                if (File.separatorChar == '/') {
                    file = new File(string);
                } else {
                    String[] stringArray = string.split("/");
                    file = new File(stringArray[0] + File.separator);
                    for (int i = 0; i < stringArray.length; ++i) {
                        file = new File(file, stringArray[i]);
                    }
                }
                try {
                    if (Files.isSameFile(comparable, file.toPath())) {
                        return true;
                    }
                }
                catch (IOException iOException) {
                    this.debug(iOException);
                }
            }
            this.warningMessage("warning.read_forbidden.hidden", "openin_any", Character.valueOf(this.openin_any), comparable);
            return false;
        }
        if (path2.startsWith(this.cwd)) {
            return true;
        }
        this.warningMessage("warning.read_forbidden.cwd", "openin_any", Character.valueOf(this.openin_any), comparable);
        return false;
    }

    public void checkWriteAccess(Path path) throws IOException {
        if (!this.isWriteAccessAllowed(path)) {
            throw new IOException(this.getMessage("error.openout.forbidden", path));
        }
    }

    public void checkWriteAccess(File file) throws IOException {
        if (!this.isWriteAccessAllowed(file.toPath())) {
            throw new IOException(this.getMessage("error.openout.forbidden", file));
        }
    }

    public void registerTeXFile(File file) throws IOException {
        this.checkWriteAccess(file);
        if (this.texFiles.contains(file)) {
            throw new IOException(this.getMessage("error.duplicate.resource", file));
        }
        this.texFiles.add(file);
    }

    @Override
    public boolean isWriteAccessAllowed(TeXPath teXPath) {
        return this.isWriteAccessAllowed(teXPath.getPath());
    }

    @Override
    public boolean isWriteAccessAllowed(File file) {
        return this.isWriteAccessAllowed(file.toPath());
    }

    public boolean isWriteAccessAllowed(Path path) {
        Comparable<File> comparable;
        Comparable<File> comparable2;
        this.debugMessage("message.checking.write", path);
        String string = path.getName(path.getNameCount() - 1).toString().toLowerCase();
        int n = string.lastIndexOf(".");
        if (n > -1 && ((string = string.substring(n + 1)).equals("tex") || string.equals("ltx") || string.equals("sty") || string.equals("cls") || string.equals("bib") || string.equals("dtx") || string.equals("ins") || string.equals("def") || string.equals("ldf"))) {
            this.warningMessage(this.getMessageWithFallback("error.forbidden.ext", "Write access forbidden for extension: {0}", string), new Object[0]);
            return false;
        }
        try {
            comparable2 = path.toFile();
            if (((File)comparable2).exists() && !((File)comparable2).canWrite()) {
                this.warningMessage("warning.write_forbidden.io", path);
                return false;
            }
        }
        catch (SecurityException securityException) {
            this.warningMessage("warning.write_forbidden.security_manager", path);
            this.debug(securityException);
            return false;
        }
        if (this.openout_any == 'a') {
            return true;
        }
        comparable2 = path.normalize();
        Comparable<File> comparable3 = comparable = comparable2.isAbsolute() ? comparable2 : comparable2.toAbsolutePath().normalize();
        if (this.isOnOutputPath((Path)comparable)) {
            return true;
        }
        if (this.isHidden(path)) {
            this.warningMessage("warning.write_forbidden.hidden", "openout_any", Character.valueOf(this.openout_any), path);
            return false;
        }
        if (this.openout_any == 'r') {
            return true;
        }
        if (path.isAbsolute()) {
            if (comparable2.startsWith(this.cwd)) {
                return true;
            }
            this.warningMessage("warning.write_forbidden.absolute", "openout_any", Character.valueOf(this.openout_any), comparable2);
            return false;
        }
        if (comparable.startsWith(this.cwd)) {
            return true;
        }
        this.warningMessage("warning.write_forbidden.cwd", "openout_any", Character.valueOf(this.openout_any), comparable2);
        return false;
    }

    public boolean isHidden(Path path) {
        for (int i = path.getNameCount() - 1; i >= 0; --i) {
            String string = path.getName(i).toString();
            if (!string.startsWith(".") || string.equals(".") || string.equals("..")) continue;
            return true;
        }
        return false;
    }

    public File getWritableFile(File file) throws IOException {
        File file2 = file.getParentFile();
        if (file2 == null) {
            file2 = this.cwd.toFile();
        }
        if (this.texmfoutput != null && !file2.canWrite()) {
            this.warningMessage("warning.dir.no.write", file2, this.texmfoutput);
            file = new File(this.texmfoutput.toFile(), file.getName());
        }
        this.checkWriteAccess(file);
        return file;
    }

    public Path resolvePath(Path path) {
        return this.basePath.resolve(path).normalize();
    }

    public File resolveFile(File file) {
        file = file.getParentFile() == null ? new File(this.basePath.toFile(), file.getName()) : this.basePath.resolve(file.toPath()).toFile();
        return file;
    }

    public File resolveFile(String string) {
        return this.resolveFile(new File(string));
    }

    public File getAuxFile() {
        return this.auxFile;
    }

    private String texToJavaCharset(String string) throws Bib2GlsException {
        if (string.equals("ascii")) {
            return "US-ASCII";
        }
        if (string.equals("latin1")) {
            return "ISO-8859-1";
        }
        if (string.equals("latin2")) {
            return "ISO-8859-2";
        }
        if (string.equals("latin3")) {
            return "ISO-8859-3";
        }
        if (string.equals("latin4")) {
            return "ISO-8859-4";
        }
        if (string.equals("latin5")) {
            return "ISO-8859-9";
        }
        if (string.equals("latin6")) {
            return "ISO-8859-10";
        }
        if (string.equals("latin7")) {
            return "ISO-8859-13";
        }
        if (string.equals("latin8")) {
            return "ISO-8859-14";
        }
        if (string.equals("latin9")) {
            return "ISO-8859-15";
        }
        if (string.equals("latin10")) {
            return "ISO-8859-16";
        }
        if (string.equals("decmulti")) {
            return "DEC-MCS";
        }
        if (string.equals("cp850")) {
            return "Cp850";
        }
        if (string.equals("cp852")) {
            return "Cp852";
        }
        if (string.equals("cp858")) {
            return "Cp858";
        }
        if (string.equals("cp437") || string.equals("cp437de")) {
            return "Cp437";
        }
        if (string.equals("cp865")) {
            return "Cp865";
        }
        if (string.equals("applemac")) {
            return "MacRoman";
        }
        if (string.equals("macce")) {
            return "MacCentralEurope";
        }
        if (!string.equals("next")) {
            if (string.equals("cp1250")) {
                return "Cp1250";
            }
            if (string.equals("cp1252") || string.equals("ansinew")) {
                return "Cp1252";
            }
            if (string.equals("cp1257")) {
                return "Cp1257";
            }
            if (string.equals("utf8")) {
                return "UTF-8";
            }
        }
        throw new Bib2GlsException(string);
    }

    public boolean suppressFieldExpansion() {
        return !this.expandFields;
    }

    public boolean useNonBreakSpace() {
        return this.useNonBreakSpace;
    }

    public String getGlsTeXHeader() {
        if (this.dateInHeader) {
            return this.getMessage("comment.header", NAME, "4.4", new Date());
        }
        return this.getMessage("comment.header.no_date", NAME, "4.4");
    }

    public boolean useInterpreter() {
        return this.interpret;
    }

    public L2HStringConverter getInterpreterListener() {
        return this.interpreter == null ? null : (L2HStringConverter)this.interpreter.getListener();
    }

    public TeXObjectList getWordExceptionList() {
        ControlSequence controlSequence = this.interpreter.getControlSequence("@mfu@nocaplist");
        if (controlSequence == null) {
            return null;
        }
        TeXObjectList teXObjectList = null;
        if (controlSequence instanceof GenericCommand) {
            teXObjectList = ((GenericCommand)controlSequence).getDefinition();
        }
        return teXObjectList;
    }

    public Vector<String> getPackages() {
        return this.packages;
    }

    public boolean hasNonASCIILabelSupport() {
        return this.hasNonASCIILabelSupport;
    }

    public boolean fontSpecLoaded() {
        return this.fontspec;
    }

    public boolean hyperrefLoaded() {
        return this.hyperref;
    }

    public boolean createHyperGroupsOn() {
        return this.createHyperGroups;
    }

    public void setCreateHyperGroups(boolean bl) {
        this.createHyperGroups = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseLog() throws IOException {
        String string = this.auxFile.getName();
        String string2 = string;
        int n = string2.lastIndexOf(".aux");
        if (n < 1) {
            this.debug("Can't determine log file from " + this.auxFile);
            return;
        }
        String string3 = string2.substring(0, n);
        string2 = string3 + ".log";
        this.texLogFile = new File(this.auxFile.getParentFile(), string2);
        if (!this.texLogFile.exists()) {
            this.warningMessage("error.no_log", this.texLogFile, NAME);
            return;
        }
        BufferedReader bufferedReader = null;
        for (String object : this.packages) {
            if (!object.equals("fontspec")) continue;
            this.fontspec = true;
            this.verboseMessage("message.detected.sty_no_version", object);
            break;
        }
        try {
            this.checkReadAccess(this.texLogFile);
            this.logMessage(this.getMessage("message.reading", this.texLogFile));
            this.logEncoding(this.texLogCharset);
            bufferedReader = this.createBufferedReader(this.texLogFile.toPath(), this.getTeXLogCharset());
            Iterator<String> iterator = null;
            while ((iterator = bufferedReader.readLine()) != null) {
                Matcher matcher = PATTERN_PACKAGE.matcher((CharSequence)((Object)iterator));
                if (matcher.matches()) {
                    String string4 = matcher.group(1).toLowerCase();
                    if (string4.equals("glossaries-extra")) {
                        try {
                            Calendar calendar = Calendar.getInstance();
                            calendar.set(2017, 1, 3);
                            int n2 = Integer.parseInt(matcher.group(2));
                            int n3 = Integer.parseInt(matcher.group(3));
                            int n4 = Integer.parseInt(matcher.group(4));
                            Calendar calendar2 = Calendar.getInstance();
                            calendar2.set(n2, n3 - 1, n4);
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
                            this.glossariesExtraVersion = simpleDateFormat.format(calendar2.getTime());
                            this.verboseMessage("message.detected.sty", string4, this.glossariesExtraVersion);
                            if (calendar2.compareTo(calendar) < 0) {
                                this.warningMessage("error.sty.too.old", "glossaries-extra", this.glossariesExtraVersion, simpleDateFormat.format(calendar.getTime()));
                                continue;
                            }
                            calendar.set(2018, 7, 18);
                            this.multiSuppSupported = calendar2.compareTo(calendar) >= 0;
                        }
                        catch (Exception exception) {
                            this.warningMessage("error.no.sty.version", "glossaries-extra");
                            this.debug(exception);
                        }
                        continue;
                    }
                    if (string4.equals("glossaries")) {
                        this.glossariesVersion = String.format("%s/%s/%s", matcher.group(2), matcher.group(3), matcher.group(4));
                        this.verboseMessage("message.detected.sty", string4, this.glossariesVersion);
                        continue;
                    }
                    if (string4.equals("mfirstuc")) {
                        this.mfirstucVersion = String.format("%s/%s/%s", matcher.group(2), matcher.group(3), matcher.group(4));
                        this.verboseMessage("message.detected.sty", string4, this.mfirstucVersion);
                        continue;
                    }
                    if (this.ignorePackages != null && this.ignorePackages.contains(string4)) continue;
                    if (string4.equals("hyperref")) {
                        this.hyperref = true;
                        continue;
                    }
                    if (string4.equals("fontspec")) {
                        if (this.fontspec) continue;
                        this.verboseMessage("message.detected.sty_no_version", string4);
                        this.fontspec = true;
                        continue;
                    }
                    if (Bib2Gls.isAutoSupportPackage(string4)) {
                        if (string4.equals("bpchem")) {
                            this.addBlocker("ce");
                        } else if (string4.equals("lipsum")) {
                            this.addBlocker("lipsum");
                        } else if (string4.equals("pifont")) {
                            this.addExclusion("ding");
                        } else if (string4.equals("siunitx")) {
                            this.addBlocker("num");
                            this.addBlocker("numlist");
                            this.addBlocker("numproduct");
                            this.addBlocker("numrange");
                            this.addBlocker("ang");
                            this.addBlocker("unit");
                            this.addBlocker("qty");
                            this.addBlocker("qtylist");
                            this.addBlocker("qtyproduct");
                            this.addBlocker("qtyrange");
                            this.addBlocker("complexnum");
                            this.addBlocker("complexqty");
                            this.addBlocker("si");
                            this.addBlocker("SI");
                            this.addBlocker("SIlist");
                            this.addBlocker("SIrange");
                        }
                        this.packages.add(string4);
                        continue;
                    }
                    if (string4.equals("twemojis")) {
                        this.addExclusion("twemoji");
                        continue;
                    }
                    if (!string4.equals("graphics")) continue;
                    this.addExclusion("includegraphics");
                    continue;
                }
                Matcher matcher2 = PATTERN_ENCDEF.matcher((CharSequence)((Object)iterator));
                if (matcher2.matches()) {
                    if (this.fontencList == null) {
                        this.fontencList = new Vector();
                    }
                    this.fontencList.add(matcher2.group(1));
                    continue;
                }
                if (!((String)((Object)iterator)).contains(string)) continue;
                break;
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        if (this.glossariesExtraVersion.equals("????/??/??")) {
            this.warningMessage("error.no_sty.version", "glossaries-extra", this.texLogFile);
        }
        if (this.isDebuggingOn() && this.packages.size() > 0) {
            if (this.packages.size() == 1) {
                this.debugMessage("message.1.sty", new Object[0]);
            } else {
                this.debugMessage("message.2.sty", this.packages.size());
            }
            for (String string5 : this.packages) {
                this.debug(string5);
            }
            this.debug();
        }
        if (this.glossariesVersion.compareTo("2023/09/29") >= 0) {
            if (this.glossariesExtraVersion.compareTo("2023/09/29") >= 0) {
                this.hasNewHyperGroupSupport = true;
            } else {
                this.warningMessage("warning.mismatched.sty", "glossaries", this.glossariesVersion, "glossaries-extra", this.glossariesExtraVersion);
            }
        }
        boolean bl = this.hasNewCaseSupport = this.mfirstucVersion.compareTo(MFIRSTUC208) >= 0;
        if (this.hasNewCaseSupport && this.glossariesVersion.compareTo(MFIRSTUC208) < 0) {
            this.hasNewCaseSupport = false;
            this.warningMessage("warning.mismatched.sty", "mfirstuc", this.mfirstucVersion, "glossaries", this.glossariesVersion);
        }
        if (this.hasNewCaseSupport && this.glossariesExtraVersion.compareTo(MFIRSTUC208) < 0) {
            this.hasNewCaseSupport = false;
            this.warningMessage("warning.mismatched.sty", "glossaries", this.glossariesVersion, "glossaries-extra", this.glossariesExtraVersion);
        }
        if (!(this.mfirstucProtectWasSet && this.mfirstucMProtectWasSet || !this.hasNewCaseSupport)) {
            this.verboseMessage("message.nomfirstuc.protect", new Object[0]);
            if (!this.mfirstucProtectWasSet) {
                this.mfirstucProtect = false;
                this.verboseMessage("message.default.arg", "--no-mfirstuc-protection", "--mfirstuc-protection");
            }
            if (!this.mfirstucMProtectWasSet) {
                this.mfirstucMProtect = false;
                this.verboseMessage("message.default.arg", "--no-mfirstuc-math-protection", "--mfirstuc-math-protection");
            }
        }
    }

    public String getGlossariesExtraVersion() {
        return this.glossariesExtraVersion;
    }

    public static boolean isAutoSupportPackage(String string) {
        for (String string2 : AUTO_SUPPORT_PACKAGES) {
            if (string2.compareToIgnoreCase(string) != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isExtraSupportedPackage(String string) {
        for (String string2 : EXTRA_SUPPORTED_PACKAGES) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isKnownPackage(String string) {
        return Bib2Gls.isAutoSupportPackage(string) || Bib2Gls.isExtraSupportedPackage(string);
    }

    private void initInterpreter(Vector<AuxData> vector) throws IOException {
        Object object;
        InterpreterListener interpreterListener = new InterpreterListener(this, vector, this.customPackages);
        interpreterListener.setSupportUnicodeScript(this.supportUnicodeSubSuperScripts);
        this.interpreter = this.createTeXParser(interpreterListener);
        this.interpreter.setCatCode(64, 11);
        this.mfirstucSty = (MfirstucSty)interpreterListener.usepackage(null, "mfirstuc", false);
        Vector<String> vector2 = this.getPackages();
        if (vector2 != null) {
            for (String object22 : vector2) {
                object = interpreterListener.usepackage(null, object22, false);
                if (this.fontencList == null || !object22.equals("fontenc")) continue;
                if (object == null || !(object instanceof FontEncSty)) {
                    object = interpreterListener.getFontEncSty();
                }
                if (object == null || !(object instanceof FontEncSty)) continue;
                for (String string : this.fontencList) {
                    this.debugMessage("message.detected.fontenc", string);
                    FontEncoding fontEncoding = ((FontEncSty)object).getEncoding(string.toUpperCase());
                    if (fontEncoding == null) continue;
                    fontEncoding.addDefinitions(this.interpreter.getSettings());
                }
                this.fontencList = null;
            }
        }
        if (this.datatoolSortMarkers) {
            interpreterListener.putControlSequence(interpreterListener.createSymbol("datatoolasciistart", 0));
            interpreterListener.putControlSequence(interpreterListener.createSymbol("datatoolpersoncomma", 28));
            interpreterListener.putControlSequence(interpreterListener.createSymbol("datatoolplacecomma", 29));
            interpreterListener.putControlSequence(interpreterListener.createSymbol("datatoolsubjectcomma", 30));
            interpreterListener.putControlSequence(interpreterListener.createSymbol("datatoolparenstart", 31));
            interpreterListener.putControlSequence(interpreterListener.createSymbol("datatoolctrlboundary", 31));
            interpreterListener.putControlSequence(interpreterListener.createSymbol("datatoolasciiend", 127));
            interpreterListener.putControlSequence(new LaTeXGenericCommand(true, "datatoolparen", "m", TeXParserUtils.createStack(interpreterListener, new TeXCsRef("datatoolctrlboundary"))));
            interpreterListener.putControlSequence(new AtSecondOfTwo("dtltexorsort"));
        } else {
            interpreterListener.putControlSequence(new GenericCommand("datatoolasciistart"));
            interpreterListener.putControlSequence(new TextualContentCommand("datatoolpersoncomma", ", "));
            interpreterListener.putControlSequence(new TextualContentCommand("datatoolplacecomma", ", "));
            interpreterListener.putControlSequence(new TextualContentCommand("datatoolsubjectcomma", ", "));
            interpreterListener.putControlSequence(new TextualContentCommand("datatoolparenstart", " "));
            interpreterListener.putControlSequence(new GenericCommand("datatoolctrlboundary"));
            interpreterListener.putControlSequence(new GenericCommand("datatoolasciiend"));
            interpreterListener.putControlSequence(new LaTeXGenericCommand(true, "datatoolparen", "m", TeXParserUtils.createStack(interpreterListener, new TeXCsRef("space"), interpreterListener.getOther(40), interpreterListener.getParam(1), interpreterListener.getOther(41))));
            interpreterListener.putControlSequence(new AtFirstOfTwo("dtltexorsort"));
        }
        interpreterListener.putControlSequence(new NewCommand("renewcommand", Overwrite.ALLOW));
        interpreterListener.putControlSequence(new NewCommand("glsxtrprovidecommand", Overwrite.ALLOW));
        interpreterListener.putControlSequence(new AtSecondOfTwo("IfNotBibGls"));
        interpreterListener.putControlSequence(new NoCaseChange("BibGlsNoCaseChange"));
        interpreterListener.putControlSequence(new MakeTextUppercase("bibglsuppercase"));
        interpreterListener.putControlSequence(new MakeTextLowercase("bibglslowercase"));
        interpreterListener.putControlSequence(new MakeTextLowercase("glslowercase"));
        interpreterListener.putControlSequence(new AtFirstOfOne("glsxtrrevert"));
        interpreterListener.putControlSequence(new GenericCommand(true, "bibglsfirstuc", null, new TeXCsRef("makefirstuc")));
        interpreterListener.putControlSequence(new CapitaliseWords(this.mfirstucSty, "bibglstitlecase"));
        interpreterListener.putControlSequence(new CapitaliseWords(this.mfirstucSty, "glscapitalisewords"));
        interpreterListener.putControlSequence(new GenericCommand(true, "BibGlsTitleCase", null, new TeXCsRef("BibGlsLongOrText")));
        interpreterListener.putControlSequence(new GenericCommand(true, "BibGlsTitleCasePlural", null, new TeXCsRef("BibGlsLongOrTextPlural")));
        Object object3 = interpreterListener.createStack();
        ((TeXObjectList)object3).add(new TeXCsRef("ifglshaslong"));
        Group group = interpreterListener.createGroup();
        ((TeXObjectList)object3).add(group);
        group.add(interpreterListener.getParam(1));
        Group group2 = interpreterListener.createGroup();
        ((TeXObjectList)object3).add(group2);
        group2.add(new TeXCsRef("glsxtrfieldtitlecase"));
        object = interpreterListener.createGroup();
        group2.add((TeXObject)object);
        ((TeXObjectList)object).add(interpreterListener.getParam(1));
        group2.add(interpreterListener.createGroup("long"));
        Group group3 = interpreterListener.createGroup();
        ((TeXObjectList)object3).add(group3);
        group3.add(new TeXCsRef("glsxtrfieldtitlecase"));
        object = interpreterListener.createGroup();
        group3.add((TeXObject)object);
        ((TeXObjectList)object).add(interpreterListener.getParam(1));
        group3.add(interpreterListener.createGroup("text"));
        interpreterListener.putControlSequence(new LaTeXGenericCommand(true, "BibGlsLongOrText", "m", (TeXObjectList)object3));
        object3 = interpreterListener.createStack();
        ((TeXObjectList)object3).add(new TeXCsRef("ifglshaslong"));
        Group group4 = interpreterListener.createGroup();
        ((TeXObjectList)object3).add(group4);
        group4.add(interpreterListener.getParam(1));
        Group group5 = interpreterListener.createGroup();
        ((TeXObjectList)object3).add(group5);
        group5.add(new TeXCsRef("glsxtrfieldtitlecase"));
        object = interpreterListener.createGroup();
        group5.add((TeXObject)object);
        ((TeXObjectList)object).add(interpreterListener.getParam(1));
        group5.add(interpreterListener.createGroup("longplural"));
        Group group6 = interpreterListener.createGroup();
        ((TeXObjectList)object3).add(group6);
        group6.add(new TeXCsRef("glsxtrfieldtitlecase"));
        object = interpreterListener.createGroup();
        group6.add((TeXObject)object);
        ((TeXObjectList)object).add(interpreterListener.getParam(1));
        group6.add(interpreterListener.createGroup("plural"));
        interpreterListener.putControlSequence(new LaTeXGenericCommand(true, "BibGlsLongOrTextPlural", "m", (TeXObjectList)object3));
        object3 = interpreterListener.createStack();
        ((TeXObjectList)object3).add(new TeXCsRef("ifglshasshort"));
        Group group7 = interpreterListener.createGroup();
        ((TeXObjectList)object3).add(group7);
        group7.add(interpreterListener.getParam(1));
        Group group8 = interpreterListener.createGroup();
        ((TeXObjectList)object3).add(group8);
        group8.add(new TeXCsRef("glsxtrfieldtitlecase"));
        object = interpreterListener.createGroup();
        group8.add((TeXObject)object);
        ((TeXObjectList)object).add(interpreterListener.getParam(1));
        group8.add(interpreterListener.createGroup("short"));
        Group group9 = interpreterListener.createGroup();
        ((TeXObjectList)object3).add(group9);
        group9.add(new TeXCsRef("glsxtrfieldtitlecase"));
        object = interpreterListener.createGroup();
        group9.add((TeXObject)object);
        ((TeXObjectList)object).add(interpreterListener.getParam(1));
        group9.add(interpreterListener.createGroup("text"));
        interpreterListener.putControlSequence(new LaTeXGenericCommand(true, "BibGlsShortOrText", "m", (TeXObjectList)object3));
        object3 = interpreterListener.createStack();
        ((TeXObjectList)object3).add(new TeXCsRef("ifglshasshort"));
        Group group10 = interpreterListener.createGroup();
        ((TeXObjectList)object3).add(group10);
        group10.add(interpreterListener.getParam(1));
        Group group11 = interpreterListener.createGroup();
        ((TeXObjectList)object3).add(group11);
        group11.add(new TeXCsRef("glsxtrfieldtitlecase"));
        object = interpreterListener.createGroup();
        group11.add((TeXObject)object);
        ((TeXObjectList)object).add(interpreterListener.getParam(1));
        group11.add(interpreterListener.createGroup("shortplural"));
        Group group12 = interpreterListener.createGroup();
        ((TeXObjectList)object3).add(group12);
        group12.add(new TeXCsRef("glsxtrfieldtitlecase"));
        object = interpreterListener.createGroup();
        group12.add((TeXObject)object);
        ((TeXObjectList)object).add(interpreterListener.getParam(1));
        group12.add(interpreterListener.createGroup("plural"));
        interpreterListener.putControlSequence(new LaTeXGenericCommand(true, "BibGlsShortOrTextPlural", "m", (TeXObjectList)object3));
        interpreterListener.putControlSequence(new GlsDisp());
        interpreterListener.putControlSequence(new GlsDisp("glslink"));
        interpreterListener.putControlSequence(new GlsDisp("dglslink"));
        interpreterListener.putControlSequence(new GlsDisp("dglsdisp"));
        interpreterListener.putControlSequence(new EnableTagging());
        interpreterListener.putControlSequence(new AtFirstOfTwo("bibglscontributorlist"));
        interpreterListener.putControlSequence(new AtFirstOfTwo("bibglshyperlink"));
        interpreterListener.putControlSequence(new GlsHyperLink(this));
        interpreterListener.putControlSequence(new BibGlsContributor(this));
        interpreterListener.putControlSequence(new BibGlsDateTime());
        interpreterListener.putControlSequence(new BibGlsDateTime("bibglsdate", true, false));
        interpreterListener.putControlSequence(new BibGlsDateTime("bibglstime", false, true));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsentryname", "name", this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsentrytext", "text", this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsentryshort", "short", this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsentrylong", "long", this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsentryfirst", "first", this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsentrysymbol", "symbol", this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsentryuseri", "user1", this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsentryuserii", "user2", this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsentryuseriii", "user3", this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsentryuseriv", "user4", this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsentryuserv", "user5", this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsentryuservi", "user6", this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsentryplural", "plural", this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsentryfirstplural", "firstplural", this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsentryshortpl", "shortplural", this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsentrylongpl", "longplural", this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsentrysymbolplural", "symbolplural", this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsentryname", "name", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsentrytext", "text", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsentryshort", "short", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsentrylong", "long", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsentryfirst", "first", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsentrysymbol", "symbol", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsentryuseri", "user1", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsentryuserii", "user2", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsentryuseriii", "user3", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsentryuseriv", "user4", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsentryuserv", "user5", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsentryuservi", "user6", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsentryplural", "plural", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsentryfirstplural", "firstplural", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsentryshortpl", "shortplural", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsentrylongpl", "longplural", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsentrysymbolplural", "symbolplural", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsaccessname", "name", this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsaccesstext", "text", this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsaccessshort", "short", this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsaccesslong", "long", this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsaccessfirst", "first", this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsaccesssymbol", "symbol", this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsaccessuseri", "user1", this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsaccessuserii", "user2", this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsaccessuseriii", "user3", this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsaccessuseriv", "user4", this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsaccessuserv", "user5", this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsaccessuservi", "user6", this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsaccessplural", "plural", this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsaccessfirstplural", "firstplural", this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsaccessshortpl", "shortplural", this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsaccesslongpl", "longplural", this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsaccesssymbolplural", "symbolplural", this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsaccessname", "name", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsaccesstext", "text", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsaccessshort", "short", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsaccesslong", "long", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsaccessfirst", "first", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsaccesssymbol", "symbol", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsaccessuseri", "user1", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsaccessuserii", "user2", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsaccessuseriii", "user3", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsaccessuseriv", "user4", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsaccessuserv", "user5", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsaccessuservi", "user6", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsaccessplural", "plural", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsaccessfirstplural", "firstplural", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsaccessshortpl", "shortplural", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsaccesslongpl", "longplural", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsaccesssymbolplural", "symbolplural", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsUseField(this));
        interpreterListener.putControlSequence(new GlsUseField("Glsxtrusefield", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsUseField("GLSxtrusefield", CaseChange.TO_UPPER, this));
        interpreterListener.putControlSequence(new GlsUseField("glsentrytitlecase", CaseChange.TITLE, this));
        interpreterListener.putControlSequence(new GlsUseField("glsxtrfieldtitlecase", CaseChange.TITLE, this));
        interpreterListener.putControlSequence(new GlsEntryParentName(this));
        interpreterListener.putControlSequence(new GenericCommand("glsxtrhiernamesep", null, interpreterListener.createString(".")));
        interpreterListener.putControlSequence(new GlsHierName(this));
        interpreterListener.putControlSequence(new GlsHierName("Glsxtrhiername", CaseChange.SENTENCE, true, this));
        interpreterListener.putControlSequence(new GlsHierName("GlsXtrhiername", CaseChange.SENTENCE, false, this));
        interpreterListener.putControlSequence(new GlsHierName("GLSxtrhiername", CaseChange.TO_UPPER, true, this));
        interpreterListener.putControlSequence(new GlsHierName("GLSXTRhiername", CaseChange.TO_UPPER, false, this));
        interpreterListener.putControlSequence(new AtFirstOfOne("MFUwordbreak"));
        interpreterListener.putControlSequence(new AtFirstOfOne("MFUskippunc"));
        interpreterListener.putControlSequence(new BibGlsDefinitionIndex(this));
        interpreterListener.putControlSequence(new BibGlsUseIndex(this));
        interpreterListener.putControlSequence(new IfGlsHasChildren(this));
        interpreterListener.putControlSequence(new GlsIfHasKey("ifglshasparent", "parent", this));
        interpreterListener.putControlSequence(new GlsIfHasKey("ifglshasdesc", "description", this));
        interpreterListener.putControlSequence(new GlsIfHasKey("ifglshassymbol", "symbol", this));
        interpreterListener.putControlSequence(new GlsIfHasKey("ifglshaslong", "long", this));
        interpreterListener.putControlSequence(new GlsIfHasKey("ifglshasshort", "short", this));
        interpreterListener.putControlSequence(new IfGlsFieldVoid(this));
        interpreterListener.putControlSequence(new Relax("glscurrentfieldvalue"));
        interpreterListener.putControlSequence(new GlsXtrIfHasField(this));
        interpreterListener.putControlSequence(new GlsXtrIfHasField("ifglshasfield", false, this));
        interpreterListener.putControlSequence(new GlsXtrIfFieldEqStr(this));
        interpreterListener.putControlSequence(new GlsXtrIfFieldEqStr("GlsXtrIfFieldEqXpStr", false, true, this));
        interpreterListener.putControlSequence(new GlsXtrIfFieldEqStr("GlsXtrIfXpFieldEqXpStr", true, true, this));
        interpreterListener.putControlSequence(new GlsXtrIfFieldEqStr("ifglsfieldeq", false, false, false, this));
        interpreterListener.putControlSequence(new GlsXtrIfHasNonZeroChildCount(this));
        interpreterListener.putControlSequence(interpreterListener.createSymbol("glshashchar", 35));
        interpreterListener.putControlSequence(interpreterListener.createSymbol("bibglshashchar", 35));
        interpreterListener.putControlSequence(interpreterListener.createSymbol("bibglsunderscorechar", 95));
        interpreterListener.putControlSequence(interpreterListener.createSymbol("bibglsdollarchar", 36));
        interpreterListener.putControlSequence(interpreterListener.createSymbol("bibglsampersandchar", 38));
        interpreterListener.putControlSequence(interpreterListener.createSymbol("bibglscircumchar", 94));
        interpreterListener.putControlSequence(interpreterListener.createSymbol("glsbackslash", 92));
        interpreterListener.putControlSequence(interpreterListener.createSymbol("glstildechar", 126));
        interpreterListener.putControlSequence(interpreterListener.createSymbol("glsopenbrace", 123));
        interpreterListener.putControlSequence(interpreterListener.createSymbol("glsclosebrace", 125));
        interpreterListener.putControlSequence(interpreterListener.createSymbol("bibglsaposchar", 39));
        interpreterListener.putControlSequence(interpreterListener.createSymbol("bibglsdoublequotechar", 34));
        interpreterListener.putControlSequence(new FlattenedPostSort());
        interpreterListener.putControlSequence(new FlattenedPreSort());
        interpreterListener.putControlSequence(new HrefChar());
        interpreterListener.putControlSequence(new AtSecondOfTwo("bibglshrefunicode"));
        interpreterListener.putControlSequence(new HexUnicodeChar());
        interpreterListener.putControlSequence(new DTLpadleadingzeros("bibglspaddigits"));
        interpreterListener.putControlSequence(new GlsCombinedSep());
        interpreterListener.putControlSequence(new GlsCombinedSep("glscombinedfirstsep"));
        interpreterListener.putControlSequence(new GlsCombinedSep("glscombinedsepfirst"));
        interpreterListener.putControlSequence(new GlsCombinedSep("glscombinedfirstsepfirst"));
        interpreterListener.putControlSequence(new GenericCommand(true, "glsxtrmultientryadjustednamesep", null, new TeXObject[]{new TeXCsRef("glscombinedfirstsepfirst")}));
        interpreterListener.putControlSequence(new GenericCommand(true, "glsxtrmultientryadjustednamepresep", null, new TeXObject[]{new TeXCsRef("glsxtrmultientryadjustednamesep")}));
        interpreterListener.putControlSequence(new GenericCommand(true, "glsxtrmultientryadjustednamepostsep", null, new TeXObject[]{new TeXCsRef("glsxtrmultientryadjustednamesep")}));
        interpreterListener.putControlSequence(new AtFirstOfOne("glsxtrmultientryadjustednamefmt"));
        interpreterListener.putControlSequence(new GenericCommand(true, "Glsxtrmultientryadjustednamefmt", null, new TeXObject[]{new TeXCsRef("makefirstuc")}));
        interpreterListener.putControlSequence(new GenericCommand(true, "GlsXtrmultientryadjustednamefmt", null, new TeXObject[]{new TeXCsRef("glscapitalisewords")}));
        interpreterListener.putControlSequence(new GenericCommand(true, "GLSxtrmultientryadjustednamefmt", null, new TeXObject[]{new TeXCsRef("mfirstucMakeUppercase")}));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("glsxtrmultientryadjustednameother", "name", CaseChange.NO_CHANGE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("Glsxtrmultientryadjustednameother", "name", CaseChange.SENTENCE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("GlsXtrmultientryadjustednameother", "name", CaseChange.TITLE, this));
        interpreterListener.putControlSequence(new GlsEntryFieldValue("GLSxtrmultientryadjustednameother", "name", CaseChange.TO_UPPER, this));
        interpreterListener.putControlSequence(new GlsXtrMultiEntryAdjustedName(this));
        interpreterListener.putControlSequence(new GlsXtrMultiEntryAdjustedName(this, "Glsxtrmultientryadjustedname", CaseChange.SENTENCE));
        interpreterListener.putControlSequence(new GlsXtrMultiEntryAdjustedName(this, "GlsXtrmultientryadjustedname", CaseChange.TITLE));
        interpreterListener.putControlSequence(new GlsXtrMultiEntryAdjustedName(this, "GLSxtrmultientryadjustedname", CaseChange.TO_UPPER));
        if (this.customPackages != null) {
            for (String string : this.customPackages) {
                interpreterListener.usepackage(null, string, false);
            }
        }
    }

    public void provideCommand(String string, String string2) {
        if (this.interpreter != null) {
            L2HStringConverter l2HStringConverter = (L2HStringConverter)this.interpreter.getListener();
            l2HStringConverter.putControlSequence(new GenericCommand(string, null, l2HStringConverter.createString(string2)));
        }
    }

    public void processPreamble(BibValueList bibValueList) throws IOException {
        if (this.interpreter == null) {
            return;
        }
        this.interpreter.addAll(bibValueList.expand(this.interpreter));
        if (this.isDebuggingOn()) {
            this.logAndPrintMessage(String.format("%n%s%n%s%n%n", this.getMessage("message.parsing.code"), this.interpreter.toString(this.interpreter)));
        }
        while (this.interpreter.size() > 0) {
            TeXObject teXObject = this.interpreter.pop();
            teXObject.process(this.interpreter);
        }
    }

    public String interpret(String string, TeXObjectList teXObjectList, boolean bl) {
        if (this.interpreter == null) {
            return string;
        }
        try {
            Object object;
            L2HStringConverter l2HStringConverter = (L2HStringConverter)this.interpreter.getListener();
            StringWriter stringWriter = new StringWriter();
            l2HStringConverter.setWriter(stringWriter);
            this.interpreter.addAll(teXObjectList);
            if (this.isDebuggingOn()) {
                this.logAndPrintMessage(String.format("%n%s%n%s%n%n", this.getMessage("message.parsing.code"), this.interpreter.toString(this.interpreter)));
            }
            while (this.interpreter.size() > 0) {
                object = this.interpreter.pop();
                object.process(this.interpreter);
            }
            object = stringWriter.toString();
            if (this.isDebuggingOn()) {
                this.logAndPrintMessage(String.format("texparserlib:--> %s", object));
            }
            object = ((String)object).replaceAll("<[^>]+>", "");
            object = ((String)object).replaceAll("\\&le;", "<");
            object = ((String)object).replaceAll("\\&ge;", ">");
            object = ((String)object).replaceAll("\\&amp;", "&");
            if (bl) {
                object = ((String)object).trim();
            }
            this.logMessage(String.format("texparserlib: %s -> %s", string, object));
            return object;
        }
        catch (IOException iOException) {
            if (this.isDebuggingOn()) {
                this.debug("texparserlib: ");
                this.debug(iOException);
            }
            return string;
        }
    }

    public String interpret(String string, BibValueList bibValueList, boolean bl) {
        if (this.interpreter == null) {
            return string;
        }
        try {
            TeXObjectList teXObjectList = bibValueList.expand(this.interpreter);
            if (teXObjectList == null) {
                return string;
            }
            teXObjectList = (TeXObjectList)teXObjectList.clone();
            return this.interpret(string, teXObjectList, bl);
        }
        catch (IOException iOException) {
            if (this.isDebuggingOn()) {
                this.debug("texparserlib: ");
                this.debug(iOException);
            }
            return string;
        }
    }

    public String convertToLabel(TeXParser teXParser, BibValueList bibValueList, GlsResource glsResource, boolean bl) throws IOException {
        Vector<PatternReplace> vector;
        String string;
        TeXObjectList teXObjectList = bibValueList.expand(teXParser);
        String string2 = string = teXObjectList.toString(teXParser);
        if (string.matches("(?s).*[\\\\\\{\\}\\~\\$].*")) {
            string = this.interpret(string, bibValueList, true);
        }
        if ((vector = glsResource.getLabelifySubstitutions()) != null) {
            for (PatternReplace patternReplace : vector) {
                string = patternReplace.replaceAll(string);
            }
        }
        String string3 = " \\.\\-\\+\\:\\;\\|\\/\\!\\?\\*\\<\\>\\@\\'\\`";
        string = bl ? string.replaceAll("[^," + (String)string3 + "\\p{IsAlphabetic}\\p{IsDigit}]", "") : string.replaceAll("[^" + (String)string3 + "\\p{IsAlphabetic}\\p{IsDigit}]", "");
        if (!this.fontSpecLoaded()) {
            string = Normalizer.normalize(string, Normalizer.Form.NFD);
            string = string.replaceAll("[^," + (String)string3 + "a-zA-Z0-9]", "");
        }
        if (bl) {
            string = string.replaceAll(",,+", ",");
            string = string.replaceAll("^,|,$", "");
        }
        if (this.isVerbose() && (!string2.equals(string) || this.isDebuggingOn())) {
            this.logMessage(String.format("%s: %s -> %s", bl ? "labelify-list" : "labelify", string2, string));
        }
        return string;
    }

    public String toTruncatedString(TeXParser teXParser, TeXObjectList teXObjectList) {
        return teXObjectList.toTruncatedString(teXParser, 40, this.getMessage("message.etc"));
    }

    public String truncate(String string) {
        if (string.length() < 160) {
            return string;
        }
        return string.substring(0, 160) + this.getMessage("message.etc");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void process() throws IOException, InterruptedException, Bib2GlsException {
        int n;
        void var8_14;
        String string;
        String string2;
        Vector<AuxData> vector;
        TeXParser teXParser;
        BibGlsAuxParser bibGlsAuxParser;
        Charset charset;
        block79: {
            try {
                this.parseLog();
            }
            catch (MalformedInputException malformedInputException) {
                this.warningMessage("error.cant.parse.file.malformed.input", this.texLogFile, this.getTeXLogCharset(), "--log-encoding", "--default-encoding");
                this.debug(malformedInputException);
            }
            catch (IOException iOException) {
                this.warningMessage("warning.cant.parse.file", this.texLogFile, iOException.getMessage());
                this.debug(iOException);
            }
            if (this.texCharset == null && this.fontspec) {
                try {
                    this.texCharset = Charset.forName("UTF-8");
                }
                catch (Exception exception) {
                    this.debug(exception);
                }
            }
            charset = this.texCharset == null ? this.getDefaultCharset() : this.texCharset;
            bibGlsAuxParser = new BibGlsAuxParser(this, charset);
            bibGlsAuxParser.setAllowCatCodeChangers(this.allowAuxCatChangers);
            teXParser = this.createTeXParser(bibGlsAuxParser);
            File file = teXParser.getBaseDir();
            if (this.dirName != null) {
                teXParser.setBaseDir(this.basePath);
            }
            try {
                bibGlsAuxParser.parseAuxFile(teXParser, this.auxFile);
                if (this.dirName == null) break block79;
                teXParser.setBaseDir(file);
            }
            catch (MalformedInputException malformedInputException) {
                this.warningMessage("error.cant.parse.file.malformed.input", this.auxFile, charset, "--tex-encoding", "--default-encoding");
                this.debug(malformedInputException);
                vector = bibGlsAuxParser.getAuxData();
                for (AuxData object2 : vector) {
                    string2 = object2.getName();
                    if (!string2.equals("glsxtr@texencoding")) continue;
                    try {
                        string = object2.getArg(0).toString(teXParser).trim();
                        this.verboseMessage("message.found", "\\glsxtr@texencoding{" + string + "}");
                        this.texCharset = string.equals("\\inputencodingname") ? Charset.forName("UTF-8") : Charset.forName(this.texToJavaCharset(string));
                        if (!this.texCharset.equals(charset)) {
                            this.message(this.getMessage("message.reparsing_aux", this.auxFile, this.texCharset));
                            vector.clear();
                            charset = this.texCharset;
                            bibGlsAuxParser.setCharSet(charset);
                            bibGlsAuxParser.parseAuxFile(teXParser, this.auxFile);
                            continue;
                        }
                        this.warningMessage("message.lost_records", new Object[0]);
                    }
                    catch (MalformedInputException malformedInputException2) {
                        this.warningMessage("error.cant.parse.file.malformed.input", this.auxFile, charset, "--tex-encoding", "--default-encoding");
                        this.debug(malformedInputException2);
                        this.warningMessage("message.lost_records", new Object[0]);
                    }
                    catch (Bib2GlsException bib2GlsException) {
                        if (this.texCharset != null) continue;
                        this.texCharset = this.getDefaultCharset();
                        this.warningMessage("error.unknown.tex.charset", bib2GlsException.getMessage(), this.texCharset, "--tex-encoding");
                    }
                }
            }
        }
        this.glsresources = new Vector();
        this.fields = new Vector();
        this.fieldMap = new HashMap();
        this.records = new Vector();
        this.seeRecords = new Vector();
        this.selectedEntries = new Vector();
        if (this.saveRecordCount) {
            this.recordCount = new HashMap();
        }
        if (this.provideknownGlossaries) {
            this.knownGlossaries = new Vector();
        }
        vector = bibGlsAuxParser.getAuxData();
        if (this.interpret) {
            this.initInterpreter(vector);
        }
        Vector<AuxData> vector2 = new Vector<AuxData>();
        Object object3 = "s";
        String string3 = "s";
        string2 = "s";
        string = "s";
        for (AuxData auxData : vector) {
            String string4;
            String string5;
            String string6;
            Object object;
            Object object2;
            Object object4;
            Object n3;
            String string7 = auxData.getName();
            if (string7.equals("glsxtr@resource")) {
                n3 = auxData.getArg(1);
                if (n3 instanceof TeXObjectList) {
                    for (int iterator = ((TeXObjectList)n3).size() - 1; iterator >= 0; --iterator) {
                        object4 = (TeXObject)((TeXObjectList)n3).get(iterator);
                        if (!(object4 instanceof CharObject) || ((CharObject)object4).getCharCode() != 34) continue;
                        ((TeXObjectList)n3).remove(iterator);
                    }
                }
                vector2.add(auxData);
                continue;
            }
            if (string7.equals("glsxtr@shortcutsval")) {
                if (this.shortcuts != null) continue;
                this.setShortCuts(auxData.getArg(0).toString(teXParser));
                continue;
            }
            if (string7.equals("glsxtr@pluralsuffixes")) {
                object3 = auxData.getArg(0).toString(teXParser);
                String string8 = auxData.getArg(1).toString(teXParser);
                string2 = auxData.getArg(2).toString(teXParser);
                string = auxData.getArg(3).toString(teXParser);
                continue;
            }
            if (string7.equals("@glsxtr@altmodifier")) {
                n3 = auxData.getArg(0).toString(teXParser).trim();
                if (((String)n3).isEmpty()) continue;
                this.altModifier = ((String)n3).codePointAt(0);
                continue;
            }
            if (string7.equals("@glsxtr@newglslike")) {
                this.addGlsLike(auxData.getArg(0).toString(teXParser), auxData.getArg(1).toString(teXParser).substring(1));
                continue;
            }
            if (string7.equals("@glsxtr@newglslikefamily")) {
                n3 = auxData.getArg(0).toString(teXParser).trim();
                String stringArray = auxData.getArg(1).toString(teXParser).trim();
                object4 = auxData.getArg(2).toString(teXParser).trim();
                object2 = auxData.getArg(3).toString(teXParser).trim();
                object = auxData.getArg(4).toString(teXParser).trim();
                string6 = auxData.getArg(5).toString(teXParser).trim();
                string5 = auxData.getArg(6).toString(teXParser).trim();
                string4 = auxData.getArg(7).toString(teXParser).trim();
                if (((String)object4).startsWith("\\")) {
                    object4 = ((String)object4).substring(1);
                }
                if (((String)object2).startsWith("\\")) {
                    object2 = ((String)object2).substring(1);
                }
                if (((String)object).startsWith("\\")) {
                    object = ((String)object).substring(1);
                }
                if (string6.startsWith("\\")) {
                    string6 = string6.substring(1);
                }
                if (string5.startsWith("\\")) {
                    string5 = string5.substring(1);
                }
                if (string4.startsWith("\\")) {
                    string4 = string4.substring(1);
                }
                this.addGlsLikeFamily((String)n3, stringArray, (String)object4, (String)object2, (String)object, string6, string5, string4);
                continue;
            }
            if (string7.equals("@glsxtr@multientry")) {
                this.addCompoundEntry(new CompoundEntry(auxData.getArg(1).toString(teXParser), auxData.getArg(3).toString(teXParser), auxData.getArg(2).toString(teXParser), auxData.getArg(0).toString(teXParser)));
                continue;
            }
            if (string7.equals("@glsxtr@mglsrefs")) {
                this.addMglsRef(auxData.getArg(0).toString(teXParser));
                continue;
            }
            if (string7.equals("@glsxtr@mglslike")) {
                this.addMglsCs(auxData.getArg(0).toString(teXParser));
                continue;
            }
            if (string7.equals("@glsxtr@prefixlabellist")) {
                String string9;
                n3 = auxData.getArg(0).toString(teXParser).split(",");
                if (n3 == null || ((String[])n3).length <= 0 || (string9 = n3[((String[])n3).length - 1]).isEmpty()) continue;
                this.addGlsLike(string9, "dgls");
                this.addGlsLike(string9, "dGls");
                this.addGlsLike(string9, "dGLS");
                this.addGlsLike(string9, "dglspl");
                this.addGlsLike(string9, "dGlspl");
                this.addGlsLike(string9, "dGLSpl");
                this.addGlsLike(string9, "dglslink");
                this.addGlsLike(string9, "dglsdisp");
                continue;
            }
            if (string7.equals("glsxtr@langtag")) {
                n3 = this.getLocale(auxData.getArg(0).toString(teXParser));
                this.setDocDefaultLocale((Locale)n3);
                this.addExtraProperties((Locale)n3);
                continue;
            }
            if (string7.equals("glsxtr@locale")) {
                n3 = this.getLocale(auxData.getArg(0).toString(teXParser));
                this.addExtraProperties((Locale)n3);
                continue;
            }
            if (string7.equals("glsxtr@texencoding")) {
                block80: {
                    try {
                        n3 = auxData.getArg(0).toString(teXParser).trim();
                        this.texCharset = ((String)n3).equals("\\inputencodingname") ? Charset.forName("UTF-8") : Charset.forName(this.texToJavaCharset((String)n3));
                    }
                    catch (Bib2GlsException n4) {
                        if (this.texCharset != null) break block80;
                        this.texCharset = this.getDefaultCharset();
                        this.warningMessage("error.unknown.tex.charset", n4.getMessage(), this.texCharset, "--tex-encoding");
                    }
                }
                if (this.texCharset.equals(charset)) continue;
                this.warningMessage("error.aux.charset.mismatch", charset, this.texCharset, "--tex-encoding");
                continue;
            }
            if (string7.equals("glsxtr@fields")) {
                n3 = CsvList.getList(teXParser, auxData.getArg(0));
                Iterator iterator = ((Vector)n3).iterator();
                while (iterator.hasNext()) {
                    object4 = (TeXObject)iterator.next();
                    object2 = (TeXObjectList)object4;
                    object = ((TeXObjectList)object2).popArg(teXParser);
                    string6 = object.toString(teXParser);
                    this.fields.add(string6);
                    object = ((TeXObjectList)object2).popArg(teXParser);
                    string5 = object.toString(teXParser);
                    if (!string5.equals(string6)) {
                        this.fieldMap.put(string6, string5);
                    }
                    if (!this.isDebuggingOn()) continue;
                    this.logAndPrintMessage("Adding field: " + string6 + " (" + string5 + ")");
                }
                continue;
            }
            if (string7.equals("glsxtr@recordsee")) {
                this.seeRecords.add(new GlsSeeRecord(auxData.getArg(0), auxData.getArg(1), teXParser));
                continue;
            }
            if (string7.equals("glsxtr@record") || this.useCiteAsRecord && string7.equals("citation") || string7.equals("glsxtr@record@nameref") || string7.equals("glsxtr@select@entry") || string7.equals("glsxtr@select@entry@nameref")) {
                Object object5;
                n3 = auxData.getArg(0).toString(teXParser);
                String[] stringArray = null;
                if (string7.startsWith("glsxtr@select@entry")) {
                    stringArray = ((String)n3).split(",");
                    n3 = stringArray[0];
                }
                string5 = null;
                string4 = null;
                String string10 = null;
                if (auxData.getNumArgs() >= 5) {
                    object4 = auxData.getArg(1).toString(teXParser);
                    object2 = auxData.getArg(2).toString(teXParser);
                    object = auxData.getArg(3).toString(teXParser);
                    string6 = auxData.getArg(4).toString(teXParser);
                    if (string6.isEmpty()) {
                        if (this.isDebuggingOn() && !((String)object).equals("glsignore")) {
                            this.logAndPrintMessage();
                            this.logAndPrintMessage(this.getMessage("message.empty.location.ignored", n3, object2, object));
                            this.logAndPrintMessage();
                        }
                        object = "glsignore";
                    }
                    if (auxData.getNumArgs() == 8) {
                        string5 = auxData.getArg(5).toString(teXParser);
                        string4 = auxData.getArg(6).toString(teXParser);
                        string10 = auxData.getArg(7).toString(teXParser);
                    }
                    if (((String)object2).equals("wrglossary") && (object5 = AuxData.getPageReference(vector, teXParser, "wrglossary." + string6)) != null) {
                        string6 = String.format("\\glsxtr@wrglossarylocation{%s}{%s}", string6, object5.toString(teXParser));
                    }
                } else {
                    if (((String)n3).equals("*")) {
                        this.verboseMessage("message.ignored.record", "\\citation{*}");
                        continue;
                    }
                    object4 = "";
                    object2 = "page";
                    object = "glsignore";
                    string6 = "";
                }
                object5 = string5 == null ? (stringArray == null ? new GlsRecord(this, (String)n3, (String)object4, (String)object2, (String)object, string6) : new GlsRecordSelection(this, stringArray, (String)object4, (String)object2, (String)object, string6)) : (stringArray == null ? new GlsRecordNameRef(this, (String)n3, (String)object4, (String)object2, (String)object, string6, string5, string4, string10) : new GlsRecordNameRefSelection(this, stringArray, (String)object4, (String)object2, (String)object, string6, string5, string4, string10));
                this.incRecordCount((GlsRecord)object5);
                boolean bl = false;
                for (int i = this.records.size() - 1; i >= 0; --i) {
                    GlsRecord glsRecord = this.records.get(i);
                    if (glsRecord.equals(object5)) {
                        bl = true;
                        break;
                    }
                    if (!glsRecord.partialMatch((GlsRecord)object5)) continue;
                    if (!glsRecord.resolveConflict((GlsRecord)object5)) {
                        this.records.add((GlsRecord)object5);
                    }
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.records.add((GlsRecord)object5);
                continue;
            }
            if (string7.equals("@mfu@excls")) {
                this.addExclusions(auxData.getArg(0));
                continue;
            }
            if (string7.equals("@mfu@blockers")) {
                this.addBlockers(auxData.getArg(0));
                continue;
            }
            if (string7.equals("@mfu@mappings")) {
                this.addMappings(CsvList.getList(teXParser, auxData.getArg(0)));
                continue;
            }
            if (this.knownGlossaries == null || !string7.equals("@newglossary")) continue;
            this.addGlossary(auxData.getArg(0).toString(teXParser));
        }
        this.updateGlsLikeFamilies();
        this.provideCommand("glspluralsuffix", (String)object3);
        this.provideCommand("abbrvpluralsuffix", (String)var8_14);
        this.provideCommand("acrpluralsuffix", string2);
        this.provideCommand("glsxtrabbrvpluralsuffix", string);
        if (this.texCharset == null) {
            this.texCharset = this.getDefaultCharset();
            this.logMessage(this.getMessage("message.unknown.tex.charset", this.texCharset, "--tex-encoding"));
        } else {
            this.verboseMessage("message.tex.charset", this.texCharset);
        }
        boolean bl = this.hasNonASCIILabelSupport = this.fontspec || "UTF-8".equals(this.texCharset.name()) && this.glossariesVersion.compareTo("2021/09/20") >= 0 && this.glossariesExtraVersion.compareTo("2021/09/20") >= 0;
        if (this.isVerbose()) {
            Iterator iterator = this.getDefaultLocale();
            this.logMessage(this.getMessage("message.default.locale", ((Locale)((Object)iterator)).toLanguageTag(), ((Locale)((Object)iterator)).getDisplayName()));
        }
        for (AuxData auxData : vector2) {
            this.glsresources.add(new GlsResource(teXParser, auxData, (String)object3, (String)var8_14));
        }
        if (this.glsresources.size() == 0) {
            throw new Bib2GlsException(this.getMessage("error.missing.aux.cs.require_cs_or", "glsxtr@resource", "glsxtrresourcefile", "GlsXtrLoadResources"));
        }
        if (this.fields.size() == 0) {
            this.warning(teXParser, this.getMessage("error.missing.aux.new.cs", "glsxtr@fields", "1.11"));
            this.fields.add("name");
            this.fields.add("sort");
            this.fieldMap.put("sort", "sortvalue");
            this.fields.add("type");
            this.fields.add("first");
            this.fields.add("firstplural");
            this.fieldMap.put("firstplural", "firstpl");
            this.fields.add("text");
            this.fields.add("plural");
            this.fields.add("description");
            this.fieldMap.put("description", "desc");
            this.fields.add("descriptionplural");
            this.fieldMap.put("description", "descplural");
            this.fields.add("symbol");
            this.fields.add("symbolplural");
            this.fields.add("user1");
            this.fieldMap.put("user1", "useri");
            this.fields.add("user2");
            this.fieldMap.put("user2", "userii");
            this.fields.add("user3");
            this.fieldMap.put("user3", "useriii");
            this.fields.add("user4");
            this.fieldMap.put("user4", "useriv");
            this.fields.add("user5");
            this.fieldMap.put("user5", "userv");
            this.fields.add("user6");
            this.fieldMap.put("user6", "uservi");
            this.fields.add("long");
            this.fields.add("longplural");
            this.fieldMap.put("long", "longpl");
            this.fields.add("short");
            this.fields.add("shortplural");
            this.fieldMap.put("short", "shortpl");
            this.fields.add("counter");
            this.fields.add("parent");
            this.fields.add("loclist");
            this.fields.add("see");
            this.fields.add("category");
        }
        if (this.useGroupField() && !this.fields.contains("group")) {
            this.warningMessage("warning.no_group_field", new Object[0]);
        }
        this.addField("dualshort");
        this.addField("dualshortplural");
        this.addField("duallong");
        this.addField("duallongplural");
        int n2 = 0;
        boolean bl2 = true;
        for (n = 0; n < this.glsresources.size(); ++n) {
            this.currentResource = this.glsresources.get(n);
            this.currentResource.parseBibFiles();
            if (!bl2 || this.forceCrossResourceRefs || this.currentResource.allowsCrossResourceRefs()) continue;
            this.debugMessage("message.cross-resource.notallowed", this.currentResource);
            bl2 = false;
        }
        if (bl2) {
            this.logMessage(this.getMessage("message.cross-resource.dep.allowed"));
            this.dependencies = new Vector();
            for (n = 0; n < this.glsresources.size(); ++n) {
                this.currentResource = this.glsresources.get(n);
                this.currentResource.processBibList();
            }
            for (n = 0; n < this.glsresources.size(); ++n) {
                this.currentResource = this.glsresources.get(n);
                int n3 = this.currentResource.processData();
                if (n3 <= 0) continue;
                n2 += n3;
            }
        } else {
            this.logMessage(this.getMessage("message.cross-resource.dep.notallowed", "--force-cross-resource-refs"));
            for (n = 0; n < this.glsresources.size(); ++n) {
                this.currentResource = this.glsresources.get(n);
                this.currentResource.processBibList();
                int n4 = this.currentResource.processData();
                if (n4 <= 0) continue;
                n2 += n4;
            }
        }
        this.currentResource = null;
        if (n2 == 0 && this.records.size() == 0) {
            this.error(this.getMessage("error.missing.records"));
        }
        if (this.glsresources.size() > 1) {
            this.message(this.getChoiceMessage("message.written.total", 0, "entry", 3, n2));
        }
        if (this.logWriter != null) {
            try {
                this.logWriter.close();
            }
            finally {
                this.logWriter = null;
            }
            this.message(this.getMessage("message.log.file", this.transcriptFile));
        }
    }

    public boolean isRetainFormat(String string) {
        if (this.retainFormatList == null) {
            return false;
        }
        return this.retainFormatList.contains(string);
    }

    public void registerDependencies(Bib2GlsEntry bib2GlsEntry) {
        if (this.dependencies == null || !bib2GlsEntry.hasDependencies()) {
            return;
        }
        Iterator<String> iterator = bib2GlsEntry.getDependencyIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            this.addDependent(string);
        }
    }

    public void addDependent(String string) {
        if (!this.dependencies.contains(string)) {
            this.verboseMessage("message.added.dep", string);
            this.dependencies.add(string);
        }
    }

    public boolean isDependent(String string) {
        return this.dependencies == null ? false : this.dependencies.contains(string);
    }

    public boolean hasCrossResourceDependencies() {
        return this.dependencies != null;
    }

    public Iterator<String> getDependencyIterator() {
        return this.dependencies == null ? null : this.dependencies.iterator();
    }

    public boolean isIgnored(GlsRecord glsRecord) {
        return this.isIgnoredFormat(glsRecord.getFormat());
    }

    public boolean isIgnoredFormat(String string) {
        return string.equals("glsignore") || string.equals("glstriggerrecordformat");
    }

    public GlsResource getCurrentResource() {
        return this.currentResource;
    }

    public boolean isLastResource(GlsResource glsResource) {
        return this.glsresources == null ? false : this.glsresources.lastElement() == glsResource;
    }

    public Vector<GlsResource> getResources() {
        return this.glsresources;
    }

    public Charset getTeXCharset() {
        return this.texCharset;
    }

    public Charset getTeXLogCharset() {
        return this.texLogCharset == null ? this.getDefaultCharset() : this.texLogCharset;
    }

    public boolean useCiteAsRecord() {
        return this.useCiteAsRecord;
    }

    public boolean mergeNameRefOnLocation() {
        return this.mergeNameRefOn == 2;
    }

    public boolean mergeNameRefOnTitle() {
        return this.mergeNameRefOn == 1;
    }

    public boolean mergeNameRefOnHref() {
        return this.mergeNameRefOn == 0;
    }

    public boolean mergeNameRefOnHcounter() {
        return this.mergeNameRefOn == 3;
    }

    public boolean mergeWrGlossaryLocations() {
        return this.mergeWrGlossaryLocations;
    }

    public boolean checkAcroShortcuts() {
        return this.checkAcroShortcuts;
    }

    public boolean checkAbbrvShortcuts() {
        return this.checkAbbrvShortcuts;
    }

    public int getAltModifier() {
        return this.altModifier;
    }

    public boolean isGlsLike(String string) {
        if (this.glsLikeMap == null) {
            return false;
        }
        return this.glsLikeMap.get(string) != null;
    }

    public void addGlsLike(String string, String string2) {
        if (this.glsLikeMap == null) {
            this.glsLikeMap = new HashMap();
        }
        GlsLike glsLike = new GlsLike(string, string2);
        this.glsLikeMap.put(string2, glsLike);
    }

    public GlsLike getGlsLike(String string) {
        return this.glsLikeMap == null ? null : this.glsLikeMap.get(string);
    }

    public String getGlsLikePrefix(String string) {
        GlsLike glsLike = this.getGlsLike(string);
        return glsLike == null ? null : glsLike.getPrefix();
    }

    private void updateGlsLikeFamilies() {
        GlsLike glsLike;
        if (this.glsLikeMap != null && this.glsLikeFamilies != null) {
            block0: for (String string : this.glsLikeMap.keySet()) {
                glsLike = this.glsLikeMap.get(string);
                if (glsLike.getFamily() != null) continue;
                for (GlsLikeFamily object : this.glsLikeFamilies) {
                    if (!object.hasMember(string)) continue;
                    glsLike.setFamily(object);
                    continue block0;
                }
            }
        } else if (this.glsLikeMap == null) {
            this.glsLikeMap = new HashMap();
        }
        this.addGlsFamily("gls", "glspl", "Gls", "Glspl", "GLS", "GLSpl");
        for (String string : this.glsLikeMap.keySet()) {
            glsLike = this.glsLikeMap.get(string);
            GlsLikeFamily glsLikeFamily = glsLike.getFamily();
            if (glsLikeFamily == null) {
                this.interpreter.putControlSequence(true, new GlsEntryFieldValue(glsLike.getName(), "text", CaseChange.NO_CHANGE, this, glsLike.getPrefix()));
                continue;
            }
            String string2 = glsLikeFamily.isPlural(string) ? "plural" : "text";
            this.interpreter.putControlSequence(true, new GlsEntryFieldValue(string, string2, glsLikeFamily.getMemberCase(string), this, glsLike.getPrefix()));
        }
    }

    private void addGlsFamily(String string, String string2, String string3, String string4, String string5, String string6) {
        GlsLikeFamily glsLikeFamily = new GlsLikeFamily();
        glsLikeFamily.setSingular(string);
        glsLikeFamily.setPlural(string2);
        glsLikeFamily.setSentence(string3);
        glsLikeFamily.setSentencePlural(string4);
        glsLikeFamily.setAllCaps(string5);
        glsLikeFamily.setAllCapsPlural(string6);
        GlsLike glsLike = new GlsLike("", string);
        glsLike.setFamily(glsLikeFamily);
        this.glsLikeMap.put(string, glsLike);
        glsLike = new GlsLike("", string2);
        glsLike.setFamily(glsLikeFamily);
        this.glsLikeMap.put(string2, glsLike);
        glsLike = new GlsLike("", string3);
        glsLike.setFamily(glsLikeFamily);
        this.glsLikeMap.put(string3, glsLike);
        glsLike = new GlsLike("", string4);
        glsLike.setFamily(glsLikeFamily);
        this.glsLikeMap.put(string4, glsLike);
        glsLike = new GlsLike("", string5);
        glsLike.setFamily(glsLikeFamily);
        this.glsLikeMap.put(string5, glsLike);
        glsLike = new GlsLike("", string6);
        glsLike.setFamily(glsLikeFamily);
        this.glsLikeMap.put(string6, glsLike);
    }

    private GlsLikeFamily findGlsLikeFamily(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        GlsLikeFamily glsLikeFamily = null;
        if (this.glsLikeFamilies != null) {
            for (GlsLikeFamily glsLikeFamily2 : this.glsLikeFamilies) {
                if (!string.equals(glsLikeFamily2.getOptions()) || !string2.equals(glsLikeFamily2.getPrefix())) continue;
                boolean bl = true;
                if (!string3.isEmpty() && glsLikeFamily2.hasSingular() || !string4.isEmpty() && glsLikeFamily2.hasPlural() || !string5.isEmpty() && glsLikeFamily2.hasSentence() || !string6.isEmpty() && glsLikeFamily2.hasSentencePlural() || !string7.isEmpty() && glsLikeFamily2.hasAllCaps() || !string8.isEmpty() && glsLikeFamily2.hasAllCapsPlural()) {
                    bl = false;
                }
                if (!bl) continue;
                break;
            }
        }
        return glsLikeFamily;
    }

    public void addGlsLikeFamily(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        GlsLikeFamily glsLikeFamily = null;
        if (this.glsLikeFamilies == null) {
            this.glsLikeFamilies = new Vector();
        } else if (string3.isEmpty() || string4.isEmpty() || string5.isEmpty() || string6.isEmpty() || string7.isEmpty() || string8.isEmpty()) {
            glsLikeFamily = this.findGlsLikeFamily(string, string2, string3, string4, string5, string6, string7, string8);
        }
        if (glsLikeFamily == null) {
            glsLikeFamily = new GlsLikeFamily();
            glsLikeFamily.setOptions(string);
            glsLikeFamily.setPrefix(string2);
            this.glsLikeFamilies.add(glsLikeFamily);
        }
        if (!string3.isEmpty()) {
            glsLikeFamily.setSingular(string3);
        }
        if (!string4.isEmpty()) {
            glsLikeFamily.setPlural(string4);
        }
        if (!string5.isEmpty()) {
            glsLikeFamily.setSentence(string5);
        }
        if (!string6.isEmpty()) {
            glsLikeFamily.setSentencePlural(string6);
        }
        if (!string7.isEmpty()) {
            glsLikeFamily.setAllCaps(string7);
        }
        if (!string8.isEmpty()) {
            glsLikeFamily.setAllCapsPlural(string8);
        }
    }

    public boolean isCaseExclusion(String string) {
        if (this.mfirstucExclusions == null) {
            return false;
        }
        return this.mfirstucExclusions.contains(string);
    }

    private void addExclusions(TeXObject teXObject) {
        if (this.mfirstucExclusions == null) {
            this.mfirstucExclusions = new Vector();
        }
        if (teXObject instanceof ControlSequence) {
            String string = ((ControlSequence)teXObject).getName();
            this.mfirstucExclusions.add(string);
            if (this.mfirstucSty != null) {
                this.mfirstucSty.addExclusion(string);
            }
        } else if (teXObject instanceof TeXObjectList) {
            TeXObjectList teXObjectList = (TeXObjectList)teXObject;
            for (int i = 0; i < teXObjectList.size(); ++i) {
                this.addExclusions((TeXObject)teXObjectList.get(i));
            }
        } else if (!(teXObject instanceof Ignoreable) && !(teXObject instanceof WhiteSpace)) {
            this.debugMessage("warning.exclusions.unknown.token", teXObject);
        }
    }

    private void addExclusion(String string) {
        if (this.mfirstucExclusions == null) {
            this.mfirstucExclusions = new Vector();
        }
        this.mfirstucExclusions.add(string);
        if (this.mfirstucSty != null) {
            this.mfirstucSty.addExclusion(string);
        }
    }

    public boolean isCaseBlocker(String string) {
        if (this.mfirstucBlockers == null) {
            return false;
        }
        return this.mfirstucBlockers.contains(string);
    }

    private void addBlockers(TeXObject teXObject) {
        if (this.mfirstucBlockers == null) {
            this.mfirstucBlockers = new Vector();
        }
        if (teXObject instanceof ControlSequence) {
            String string = ((ControlSequence)teXObject).getName();
            this.mfirstucBlockers.add(string);
            if (this.mfirstucSty != null) {
                this.mfirstucSty.addBlocker(string);
            }
        } else if (teXObject instanceof TeXObjectList) {
            TeXObjectList teXObjectList = (TeXObjectList)teXObject;
            for (int i = 0; i < teXObjectList.size(); ++i) {
                this.addBlockers((TeXObject)teXObjectList.get(i));
            }
        } else if (!(teXObject instanceof Ignoreable) && !(teXObject instanceof WhiteSpace)) {
            this.debugMessage("warning.blockers.unknown.token", teXObject);
        }
    }

    private void addBlocker(String string) {
        if (this.mfirstucBlockers == null) {
            this.mfirstucBlockers = new Vector();
        }
        this.mfirstucBlockers.add(string);
        if (this.mfirstucSty != null) {
            this.mfirstucSty.addBlocker(string);
        }
    }

    public String getCaseMapping(String string) {
        if (this.mfirstucMappings == null) {
            return null;
        }
        return this.mfirstucMappings.get(string);
    }

    private void addMappings(CsvList csvList) {
        if (this.mfirstucMappings == null) {
            this.mfirstucMappings = new HashMap();
        }
        for (int i = 0; i < csvList.size(); ++i) {
            TeXObject teXObject = csvList.getValue(i);
            if (teXObject instanceof TeXObjectList) {
                String string = null;
                String string2 = null;
                TeXObjectList teXObjectList = (TeXObjectList)teXObject;
                boolean bl = false;
                for (int j = 0; j < teXObjectList.size(); ++j) {
                    TeXObject teXObject2 = (TeXObject)teXObjectList.get(j);
                    if (teXObject2 instanceof Other && ((Other)teXObject2).getCharCode() == 61) {
                        bl = true;
                        continue;
                    }
                    ControlSequence controlSequence = this.getFirstCs(teXObject2);
                    if (controlSequence == null) continue;
                    if (bl) {
                        string2 = controlSequence.getName();
                        break;
                    }
                    string = controlSequence.getName();
                }
                if (string != null && string2 != null) {
                    this.mfirstucMappings.put(string, string2);
                    if (this.mfirstucSty == null) continue;
                    this.mfirstucSty.addMapping(string, string2);
                    continue;
                }
                this.debugMessage("warning.mappings.cant.parse", teXObject);
                continue;
            }
            if (teXObject instanceof Ignoreable || teXObject instanceof WhiteSpace) continue;
            this.debugMessage("warning.mappings.cant.parse", teXObject);
        }
    }

    private ControlSequence getFirstCs(TeXObject teXObject) {
        if (teXObject instanceof ControlSequence) {
            return (ControlSequence)teXObject;
        }
        if (teXObject instanceof TeXObjectList) {
            for (TeXObject teXObject2 : (TeXObjectList)teXObject) {
                ControlSequence controlSequence = this.getFirstCs(teXObject2);
                if (controlSequence == null) continue;
                return controlSequence;
            }
        }
        return null;
    }

    public boolean checkNestedLinkTextField(String string) {
        if (this.nestedLinkCheckFields == null) {
            return false;
        }
        for (int i = 0; i < this.nestedLinkCheckFields.length; ++i) {
            if (!string.equals(this.nestedLinkCheckFields[i])) continue;
            return true;
        }
        return false;
    }

    public void addMglsCs(String string) {
        String[] stringArray;
        if (this.mglsCs == null) {
            this.mglsCs = new Vector();
        }
        for (String string2 : stringArray = string.split(",")) {
            this.mglsCs.add(string2);
        }
    }

    public boolean isMglsCs(String string) {
        if (this.mglsCs == null) {
            return false;
        }
        return this.mglsCs.contains(string);
    }

    public void addMglsRef(String string) {
        String[] stringArray;
        if (this.mglsRefs == null) {
            this.mglsRefs = new Vector();
        }
        for (String string2 : stringArray = string.split(",")) {
            if (this.mglsRefs.contains(string2)) continue;
            this.debugMessage("message.mgls.found", string2);
            this.mglsRefs.add(string2);
        }
    }

    public boolean isMglsRefd(String string) {
        if (this.mglsRefs == null) {
            return false;
        }
        return this.mglsRefs.contains(string);
    }

    public Vector<String> getMglsRefdList() {
        return this.mglsRefs;
    }

    public CompoundEntry getCompoundEntry(String string) {
        if (this.compoundEntries == null) {
            return null;
        }
        return this.compoundEntries.get(string);
    }

    public void addCompoundEntry(CompoundEntry compoundEntry) {
        this.addCompoundEntry(compoundEntry, false);
    }

    public void addCompoundEntry(CompoundEntry compoundEntry, boolean bl) {
        String string = compoundEntry.getLabel();
        if (this.compoundEntries == null) {
            this.compoundEntries = new HashMap();
        } else if (!bl && this.compoundEntries.containsKey(string)) {
            return;
        }
        this.compoundEntries.put(string, compoundEntry);
    }

    public boolean hasCompoundEntries() {
        return this.compoundEntries != null;
    }

    public Iterator<String> getCompoundEntryKeyIterator() {
        if (this.compoundEntries == null) {
            return null;
        }
        return this.compoundEntries.keySet().iterator();
    }

    public Iterator<CompoundEntry> getCompoundEntryValueIterator() {
        if (this.compoundEntries == null) {
            return null;
        }
        return this.compoundEntries.values().iterator();
    }

    public CompoundEntry getCompoundEntryWithMain(String string) {
        if (this.compoundEntries == null) {
            return null;
        }
        Iterator<CompoundEntry> iterator = this.getCompoundEntryValueIterator();
        while (iterator.hasNext()) {
            CompoundEntry compoundEntry = iterator.next();
            if (!compoundEntry.getMainLabel().equals(string)) continue;
            return compoundEntry;
        }
        return null;
    }

    public CompoundEntry getUniqueCompoundEntryWithMain(String string) {
        if (this.compoundEntries == null) {
            return null;
        }
        CompoundEntry compoundEntry = null;
        Iterator<CompoundEntry> iterator = this.getCompoundEntryValueIterator();
        while (iterator.hasNext()) {
            CompoundEntry compoundEntry2 = iterator.next();
            if (!compoundEntry2.getMainLabel().equals(string)) continue;
            if (compoundEntry == null) {
                compoundEntry = compoundEntry2;
                continue;
            }
            return null;
        }
        return compoundEntry;
    }

    public boolean useGroupField() {
        return this.addGroupField;
    }

    public boolean isMultipleSupplementarySupported() {
        return this.multiSuppSupported;
    }

    public Vector<String> getFields() {
        return this.fields;
    }

    public void addField(String string) {
        if (!this.fields.contains(string)) {
            this.fields.add(string);
        }
    }

    public HashMap<String, String> getFieldMap() {
        return this.fieldMap;
    }

    public boolean isInternalField(String string) {
        return string.startsWith("bib2gls@");
    }

    public boolean isNonBibField(String string) {
        for (String string2 : NON_BIB_FIELDS) {
            if (!string2.equals(string)) continue;
            return true;
        }
        for (String string2 : PRIVATE_NON_BIB_FIELDS) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return this.isInternalField(string) || string.startsWith("bibtexentry@") || string.endsWith("endpunc") || string.startsWith("recordcount.") || string.startsWith("currcount@") || string.startsWith("prevcount@");
    }

    public boolean isPrivateNonBibField(String string) {
        for (String string2 : PRIVATE_NON_BIB_FIELDS) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return this.isInternalField(string) || string.startsWith("bibtexentry@") || string.startsWith("recordcount.") || string.startsWith("currcount@") || string.startsWith("prevcount@");
    }

    public String getFieldKey(String string) {
        for (String string2 : this.fields) {
            if (string2.equals(string)) {
                return string;
            }
            if (!string.equals(this.fieldMap.get(string2))) continue;
            return string2;
        }
        return string;
    }

    public boolean arePrefixFieldsKnown() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (String string : this.fields) {
            if (string.equals("prefix")) {
                bl = true;
                continue;
            }
            if (string.equals("prefixplural")) {
                bl2 = true;
                continue;
            }
            if (string.equals("prefixfirst")) {
                bl3 = true;
                continue;
            }
            if (!string.equals("prefixfirstplural")) continue;
            bl4 = true;
        }
        return bl && bl2 && bl3 && bl4;
    }

    public boolean isKnownField(String string) {
        if (this.fields.isEmpty()) {
            this.debug("Empty field list when checking for field '" + string + "'");
        }
        for (String string2 : this.fields) {
            if (string2.equals(string)) {
                return true;
            }
            if (!string.equals(this.fieldMap.get(string2))) continue;
            return true;
        }
        return false;
    }

    public boolean isKnownSpecialField(String string) {
        for (String string2 : SPAWN_SPECIAL_FIELDS) {
            if (!string2.equals(string)) continue;
            return true;
        }
        for (String string2 : DUAL_SPECIAL_FIELDS) {
            if (!string2.equals(string)) continue;
            return true;
        }
        for (String string2 : OTHER_SPECIAL_FIELDS) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isCheckNonBibFieldsOn() {
        return this.checkNonBibFields;
    }

    public boolean isWarnUnknownEntryTypesOn() {
        return this.warnUnknownEntryTypes;
    }

    public boolean isProvideGlossariesOn() {
        return this.knownGlossaries != null;
    }

    public boolean isKnownGlossary(String string) {
        return this.knownGlossaries != null && this.knownGlossaries.contains(string);
    }

    public void addGlossary(String string) {
        this.knownGlossaries.add(string);
    }

    public void selectedEntry(String string) {
        this.selectedEntries.add(string);
    }

    public boolean isEntrySelected(String string) {
        return this.selectedEntries.contains(string);
    }

    public boolean anyEntriesSelected() {
        return !this.selectedEntries.isEmpty();
    }

    public GlsSeeRecord getSeeRecord(String string) {
        for (GlsSeeRecord glsSeeRecord : this.seeRecords) {
            if (!glsSeeRecord.getLabel().equals(string)) continue;
            return glsSeeRecord;
        }
        return null;
    }

    public Vector<GlsRecord> getRecords() {
        return this.records;
    }

    public Vector<GlsSeeRecord> getSeeRecords() {
        return this.seeRecords;
    }

    public boolean hasRecord(String string) {
        for (GlsRecord glsRecord : this.records) {
            if (!string.equals(glsRecord.getLabel())) continue;
            return true;
        }
        return false;
    }

    public boolean hasSeeRecord(String string) {
        for (GlsSeeRecord glsSeeRecord : this.seeRecords) {
            if (!string.equals(glsSeeRecord.getLabel())) continue;
            return true;
        }
        return false;
    }

    public GlsRecord getRecordCountKey(GlsRecord glsRecord) {
        if (this.recordCount == null) {
            return null;
        }
        Set<GlsRecord> set = this.recordCount.keySet();
        for (GlsRecord glsRecord2 : set) {
            boolean bl;
            boolean bl2 = bl = glsRecord2.getLabel().equals(glsRecord.getLabel()) && glsRecord2.getCounter().equals(glsRecord.getCounter());
            if (this.saveRecordCountUnit) {
                boolean bl3 = bl = bl && glsRecord2.getLocation().equals(glsRecord.getLocation());
            }
            if (!bl) continue;
            return glsRecord2;
        }
        return null;
    }

    public boolean isRecordCountSet() {
        return this.recordCount != null;
    }

    public Set<GlsRecord> getRecordCountKeySet() {
        return this.recordCount == null ? null : this.recordCount.keySet();
    }

    public Integer getRecordCount(GlsRecord glsRecord) {
        return this.recordCount == null ? null : this.recordCount.get(glsRecord);
    }

    public void writeRecordCount(String string, PrintWriter printWriter) throws IOException {
        Set<GlsRecord> set = this.getRecordCountKeySet();
        if (set == null) {
            return;
        }
        int n = 0;
        for (GlsRecord glsRecord : set) {
            if (!glsRecord.getLabel().equals(string)) continue;
            Integer n2 = this.getRecordCount(glsRecord);
            n += n2.intValue();
            printWriter.format("\\bibglssetrecordcount{%s}{%s}{%d}%n", string, glsRecord.getCounter(), n2);
            if (!this.saveRecordCountUnit) continue;
            printWriter.format("\\bibglssetlocationrecordcount{%s}{%s}{%s}{%d}%n", string, glsRecord.getCounter(), glsRecord.getLocation(), n2);
        }
        printWriter.format("\\bibglssettotalrecordcount{%s}{%d}%n", string, n);
    }

    public String replaceSpecialChars(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            int n2 = string.codePointAt(n);
            n += Character.charCount(n2);
            if (n2 == 92) {
                if (n < string.length() && string.substring(n).startsWith("char`\\")) {
                    int n3 = string.codePointAt(n + 6);
                    int n4 = Character.charCount(n3);
                    String string2 = this.getCsNameForLiteral(n3);
                    if (string2 != null) {
                        stringBuilder.append("\\" + string2 + " ");
                        bl = true;
                    } else {
                        stringBuilder.append(string.substring(n - 1, n + 6 + n4));
                    }
                    n = n + 6 + n4;
                    continue;
                }
                stringBuilder.append("\\glsbackslash ");
                bl = true;
                continue;
            }
            String string3 = this.getCsNameForLiteral(n2);
            if (string3 != null) {
                stringBuilder.append("\\" + string3 + " ");
                bl = true;
                continue;
            }
            if (bl && Character.isWhitespace(n2)) {
                stringBuilder.append("\\space");
            }
            bl = false;
            stringBuilder.appendCodePoint(n2);
        }
        return stringBuilder.toString();
    }

    public String getCsNameForLiteral(int n) {
        switch (n) {
            case 92: {
                return "glsbackslash";
            }
            case 37: {
                return "glspercentchar";
            }
            case 123: {
                return "glsopenbrace";
            }
            case 125: {
                return "glsclosebrace";
            }
            case 126: {
                return "glstildechar";
            }
            case 35: {
                return "bibglshashchar";
            }
            case 95: {
                return "bibglsunderscorechar";
            }
            case 36: {
                return "bibglsdollarchar";
            }
            case 38: {
                return "bibglsampersandchar";
            }
            case 94: {
                return "bibglscircumchar";
            }
            case 39: {
                if (!this.replaceQuotes) break;
                return "bibglsaposchar";
            }
            case 34: {
                if (!this.replaceQuotes) break;
                return "bibglsdoublequotechar";
            }
            case 0: {
                if (!this.datatoolSortMarkers) break;
                return "datatoolasciistart";
            }
            case 28: {
                if (!this.datatoolSortMarkers) break;
                return "datatoolpersoncomma";
            }
            case 29: {
                if (!this.datatoolSortMarkers) break;
                return "datatoolplacecomma";
            }
            case 30: {
                if (!this.datatoolSortMarkers) break;
                return "datatoolsubjectcomma";
            }
            case 31: {
                if (!this.datatoolSortMarkers) break;
                return "datatoolctrlboundary";
            }
            case 127: {
                if (!this.datatoolSortMarkers) break;
                return "datatoolasciiend";
            }
        }
        return null;
    }

    public boolean hasNewHyperGroupSupport() {
        return this.hasNewHyperGroupSupport;
    }

    public boolean isCollapseSamePageRangeOn() {
        return this.collapseSamePageRange;
    }

    public String getFormatMapping(String string) {
        return this.formatMap.get(string);
    }

    public void writeCommonCommands(PrintWriter printWriter) throws IOException {
        if (this.commonCommandsDone) {
            return;
        }
        if (this.replaceQuotes) {
            printWriter.println("\\providecommand{\\bibglsaposchar}{\\string'}");
            printWriter.println("\\providecommand{\\bibglsdoublequotechar}{\\string\"}");
        }
        printWriter.println("\\providecommand{\\bibglshashchar}{\\expandafter\\@gobble\\string\\#}");
        printWriter.println("\\providecommand{\\bibglscircumchar}{\\expandafter\\@gobble\\string\\^}");
        printWriter.println("\\providecommand{\\bibglsdollarchar}{\\expandafter\\@gobble\\string\\$}");
        printWriter.println("\\providecommand{\\bibglsampersandchar}{\\expandafter\\@gobble\\string\\&}");
        printWriter.println("\\providecommand{\\bibglsunderscorechar}{\\expandafter\\@gobble\\string\\_}");
        printWriter.println("\\providecommand{\\bibglshrefchar}[2]{\\glspercentchar #1}");
        if (this.fontspec) {
            printWriter.println("\\providecommand{\\bibglshrefunicode}[2]{#2}");
        }
        if (this.hyperref) {
            printWriter.println("\\providecommand{\\bibglshexunicodechar}[1]{\\csname ifHy@unicode\\endcsname\\texorpdfstring{\\symbol{\\string\"#1}}{\\unichar{\\string\"#1}}\\else\\symbol{\\string\"#1}\\fi}");
        } else {
            printWriter.println("\\providecommand{\\bibglshexunicodechar}[1]{\\symbol{\\string\"#1}}");
        }
        printWriter.println("\\providecommand{\\bibglsusesee}[1]{\\glsxtrusesee{#1}}");
        printWriter.println("\\providecommand{\\bibglsusealias}[1]{%");
        printWriter.println(" \\glsxtrifhasfield{alias}{#1}%");
        printWriter.println(" {\\expandafter\\glsseeformat\\expandafter{\\glscurrentfieldvalue}{}}%");
        printWriter.println(" {}%");
        printWriter.println("}");
        printWriter.println("\\providecommand{\\bibglsuseseealso}[1]{\\glsxtruseseealso{#1}}");
        printWriter.println("\\providecommand{\\bibglsdelimN}{\\delimN}");
        printWriter.println("\\providecommand{\\bibglslastDelimN}{,~}");
        printWriter.println("\\providecommand{\\bibglsrange}[1]{#1}");
        printWriter.println("\\providecommand{\\bibglsinterloper}[1]{#1\\bibglsdelimN }");
        printWriter.println("\\providecommand{\\bibglspassim}{ \\bibglspassimname}");
        printWriter.println("\\providecommand*{\\bibglshyperlink}[2]{\\glshyperlink[#1]{#2}}");
        printWriter.println();
        if (this.hasNewCaseSupport) {
            printWriter.println("\\providecommand{\\bibglsuppercase}{\\glsuppercase}");
            printWriter.println("\\providecommand{\\bibglslowercase}{\\glslowercase}");
        } else {
            printWriter.println("\\providecommand{\\bibglsuppercase}{\\MakeTextUppercase}");
            printWriter.println("\\providecommand{\\bibglslowercase}{\\MakeTextLowercase}");
        }
        printWriter.println("\\providecommand{\\bibglsfirstuc}{\\makefirstuc}");
        printWriter.println("\\providecommand{\\bibglstitlecase}{\\capitalisewords}");
        printWriter.println("\\providecommand{\\BibGlsNoCaseChange}[1]{#1}");
        printWriter.println();
        printWriter.println("\\providecommand{\\bibglsprimaryprefixlabel}[1]{}");
        printWriter.println("\\providecommand{\\bibglsdualprefixlabel}[1]{}");
        printWriter.println("\\providecommand{\\bibglstertiaryprefixlabel}[1]{}");
        printWriter.println("\\providecommand{\\bibglsexternalprefixlabel}[2]{}");
        printWriter.println();
        if (this.recordCount != null) {
            printWriter.println("\\ifdef\\glsxtrenablerecordcount %glossaries-extra.sty v1.21+");
            printWriter.println("{\\glsxtrenablerecordcount}");
            printWriter.println("{");
            printWriter.println(" \\PackageWarning{bib2gls}{You need at least v1.21 of glossaries-extra with --record-count or --record-count-unit}");
            printWriter.println("}");
            printWriter.println();
            printWriter.println("\\providecommand*{\\bibglssetrecordcount}[3]{%");
            printWriter.println("   \\GlsXtrSetField{#1}{recordcount.#2}{#3}%");
            printWriter.println("}");
            printWriter.println("\\providecommand*{\\bibglssettotalrecordcount}[2]{%");
            printWriter.println("   \\GlsXtrSetField{#1}{recordcount}{#2}%");
            printWriter.println("}");
            if (this.saveRecordCountUnit) {
                printWriter.println("\\ifdef\\glsxtrdetoklocation");
                printWriter.println("{% glossaries-extra v1.21+");
                printWriter.println("  \\providecommand*{\\bibglssetlocationrecordcount}[4]{%");
                printWriter.println("     \\GlsXtrSetField{#1}{recordcount.#2.\\glsxtrdetoklocation{#3}}{#4}%");
                printWriter.println("  }");
                printWriter.println("}");
                printWriter.println("{");
                printWriter.println("  \\providecommand*{\\bibglssetlocationrecordcount}[4]{%");
                printWriter.println("     \\GlsXtrSetField{#1}{recordcount.#2.#3}{#4}%");
                printWriter.println("  }");
                printWriter.println("}");
            }
        }
        if (this.glossariesExtraVersion.compareTo("2021/09/20") <= 0) {
            printWriter.println("\\providecommand*{\\glsxtrapptocsvfield}[3]{%");
            printWriter.println(" \\ifcsdef{glo@\\glsdetoklabel{#1}@#2}%");
            printWriter.println(" {\\csappto{glo@\\glsdetoklabel{#1}@#2}{,#3}}%");
            printWriter.println(" {\\csdef{glo@\\glsdetoklabel{#1}@#2}{#3}}%");
            printWriter.println("}");
        }
        this.commonCommandsDone = true;
    }

    public void incRecordCount(GlsRecord glsRecord) {
        if (this.recordCount == null) {
            return;
        }
        GlsRecord glsRecord2 = this.getRecordCountKey(glsRecord);
        if (this.recordCountRule.isAllowed(glsRecord)) {
            if (glsRecord2 == null) {
                this.recordCount.put(glsRecord, 1);
            } else {
                Integer n = this.recordCount.get(glsRecord2);
                this.recordCount.put(glsRecord2, n + 1);
            }
        }
    }

    public boolean mfirstucProtection() {
        return this.mfirstucProtect;
    }

    public boolean mfirstucMathShiftProtection() {
        return this.mfirstucMProtect;
    }

    public String[] mfirstucProtectionFields() {
        return this.mfirstucProtectFields;
    }

    public AuxInputAction getAuxInputAction() {
        return this.auxInputAction;
    }

    public TeXParser createTeXParser(TeXParserListener teXParserListener) {
        TeXParser teXParser = new TeXParser(teXParserListener);
        teXParser.setBaseDir(new File("."));
        if (this.debugLevel > 0) {
            teXParser.setDebugMode(this.debugLevel, this.logWriter);
        }
        return teXParser;
    }

    public void logEncodingDetected(Charset charset) {
        this.logMessage(this.getMessage("message.detected.charset", charset));
    }

    public void logEncoding(Charset charset) {
        if (charset == null) {
            this.logMessage(this.getMessage("message.charset", this.getMessage("message.null")));
        } else {
            this.logMessage(this.getMessage("message.charset", charset.name()));
        }
    }

    public void logEncoding(String string) {
        if (string == null) {
            this.logMessage(this.getMessage("message.charset", this.getMessage("message.null")));
        } else {
            this.logMessage(this.getMessage("message.charset", string));
        }
    }

    public void logDefaultEncoding(Charset charset) {
        if (charset == null) {
            this.logMessage(this.getMessage("message.default.charset", this.getMessage("message.null")));
        } else {
            this.logMessage(this.getMessage("message.default.charset", charset.name()));
        }
    }

    public void logDefaultEncoding(String string) {
        if (string == null) {
            this.logMessage(this.getMessage("message.default.charset", this.getMessage("message.null")));
        } else {
            this.logMessage(this.getMessage("message.default.charset", string));
        }
    }

    @Override
    public void logMessageNoLn(String string) {
        if (this.logWriter != null) {
            this.logWriter.print(string);
        } else if (this.pendingWriter != null) {
            this.pendingWriter.print(string);
        }
    }

    @Override
    public void logMessage(String string) {
        if (this.logWriter != null) {
            this.logWriter.println(string);
        } else if (this.pendingWriter != null) {
            this.pendingWriter.println(string);
        }
    }

    @Override
    public void logMessage() {
        if (this.logWriter != null) {
            this.logWriter.println();
        } else if (this.pendingWriter != null) {
            this.pendingWriter.println();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public void error(Exception exception) {
        block10: {
            if (exception instanceof TeXSyntaxException) {
                TeXParser teXParser = ((TeXSyntaxException)exception).getParser();
                if (teXParser == null || teXParser.getListener() instanceof Bib2GlsBibParser) {
                    this.error(((TeXSyntaxException)exception).getMessage(this));
                    break block10;
                } else {
                    this.warning(((TeXSyntaxException)exception).getMessage(this));
                    if (this.isDebuggingOn()) {
                        exception.printStackTrace();
                        for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
                            this.logMessage(stackTraceElement.toString());
                        }
                    }
                    return;
                }
            }
            if (exception instanceof NoSuchFileException) {
                this.error(this.getMessage("tex.error.file.not.found", ((NoSuchFileException)exception).getFile()));
            } else {
                void var2_5;
                String string = exception.getMessage();
                if (string == null) {
                    String string2 = exception.getClass().getSimpleName();
                }
                this.error((String)var2_5);
            }
        }
        if (this.isDebuggingOn()) {
            exception.printStackTrace();
            for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
                this.logMessage(stackTraceElement.toString());
            }
        }
        this.exitCode = 2;
    }

    @Override
    public void debug(Throwable throwable) {
        if (this.isDebuggingOn()) {
            String string = throwable.getMessage();
            if (string == null) {
                string = throwable.getClass().getSimpleName();
            }
            this.logAndPrintMessage(string);
            throwable.printStackTrace();
            if (this.logWriter != null) {
                throwable.printStackTrace(this.logWriter);
            } else if (this.pendingWriter != null) {
                throwable.printStackTrace(this.pendingWriter);
            }
        }
    }

    public void debug(String string, Throwable throwable) {
        if (this.isDebuggingOn()) {
            String string2 = throwable.getMessage();
            if (string2 == null) {
                string2 = throwable.getClass().getSimpleName();
            }
            if (string != null) {
                string2 = string + string2;
            }
            this.logAndPrintMessage(string2);
            throwable.printStackTrace();
            if (this.logWriter != null) {
                throwable.printStackTrace(this.logWriter);
            } else if (this.pendingWriter != null) {
                throwable.printStackTrace(this.pendingWriter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String kpsewhich(String string) throws IOException, InterruptedException {
        String string2 = this.kpsewhichResults.get(string);
        if (string2 != null) {
            return string2;
        }
        this.debug(this.getMessageWithFallback("message.running", "Running {0}", String.format("kpsewhich '%s'", string)));
        Process process = null;
        int n = -1;
        try {
            process = new ProcessBuilder("kpsewhich", string).start();
            n = process.waitFor();
        }
        catch (Exception exception) {
            this.debug(exception);
            return null;
        }
        String string3 = null;
        if (n == 0) {
            InputStream inputStream = process.getInputStream();
            if (inputStream == null) {
                throw new IOException(this.getMessageWithFallback("error.cant.open.process.stream", "Unable to open input stream from process: {0}", String.format("kpsewhich '%s'", string)));
            }
            try (BufferedReader bufferedReader = null;){
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                string3 = bufferedReader.readLine();
                this.debug(this.getMessageWithFallback("message.process.result", "Processed returned: {0}", string3));
            }
        } else if (this.isDebuggingOn()) {
            this.logAndPrintMessage(this.getMessageWithFallback("error.app_failed", "{0} failed with exit code {1}", String.format("kpsewhich '%s'", string), n));
        }
        this.kpsewhichResults.put(string, string3);
        return string3;
    }

    public TeXPath getBibFilePath(TeXParser teXParser, String string) throws IOException, InterruptedException {
        TeXPath teXPath = new TeXPath(teXParser, string, "bib", false);
        File file = teXPath.getFile();
        if (!file.exists()) {
            Object object;
            this.debug(this.getMessage("error.file.not.found", file));
            File file2 = file;
            if (this.basePath.equals(this.cwd)) {
                object = this.auxFile.getParentFile();
                file2 = new File((File)object, file.getName());
            } else {
                file2 = this.resolvePath(teXPath.getRelativePath()).toFile();
                if (!file2.exists()) {
                    this.debug(this.getMessage("error.file.not.found", file2));
                    object = this.auxFile.getParentFile();
                    file2 = new File((File)object, file.getName());
                }
            }
            if (!file2.exists() && (object = this.kpsewhich(file.getName())) != null && !((String)object).isEmpty()) {
                return new TeXPath(teXParser, (String)object, "", false);
            }
            if (file2.exists()) {
                teXPath = new TeXPath(teXParser, file2);
            } else {
                this.debug(this.getMessage("error.file.not.found", file2));
            }
        }
        return teXPath;
    }

    public String getTeXPathHref(TeXPath teXPath) {
        int n;
        String string = teXPath.toString();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (n == 45 || n == 46 || n == 58 || n >= 47 && n <= 57 || n >= 65 && n <= 90 || n >= 97 && n <= 122) {
                stringBuilder.appendCodePoint(n);
                continue;
            }
            if (this.fontspec && n > 127) {
                stringBuilder.append(String.format("\\bibglshrefunicode{%02X}{%s}", n, new String(Character.toChars(n))));
                continue;
            }
            if (n == 92) {
                stringBuilder.append(String.format("\\bibglshrefchar{%02X}{\\glsbackslash }", n));
                continue;
            }
            if (n == 37) {
                stringBuilder.append(String.format("\\bibglshrefchar{%02X}{\\glspercentchar }", n));
                continue;
            }
            if (n == 35) {
                stringBuilder.append(String.format("\\bibglshrefchar{%02X}{\\bibglshashchar }", n));
                continue;
            }
            if (n == 36) {
                stringBuilder.append(String.format("\\bibglshrefchar{%02X}{\\bibglsdollarchar }", n));
                continue;
            }
            if (n == 95) {
                stringBuilder.append(String.format("\\bibglshrefchar{%02X}{\\bibglsunderscorechar }", n));
                continue;
            }
            if (n == 38) {
                stringBuilder.append(String.format("\\bibglshrefchar{%02X}{\\bibglsampersandchar }", n));
                continue;
            }
            if (n == 94) {
                stringBuilder.append(String.format("\\bibglshrefchar{%02X}{\\bibglscircumchar }", n));
                continue;
            }
            if (n == 123) {
                stringBuilder.append(String.format("\\bibglshrefchar{%02X}{\\glsopenbrace }", n));
                continue;
            }
            if (n == 125) {
                stringBuilder.append(String.format("\\bibglshrefchar{%02X}{\\glsclosebrace }", n));
                continue;
            }
            if (n == 126) {
                stringBuilder.append(String.format("\\bibglshrefchar{%02X}{\\glstildechar }", n));
                continue;
            }
            stringBuilder.append(String.format("\\bibglshrefchar{%02X}{%s}", n, new String(Character.toChars(n))));
        }
        return stringBuilder.toString();
    }

    public static boolean isScriptDigit(int n) {
        return Bib2Gls.isSubscriptDigit(n) || Bib2Gls.isSuperscriptDigit(n);
    }

    public static boolean isSubscriptDigit(int n) {
        switch (n) {
            case 8320: 
            case 8321: 
            case 8322: 
            case 8323: 
            case 8324: 
            case 8325: 
            case 8326: 
            case 8327: 
            case 8328: 
            case 8329: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSuperscriptDigit(int n) {
        switch (n) {
            case 178: 
            case 179: 
            case 185: 
            case 8304: 
            case 8308: 
            case 8309: 
            case 8310: 
            case 8311: 
            case 8312: 
            case 8313: {
                return true;
            }
        }
        return false;
    }

    public static Integer parseInt(String string) throws NumberFormatException {
        try {
            if (string.codePointAt(0) == 8722) {
                return Integer.valueOf("-" + string.substring(1));
            }
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            block16: for (int i = 0; i < string.length(); i += Character.charCount(n)) {
                n = string.codePointAt(i);
                switch (n) {
                    case 8304: 
                    case 8320: {
                        stringBuilder.append('0');
                        continue block16;
                    }
                    case 185: 
                    case 8321: {
                        stringBuilder.append('1');
                        continue block16;
                    }
                    case 178: 
                    case 8322: {
                        stringBuilder.append('2');
                        continue block16;
                    }
                    case 179: 
                    case 8323: {
                        stringBuilder.append('3');
                        continue block16;
                    }
                    case 8308: 
                    case 8324: {
                        stringBuilder.append('4');
                        continue block16;
                    }
                    case 8309: 
                    case 8325: {
                        stringBuilder.append('5');
                        continue block16;
                    }
                    case 8310: 
                    case 8326: {
                        stringBuilder.append('6');
                        continue block16;
                    }
                    case 8311: 
                    case 8327: {
                        stringBuilder.append('7');
                        continue block16;
                    }
                    case 8312: 
                    case 8328: {
                        stringBuilder.append('8');
                        continue block16;
                    }
                    case 8313: 
                    case 8329: {
                        stringBuilder.append('9');
                        continue block16;
                    }
                    case 8314: 
                    case 8330: {
                        stringBuilder.append('+');
                        continue block16;
                    }
                    case 8315: 
                    case 8331: {
                        stringBuilder.append('-');
                        continue block16;
                    }
                }
                stringBuilder.appendCodePoint(n);
            }
            return Integer.valueOf(stringBuilder.toString());
        }
    }

    @Override
    public String getApplicationName() {
        return NAME;
    }

    @Override
    public String getCopyrightStartYear() {
        return "2017";
    }

    @Override
    public void help() {
        System.out.println(this.getMessage("syntax.usage", NAME));
        System.out.println();
        this.printSyntaxItem(this.getMessage("syntax.info", "--dir"));
        System.out.println();
        System.out.println(this.getMessage("syntax.options.common"));
        System.out.println();
        this.commonHelp();
        this.printSyntaxItem(this.getMessage("syntax.group", "--[no-]group", "-g"));
        System.out.println();
        System.out.println(this.getMessage("syntax.options.files"));
        System.out.println();
        this.printSyntaxItem(this.getMessage("syntax.dir", "--dir", "-d"));
        this.printSyntaxItem(this.getMessage("syntax.log", "--log-file", "-t"));
        this.printSyntaxItem(this.getMessage("syntax.tex.encoding", "--tex-encoding"));
        this.printSyntaxItem(this.getMessage("syntax.log.encoding", "--log-encoding"));
        this.printSyntaxItem(this.getMessage("syntax.default.encoding", "--default-encoding"));
        this.printSyntaxItem(this.getMessage("syntax.date_in_header", "--[no-]date-in-header"));
        this.printSyntaxItem(this.getMessage("syntax.aux_input_action", "--aux-input-action"));
        System.out.println();
        System.out.println(this.getMessage("syntax.options.interpreter"));
        System.out.println();
        this.printSyntaxItem(this.getMessage("syntax.break.space", "--[no-]break-space"));
        this.printSyntaxItem(this.getMessage("syntax.obey.aux.catcode", "--[no-]obey-aux-catcode"));
        this.printSyntaxItem(this.getMessage("syntax.datatool_sort_markers", "--[no-]datatool-sort-markers"));
        this.printSyntaxItem(this.getMessage("syntax.custom.packages", "--custom-packages"));
        this.printSyntaxItem(this.getMessage("syntax.ignore.packages", "--ignore-packages", "-k"));
        this.printSyntaxItem(this.getMessage("syntax.interpret", "--[no-]interpret"));
        this.printSyntaxItem(this.getMessage("syntax.list.known.packages", "--list-known-packages"));
        this.printSyntaxItem(this.getMessage("syntax.packages", "--packages", "-p"));
        this.printSyntaxItem(this.getMessage("syntax.support.unicode.script", "--[no-]support-unicode-script"));
        System.out.println();
        System.out.println(this.getMessage("syntax.options.records"));
        System.out.println();
        this.printSyntaxItem(this.getMessage("syntax.cite.as.record", "--[no-]cite-as-record"));
        this.printSyntaxItem(this.getMessage("syntax.collapse.same.location.range", "--[no-]collapse-same-location-range"));
        this.printSyntaxItem(this.getMessage("syntax.format.map", "--map-format", "-m"));
        this.printSyntaxItem(this.getMessage("syntax.merge.nameref.on", "--merge-nameref-on"));
        this.printSyntaxItem(this.getMessage("syntax.merge.wrglossary.records", "--[no-]merge-wrglossary-records"));
        this.printSyntaxItem(this.getMessage("syntax.record.count.rule", "--record-count-rule", "-r"));
        this.printSyntaxItem(this.getMessage("syntax.record.count", "--[no-]record-count", "-c"));
        this.printSyntaxItem(this.getMessage("syntax.record.count.unit", "--record-count-unit", "-n"));
        this.printSyntaxItem(this.getMessage("syntax.retain.formats", "--[no-]retain-formats"));
        System.out.println();
        System.out.println(this.getMessage("syntax.options.bib"));
        System.out.println();
        this.printSyntaxItem(this.getMessage("syntax.warn.non.bib.fields", "--[no-]warn-non-bib-fields"));
        this.printSyntaxItem(this.getMessage("syntax.warn.unknown.entry.types", "--[no-]warn-unknown-entry-types"));
        System.out.println();
        System.out.println(this.getMessage("syntax.options.fields"));
        System.out.println();
        this.printSyntaxItem(this.getMessage("syntax.expand.fields", "--[no-]expand-fields"));
        this.printSyntaxItem(this.getMessage("syntax.math.mfirstuc", "--[no-]mfirstuc-math-protection"));
        this.printSyntaxItem(this.getMessage("syntax.mfirstuc", "--[no-]mfirstuc-protection", "-u"));
        this.printSyntaxItem(this.getMessage("syntax.check.nested", "--[no-]nested-link-check"));
        this.printSyntaxItem(this.getMessage("syntax.check.shortcuts", "--shortcuts"));
        this.printSyntaxItem(this.getMessage("syntax.trim.fields", "--[no-]trim-fields"));
        this.printSyntaxItem(this.getMessage("syntax.trim.except.fields", "--trim-except-fields"));
        this.printSyntaxItem(this.getMessage("syntax.trim.only.fields", "--trim-only-fields"));
        System.out.println();
        System.out.println(this.getMessage("syntax.options.other"));
        System.out.println();
        this.printSyntaxItem(this.getMessage("syntax.force.cross.resource.refs", "--[no-]force-cross-resource-refs", "-x"));
        this.printSyntaxItem(this.getMessage("syntax.locale", "--locale", "-l"));
        this.printSyntaxItem(this.getMessage("syntax.provide.glossaries", "--[no-]provide-glossaries"));
        this.printSyntaxItem(this.getMessage("syntax.replace.quotes", "--[no-]replace-quotes"));
        System.out.println();
        System.out.println(this.getMessage("syntax.furtherinfo"));
        System.out.println();
        this.furtherInfo();
        System.exit(0);
    }

    @Override
    protected Locale initMessageLocale(Locale locale) {
        try {
            this.setDocDefaultLocale(this.langTag);
            locale = this.getDefaultLocale();
        }
        catch (IllformedLocaleException illformedLocaleException) {
            locale = Locale.getDefault();
            this.setDocDefaultLocale(locale);
            this.error(illformedLocaleException.getMessage());
            this.debug(illformedLocaleException);
        }
        return locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExtraProperties(Locale locale) throws IOException, Bib2GlsException {
        URL uRL = this.getLanguageUrl("bib2gls-extra", locale, null);
        if (uRL != null) {
            InputStream inputStream = null;
            try {
                this.debug("Reading " + uRL);
                inputStream = uRL.openStream();
                Properties properties = new Properties();
                properties.loadFromXML(inputStream);
                inputStream.close();
                inputStream = null;
                this.messages.addProperties(properties);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                    inputStream = null;
                }
            }
        }
    }

    private void setShortCuts(String string) {
        if (string.startsWith("ac")) {
            this.shortcuts = string;
            this.checkAcroShortcuts = true;
        } else if (string.startsWith("ab")) {
            this.shortcuts = string;
            this.checkAbbrvShortcuts = true;
        } else if (string.equals("all") || string.equals("true")) {
            this.shortcuts = string;
            this.checkAcroShortcuts = true;
            this.checkAbbrvShortcuts = true;
        } else if (string.equals("none") || string.equals("false") || string.equals("other")) {
            this.shortcuts = string;
            this.checkAcroShortcuts = false;
            this.checkAbbrvShortcuts = false;
        } else {
            throw new IllegalArgumentException("Invalid shortcut value: " + string);
        }
    }

    public void setDocDefaultLocale(Locale locale) {
        this.docLocale = locale.toLanguageTag();
        this.defaultLocale = locale;
    }

    public void setDocDefaultLocale(String string) throws IllformedLocaleException {
        this.docLocale = string;
        this.defaultLocale = new Locale.Builder().setLanguageTag(string).build();
    }

    public String getDocDefaultLocale() {
        return this.docLocale;
    }

    public Locale getLocale(String string) {
        return this.getLocale(string, true);
    }

    public Locale getLocale(String string, boolean bl) {
        try {
            return new Locale.Builder().setLanguageTag(string).build();
        }
        catch (IllformedLocaleException illformedLocaleException) {
            Locale locale = this.defaultLocale;
            if (locale == null) {
                locale = Locale.getDefault();
            }
            if (bl) {
                this.warningMessage("warning.invalid.locale", string, locale);
            }
            return locale;
        }
    }

    public void setTrimFields(boolean bl) {
        this.trimFields = bl;
    }

    @Deprecated
    public boolean trimFields() {
        return this.trimFields;
    }

    public boolean isTrimFieldOn(String string) {
        if (this.trimOnlyFields == null && this.trimExceptFields == null) {
            return this.trimFields;
        }
        if (this.trimOnlyFields != null) {
            return this.trimOnlyFields.contains(string);
        }
        return !this.trimExceptFields.contains(string);
    }

    @Override
    protected void initSettings() throws Bib2GlsSyntaxException {
        this.provideknownGlossaries = false;
        this.mfirstucProtectWasSet = false;
        this.mfirstucMProtectWasSet = false;
        this.debugMessage("message.parsing.args", new Object[0]);
        this.recordCountRule = new RecordCountRule(this);
    }

    @Override
    protected int argCount(String string) {
        if (string.equals("-t") || string.equals("--log-file") || string.equals("-p") || string.equals("--packages") || string.equals("--custom-packages") || string.equals("-k") || string.equals("--ignore-packages") || string.equals("--merge-nameref-on") || string.equals("-u") || string.equals("--mfirstuc-protection") || string.equals("--shortcuts") || string.equals("--nested-link-check") || string.equals("-d") || string.equals("--dir") || string.equals("-m") || string.equals("--map-format") || string.equals("--retain-formats") || string.equals("-r") || string.equals("--record-count-rule") || string.equals("--tex-encoding") || string.equals("--log-encoding") || string.equals("--trim-only-fields") || string.equals("--trim-except-fields") || string.equals("--aux-input-action")) {
            return 1;
        }
        return super.argCount(string);
    }

    public void processGlobalOptions(KeyValList keyValList, TeXParser teXParser) throws Bib2GlsSyntaxException {
        for (String string : keyValList.keySet()) {
            String[] stringArray;
            String string2;
            TeXObject teXObject;
            if (string.equals("log-file") || string.equals("ignore-packages") || string.equals("list-known-packages") || string.equals("obey-aux-catcode") || string.equals("dir") || string.equals("tex-encoding") || string.equals("log-encoding") || string.equals("default-encoding") || string.equals("verbose") || string.equals("silent") || string.equals("quiet") || string.equals("debug") || string.equals("debug-mode") || string.equals("help") || string.equals("version")) {
                throw new Bib2GlsSyntaxException(this.getMessage("error.switch_only", string));
            }
            if (string.equals("packages")) {
                teXObject = keyValList.getValue(string);
                if (teXObject == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", string));
                }
                this.addKnownPackages(teXObject.toString(teXParser).trim().split(" *, *"), false);
                continue;
            }
            if (string.equals("custom-packages")) {
                teXObject = keyValList.getValue(string);
                if (teXObject == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", string));
                }
                this.addCustomPackages(teXObject.toString(teXParser).trim().split(" *, *"), false);
                continue;
            }
            if (string.equals("expand-fields")) {
                teXObject = keyValList.getValue(string);
                string2 = "";
                if (teXObject != null) {
                    string2 = teXObject.toString(teXParser).trim();
                }
                if (string2.isEmpty() || string2.equals("true")) {
                    this.expandFields = true;
                    continue;
                }
                if (string2.equals("false")) {
                    this.expandFields = false;
                    continue;
                }
                throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.opt.bool.value", string, string2));
            }
            if (string.equals("warn-non-bib-fields")) {
                teXObject = keyValList.getValue(string);
                string2 = "";
                if (teXObject != null) {
                    string2 = teXObject.toString(teXParser).trim();
                }
                if (string2.isEmpty() || string2.equals("true")) {
                    this.checkNonBibFields = true;
                    continue;
                }
                if (string2.equals("false")) {
                    this.checkNonBibFields = false;
                    continue;
                }
                throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.opt.bool.value", string, string2));
            }
            if (string.equals("warn-unknown-entry-types")) {
                teXObject = keyValList.getValue(string);
                string2 = "";
                if (teXObject != null) {
                    string2 = teXObject.toString(teXParser).trim();
                }
                if (string2.isEmpty() || string2.equals("true")) {
                    this.warnUnknownEntryTypes = true;
                    continue;
                }
                if (string2.equals("false")) {
                    this.warnUnknownEntryTypes = false;
                    continue;
                }
                throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.opt.bool.value", string, string2));
            }
            if (string.equals("interpret")) {
                teXObject = keyValList.getValue(string);
                string2 = "";
                if (teXObject != null) {
                    string2 = teXObject.toString(teXParser).trim();
                }
                if (string2.isEmpty() || string2.equals("true")) {
                    this.interpret = true;
                    continue;
                }
                if (string2.equals("false")) {
                    this.interpret = false;
                    continue;
                }
                throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.opt.bool.value", string, string2));
            }
            if (string.equals("break-space")) {
                teXObject = keyValList.getValue(string);
                string2 = "";
                if (teXObject != null) {
                    string2 = teXObject.toString(teXParser).trim();
                }
                if (string2.isEmpty() || string2.equals("true")) {
                    this.useNonBreakSpace = true;
                    continue;
                }
                if (string2.equals("false")) {
                    this.useNonBreakSpace = false;
                    continue;
                }
                throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.opt.bool.value", string, string2));
            }
            if (string.equals("cite-as-record")) {
                teXObject = keyValList.getValue(string);
                string2 = "";
                if (teXObject != null) {
                    string2 = teXObject.toString(teXParser).trim();
                }
                if (string2.isEmpty() || string2.equals("true")) {
                    this.useCiteAsRecord = true;
                    continue;
                }
                if (string2.equals("false")) {
                    this.useCiteAsRecord = false;
                    continue;
                }
                throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.opt.bool.value", string, string2));
            }
            if (string.equals("merge-wrglossary-records")) {
                teXObject = keyValList.getValue(string);
                string2 = "";
                if (teXObject != null) {
                    string2 = teXObject.toString(teXParser).trim();
                }
                if (string2.isEmpty() || string2.equals("true")) {
                    this.mergeWrGlossaryLocations = true;
                    continue;
                }
                if (string2.equals("false")) {
                    this.mergeWrGlossaryLocations = false;
                    continue;
                }
                throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.opt.bool.value", string, string2));
            }
            if (string.equals("merge-nameref-on")) {
                teXObject = keyValList.getValue(string);
                if (teXObject == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", string));
                }
                string2 = teXObject.toString(teXParser).trim();
                if (string2.equals("href")) {
                    this.mergeNameRefOn = 0;
                    continue;
                }
                if (string2.equals("title")) {
                    this.mergeNameRefOn = 1;
                    continue;
                }
                if (string2.equals("location")) {
                    this.mergeNameRefOn = (byte)2;
                    continue;
                }
                if (string2.equals("hcounter")) {
                    this.mergeNameRefOn = (byte)3;
                    continue;
                }
                throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.choice.value", string, string2));
            }
            if (string.equals("force-cross-resource-refs")) {
                teXObject = keyValList.getValue(string);
                string2 = "";
                if (teXObject != null) {
                    string2 = teXObject.toString(teXParser).trim();
                }
                if (string2.isEmpty() || string2.equals("true")) {
                    this.forceCrossResourceRefs = true;
                    continue;
                }
                if (string2.equals("false")) {
                    this.forceCrossResourceRefs = false;
                    continue;
                }
                throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.opt.bool.value", string, string2));
            }
            if (string.equals("support-unicode-script")) {
                teXObject = keyValList.getValue(string);
                string2 = "";
                if (teXObject != null) {
                    string2 = teXObject.toString(teXParser).trim();
                }
                if (string2.isEmpty() || string2.equals("true")) {
                    this.supportUnicodeSubSuperScripts = true;
                    continue;
                }
                if (string2.equals("false")) {
                    this.supportUnicodeSubSuperScripts = false;
                    continue;
                }
                throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.opt.bool.value", string, string2));
            }
            if (string.equals("replace-quotes")) {
                teXObject = keyValList.getValue(string);
                string2 = "";
                if (teXObject != null) {
                    string2 = teXObject.toString(teXParser).trim();
                }
                if (string2.isEmpty() || string2.equals("true")) {
                    this.replaceQuotes = true;
                    continue;
                }
                if (string2.equals("false")) {
                    this.replaceQuotes = false;
                    continue;
                }
                throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.opt.bool.value", string, string2));
            }
            if (string.equals("collapse-same-location-range")) {
                teXObject = keyValList.getValue(string);
                string2 = "";
                if (teXObject != null) {
                    string2 = teXObject.toString(teXParser).trim();
                }
                if (string2.isEmpty() || string2.equals("true")) {
                    this.collapseSamePageRange = true;
                    continue;
                }
                if (string2.equals("false")) {
                    this.collapseSamePageRange = false;
                    continue;
                }
                throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.opt.bool.value", string, string2));
            }
            if (string.equals("mfirstuc-protection")) {
                teXObject = keyValList.getValue(string);
                if (teXObject == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", string));
                }
                string2 = teXObject.toString(teXParser).trim();
                if (string2.equals("false")) {
                    this.mfirstucProtect = false;
                    continue;
                }
                this.mfirstucProtect = true;
                if (string2.equals("all")) {
                    this.mfirstucProtectFields = null;
                    continue;
                }
                if (string2.isEmpty()) {
                    this.mfirstucProtect = false;
                    continue;
                }
                this.mfirstucProtectFields = string2.split(" *, *");
                continue;
            }
            if (string.equals("mfirstuc-math-protection")) {
                teXObject = keyValList.getValue(string);
                string2 = "";
                if (teXObject != null) {
                    string2 = teXObject.toString(teXParser).trim();
                }
                if (string2.isEmpty() || string2.equals("true")) {
                    this.mfirstucMProtect = true;
                    continue;
                }
                if (string2.equals("false")) {
                    this.mfirstucMProtect = false;
                    continue;
                }
                throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.opt.bool.value", string, string2));
            }
            if (string.equals("shortcuts")) {
                teXObject = keyValList.getValue(string);
                if (teXObject == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", string));
                }
                string2 = teXObject.toString(teXParser).trim();
                try {
                    this.setShortCuts(string2);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.choice.value", string, string2), illegalArgumentException);
                }
            }
            if (string.equals("nested-link-check")) {
                teXObject = keyValList.getValue(string);
                if (teXObject == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", string));
                }
                string2 = teXObject.toString(teXParser).trim();
                if (string2.equals("none") || string2.equals("false") || string2.isEmpty()) {
                    this.nestedLinkCheckFields = null;
                    continue;
                }
                this.nestedLinkCheckFields = string2.split(" *, *");
                continue;
            }
            if (string.equals("map-format")) {
                teXObject = keyValList.getValue(string);
                if (teXObject == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", string));
                }
                string2 = teXObject.toString(teXParser).trim();
                for (String string3 : stringArray = string2.split(" *, *")) {
                    String[] stringArray2 = string3.split(" *: *");
                    if (stringArray2.length != 2) {
                        throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.opt.value", string, string2));
                    }
                    this.formatMap.put(stringArray2[0], stringArray2[1]);
                }
                continue;
            }
            if (string.equals("retain-formats")) {
                teXObject = keyValList.getValue(string);
                if (teXObject == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", string));
                }
                if (this.retainFormatList == null) {
                    this.retainFormatList = new Vector();
                }
                if ((string2 = teXObject.toString(teXParser).trim()).equals("false")) {
                    this.retainFormatList = null;
                    continue;
                }
                for (String string3 : stringArray = string2.split(" *, *")) {
                    this.retainFormatList.add(string3);
                }
                continue;
            }
            if (string.equals("group")) {
                teXObject = keyValList.getValue(string);
                string2 = "";
                if (teXObject != null) {
                    string2 = teXObject.toString(teXParser).trim();
                }
                if (string2.isEmpty() || string2.equals("true")) {
                    this.addGroupField = true;
                    continue;
                }
                if (string2.equals("false")) {
                    this.addGroupField = false;
                    continue;
                }
                throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.opt.bool.value", string, string2));
            }
            if (string.equals("record-count-rule")) {
                teXObject = keyValList.getValue(string);
                if (teXObject == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", string));
                }
                this.recordCountRule.setRule(teXObject.toString(teXParser).trim());
                this.saveRecordCount = true;
                continue;
            }
            if (string.equals("record-count")) {
                teXObject = keyValList.getValue(string);
                string2 = "";
                if (teXObject != null) {
                    string2 = teXObject.toString(teXParser).trim();
                }
                if (string2.isEmpty() || string2.equals("true")) {
                    this.saveRecordCount = true;
                    continue;
                }
                if (string2.equals("false")) {
                    this.saveRecordCount = false;
                    this.saveRecordCountUnit = false;
                    continue;
                }
                throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.opt.bool.value", string, string2));
            }
            if (string.equals("record-count-unit")) {
                teXObject = keyValList.getValue(string);
                string2 = "";
                if (teXObject != null) {
                    string2 = teXObject.toString(teXParser).trim();
                }
                if (string2.isEmpty() || string2.equals("true")) {
                    this.saveRecordCountUnit = true;
                    this.saveRecordCount = true;
                    continue;
                }
                if (string2.equals("false")) {
                    this.saveRecordCountUnit = false;
                    continue;
                }
                throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.opt.bool.value", string, string2));
            }
            if (string.equals("date-in-header")) {
                teXObject = keyValList.getValue(string);
                string2 = "";
                if (teXObject != null) {
                    string2 = teXObject.toString(teXParser).trim();
                }
                if (string2.isEmpty() || string2.equals("true")) {
                    this.dateInHeader = true;
                    continue;
                }
                if (string2.equals("false")) {
                    this.dateInHeader = false;
                    continue;
                }
                throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.opt.bool.value", string, string2));
            }
            if (string.equals("aux-input-action")) {
                teXObject = keyValList.getValue(string);
                if (teXObject == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", string));
                }
                string2 = teXObject.toString(teXParser).trim();
                try {
                    this.auxInputAction = AuxInputAction.valueOfArg(string2);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.choice.value", string, string2, AuxInputAction.getValidList()));
                }
            }
            if (string.equals("trim-fields")) {
                teXObject = keyValList.getValue(string);
                string2 = "";
                if (teXObject != null) {
                    string2 = teXObject.toString(teXParser).trim();
                }
                if (string2.isEmpty() || string2.equals("true")) {
                    this.trimFields = true;
                    this.trimOnlyFields = null;
                    this.trimExceptFields = null;
                    continue;
                }
                if (string2.equals("false")) {
                    this.trimFields = false;
                    this.trimOnlyFields = null;
                    this.trimExceptFields = null;
                    continue;
                }
                throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.opt.bool.value", string, string2));
            }
            if (string.equals("trim-only-fields")) {
                if (this.trimExceptFields != null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.option.clash", "--trim-only-fields", "--trim-except-fields"));
                }
                teXObject = keyValList.getValue(string);
                if (teXObject == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", string));
                }
                string2 = teXObject.toString(teXParser).trim();
                stringArray = string2.split(" *, *");
                if (this.trimOnlyFields == null) {
                    this.trimOnlyFields = new Vector();
                }
                for (String string3 : stringArray) {
                    this.trimOnlyFields.add(string3);
                }
                this.trimFields = true;
                continue;
            }
            if (string.equals("trim-except-fields")) {
                if (this.trimOnlyFields != null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.option.clash", "--trim-only-fields", "--trim-except-fields"));
                }
                teXObject = keyValList.getValue(string);
                if (teXObject == null) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", string));
                }
                string2 = teXObject.toString(teXParser).trim();
                stringArray = string2.split(" *, *");
                if (this.trimExceptFields == null) {
                    this.trimExceptFields = new Vector();
                }
                for (String string3 : stringArray) {
                    this.trimExceptFields.add(string3);
                }
                this.trimFields = true;
                continue;
            }
            if (string.equals("provide-glossaries")) {
                teXObject = keyValList.getValue(string);
                string2 = "";
                if (teXObject != null) {
                    string2 = teXObject.toString(teXParser).trim();
                }
                if (string2.isEmpty() || string2.equals("true")) {
                    this.provideknownGlossaries = true;
                    continue;
                }
                if (string2.equals("false")) {
                    this.provideknownGlossaries = false;
                    continue;
                }
                throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.opt.bool.value", string, string2));
            }
            if (string.equals("datatool-sort-markers")) {
                teXObject = keyValList.getValue(string);
                string2 = "";
                if (teXObject != null) {
                    string2 = teXObject.toString(teXParser).trim();
                }
                if (string2.isEmpty() || string2.equals("true")) {
                    this.datatoolSortMarkers = true;
                    continue;
                }
                if (string2.equals("false")) {
                    this.datatoolSortMarkers = false;
                    continue;
                }
                throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.opt.bool.value", string, string2));
            }
            if (string.startsWith("no-")) {
                throw new Bib2GlsSyntaxException(this.getMessage("error.syntax.unknown_option_try", string, string.substring(3) + "=false"));
            }
            if (string.startsWith("--")) {
                throw new Bib2GlsSyntaxException(this.getMessage("error.syntax.unknown_option_try", string, string.substring(2)));
            }
            throw new Bib2GlsSyntaxException(this.getMessage("error.syntax.unknown_option", string));
        }
    }

    protected void addKnownPackages(String[] stringArray, boolean bl) throws Bib2GlsSyntaxException {
        for (String string : stringArray) {
            if (Bib2Gls.isKnownPackage(string)) {
                this.packages.add(string);
                if (bl) continue;
                if (string.equals("fontspec")) {
                    this.fontspec = true;
                }
                this.debug(string);
                continue;
            }
            throw new Bib2GlsSyntaxException(this.getMessage("error.unsupported.package", string, bl ? "--custom-packages" : "custom-packages"));
        }
    }

    protected void addCustomPackages(String[] stringArray, boolean bl) throws Bib2GlsSyntaxException {
        if (this.customPackages == null) {
            this.customPackages = new Vector();
        }
        for (String string : stringArray) {
            if (Bib2Gls.isKnownPackage(string)) {
                throw new Bib2GlsSyntaxException(this.getMessage("error.supported.package", string, bl ? "--packages" : "packages"));
            }
            this.customPackages.add(string);
        }
    }

    @Override
    protected void parseArg(ArrayDeque<String> arrayDeque, String string) throws Bib2GlsSyntaxException {
        if (this.auxFileName != null) {
            throw new Bib2GlsSyntaxException(this.getMessage("error.only.one.aux"));
        }
        this.auxFileName = string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean parseArg(ArrayDeque<String> arrayDeque, String string, BibGlsArgValue[] bibGlsArgValueArray) throws Bib2GlsSyntaxException {
        if (this.isArg(arrayDeque, string, "-t", "--log-file", bibGlsArgValueArray)) {
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", string));
            }
            this.logName = bibGlsArgValueArray[0].toString();
            if (!this.logName.isEmpty()) return true;
            this.logName = null;
            return true;
        } else if (this.isListArg(arrayDeque, string, "-p", "--packages", bibGlsArgValueArray)) {
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", string));
            }
            this.addKnownPackages(bibGlsArgValueArray[0].listValue(), true);
            return true;
        } else if (this.isListArg(arrayDeque, string, "--custom-packages", bibGlsArgValueArray)) {
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", string));
            }
            this.addCustomPackages(bibGlsArgValueArray[0].listValue(), true);
            return true;
        } else if (this.isListArg(arrayDeque, string, "-k", "--ignore-packages", bibGlsArgValueArray)) {
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", string));
            }
            if (this.ignorePackages == null) {
                this.ignorePackages = new Vector();
            }
            for (String string2 : bibGlsArgValueArray[0].listValue()) {
                if (Bib2Gls.isKnownPackage(string2)) {
                    this.ignorePackages.add(string2);
                    continue;
                }
                this.warningMessage("error.invalid.opt.value", string, string2);
            }
            return true;
        } else if (string.equals("--list-known-packages")) {
            int n;
            System.out.println(this.getMessage("message.list.known.packages.auto"));
            for (n = 0; n < AUTO_SUPPORT_PACKAGES.length; ++n) {
                if (n % 5 == 0) {
                    if (n > 0) {
                        System.out.print(",");
                    }
                    System.out.println();
                    System.out.print("\t");
                } else {
                    System.out.print(", ");
                }
                System.out.print(AUTO_SUPPORT_PACKAGES[n]);
            }
            System.out.println();
            System.out.println();
            System.out.println(this.getMessage("message.list.known.packages.extra"));
            for (n = 0; n < EXTRA_SUPPORTED_PACKAGES.length; ++n) {
                if (n % 5 == 0) {
                    if (n > 0) {
                        System.out.print(",");
                    }
                    System.out.println();
                    System.out.print("\t");
                } else {
                    System.out.print(", ");
                }
                System.out.print(EXTRA_SUPPORTED_PACKAGES[n]);
            }
            System.out.println();
            System.out.println(this.getMessage("message.list.known.packages.info"));
            System.exit(0);
            return true;
        } else if (string.equals("--expand-fields")) {
            this.expandFields = true;
            return true;
        } else if (string.equals("--no-expand-fields")) {
            this.expandFields = false;
            return true;
        } else if (string.equals("--warn-non-bib-fields")) {
            this.checkNonBibFields = true;
            return true;
        } else if (string.equals("--no-warn-non-bib-fields")) {
            this.checkNonBibFields = false;
            return true;
        } else if (string.equals("--warn-unknown-entry-types")) {
            this.warnUnknownEntryTypes = true;
            return true;
        } else if (string.equals("--no-warn-unknown-entry-types")) {
            this.warnUnknownEntryTypes = false;
            return true;
        } else if (string.equals("--interpret")) {
            this.interpret = true;
            return true;
        } else if (string.equals("--no-interpret")) {
            this.interpret = false;
            return true;
        } else if (string.equals("--break-space")) {
            this.useNonBreakSpace = false;
            return true;
        } else if (string.equals("--no-break-space")) {
            this.useNonBreakSpace = true;
            return true;
        } else if (string.equals("--obey-aux-catcode")) {
            this.allowAuxCatChangers = true;
            return true;
        } else if (string.equals("--no-obey-aux-catcode")) {
            this.allowAuxCatChangers = false;
            return true;
        } else if (string.equals("--cite-as-record")) {
            this.useCiteAsRecord = true;
            return true;
        } else if (string.equals("--no-cite-as-record")) {
            this.useCiteAsRecord = false;
            return true;
        } else if (string.equals("--merge-wrglossary-records")) {
            this.mergeWrGlossaryLocations = true;
            return true;
        } else if (string.equals("--no-merge-wrglossary-records")) {
            this.mergeWrGlossaryLocations = false;
            return true;
        } else if (this.isArg(arrayDeque, string, "--merge-nameref-on", bibGlsArgValueArray)) {
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", string));
            }
            String string3 = bibGlsArgValueArray[0].toString();
            if (string3.equals("href")) {
                this.mergeNameRefOn = 0;
                return true;
            } else if (string3.equals("title")) {
                this.mergeNameRefOn = 1;
                return true;
            } else if (string3.equals("location")) {
                this.mergeNameRefOn = (byte)2;
                return true;
            } else {
                if (!string3.equals("hcounter")) throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.choice.value", string, string3));
                this.mergeNameRefOn = (byte)3;
            }
            return true;
        } else if (string.equals("--force-cross-resource-refs") || string.equals("-x")) {
            this.forceCrossResourceRefs = true;
            return true;
        } else if (string.equals("--no-force-cross-resource-refs")) {
            this.forceCrossResourceRefs = false;
            return true;
        } else if (string.equals("--support-unicode-script")) {
            this.supportUnicodeSubSuperScripts = true;
            return true;
        } else if (string.equals("--no-support-unicode-script")) {
            this.supportUnicodeSubSuperScripts = false;
            return true;
        } else if (string.equals("--replace-quotes")) {
            this.replaceQuotes = true;
            return true;
        } else if (string.equals("--no-replace-quotes")) {
            this.replaceQuotes = false;
            return true;
        } else if (string.equals("--collapse-same-location-range")) {
            this.collapseSamePageRange = true;
            return true;
        } else if (string.equals("--no-collapse-same-location-range")) {
            this.collapseSamePageRange = false;
            return true;
        } else if (string.equals("--no-mfirstuc-protection")) {
            this.mfirstucProtect = false;
            this.mfirstucProtectWasSet = true;
            return true;
        } else if (this.isArg(arrayDeque, string, "-u", "--mfirstuc-protection", bibGlsArgValueArray)) {
            this.mfirstucProtect = true;
            this.mfirstucProtectWasSet = true;
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", string));
            }
            String string4 = bibGlsArgValueArray[0].toString();
            if (string4.equals("all")) {
                this.mfirstucProtectFields = null;
                return true;
            } else if (string4.isEmpty()) {
                this.mfirstucProtect = false;
                return true;
            } else {
                this.mfirstucProtectFields = string4.split(" *, *");
            }
            return true;
        } else if (string.equals("--no-mfirstuc-math-protection")) {
            this.mfirstucMProtect = false;
            this.mfirstucMProtectWasSet = true;
            return true;
        } else if (string.equals("--mfirstuc-math-protection")) {
            this.mfirstucMProtect = true;
            this.mfirstucMProtectWasSet = true;
            return true;
        } else if (this.isArg(arrayDeque, string, "--shortcuts", bibGlsArgValueArray)) {
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", string));
            }
            try {
                this.setShortCuts(bibGlsArgValueArray[0].toString());
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.choice.value", string, bibGlsArgValueArray[0]), illegalArgumentException);
            }
        } else if (this.isArg(arrayDeque, string, "--nested-link-check", bibGlsArgValueArray)) {
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", string));
            }
            String string5 = bibGlsArgValueArray[0].toString();
            this.nestedLinkCheckFields = string5.equals("none") || string5.isEmpty() ? null : string5.split(" *, *");
            return true;
        } else if (string.equals("--no-nested-link-check")) {
            this.nestedLinkCheckFields = null;
            return true;
        } else if (this.isArg(arrayDeque, string, "-d", "--dir", bibGlsArgValueArray)) {
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", string));
            }
            this.dirName = bibGlsArgValueArray[0].toString();
            return true;
        } else if (this.isListArg(arrayDeque, string, "-m", "--map-format", bibGlsArgValueArray)) {
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", string));
            }
            for (String string6 : bibGlsArgValueArray[0].listValue()) {
                String[] stringArray = string6.split(" *: *");
                if (stringArray.length != 2) {
                    throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.opt.value", string, bibGlsArgValueArray[0]));
                }
                this.formatMap.put(stringArray[0], stringArray[1]);
            }
            return true;
        } else if (this.isListArg(arrayDeque, string, "--retain-formats", bibGlsArgValueArray)) {
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", string));
            }
            if (this.retainFormatList == null) {
                this.retainFormatList = new Vector();
            }
            for (String string7 : bibGlsArgValueArray[0].listValue()) {
                this.retainFormatList.add(string7);
            }
            return true;
        } else if (string.equals("--no-retain-formats")) {
            this.retainFormatList = null;
            return true;
        } else if (string.equals("--group") || string.equals("-g")) {
            this.addGroupField = true;
            return true;
        } else if (string.equals("--no-group")) {
            this.addGroupField = false;
            return true;
        } else if (this.isArg(arrayDeque, string, "-r", "--record-count-rule", bibGlsArgValueArray)) {
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", string));
            }
            this.recordCountRule.setRule(bibGlsArgValueArray[0].toString());
            this.saveRecordCount = true;
            return true;
        } else if (string.equals("--record-count") || string.equals("-c")) {
            this.saveRecordCount = true;
            return true;
        } else if (string.equals("--no-record-count")) {
            this.saveRecordCount = false;
            this.saveRecordCountUnit = false;
            return true;
        } else if (string.equals("--record-count-unit") || string.equals("-n")) {
            this.saveRecordCountUnit = true;
            this.saveRecordCount = true;
            return true;
        } else if (string.equals("--no-record-count-unit")) {
            this.saveRecordCountUnit = false;
            return true;
        } else if (string.equals("-D") || string.equals("--date-in-header")) {
            this.dateInHeader = true;
            return true;
        } else if (string.equals("--no-date-in-header")) {
            this.dateInHeader = false;
            return true;
        } else if (this.isArg(arrayDeque, string, "--aux-input-action", bibGlsArgValueArray)) {
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", string));
            }
            String string8 = bibGlsArgValueArray[0].toString();
            try {
                this.auxInputAction = AuxInputAction.valueOfArg(string8);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.choice.value", string, string8, AuxInputAction.getValidList()));
            }
        } else if (this.isArg(arrayDeque, string, "--tex-encoding", bibGlsArgValueArray)) {
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", string));
            }
            try {
                this.texCharset = Charset.forName(bibGlsArgValueArray[0].toString());
                return true;
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                throw new Bib2GlsSyntaxException(this.getMessage("error.unknown.charset", bibGlsArgValueArray[0]), unsupportedCharsetException);
            }
        } else if (this.isArg(arrayDeque, string, "--log-encoding", bibGlsArgValueArray)) {
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", string));
            }
            try {
                this.texLogCharset = Charset.forName(bibGlsArgValueArray[0].toString());
                return true;
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                throw new Bib2GlsSyntaxException(this.getMessage("error.unknown.charset", bibGlsArgValueArray[0]), unsupportedCharsetException);
            }
        } else if (string.equals("--trim-fields")) {
            this.trimFields = true;
            this.trimOnlyFields = null;
            this.trimExceptFields = null;
            return true;
        } else if (string.equals("--no-trim-fields")) {
            this.trimFields = false;
            this.trimOnlyFields = null;
            this.trimExceptFields = null;
            return true;
        } else if (this.isListArg(arrayDeque, string, "--trim-only-fields", bibGlsArgValueArray)) {
            if (this.trimExceptFields != null) {
                throw new Bib2GlsSyntaxException(this.getMessage("error.option.clash", "--trim-only-fields", "--trim-except-fields"));
            }
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", string));
            }
            if (this.trimOnlyFields == null) {
                this.trimOnlyFields = new Vector();
            }
            for (String string9 : bibGlsArgValueArray[0].listValue()) {
                this.trimOnlyFields.add(string9);
            }
            this.trimFields = true;
            return true;
        } else if (this.isListArg(arrayDeque, string, "--trim-except-fields", bibGlsArgValueArray)) {
            if (this.trimOnlyFields != null) {
                throw new Bib2GlsSyntaxException(this.getMessage("error.option.clash", "--trim-only-fields", "--trim-except-fields"));
            }
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("error.missing.value", string));
            }
            if (this.trimExceptFields == null) {
                this.trimExceptFields = new Vector();
            }
            for (String string10 : bibGlsArgValueArray[0].listValue()) {
                this.trimExceptFields.add(string10);
            }
            this.trimFields = true;
            return true;
        } else if (string.equals("--provide-glossaries")) {
            this.provideknownGlossaries = true;
            return true;
        } else if (string.equals("--no-provide-glossaries")) {
            this.provideknownGlossaries = false;
            return true;
        } else if (string.equals("--datatool-sort-markers")) {
            this.datatoolSortMarkers = true;
            return true;
        } else {
            if (!string.equals("--no-datatool-sort-markers")) return false;
            this.datatoolSortMarkers = false;
        }
        return true;
    }

    @Override
    protected void postSettings() throws Bib2GlsSyntaxException, IOException {
        if (this.auxFileName == null) {
            if (this.argsFound) {
                throw new Bib2GlsSyntaxException(this.getMessage("error.no.aux.args_found", this.getMessage("syntax.usage", NAME)));
            }
            throw new Bib2GlsSyntaxException(this.getMessage("error.no.aux", this.getMessage("syntax.usage", NAME)));
        }
        if (!this.auxFileName.endsWith(".aux")) {
            this.auxFileName = this.auxFileName + ".aux";
        }
        this.auxFile = new File(this.auxFileName);
        if (this.dirName != null) {
            this.dirFile = new File(this.dirName);
            this.basePath = this.dirFile.toPath();
            if (!this.dirFile.exists()) {
                System.err.println(this.getMessage("error.dir.not.found", this.dirName));
                System.exit(1);
            }
            if (!this.dirFile.isDirectory()) {
                System.err.println(this.getMessage("error.not.dir", this.dirName));
                System.exit(1);
            }
            this.dirPath = this.basePath.toAbsolutePath().normalize();
            this.auxFile = this.auxFile.getParentFile() == null ? new File(this.dirFile, this.auxFileName) : this.dirFile.toPath().resolve(this.auxFile.toPath()).toFile();
        } else {
            this.dirFile = this.auxFile.getParentFile();
            this.basePath = this.cwd;
        }
        if (!this.auxFile.exists()) {
            System.err.println(this.getMessage("error.file.not.found", this.auxFileName));
            System.exit(0);
        }
        this.initTranscript();
        this.logDefaultEncoding(this.getDefaultCharset());
        if (this.logWriter != null) {
            this.logWriter.print(this.pending.toString());
            this.logWriter.flush();
        }
        this.pendingWriter.close();
        this.pendingWriter = null;
        this.pending = null;
        if (this.isDebuggingOn()) {
            this.logAndPrintMessage(String.format("openin_any=%s%nopenout_any=%s%nTEXMFOUTPUT=%s%ncwd=%s", Character.valueOf(this.openin_any), Character.valueOf(this.openout_any), this.texmfoutput == null ? "" : this.texmfoutput, this.cwd));
        }
    }

    @Override
    protected File newTranscriptFile() throws IOException {
        File file;
        if (this.logName == null) {
            String string = this.auxFile.getName();
            file = new File(this.dirFile, string.substring(0, string.lastIndexOf(".")) + ".glg");
        } else {
            file = this.resolveFile(this.logName);
        }
        return this.getWritableFile(file);
    }

    protected void run(String[] stringArray) {
        try {
            this.initialise(stringArray);
            this.process();
        }
        catch (Bib2GlsSyntaxException bib2GlsSyntaxException) {
            System.err.println(bib2GlsSyntaxException.getMessage());
            System.err.println(this.getMessage("syntax.use.help"));
            this.exitCode = 1;
        }
        catch (Exception exception) {
            this.error(exception);
            this.exitCode = 3;
        }
        this.exit();
    }

    public static void main(String[] stringArray) {
        Bib2Gls bib2Gls = new Bib2Gls();
        bib2Gls.run(stringArray);
    }
}

