// NOTICE: This file is generated by Rollup. To modify it,
// please instead edit the ESM counterpart and rebuild with Rollup (npm run build).
'use strict';

const node_path = require('node:path');
const promises = require('node:fs/promises');
const node_util = require('node:util');
const writeFileAtomic = require('write-file-atomic');

/**
 * @param {string} content
 * @param {string} filePath
 * @returns {Promise<void>}
 */
async function writeOutputFile(content, filePath) {
	await promises.mkdir(node_path.dirname(filePath), { recursive: true });

	await writeFileAtomic(node_path.normalize(filePath), node_util.stripVTControlCharacters(content));
}

module.exports = writeOutputFile;
