/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.ACProxyable;
import oracle.jdbc.internal.OracleBlob;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyAccess;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.JDBCReplayable;
import oracle.jdbc.replay.driver.TxnFailoverManagerImpl;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.driver.TxnReplayableConnection;

@ProxyFor(value={OracleBlob.class})
@ProxyAccess(value=ACProxyable.class)
@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
public abstract class TxnReplayableBlob
extends TxnReplayableBase
implements JDBCReplayable {
    private static final Method GETBINSTREAM_METHOD;
    private static final Method GETBINSTREAM_LONG_METHOD;
    private static final Method GETBINSTREAM_LONG_LONG_METHOD;
    private static final Method SETBINSTREAM_LONG_METHOD;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;

    protected TxnReplayableBlob() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$18, null, new Object[0]);
            }
            this.thisProxyNameInLog = "BLOB" + this.thisProxyNameInLog;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$18, null);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$18, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$18, null, throwable2);
            }
            throw throwable;
        }
    }

    private static final Method getGetBinaryStreamMethod() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            Method method;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$0, null, new Object[0]);
                }
                try {
                    method = OracleBlob.class.getMethod("getBinaryStream", new Class[0]);
                    if (!bl) break block7;
                }
                catch (Exception e2) {
                    Method method2 = null;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$0, null, method2);
                        ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$0, null, null);
                    }
                    return null;
                }
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$0, null, method);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$0, null, null);
            }
            return method;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    private static final Method getGetBinaryStreamLongMethod() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            Method method;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$1, null, new Object[0]);
                }
                try {
                    method = OracleBlob.class.getMethod("getBinaryStream", Long.TYPE);
                    if (!bl) break block7;
                }
                catch (Exception e2) {
                    Method method2 = null;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$1, null, method2);
                        ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$1, null, null);
                    }
                    return null;
                }
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$1, null, method);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$1, null, null);
            }
            return method;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    private static final Method getGetBinaryStreamLongLongMethod() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            Method method;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$2, null, new Object[0]);
                }
                try {
                    method = OracleBlob.class.getMethod("getBinaryStream", Long.TYPE, Long.TYPE);
                    if (!bl) break block7;
                }
                catch (Exception e2) {
                    Method method2 = null;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$2, null, method2);
                        ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$2, null, null);
                    }
                    return null;
                }
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$2, null, method);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$2, null, null);
            }
            return method;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$2, null, throwable2);
            }
            throw throwable;
        }
    }

    private static final Method getSetBinaryStreamLongMethod() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            Method method;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$3, null, new Object[0]);
                }
                try {
                    method = OracleBlob.class.getMethod("setBinaryStream", Long.TYPE);
                    if (!bl) break block7;
                }
                catch (Exception e2) {
                    Method method2 = null;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$3, null, method2);
                        ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$3, null, null);
                    }
                    return null;
                }
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$3, null, method);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$3, null, null);
            }
            return method;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$3, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void args;
            void receiver;
            void m2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$4, this, method, object, objectArray);
            }
            super.preForAll((Method)m2, receiver, (Object[])args);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Post
    protected void postForAll(Method method) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void m2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$5, this, method);
            }
            this.postForAll((Method)m2, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Post
    protected Object postForAll(Method method, Object object) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void m2;
            void result;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$6, this, method, object);
            }
            if (result instanceof TxnReplayableBase) {
                TxnReplayableBase jdbcProxy = (TxnReplayableBase)result;
                jdbcProxy.setFailoverManager(this.getFailoverManager());
            }
            Object object2 = super.postForAll((Method)m2, result);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$6, this, object2);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$6, this, null);
            }
            return object2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Post
    @Methods(signatures={@Signature(name="close", args={})})
    protected void postForClose(Method method) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            block8: {
                void m2;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$7, this, method);
                }
                this.postForAll((Method)m2);
                TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
                TxnReplayableConnection connProxy = (TxnReplayableConnection)this.failoverMngr.getConnectionProxy();
                OracleConnection oconn = (OracleConnection)connProxy.getDelegate();
                if (lifecycle == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING || lifecycle == TxnFailoverManagerImpl.ReplayLifecycle.INTERNALLY_DISABLED && oconn.isUsable(false)) {
                    this.isLogicallyClosed = true;
                    try {
                        connProxy.checkImplicitRequestBoundary();
                    }
                    catch (Throwable error) {
                        if (!bl) break block8;
                        OracleLog.log($$$loggerRef$$$7, Level.FINEST, this.getClass(), $$$methodRef$$$7, "On Blob {0}, implicit boundary check failed", this);
                    }
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Post
    @Methods(signatures={@Signature(name="free", args={})})
    protected void postForFree(Method method) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            block10: {
                void m2;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$8, this, method);
                }
                super.postForAll((Method)m2);
                if (!this.isFreed) {
                    TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
                    TxnReplayableConnection connProxy = (TxnReplayableConnection)this.failoverMngr.getConnectionProxy();
                    OracleConnection oconn = (OracleConnection)connProxy.getDelegate();
                    if (lifecycle == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING || lifecycle == TxnFailoverManagerImpl.ReplayLifecycle.INTERNALLY_DISABLED && oconn.isUsable(false)) {
                        if (lifecycle == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                            this.failoverMngr.setStateSignatureSyncUp();
                        }
                        try {
                            connProxy.checkImplicitRequestBoundary();
                        }
                        catch (Throwable error) {
                            if (!bl) break block10;
                            OracleLog.log($$$loggerRef$$$8, Level.FINEST, this.getClass(), $$$methodRef$$$8, "On Blob {0}, implicit boundary check failed", this);
                        }
                    }
                }
            }
            this.isFreed = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void error;
            void m2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$9, this, method, sQLException);
            }
            super.onErrorVoidForAll((Method)m2, (SQLException)error);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void error;
            void m2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$10, this, method, sQLException);
            }
            Object object = super.onErrorForAll((Method)m2, (SQLException)error);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$10, this, object);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$10, this, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    public InputStream getBinaryStream() throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            InputStream inputStream;
            block11: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$11, this, new Object[0]);
                }
                if (GETBINSTREAM_METHOD == null) {
                    SQLException sQLException = DatabaseError.createSqlException(1, "Cannot get binary stream");
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$11, this, sQLException);
                    }
                    throw sQLException;
                }
                Method m2 = GETBINSTREAM_METHOD;
                this.failoverMngr.setLobStreamInRequest(true);
                this.preForAll(m2, this, new Object[0]);
                try {
                    OracleBlob delegate = (OracleBlob)this.getDelegate();
                    if (this.isFreed) {
                        SQLException sqlexc = DatabaseError.createSqlException(delegate.getInternalConnection(), 192);
                        sqlexc.fillInStackTrace();
                        SQLException sQLException = sqlexc;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$11, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$11, this, sQLException);
                        }
                        throw sQLException;
                    }
                    InputStream delegateReturn = delegate.canReadBasicLobDataInLocator() ? delegate.getBinaryStream() : delegate.getDBAccess().newInputStream((OracleBlob)((Object)this), delegate.getBufferSize(), 0L);
                    inputStream = (InputStream)this.postForAll(m2, delegateReturn);
                    if (!bl) break block11;
                }
                catch (SQLException sqlexc) {
                    InputStream inputStream2 = (InputStream)this.postForAll(m2, this.onErrorForAll(m2, sqlexc));
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$11, this, inputStream2);
                        ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$11, this, null);
                    }
                    return inputStream2;
                }
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$11, this, inputStream);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$11, this, null);
            }
            return inputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public InputStream getBinaryStream(long l2) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            InputStream inputStream;
            block15: {
                void pos;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$12, this, l2);
                }
                if (GETBINSTREAM_LONG_METHOD == null) {
                    SQLException sQLException = DatabaseError.createSqlException(1, "Cannot get binary stream");
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$12, this, sQLException);
                    }
                    throw sQLException;
                }
                Method m2 = GETBINSTREAM_LONG_METHOD;
                this.failoverMngr.setLobStreamInRequest(true);
                this.preForAll(m2, this, (long)pos);
                try {
                    InputStream delegateReturn;
                    OracleBlob delegate = (OracleBlob)this.getDelegate();
                    if (this.isFreed) {
                        SQLException sqlexc = DatabaseError.createSqlException(delegate.getInternalConnection(), 192);
                        sqlexc.fillInStackTrace();
                        SQLException sQLException = sqlexc;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$12, this, sQLException);
                        }
                        throw sQLException;
                    }
                    if (delegate.canReadBasicLobDataInLocator()) {
                        delegateReturn = delegate.getBinaryStream((long)pos);
                    } else {
                        if (pos < 1L) {
                            SQLException sqlexc = DatabaseError.createSqlException(delegate.getInternalConnection(), 68);
                            sqlexc.fillInStackTrace();
                            SQLException sQLException = sqlexc;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$12, this, sQLException);
                            }
                            throw sQLException;
                        }
                        delegateReturn = delegate.getDBAccess().newInputStream((OracleBlob)((Object)this), delegate.getBufferSize(), (long)pos);
                    }
                    inputStream = (InputStream)this.postForAll(m2, delegateReturn);
                    if (!bl) break block15;
                }
                catch (SQLException sqlexc) {
                    InputStream inputStream2 = (InputStream)this.postForAll(m2, this.onErrorForAll(m2, sqlexc));
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$12, this, inputStream2);
                        ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$12, this, null);
                    }
                    return inputStream2;
                }
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$12, this, inputStream);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$12, this, null);
            }
            return inputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public InputStream getBinaryStream(long l2, long l3) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            InputStream inputStream;
            block15: {
                void length;
                void pos;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$13, this, l2, l3);
                }
                if (GETBINSTREAM_LONG_LONG_METHOD == null) {
                    SQLException sQLException = DatabaseError.createSqlException(1, "Cannot get binary stream");
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$13, this, sQLException);
                    }
                    throw sQLException;
                }
                Method m2 = GETBINSTREAM_LONG_LONG_METHOD;
                this.failoverMngr.setLobStreamInRequest(true);
                this.preForAll(m2, this, (long)pos, (long)length);
                try {
                    InputStream delegateReturn;
                    OracleBlob delegate = (OracleBlob)this.getDelegate();
                    if (this.isFreed) {
                        SQLException sqlexc = DatabaseError.createSqlException(delegate.getInternalConnection(), 192);
                        sqlexc.fillInStackTrace();
                        SQLException sQLException = sqlexc;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$13, this, sQLException);
                        }
                        throw sQLException;
                    }
                    if (delegate.canReadBasicLobDataInLocator()) {
                        delegateReturn = delegate.getBinaryStream((long)pos, (long)length);
                    } else {
                        long lobLen = delegate.length();
                        if (pos < 1L || length < 0L || pos > lobLen || pos - 1L + length > lobLen) {
                            SQLException sqlexc = DatabaseError.createSqlException(delegate.getInternalConnection(), 68);
                            sqlexc.fillInStackTrace();
                            SQLException sQLException = sqlexc;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$13, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$13, this, sQLException);
                            }
                            throw sQLException;
                        }
                        delegateReturn = delegate.getDBAccess().newInputStream((OracleBlob)((Object)this), delegate.getBufferSize(), (long)pos, (long)length);
                    }
                    inputStream = (InputStream)this.postForAll(m2, delegateReturn);
                    if (!bl) break block15;
                }
                catch (SQLException sqlexc) {
                    InputStream inputStream2 = (InputStream)this.postForAll(m2, this.onErrorForAll(m2, sqlexc));
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$13, this, inputStream2);
                        ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$13, this, null);
                    }
                    return inputStream2;
                }
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$13, this, inputStream);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$13, this, null);
            }
            return inputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public OutputStream setBinaryStream(long l2) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            OutputStream outputStream;
            block11: {
                void pos;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$14, this, l2);
                }
                if (SETBINSTREAM_LONG_METHOD == null) {
                    SQLException sQLException = DatabaseError.createSqlException(1, "Cannot set binary stream");
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$14, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$14, this, sQLException);
                    }
                    throw sQLException;
                }
                Method m2 = SETBINSTREAM_LONG_METHOD;
                this.failoverMngr.setLobStreamInRequest(true);
                this.preForAll(m2, this, (long)pos);
                try {
                    OracleBlob delegate = (OracleBlob)this.getDelegate();
                    if (this.isFreed) {
                        SQLException sqlexc = DatabaseError.createSqlException(delegate.getInternalConnection(), 192);
                        sqlexc.fillInStackTrace();
                        SQLException sQLException = sqlexc;
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$14, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$14, this, sQLException);
                        }
                        throw sQLException;
                    }
                    OutputStream delegateReturn = delegate.getDBAccess().newOutputStream((OracleBlob)((Object)this), delegate.getBufferSize(), (long)pos, true);
                    outputStream = (OutputStream)this.postForAll(m2, delegateReturn);
                    if (!bl) break block11;
                }
                catch (SQLException sqlexc) {
                    OutputStream outputStream2 = (OutputStream)this.postForAll(m2, this.onErrorForAll(m2, sqlexc));
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$14, this, outputStream2);
                        ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$14, this, null);
                    }
                    return outputStream2;
                }
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$14, this, outputStream);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$14, this, null);
            }
            return outputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    public OutputStream getBinaryOutputStream() throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$15, this, new Object[0]);
            }
            OutputStream outputStream = this.setBinaryStream(1L);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$15, this, outputStream);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$15, this, null);
            }
            return outputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public OutputStream getBinaryOutputStream(long l2) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void pos;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$16, this, l2);
            }
            OutputStream outputStream = this.setBinaryStream((long)pos);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$16, this, outputStream);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$16, this, null);
            }
            return outputStream;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public OracleConnection getInternalConnection() throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$17, this, new Object[0]);
            }
            OracleBlob delegate = (OracleBlob)this.getDelegate();
            OracleConnection oracleConnection = delegate.getInternalConnection();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$17, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$17, this, null);
            }
            return oracleConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, TxnReplayableBlob.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$18 = TxnReplayableBlob.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$17 = TxnReplayableBlob.class.getDeclaredMethod("getInternalConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$16 = TxnReplayableBlob.class.getDeclaredMethod("getBinaryOutputStream", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$15 = TxnReplayableBlob.class.getDeclaredMethod("getBinaryOutputStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$14 = TxnReplayableBlob.class.getDeclaredMethod("setBinaryStream", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$13 = TxnReplayableBlob.class.getDeclaredMethod("getBinaryStream", Long.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$12 = TxnReplayableBlob.class.getDeclaredMethod("getBinaryStream", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$11 = TxnReplayableBlob.class.getDeclaredMethod("getBinaryStream", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$10 = TxnReplayableBlob.class.getDeclaredMethod("onErrorForAll", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$9 = TxnReplayableBlob.class.getDeclaredMethod("onErrorVoidForAll", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$8 = TxnReplayableBlob.class.getDeclaredMethod("postForFree", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$7 = TxnReplayableBlob.class.getDeclaredMethod("postForClose", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$6 = TxnReplayableBlob.class.getDeclaredMethod("postForAll", Method.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$5 = TxnReplayableBlob.class.getDeclaredMethod("postForAll", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$4 = TxnReplayableBlob.class.getDeclaredMethod("preForAll", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$3 = TxnReplayableBlob.class.getDeclaredMethod("getSetBinaryStreamLongMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$2 = TxnReplayableBlob.class.getDeclaredMethod("getGetBinaryStreamLongLongMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$1 = TxnReplayableBlob.class.getDeclaredMethod("getGetBinaryStreamLongMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$0 = TxnReplayableBlob.class.getDeclaredMethod("getGetBinaryStreamMethod", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        GETBINSTREAM_METHOD = TxnReplayableBlob.getGetBinaryStreamMethod();
        GETBINSTREAM_LONG_METHOD = TxnReplayableBlob.getGetBinaryStreamLongMethod();
        GETBINSTREAM_LONG_LONG_METHOD = TxnReplayableBlob.getGetBinaryStreamLongLongMethod();
        SETBINSTREAM_LONG_METHOD = TxnReplayableBlob.getSetBinaryStreamLongMethod();
    }
}

