/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.runtime.JSRuntime;

public abstract class JSToUInt16Node
extends JavaScriptBaseNode {
    public abstract int executeInt(Object var1);

    public final char executeChar(Object value) {
        return (char)this.executeInt(value);
    }

    @Specialization
    protected int doInt(int value) {
        return JSRuntime.toUInt16(value);
    }

    @Specialization
    protected int doDouble(double value, @Cached InlinedBranchProfile needPositiveInfinityBranch) {
        if (JSRuntime.isPositiveInfinity(value)) {
            needPositiveInfinityBranch.enter((Node)this);
            return 0;
        }
        return JSRuntime.toUInt16((long)value);
    }

    @Specialization
    protected int doGeneric(Object value, @Cached JSToNumberNode toNumberNode) {
        return JSRuntime.toUInt16(toNumberNode.executeNumber(value));
    }
}

