/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.codec;

import com.oracle.truffle.api.strings.TruffleString;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class BinaryEncoder {
    private static final int INITIAL_BUFFER_SIZE = 8192;
    private ByteBuffer buffer = ByteBuffer.allocate(8192).order(ByteOrder.LITTLE_ENDIAN);

    public ByteBuffer getBuffer() {
        return this.buffer.duplicate().order(ByteOrder.LITTLE_ENDIAN).flip();
    }

    protected void putU1(long value) {
        this.ensureCapacity(1);
        this.buffer.put((byte)value);
    }

    private void ensureCapacity(int increase) {
        if (this.buffer.position() + increase >= this.buffer.limit()) {
            ByteBuffer oldBuffer = this.buffer;
            ByteBuffer newBuffer = ByteBuffer.allocate(Math.max(2 * oldBuffer.capacity(), oldBuffer.position() + increase)).order(ByteOrder.LITTLE_ENDIAN);
            newBuffer.put(oldBuffer.duplicate().flip());
            assert (newBuffer.position() == oldBuffer.position());
            assert (newBuffer.order() == ByteOrder.LITTLE_ENDIAN);
            this.buffer = newBuffer;
        }
    }

    private void putSV(long value) {
        long cur = value;
        while (true) {
            if (cur >= -64L && cur < 64L) {
                this.putU1(cur & 0x7FL);
                return;
            }
            this.putU1(0x80L | cur & 0x7FL);
            cur >>= 7;
        }
    }

    private void putUV(long value) {
        long cur = value;
        while (true) {
            assert (cur >= 0L);
            if (cur < 128L) {
                this.putU1(cur & 0x7FL);
                return;
            }
            this.putU1(0x80L | cur & 0x7FL);
            cur >>= 7;
        }
    }

    public void putInt(int value) {
        this.putSV(value);
    }

    public void putUInt(int value) {
        this.putUV(value);
    }

    public void putLong(long value) {
        this.putSV(value);
    }

    public void putDouble(double value) {
        this.putInt64(Double.doubleToRawLongBits(value));
    }

    public void putInt64(long value) {
        this.ensureCapacity(8);
        long cur = value;
        for (int i = 0; i < 8; ++i) {
            this.putU1(cur & 0xFFL);
            cur >>>= 8;
        }
    }

    public void putString(TruffleString value) {
        TruffleString.CompactionLevel compactionLevel = value.getStringCompactionLevelUncached(TruffleString.Encoding.UTF_16);
        this.putU1(compactionLevel.getLog2());
        if (compactionLevel == TruffleString.CompactionLevel.S1) {
            this.putByteArray(value.switchEncodingUncached(TruffleString.Encoding.ISO_8859_1).copyToByteArrayUncached(TruffleString.Encoding.ISO_8859_1));
        } else {
            assert (compactionLevel == TruffleString.CompactionLevel.S2) : compactionLevel;
            this.putByteArray(value.copyToByteArrayUncached(TruffleString.Encoding.UTF_16));
        }
    }

    public void putByteArray(byte[] value) {
        this.putUV(value.length);
        this.ensureCapacity(value.length);
        for (int i = 0; i < value.length; ++i) {
            this.putU1(value[i]);
        }
    }

    public void putBigInteger(BigInteger value) {
        BigInteger cur = value;
        while (true) {
            int intValue;
            if ((intValue = cur.intValue()) >= -64 && intValue < 64) {
                this.putU1(intValue & 0x7F);
                return;
            }
            this.putU1(0x80 | intValue & 0x7F);
            cur = cur.shiftRight(7);
        }
    }

    public void putInt32(int value) {
        this.ensureCapacity(4);
        int cur = value;
        for (int i = 0; i < 4; ++i) {
            this.putU1((long)cur & 0xFFL);
            cur >>>= 8;
        }
    }

    public int getPosition() {
        return this.buffer.position();
    }
}

