/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.intl;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.intl.DateTimeFormatPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSDate;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.intl.JSDateTimeFormat;
import com.oracle.truffle.js.runtime.builtins.intl.JSDateTimeFormatObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class DateTimeFormatPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<DateTimeFormatPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new DateTimeFormatPrototypeBuiltins();

    protected DateTimeFormatPrototypeBuiltins() {
        super(JSDateTimeFormat.PROTOTYPE_NAME, DateTimeFormatPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, DateTimeFormatPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return DateTimeFormatPrototypeBuiltinsFactory.JSDateTimeFormatResolvedOptionsNodeGen.create(context, builtin, DateTimeFormatPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 1: {
                return DateTimeFormatPrototypeBuiltinsFactory.JSDateTimeFormatFormatToPartsNodeGen.create(context, builtin, DateTimeFormatPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 2: {
                return DateTimeFormatPrototypeBuiltinsFactory.JSDateTimeFormatFormatRangeNodeGen.create(context, builtin, DateTimeFormatPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 3: {
                return DateTimeFormatPrototypeBuiltinsFactory.JSDateTimeFormatFormatRangeToPartsNodeGen.create(context, builtin, DateTimeFormatPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 4: {
                return DateTimeFormatPrototypeBuiltinsFactory.JSDateTimeFormatGetFormatNodeGen.create(context, builtin, DateTimeFormatPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum DateTimeFormatPrototype implements BuiltinEnum<DateTimeFormatPrototype>
    {
        resolvedOptions(0),
        formatToParts(1),
        formatRange(2),
        formatRangeToParts(2),
        format(0);

        private final int length;

        private DateTimeFormatPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public int getECMAScriptVersion() {
            return switch (this.ordinal()) {
                case 1 -> 8;
                case 2, 3 -> 12;
                default -> BuiltinEnum.super.getECMAScriptVersion();
            };
        }

        @Override
        public boolean isGetter() {
            return this == format;
        }
    }

    public static abstract class JSDateTimeFormatResolvedOptionsNode
    extends JSBuiltinNode {
        public JSDateTimeFormatResolvedOptionsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public Object doResolvedOptions(JSDateTimeFormatObject dateTimeFormat) {
            return JSDateTimeFormat.resolvedOptions(this.getContext(), this.getRealm(), dateTimeFormat);
        }

        @Fallback
        public Object throwTypeError(Object bummer) {
            throw Errors.createTypeErrorTypeXExpected(JSDateTimeFormat.CLASS_NAME);
        }
    }

    public static abstract class JSDateTimeFormatFormatToPartsNode
    extends JSBuiltinNode {
        public JSDateTimeFormatFormatToPartsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public Object doFormatToParts(JSDateTimeFormatObject dateTimeFormat, Object value) {
            return JSDateTimeFormat.formatToParts(this.getContext(), this.getRealm(), dateTimeFormat, value, null);
        }

        @Fallback
        public Object throwTypeError(Object bummer, Object value) {
            throw Errors.createTypeErrorTypeXExpected(JSDateTimeFormat.CLASS_NAME);
        }
    }

    public static abstract class JSDateTimeFormatFormatRangeNode
    extends JSBuiltinNode {
        public JSDateTimeFormatFormatRangeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public TruffleString doFormatRange(JSDateTimeFormatObject dateTimeFormat, Object startDate, Object endDate, @Cached JSToNumberNode startDateToNumberNode, @Cached JSToNumberNode endDateToNumberNode, @Cached InlinedBranchProfile errorBranch) {
            if (startDate == Undefined.instance || endDate == Undefined.instance) {
                errorBranch.enter((Node)this);
                throw Errors.createTypeErrorInvalidTimeValue();
            }
            Number xNumber = startDateToNumberNode.executeNumber(startDate);
            Number yNumber = endDateToNumberNode.executeNumber(endDate);
            double x = JSDate.timeClip(JSRuntime.toDouble(xNumber));
            double y = JSDate.timeClip(JSRuntime.toDouble(yNumber));
            if (Double.isNaN(x) || Double.isNaN(y)) {
                errorBranch.enter((Node)this);
                throw Errors.createRangeErrorInvalidTimeValue();
            }
            return JSDateTimeFormat.formatRange(dateTimeFormat, x, y);
        }

        @Fallback
        public Object throwTypeError(Object bummer, Object startDate, Object endDate) {
            throw Errors.createTypeErrorTypeXExpected(JSDateTimeFormat.CLASS_NAME);
        }
    }

    public static abstract class JSDateTimeFormatFormatRangeToPartsNode
    extends JSBuiltinNode {
        public JSDateTimeFormatFormatRangeToPartsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public Object doFormatRangeToParts(JSDateTimeFormatObject dateTimeFormat, Object startDate, Object endDate, @Cached JSToNumberNode startDateToNumberNode, @Cached JSToNumberNode endDateToNumberNode, @Cached InlinedBranchProfile errorBranch) {
            if (startDate == Undefined.instance || endDate == Undefined.instance) {
                errorBranch.enter((Node)this);
                throw Errors.createTypeErrorInvalidTimeValue();
            }
            Number xNumber = startDateToNumberNode.executeNumber(startDate);
            Number yNumber = endDateToNumberNode.executeNumber(endDate);
            double x = JSDate.timeClip(JSRuntime.toDouble(xNumber));
            double y = JSDate.timeClip(JSRuntime.toDouble(yNumber));
            if (Double.isNaN(x) || Double.isNaN(y)) {
                errorBranch.enter((Node)this);
                throw Errors.createRangeErrorInvalidTimeValue();
            }
            return JSDateTimeFormat.formatRangeToParts(this.getContext(), this.getRealm(), dateTimeFormat, x, y);
        }

        @Fallback
        public Object throwTypeError(Object bummer, Object startDate, Object endDate) {
            throw Errors.createTypeErrorTypeXExpected(JSDateTimeFormat.CLASS_NAME);
        }
    }

    public static abstract class JSDateTimeFormatGetFormatNode
    extends JSBuiltinNode {
        static final HiddenKey BOUND_OBJECT_KEY = new HiddenKey(Strings.toJavaString(JSDateTimeFormat.CLASS_NAME));
        @Node.Child
        private PropertySetNode setBoundObjectNode;

        public JSDateTimeFormatGetFormatNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.setBoundObjectNode = PropertySetNode.createSetHidden(BOUND_OBJECT_KEY, context);
        }

        @Specialization
        public Object doDateTimeFormat(JSDateTimeFormatObject dateTimeFormatObj, @Cached InlinedBranchProfile errorBranch) {
            JSDateTimeFormat.InternalState state = dateTimeFormatObj.getInternalState();
            if (state == null || !state.isInitialized()) {
                errorBranch.enter((Node)this);
                throw Errors.createTypeErrorMethodCalledOnNonObjectOrWrongType("format");
            }
            if (state.getBoundFormatFunction() == null) {
                JSFunctionData formatFunctionData = this.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.DateTimeFormatFormat, c -> JSDateTimeFormatGetFormatNode.createFormatFunctionData(c));
                JSFunctionObject formatFn = JSFunction.create(this.getRealm(), formatFunctionData);
                this.setBoundObjectNode.setValue((Object)formatFn, (Object)dateTimeFormatObj);
                state.setBoundFormatFunction(formatFn);
            }
            return state.getBoundFormatFunction();
        }

        @Fallback
        public Object doIncompatibleReceiver(Object bummer) {
            throw Errors.createTypeErrorTypeXExpected(JSDateTimeFormat.CLASS_NAME);
        }

        private static JSFunctionData createFormatFunctionData(final JSContext context) {
            return JSFunctionData.createCallOnly(context, (CallTarget)new JavaScriptRootNode(context.getLanguage(), null, null){
                @Node.Child
                private PropertyGetNode getBoundObjectNode;
                {
                    super(lang, sourceSection, frameDescriptor);
                    this.getBoundObjectNode = PropertyGetNode.createGetHidden(BOUND_OBJECT_KEY, context);
                }

                public Object execute(VirtualFrame frame) {
                    Object[] arguments = frame.getArguments();
                    JSDateTimeFormatObject thisObj = (JSDateTimeFormatObject)((Object)this.getBoundObjectNode.getValue(JSArguments.getFunctionObject(arguments)));
                    JSDynamicObject n = JSArguments.getUserArgumentCount(arguments) > 0 ? JSArguments.getUserArgument(arguments, 0) : Undefined.instance;
                    return JSDateTimeFormat.format(thisObj, (Object)n);
                }
            }.getCallTarget(), 1, Strings.EMPTY_STRING);
        }
    }
}

