/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime.collection;

import com.oracle.truffle.runtime.collection.SerialQueue;
import java.util.ArrayList;
import java.util.Arrays;

public final class BTreeQueue<E>
implements SerialQueue<E> {
    private static final Object FAILURE_DUPLICATE = new Object();
    private static final Object SUCCESS = new Object();
    private static final Object MAX_ELEMENT = new Object(){

        public String toString() {
            return "<max-value>";
        }
    };
    private static final int BRANCHING_FACTOR = 16;
    private Node<E> root = new Leaf(MAX_ELEMENT);

    private Object insert(Node<E> node, E x) {
        Node c;
        Object result;
        int pos;
        if (node.isLeaf()) {
            if (node.count < 16) {
                int pos2 = 0;
                Object cur = null;
                while ((cur = node.children[pos2]) != null) {
                    if (cur == x) {
                        return FAILURE_DUPLICATE;
                    }
                    if (this.compareUnique(cur, x) >= 0) break;
                    ++pos2;
                }
                Object prev = x;
                while (prev != null) {
                    node.children[pos2] = prev;
                    prev = cur;
                    cur = ++pos2 < node.children.length ? node.children[pos2] : null;
                }
                ++node.count;
                if (node.pivot != MAX_ELEMENT && node.pivot != node.children[node.count - 1]) {
                    node.pivot = node.children[node.count - 1];
                }
                return SUCCESS;
            }
            int siblingStart = 8;
            Object midElement = node.children[siblingStart - 1];
            Leaf sibling = new Leaf(node.pivot);
            node.pivot = midElement;
            int npos = siblingStart;
            int spos = 0;
            while (npos < 16) {
                sibling.children[spos] = node.children[npos];
                ++sibling.count;
                node.children[npos] = null;
                --node.count;
                ++npos;
                ++spos;
            }
            if (this.compareUnique(x, midElement) < 0) {
                this.insert(node, x);
            } else {
                this.insert(sibling, x);
            }
            return sibling;
        }
        Inner inner = (Inner)node;
        Node child = null;
        for (pos = 0; pos < 16; ++pos) {
            Node candidate = (Node)inner.children[pos];
            if (candidate == null) {
                throw new IllegalStateException("Child not found for: " + String.valueOf(x));
            }
            if (this.compareUnique(candidate.pivot, x) <= 0) continue;
            child = candidate;
            break;
        }
        if ((result = this.insert(child, x)) == SUCCESS) {
            ++inner.count;
            return result;
        }
        if (result == FAILURE_DUPLICATE) {
            return result;
        }
        Node nchild = (Node)result;
        ++inner.count;
        inner.count -= nchild.count;
        if (inner.childCount < 16) {
            this.insertChildAt(inner, ++pos, nchild);
            return SUCCESS;
        }
        int siblingStart = 8;
        Object midElement = ((Node)inner.children[siblingStart - 1]).pivot;
        Inner sibling = new Inner(inner.pivot);
        if (this.compare(sibling.pivot, nchild.pivot) < 0) {
            sibling.pivot = nchild.pivot;
        }
        inner.pivot = midElement;
        int npos = siblingStart;
        int spos = 0;
        while (npos < 16) {
            c = (Node)inner.children[npos];
            sibling.children[spos] = c;
            ++sibling.childCount;
            sibling.count += c.count;
            inner.children[npos] = null;
            --inner.childCount;
            inner.count -= c.count;
            ++npos;
            ++spos;
        }
        Inner target = this.compareUnique(nchild.pivot, inner.pivot) <= 0 ? inner : sibling;
        for (int tpos = 0; tpos < 16; ++tpos) {
            c = (Node)target.children[tpos];
            if (c == null) {
                target.children[tpos] = nchild;
                ++target.childCount;
                target.count += nchild.count;
                return sibling;
            }
            if (this.compare(nchild.pivot, c.pivot) > 0) continue;
            this.insertChildAt(target, tpos, nchild);
            return sibling;
        }
        throw new IllegalStateException("Could not find the insertion point after split: " + String.valueOf(target) + ", new child: " + String.valueOf(nchild.pivot));
    }

    private void insertChildAt(Inner<E> inner, int from, Node<E> nchild) {
        int pos = from;
        Node cur = (Node)inner.children[pos];
        Node prev = nchild;
        while (prev != null) {
            inner.children[pos] = prev;
            prev = cur;
            cur = ++pos < inner.children.length ? (Node)inner.children[pos] : null;
        }
        ++inner.childCount;
        inner.count += nchild.count;
    }

    private boolean insertRoot(E x) {
        Object result = this.insert(this.root, x);
        if (result == SUCCESS) {
            return true;
        }
        if (result instanceof Node) {
            Node sibling = (Node)result;
            Inner nroot = new Inner(null);
            if (this.compareUnique(this.root.pivot, sibling.pivot) < 0) {
                nroot.children[0] = this.root;
                nroot.children[1] = sibling;
                nroot.pivot = sibling.pivot;
            } else {
                nroot.children[0] = sibling;
                nroot.children[1] = this.root;
                nroot.pivot = this.root.pivot;
            }
            nroot.count = this.root.count + sibling.count;
            nroot.childCount = 2;
            this.root = nroot;
            return true;
        }
        if (result == FAILURE_DUPLICATE) {
            throw new IllegalArgumentException("Inserted duplicate key: " + String.valueOf(x));
        }
        throw new IllegalStateException("Unexpected result: " + String.valueOf(result));
    }

    private int compareUnique(Object a, Object b) {
        if (a == MAX_ELEMENT) {
            if (b == MAX_ELEMENT) {
                return 0;
            }
            return 1;
        }
        if (b == MAX_ELEMENT) {
            return -1;
        }
        int result = ((Comparable)a).compareTo(b);
        if (result != 0) {
            return result;
        }
        throw new UnsupportedOperationException("Two different objects must not be equal in comparison.");
    }

    private int compare(Object a, Object b) {
        if (a == MAX_ELEMENT) {
            if (b == MAX_ELEMENT) {
                return 0;
            }
            return 1;
        }
        if (b == MAX_ELEMENT) {
            return -1;
        }
        return ((Comparable)a).compareTo(b);
    }

    @Override
    public void add(E x) {
        this.insertRoot(x);
    }

    @Override
    public int addIndexOf(E x) {
        this.add(x);
        return this.indexOf(x);
    }

    @Override
    public int indexOf(E x) {
        int pos;
        int count = 0;
        Node node = this.root;
        while (!node.isLeaf()) {
            for (pos = 0; pos < 16; ++pos) {
                Node child = (Node)node.children[pos];
                if (this.compare(x, child.pivot) <= 0) {
                    node = child;
                    break;
                }
                count += child.count;
            }
            if (pos != 16) continue;
            throw new IllegalStateException("Key " + String.valueOf(x) + " cannot be found in node: " + String.valueOf(node));
        }
        for (pos = 0; pos < 16; ++pos) {
            Object cur = node.children[pos];
            if (cur == null) {
                return -1;
            }
            int comparison = this.compare(x, cur);
            if (comparison == 0) {
                return count;
            }
            ++count;
        }
        return -1;
    }

    public int indexBefore(E x) {
        int pos;
        int count = 0;
        Node node = this.root;
        while (!node.isLeaf()) {
            for (pos = 0; pos < 16; ++pos) {
                Node child = (Node)node.children[pos];
                if (this.compare(x, child.pivot) <= 0) {
                    node = child;
                    break;
                }
                count += child.count;
            }
            if (pos != 16) continue;
            throw new IllegalStateException("Key " + String.valueOf(x) + " cannot be found in node: " + String.valueOf(node));
        }
        for (pos = 0; pos < 16; ++pos) {
            Object cur = node.children[pos];
            if (cur == null) {
                return count;
            }
            int comparison = this.compare(x, cur);
            if (comparison <= 0) {
                return count;
            }
            ++count;
        }
        return count;
    }

    @Override
    public E poll() {
        return this.removeFirstRoot();
    }

    private E removeFirstRoot() {
        Object result = this.removeFirst(this.root);
        if (result instanceof Compress) {
            Compress compress = (Compress)result;
            if (compress.target == this.root) {
                this.root = new Leaf(MAX_ELEMENT);
            }
            this.insertAll(compress.target);
            return compress.removedValue;
        }
        return (E)result;
    }

    private void insertAll(Node<E> node) {
        if (node.isLeaf()) {
            Object element;
            for (int pos = 0; pos < 16 && (element = node.children[pos]) != null; ++pos) {
                this.insertRoot(element);
            }
        } else {
            Node child;
            for (int pos = 0; pos < 16 && (child = (Node)node.children[pos]) != null; ++pos) {
                this.insertAll(child);
            }
        }
    }

    private Object removeFirst(Node<E> node) {
        if (node instanceof Leaf) {
            Object result = node.children[0];
            if (result == null) {
                return null;
            }
            for (int pos = 0; pos < 16; ++pos) {
                Object next;
                node.children[pos] = next = pos + 1 < node.children.length ? node.children[pos + 1] : null;
                if (next == null) break;
            }
            --node.count;
            if (node.count == 1 && node != this.root) {
                return new Compress(result, (Leaf)node);
            }
            return result;
        }
        Node child = (Node)node.children[0];
        Object result = this.removeFirst(child);
        --node.count;
        if (result instanceof Compress) {
            Inner inner = (Inner)node;
            Compress compress = (Compress)result;
            if (compress.target == child) {
                if (inner.childCount == 2) {
                    compress.target = inner;
                } else {
                    for (int pos = 0; pos < 16; ++pos) {
                        Node next = pos + 1 < node.children.length ? (Node)node.children[pos + 1] : null;
                        node.children[pos] = next;
                        if (next == null) break;
                    }
                    --inner.childCount;
                    inner.count -= child.count;
                }
            } else {
                inner.count -= compress.target.count;
            }
        }
        return result;
    }

    @Override
    public E peek() {
        return this.lookupFirst(this.root);
    }

    private E lookupFirst(Node<E> node) {
        if (node instanceof Leaf) {
            return (E)node.children[0];
        }
        return this.lookupFirst((Node)node.children[0]);
    }

    @Override
    public void clear() {
        this.root = new Leaf(MAX_ELEMENT);
    }

    @Override
    public int size() {
        return this.root.count;
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.root.count];
        this.toArray(result, 0, this.root);
        return result;
    }

    private void toArray(Object[] result, int from, Node<E> node) {
        if (node.isLeaf()) {
            Object element;
            int i = from;
            for (int pos = 0; pos < 16 && (element = node.children[pos]) != null; ++pos) {
                result[i] = element;
                ++i;
            }
        } else {
            Node child;
            int updatedFrom = from;
            for (int pos = 0; pos < 16 && (child = (Node)node.children[pos]) != null; ++pos) {
                this.toArray(result, updatedFrom, child);
                updatedFrom += child.count;
            }
        }
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return null;
    }

    @Override
    public int internalCapacity() {
        return -1;
    }

    public void checkInvariants() {
        this.check(this.root, null);
    }

    private int check(Node<E> node, Object maxArg) {
        Object max = maxArg;
        if (node instanceof Leaf) {
            boolean nullSeen = false;
            int count = 0;
            for (int i = 0; i < node.children.length; ++i) {
                Object x = node.children[i];
                if (nullSeen) {
                    BTreeQueue.ensure(x == null, "After first null, all children must be null: %s", node);
                    continue;
                }
                if (x == null) {
                    nullSeen = true;
                    continue;
                }
                ++count;
                if (max != null) {
                    BTreeQueue.ensure(this.compareUnique(max, x) < 0, "Elements must be ordered: %s", node);
                }
                max = x;
            }
            BTreeQueue.ensure(max == node.pivot || node.pivot == MAX_ELEMENT, "Pivot must be the largest element: %s", node);
            BTreeQueue.ensure(count == node.count, "Count must correspond to the number of non-null slots: %s", node);
        } else {
            Inner inner = (Inner)node;
            boolean nullSeen = false;
            int count = 0;
            int childCount = 0;
            for (int i = 0; i < inner.children.length; ++i) {
                Node child = (Node)inner.children[i];
                if (nullSeen) {
                    BTreeQueue.ensure(child == null, "After first null, all children must be null: %s", inner);
                    continue;
                }
                if (child == null) {
                    nullSeen = true;
                    continue;
                }
                this.check(child, max);
                ++childCount;
                count += child.count;
                if (max != null) {
                    BTreeQueue.ensure(this.compareUnique(max, child.pivot) < 0, "Elements must be ordered: %s", inner);
                }
                max = child.pivot;
            }
            BTreeQueue.ensure(max == inner.pivot || inner.pivot == MAX_ELEMENT, "Pivot must be the largest child key: %s", inner);
            BTreeQueue.ensure(count == inner.count, "Count must correspond to the sum of child counts: %s", inner);
            BTreeQueue.ensure(childCount == inner.childCount, "Child count must correspond to the number children: %s", inner);
        }
        return node.count;
    }

    private static void ensure(boolean condition, String title, Object value) {
        if (!condition) {
            throw new IllegalStateException(String.format(title, value));
        }
    }

    public String prettyString() {
        StringBuilder result = new StringBuilder(128);
        this.prettyString(this.root, 0, result);
        return result.toString();
    }

    private void prettyString(Node<E> node, int indentation, StringBuilder result) {
        int i;
        for (i = 0; i < indentation; ++i) {
            result.append(" ");
        }
        if (node instanceof Inner) {
            Inner inner = (Inner)node;
            result.append("<# = " + inner.count + ", max = " + String.valueOf(inner.pivot) + ", #child = " + inner.childCount + ">");
            result.append(System.lineSeparator());
            for (int i2 = 0; i2 < inner.childCount; ++i2) {
                this.prettyString((Node)inner.children[i2], indentation + 2, result);
            }
        } else {
            result.append("<# = " + node.count + ", max = " + String.valueOf(node.pivot) + "; ");
            for (i = 0; i < node.count; ++i) {
                result.append(node.children[i]).append(", ");
            }
            for (i = node.count; i < node.children.length; ++i) {
                result.append((String)(node.children[i] != null ? "!! " + String.valueOf(node.children[i]) + " !!" : ".")).append(", ");
            }
            result.append(">");
            result.append(System.lineSeparator());
        }
    }

    private static final class Leaf<E>
    extends Node<E> {
        Leaf(Object pivot) {
            super(pivot);
        }

        public String toString() {
            return String.format("Leaf(pivot = %s, count = %d; %s)", this.pivot, this.count, Arrays.asList(this.children));
        }
    }

    private static abstract class Node<E> {
        Object pivot;
        int count;
        final Object[] children;

        Node(Object pivot) {
            this.pivot = pivot;
            this.count = 0;
            this.children = new Object[16];
        }

        public boolean isLeaf() {
            return this instanceof Leaf;
        }
    }

    private static final class Inner<E>
    extends Node<E> {
        int childCount = 0;

        Inner(Object pivot) {
            super(pivot);
        }

        public String toString() {
            ArrayList<Object> childPivots = new ArrayList<Object>();
            for (Object c : this.children) {
                if (c == null) continue;
                childPivots.add(((Node)c).pivot);
            }
            return String.format("Inner(pivot = %s, count = %d; %s)", this.pivot, this.count, childPivots);
        }
    }

    private class Compress {
        final E removedValue;
        Node<E> target;

        Compress(E removedValue, Leaf<E> target) {
            this.removedValue = removedValue;
            this.target = target;
        }
    }
}

