/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.jcc.am;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;

public class LicenseEntry
implements Serializable {
    private static final long serialVersionUID = 6360267333959868353L;
    private static final String LICENSE_TYPE_O_STRING = "O";
    public static final String LICENSE_TYPE_ZS_STRING = "ZS";
    public static final String LICENSE_TYPE_IS_STRING = "IS";
    private static final String LICENSE_TYPE_AS_STRING = "AS";
    private static final String LICENSE_TYPE_EE_STRING = "EE";
    private static final String LICENSE_TYPE_PE_STRING = "PE";
    public static final String LICENSE_TYPE_TL_STRING = "TL";
    public static final String LICENSE_TYPE_LUW_STRING = "LUW";
    public static final int LICENSE_TYPE = 0;
    public static final int LICENSE_TYPE_TL = 1;
    public static final int CALL_SP = 1;
    public static final int CALL_UDF = 2;
    public static final int CURRENT_LICENSEDISKFILE_VERSION = 0;
    public static final int LICENSE_LEASE_PERIOD_SP = 7;
    public static final int LICENSE_LEASE_PERIOD_UDF = 90;
    private static final String key = "key";
    private String server_ = null;
    private int port_ = 0;
    private String databaseName_ = null;
    private String key_ = null;
    private long lastActivationTime_ = 0L;
    private String retval_ = null;
    private String[] licenseType_ = new String[2];
    private long[] expirationDate_ = new long[2];
    private int version_ = 0;
    private String controllerURL_ = null;
    private static final DateFormat dateFormat__ = new SimpleDateFormat("MMddyy");
    private static Calendar calendar_ = null;

    public LicenseEntry(String string, int n2, String string2, String[] stringArray, long[] lArray, long l2, int n3, String string3, String string4) {
        this.server_ = string;
        this.port_ = n2;
        this.databaseName_ = string2;
        this.licenseType_ = stringArray;
        this.key_ = this.server_ + ":" + this.port_ + ":" + this.databaseName_;
        this.expirationDate_ = lArray;
        this.lastActivationTime_ = l2;
        this.version_ = n3;
        this.controllerURL_ = string3;
        this.retval_ = string4;
    }

    public String getKey() {
        return this.key_;
    }

    public String getServerName() {
        return this.server_;
    }

    public int getPort() {
        return this.port_;
    }

    public String getDatabaseName() {
        return this.databaseName_;
    }

    public String getLastReturnedValue() {
        return this.retval_;
    }

    public long getLastActivationTime() {
        return this.lastActivationTime_;
    }

    public String[] getLicenseType() {
        return this.licenseType_;
    }

    public long[] getExpirationDate() {
        return this.expirationDate_;
    }

    public int getVersion() {
        return this.version_;
    }

    public String getControllerURL() {
        return this.controllerURL_;
    }

    public synchronized void update(String[] stringArray, long[] lArray, String string, long l2, int n2, String string2) {
        this.licenseType_ = stringArray;
        this.expirationDate_ = lArray;
        this.lastActivationTime_ = l2;
        this.retval_ = string;
        this.version_ = n2;
        this.controllerURL_ = string2;
    }

    public synchronized void updateLastActivationTime(long l2) {
        this.lastActivationTime_ = l2;
    }

    public synchronized void updateReturnValue(String string) {
        this.retval_ = string;
    }

    public synchronized void updateLicenseType(String[] stringArray) {
        this.licenseType_ = stringArray;
    }

    public synchronized void updateExpirationDate(long[] lArray) {
        this.expirationDate_ = lArray;
    }

    public synchronized boolean checkIfLeaseTimeExpired() {
        return LicenseEntry.checkIfLeaseTimeExpired(this.expirationDate_);
    }

    /*
     * Unable to fully structure code
     */
    protected static Object[] validateLicense(String var0, int var1_1, int var2_2) {
        block19: {
            block18: {
                var3_3 = new String[2];
                var4_4 = new long[2];
                var5_5 = null;
                var6_6 = null;
                if (var0 != null) {
                    var7_7 = new StringTokenizer(var0, ";");
                    while (var7_7.hasMoreTokens()) {
                        var8_8 = var7_7.nextToken();
                        if (var8_8.startsWith("L:")) {
                            var5_5 = LicenseEntry.decryptLicenseToken(var8_8.substring(2));
                            if (var5_5.startsWith("TL")) {
                                var3_3[1] = "TL";
                                var9_9 = null;
                                try {
                                    var9_9 = LicenseEntry.dateFormat__.parse(var5_5.substring(6));
                                }
                                catch (ParseException var10_10) {
                                    var9_9 = null;
                                }
                                var4_4[1] = LicenseEntry.addDaysToLease((Date)var9_9, 1);
                                continue;
                            }
                            var9_9 = LicenseEntry.getLiceneseTypeString(var5_5);
                            try {
                                if (var9_9 == null) continue;
                                var3_3[0] = var9_9;
                                var4_4[0] = LicenseEntry.addDaysToLease(var1_1);
                                continue;
                            }
                            catch (ParseException v0) {
                                throw LicenseEntry.b(v0);
                            }
                        }
                        try {
                            if (var8_8.startsWith("C:") || !var8_8.startsWith("c:")) continue;
                        }
                        catch (ParseException v1) {
                            throw LicenseEntry.b(v1);
                        }
                    }
                } else {
                    try {
                        if (var2_2 == 4) ** GOTO lbl42
                        var3_3[0] = "ZS";
                        var4_4[0] = LicenseEntry.addDaysToLease(var1_1);
                    }
                    catch (ParseException v2) {
                        throw LicenseEntry.b(v2);
                    }
                }
lbl42:
                // 3 sources

                try {
                    if (var2_2 == 4) {
                        var3_3[0] = "LUW";
                        var4_4[0] = LicenseEntry.addDaysToLease(var1_1);
                    }
                }
                catch (ParseException v3) {
                    throw LicenseEntry.b(v3);
                }
                try {
                    if (LicenseEntry.checkIfLeaseTimeExpired(var4_4)) break block18;
                    v4 = new Object[3];
                    v4[0] = var3_3;
                    v4[1] = var4_4;
                    v5 = v4;
                    v4[2] = var6_6;
                    break block19;
                }
                catch (ParseException v6) {
                    throw LicenseEntry.b(v6);
                }
            }
            v5 = null;
        }
        return v5;
    }

    private static String getLiceneseTypeString(String string) {
        if (string.startsWith(LICENSE_TYPE_O_STRING)) {
            return LICENSE_TYPE_O_STRING;
        }
        if (string.startsWith(LICENSE_TYPE_ZS_STRING)) {
            return LICENSE_TYPE_ZS_STRING;
        }
        if (string.startsWith(LICENSE_TYPE_IS_STRING)) {
            return LICENSE_TYPE_IS_STRING;
        }
        if (string.startsWith(LICENSE_TYPE_AS_STRING)) {
            return LICENSE_TYPE_AS_STRING;
        }
        if (string.startsWith(LICENSE_TYPE_EE_STRING)) {
            return LICENSE_TYPE_EE_STRING;
        }
        if (string.startsWith(LICENSE_TYPE_PE_STRING)) {
            return LICENSE_TYPE_PE_STRING;
        }
        return null;
    }

    protected String getLicenseErrorMessage() {
        String string = null;
        if (this.expirationDate_[0] == 0L && this.expirationDate_[1] == 0L) {
            string = "No valid server license found.";
        } else if (this.expirationDate_[1] > 0L) {
            Date date = new Date(this.expirationDate_[1]);
            string = "Trial license expired on " + date.toString();
        } else {
            string = "Unable to validate server license.";
        }
        return string;
    }

    private static boolean checkIfLeaseTimeExpired(long[] lArray) {
        boolean bl2 = true;
        long l2 = System.currentTimeMillis();
        if (lArray != null) {
            for (int i10 = 0; i10 < lArray.length; ++i10) {
                if (l2 >= lArray[i10]) continue;
                return false;
            }
        }
        return bl2;
    }

    private static Calendar getCalendar() {
        if (calendar_ == null) {
            calendar_ = Calendar.getInstance();
        }
        return calendar_;
    }

    private static long addDaysToLease(Date date, int n2) {
        Calendar calendar = LicenseEntry.getCalendar();
        calendar.setTime(date);
        calendar.add(5, n2);
        return calendar.getTime().getTime();
    }

    private static long addDaysToLease(int n2) {
        int n3 = 0;
        if (n2 == 1) {
            n3 = 7;
        } else if (n2 == 2) {
            n3 = 90;
        }
        long l2 = System.currentTimeMillis();
        return l2 += 86400000L * (long)n3;
    }

    public static String decryptLicenseToken(String string) {
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(16);
        int n3 = key.length();
        for (int i10 = 0; i10 < string.length(); i10 += 2) {
            byte by2 = (byte)string.charAt(i10);
            by2 = (byte)(by2 - 64);
            by2 = (byte)(by2 << 4);
            byte by3 = (byte)string.charAt(i10 + 1);
            by3 = (byte)(by3 - 64);
            by2 = (byte)(by2 + by3);
            int n4 = by2 ^ key.charAt(n2);
            stringBuffer.append((char)n4);
            if (++n2 < n3) continue;
            n2 = 0;
        }
        return stringBuffer.toString();
    }

    private static ParseException b(ParseException parseException) {
        return parseException;
    }
}

