/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.generatePdqXml;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlSpecialRegValuesSet;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatementAttributes;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatementDescriptor;
import com.ibm.db2.cmx.runtime.internal.xml.XmlTags;
import com.ibm.db2.cmx.tools.internal.ToolsLogger;
import com.ibm.db2.cmx.tools.internal.generatePdqXml.PDQXmlStatementForGeneratePureQueryXml;
import com.ibm.db2.cmx.tools.internal.generatePdqXml.SQLFile;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.ArtifactOptionsSet;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.PossibleArgs;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SQLScriptFile
extends SQLFile {
    private static final boolean carriageReturnPlusLineFeedIsOnlyOneNewLine_ = "\r\n".equals(XmlTags.CRLF);
    final String delimiter_;
    final String commentStart_;
    private boolean statementAttributesVary_ = false;

    SQLScriptFile(ArtifactOptionsSet artifactOptionsSet, String string, PDQXmlSpecialRegValuesSet pDQXmlSpecialRegValuesSet) {
        super(artifactOptionsSet, string, pDQXmlSpecialRegValuesSet);
        this.delimiter_ = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.STATEMENT_DELIMITER);
        if (this.delimiter_ != null && this.delimiter_.equals("/*")) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_STMT_DELIM", new Object[0]), null, 10960);
        }
        this.commentStart_ = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.COMMENT_START);
        if (this.commentStart_ != null && this.commentStart_.equals("/*")) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_COMMENT_START", new Object[0]), null, 10961);
        }
    }

    @Override
    public boolean statementAttributesVary() {
        this.throwExceptionIfParseMethodHasNotCompleted("statementAttributesVary", Messages.getText("ERR_METHOD_CALLED_OUT_OF_ORDER_SQL_SCRIPT_PARSING_INCOMPLETE", new Object[0]));
        return this.statementAttributesVary_;
    }

    @Override
    List<PDQXmlStatementForGeneratePureQueryXml> parseFileAndReturnStatementList(Connection connection, BufferedReader bufferedReader) throws IOException {
        ArrayList<PDQXmlStatementForGeneratePureQueryXml> arrayList = new ArrayList<PDQXmlStatementForGeneratePureQueryXml>();
        String string = SQLScriptFile.readToString(bufferedReader);
        Pattern pattern = Pattern.compile("(resultSet[a-zA-Z]+)=([a-zA-Z_]+)");
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n", true);
        PDQXmlStatementAttributes pDQXmlStatementAttributes = this.createPDQXmlStatementAttributesWithDefaultAttributesForFile();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n2 = 1;
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            int n3;
            int n4;
            String string3;
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("\n")) {
                if (bl3) {
                    stringBuilder.append("\n");
                }
                if (!carriageReturnPlusLineFeedIsOnlyOneNewLine_ || !bl5) {
                    ++n2;
                }
                bl5 = false;
                continue;
            }
            if (string4.equals("\r")) {
                if (bl3) {
                    stringBuilder.append("\r");
                }
                ++n2;
                bl5 = true;
                continue;
            }
            bl5 = false;
            String string5 = string4.replace(" ", "");
            string5 = string5.replace("\t", "");
            if (string4.matches(".*?\\*/[\\s\\t]*")) {
                string3 = stringBuilder.toString();
                if ((string3 = string3 + string4).matches("[\\s\\t]*/\\*(?:.|[\\n])*?\\*/[\\s\\t]*")) {
                    stringBuilder.setLength(0);
                    bl2 = false;
                    continue;
                }
            }
            if (!bl3 && (string3 = stringBuilder.toString()).matches("[\\s\\t]*")) {
                stringBuilder.setLength(0);
            }
            if (bl2 || !string5.startsWith(this.commentStart_)) {
                n4 = string4.length();
                for (n3 = 0; n3 < n4; ++n3) {
                    char c10 = string4.charAt(n3);
                    if (!bl2 && c10 == '\'') {
                        boolean bl6 = bl4 = !bl4;
                    }
                    if (n3 < n4 - 1 && !bl4) {
                        if (c10 == '/' && string4.charAt(n3 + 1) == '*') {
                            bl2 = true;
                        } else if (c10 == '*' && string4.charAt(n3 + 1) == '/') {
                            bl2 = false;
                        }
                    }
                    if (!bl2 && c10 != ' ' && c10 != '\t') {
                        bl3 = true;
                    }
                    if (!bl2 && !bl4 && c10 == this.delimiter_.charAt(0)) {
                        string2 = string4.substring(n3);
                        if ((string2 = string2.replaceAll("/\\*.*?\\*/", "")).startsWith(this.delimiter_) && string2.substring(this.delimiter_.length()).matches("[\\s\\t]*(?:/\\*.*)??")) {
                            this.appendSql(arrayList, stringBuilder, pDQXmlStatementAttributes, n2);
                            bl3 = false;
                            pDQXmlStatementAttributes = this.createPDQXmlStatementAttributesWithDefaultAttributesForFile();
                            stringBuilder.append(string2.substring(this.delimiter_.length()));
                            break;
                        }
                    }
                    stringBuilder.append(c10);
                }
            }
            if (bl2 || bl3 || bl4 || !string5.startsWith(this.commentStart_)) continue;
            string5 = string5.substring(this.commentStart_.length());
            Matcher matcher = pattern.matcher(string5);
            n3 = 0;
            n4 = 0;
            while (matcher.find(n3)) {
                string2 = matcher.group(1);
                String string6 = matcher.group(2);
                if (n3 < matcher.start()) {
                    ToolsLogger.getLogger().log(Level.WARNING, Messages.getText("ERR_SQLFILE_UNEXP_CHARS", String.valueOf(n2), string5.substring(n3, matcher.start())));
                    break;
                }
                if (string2.equals("resultSetType")) {
                    pDQXmlStatementAttributes.setType(SQLScriptFile.getRSType(string6));
                } else if (string2.equals("resultSetConcurrency")) {
                    pDQXmlStatementAttributes.setConcurrency(SQLScriptFile.getRSConcurrency(string6));
                } else if (string2.equals("resultSetHoldability")) {
                    pDQXmlStatementAttributes.setHoldability(SQLScriptFile.getRSHoldability(string6));
                } else {
                    ToolsLogger.getLogger().log(Level.WARNING, Messages.getText("ERR_SQLFILE_UNEXP_KEYVALUE", String.valueOf(n2), string2 + "=" + string6));
                    break;
                }
                n4 = n3;
                n3 = matcher.end();
                if (n3 >= string5.length()) break;
                char c11 = string5.charAt(n3);
                if (c11 != ',') {
                    ToolsLogger.getLogger().log(Level.WARNING, Messages.getText("ERR_SQLFILE_UNEXP_CHAR_COMMA", String.valueOf(n2), String.valueOf(c11)));
                    break;
                }
                if (++n3 < string5.length()) continue;
                break;
            }
            if (n4 <= 0 || n4 >= string5.length() - 1) continue;
            ToolsLogger.getLogger().log(Level.WARNING, Messages.getText("ERR_SQLFILE_UNEXP_CHARS_IGNORED", String.valueOf(n2), string5.substring(n4)));
        }
        if (bl2) {
            ToolsLogger.getLogger().log(Level.WARNING, Messages.getText("ERR_SQLFILE_EOF_COMMENT", new Object[0]));
        }
        if (bl3) {
            this.appendSql(arrayList, stringBuilder, pDQXmlStatementAttributes, n2);
        }
        return arrayList;
    }

    private void appendSql(List<PDQXmlStatementForGeneratePureQueryXml> list, StringBuilder stringBuilder, PDQXmlStatementAttributes pDQXmlStatementAttributes, int n2) {
        PDQXmlStatementForGeneratePureQueryXml pDQXmlStatementForGeneratePureQueryXml = new PDQXmlStatementForGeneratePureQueryXml();
        list.add(pDQXmlStatementForGeneratePureQueryXml);
        PDQXmlStatementDescriptor pDQXmlStatementDescriptor = this.getStatementDescriptor(pDQXmlStatementForGeneratePureQueryXml, pDQXmlStatementAttributes);
        pDQXmlStatementDescriptor.setSql(stringBuilder.toString());
        pDQXmlStatementDescriptor.setLineNumber(n2);
        this.statementAttributesVary_ |= this.doStatementAttributesDifferFromDefaults(pDQXmlStatementDescriptor);
        stringBuilder.setLength(0);
    }

    private static int getRSType(String string) {
        if (string == null) {
            return 1003;
        }
        return XmlTags.getCursorTypeNumber(string);
    }

    private static int getRSConcurrency(String string) {
        if (string == null) {
            return 1007;
        }
        return XmlTags.getConcurrencyNumber(string);
    }

    private static int getRSHoldability(String string) {
        if (string == null) {
            return 1;
        }
        return XmlTags.getHoldabilityNumber(string, 1);
    }

    private static void readToStringBuilder(Reader reader, StringBuilder stringBuilder) throws IOException {
        int n2;
        char[] cArray = new char[1024];
        while ((n2 = reader.read(cArray, 0, 1024)) != -1) {
            stringBuilder.append(cArray, 0, n2);
        }
    }

    private static String readToString(Reader reader) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        SQLScriptFile.readToStringBuilder(reader, stringBuilder);
        return stringBuilder.toString();
    }
}

