/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.generatePdqXml;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.StaticProfileConstants;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlCaptureStatistics;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlSpecialRegValuesSet;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatementAttributes;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatementDescriptor;
import com.ibm.db2.cmx.tools.internal.generatePdqXml.DynamicStatementCacheUtilities;
import com.ibm.db2.cmx.tools.internal.generatePdqXml.PDQXmlStatementForGeneratePureQueryXml;
import com.ibm.db2.cmx.tools.internal.generatePdqXml.SQLFile;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.ArtifactOptionsSet;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.PossibleArgs;
import java.io.BufferedReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DynamicStatementCache
extends SQLFile {
    private final List<PDQXmlStatementForGeneratePureQueryXml> statements_ = new ArrayList<PDQXmlStatementForGeneratePureQueryXml>();
    public static final String filterCacheByPropertyName_ = "filterCacheBy";
    public static final String clientInfoApplicationNamePropertyName_ = "ApplicationName";
    public static final String clientInfoClientAccountingInformationPropertyName_ = "ClientAccountingInformation";
    public static final String clientInfoClientHostNamePropertyName_ = "ClientHostName";
    public static final String clientInfoClientUserPropertyName_ = "ClientUser";
    private final String cacheFilterString_;
    private static final String storedProcedure_parameter_cacheFilter = "CACHE_FILTER";
    private static final String cachedStatements_column_01 = "GENERATED_NAME";
    private static final String cachedStatements_column_02 = "STATEMENT_ID";
    private static final String cachedStatements_column_03 = "USE_COUNT";
    private static final String cachedStatements_column_04 = "COPY_COUNT";
    private static final String cachedStatements_column_05 = "STATUS_FLAGS";
    private static final String cachedStatements_column_06 = "CACHE_INSERT_TIME";
    private static final String cachedStatements_column_executionStatistics_executionCount = "EXECUTION_COUNT";
    private static final String cachedStatements_column_08 = "SYNC_BUFR_RD_COUNT";
    private static final String cachedStatements_column_09 = "GETPAGE_COUNT";
    private static final String cachedStatements_column_10 = "ROWS_EXAMINED_CNT";
    private static final String cachedStatements_column_11 = "ROWS_AFFECTED_CNT";
    private static final String cachedStatements_column_12 = "SORT_COUNT";
    private static final String cachedStatements_column_13 = "INDEX_SCAN_COUNT";
    private static final String cachedStatements_column_14 = "TBLSPC_SCAN_COUNT";
    private static final String cachedStatements_column_15 = "PARALLEL_GRP_COUNT";
    private static final String cachedStatements_column_16 = "SYNC_BUFR_WRT_CNT";
    private static final String cachedStatements_column_executionStatistics_executionTime = "ACCUM_ELAPSED_TIME";
    private static final String cachedStatements_column_18 = "STMT_TXT_DEPR";
    private static final String cachedStatements_column_pkgThatDidPrepare = "PKG_THAT_DID_PREP";
    private static final String cachedStatements_column_20 = "SRC_CODE_LINE_NUM";
    private static final String cachedStatements_column_21 = "CLIENT_APPL_NAME";
    private static final String cachedStatements_column_22 = "CLIENT_USER_NAME";
    private static final String cachedStatements_column_specialRegister_sqlid = "CURRENT_SQLID";
    private static final String cachedStatements_column_specialRegister_schema = "CURRENT_SCHEMA";
    private static final String cachedStatements_column_25 = "ISOLATION_OF_PKG";
    private static final String cachedStatements_column_26 = "CURR_DATA_BIND_OPT";
    private static final String cachedStatements_column_27 = "DYNRULES_BIND_OPT";
    private static final String cachedStatements_column_specialRegister_degree = "CURRENT_DEGREE";
    private static final String cachedStatements_column_specialRegister_rules = "CURRENT_RULES";
    private static final String cachedStatements_column_specialRegister_precision = "CURRENT_PRECISION";
    private static final String cachedStatements_column_cursorWithHold = "CURSOR_HOLD";
    private static final String cachedStatements_column_32 = "BEGIN_STATS_TIME";
    private static final String cachedStatements_column_tableFirstReferencedQualifier = "TABLE_QUALIFIER";
    private static final String cachedStatements_column_tableFirstReferencedName = "TABLE_NAME";
    private static final String cachedStatements_column_35 = "ACCUM_CPU_TIME";
    private static final String cachedStatements_column_36 = "ACCUM_IO_WAIT";
    private static final String cachedStatements_column_37 = "ACCUM_LK_LTCH_WAIT";
    private static final String cachedStatements_column_38 = "ACCUM_SYNCEUS_WAIT";
    private static final String cachedStatements_column_39 = "ACCUM_GLBL_LK_WAIT";
    private static final String cachedStatements_column_40 = "ACCUM_SYNC_RD_WAIT";
    private static final String cachedStatements_column_41 = "ACCUM_SYNC_WR_WAIT";
    private static final String cachedStatements_column_42 = "PROGRAM_ID";
    private static final String cachedStatements_column_43 = "RID_INT_ERROR_CNT";
    private static final String cachedStatements_column_44 = "RID_OVERFLOW_CNT";
    private static final String cachedStatements_column_45 = "ISRT_DATE_TIMESTCK";
    private static final String cachedStatements_column_46 = "UPDT_DATE_TIMESTCK";
    private static final String cachedStatements_column_47 = "UPDATE_DATE_TIME";
    private static final String cachedStatements_column_prepareAttributes = "PREPARE_ATTRIBUTES";
    private static final String cachedStatements_column_sqlStatementText = "STATEMENT_TEXT";

    public DynamicStatementCache(ArtifactOptionsSet artifactOptionsSet, String string, PDQXmlSpecialRegValuesSet pDQXmlSpecialRegValuesSet) {
        super(artifactOptionsSet, string, pDQXmlSpecialRegValuesSet);
        this.cacheFilterString_ = artifactOptionsSet.isOptionOrArtifactSpecified(PossibleArgs.DSC_FILTER) ? artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.DSC_FILTER) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<PDQXmlStatementForGeneratePureQueryXml> parseFileAndReturnStatementList(Connection connection, BufferedReader bufferedReader) throws IOException {
        if (null != bufferedReader) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", bufferedReader), null, 11746);
        }
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            StaticProfileConstants.DBInfo dBInfo = new StaticProfileConstants.DBInfo(connection.getMetaData());
            if (StaticProfileConstants.DatabaseType.DB2forZOS != dBInfo.databaseType_) {
                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_DSC_DB_NOT_SUPPORTED", PossibleArgs.INPUT_SQL.externalOptionName(), PossibleArgs.PredefinedOptionValues.INPUT_SQL_DYNAMIC_STATEMENT_CACHE.getOptionValue(), "IBM DB2 for z/OS", PossibleArgs.URL.externalOptionName(), dBInfo.databaseTypeDisplayName_), null, 11747);
            }
            statement = connection.prepareCall("CALL IBMPDQ.QRYCACHE(?,?,?,?,?)");
            statement.setString(1, this.cacheFilterString_);
            statement.setString(2, "Y");
            statement.setString(3, "Y");
            statement.registerOutParameter(4, 4);
            statement.registerOutParameter(5, 12);
            statement.execute();
            int n2 = statement.getInt(4);
            if (n2 < 0) {
                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_DSC_ERR_FROM_SP", statement.getString(4), statement.getString(5)), null, 11748);
            }
            if (n2 > 0) {
                // empty if block
            }
            resultSet = statement.getResultSet();
            while (resultSet.next()) {
                PDQXmlStatementForGeneratePureQueryXml pDQXmlStatementForGeneratePureQueryXml = new PDQXmlStatementForGeneratePureQueryXml();
                this.statements_.add(pDQXmlStatementForGeneratePureQueryXml);
                PDQXmlStatementDescriptor pDQXmlStatementDescriptor = this.getStatementDescriptor(pDQXmlStatementForGeneratePureQueryXml);
                PDQXmlStatementAttributes pDQXmlStatementAttributes = this.getStatementAttributes(pDQXmlStatementForGeneratePureQueryXml);
                PDQXmlCaptureStatistics pDQXmlCaptureStatistics = DynamicStatementCache.getCaptureStatistics(pDQXmlStatementForGeneratePureQueryXml);
                pDQXmlStatementDescriptor.setSql(resultSet.getString(cachedStatements_column_sqlStatementText));
                String string = resultSet.getString(cachedStatements_column_prepareAttributes);
                pDQXmlStatementAttributes.setPrepareOptions(string);
                String string2 = resultSet.getString(cachedStatements_column_cursorWithHold);
                String string3 = resultSet.getString(cachedStatements_column_pkgThatDidPrepare);
                DynamicStatementCacheUtilities.setCursorAttributes(pDQXmlStatementAttributes, string2, string, string3);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("SCHEMA", resultSet.getString(cachedStatements_column_specialRegister_schema));
                hashMap.put("SQLID", resultSet.getString(cachedStatements_column_specialRegister_sqlid));
                hashMap.put("PRECISION", resultSet.getString(cachedStatements_column_specialRegister_precision));
                pDQXmlStatementDescriptor.addSpecialRegisterValuesSet(this.specialRegisterValuesSetsOriginElement_, hashMap);
                int n3 = resultSet.getInt(cachedStatements_column_executionStatistics_executionCount);
                if (!resultSet.wasNull()) {
                    pDQXmlCaptureStatistics.setExecutionCount(n3);
                }
                BigDecimal bigDecimal = resultSet.getBigDecimal(cachedStatements_column_executionStatistics_executionTime);
                if (resultSet.wasNull()) continue;
                long l2 = StaticProfileConstants.toLong(bigDecimal.movePointRight(6).toBigInteger());
                pDQXmlCaptureStatistics.setStmtMaxExecutionTimeInMicroseconds(l2);
            }
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException.getMessage());
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            System.out.println(exception.getStackTrace());
        }
        finally {
            try {
                if (null != resultSet) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (null != statement) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return this.statements_;
    }

    @Override
    public boolean statementAttributesVary() {
        return true;
    }
}

