/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.binder.classloaders;

import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.tools.internal.ToolsLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class ClassLoaderHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readClassBytesFromJar(String string, String string2) throws ClassNotFoundException {
        byte[] byArray;
        ZipFile zipFile = new ZipFile(string);
        ZipEntry zipEntry = zipFile.getEntry(string2);
        if (zipEntry == null) {
            throw new ClassNotFoundException(Messages.getText("MSG_NOT_FOUND2", string2, string));
        }
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        try {
            byte[] byArray2;
            byArray = byArray2 = ClassLoaderHelper.getBytesFromInputStream(inputStream);
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new ClassNotFoundException(iOException.getLocalizedMessage(), iOException);
            }
        }
        inputStream.close();
        return byArray;
    }

    public static InputStream getInputStreamForResourceInJar(String string, String string2) {
        try {
            ZipFile zipFile = new ZipFile(string);
            ZipEntry zipEntry = zipFile.getEntry(string2);
            if (zipEntry == null) {
                return null;
            }
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            ToolsLogger.getLogger().log(Level.FINER, "Reading resource " + string2 + " from jar: " + string);
            return inputStream;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static InputStream getInputStreamForResourceInJarInsideWar(String string, String string2, String string3) {
        try {
            ZipEntry zipEntry;
            ZipFile zipFile = new ZipFile(string);
            String string4 = string2;
            ZipEntry zipEntry2 = zipFile.getEntry(string4);
            if (zipEntry2 == null) {
                return null;
            }
            InputStream inputStream = zipFile.getInputStream(zipEntry2);
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!string3.equals(zipEntry.getName())) continue;
                ToolsLogger.getLogger().log(Level.FINER, "Reading resource " + string3 + " from jar " + string2 + " that is inside war file " + string);
                return zipInputStream;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return null;
    }

    public static InputStream getInputStreamForResourceInJarInsideWarInsideEar(String string, String string2, String string3, String string4) {
        try {
            ZipEntry zipEntry;
            ZipFile zipFile = new ZipFile(string);
            ZipEntry zipEntry2 = zipFile.getEntry(string2);
            if (zipEntry2 == null) {
                return null;
            }
            InputStream inputStream = zipFile.getInputStream(zipEntry2);
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                ZipEntry zipEntry3;
                if (!string3.equals(zipEntry.getName())) continue;
                ZipInputStream zipInputStream2 = new ZipInputStream(zipInputStream);
                while ((zipEntry3 = zipInputStream2.getNextEntry()) != null) {
                    if (!string4.equals(zipEntry3.getName())) continue;
                    ToolsLogger.getLogger().log(Level.FINER, "Reading resource " + string4 + " from jar " + string3 + " that is inside war file " + string2 + " that is inside ear file " + string);
                    return zipInputStream2;
                }
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromInputStream(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            int n2;
            while ((n2 = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n2);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readClassBytesFromJarInsideWar(String string, String string2, String string3) throws ClassNotFoundException {
        try {
            ZipFile zipFile = new ZipFile(string);
            String string4 = string2;
            ZipEntry zipEntry = zipFile.getEntry(string4);
            if (zipEntry == null) {
                throw new ClassNotFoundException(Messages.getText("MSG_NOT_FOUND2", string2, string));
            }
            try (InputStream inputStream = zipFile.getInputStream(zipEntry);
                 ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
                ZipEntry zipEntry2;
                while ((zipEntry2 = zipInputStream.getNextEntry()) != null) {
                    if (!string3.equals(zipEntry2.getName())) continue;
                    byte[] byArray = ClassLoaderHelper.getBytesFromInputStream(zipInputStream);
                    ToolsLogger.getLogger().log(Level.FINER, "Reading class " + string3 + " from jar " + string2 + " that is inside war file " + string);
                    byte[] byArray2 = byArray;
                    return byArray2;
                }
                throw new ClassNotFoundException(Messages.getText("MSG_NOT_FOUND3", string3, string2, string));
            }
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(iOException.getLocalizedMessage(), iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readClassBytesFromJarInsideWarInsideEar(String string, String string2, String string3, String string4) throws ClassNotFoundException {
        try {
            ZipFile zipFile = new ZipFile(string);
            ZipEntry zipEntry = zipFile.getEntry(string2);
            if (zipEntry == null) {
                throw new ClassNotFoundException(Messages.getText("MSG_NOT_FOUND2", string2, string));
            }
            try (InputStream inputStream = zipFile.getInputStream(zipEntry);
                 ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
                ZipEntry zipEntry2;
                while ((zipEntry2 = zipInputStream.getNextEntry()) != null) {
                    if (!string3.equals(zipEntry2.getName())) continue;
                    try (ZipInputStream zipInputStream2 = new ZipInputStream(zipInputStream);){
                        ZipEntry zipEntry3;
                        while ((zipEntry3 = zipInputStream2.getNextEntry()) != null) {
                            if (!string4.equals(zipEntry3.getName())) continue;
                            byte[] byArray = ClassLoaderHelper.getBytesFromInputStream(zipInputStream2);
                            ToolsLogger.getLogger().log(Level.FINER, "Reading class " + string4 + " from jar " + string3 + " that is inside war file " + string2 + " that is inside ear file " + string);
                            byte[] byArray2 = byArray;
                            return byArray2;
                        }
                    }
                }
                throw new ClassNotFoundException(Messages.getText("MSG_NOT_FOUND4", string4, string3, string2, string));
            }
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(iOException.getLocalizedMessage(), iOException);
        }
    }

    public static ArrayList<String> getZipEntryNames(String string) throws IOException {
        ZipFile zipFile = new ZipFile(string);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement().getName();
            if (string2.endsWith("/")) continue;
            arrayList.add(string2);
        }
        arrayList.trimToSize();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getWarEntryNamesBreadthFirst(String string) throws IOException {
        Object object;
        ZipFile zipFile = new ZipFile(string);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement().getName();
            if (((String)object).endsWith("/")) continue;
            arrayList.add((String)object);
        }
        object = new ArrayList(arrayList);
        Iterator iterator = ((ArrayList)object).iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.endsWith(".jar") && !string2.endsWith(".zip")) continue;
            ZipEntry zipEntry = zipFile.getEntry(string2);
            try (InputStream inputStream = zipFile.getInputStream(zipEntry);
                 ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
                ZipEntry zipEntry2;
                while ((zipEntry2 = zipInputStream.getNextEntry()) != null) {
                    String string3 = zipEntry2.getName();
                    arrayList.add(string2 + ":" + string3);
                }
            }
        }
        arrayList.trimToSize();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getEarEntryNamesBreadthFirst(String string) throws IOException {
        Object object;
        ZipFile zipFile = new ZipFile(string);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement().getName();
            if (((String)object).endsWith("/")) continue;
            arrayList.add((String)object);
        }
        object = new ArrayList(arrayList);
        Iterator iterator = ((ArrayList)object).iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.endsWith(".jar") && !string2.endsWith(".zip") && !string2.endsWith(".war")) continue;
            if (string.endsWith(".jar")) {
                ToolsLogger.getLogger().log(Level.INFO, "Ignoring nested archive " + string2 + " inside jar file " + string);
                continue;
            }
            if (string.endsWith(".war") && string2.endsWith(".war")) {
                ToolsLogger.getLogger().log(Level.INFO, "Ignoring nested archive " + string2 + " inside war file " + string);
                continue;
            }
            ZipEntry zipEntry = zipFile.getEntry(string2);
            try (InputStream inputStream = zipFile.getInputStream(zipEntry);
                 ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
                ZipEntry zipEntry2;
                while ((zipEntry2 = zipInputStream.getNextEntry()) != null) {
                    ZipEntry zipEntry3;
                    String string3 = zipEntry2.getName();
                    arrayList.add(string2 + ":" + string3);
                    if (!string2.endsWith(".war") && !string2.endsWith(".rar") || !string3.endsWith(".jar") && !string3.endsWith(".zip")) continue;
                    ZipInputStream zipInputStream2 = new ZipInputStream(zipInputStream);
                    while ((zipEntry3 = zipInputStream2.getNextEntry()) != null) {
                        String string4 = zipEntry3.getName();
                        arrayList.add(string2 + ":" + string3 + ":" + string4);
                    }
                }
            }
        }
        arrayList.trimToSize();
        return arrayList;
    }

    public static ArrayList<String> findBindPropsNamesInSet(ArrayList<String> arrayList) throws IOException {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string : arrayList) {
            if (!string.endsWith(".bindProps") && !string.endsWith(".bindprops")) continue;
            ToolsLogger.getLogger().log(Level.FINER, "Found bindProps file: " + string);
            arrayList2.add(string);
        }
        arrayList2.trimToSize();
        return arrayList2;
    }

    public static ArrayList<String> findPDQXmlNamesInSet(ArrayList<String> arrayList) throws IOException {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string : arrayList) {
            if (!string.endsWith(".pdqxml")) continue;
            ToolsLogger.getLogger().log(Level.FINER, "Found pdqxml file: " + string);
            arrayList2.add(string);
        }
        arrayList2.trimToSize();
        return arrayList2;
    }

    public static ArrayList<String> findImplClassNamesInSet(ArrayList<String> arrayList) throws IOException {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string : arrayList) {
            if (!string.endsWith("Impl.class")) continue;
            ToolsLogger.getLogger().log(Level.FINER, "Found implementation class file: " + string);
            arrayList2.add(string);
        }
        arrayList2.trimToSize();
        return arrayList2;
    }
}

