/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess;

import com.ibm.db2.cmx.runtime.internal.repository.MetadataException;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class CurrentSchemaWriter {
    public static void setCurrentSchema(Connection connection, String string) throws MetadataException {
        if (string != null && connection != null) {
            try {
                String string2 = connection.getMetaData().getDatabaseProductName().toUpperCase();
                if (string2.contains("DB2") || string2.equals("AS") || string2.contains("DERBY")) {
                    CurrentSchemaWriter.setSchema(connection, "set current schema " + string);
                } else if (string2.contains("ORACLE")) {
                    CurrentSchemaWriter.setSchema(connection, "alter session set current_schema=" + string);
                } else if (!string2.startsWith("INFORMIX") && !string2.startsWith("IDS")) {
                    String string3 = Messages.getText("ERR_CANNOT_SET_DEFAULT_SCHEMA_ON_PLATFORM", string2);
                    throw new MetadataException(string3, null);
                }
            }
            catch (SQLException sQLException) {
                String string4 = Messages.getText("ERR_CANNOT_SET_DEFAULT_SCHEMA", string);
                throw new MetadataException(string4, sQLException);
            }
        }
    }

    private static void setSchema(Connection connection, String string) throws SQLException {
        try (Statement statement = null;){
            statement = connection.createStatement();
            statement.execute(string);
        }
    }
}

