/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.factory.DataFactory;
import com.ibm.db2.cmx.runtime.internal.CentralStore;
import com.ibm.db2.cmx.runtime.internal.CentralStoreKey;
import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.ServiceThreadFactory;
import com.ibm.db2.cmx.runtime.internal.db.StaticProfileCaptureHelper;
import com.ibm.db2.cmx.runtime.internal.db.XmlFileHelper;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import com.ibm.db2.cmx.runtime.internal.wrappers.ConnectionExecutionHandler;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class PdqServiceThreadProvider
implements Runnable {
    private static int nextThreadNumber_ = 0;
    private static boolean threadsEnabled_;
    private static ServiceThreadFactory serviceThreadFactory_;
    static ThreadGroup loadOfNewPropertiesAndXmlThreadPoolThreadGroup;
    private static Logger logger__;
    private long serviceThreadStartTime_ = System.currentTimeMillis();
    private Thread serviceThread_;
    private ServiceThreadRequest stRequest_;
    private ConnectionExecutionHandler connHandler_;
    private Object[] returnObjects_;
    private boolean saveServiceThread_;
    private Object[] parms_;

    public PdqServiceThreadProvider(ServiceThreadRequest serviceThreadRequest, ConnectionExecutionHandler connectionExecutionHandler, Object[] objectArray, boolean bl2, Object ... objectArray2) {
        this.connHandler_ = connectionExecutionHandler;
        this.returnObjects_ = objectArray;
        this.saveServiceThread_ = bl2;
        this.parms_ = objectArray2;
        this.stRequest_ = serviceThreadRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(ServiceThreadRequest serviceThreadRequest, Object[] objectArray, boolean bl2, Object ... objectArray2) {
        this.returnObjects_ = objectArray;
        this.saveServiceThread_ = bl2;
        this.parms_ = objectArray2;
        this.stRequest_ = serviceThreadRequest;
        Thread thread = this.serviceThread_;
        synchronized (thread) {
            this.serviceThread_.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.serviceThread_ = Thread.currentThread();
        if (this.returnObjects_ != null) {
            this.returnObjects_[1] = null;
            this.returnObjects_[0] = null;
        }
        do {
            try {
                if (this.stRequest_ == ServiceThreadRequest.CLOSE_SERVICE_THREAD) {
                    this.saveServiceThread_ = false;
                    continue;
                }
                if (this.connHandler_ != null && this.connHandler_.driverTraceOn_) {
                    this.connHandler_.driverLogWriter_.println(this.connHandler_.buildDriverTraceHeader(this.connHandler_, "Repository: run") + " [Thread:" + Thread.currentThread().getName() + "] execute of " + this.stRequest_.toString());
                }
                this.returnObjects_[0] = PdqServiceThreadProvider.executeServiceRequest(this.stRequest_, this.connHandler_, this.parms_);
            }
            catch (Throwable throwable) {
                if (this.connHandler_ != null && this.connHandler_.driverTraceOn_) {
                    this.connHandler_.driverLogWriter_.println(this.connHandler_.buildDriverTraceHeader(this.connHandler_, "Repository: run") + " [Thread:" + Thread.currentThread().getName() + "] Throwable during execute of " + this.stRequest_.toString() + "\n" + throwable.toString());
                }
                if (this.returnObjects_ == null) continue;
                this.returnObjects_[1] = throwable;
            }
            finally {
                Thread thread = this.serviceThread_;
                synchronized (thread) {
                    if (this.connHandler_ != null && this.connHandler_.driverTraceOn_) {
                        this.connHandler_.driverLogWriter_.println(this.connHandler_.buildDriverTraceHeader(this.connHandler_, "Repository: run") + " [Thread:" + Thread.currentThread().getName() + "] Finished execute of request, now setting to NO_REQUEST");
                    }
                    this.stRequest_ = ServiceThreadRequest.NO_REQUEST;
                    this.serviceThread_.notifyAll();
                    this.parms_ = null;
                }
                if (this.saveServiceThread_) {
                    thread = this.serviceThread_;
                    synchronized (thread) {
                        int n2 = 0;
                        int n3 = 0;
                        while (this.stRequest_ == ServiceThreadRequest.NO_REQUEST) {
                            try {
                                if (this.connHandler_ != null && this.connHandler_.driverTraceOn_ && n2 == 0) {
                                    this.connHandler_.driverLogWriter_.println(this.connHandler_.buildDriverTraceHeader(this.connHandler_, "Repository: run") + " [Thread:" + Thread.currentThread().getName() + "] Waiting for new Request");
                                }
                                ++n2;
                                this.serviceThread_.wait(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                ++n3;
                            }
                        }
                        if (this.connHandler_ != null && this.connHandler_.driverTraceOn_) {
                            this.connHandler_.driverLogWriter_.println(this.connHandler_.buildDriverTraceHeader(this.connHandler_, "Repository: run") + " [Thread:" + Thread.currentThread().getName() + "], waited " + n2 + " times, with " + n3 + " InterruptedExceptions, for new Request");
                        }
                    }
                }
            }
        } while (this.saveServiceThread_ || this.stRequest_ != ServiceThreadRequest.NO_REQUEST);
        if (this.connHandler_ != null && this.connHandler_.driverTraceOn_) {
            this.connHandler_.driverLogWriter_.println(this.connHandler_.buildDriverTraceHeader(this.connHandler_, "Repository: run") + " [Thread:" + Thread.currentThread().getName() + "] Closing this service thread, active for " + (System.currentTimeMillis() - this.serviceThreadStartTime_) + " milliseconds");
        }
        if (logger__.isLoggable(Level.CONFIG)) {
            DataLogger.logConfigHighVis(logger__, null, "", "[Thread:" + Thread.currentThread().getName() + "][PdqServiceThreadProvider.run] Repository: Closing this service thread, active for " + (System.currentTimeMillis() - this.serviceThreadStartTime_) + " milliseconds", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] executeOnServiceThreadIfNeeded(ServiceThreadRequest serviceThreadRequest, ConnectionExecutionHandler connectionExecutionHandler, boolean bl2, Object ... objectArray) {
        Object[] objectArray2 = null;
        PdqServiceThreadProvider pdqServiceThreadProvider = null;
        Object[] objectArray3 = new Object[2];
        objectArray3[1] = null;
        if (!PdqServiceThreadProvider.isThreadingEnabled() || Thread.currentThread().getName().startsWith("pdqServiceThread")) {
            try {
                if (logger__.isLoggable(Level.CONFIG)) {
                    DataLogger.logConfigHighVis(logger__, null, "", DataLogger.getShortName(connectionExecutionHandler) + " [Thread:" + Thread.currentThread().getName() + "][executeOnServiceThreadIfNeeded] Direct execute of " + serviceThreadRequest.toString(), false);
                }
                objectArray3[0] = PdqServiceThreadProvider.executeServiceRequest(serviceThreadRequest, connectionExecutionHandler, objectArray);
            }
            catch (Throwable throwable) {
                objectArray3[1] = throwable;
            }
            return objectArray3;
        }
        boolean bl3 = false;
        Connection connection = null;
        if (connectionExecutionHandler != null) {
            try {
                connectionExecutionHandler.createConnInfo();
            }
            catch (SQLException sQLException) {
                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, sQLException.getLocalizedMessage(), sQLException, 11071);
            }
            bl3 = connectionExecutionHandler.isHasPhysicalConnection();
            connection = connectionExecutionHandler.getPhysicalConnection();
            connectionExecutionHandler.setHasPhysicalConnection(false);
            connectionExecutionHandler.setPhysicalConnection(null);
        }
        try {
            if (serviceThreadFactory_ == null) {
                serviceThreadFactory_ = new ServiceThreadFactory();
            }
            if (connectionExecutionHandler != null) {
                pdqServiceThreadProvider = connectionExecutionHandler.getServiceThreadProvider();
            }
            if (pdqServiceThreadProvider == null) {
                pdqServiceThreadProvider = new PdqServiceThreadProvider(serviceThreadRequest, connectionExecutionHandler, objectArray3, bl2, objectArray);
                objectArray2 = serviceThreadFactory_.newThread(pdqServiceThreadProvider);
                if (logger__.isLoggable(Level.CONFIG)) {
                    DataLogger.logConfigHighVis(logger__, null, "", DataLogger.getShortName(connectionExecutionHandler) + " [Thread:" + Thread.currentThread().getName() + "][executeOnServiceThreadIfNeeded] Created new service thread - " + objectArray2.getName() + ", execute of " + serviceThreadRequest.toString(), false);
                }
                if (connectionExecutionHandler != null && connectionExecutionHandler.driverTraceOn_) {
                    connectionExecutionHandler.driverLogWriter_.println(connectionExecutionHandler.buildDriverTraceHeader(connectionExecutionHandler, "Repository: executeOnServiceThreadIfNeeded") + " [Thread:" + Thread.currentThread().getName() + "] Created new service thread - " + objectArray2.getName() + ", execute of " + serviceThreadRequest.toString());
                }
                objectArray2.start();
            } else {
                objectArray2 = pdqServiceThreadProvider.serviceThread_;
                if (logger__.isLoggable(Level.CONFIG)) {
                    DataLogger.logConfigHighVis(logger__, null, "", DataLogger.getShortName(connectionExecutionHandler) + " [Thread:" + Thread.currentThread().getName() + "][executeOnServiceThreadIfNeeded] Use existing service thread - " + objectArray2.getName() + ", execute of " + serviceThreadRequest.toString(), false);
                }
                if (connectionExecutionHandler != null && connectionExecutionHandler.driverTraceOn_) {
                    connectionExecutionHandler.driverLogWriter_.println(connectionExecutionHandler.buildDriverTraceHeader(connectionExecutionHandler, "Repository: executeOnServiceThreadIfNeeded") + " [Thread:" + Thread.currentThread().getName() + "] Use existing service thread - " + objectArray2.getName() + ", execute of " + serviceThreadRequest.toString());
                }
                pdqServiceThreadProvider.request(serviceThreadRequest, objectArray3, bl2, objectArray);
            }
            Object[] objectArray4 = objectArray2;
            synchronized (objectArray2) {
                int n2 = 0;
                int n3 = 0;
                while (pdqServiceThreadProvider.getStRequest_() != ServiceThreadRequest.NO_REQUEST) {
                    try {
                        ++n2;
                        objectArray2.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        ++n3;
                    }
                }
                if (connectionExecutionHandler != null && connectionExecutionHandler.driverTraceOn_) {
                    connectionExecutionHandler.driverLogWriter_.println(connectionExecutionHandler.buildDriverTraceHeader(connectionExecutionHandler, "Repository: executeOnServiceThreadIfNeeded") + " [Thread:" + Thread.currentThread().getName() + "] Returned from Service Thread - " + objectArray2.getName() + ", waited " + n2 + " times, with " + n3 + " InterruptedExceptions, for execute of " + serviceThreadRequest.toString());
                }
                // ** MonitorExit[var9_11] (shouldn't be in output)
                if (connectionExecutionHandler != null) {
                    if (serviceThreadRequest == ServiceThreadRequest.CLOSE_SERVICE_THREAD || !bl2) {
                        connectionExecutionHandler.setServiceThreadProvider(null);
                    } else {
                        if (logger__.isLoggable(Level.CONFIG)) {
                            DataLogger.logConfigHighVis(logger__, null, "", DataLogger.getShortName(connectionExecutionHandler) + " [Thread:" + Thread.currentThread().getName() + "][executeOnServiceThreadIfNeeded] Save service thread - " + objectArray2.getName(), false);
                        }
                        connectionExecutionHandler.setServiceThreadProvider(pdqServiceThreadProvider);
                    }
                }
                if (objectArray3[1] != null) {
                    objectArray4 = ((Throwable)objectArray3[1]).getStackTrace();
                    StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                    StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[objectArray4.length + stackTraceElementArray.length];
                    System.arraycopy(objectArray4, 0, stackTraceElementArray2, 0, objectArray4.length);
                    System.arraycopy(stackTraceElementArray, 0, stackTraceElementArray2, objectArray4.length, stackTraceElementArray.length);
                    ((Throwable)objectArray3[1]).setStackTrace(stackTraceElementArray2);
                    if (logger__.isLoggable(Level.CONFIG)) {
                        DataLogger.logConfigHighVis(logger__, null, "", DataLogger.getShortName(connectionExecutionHandler) + " [Thread:" + Thread.currentThread().getName() + "][executeOnServiceThreadIfNeeded] Exception on service thread - " + (Throwable)objectArray3[1], false);
                    }
                }
                objectArray4 = objectArray3;
                return objectArray4;
            }
        }
        finally {
            if (connectionExecutionHandler != null) {
                connectionExecutionHandler.setHasPhysicalConnection(bl3);
                connectionExecutionHandler.setPhysicalConnection(connection);
            }
        }
    }

    protected static Object executeServiceRequest(ServiceThreadRequest serviceThreadRequest, ConnectionExecutionHandler connectionExecutionHandler, Object ... objectArray) throws Throwable {
        Object object = null;
        switch (serviceThreadRequest) {
            case CLOSE_SERVICE_THREAD: {
                break;
            }
            case LOG_TO_REPOSITORY: {
                ArrayList<LogRecord> arrayList = new ArrayList<LogRecord>();
                CentralStore.logToRepository((CentralStoreKey)objectArray[0], arrayList);
                break;
            }
            case DATA_FACTORY_INIT: {
                DataFactory.processRepositoryDataFactoryX((CentralStoreKey)objectArray[0]);
                break;
            }
            case GET_DOCUMENT_PARSER_WITH_KEY: {
                object = ((XmlFileHelper)objectArray[0]).getDocumentParserX((CentralStoreKey)objectArray[1]);
                break;
            }
            case PROCESS_REDIRECTED_PROPERTIES: {
                object = connectionExecutionHandler.processRedirectedPropertiesX((ClassLoader)objectArray[0], (Properties)objectArray[1], (String)objectArray[2], (CentralStoreKey)objectArray[3]);
                break;
            }
            case RESET_CAPTURE_HELPER_STATUS: {
                ((StaticProfileCaptureHelper)objectArray[0]).resetCaptureHelperStatesX(connectionExecutionHandler);
                break;
            }
            case SERIALIZE_DOM_IF_ANY: {
                ((StaticProfileCaptureHelper)objectArray[0]).serializeDOMIfAnyX();
                break;
            }
            case NO_REQUEST: {
                if (connectionExecutionHandler == null || !connectionExecutionHandler.driverTraceOn_) break;
                connectionExecutionHandler.driverLogWriter_.println(connectionExecutionHandler.buildDriverTraceHeader(connectionExecutionHandler, "Repository: executeServiceRequest") + " [Thread:" + Thread.currentThread().getName() + "] execute of " + serviceThreadRequest.toString());
            }
        }
        return object;
    }

    public static synchronized String getNextThreadName(String string) {
        return "pdqServiceThread" + string + ++nextThreadNumber_;
    }

    public static boolean isThreadingEnabled() {
        return threadsEnabled_;
    }

    public ServiceThreadRequest getStRequest_() {
        return this.stRequest_;
    }

    static {
        serviceThreadFactory_ = null;
        loadOfNewPropertiesAndXmlThreadPoolThreadGroup = null;
        logger__ = Log.getClientOptimizerLogger();
        int n2 = Integer.parseInt("-2");
        String string = DataProperties.getProperty("pdq.cmx.controllerDiscoveryInterval");
        int n3 = string != null ? Integer.parseInt(string) : n2;
        threadsEnabled_ = n3 != n2;
    }

    public static enum ServiceThreadRequest {
        LOG_TO_REPOSITORY,
        DATA_FACTORY_INIT,
        RESET_CAPTURE_HELPER_STATUS,
        PROCESS_REDIRECTED_PROPERTIES,
        GET_DOCUMENT_PARSER_WITH_KEY,
        SERIALIZE_DOM_IF_ANY,
        CLOSE_SERVICE_THREAD,
        NO_REQUEST;

    }
}

