/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app;

import COM.ibm.db2.app.ClobWithIO;
import java.io.IOException;
import java.io.Writer;

class ClobWriter
extends Writer {
    private ClobWithIO clob;

    ClobWriter(ClobWithIO clobWithIO) {
        this.clob = clobWithIO;
    }

    @Override
    public void write(int n2) throws IOException {
        if (n2 < 0 || n2 > 255) {
            throw new IOException("not a char");
        }
        char[] cArray = new char[]{(char)(n2 & 0xFF)};
        this.write(cArray);
    }

    @Override
    public void write(char[] cArray) throws IOException {
        this.write(cArray, 0, cArray.length);
    }

    @Override
    public void write(char[] cArray, int n2, int n3) throws IOException {
        if (this.clob == null) {
            throw new IOException("Writer is closed");
        }
        if (n2 < 0 || n2 >= cArray.length || n3 <= 0 || n2 + n3 > cArray.length) {
            throw new IOException("invalid offset/length");
        }
        try {
            this.clob.append(cArray, n2, n3);
        }
        catch (Exception exception) {
            throw new IOException("I/O error on Clob write(): " + exception);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.clob == null) {
            throw new IOException("Writer is closed");
        }
    }

    @Override
    public void close() throws IOException {
        this.clob = null;
    }
}

