/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.linter;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.schemacrawler.IdentifiersBuilder;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.QueryUtility;
import schemacrawler.tools.lint.BaseLinter;
import schemacrawler.tools.lint.LintCollector;
import schemacrawler.tools.options.Config;
import us.fatehi.utility.Utility;
import us.fatehi.utility.property.PropertyName;
import us.fatehi.utility.string.StringFormat;

class LinterTableSql
extends BaseLinter {
    private static final Logger LOGGER = Logger.getLogger(LinterTableSql.class.getName());
    private String message;
    private String sql;

    LinterTableSql(PropertyName propertyName, LintCollector lintCollector) {
        super(propertyName, lintCollector);
    }

    @Override
    public String getSummary() {
        if (Utility.isBlank((CharSequence)this.message)) {
            return "SQL statement based table linter";
        }
        return this.message;
    }

    @Override
    protected void configure(Config config) {
        Objects.requireNonNull(config, "No configuration provided");
        this.message = config.getStringValue("message", "");
        Utility.requireNotBlank((String)this.message, (String)"No message provided");
        this.sql = config.getStringValue("sql", "");
        Utility.requireNotBlank((String)this.sql, (String)"No SQL provided");
    }

    public boolean usesConnection() {
        return true;
    }

    @Override
    protected void lint(Table table, Connection connection) {
        if (Utility.isBlank((CharSequence)this.sql)) {
            return;
        }
        Objects.requireNonNull(table, "No table provided");
        Objects.requireNonNull(connection, "No connection provided");
        Query query = new Query(this.message, this.sql);
        try {
            Identifiers identifiers = IdentifiersBuilder.builder().fromConnection(connection).toOptions();
            Object queryResult = QueryUtility.executeForScalar((Query)query, (Connection)connection, (Table)table, (Identifiers)identifiers);
            if (queryResult != null) {
                this.addTableLint(table, this.getSummary() + " " + String.valueOf(queryResult));
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, e, (Supplier<String>)new StringFormat("Could not execute SQL for table lints, for table", new Object[]{table}));
        }
    }
}

