/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.lint;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArraySet;
import schemacrawler.schema.NamedObject;
import schemacrawler.tools.lint.Lint;

public final class LintCollector {
    private final Collection<Lint<? extends Serializable>> allLints = new CopyOnWriteArraySet<Lint<? extends Serializable>>();

    LintCollector() {
    }

    <N extends NamedObject> void addLint(N namedObject, Lint<?> lint) {
        Objects.requireNonNull(namedObject, "No named object provided");
        Objects.requireNonNull(lint, "No lint provided");
        if (namedObject.key().equals((Object)lint.getObjectKey())) {
            this.allLints.add(lint);
        }
    }

    Collection<Lint<? extends Serializable>> getLints() {
        return new HashSet<Lint<? extends Serializable>>(this.allLints);
    }
}

