/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.xml;

import com.ibm.db2.cmx.runtime.internal.db.StaticProfileCaptureHelper;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXml;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlDataTypeInfo;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlMetaDataBase;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlParameter;
import com.ibm.db2.cmx.runtime.internal.xml.XmlBuf;
import com.ibm.db2.cmx.runtime.internal.xml.XmlExporter;
import com.ibm.db2.cmx.runtime.internal.xml.XmlTags;
import com.ibm.db2.cmx.tools.internal.PDQDB2Types;
import com.ibm.db2.jcc.DB2PreparedStatement;
import com.ibm.db2.jcc.DBMetaData;
import com.ibm.db2.jcc.DBPreparedStatementInfoInterface;
import com.ibm.db2.jcc.SQLJColumnMetaData;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PDQXmlParameterMetaData
extends PDQXmlMetaDataBase
implements XmlExporter {
    private ArrayList<PDQXmlParameter> parameters_ = new ArrayList();

    public ArrayList<PDQXmlParameter> getParameters() {
        return this.parameters_;
    }

    public void setParameters(ArrayList<PDQXmlParameter> arrayList) {
        this.parameters_ = arrayList;
    }

    public PDQXmlParameter getLast() {
        return this.parameters_.get(this.parameters_.size() - 1);
    }

    public void add(PDQXmlParameter pDQXmlParameter) {
        this.parameters_.add(pDQXmlParameter);
    }

    public int[][] toIntArray() {
        int n2;
        int n3 = this.parameters_.size();
        if (n3 == 0) {
            return null;
        }
        int[][] nArrayArray = new int[4][];
        for (n2 = 0; n2 < 4; ++n2) {
            nArrayArray[n2] = new int[n3];
        }
        for (n2 = 0; n2 < n3; ++n2) {
            nArrayArray[0][n2] = this.parameters_.get(n2).getJdbcType();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            nArrayArray[1][n2] = this.parameters_.get(n2).getPrecision();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            nArrayArray[2][n2] = this.parameters_.get(n2).getScale();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            nArrayArray[3][n2] = this.parameters_.get(n2).getParameterMode();
        }
        return nArrayArray;
    }

    public void init(PreparedStatement preparedStatement) throws SQLException {
        block5: {
            if (preparedStatement == null) {
                return;
            }
            ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
            if (parameterMetaData != null && parameterMetaData.getParameterCount() > 0) {
                Object object;
                int n2 = parameterMetaData.getParameterCount();
                for (int i10 = 1; i10 <= n2; ++i10) {
                    object = new PDQXmlParameter();
                    ((PDQXmlDataTypeInfo)object).setColumnName("p" + i10);
                    ((PDQXmlDataTypeInfo)object).setJdbcType(XmlTags.getDB2TypeNumberFromJdbcType(parameterMetaData.getParameterType(i10), parameterMetaData.getParameterTypeName(i10)));
                    ((PDQXmlDataTypeInfo)object).setPrecision(parameterMetaData.getPrecision(i10));
                    ((PDQXmlDataTypeInfo)object).setScale(parameterMetaData.getScale(i10));
                    ((PDQXmlParameter)object).setParameterMode(parameterMetaData.getParameterMode(i10));
                    this.parameters_.add((PDQXmlParameter)object);
                }
                try {
                    this.initColumnsFromDB2ParameterMetaData(preparedStatement);
                }
                catch (Throwable throwable) {
                    object = Log.getLogger();
                    if (null == object) break block5;
                    ((Logger)object).log(Level.WARNING, "Error while retrieving statement parameter metadata.", throwable);
                }
            }
        }
        PDQXml.currentConnection__ = preparedStatement.getConnection();
    }

    public void init(ParameterMetaData parameterMetaData) throws SQLException {
        block5: {
            if (parameterMetaData != null && parameterMetaData.getParameterCount() > 0) {
                int n2 = parameterMetaData.getParameterCount();
                for (int i10 = 1; i10 <= n2; ++i10) {
                    PDQXmlParameter pDQXmlParameter = new PDQXmlParameter();
                    pDQXmlParameter.setColumnName("p" + i10);
                    pDQXmlParameter.setJdbcType(XmlTags.getDB2TypeNumberFromJdbcType(parameterMetaData.getParameterType(i10), parameterMetaData.getParameterTypeName(i10)));
                    pDQXmlParameter.setPrecision(parameterMetaData.getPrecision(i10));
                    pDQXmlParameter.setScale(parameterMetaData.getScale(i10));
                    pDQXmlParameter.setParameterMode(parameterMetaData.getParameterMode(i10));
                    this.parameters_.add(pDQXmlParameter);
                }
            }
            try {
                if (this.parameters_.size() > 0) {
                    this.initDB2MetaDataFromJdbcMetaData();
                }
            }
            catch (Throwable throwable) {
                Logger logger = Log.getLogger();
                if (null == logger) break block5;
                logger.log(Level.WARNING, "Error while computing statement parameter metadata.", throwable);
            }
        }
    }

    private void initDB2MetaDataFromJdbcMetaData() {
        SQLJColumnMetaData sQLJColumnMetaData = new SQLJColumnMetaData(this.parameters_.size());
        for (int i10 = 0; i10 < this.parameters_.size(); ++i10) {
            PDQXmlParameter pDQXmlParameter = this.parameters_.get(i10);
            PDQDB2Types.mapDriverTypeToDB2TypeInfo(sQLJColumnMetaData, pDQXmlParameter.getJdbcType(), i10, false, pDQXmlParameter.getScale(), pDQXmlParameter.getPrecision());
        }
        this.initFromSqljColumnMetaData(this.parameters_, sQLJColumnMetaData);
    }

    private void initColumnsFromDB2ParameterMetaData(PreparedStatement preparedStatement) throws SQLException {
        HashMap hashMap;
        DB2PreparedStatement dB2PreparedStatement = (DB2PreparedStatement)preparedStatement;
        DBMetaData dBMetaData = dB2PreparedStatement.getDBPreparedStatementInfo().getDBParameterMetaData();
        this.initFromSqljColumnMetaData(this.parameters_, dBMetaData);
        DBPreparedStatementInfoInterface dBPreparedStatementInfoInterface = dB2PreparedStatement.getDBPreparedStatementInfo();
        if (dBPreparedStatementInfoInterface != null) {
            this.prepareOptions_ = dBPreparedStatementInfoInterface.getPrepareAttributes();
        }
        if ((hashMap = dBPreparedStatementInfoInterface.getNamedParameterMarkerMap()) != null) {
            int n2 = this.parameters_.size();
            for (int i10 = 0; i10 < n2; ++i10) {
                String string = StaticProfileCaptureHelper.getParameterMarkerName(hashMap, i10);
                this.parameters_.get(i10).setColumnName(string);
            }
        }
    }

    @Override
    public String getXml(int n2) {
        XmlBuf xmlBuf = new XmlBuf(n2);
        xmlBuf.startElement("parameterMetadata");
        for (int i10 = 0; i10 < this.parameters_.size(); ++i10) {
            xmlBuf.addBranch(this.parameters_.get(i10));
        }
        xmlBuf.endElement();
        return xmlBuf.toString();
    }
}

