/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app;

import COM.ibm.db2.app.ClobReader;
import COM.ibm.db2.app.ClobWithIO;
import COM.ibm.db2.app.ClobWriter;
import COM.ibm.db2.app.Lob;
import java.io.Reader;
import java.io.Writer;

class ClobWithCharBuffer
extends Lob
implements ClobWithIO {
    char[] buffer;
    int capacity;
    int count;

    ClobWithCharBuffer(char[] cArray) throws Exception {
        this.buffer = cArray;
        this.capacity = cArray.length;
        this.count = cArray.length;
    }

    ClobWithCharBuffer() throws Exception {
        this.capacity = 32;
        this.count = 0;
        this.buffer = new char[this.capacity];
    }

    @Override
    public void close() {
        this.buffer = null;
        this.count = 0;
        this.capacity = 0;
    }

    @Override
    void assertOpen() throws Exception {
        if (this.buffer == null) {
            throw new Exception("Clob is closed.");
        }
    }

    @Override
    public long size() throws Exception {
        this.assertOpen();
        return this.count;
    }

    @Override
    public Reader getReader() throws Exception {
        return new ClobReader(this);
    }

    @Override
    public Writer getWriter() throws Exception {
        return new ClobWriter(this);
    }

    @Override
    public synchronized void append(char[] cArray, int n2, int n3) throws Exception {
        this.assertOpen();
        if (this.count + n3 <= this.capacity) {
            System.arraycopy(cArray, n2, this.buffer, this.count, n3);
            this.count += n3;
        } else {
            int n4 = this.capacity + (int)((double)n3 * 1.2);
            char[] cArray2 = new char[n4];
            int n5 = this.count + n3;
            System.arraycopy(this.buffer, 0, cArray2, 0, this.count);
            System.arraycopy(cArray, n2, cArray2, this.count, n3);
            this.capacity = n4;
            this.buffer = cArray2;
            this.count = n5;
        }
    }

    @Override
    public synchronized int substr(int n2, char[] cArray, int n3, int n4) throws Exception {
        this.assertOpen();
        int n5 = n4;
        if (n2 >= this.count) {
            n5 = 0;
        } else if (n2 + n4 > this.count) {
            n5 = this.count - (n2 + n4);
        }
        System.arraycopy(this.buffer, n2, cArray, n3, n5);
        return n5;
    }
}

