/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schema;

import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.fatehi.utility.string.StringFormat;

public enum TableConstraintType {
    unknown("unknown"),
    primary_key("PRIMARY KEY"),
    foreign_key("FOREIGN KEY"),
    unique("UNIQUE"),
    check("CHECK"),
    alternate_key("ALTERNATE KEY"),
    weak_association("WEAK ASSOCIATION");

    private static final Logger LOGGER;
    private final String value;

    public static TableConstraintType valueOfFromValue(String value) {
        for (TableConstraintType type : TableConstraintType.values()) {
            if (!type.getValue().equalsIgnoreCase(value)) continue;
            return type;
        }
        LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Unknown value <%s>", new Object[]{value}));
        return unknown;
    }

    private TableConstraintType(String value) {
        this.value = value;
    }

    public final String getValue() {
        return this.value;
    }

    static {
        LOGGER = Logger.getLogger(TableConstraintType.class.getName());
    }
}

