/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.SharedArrayBufferPrototypeBuiltins;
import com.oracle.truffle.js.runtime.JSAgentWaiterList;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSAbstractBuffer;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.util.DirectByteBufferHelper;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;

public final class JSSharedArrayBuffer
extends JSAbstractBuffer
implements JSConstructorFactory.Default.WithSpecies,
PrototypeSupplier {
    public static final TruffleString CLASS_NAME = Strings.constant("SharedArrayBuffer");
    public static final TruffleString PROTOTYPE_NAME = Strings.concat(CLASS_NAME, Strings.DOT_PROTOTYPE);
    public static final JSSharedArrayBuffer INSTANCE = new JSSharedArrayBuffer();

    private JSSharedArrayBuffer() {
    }

    public static JSArrayBufferObject createSharedArrayBuffer(JSContext context, JSRealm realm, JSDynamicObject proto, int byteLength, int maxByteLength) {
        JSObjectFactory factory = context.getSharedArrayBufferFactory();
        return JSSharedArrayBuffer.createSharedArrayBuffer(realm, proto, DirectByteBufferHelper.allocateDirect(Math.max(byteLength, maxByteLength)), factory, new AtomicInteger(byteLength), maxByteLength);
    }

    public static JSArrayBufferObject createSharedArrayBuffer(JSContext context, JSRealm realm, ByteBuffer buffer) {
        JSObjectFactory factory = context.getSharedArrayBufferFactory();
        return JSSharedArrayBuffer.createSharedArrayBuffer(realm, factory.getPrototype(realm), buffer, factory, new AtomicInteger(buffer.capacity()), -1);
    }

    public static JSArrayBufferObject createSharedArrayBuffer(JSContext context, JSRealm realm, ByteBuffer buffer, AtomicInteger byteLength, int maxByteLength) {
        JSObjectFactory factory = context.getSharedArrayBufferFactory();
        return JSSharedArrayBuffer.createSharedArrayBuffer(realm, factory.getPrototype(realm), buffer, factory, byteLength, maxByteLength);
    }

    private static JSArrayBufferObject createSharedArrayBuffer(JSRealm realm, JSDynamicObject proto, ByteBuffer buffer, JSObjectFactory factory, AtomicInteger byteLength, int maxByteLength) {
        assert (buffer != null);
        Shape shape = factory.getShape(realm, proto);
        JSArrayBufferObject.Shared newObj = factory.initProto(new JSArrayBufferObject.Shared(shape, proto, buffer, new JSAgentWaiterList(), byteLength, maxByteLength), realm, proto);
        return factory.trackAllocation(newObj);
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject ctor) {
        JSObject arrayBufferPrototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(arrayBufferPrototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, arrayBufferPrototype, SharedArrayBufferPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putAccessorsFromContainer(realm, arrayBufferPrototype, SharedArrayBufferPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(arrayBufferPrototype, CLASS_NAME);
        return arrayBufferPrototype;
    }

    @Override
    public Shape makeInitialShape(JSContext context, JSDynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    public static boolean isJSSharedArrayBuffer(Object obj) {
        return obj instanceof JSArrayBufferObject.Shared;
    }

    public static ByteBuffer getDirectByteBuffer(JSDynamicObject thisObj) {
        assert (JSSharedArrayBuffer.isJSSharedArrayBuffer((Object)thisObj));
        return JSArrayBufferObject.getDirectByteBuffer((Object)thisObj);
    }

    public static JSAgentWaiterList getWaiterList(JSDynamicObject thisObj) {
        return JSArrayBufferObject.getWaiterList(thisObj);
    }

    public static void setWaiterList(JSDynamicObject thisObj, JSAgentWaiterList wl) {
        JSArrayBufferObject.setWaiterList(thisObj, wl);
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getSharedArrayBufferPrototype();
    }
}

