/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.AbstractModuleSourcePrototype;
import com.oracle.truffle.js.builtins.AsyncIteratorHelperPrototypeBuiltins;
import com.oracle.truffle.js.builtins.AtomicsBuiltins;
import com.oracle.truffle.js.builtins.ConsoleBuiltins;
import com.oracle.truffle.js.builtins.ConstructorBuiltins;
import com.oracle.truffle.js.builtins.DatePrototypeBuiltins;
import com.oracle.truffle.js.builtins.DebugBuiltins;
import com.oracle.truffle.js.builtins.GlobalBuiltins;
import com.oracle.truffle.js.builtins.IteratorHelperPrototypeBuiltins;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.JavaBuiltins;
import com.oracle.truffle.js.builtins.MLEBuiltins;
import com.oracle.truffle.js.builtins.ObjectFunctionBuiltins;
import com.oracle.truffle.js.builtins.OperatorsBuiltins;
import com.oracle.truffle.js.builtins.PerformanceBuiltins;
import com.oracle.truffle.js.builtins.PolyglotBuiltins;
import com.oracle.truffle.js.builtins.ReflectBuiltins;
import com.oracle.truffle.js.builtins.RegExpBuiltins;
import com.oracle.truffle.js.builtins.RegExpStringIteratorPrototypeBuiltins;
import com.oracle.truffle.js.builtins.commonjs.GlobalCommonJSRequireBuiltins;
import com.oracle.truffle.js.builtins.commonjs.NpmCompatibleESModuleLoader;
import com.oracle.truffle.js.builtins.foreign.ForeignIterablePrototypeBuiltins;
import com.oracle.truffle.js.builtins.foreign.ForeignIteratorPrototypeBuiltins;
import com.oracle.truffle.js.builtins.json.JSON;
import com.oracle.truffle.js.builtins.temporal.TemporalNowBuiltins;
import com.oracle.truffle.js.builtins.testing.PolyglotInternalBuiltins;
import com.oracle.truffle.js.builtins.testing.RealmFunctionBuiltins;
import com.oracle.truffle.js.builtins.web.JSTextDecoder;
import com.oracle.truffle.js.builtins.web.JSTextEncoder;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSAgent;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSConsoleUtil;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSContextOptions;
import com.oracle.truffle.js.runtime.JSErrorType;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Properties;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.array.TypedArray;
import com.oracle.truffle.js.runtime.array.TypedArrayFactory;
import com.oracle.truffle.js.runtime.builtins.Builtin;
import com.oracle.truffle.js.runtime.builtins.JSAdapter;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSArrayIterator;
import com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import com.oracle.truffle.js.runtime.builtins.JSAsyncIterator;
import com.oracle.truffle.js.runtime.builtins.JSBigInt;
import com.oracle.truffle.js.runtime.builtins.JSBoolean;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSDataView;
import com.oracle.truffle.js.runtime.builtins.JSDate;
import com.oracle.truffle.js.runtime.builtins.JSError;
import com.oracle.truffle.js.runtime.builtins.JSFinalizationRegistry;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSGlobal;
import com.oracle.truffle.js.runtime.builtins.JSIterator;
import com.oracle.truffle.js.runtime.builtins.JSMap;
import com.oracle.truffle.js.runtime.builtins.JSMapIterator;
import com.oracle.truffle.js.runtime.builtins.JSMath;
import com.oracle.truffle.js.runtime.builtins.JSNumber;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSObjectPrototype;
import com.oracle.truffle.js.runtime.builtins.JSObjectPrototypeObject;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.JSPromise;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.builtins.JSRegExp;
import com.oracle.truffle.js.runtime.builtins.JSSet;
import com.oracle.truffle.js.runtime.builtins.JSSetIterator;
import com.oracle.truffle.js.runtime.builtins.JSShadowRealm;
import com.oracle.truffle.js.runtime.builtins.JSSharedArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSString;
import com.oracle.truffle.js.runtime.builtins.JSStringIterator;
import com.oracle.truffle.js.runtime.builtins.JSSymbol;
import com.oracle.truffle.js.runtime.builtins.JSTest262;
import com.oracle.truffle.js.runtime.builtins.JSTestV8;
import com.oracle.truffle.js.runtime.builtins.JSWeakMap;
import com.oracle.truffle.js.runtime.builtins.JSWeakRef;
import com.oracle.truffle.js.runtime.builtins.JSWeakSet;
import com.oracle.truffle.js.runtime.builtins.JSWorker;
import com.oracle.truffle.js.runtime.builtins.JSWrapForValidAsyncIterator;
import com.oracle.truffle.js.runtime.builtins.JSWrapForValidIterator;
import com.oracle.truffle.js.runtime.builtins.asynccontext.JSAsyncContext;
import com.oracle.truffle.js.runtime.builtins.asynccontext.JSAsyncContextSnapshot;
import com.oracle.truffle.js.runtime.builtins.asynccontext.JSAsyncContextVariable;
import com.oracle.truffle.js.runtime.builtins.intl.JSCollator;
import com.oracle.truffle.js.runtime.builtins.intl.JSDateTimeFormat;
import com.oracle.truffle.js.runtime.builtins.intl.JSDisplayNames;
import com.oracle.truffle.js.runtime.builtins.intl.JSDurationFormat;
import com.oracle.truffle.js.runtime.builtins.intl.JSIntl;
import com.oracle.truffle.js.runtime.builtins.intl.JSListFormat;
import com.oracle.truffle.js.runtime.builtins.intl.JSLocale;
import com.oracle.truffle.js.runtime.builtins.intl.JSNumberFormat;
import com.oracle.truffle.js.runtime.builtins.intl.JSPluralRules;
import com.oracle.truffle.js.runtime.builtins.intl.JSRelativeTimeFormat;
import com.oracle.truffle.js.runtime.builtins.intl.JSSegmenter;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalInstant;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainMonthDay;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainYearMonth;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTime;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssembly;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyGlobal;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyInstance;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyMemory;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyMemoryGrowCallback;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyMemoryNotifyCallback;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyMemoryWaitCallback;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyModule;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyTable;
import com.oracle.truffle.js.runtime.interop.DynamicScopeWrapper;
import com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import com.oracle.truffle.js.runtime.interop.TopScopeObject;
import com.oracle.truffle.js.runtime.java.JavaImporter;
import com.oracle.truffle.js.runtime.java.JavaPackage;
import com.oracle.truffle.js.runtime.objects.Accessor;
import com.oracle.truffle.js.runtime.objects.DefaultESModuleLoader;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSModuleLoader;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.PropertyProxy;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import com.oracle.truffle.js.runtime.util.LRUCache;
import com.oracle.truffle.js.runtime.util.PrintWriterWrapper;
import com.oracle.truffle.js.runtime.util.SimpleArrayList;
import com.oracle.truffle.js.runtime.util.StableContextOptionValue;
import com.oracle.truffle.js.runtime.util.TRegexUtil;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.LinkOption;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.SplittableRandom;
import java.util.WeakHashMap;
import org.graalvm.collections.Pair;
import org.graalvm.home.HomeFinder;
import org.graalvm.options.OptionValues;
import org.graalvm.shadowed.com.ibm.icu.text.DateFormat;
import org.graalvm.shadowed.com.ibm.icu.text.SimpleDateFormat;
import org.graalvm.shadowed.com.ibm.icu.text.TimeZoneFormat;
import org.graalvm.shadowed.com.ibm.icu.text.TimeZoneNames;
import org.graalvm.shadowed.com.ibm.icu.util.Calendar;
import org.graalvm.shadowed.com.ibm.icu.util.GregorianCalendar;
import org.graalvm.shadowed.com.ibm.icu.util.TimeZone;
import org.graalvm.shadowed.com.ibm.icu.util.ULocale;

public class JSRealm {
    public static final TruffleString POLYGLOT_CLASS_NAME = Strings.constant("Polyglot");
    public static final TruffleString REFLECT_CLASS_NAME = Strings.constant("Reflect");
    public static final TruffleString ATOMICS_CLASS_NAME = Strings.constant("Atomics");
    public static final TruffleString REALM_BUILTIN_CLASS_NAME = Strings.constant("Realm");
    public static final TruffleString ARGUMENTS_NAME = Strings.ARGUMENTS;
    public static final TruffleString JAVA_CLASS_NAME = Strings.constant("Java");
    public static final TruffleString JAVA_CLASS_NAME_NASHORN_COMPAT = Strings.constant("JavaNashornCompat");
    public static final TruffleString PERFORMANCE_CLASS_NAME = Strings.constant("performance");
    public static final TruffleString DEBUG_CLASS_NAME = Strings.constant("Debug");
    public static final TruffleString CONSOLE_CLASS_NAME = Strings.constant("Console");
    public static final TruffleString SYMBOL_ITERATOR_NAME = Strings.constant("[Symbol.iterator]");
    public static final TruffleString MLE_CLASS_NAME = Strings.constant("MLE");
    private static final TruffleString GRAALVM_VERSION = Strings.fromJavaString(HomeFinder.getInstance().getVersion());
    private static final TruffleLanguage.ContextReference<JSRealm> REFERENCE = TruffleLanguage.ContextReference.create(JavaScriptLanguage.class);
    private final JSContext context;
    private final JSContextOptions contextOptions;
    @CompilerDirectives.CompilationFinal
    private JSDynamicObject globalObject;
    private final JSFunctionObject objectConstructor;
    private final JSObjectPrototypeObject objectPrototype;
    private final JSFunctionObject functionConstructor;
    private final JSFunctionObject functionPrototype;
    private final JSFunctionObject arrayConstructor;
    private final JSArrayObject arrayPrototype;
    private final JSFunctionObject booleanConstructor;
    private final JSDynamicObject booleanPrototype;
    private final JSFunctionObject numberConstructor;
    private final JSDynamicObject numberPrototype;
    private final JSFunctionObject bigIntConstructor;
    private final JSDynamicObject bigIntPrototype;
    private final JSFunctionObject stringConstructor;
    private final JSDynamicObject stringPrototype;
    private final JSFunctionObject regExpConstructor;
    private final JSDynamicObject regExpPrototype;
    private final JSFunctionObject collatorConstructor;
    private final JSDynamicObject collatorPrototype;
    private final JSFunctionObject numberFormatConstructor;
    private final JSDynamicObject numberFormatPrototype;
    private final JSFunctionObject pluralRulesConstructor;
    private final JSDynamicObject pluralRulesPrototype;
    private final JSFunctionObject listFormatConstructor;
    private final JSDynamicObject listFormatPrototype;
    private final JSFunctionObject dateTimeFormatConstructor;
    private final JSDynamicObject dateTimeFormatPrototype;
    private final JSFunctionObject relativeTimeFormatConstructor;
    private final JSDynamicObject relativeTimeFormatPrototype;
    private final JSFunctionObject segmenterConstructor;
    private final JSDynamicObject segmenterPrototype;
    private final JSFunctionObject displayNamesConstructor;
    private final JSDynamicObject displayNamesPrototype;
    private final JSFunctionObject localeConstructor;
    private final JSDynamicObject localePrototype;
    private final JSFunctionObject durationFormatConstructor;
    private final JSDynamicObject durationFormatPrototype;
    private final JSFunctionObject dateConstructor;
    private final JSDynamicObject datePrototype;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final JSFunctionObject[] errorConstructors;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final JSDynamicObject[] errorPrototypes;
    private final JSFunctionObject callSiteConstructor;
    private final JSDynamicObject callSitePrototype;
    private final JSDynamicObject foreignArrayPrototype;
    private final JSDynamicObject foreignDatePrototype;
    private final JSDynamicObject foreignMapPrototype;
    private final JSDynamicObject foreignStringPrototype;
    private final JSDynamicObject foreignNumberPrototype;
    private final JSDynamicObject foreignBooleanPrototype;
    private final JSDynamicObject foreignErrorPrototype;
    private final JSDynamicObject foreignFunctionPrototype;
    private final JSDynamicObject foreignObjectPrototype;
    private final Shape initialRegExpPrototypeShape;
    private final JSObjectFactory.RealmData objectFactories;
    private final JSFunctionObject temporalPlainTimeConstructor;
    private final JSDynamicObject temporalPlainTimePrototype;
    private final JSFunctionObject temporalPlainDateConstructor;
    private final JSDynamicObject temporalPlainDatePrototype;
    private final JSFunctionObject temporalPlainDateTimeConstructor;
    private final JSDynamicObject temporalPlainDateTimePrototype;
    private final JSFunctionObject temporalDurationConstructor;
    private final JSDynamicObject temporalDurationPrototype;
    private final JSFunctionObject temporalPlainYearMonthConstructor;
    private final JSDynamicObject temporalPlainYearMonthPrototype;
    private final JSFunctionObject temporalPlainMonthDayConstructor;
    private final JSDynamicObject temporalPlainMonthDayPrototype;
    private final JSFunctionObject temporalInstantConstructor;
    private final JSDynamicObject temporalInstantPrototype;
    private final JSFunctionObject temporalZonedDateTimeConstructor;
    private final JSDynamicObject temporalZonedDateTimePrototype;
    private final JSFunctionObject symbolConstructor;
    private final JSDynamicObject symbolPrototype;
    private final JSFunctionObject mapConstructor;
    private final JSDynamicObject mapPrototype;
    private final JSFunctionObject setConstructor;
    private final JSDynamicObject setPrototype;
    private final JSFunctionObject weakRefConstructor;
    private final JSDynamicObject weakRefPrototype;
    private final JSFunctionObject weakMapConstructor;
    private final JSDynamicObject weakMapPrototype;
    private final JSFunctionObject weakSetConstructor;
    private final JSDynamicObject weakSetPrototype;
    private final JSDynamicObject mathObject;
    private JSDynamicObject realmBuiltinObject;
    private Object evalFunctionObject;
    private final Object applyFunctionObject;
    private final Object callFunctionObject;
    private Object reflectApplyFunctionObject;
    private Object reflectConstructFunctionObject;
    private Object commonJSRequireFunctionObject;
    private Object jsonParseFunctionObject;
    private final JSFunctionObject arrayBufferConstructor;
    private final JSDynamicObject arrayBufferPrototype;
    private final JSFunctionObject sharedArrayBufferConstructor;
    private final JSDynamicObject sharedArrayBufferPrototype;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final JSFunctionObject[] typedArrayConstructors;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final JSDynamicObject[] typedArrayPrototypes;
    private final JSFunctionObject dataViewConstructor;
    private final JSDynamicObject dataViewPrototype;
    private final JSFunctionObject jsAdapterConstructor;
    private final JSDynamicObject jsAdapterPrototype;
    private final JSFunctionObject javaImporterConstructor;
    private final JSDynamicObject javaImporterPrototype;
    private final JSFunctionObject proxyConstructor;
    private final JSDynamicObject proxyPrototype;
    private final JSFunctionObject finalizationRegistryConstructor;
    private final JSDynamicObject finalizationRegistryPrototype;
    private final JSFunctionObject iteratorConstructor;
    private final JSDynamicObject iteratorPrototype;
    private final JSDynamicObject wrapForIteratorPrototype;
    private final JSDynamicObject wrapForAsyncIteratorPrototype;
    private final JSDynamicObject arrayIteratorPrototype;
    private final JSDynamicObject setIteratorPrototype;
    private final JSDynamicObject mapIteratorPrototype;
    private final JSDynamicObject asyncIteratorHelperPrototype;
    private final JSDynamicObject iteratorHelperPrototype;
    private final JSDynamicObject segmentsPrototype;
    private final JSDynamicObject segmentIteratorPrototype;
    private final JSDynamicObject stringIteratorPrototype;
    private final JSDynamicObject regExpStringIteratorPrototype;
    private final JSDynamicObject enumerateIteratorPrototype;
    private final JSDynamicObject forInIteratorPrototype;
    private final JSFunctionObject generatorFunctionConstructor;
    private final JSDynamicObject generatorFunctionPrototype;
    private final JSDynamicObject generatorObjectPrototype;
    private final JSFunctionObject asyncFunctionConstructor;
    private final JSDynamicObject asyncFunctionPrototype;
    private final JSFunctionObject asyncIteratorContructor;
    private final JSDynamicObject asyncIteratorPrototype;
    private final JSDynamicObject asyncFromSyncIteratorPrototype;
    private final JSDynamicObject asyncGeneratorObjectPrototype;
    private final JSFunctionObject asyncGeneratorFunctionConstructor;
    private final JSDynamicObject asyncGeneratorFunctionPrototype;
    private final JSFunctionObject throwTypeErrorFunction;
    private final Accessor throwerAccessor;
    private final JSFunctionObject promiseConstructor;
    private final JSDynamicObject promisePrototype;
    private JSFunctionObject promiseAllFunctionObject;
    private JSFunctionObject promiseResolveFunctionObject;
    private Object unhandledPromiseRejectionHandler;
    private final JSDynamicObject ordinaryHasInstanceFunction;
    @CompilerDirectives.CompilationFinal
    private JSDynamicObject javaPackageToPrimitiveFunction;
    private final JSDynamicObject arrayProtoValuesIterator;
    @CompilerDirectives.CompilationFinal
    private JSFunctionObject typedArrayConstructor;
    @CompilerDirectives.CompilationFinal
    private JSDynamicObject typedArrayPrototype;
    private JSDynamicObject preinitIntlObject;
    private JSDynamicObject preinitConsoleBuiltinObject;
    private JSDynamicObject preinitPerformanceObject;
    private volatile Map<Object, JSArrayObject> templateRegistry;
    private volatile Map<Object, JSArrayObject> dedentMap;
    private final JSDynamicObject globalScope;
    private final JSDynamicObject scriptEngineImportScope;
    @CompilerDirectives.CompilationFinal
    private TopScopeObject topScope;
    private TruffleLanguage.Env truffleLanguageEnv;
    private boolean preparingStackTrace;
    private Object embedderData;
    private Object staticRegexResult;
    private TruffleString staticRegexResultInputString = Strings.EMPTY_STRING;
    private Object staticRegexResultCompiledRegex;
    private boolean staticRegexResultInvalidated;
    private long staticRegexResultFromIndex;
    private TruffleString staticRegexResultOriginalInputString;
    private final JSFunctionObject abstractModuleSourceConstructor;
    private final JSDynamicObject abstractModuleSourcePrototype;
    private final Object wasmTableAlloc;
    private final Object wasmTableGrow;
    private final Object wasmTableRead;
    private final Object wasmTableWrite;
    private final Object wasmTableLength;
    private final Object wasmFuncType;
    private final Object wasmIsFunc;
    private final Object wasmMemAlloc;
    private final Object wasmMemGrow;
    private final Object wasmMemAsByteBuffer;
    private final Object wasmGlobalAlloc;
    private final Object wasmGlobalRead;
    private final Object wasmGlobalWrite;
    private final Object wasmModuleInstantiate;
    private final Object wasmModuleExports;
    private final Object wasmModuleImports;
    private final Object wasmCustomSections;
    private final Object wasmInstanceExport;
    private final Object wasmEmbedderDataGet;
    private final Object wasmEmbedderDataSet;
    private final Object wasmRefNull;
    private final JSDynamicObject webAssemblyObject;
    private final JSFunctionObject webAssemblyGlobalConstructor;
    private final JSDynamicObject webAssemblyGlobalPrototype;
    private final JSFunctionObject webAssemblyInstanceConstructor;
    private final JSDynamicObject webAssemblyInstancePrototype;
    private final JSFunctionObject webAssemblyMemoryConstructor;
    private final JSDynamicObject webAssemblyMemoryPrototype;
    private final JSFunctionObject webAssemblyModuleConstructor;
    private final JSDynamicObject webAssemblyModulePrototype;
    private final JSFunctionObject webAssemblyTableConstructor;
    private final JSDynamicObject webAssemblyTablePrototype;
    private final JSFunctionObject shadowRealmConstructor;
    private final JSDynamicObject shadowRealmPrototype;
    private final JSFunctionObject workerConstructor;
    private final JSDynamicObject workerPrototype;
    private final JSFunctionObject asyncContextSnapshotConstructor;
    private final JSDynamicObject asyncContextSnapshotPrototype;
    private final JSFunctionObject asyncContextVariableConstructor;
    private final JSDynamicObject asyncContextVariablePrototype;
    private final JSDynamicObject foreignIterablePrototype;
    private final JSDynamicObject foreignIteratorPrototype;
    private final JSFunctionObject textDecoderConstructor;
    private final JSDynamicObject textDecoderPrototype;
    private final JSFunctionObject textEncoderConstructor;
    private final JSDynamicObject textEncoderPrototype;
    private ZoneId localTimeZoneId;
    private TimeZone localTimeZone;
    @CompilerDirectives.CompilationFinal
    private DateFormat jsDateFormat;
    @CompilerDirectives.CompilationFinal
    private DateFormat jsDateFormatBeforeYear0;
    @CompilerDirectives.CompilationFinal
    private DateFormat jsDateFormatAfterYear9999;
    @CompilerDirectives.CompilationFinal
    private DateFormat jsDateFormatISO;
    private DateFormat jsShortDateFormat;
    private DateFormat jsShortDateLocalFormat;
    private DateFormat jsShortTimeFormat;
    private DateFormat jsShortTimeLocalFormat;
    private DateFormat jsDateToStringFormat;
    public static final long NANOSECONDS_PER_MILLISECOND = 1000000L;
    public static final long NANOSECONDS_PER_SECOND = 1000000000L;
    private SplittableRandom random;
    private long nanoToZeroTimeOffset;
    private long lastFuzzyTime = Long.MIN_VALUE;
    private final Charset charset;
    private PrintWriterWrapper outputWriter;
    private PrintWriterWrapper errorWriter;
    private final JSConsoleUtil consoleUtil;
    private JSModuleLoader moduleLoader;
    private long lastAsyncEvaluationOrder;
    @CompilerDirectives.CompilationFinal
    private JSAgent agent;
    private List<JSRealm> realmList;
    private final JSRealm parentRealm;
    private JSRealm currentRealm;
    private JSRealm v8RealmCurrent = this;
    Object v8RealmShared = Undefined.instance;
    private JavaScriptBaseNode callNode;
    private final Map<TruffleFile, JSDynamicObject> commonJSRequireCache;
    private final SimpleArrayList<Object> joinStack = new SimpleArrayList();
    private Map<Source, Object> compiledRegexCache;
    private Object customEsmPathMappingCallback;
    private JSDynamicObject parentPromise;
    private int operatorCounter = 3;
    private static final TruffleString REALM_SHARED_NAME = Strings.SHARED;
    private static final PropertyProxy REALM_SHARED_PROXY = new RealmSharedPropertyProxy();

    protected JSRealm(JSContext context, TruffleLanguage.Env env, JSRealm parentRealm) {
        boolean es6;
        this.context = context;
        this.contextOptions = JSContextOptions.fromOptionValues(env.getSandboxPolicy(), env.getOptions());
        this.truffleLanguageEnv = env;
        if (!env.isPreInitialization()) {
            context.updateStableOptions(this.contextOptions, StableContextOptionValue.UpdateKind.UPDATE);
        }
        this.parentRealm = parentRealm;
        if (parentRealm == null) {
            this.currentRealm = this;
        } else {
            this.currentRealm = null;
            this.agent = parentRealm.agent;
        }
        this.objectPrototype = JSObjectPrototype.create(context);
        this.functionPrototype = JSFunction.createFunctionPrototype(this, this.objectPrototype);
        this.objectFactories = context.newObjectFactoryRealmData();
        this.throwTypeErrorFunction = this.createThrowTypeErrorFunction(false);
        JSFunctionObject throwerFunction = this.createThrowTypeErrorFunction(true);
        this.throwerAccessor = new Accessor((Object)throwerFunction, (Object)throwerFunction);
        if (context.isOptionAnnexB()) {
            JSRealm.putProtoAccessorProperty(this);
        }
        this.globalObject = JSGlobal.create(this, this.objectPrototype);
        this.globalScope = JSGlobal.createGlobalScope(context);
        this.scriptEngineImportScope = context.getLanguageOptions().scriptEngineGlobalScopeImport() ? JSOrdinary.createWithNullPrototypeInit(context) : null;
        this.topScope = this.createTopScope();
        this.objectConstructor = JSRealm.createObjectConstructor(this, this.objectPrototype);
        JSObjectUtil.putDataProperty(this.objectPrototype, JSObject.CONSTRUCTOR, (Object)this.objectConstructor, JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putFunctionsFromContainer(this, this.objectPrototype, JSObjectPrototype.BUILTINS);
        this.functionConstructor = JSFunction.createFunctionConstructor(this);
        JSFunction.fillFunctionPrototype(this);
        this.applyFunctionObject = JSDynamicObject.getOrNull(this.getFunctionPrototype(), Strings.APPLY);
        this.callFunctionObject = JSDynamicObject.getOrNull(this.getFunctionPrototype(), Strings.CALL);
        JSConstructor ctor = JSArray.createConstructor(this);
        this.arrayConstructor = ctor.getFunctionObject();
        this.arrayPrototype = (JSArrayObject)ctor.getPrototype();
        ctor = JSBoolean.createConstructor(this);
        this.booleanConstructor = ctor.getFunctionObject();
        this.booleanPrototype = ctor.getPrototype();
        ctor = JSNumber.createConstructor(this);
        this.numberConstructor = ctor.getFunctionObject();
        this.numberPrototype = ctor.getPrototype();
        ctor = JSString.createConstructor(this);
        this.stringConstructor = ctor.getFunctionObject();
        this.stringPrototype = ctor.getPrototype();
        ctor = JSRegExp.createConstructor(this);
        this.regExpConstructor = ctor.getFunctionObject();
        this.regExpPrototype = ctor.getPrototype();
        ctor = JSDate.createConstructor(this);
        this.dateConstructor = ctor.getFunctionObject();
        this.datePrototype = ctor.getPrototype();
        this.initialRegExpPrototypeShape = this.regExpPrototype.getShape();
        int ecmaScriptVersion = context.getLanguageOptions().ecmaScriptVersion();
        boolean bl = es6 = ecmaScriptVersion >= 6;
        if (es6) {
            ctor = JSSymbol.createConstructor(this);
            this.symbolConstructor = ctor.getFunctionObject();
            this.symbolPrototype = ctor.getPrototype();
            ctor = JSMap.createConstructor(this);
            this.mapConstructor = ctor.getFunctionObject();
            this.mapPrototype = ctor.getPrototype();
            ctor = JSSet.createConstructor(this);
            this.setConstructor = ctor.getFunctionObject();
            this.setPrototype = ctor.getPrototype();
            ctor = JSWeakMap.createConstructor(this);
            this.weakMapConstructor = ctor.getFunctionObject();
            this.weakMapPrototype = ctor.getPrototype();
            ctor = JSWeakSet.createConstructor(this);
            this.weakSetConstructor = ctor.getFunctionObject();
            this.weakSetPrototype = ctor.getPrototype();
            ctor = JSProxy.createConstructor(this);
            this.proxyConstructor = ctor.getFunctionObject();
            this.proxyPrototype = ctor.getPrototype();
            ctor = JSPromise.createConstructor(this);
            this.promiseConstructor = ctor.getFunctionObject();
            this.promisePrototype = ctor.getPrototype();
        } else {
            this.symbolConstructor = null;
            this.symbolPrototype = null;
            this.mapConstructor = null;
            this.mapPrototype = null;
            this.setConstructor = null;
            this.setPrototype = null;
            this.weakMapConstructor = null;
            this.weakMapPrototype = null;
            this.weakSetConstructor = null;
            this.weakSetPrototype = null;
            this.proxyConstructor = null;
            this.proxyPrototype = null;
            this.promiseConstructor = null;
            this.promisePrototype = null;
        }
        this.errorConstructors = new JSFunctionObject[JSErrorType.errorTypes().length];
        this.errorPrototypes = new JSDynamicObject[JSErrorType.errorTypes().length];
        this.initializeErrorConstructors();
        ctor = JSError.createCallSiteConstructor(this);
        this.callSiteConstructor = ctor.getFunctionObject();
        this.callSitePrototype = ctor.getPrototype();
        ctor = JSArrayBuffer.createConstructor(this);
        this.arrayBufferConstructor = ctor.getFunctionObject();
        this.arrayBufferPrototype = ctor.getPrototype();
        this.typedArrayConstructors = new JSFunctionObject[TypedArray.factories(context).length];
        this.typedArrayPrototypes = new JSDynamicObject[TypedArray.factories(context).length];
        this.initializeTypedArrayConstructors();
        ctor = JSDataView.createConstructor(this);
        this.dataViewConstructor = ctor.getFunctionObject();
        this.dataViewPrototype = ctor.getPrototype();
        if (this.contextOptions.isBigInt()) {
            ctor = JSBigInt.createConstructor(this);
            this.bigIntConstructor = ctor.getFunctionObject();
            this.bigIntPrototype = ctor.getPrototype();
        } else {
            this.bigIntConstructor = null;
            this.bigIntPrototype = null;
        }
        if (context.getLanguageOptions().iteratorHelpers()) {
            assert (ecmaScriptVersion >= 9);
            ctor = JSIterator.createConstructor(this);
            this.iteratorConstructor = ctor.getFunctionObject();
            this.iteratorPrototype = ctor.getPrototype();
            this.wrapForIteratorPrototype = JSWrapForValidIterator.INSTANCE.createPrototype(this, this.iteratorConstructor);
            this.iteratorHelperPrototype = this.createIteratorHelperPrototype();
        } else {
            this.iteratorPrototype = this.createIteratorPrototype();
            this.iteratorConstructor = null;
            this.wrapForIteratorPrototype = null;
            this.iteratorHelperPrototype = null;
        }
        if (context.getLanguageOptions().asyncIteratorHelpers()) {
            ctor = JSAsyncIterator.createConstructor(this);
            this.asyncIteratorPrototype = ctor.getPrototype();
            this.asyncIteratorContructor = ctor.getFunctionObject();
            this.wrapForAsyncIteratorPrototype = JSWrapForValidAsyncIterator.INSTANCE.createPrototype(this, this.asyncIteratorContructor);
            this.asyncIteratorHelperPrototype = this.createAsyncIteratorHelperPrototype();
        } else {
            this.asyncIteratorPrototype = ecmaScriptVersion >= 9 ? JSFunction.createAsyncIteratorPrototype(this) : null;
            this.asyncIteratorContructor = null;
            this.wrapForAsyncIteratorPrototype = null;
            this.asyncIteratorHelperPrototype = null;
        }
        this.arrayIteratorPrototype = es6 ? JSArrayIterator.INSTANCE.createPrototype(this, this.iteratorConstructor) : null;
        this.setIteratorPrototype = es6 ? JSSetIterator.INSTANCE.createPrototype(this, this.iteratorConstructor) : null;
        this.mapIteratorPrototype = es6 ? JSMapIterator.INSTANCE.createPrototype(this, this.iteratorConstructor) : null;
        this.stringIteratorPrototype = es6 ? JSStringIterator.INSTANCE.createPrototype(this, this.iteratorConstructor) : null;
        this.regExpStringIteratorPrototype = ecmaScriptVersion >= 10 ? this.createRegExpStringIteratorPrototype() : null;
        ctor = JSCollator.createConstructor(this);
        this.collatorConstructor = ctor.getFunctionObject();
        this.collatorPrototype = ctor.getPrototype();
        ctor = JSNumberFormat.createConstructor(this);
        this.numberFormatConstructor = ctor.getFunctionObject();
        this.numberFormatPrototype = ctor.getPrototype();
        ctor = JSDateTimeFormat.createConstructor(this);
        this.dateTimeFormatConstructor = ctor.getFunctionObject();
        this.dateTimeFormatPrototype = ctor.getPrototype();
        ctor = JSPluralRules.createConstructor(this);
        this.pluralRulesConstructor = ctor.getFunctionObject();
        this.pluralRulesPrototype = ctor.getPrototype();
        ctor = JSListFormat.createConstructor(this);
        this.listFormatConstructor = ctor.getFunctionObject();
        this.listFormatPrototype = ctor.getPrototype();
        ctor = JSRelativeTimeFormat.createConstructor(this);
        this.relativeTimeFormatConstructor = ctor.getFunctionObject();
        this.relativeTimeFormatPrototype = ctor.getPrototype();
        ctor = JSSegmenter.createConstructor(this);
        this.segmenterConstructor = ctor.getFunctionObject();
        this.segmenterPrototype = ctor.getPrototype();
        this.segmentsPrototype = JSSegmenter.createSegmentsPrototype(this);
        this.segmentIteratorPrototype = JSSegmenter.createSegmentIteratorPrototype(this);
        ctor = JSDisplayNames.createConstructor(this);
        this.displayNamesConstructor = ctor.getFunctionObject();
        this.displayNamesPrototype = ctor.getPrototype();
        ctor = JSLocale.createConstructor(this);
        this.localeConstructor = ctor.getFunctionObject();
        this.localePrototype = ctor.getPrototype();
        if (ecmaScriptVersion >= 16) {
            ctor = JSDurationFormat.createConstructor(this);
            this.durationFormatConstructor = ctor.getFunctionObject();
            this.durationFormatPrototype = ctor.getPrototype();
        } else {
            this.durationFormatConstructor = null;
            this.durationFormatPrototype = null;
        }
        if (es6) {
            ctor = JSFunction.createGeneratorFunctionConstructor(this);
            this.generatorFunctionConstructor = ctor.getFunctionObject();
            this.generatorFunctionPrototype = ctor.getPrototype();
            this.generatorObjectPrototype = (JSDynamicObject)((Object)JSDynamicObject.getOrNull(this.generatorFunctionPrototype, JSObject.PROTOTYPE));
        } else {
            this.generatorFunctionConstructor = null;
            this.generatorFunctionPrototype = null;
            this.generatorObjectPrototype = null;
        }
        this.enumerateIteratorPrototype = JSFunction.createEnumerateIteratorPrototype(this);
        this.forInIteratorPrototype = JSFunction.createForInIteratorPrototype(this);
        this.arrayProtoValuesIterator = (JSDynamicObject)((Object)JSDynamicObject.getOrDefault(this.getArrayPrototype(), Symbol.SYMBOL_ITERATOR, (Object)Undefined.instance));
        if (context.isOptionSharedArrayBuffer()) {
            ctor = JSSharedArrayBuffer.createConstructor(this);
            this.sharedArrayBufferConstructor = ctor.getFunctionObject();
            this.sharedArrayBufferPrototype = ctor.getPrototype();
        } else {
            this.sharedArrayBufferConstructor = null;
            this.sharedArrayBufferPrototype = null;
        }
        this.mathObject = JSMath.create(this);
        if (ecmaScriptVersion >= 8) {
            ctor = JSFunction.createAsyncFunctionConstructor(this);
            this.asyncFunctionConstructor = ctor.getFunctionObject();
            this.asyncFunctionPrototype = ctor.getPrototype();
        } else {
            this.asyncFunctionConstructor = null;
            this.asyncFunctionPrototype = null;
        }
        if (ecmaScriptVersion >= 9) {
            this.asyncFromSyncIteratorPrototype = JSFunction.createAsyncFromSyncIteratorPrototype(this);
            ctor = JSFunction.createAsyncGeneratorFunctionConstructor(this);
            this.asyncGeneratorFunctionConstructor = ctor.getFunctionObject();
            this.asyncGeneratorFunctionPrototype = ctor.getPrototype();
            this.asyncGeneratorObjectPrototype = (JSDynamicObject)((Object)JSDynamicObject.getOrNull(this.asyncGeneratorFunctionPrototype, JSObject.PROTOTYPE));
        } else {
            this.asyncFromSyncIteratorPrototype = null;
            this.asyncGeneratorFunctionConstructor = null;
            this.asyncGeneratorFunctionPrototype = null;
            this.asyncGeneratorObjectPrototype = null;
        }
        if (ecmaScriptVersion >= 12) {
            ctor = JSWeakRef.createConstructor(this);
            this.weakRefConstructor = ctor.getFunctionObject();
            this.weakRefPrototype = ctor.getPrototype();
            ctor = JSFinalizationRegistry.createConstructor(this);
            this.finalizationRegistryConstructor = ctor.getFunctionObject();
            this.finalizationRegistryPrototype = ctor.getPrototype();
        } else {
            this.weakRefConstructor = null;
            this.weakRefPrototype = null;
            this.finalizationRegistryConstructor = null;
            this.finalizationRegistryPrototype = null;
        }
        this.ordinaryHasInstanceFunction = JSFunction.createOrdinaryHasInstanceFunction(this);
        boolean nashornCompat = context.isOptionNashornCompatibilityMode();
        if (nashornCompat) {
            ctor = JSAdapter.createConstructor(this);
            this.jsAdapterConstructor = ctor.getFunctionObject();
            this.jsAdapterPrototype = ctor.getPrototype();
            ctor = JavaImporter.createConstructor(this);
            this.javaImporterConstructor = ctor.getFunctionObject();
            this.javaImporterPrototype = ctor.getPrototype();
        } else {
            this.jsAdapterConstructor = null;
            this.jsAdapterPrototype = null;
            this.javaImporterConstructor = null;
            this.javaImporterPrototype = null;
        }
        this.charset = this.getCharsetImpl();
        this.outputWriter = new PrintWriterWrapper(env.out(), true, this.charset);
        this.errorWriter = new PrintWriterWrapper(env.err(), true, this.charset);
        this.consoleUtil = new JSConsoleUtil();
        this.commonJSRequireCache = context.getLanguageOptions().commonJSRequire() ? new HashMap<TruffleFile, JSDynamicObject>() : null;
        ctor = this.createAbstractModuleSourcePrototype();
        this.abstractModuleSourceConstructor = ctor.getFunctionObject();
        this.abstractModuleSourcePrototype = ctor.getPrototype();
        if (context.getLanguageOptions().webAssembly()) {
            LanguageInfo wasmLanguageInfo = this.ensureWasmLanguageAvailable();
            this.truffleLanguageEnv.initializeLanguage(wasmLanguageInfo);
            Object wasmObject = this.truffleLanguageEnv.importSymbol("WebAssembly");
            try {
                InteropLibrary wasmInterop = InteropLibrary.getUncached((Object)wasmObject);
                this.wasmTableAlloc = wasmInterop.readMember(wasmObject, "table_alloc");
                this.wasmTableGrow = wasmInterop.readMember(wasmObject, "table_grow");
                this.wasmTableRead = wasmInterop.readMember(wasmObject, "table_read");
                this.wasmTableWrite = wasmInterop.readMember(wasmObject, "table_write");
                this.wasmTableLength = wasmInterop.readMember(wasmObject, "table_size");
                this.wasmFuncType = wasmInterop.readMember(wasmObject, "func_type");
                this.wasmIsFunc = wasmInterop.readMember(wasmObject, "is_func");
                this.wasmMemAlloc = wasmInterop.readMember(wasmObject, "mem_alloc");
                this.wasmMemGrow = wasmInterop.readMember(wasmObject, "mem_grow");
                this.wasmGlobalAlloc = wasmInterop.readMember(wasmObject, "global_alloc");
                this.wasmGlobalRead = wasmInterop.readMember(wasmObject, "global_read");
                this.wasmGlobalWrite = wasmInterop.readMember(wasmObject, "global_write");
                this.wasmModuleInstantiate = wasmInterop.readMember(wasmObject, "module_instantiate");
                this.wasmModuleExports = wasmInterop.readMember(wasmObject, "module_exports");
                this.wasmModuleImports = wasmInterop.readMember(wasmObject, "module_imports");
                this.wasmCustomSections = wasmInterop.readMember(wasmObject, "custom_sections");
                this.wasmInstanceExport = wasmInterop.readMember(wasmObject, "instance_export");
                this.wasmEmbedderDataGet = wasmInterop.readMember(wasmObject, "embedder_data_get");
                this.wasmEmbedderDataSet = wasmInterop.readMember(wasmObject, "embedder_data_set");
                this.wasmMemAsByteBuffer = wasmInterop.readMember(wasmObject, "mem_as_byte_buffer");
                this.wasmRefNull = wasmInterop.readMember(wasmObject, "ref_null");
                InteropLibrary settersInterop = InteropLibrary.getUncached();
                settersInterop.execute(wasmInterop.readMember(wasmObject, "mem_set_grow_callback"), new Object[]{new JSWebAssemblyMemoryGrowCallback(this)});
                settersInterop.execute(wasmInterop.readMember(wasmObject, "mem_set_notify_callback"), new Object[]{new JSWebAssemblyMemoryNotifyCallback(this, context)});
                settersInterop.execute(wasmInterop.readMember(wasmObject, "mem_set_wait_callback"), new Object[]{new JSWebAssemblyMemoryWaitCallback(this, context)});
            }
            catch (InteropException ex) {
                throw Errors.shouldNotReachHere(ex);
            }
            this.webAssemblyObject = JSWebAssembly.create(this);
            ctor = JSWebAssemblyModule.createConstructor(this);
            this.webAssemblyModuleConstructor = ctor.getFunctionObject();
            this.webAssemblyModulePrototype = ctor.getPrototype();
            ctor = JSWebAssemblyInstance.createConstructor(this);
            this.webAssemblyInstanceConstructor = ctor.getFunctionObject();
            this.webAssemblyInstancePrototype = ctor.getPrototype();
            ctor = JSWebAssemblyMemory.createConstructor(this);
            this.webAssemblyMemoryConstructor = ctor.getFunctionObject();
            this.webAssemblyMemoryPrototype = ctor.getPrototype();
            ctor = JSWebAssemblyTable.createConstructor(this);
            this.webAssemblyTableConstructor = ctor.getFunctionObject();
            this.webAssemblyTablePrototype = ctor.getPrototype();
            ctor = JSWebAssemblyGlobal.createConstructor(this);
            this.webAssemblyGlobalConstructor = ctor.getFunctionObject();
            this.webAssemblyGlobalPrototype = ctor.getPrototype();
        } else {
            this.wasmTableAlloc = null;
            this.wasmTableGrow = null;
            this.wasmTableRead = null;
            this.wasmTableWrite = null;
            this.wasmTableLength = null;
            this.wasmFuncType = null;
            this.wasmIsFunc = null;
            this.wasmMemAlloc = null;
            this.wasmMemGrow = null;
            this.wasmMemAsByteBuffer = null;
            this.wasmGlobalAlloc = null;
            this.wasmGlobalRead = null;
            this.wasmGlobalWrite = null;
            this.wasmModuleInstantiate = null;
            this.wasmModuleExports = null;
            this.wasmModuleImports = null;
            this.wasmCustomSections = null;
            this.wasmInstanceExport = null;
            this.wasmEmbedderDataGet = null;
            this.wasmEmbedderDataSet = null;
            this.wasmRefNull = null;
            this.webAssemblyObject = null;
            this.webAssemblyGlobalConstructor = null;
            this.webAssemblyGlobalPrototype = null;
            this.webAssemblyInstanceConstructor = null;
            this.webAssemblyInstancePrototype = null;
            this.webAssemblyMemoryConstructor = null;
            this.webAssemblyMemoryPrototype = null;
            this.webAssemblyModuleConstructor = null;
            this.webAssemblyModulePrototype = null;
            this.webAssemblyTableConstructor = null;
            this.webAssemblyTablePrototype = null;
        }
        this.foreignIterablePrototype = this.createForeignIterablePrototype();
        this.foreignIteratorPrototype = this.createForeignIteratorPrototype();
        if (context.isOptionTemporal()) {
            ctor = JSTemporalPlainTime.createConstructor(this);
            this.temporalPlainTimeConstructor = ctor.getFunctionObject();
            this.temporalPlainTimePrototype = ctor.getPrototype();
            ctor = JSTemporalPlainDate.createConstructor(this);
            this.temporalPlainDateConstructor = ctor.getFunctionObject();
            this.temporalPlainDatePrototype = ctor.getPrototype();
            ctor = JSTemporalPlainDateTime.createConstructor(this);
            this.temporalPlainDateTimeConstructor = ctor.getFunctionObject();
            this.temporalPlainDateTimePrototype = ctor.getPrototype();
            ctor = JSTemporalDuration.createConstructor(this);
            this.temporalDurationConstructor = ctor.getFunctionObject();
            this.temporalDurationPrototype = ctor.getPrototype();
            ctor = JSTemporalPlainYearMonth.createConstructor(this);
            this.temporalPlainYearMonthConstructor = ctor.getFunctionObject();
            this.temporalPlainYearMonthPrototype = ctor.getPrototype();
            ctor = JSTemporalPlainMonthDay.createConstructor(this);
            this.temporalPlainMonthDayConstructor = ctor.getFunctionObject();
            this.temporalPlainMonthDayPrototype = ctor.getPrototype();
            ctor = JSTemporalInstant.createConstructor(this);
            this.temporalInstantConstructor = ctor.getFunctionObject();
            this.temporalInstantPrototype = ctor.getPrototype();
            ctor = JSTemporalZonedDateTime.createConstructor(this);
            this.temporalZonedDateTimeConstructor = ctor.getFunctionObject();
            this.temporalZonedDateTimePrototype = ctor.getPrototype();
        } else {
            this.temporalPlainTimeConstructor = null;
            this.temporalPlainTimePrototype = null;
            this.temporalPlainDateConstructor = null;
            this.temporalPlainDatePrototype = null;
            this.temporalPlainDateTimeConstructor = null;
            this.temporalPlainDateTimePrototype = null;
            this.temporalDurationConstructor = null;
            this.temporalDurationPrototype = null;
            this.temporalPlainYearMonthConstructor = null;
            this.temporalPlainYearMonthPrototype = null;
            this.temporalPlainMonthDayConstructor = null;
            this.temporalPlainMonthDayPrototype = null;
            this.temporalInstantConstructor = null;
            this.temporalInstantPrototype = null;
            this.temporalZonedDateTimeConstructor = null;
            this.temporalZonedDateTimePrototype = null;
        }
        if (context.getLanguageOptions().shadowRealm()) {
            ctor = JSShadowRealm.createConstructor(this);
            this.shadowRealmConstructor = ctor.getFunctionObject();
            this.shadowRealmPrototype = ctor.getPrototype();
        } else {
            this.shadowRealmConstructor = null;
            this.shadowRealmPrototype = null;
        }
        if (context.getLanguageOptions().worker()) {
            ctor = JSWorker.createConstructor(this);
            this.workerConstructor = ctor.getFunctionObject();
            this.workerPrototype = ctor.getPrototype();
        } else {
            this.workerConstructor = null;
            this.workerPrototype = null;
        }
        if (context.getLanguageOptions().asyncContext()) {
            ctor = JSAsyncContextSnapshot.createConstructor(this);
            this.asyncContextSnapshotConstructor = ctor.getFunctionObject();
            this.asyncContextSnapshotPrototype = ctor.getPrototype();
            ctor = JSAsyncContextVariable.createConstructor(this);
            this.asyncContextVariableConstructor = ctor.getFunctionObject();
            this.asyncContextVariablePrototype = ctor.getPrototype();
        } else {
            this.asyncContextSnapshotConstructor = null;
            this.asyncContextSnapshotPrototype = null;
            this.asyncContextVariableConstructor = null;
            this.asyncContextVariablePrototype = null;
        }
        if (this.contextOptions.isTextEncoding()) {
            ctor = JSTextDecoder.createConstructor(this);
            this.textDecoderConstructor = ctor.getFunctionObject();
            this.textDecoderPrototype = ctor.getPrototype();
            ctor = JSTextEncoder.createConstructor(this);
            this.textEncoderConstructor = ctor.getFunctionObject();
            this.textEncoderPrototype = ctor.getPrototype();
        } else {
            this.textDecoderConstructor = null;
            this.textDecoderPrototype = null;
            this.textEncoderConstructor = null;
            this.textEncoderPrototype = null;
        }
        this.foreignArrayPrototype = JSOrdinary.createInit(this, this.arrayPrototype);
        this.foreignDatePrototype = JSOrdinary.createInit(this, this.datePrototype);
        this.foreignMapPrototype = JSOrdinary.createInit(this, this.mapPrototype == null ? Null.instance : this.mapPrototype);
        this.foreignStringPrototype = JSOrdinary.createInit(this, this.stringPrototype);
        this.foreignNumberPrototype = JSOrdinary.createInit(this, this.numberPrototype);
        this.foreignBooleanPrototype = JSOrdinary.createInit(this, this.booleanPrototype);
        this.foreignErrorPrototype = JSError.createForeignErrorPrototype(this);
        this.foreignFunctionPrototype = JSOrdinary.createInit(this, this.functionPrototype);
        this.foreignObjectPrototype = JSOrdinary.createInit(this, this.objectPrototype);
    }

    private void initializeTypedArrayConstructors() {
        JSConstructor taConst = JSArrayBufferView.createTypedArrayConstructor(this);
        this.typedArrayConstructor = taConst.getFunctionObject();
        this.typedArrayPrototype = taConst.getPrototype();
        for (TypedArrayFactory factory : TypedArray.factories(this.context)) {
            JSConstructor constructor = JSArrayBufferView.createConstructor(this, factory, taConst);
            this.typedArrayConstructors[factory.getFactoryIndex()] = constructor.getFunctionObject();
            this.typedArrayPrototypes[factory.getFactoryIndex()] = constructor.getPrototype();
        }
    }

    private void initializeErrorConstructors() {
        for (JSErrorType type : JSErrorType.errorTypes()) {
            JSConstructor errorConstructor = JSError.createErrorConstructor(this, type);
            this.errorConstructors[type.ordinal()] = errorConstructor.getFunctionObject();
            this.errorPrototypes[type.ordinal()] = errorConstructor.getPrototype();
        }
    }

    public final JSContext getContext() {
        return this.context;
    }

    public static JSRealm getMain(Node node) {
        return (JSRealm)REFERENCE.get(node);
    }

    public static JSRealm get(Node node) {
        JSRealm mainRealm = (JSRealm)REFERENCE.get(node);
        if (CompilerDirectives.inCompiledCode()) {
            if (CompilerDirectives.isPartialEvaluationConstant((Object)node) && node != null && JavaScriptLanguage.get(node).getJSContext().isSingleRealm()) {
                assert (mainRealm == mainRealm.currentRealm);
                return mainRealm;
            }
        } else assert (mainRealm.currentRealm == mainRealm || !JavaScriptLanguage.get(node).getJSContext().isSingleRealm());
        return mainRealm.currentRealm;
    }

    private boolean allowEnterLeave(Node node, JSRealm otherRealm) {
        assert (this.isMainRealm() && JSRealm.getMain(node) == this);
        assert (!JavaScriptLanguage.get(node).getJSContext().isSingleRealm() || this.currentRealm == otherRealm);
        return true;
    }

    public JSRealm enterRealm(Node node, JSRealm childRealm) {
        assert (this.allowEnterLeave(node, childRealm));
        JSRealm prev = this.currentRealm;
        this.currentRealm = childRealm;
        return prev;
    }

    public void leaveRealm(Node node, JSRealm prevRealm) {
        assert (this.allowEnterLeave(node, prevRealm));
        this.currentRealm = prevRealm;
    }

    public final JSFunctionObject lookupFunction(JSBuiltinsContainer container, Object key) {
        assert (JSRuntime.isPropertyKey(key));
        Builtin builtin = Objects.requireNonNull(container.lookupFunctionByKey(key));
        JSFunctionData functionData = builtin.createFunctionData(this.context);
        return JSFunction.create(this, functionData);
    }

    public final JSFunctionObject lookupFunctionWithPrototype(JSBuiltinsContainer container, Object key, JSDynamicObject prototype) {
        assert (JSRuntime.isPropertyKey(key));
        Builtin builtin = Objects.requireNonNull(container.lookupFunctionByKey(key));
        JSFunctionData functionData = builtin.createFunctionData(this.context);
        return JSFunction.createWithPrototype(this, functionData, prototype);
    }

    public final Accessor lookupAccessor(JSBuiltinsContainer container, Object key) {
        JSFunctionData functionData;
        Pair<JSBuiltin, JSBuiltin> pair = container.lookupAccessorByKey(key);
        JSBuiltin getterBuiltin = (JSBuiltin)pair.getLeft();
        JSBuiltin setterBuiltin = (JSBuiltin)pair.getRight();
        JSFunctionObject getterFunction = null;
        JSFunctionObject setterFunction = null;
        if (getterBuiltin != null) {
            functionData = getterBuiltin.createFunctionData(this.context);
            getterFunction = JSFunction.create(this, functionData);
        }
        if (setterBuiltin != null) {
            functionData = setterBuiltin.createFunctionData(this.context);
            setterFunction = JSFunction.create(this, functionData);
        }
        return new Accessor((Object)getterFunction, (Object)setterFunction);
    }

    public static JSFunctionObject createObjectConstructor(JSRealm realm, JSDynamicObject objectPrototype) {
        JSContext context = realm.getContext();
        JSFunctionObject objectConstructor = realm.lookupFunction(ConstructorBuiltins.BUILTINS, JSOrdinary.CLASS_NAME);
        JSObjectUtil.putConstructorPrototypeProperty(objectConstructor, objectPrototype);
        JSObjectUtil.putFunctionsFromContainer(realm, objectConstructor, ObjectFunctionBuiltins.BUILTINS);
        if (context.isOptionNashornCompatibilityMode()) {
            JSObjectUtil.putFunctionsFromContainer(realm, objectConstructor, ObjectFunctionBuiltins.BUILTINS_NASHORN_COMPAT);
        }
        return objectConstructor;
    }

    public final JSFunctionObject getErrorConstructor(JSErrorType type) {
        return this.errorConstructors[type.ordinal()];
    }

    public final JSDynamicObject getErrorPrototype(JSErrorType type) {
        return this.errorPrototypes[type.ordinal()];
    }

    public final JSDynamicObject getGlobalObject() {
        return this.globalObject;
    }

    public final void setGlobalObject(JSDynamicObject global) {
        this.context.getGlobalObjectPristineAssumption().invalidate();
        this.globalObject = global;
        this.topScope = this.createTopScope();
    }

    private TopScopeObject createTopScope() {
        return new TopScopeObject(new Object[]{this.scriptEngineImportScope, new DynamicScopeWrapper(this.globalScope), this.globalObject});
    }

    public final void dispose() {
        this.globalObject = Undefined.instance;
        this.topScope = TopScopeObject.empty();
    }

    public final JSFunctionObject getObjectConstructor() {
        return this.objectConstructor;
    }

    public final JSDynamicObject getObjectPrototype() {
        return this.objectPrototype;
    }

    public final JSFunctionObject getFunctionConstructor() {
        return this.functionConstructor;
    }

    public final JSDynamicObject getFunctionPrototype() {
        return this.functionPrototype;
    }

    public final JSFunctionObject getArrayConstructor() {
        return this.arrayConstructor;
    }

    public final JSDynamicObject getArrayPrototype() {
        return this.arrayPrototype;
    }

    public final JSFunctionObject getBooleanConstructor() {
        return this.booleanConstructor;
    }

    public final JSDynamicObject getBooleanPrototype() {
        return this.booleanPrototype;
    }

    public final JSFunctionObject getNumberConstructor() {
        return this.numberConstructor;
    }

    public final JSDynamicObject getNumberPrototype() {
        return this.numberPrototype;
    }

    public final JSFunctionObject getBigIntConstructor() {
        return this.bigIntConstructor;
    }

    public final JSDynamicObject getBigIntPrototype() {
        return this.bigIntPrototype;
    }

    public final JSFunctionObject getStringConstructor() {
        return this.stringConstructor;
    }

    public final JSDynamicObject getStringPrototype() {
        return this.stringPrototype;
    }

    public final JSFunctionObject getRegExpConstructor() {
        return this.regExpConstructor;
    }

    public final JSDynamicObject getRegExpPrototype() {
        return this.regExpPrototype;
    }

    public final JSFunctionObject getCollatorConstructor() {
        return this.collatorConstructor;
    }

    public final JSDynamicObject getCollatorPrototype() {
        return this.collatorPrototype;
    }

    public final JSFunctionObject getNumberFormatConstructor() {
        return this.numberFormatConstructor;
    }

    public final JSDynamicObject getNumberFormatPrototype() {
        return this.numberFormatPrototype;
    }

    public final JSFunctionObject getPluralRulesConstructor() {
        return this.pluralRulesConstructor;
    }

    public final JSDynamicObject getPluralRulesPrototype() {
        return this.pluralRulesPrototype;
    }

    public final JSFunctionObject getListFormatConstructor() {
        return this.listFormatConstructor;
    }

    public final JSDynamicObject getListFormatPrototype() {
        return this.listFormatPrototype;
    }

    public final JSFunctionObject getRelativeTimeFormatConstructor() {
        return this.relativeTimeFormatConstructor;
    }

    public final JSDynamicObject getRelativeTimeFormatPrototype() {
        return this.relativeTimeFormatPrototype;
    }

    public final JSFunctionObject getDateTimeFormatConstructor() {
        return this.dateTimeFormatConstructor;
    }

    public final JSDynamicObject getDateTimeFormatPrototype() {
        return this.dateTimeFormatPrototype;
    }

    public final JSFunctionObject getDateConstructor() {
        return this.dateConstructor;
    }

    public final JSDynamicObject getDatePrototype() {
        return this.datePrototype;
    }

    public final JSFunctionObject getSegmenterConstructor() {
        return this.segmenterConstructor;
    }

    public final JSDynamicObject getSegmenterPrototype() {
        return this.segmenterPrototype;
    }

    public final JSFunctionObject getDisplayNamesConstructor() {
        return this.displayNamesConstructor;
    }

    public final JSDynamicObject getDisplayNamesPrototype() {
        return this.displayNamesPrototype;
    }

    public final JSFunctionObject getLocaleConstructor() {
        return this.localeConstructor;
    }

    public final JSDynamicObject getLocalePrototype() {
        return this.localePrototype;
    }

    public final JSFunctionObject getDurationFormatConstructor() {
        return this.durationFormatConstructor;
    }

    public final JSDynamicObject getDurationFormatPrototype() {
        return this.durationFormatPrototype;
    }

    public final JSFunctionObject getSymbolConstructor() {
        return this.symbolConstructor;
    }

    public final JSDynamicObject getSymbolPrototype() {
        return this.symbolPrototype;
    }

    public final JSFunctionObject getMapConstructor() {
        return this.mapConstructor;
    }

    public final JSDynamicObject getMapPrototype() {
        return this.mapPrototype;
    }

    public final JSFunctionObject getSetConstructor() {
        return this.setConstructor;
    }

    public final JSDynamicObject getSetPrototype() {
        return this.setPrototype;
    }

    public final JSFunctionObject getWeakRefConstructor() {
        return this.weakRefConstructor;
    }

    public final JSDynamicObject getWeakRefPrototype() {
        return this.weakRefPrototype;
    }

    public final JSFunctionObject getFinalizationRegistryConstructor() {
        return this.finalizationRegistryConstructor;
    }

    public final JSDynamicObject getFinalizationRegistryPrototype() {
        return this.finalizationRegistryPrototype;
    }

    public final JSFunctionObject getWeakMapConstructor() {
        return this.weakMapConstructor;
    }

    public final JSDynamicObject getWeakMapPrototype() {
        return this.weakMapPrototype;
    }

    public final JSFunctionObject getWeakSetConstructor() {
        return this.weakSetConstructor;
    }

    public final JSDynamicObject getWeakSetPrototype() {
        return this.weakSetPrototype;
    }

    public final Shape getInitialRegExpPrototypeShape() {
        return this.initialRegExpPrototypeShape;
    }

    public final JSFunctionObject getArrayBufferConstructor() {
        return this.arrayBufferConstructor;
    }

    public final JSDynamicObject getArrayBufferPrototype() {
        return this.arrayBufferPrototype;
    }

    public final JSFunctionObject getSharedArrayBufferConstructor() {
        assert (this.context.isOptionSharedArrayBuffer());
        return this.sharedArrayBufferConstructor;
    }

    public final JSDynamicObject getSharedArrayBufferPrototype() {
        assert (this.context.isOptionSharedArrayBuffer());
        return this.sharedArrayBufferPrototype;
    }

    public final JSFunctionObject getArrayBufferViewConstructor(TypedArrayFactory factory) {
        return this.typedArrayConstructors[factory.getFactoryIndex()];
    }

    public final JSDynamicObject getArrayBufferViewPrototype(TypedArrayFactory factory) {
        return this.typedArrayPrototypes[factory.getFactoryIndex()];
    }

    public final JSFunctionObject getDataViewConstructor() {
        return this.dataViewConstructor;
    }

    public final JSDynamicObject getDataViewPrototype() {
        return this.dataViewPrototype;
    }

    public final JSFunctionObject getTypedArrayConstructor() {
        return this.typedArrayConstructor;
    }

    public final JSDynamicObject getTypedArrayPrototype() {
        return this.typedArrayPrototype;
    }

    public final JSDynamicObject getRealmBuiltinObject() {
        return this.realmBuiltinObject;
    }

    public final JSFunctionObject getProxyConstructor() {
        return this.proxyConstructor;
    }

    public final JSDynamicObject getProxyPrototype() {
        return this.proxyPrototype;
    }

    public final JSFunctionObject getGeneratorFunctionConstructor() {
        return this.generatorFunctionConstructor;
    }

    public final JSDynamicObject getGeneratorFunctionPrototype() {
        return this.generatorFunctionPrototype;
    }

    public final JSFunctionObject getAsyncFunctionConstructor() {
        return this.asyncFunctionConstructor;
    }

    public final JSDynamicObject getAsyncFunctionPrototype() {
        return this.asyncFunctionPrototype;
    }

    public final JSFunctionObject getAsyncGeneratorFunctionConstructor() {
        return this.asyncGeneratorFunctionConstructor;
    }

    public final JSDynamicObject getAsyncGeneratorFunctionPrototype() {
        return this.asyncGeneratorFunctionPrototype;
    }

    public final JSDynamicObject getEnumerateIteratorPrototype() {
        return this.enumerateIteratorPrototype;
    }

    public final JSDynamicObject getForInIteratorPrototype() {
        return this.forInIteratorPrototype;
    }

    public final JSDynamicObject getGeneratorObjectPrototype() {
        return this.generatorObjectPrototype;
    }

    public final JSDynamicObject getAsyncGeneratorObjectPrototype() {
        return this.asyncGeneratorObjectPrototype;
    }

    public final JSFunctionObject getJavaImporterConstructor() {
        return this.javaImporterConstructor;
    }

    public final JSDynamicObject getJavaImporterPrototype() {
        return this.javaImporterPrototype;
    }

    public final JSDynamicObject getJavaPackageToPrimitiveFunction() {
        assert (this.javaPackageToPrimitiveFunction != null);
        return this.javaPackageToPrimitiveFunction;
    }

    public final JSFunctionObject getTemporalPlainTimeConstructor() {
        return this.temporalPlainTimeConstructor;
    }

    public final JSDynamicObject getTemporalPlainTimePrototype() {
        return this.temporalPlainTimePrototype;
    }

    public final JSFunctionObject getTemporalPlainDateConstructor() {
        return this.temporalPlainDateConstructor;
    }

    public final JSDynamicObject getTemporalPlainDatePrototype() {
        return this.temporalPlainDatePrototype;
    }

    public final JSFunctionObject getTemporalPlainDateTimeConstructor() {
        return this.temporalPlainDateTimeConstructor;
    }

    public final JSDynamicObject getTemporalPlainDateTimePrototype() {
        return this.temporalPlainDateTimePrototype;
    }

    public final JSFunctionObject getTemporalDurationConstructor() {
        return this.temporalDurationConstructor;
    }

    public final JSDynamicObject getTemporalDurationPrototype() {
        return this.temporalDurationPrototype;
    }

    public final JSFunctionObject getTemporalPlainYearMonthConstructor() {
        return this.temporalPlainYearMonthConstructor;
    }

    public JSDynamicObject getTemporalPlainYearMonthPrototype() {
        return this.temporalPlainYearMonthPrototype;
    }

    public JSFunctionObject getTemporalPlainMonthDayConstructor() {
        return this.temporalPlainMonthDayConstructor;
    }

    public JSDynamicObject getTemporalPlainMonthDayPrototype() {
        return this.temporalPlainMonthDayPrototype;
    }

    public JSFunctionObject getTemporalInstantConstructor() {
        return this.temporalInstantConstructor;
    }

    public JSDynamicObject getTemporalInstantPrototype() {
        return this.temporalInstantPrototype;
    }

    public JSFunctionObject getTemporalZonedDateTimeConstructor() {
        return this.temporalZonedDateTimeConstructor;
    }

    public JSDynamicObject getTemporalZonedDateTimePrototype() {
        return this.temporalZonedDateTimePrototype;
    }

    public final JSDynamicObject getForeignArrayPrototype() {
        return this.foreignArrayPrototype;
    }

    public final JSDynamicObject getForeignDatePrototype() {
        return this.foreignDatePrototype;
    }

    public JSDynamicObject getForeignMapPrototype() {
        return this.foreignMapPrototype;
    }

    public JSDynamicObject getForeignStringPrototype() {
        return this.foreignStringPrototype;
    }

    public JSDynamicObject getForeignNumberPrototype() {
        return this.foreignNumberPrototype;
    }

    public JSDynamicObject getForeignBooleanPrototype() {
        return this.foreignBooleanPrototype;
    }

    public JSDynamicObject getForeignErrorPrototype() {
        return this.foreignErrorPrototype;
    }

    public JSDynamicObject getForeignFunctionPrototype() {
        return this.foreignFunctionPrototype;
    }

    public JSDynamicObject getForeignObjectPrototype() {
        return this.foreignObjectPrototype;
    }

    public final Map<Object, JSArrayObject> getTemplateRegistry() {
        if (this.templateRegistry == null) {
            this.createTemplateRegistry();
        }
        return this.templateRegistry;
    }

    @CompilerDirectives.TruffleBoundary
    private void createTemplateRegistry() {
        if (this.templateRegistry == null) {
            this.templateRegistry = new WeakHashMap<Object, JSArrayObject>();
        }
    }

    public final Map<Object, JSArrayObject> getDedentMap() {
        if (this.dedentMap == null) {
            this.createDedentMap();
        }
        return this.dedentMap;
    }

    @CompilerDirectives.TruffleBoundary
    private void createDedentMap() {
        if (this.dedentMap == null) {
            this.dedentMap = new WeakHashMap<Object, JSArrayObject>();
        }
    }

    public final Object getEvalFunctionObject() {
        return this.evalFunctionObject;
    }

    public final Object getApplyFunctionObject() {
        return this.applyFunctionObject;
    }

    public final Object getCallFunctionObject() {
        return this.callFunctionObject;
    }

    public final Object getReflectApplyFunctionObject() {
        return this.reflectApplyFunctionObject;
    }

    public final Object getReflectConstructFunctionObject() {
        return this.reflectConstructFunctionObject;
    }

    public final Object getCommonJSRequireFunctionObject() {
        return this.commonJSRequireFunctionObject;
    }

    public final Object getJsonParseFunctionObject() {
        return this.jsonParseFunctionObject;
    }

    public final JSFunctionObject getPromiseAllFunctionObject() {
        return this.promiseAllFunctionObject;
    }

    public final JSFunctionObject getPromiseResolveFunctionObject() {
        return this.promiseResolveFunctionObject;
    }

    public final Object getUnhandledPromiseRejectionHandler() {
        return this.unhandledPromiseRejectionHandler;
    }

    private static void putProtoAccessorProperty(JSRealm realm) {
        JSContext context = realm.getContext();
        JSFunctionObject getProto = JSFunction.create(realm, context.protoGetterFunctionData);
        JSFunctionObject setProto = JSFunction.create(realm, context.protoSetterFunctionData);
        JSObjectUtil.putBuiltinAccessorProperty(realm.getObjectPrototype(), (Object)JSObject.PROTO, getProto, setProto);
    }

    public final JSFunctionObject getThrowTypeErrorFunction() {
        assert (this.throwTypeErrorFunction != null);
        return this.throwTypeErrorFunction;
    }

    public final Accessor getThrowerAccessor() {
        assert (this.throwerAccessor != null);
        return this.throwerAccessor;
    }

    public JSFunctionObject getIteratorConstructor() {
        return this.iteratorConstructor;
    }

    public JSFunctionObject getAsyncIteratorConstructor() {
        return this.asyncIteratorContructor;
    }

    public JSDynamicObject getIteratorPrototype() {
        return this.iteratorPrototype;
    }

    public JSDynamicObject getWrapForIteratorPrototype() {
        return this.wrapForIteratorPrototype;
    }

    public JSDynamicObject getWrapForAsyncIteratorPrototype() {
        return this.wrapForAsyncIteratorPrototype;
    }

    public JSDynamicObject getAsyncIteratorPrototype() {
        return this.asyncIteratorPrototype;
    }

    public JSDynamicObject getAsyncFromSyncIteratorPrototype() {
        return this.asyncFromSyncIteratorPrototype;
    }

    public JSDynamicObject getArrayIteratorPrototype() {
        return this.arrayIteratorPrototype;
    }

    public JSDynamicObject getSetIteratorPrototype() {
        return this.setIteratorPrototype;
    }

    public JSDynamicObject getMapIteratorPrototype() {
        return this.mapIteratorPrototype;
    }

    public JSDynamicObject getIteratorHelperPrototype() {
        return this.iteratorHelperPrototype;
    }

    public JSDynamicObject getAsyncIteratorHelperPrototype() {
        return this.asyncIteratorHelperPrototype;
    }

    public JSDynamicObject getStringIteratorPrototype() {
        return this.stringIteratorPrototype;
    }

    public JSDynamicObject getRegExpStringIteratorPrototype() {
        return this.regExpStringIteratorPrototype;
    }

    public JSDynamicObject getSegmentsPrototype() {
        return this.segmentsPrototype;
    }

    public JSDynamicObject getSegmentIteratorPrototype() {
        return this.segmentIteratorPrototype;
    }

    private JSFunctionObject createThrowTypeErrorFunction(boolean restrictedProperty) {
        CompilerAsserts.neverPartOfCompilation();
        JSFunctionObject thrower = JSFunction.create(this, restrictedProperty ? this.context.throwTypeErrorRestrictedPropertyFunctionData : this.context.throwTypeErrorFunctionData);
        thrower.preventExtensions(true);
        thrower.setIntegrityLevel(true, true);
        return thrower;
    }

    public JSFunctionObject getPromiseConstructor() {
        return this.promiseConstructor;
    }

    public JSDynamicObject getPromisePrototype() {
        return this.promisePrototype;
    }

    public final JSObjectFactory.RealmData getObjectFactories() {
        return this.objectFactories;
    }

    public final JSFunctionObject getShadowRealmConstructor() {
        return this.shadowRealmConstructor;
    }

    public final JSDynamicObject getShadowRealmPrototype() {
        return this.shadowRealmPrototype;
    }

    public final JSFunctionObject getWorkerConstructor() {
        return this.workerConstructor;
    }

    public final JSDynamicObject getWorkerPrototype() {
        return this.workerPrototype;
    }

    public final JSFunctionObject getAsyncContextSnapshotConstructor() {
        return this.asyncContextSnapshotConstructor;
    }

    public final JSDynamicObject getAsyncContextSnapshotPrototype() {
        return this.asyncContextSnapshotPrototype;
    }

    public final JSFunctionObject getAsyncContexVariableConstructor() {
        return this.asyncContextVariableConstructor;
    }

    public final JSDynamicObject getAsyncContextVariablePrototype() {
        return this.asyncContextVariablePrototype;
    }

    public final JSContextOptions getContextOptions() {
        return this.contextOptions;
    }

    public void setupGlobals() {
        CompilerAsserts.neverPartOfCompilation((String)"do not setup globals from compiled code");
        long time = this.context.getLanguageOptions().profileTime() ? System.nanoTime() : 0L;
        JSDynamicObject global = this.getGlobalObject();
        this.putGlobalProperty(JSOrdinary.CLASS_NAME, (Object)this.getObjectConstructor());
        this.putGlobalProperty(JSFunction.CLASS_NAME, (Object)this.getFunctionConstructor());
        this.putGlobalProperty(JSArray.CLASS_NAME, (Object)this.getArrayConstructor());
        this.putGlobalProperty(JSString.CLASS_NAME, (Object)this.getStringConstructor());
        this.putGlobalProperty(JSDate.CLASS_NAME, (Object)this.getDateConstructor());
        this.putGlobalProperty(JSNumber.CLASS_NAME, (Object)this.getNumberConstructor());
        this.putGlobalProperty(JSBoolean.CLASS_NAME, (Object)this.getBooleanConstructor());
        this.putGlobalProperty(JSRegExp.CLASS_NAME, (Object)this.getRegExpConstructor());
        this.putGlobalProperty(JSMath.CLASS_NAME, (Object)this.mathObject);
        this.putGlobalProperty(JSON.CLASS_NAME, (Object)JSON.create(this));
        JSObjectUtil.putDataProperty(global, Strings.NAN, Double.NaN);
        JSObjectUtil.putDataProperty(global, Strings.INFINITY, Double.POSITIVE_INFINITY);
        JSObjectUtil.putDataProperty(global, Undefined.NAME, (Object)Undefined.instance);
        JSObjectUtil.putFunctionsFromContainer(this, global, GlobalBuiltins.GLOBAL_FUNCTIONS);
        this.evalFunctionObject = JSObject.get(global, JSGlobal.EVAL_NAME);
        JSDynamicObject jsonBuiltin = (JSDynamicObject)((Object)JSObject.get(global, JSON.CLASS_NAME));
        this.jsonParseFunctionObject = JSObject.get(jsonBuiltin, Strings.PARSE);
        boolean webassembly = this.getContextOptions().isWebAssembly();
        block4: for (JSErrorType jSErrorType : JSErrorType.errorTypes()) {
            switch (jSErrorType) {
                case CompileError: 
                case LinkError: 
                case RuntimeError: {
                    if (!webassembly) continue block4;
                    JSObjectUtil.putDataProperty(this.webAssemblyObject, Strings.fromJavaString(jSErrorType.name()), (Object)this.getErrorConstructor(jSErrorType), JSAttributes.getDefaultNotEnumerable());
                    continue block4;
                }
                case AggregateError: {
                    if (this.context.getEcmaScriptVersion() < 12) continue block4;
                    this.putGlobalProperty(Strings.fromJavaString(jSErrorType.name()), (Object)this.getErrorConstructor(jSErrorType));
                    continue block4;
                }
                default: {
                    this.putGlobalProperty(Strings.fromJavaString(jSErrorType.name()), (Object)this.getErrorConstructor(jSErrorType));
                }
            }
        }
        this.putGlobalProperty(JSArrayBuffer.CLASS_NAME, (Object)this.getArrayBufferConstructor());
        for (Enum enum_ : TypedArray.factories(this.context)) {
            this.putGlobalProperty(((TypedArrayFactory)enum_).getName(), (Object)this.getArrayBufferViewConstructor((TypedArrayFactory)enum_));
        }
        this.putGlobalProperty(JSDataView.CLASS_NAME, (Object)this.getDataViewConstructor());
        if (this.getContextOptions().isBigInt()) {
            this.putGlobalProperty(JSBigInt.CLASS_NAME, (Object)this.getBigIntConstructor());
        }
        if (this.context.isOptionNashornCompatibilityMode()) {
            this.initGlobalNashornExtensions();
            this.removeNashornIncompatibleBuiltins();
        }
        if (this.getContextOptions().isScriptEngineGlobalScopeImport()) {
            TruffleString builtin = Strings.IMPORT_SCRIPT_ENGINE_GLOBAL_BINDINGS;
            JSObjectUtil.putDataProperty(this.getScriptEngineImportScope(), builtin, (Object)this.lookupFunction(GlobalBuiltins.GLOBAL_NASHORN_EXTENSIONS, builtin), JSAttributes.notConfigurableNotEnumerableNotWritable());
        }
        if (this.getContextOptions().isPolyglotBuiltin() && (this.getEnv().isPolyglotEvalAllowed(null) || this.getEnv().isPolyglotBindingsAccessAllowed())) {
            this.setupPolyglot();
        }
        if (this.getContextOptions().isDebugBuiltin()) {
            this.putGlobalProperty(Strings.fromJavaString(this.getContextOptions().getDebugPropertyName()), (Object)this.createDebugObject());
        }
        if (this.context.isOptionMleBuiltin()) {
            this.putGlobalProperty(Strings.fromJavaString("MLE"), (Object)this.createMleObject());
        }
        if (this.getContextOptions().isTest262Mode()) {
            this.putGlobalProperty(JSTest262.GLOBAL_PROPERTY_NAME, (Object)JSTest262.create(this));
        }
        if (this.getContextOptions().isTestV8Mode()) {
            this.putGlobalProperty(JSTestV8.CLASS_NAME, (Object)JSTestV8.create(this));
        }
        if (this.getContextOptions().isV8RealmBuiltin()) {
            this.initRealmBuiltinObject();
        }
        if (this.context.getEcmaScriptVersion() >= 6) {
            Object parseInt = JSObject.get(global, Strings.PARSE_INT);
            Object parseFloat = JSObject.get(global, Strings.PARSE_FLOAT);
            JSRealm.putProperty(this.getNumberConstructor(), Strings.PARSE_INT, parseInt);
            JSRealm.putProperty(this.getNumberConstructor(), Strings.PARSE_FLOAT, parseFloat);
            this.putGlobalProperty(JSMap.CLASS_NAME, (Object)this.getMapConstructor());
            this.putGlobalProperty(JSSet.CLASS_NAME, (Object)this.getSetConstructor());
            this.putGlobalProperty(JSWeakMap.CLASS_NAME, (Object)this.getWeakMapConstructor());
            this.putGlobalProperty(JSWeakSet.CLASS_NAME, (Object)this.getWeakSetConstructor());
            this.putGlobalProperty(JSSymbol.CLASS_NAME, (Object)this.getSymbolConstructor());
            JSRealm.setupPredefinedSymbols(this.getSymbolConstructor());
            JSDynamicObject reflectObject = this.createReflect();
            this.putGlobalProperty(REFLECT_CLASS_NAME, (Object)reflectObject);
            this.reflectApplyFunctionObject = JSObject.get(reflectObject, Strings.APPLY);
            this.reflectConstructFunctionObject = JSObject.get(reflectObject, Strings.CONSTRUCT);
            this.putGlobalProperty(JSProxy.CLASS_NAME, (Object)this.getProxyConstructor());
            this.putGlobalProperty(JSPromise.CLASS_NAME, (Object)this.getPromiseConstructor());
            this.promiseAllFunctionObject = (JSFunctionObject)((Object)JSObject.get((JSDynamicObject)this.getPromiseConstructor(), Strings.ALL));
            this.promiseResolveFunctionObject = (JSFunctionObject)((Object)JSObject.get((JSDynamicObject)this.getPromiseConstructor(), Strings.RESOLVE));
        }
        if (this.getContextOptions().isIteratorHelpers()) {
            this.putGlobalProperty(JSIterator.CLASS_NAME, (Object)this.getIteratorConstructor());
        }
        if (this.getContextOptions().isAsyncIteratorHelpers()) {
            this.putGlobalProperty(JSAsyncIterator.CLASS_NAME, (Object)this.getAsyncIteratorConstructor());
        }
        if (this.context.isOptionSharedArrayBuffer()) {
            this.putGlobalProperty(JSSharedArrayBuffer.CLASS_NAME, (Object)this.getSharedArrayBufferConstructor());
        }
        if (this.getContextOptions().isAtomics()) {
            this.putGlobalProperty(ATOMICS_CLASS_NAME, (Object)this.createAtomics());
        }
        if (this.context.getEcmaScriptVersion() >= 10) {
            this.putGlobalProperty(Strings.GLOBAL_THIS, (Object)global);
        }
        if (this.context.getEcmaScriptVersion() >= 12) {
            this.putGlobalProperty(JSWeakRef.CLASS_NAME, (Object)this.getWeakRefConstructor());
            this.putGlobalProperty(JSFinalizationRegistry.CLASS_NAME, (Object)this.getFinalizationRegistryConstructor());
        }
        if (this.getContextOptions().isGraalBuiltin()) {
            this.putGraalObject();
        }
        if (webassembly) {
            this.putGlobalProperty(JSWebAssembly.CLASS_NAME, (Object)this.webAssemblyObject);
            JSObjectUtil.putDataProperty(this.webAssemblyObject, JSFunction.getName(this.webAssemblyGlobalConstructor), (Object)this.webAssemblyGlobalConstructor, JSAttributes.getDefaultNotEnumerable());
            JSObjectUtil.putDataProperty(this.webAssemblyObject, JSFunction.getName(this.webAssemblyInstanceConstructor), (Object)this.webAssemblyInstanceConstructor, JSAttributes.getDefaultNotEnumerable());
            JSObjectUtil.putDataProperty(this.webAssemblyObject, JSFunction.getName(this.webAssemblyMemoryConstructor), (Object)this.webAssemblyMemoryConstructor, JSAttributes.getDefaultNotEnumerable());
            JSObjectUtil.putDataProperty(this.webAssemblyObject, JSFunction.getName(this.webAssemblyModuleConstructor), (Object)this.webAssemblyModuleConstructor, JSAttributes.getDefaultNotEnumerable());
            JSObjectUtil.putDataProperty(this.webAssemblyObject, JSFunction.getName(this.webAssemblyTableConstructor), (Object)this.webAssemblyTableConstructor, JSAttributes.getDefaultNotEnumerable());
        }
        if (this.getContextOptions().isOperatorOverloading()) {
            JSObjectUtil.putFunctionsFromContainer(this, global, OperatorsBuiltins.BUILTINS);
        }
        if (this.context.isOptionTemporal()) {
            this.addTemporalGlobals();
        }
        if (this.getContextOptions().isShadowRealm()) {
            this.putGlobalProperty(JSShadowRealm.CLASS_NAME, (Object)this.getShadowRealmConstructor());
        }
        if (this.getContextOptions().isWorker()) {
            this.putGlobalProperty(JSWorker.CLASS_NAME, (Object)this.getWorkerConstructor());
        }
        if (this.getContextOptions().isAsyncContext()) {
            this.putGlobalProperty(JSAsyncContext.NAMESPACE_NAME, (Object)JSAsyncContext.create(this));
        }
        if (this.getContextOptions().isTextEncoding()) {
            this.putGlobalProperty(JSTextEncoder.CLASS_NAME, (Object)this.textEncoderConstructor);
            this.putGlobalProperty(JSTextDecoder.CLASS_NAME, (Object)this.textDecoderConstructor);
        }
        if (this.context.getLanguageOptions().profileTime()) {
            System.out.println("SetupGlobals: " + (System.nanoTime() - time) / 1000000L);
        }
    }

    private void initGlobalNashornExtensions() {
        assert (this.getContext().isOptionNashornCompatibilityMode());
        this.putGlobalProperty(JSAdapter.CLASS_NAME, (Object)this.jsAdapterConstructor);
        this.putGlobalProperty(Strings.EXIT, (Object)this.lookupFunction(GlobalBuiltins.GLOBAL_NASHORN_EXTENSIONS, Strings.EXIT));
        if (!this.getContextOptions().isShell()) {
            this.putGlobalProperty(Strings.QUIT, (Object)this.lookupFunction(GlobalBuiltins.GLOBAL_NASHORN_EXTENSIONS, Strings.QUIT));
        }
        this.putGlobalProperty(Strings.PARSE_TO_JSON, (Object)this.lookupFunction(GlobalBuiltins.GLOBAL_NASHORN_EXTENSIONS, Strings.PARSE_TO_JSON));
    }

    private void removeNashornIncompatibleBuiltins() {
        assert (this.getContext().isOptionNashornCompatibilityMode());
        JSObject.delete(this.typedArrayPrototype, Strings.JOIN);
    }

    private void addPrintGlobals() {
        if (this.getContextOptions().isPrint()) {
            this.putGlobalProperty(Strings.PRINT, (Object)this.lookupFunction(GlobalBuiltins.GLOBAL_PRINT, Strings.PRINT));
            this.putGlobalProperty(Strings.PRINT_ERR, (Object)this.lookupFunction(GlobalBuiltins.GLOBAL_PRINT, Strings.PRINT_ERR));
        }
    }

    @CompilerDirectives.TruffleBoundary
    private void addCommonJSGlobals() {
        if (this.getContextOptions().isCommonJSRequire()) {
            String cwdOption = this.getContextOptions().getRequireCwd();
            try {
                TruffleFile cwdFile;
                if (!cwdOption.isEmpty() && !(cwdFile = this.getEnv().getPublicTruffleFile(cwdOption)).exists(new LinkOption[0])) {
                    throw Errors.createError("Invalid CommonJS root folder: " + cwdOption);
                }
            }
            catch (IllegalArgumentException | SecurityException | UnsupportedOperationException se) {
                throw Errors.createError("Access denied to CommonJS root folder: " + cwdOption);
            }
            JSBuiltinsContainer builtins = GlobalCommonJSRequireBuiltins.GLOBAL_COMMONJS_REQUIRE_EXTENSIONS;
            JSFunctionObject requireFunction = this.lookupFunction(builtins, Strings.REQUIRE_PROPERTY_NAME);
            JSFunctionObject resolveFunction = this.lookupFunction(builtins, Strings.RESOLVE_PROPERTY_NAME);
            JSObject.set((JSDynamicObject)requireFunction, Strings.RESOLVE_PROPERTY_NAME, (Object)resolveFunction);
            this.putGlobalProperty(Strings.REQUIRE_PROPERTY_NAME, (Object)requireFunction);
            JSFunctionObject dirnameGetter = this.lookupFunction(builtins, GlobalCommonJSRequireBuiltins.GlobalRequire.dirnameGetter.getKey());
            JSObject.defineOwnProperty(this.getGlobalObject(), Strings.DIRNAME_VAR_NAME, PropertyDescriptor.createAccessor((Object)dirnameGetter, (Object)Undefined.instance, false, false));
            JSFunctionObject filenameGetter = this.lookupFunction(builtins, GlobalCommonJSRequireBuiltins.GlobalRequire.filenameGetter.getKey());
            JSObject.defineOwnProperty(this.getGlobalObject(), Strings.FILENAME_VAR_NAME, PropertyDescriptor.createAccessor((Object)filenameGetter, (Object)Undefined.instance, false, false));
            JSFunctionObject moduleGetter = this.lookupFunction(builtins, GlobalCommonJSRequireBuiltins.GlobalRequire.globalModuleGetter.getKey());
            JSObject.defineOwnProperty(this.getGlobalObject(), Strings.MODULE_PROPERTY_NAME, PropertyDescriptor.createAccessor((Object)moduleGetter, (Object)Undefined.instance, false, false));
            JSFunctionObject exportsGetter = this.lookupFunction(builtins, GlobalCommonJSRequireBuiltins.GlobalRequire.globalExportsGetter.getKey());
            JSObject.defineOwnProperty(this.getGlobalObject(), Strings.EXPORTS_PROPERTY_NAME, PropertyDescriptor.createAccessor((Object)exportsGetter, (Object)Undefined.instance, false, false));
            this.commonJSRequireFunctionObject = requireFunction;
        }
    }

    private void addLoadGlobals() {
        if (this.getContextOptions().isLoad()) {
            this.putGlobalProperty(Strings.LOAD, (Object)this.lookupFunction(GlobalBuiltins.GLOBAL_LOAD, Strings.LOAD));
            this.putGlobalProperty(Strings.LOAD_WITH_NEW_GLOBAL, (Object)this.lookupFunction(GlobalBuiltins.GLOBAL_LOAD, Strings.LOAD_WITH_NEW_GLOBAL));
        }
    }

    private void addPerformanceGlobal() {
        if (this.getContextOptions().isPerformance()) {
            this.putGlobalProperty(PERFORMANCE_CLASS_NAME, (Object)(this.preinitPerformanceObject != null ? this.preinitPerformanceObject : this.createPerformanceObject()));
        }
    }

    public void addOptionalGlobals() {
        assert (!this.getEnv().isPreInitialization());
        this.addGlobalGlobal();
        this.addShellGlobals();
        this.addScriptingGlobals();
        this.addIntlGlobal();
        this.addLoadGlobals();
        this.addConsoleGlobals();
        this.addPrintGlobals();
        this.addPerformanceGlobal();
        if (this.isJavaInteropEnabled()) {
            this.setupJavaInterop();
        }
        this.addCommonJSGlobals();
    }

    private void addGlobalGlobal() {
        if (this.getContextOptions().isGlobalProperty()) {
            this.putGlobalProperty(Strings.GLOBAL, (Object)this.getGlobalObject());
        }
    }

    private void addShellGlobals() {
        if (this.getContextOptions().isShell()) {
            GlobalBuiltins.GLOBAL_SHELL.forEachBuiltin(builtin -> {
                JSFunctionData functionData = builtin.createFunctionData(this.getContext());
                this.putGlobalProperty(builtin.getKey(), (Object)JSFunction.create(this, functionData), builtin.getAttributeFlags());
            });
        }
    }

    private void addIntlGlobal() {
        if (this.context.isOptionIntl402()) {
            this.putGlobalProperty(JSIntl.CLASS_NAME, (Object)(this.preinitIntlObject != null ? this.preinitIntlObject : this.createIntlObject()));
        }
    }

    private void addTemporalGlobals() {
        assert (this.context.isOptionTemporal());
        JSObject temporalObject = JSOrdinary.createInit(this);
        JSObjectUtil.putToStringTag(temporalObject, TemporalConstants.TEMPORAL);
        int flags = JSAttributes.configurableNotEnumerableWritable();
        JSObjectUtil.putDataProperty(temporalObject, JSTemporalPlainTime.CLASS_NAME, (Object)this.getTemporalPlainTimeConstructor(), flags);
        JSObjectUtil.putDataProperty(temporalObject, JSTemporalPlainDate.CLASS_NAME, (Object)this.getTemporalPlainDateConstructor(), flags);
        JSObjectUtil.putDataProperty(temporalObject, JSTemporalPlainDateTime.CLASS_NAME, (Object)this.getTemporalPlainDateTimeConstructor(), flags);
        JSObjectUtil.putDataProperty(temporalObject, JSTemporalDuration.CLASS_NAME, (Object)this.getTemporalDurationConstructor(), flags);
        JSObjectUtil.putDataProperty(temporalObject, JSTemporalPlainYearMonth.CLASS_NAME, (Object)this.getTemporalPlainYearMonthConstructor(), flags);
        JSObjectUtil.putDataProperty(temporalObject, JSTemporalPlainMonthDay.CLASS_NAME, (Object)this.getTemporalPlainMonthDayConstructor(), flags);
        JSObjectUtil.putDataProperty(temporalObject, JSTemporalInstant.CLASS_NAME, (Object)this.getTemporalInstantConstructor(), flags);
        JSObjectUtil.putDataProperty(temporalObject, JSTemporalZonedDateTime.CLASS_NAME, (Object)this.getTemporalZonedDateTimeConstructor(), flags);
        JSObject nowObject = JSOrdinary.createInit(this);
        JSObjectUtil.putDataProperty(temporalObject, TemporalConstants.NOW, (Object)nowObject, flags);
        JSObjectUtil.putFunctionsFromContainer(this, nowObject, TemporalNowBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(nowObject, TemporalConstants.TEMPORAL_NOW_TO_STRING_TAG);
        this.putGlobalProperty(TemporalConstants.TEMPORAL, (Object)temporalObject);
        JSFunctionObject toTemporalInstantFn = this.lookupFunction(DatePrototypeBuiltins.BUILTINS, Strings.TO_TEMPORAL_INSTANT);
        JSObjectUtil.putDataProperty(this.getDatePrototype(), Strings.TO_TEMPORAL_INSTANT, (Object)toTemporalInstantFn, JSAttributes.getDefaultNotEnumerable());
    }

    private JSDynamicObject createIntlObject() {
        JSObject intlObject = JSIntl.create(this);
        JSFunctionObject collatorFn = this.getCollatorConstructor();
        JSFunctionObject numberFormatFn = this.getNumberFormatConstructor();
        JSFunctionObject dateTimeFormatFn = this.getDateTimeFormatConstructor();
        JSFunctionObject pluralRulesFn = this.getPluralRulesConstructor();
        JSFunctionObject listFormatFn = this.getListFormatConstructor();
        JSFunctionObject relativeTimeFormatFn = this.getRelativeTimeFormatConstructor();
        JSFunctionObject segmenterFn = this.getSegmenterConstructor();
        JSFunctionObject displayNamesFn = this.getDisplayNamesConstructor();
        JSFunctionObject localeFn = this.getLocaleConstructor();
        JSFunctionObject durationFormatFn = this.getDurationFormatConstructor();
        JSObjectUtil.putDataProperty(intlObject, JSFunction.getName(collatorFn), (Object)collatorFn, JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty(intlObject, JSFunction.getName(numberFormatFn), (Object)numberFormatFn, JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty(intlObject, JSFunction.getName(dateTimeFormatFn), (Object)dateTimeFormatFn, JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty(intlObject, JSFunction.getName(pluralRulesFn), (Object)pluralRulesFn, JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty(intlObject, JSFunction.getName(listFormatFn), (Object)listFormatFn, JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty(intlObject, JSFunction.getName(relativeTimeFormatFn), (Object)relativeTimeFormatFn, JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty(intlObject, JSFunction.getName(segmenterFn), (Object)segmenterFn, JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty(intlObject, JSFunction.getName(displayNamesFn), (Object)displayNamesFn, JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty(intlObject, JSFunction.getName(localeFn), (Object)localeFn, JSAttributes.getDefaultNotEnumerable());
        if (this.getContextOptions().getEcmaScriptVersion() >= 16) {
            JSObjectUtil.putDataProperty(intlObject, JSFunction.getName(durationFormatFn), (Object)durationFormatFn, JSAttributes.getDefaultNotEnumerable());
        }
        return intlObject;
    }

    private void putGraalObject() {
        JSObject graalObject = JSOrdinary.createInit(this);
        int flags = JSAttributes.notConfigurableEnumerableNotWritable();
        JSContextOptions options = this.getContextOptions();
        int esVersion = options.getEcmaScriptVersion();
        esVersion = esVersion > 6 ? esVersion + 2009 : esVersion;
        JSObjectUtil.putDataProperty(graalObject, Strings.LANGUAGE, Strings.fromJavaString("JavaScript"), flags);
        assert (GRAALVM_VERSION != null);
        JSObjectUtil.putDataProperty(graalObject, Strings.VERSION_GRAAL_VM, GRAALVM_VERSION, flags);
        JSObjectUtil.putDataProperty(graalObject, Strings.VERSION_ECMA_SCRIPT, esVersion, flags);
        JSObjectUtil.putDataProperty(graalObject, Strings.IS_GRAAL_RUNTIME, (Object)JSFunction.create(this, JSRealm.isGraalRuntimeFunction(this.context)), flags);
        if (options.getUnhandledRejectionsMode() == JSContextOptions.UnhandledRejectionsTrackingMode.HANDLER) {
            JSFunctionObject registerFunction = JSFunction.create(this, JSRealm.setUnhandledPromiseRejectionHandlerFunction(this.context));
            JSObjectUtil.putDataProperty(graalObject, Strings.SET_UNHANDLED_PROMISE_REJECTION_HANDLER, (Object)registerFunction, flags);
        }
        this.putGlobalProperty(Strings.GRAAL, (Object)graalObject);
    }

    private static JSFunctionData setUnhandledPromiseRejectionHandlerFunction(JSContext context) {
        return context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.SetUnhandledPromiseRejectionHandler, c -> JSFunctionData.createCallOnly(c, (CallTarget)new JavaScriptRootNode(c.getLanguage(), null, null){

            public Object execute(VirtualFrame frame) {
                Object[] args = frame.getArguments();
                Object handler = null;
                if (JSArguments.getUserArgumentCount(args) > 0) {
                    Object arg = JSArguments.getUserArgument(args, 0);
                    if (JSRuntime.isCallable(arg)) {
                        handler = arg;
                    } else if (!JSRuntime.isNullOrUndefined(arg)) {
                        throw Errors.createTypeError("Value provided for the unhandled promise rejection handler is not callable");
                    }
                }
                this.getRealm().unhandledPromiseRejectionHandler = handler;
                return Undefined.instance;
            }
        }.getCallTarget(), 0, Strings.SET_UNHANDLED_PROMISE_REJECTION_HANDLER));
    }

    private static JSFunctionData isGraalRuntimeFunction(JSContext context) {
        return context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.IsGraalRuntime, c -> JSFunctionData.createCallOnly(context, (CallTarget)new JavaScriptRootNode(context.getLanguage(), null, null){

            public Object execute(VirtualFrame frame) {
                return this.isGraalRuntime();
            }

            @CompilerDirectives.TruffleBoundary
            private boolean isGraalRuntime() {
                return Truffle.getRuntime().getName().contains("Graal");
            }
        }.getCallTarget(), 0, Strings.IS_GRAAL_RUNTIME));
    }

    private void putGlobalProperty(TruffleString key, Object value) {
        this.putGlobalProperty(key, value, JSAttributes.getDefaultNotEnumerable());
    }

    private void putGlobalProperty(Object key, Object value, int attributes) {
        JSObjectUtil.putDataProperty(this.getGlobalObject(), key, value, attributes);
    }

    private static void putProperty(JSDynamicObject receiver, Object key, Object value) {
        JSObjectUtil.putDataProperty(receiver, key, value, JSAttributes.getDefaultNotEnumerable());
    }

    private static void setupPredefinedSymbols(JSDynamicObject symbolFunction) {
        JSRealm.putSymbolProperty(symbolFunction, Strings.HAS_INSTANCE, Symbol.SYMBOL_HAS_INSTANCE);
        JSRealm.putSymbolProperty(symbolFunction, Strings.IS_CONCAT_SPREADABLE, Symbol.SYMBOL_IS_CONCAT_SPREADABLE);
        JSRealm.putSymbolProperty(symbolFunction, Strings.ITERATOR, Symbol.SYMBOL_ITERATOR);
        JSRealm.putSymbolProperty(symbolFunction, Strings.ASYNC_ITERATOR, Symbol.SYMBOL_ASYNC_ITERATOR);
        JSRealm.putSymbolProperty(symbolFunction, Strings.MATCH, Symbol.SYMBOL_MATCH);
        JSRealm.putSymbolProperty(symbolFunction, Strings.MATCH_ALL, Symbol.SYMBOL_MATCH_ALL);
        JSRealm.putSymbolProperty(symbolFunction, Strings.REPLACE, Symbol.SYMBOL_REPLACE);
        JSRealm.putSymbolProperty(symbolFunction, Strings.SEARCH, Symbol.SYMBOL_SEARCH);
        JSRealm.putSymbolProperty(symbolFunction, Strings.SPECIES, Symbol.SYMBOL_SPECIES);
        JSRealm.putSymbolProperty(symbolFunction, Strings.SPLIT, Symbol.SYMBOL_SPLIT);
        JSRealm.putSymbolProperty(symbolFunction, Strings.TO_STRING_TAG, Symbol.SYMBOL_TO_STRING_TAG);
        JSRealm.putSymbolProperty(symbolFunction, Strings.TO_PRIMITIVE, Symbol.SYMBOL_TO_PRIMITIVE);
        JSRealm.putSymbolProperty(symbolFunction, Strings.UNSCOPABLES, Symbol.SYMBOL_UNSCOPABLES);
    }

    private static void putSymbolProperty(JSDynamicObject symbolFunction, TruffleString name, Symbol symbol) {
        Properties.putConstantUncached(symbolFunction, name, symbol, JSAttributes.notConfigurableNotEnumerableNotWritable());
    }

    public boolean isJavaInteropEnabled() {
        return this.getEnv() != null && this.getEnv().isHostLookupAllowed();
    }

    private void setupJavaInterop() {
        assert (this.isJavaInteropEnabled());
        JSObject java = JSObjectUtil.createOrdinaryPrototypeObject(this);
        JSObjectUtil.putToStringTag(java, JAVA_CLASS_NAME);
        JSObjectUtil.putFunctionsFromContainer(this, java, JavaBuiltins.BUILTINS);
        if (this.context.isOptionNashornCompatibilityMode()) {
            JSObjectUtil.putFunctionsFromContainer(this, java, JavaBuiltins.BUILTINS_NASHORN_COMPAT);
        }
        this.putGlobalProperty(JAVA_CLASS_NAME, (Object)java);
        if (this.getEnv() != null && this.getEnv().isHostLookupAllowed() && ((Boolean)JSContextOptions.JAVA_PACKAGE_GLOBALS.getValue(this.getEnv().getOptions())).booleanValue()) {
            this.javaPackageToPrimitiveFunction = JavaPackage.createToPrimitiveFunction(this.context, this);
            this.putGlobalProperty(Strings.UC_PACKAGES, (Object)JavaPackage.createInit(this, Strings.EMPTY_STRING));
            this.putGlobalProperty(Strings.JAVA, (Object)JavaPackage.createInit(this, Strings.JAVA));
            this.putGlobalProperty(Strings.JAVAFX, (Object)JavaPackage.createInit(this, Strings.JAVAFX));
            this.putGlobalProperty(Strings.JAVAX, (Object)JavaPackage.createInit(this, Strings.JAVAX));
            this.putGlobalProperty(Strings.COM, (Object)JavaPackage.createInit(this, Strings.COM));
            this.putGlobalProperty(Strings.ORG, (Object)JavaPackage.createInit(this, Strings.ORG));
            this.putGlobalProperty(Strings.EDU, (Object)JavaPackage.createInit(this, Strings.EDU));
            if (this.context.isOptionNashornCompatibilityMode()) {
                this.putGlobalProperty(JavaImporter.CLASS_NAME, (Object)this.getJavaImporterConstructor());
            }
        }
    }

    private void setupPolyglot() {
        JSObject polyglotObject = JSObjectUtil.createOrdinaryPrototypeObject(this);
        JSObjectUtil.putFunctionsFromContainer(this, polyglotObject, PolyglotBuiltins.BUILTINS);
        if (this.getContextOptions().isPolyglotEvalFile()) {
            JSObjectUtil.putDataProperty(polyglotObject, Strings.EVAL_FILE, (Object)this.lookupFunction(PolyglotBuiltins.BUILTINS, Strings.EVAL_FILE), JSAttributes.getDefaultNotEnumerable());
        }
        if (this.getContextOptions().isDebugBuiltin()) {
            JSObjectUtil.putFunctionsFromContainer(this, polyglotObject, PolyglotInternalBuiltins.BUILTINS);
        }
        this.putGlobalProperty(POLYGLOT_CLASS_NAME, (Object)polyglotObject);
    }

    private void addConsoleGlobals() {
        if (this.getContextOptions().isConsole()) {
            this.putGlobalProperty(Strings.CONSOLE, (Object)(this.preinitConsoleBuiltinObject != null ? this.preinitConsoleBuiltinObject : this.createConsoleObject()));
        }
    }

    private JSDynamicObject createConsoleObject() {
        JSObject console = JSOrdinary.createInit(this);
        JSObjectUtil.putFunctionsFromContainer(this, console, ConsoleBuiltins.BUILTINS);
        return console;
    }

    private JSDynamicObject createPerformanceObject() {
        JSObject obj = JSOrdinary.createInit(this);
        JSObjectUtil.putFunctionsFromContainer(this, obj, PerformanceBuiltins.BUILTINS);
        return obj;
    }

    private JSDynamicObject createIteratorPrototype() {
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(this, this.getObjectPrototype());
        JSObjectUtil.putDataProperty(prototype, Symbol.SYMBOL_ITERATOR, (Object)JSRealm.createIteratorPrototypeSymbolIteratorFunction(this), JSAttributes.getDefaultNotEnumerable());
        return prototype;
    }

    private static JSDynamicObject createIteratorPrototypeSymbolIteratorFunction(JSRealm realm) {
        return JSFunction.create(realm, realm.getContext().getSymbolIteratorThisGetterFunctionData());
    }

    private JSDynamicObject createIteratorHelperPrototype() {
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(this, this.iteratorPrototype);
        JSObjectUtil.putFunctionsFromContainer(this, prototype, IteratorHelperPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(prototype, IteratorHelperPrototypeBuiltins.TO_STRING_TAG);
        return prototype;
    }

    private JSDynamicObject createAsyncIteratorHelperPrototype() {
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(this, this.asyncIteratorPrototype);
        JSObjectUtil.putFunctionsFromContainer(this, prototype, AsyncIteratorHelperPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(prototype, AsyncIteratorHelperPrototypeBuiltins.TO_STRING_TAG);
        return prototype;
    }

    private JSDynamicObject createRegExpStringIteratorPrototype() {
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(this, this.iteratorPrototype);
        JSObjectUtil.putFunctionsFromContainer(this, prototype, RegExpStringIteratorPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(prototype, JSString.REGEXP_ITERATOR_CLASS_NAME);
        return prototype;
    }

    private JSDynamicObject createForeignIterablePrototype() {
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(this);
        JSObjectUtil.putFunctionsFromContainer(this, prototype, ForeignIterablePrototypeBuiltins.BUILTINS);
        return prototype;
    }

    private JSDynamicObject createForeignIteratorPrototype() {
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(this, this.iteratorPrototype);
        JSObjectUtil.putFunctionsFromContainer(this, prototype, ForeignIteratorPrototypeBuiltins.BUILTINS);
        return prototype;
    }

    private JSConstructor createAbstractModuleSourcePrototype() {
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(this);
        JSFunctionObject constructor = this.lookupFunction(ConstructorBuiltins.BUILTINS, ConstructorBuiltins.Constructor.AbstractModuleSource.getKey());
        JSObjectUtil.putConstructorPrototypeProperty(constructor, prototype);
        JSObjectUtil.putConstructorProperty(prototype, constructor);
        JSObjectUtil.putAccessorsFromContainer(this, prototype, AbstractModuleSourcePrototype.BUILTINS);
        return new JSConstructor(constructor, prototype);
    }

    public JSFunctionObject getAbstractModuleSourceConstructor() {
        return this.abstractModuleSourceConstructor;
    }

    public JSDynamicObject getAbstractModuleSourcePrototype() {
        return this.abstractModuleSourcePrototype;
    }

    public JSDynamicObject getArrayProtoValuesIterator() {
        return this.arrayProtoValuesIterator;
    }

    private JSDynamicObject createReflect() {
        JSObject obj = JSObjectUtil.createOrdinaryPrototypeObject(this, this.getObjectPrototype());
        JSObjectUtil.putToStringTag(obj, REFLECT_CLASS_NAME);
        JSObjectUtil.putFunctionsFromContainer(this, obj, ReflectBuiltins.BUILTINS);
        return obj;
    }

    private JSDynamicObject createAtomics() {
        JSObject obj = JSObjectUtil.createOrdinaryPrototypeObject(this, this.getObjectPrototype());
        JSObjectUtil.putToStringTag(obj, ATOMICS_CLASS_NAME);
        JSObjectUtil.putFunctionsFromContainer(this, obj, AtomicsBuiltins.BUILTINS);
        if (this.getContextOptions().isAtomicsWaitAsync()) {
            JSObjectUtil.putFunctionFromContainer(this, obj, AtomicsBuiltins.BUILTINS, AtomicsBuiltins.Atomics.waitAsync.getKey());
        }
        return obj;
    }

    public final JSFunctionObject getCallSiteConstructor() {
        return this.callSiteConstructor;
    }

    public final JSDynamicObject getCallSitePrototype() {
        return this.callSitePrototype;
    }

    public final JSDynamicObject getGlobalScope() {
        return this.globalScope;
    }

    public JSDynamicObject getScriptEngineImportScope() {
        return this.scriptEngineImportScope;
    }

    public Object getTopScopeObject() {
        return this.topScope;
    }

    private void addScriptingGlobals() {
        CompilerAsserts.neverPartOfCompilation();
        if (this.getContext().getParserOptions().scripting()) {
            String timezone = this.getLocalTimeZoneId().getId();
            JSObject timezoneObj = JSOrdinary.create(this.context, this);
            JSObjectUtil.putDataProperty(timezoneObj, Strings.CAPS_ID, Strings.fromJavaString(timezone), JSAttributes.configurableEnumerableWritable());
            JSObject optionsObj = JSOrdinary.create(this.context, this);
            JSObjectUtil.putDataProperty(optionsObj, Strings._TIMEZONE, (Object)timezoneObj, JSAttributes.configurableEnumerableWritable());
            JSObjectUtil.putDataProperty(optionsObj, Strings._SCRIPTING, true, JSAttributes.configurableEnumerableWritable());
            JSObjectUtil.putDataProperty(optionsObj, Strings._COMPILE_ONLY, false, JSAttributes.configurableEnumerableWritable());
            this.putGlobalProperty(Strings.$_OPTIONS, (Object)optionsObj, JSAttributes.configurableNotEnumerableWritable());
            JSArrayObject arguments = JSArray.createConstant(this.context, this, Strings.fromJavaStringArray(this.getEnv().getApplicationArguments()));
            this.putGlobalProperty(Strings.$_ARG, arguments, JSAttributes.configurableNotEnumerableWritable());
            JSObject envObj = JSOrdinary.create(this.context, this);
            Map sysenv = this.getEnv().getEnvironment();
            for (Map.Entry entry : sysenv.entrySet()) {
                JSObjectUtil.defineDataProperty(this.context, envObj, Strings.fromJavaString((String)entry.getKey()), Strings.fromJavaString((String)entry.getValue()), JSAttributes.configurableEnumerableWritable());
            }
            this.putGlobalProperty(Strings.DOLLAR_ENV, (Object)envObj, JSAttributes.configurableNotEnumerableWritable());
            this.putGlobalProperty(Strings.$_EXEC, (Object)this.lookupFunction(GlobalBuiltins.GLOBAL_NASHORN_EXTENSIONS, Strings.EXEC));
            this.putGlobalProperty(Strings.READ_FULLY, (Object)this.lookupFunction(GlobalBuiltins.GLOBAL_NASHORN_EXTENSIONS, Strings.READ_FULLY));
            this.putGlobalProperty(Strings.READ_LINE, (Object)this.lookupFunction(GlobalBuiltins.GLOBAL_NASHORN_EXTENSIONS, Strings.READ_LINE));
            this.putGlobalProperty(Strings.$_EXIT, (Object)Undefined.instance);
            this.putGlobalProperty(Strings.$_OUT, (Object)Undefined.instance);
            this.putGlobalProperty(Strings.$_ERR, (Object)Undefined.instance);
        }
    }

    public void setRealmBuiltinObject(JSDynamicObject realmBuiltinObject) {
        if (this.realmBuiltinObject == null && realmBuiltinObject != null) {
            this.realmBuiltinObject = realmBuiltinObject;
            this.putGlobalProperty(REALM_BUILTIN_CLASS_NAME, (Object)realmBuiltinObject);
        }
    }

    public void initRealmBuiltinObject() {
        assert (this.getContextOptions().isV8RealmBuiltin());
        this.setRealmBuiltinObject(this.createRealmBuiltinObject());
    }

    private JSObject createRealmBuiltinObject() {
        JSObject obj = JSOrdinary.createInit(this);
        JSObjectUtil.putToStringTag(obj, REALM_BUILTIN_CLASS_NAME);
        JSObjectUtil.putProxyProperty(obj, REALM_SHARED_NAME, REALM_SHARED_PROXY, JSAttributes.getDefault());
        JSObjectUtil.putFunctionsFromContainer(this, obj, RealmFunctionBuiltins.BUILTINS);
        return obj;
    }

    private JSObject createDebugObject() {
        JSObject obj = JSOrdinary.createInit(this);
        JSObjectUtil.putToStringTag(obj, DEBUG_CLASS_NAME);
        JSObjectUtil.putFunctionsFromContainer(this, obj, DebugBuiltins.BUILTINS);
        return obj;
    }

    private JSObject createMleObject() {
        JSObject obj = JSOrdinary.createInit(this);
        JSObjectUtil.putToStringTag(obj, MLE_CLASS_NAME);
        JSObjectUtil.putFunctionsFromContainer(this, obj, MLEBuiltins.BUILTINS);
        return obj;
    }

    private void addStaticRegexResultProperties() {
        if (this.context.isOptionRegexpStaticResult()) {
            if (this.context.isOptionNashornCompatibilityMode()) {
                this.putRegExpStaticPropertyAccessor(null, Strings.INPUT);
                this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExpMultiLine, JSRegExp.MULTILINE);
                this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExpLastMatch, JSRegExp.LAST_MATCH);
                this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExpLastParen, JSRegExp.LAST_PAREN);
                this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExpLeftContext, JSRegExp.LEFT_CONTEXT);
                this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExpRightContext, JSRegExp.RIGHT_CONTEXT);
            } else {
                this.putRegExpStaticPropertyAccessor(null, Strings.INPUT);
                this.putRegExpStaticPropertyAccessor(null, Strings.INPUT, JSRegExp.$_);
                this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExpLastMatch, JSRegExp.LAST_MATCH);
                this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExpLastMatch, JSRegExp.LAST_MATCH, JSRegExp.$_AMPERSAND);
                this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExpLastParen, JSRegExp.LAST_PAREN);
                this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExpLastParen, JSRegExp.LAST_PAREN, JSRegExp.$_PLUS);
                this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExpLeftContext, JSRegExp.LEFT_CONTEXT);
                this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExpLeftContext, JSRegExp.LEFT_CONTEXT, JSRegExp.$_BACKTICK);
                this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExpRightContext, JSRegExp.RIGHT_CONTEXT);
                this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExpRightContext, JSRegExp.RIGHT_CONTEXT, JSRegExp.$_SQUOT);
            }
            this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExp$1, JSRegExp.$_1);
            this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExp$2, JSRegExp.$_2);
            this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExp$3, JSRegExp.$_3);
            this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExp$4, JSRegExp.$_4);
            this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExp$5, JSRegExp.$_5);
            this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExp$6, JSRegExp.$_6);
            this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExp$7, JSRegExp.$_7);
            this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExp$8, JSRegExp.$_8);
            this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExp$9, JSRegExp.$_9);
        }
    }

    private void putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey builtinKey, TruffleString getterName) {
        this.putRegExpStaticPropertyAccessor(builtinKey, getterName, getterName);
    }

    private void putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey builtinKey, TruffleString getterName, TruffleString propertyName) {
        JSDynamicObject setter;
        Pair<JSBuiltin, JSBuiltin> pair = RegExpBuiltins.BUILTINS.lookupAccessorByKey(getterName);
        JSBuiltin getterBuiltin = (JSBuiltin)pair.getLeft();
        JSFunctionObject getter = JSFunction.create(this, getterBuiltin.createFunctionData(this.context));
        JSBuiltin setterBuiltin = (JSBuiltin)pair.getRight();
        if (setterBuiltin != null) {
            assert (Strings.equals(propertyName, Strings.INPUT) || Strings.equals(propertyName, JSRegExp.$_));
            setter = JSFunction.create(this, setterBuiltin.createFunctionData(this.context));
        } else if (this.context.isOptionV8CompatibilityMode()) {
            TruffleString setterName = Strings.concat(Strings.SET_SPC, getterName);
            JSFunctionData setterData = this.context.getOrCreateBuiltinFunctionData(builtinKey, c -> JSFunctionData.createCallOnly(c, this.context.getEmptyFunctionCallTarget(), 1, setterName));
            setter = JSFunction.create(this, setterData);
        } else {
            setter = Undefined.instance;
        }
        int propertyAttributes = this.context.isOptionNashornCompatibilityMode() ? JSAttributes.notConfigurableEnumerableWritable() : JSAttributes.configurableNotEnumerableWritable();
        JSObjectUtil.putBuiltinAccessorProperty(this.regExpConstructor, propertyName, getter, setter, propertyAttributes);
    }

    public void setArguments(TruffleString[] arguments) {
        JSObjectUtil.defineDataProperty(this.context, this.getGlobalObject(), ARGUMENTS_NAME, JSArray.createConstant(this.context, this, arguments), this.context.isOptionV8CompatibilityMode() ? JSAttributes.getDefault() : JSAttributes.getDefaultNotEnumerable());
    }

    public final JSDynamicObject getOrdinaryHasInstanceFunction() {
        return this.ordinaryHasInstanceFunction;
    }

    public final JSFunctionObject getJSAdapterConstructor() {
        return this.jsAdapterConstructor;
    }

    public final JSDynamicObject getJSAdapterPrototype() {
        return this.jsAdapterPrototype;
    }

    public final TruffleLanguage.Env getEnv() {
        return this.truffleLanguageEnv;
    }

    public boolean patchContext(TruffleLanguage.Env newEnv) {
        CompilerAsserts.neverPartOfCompilation();
        Objects.requireNonNull(newEnv, "New env cannot be null.");
        this.truffleLanguageEnv = newEnv;
        this.getContext().setAllocationReporter(newEnv);
        this.getContextOptions().setOptionValues(newEnv.getSandboxPolicy(), newEnv.getOptions());
        this.getContext().updateStableOptions(this.contextOptions, StableContextOptionValue.UpdateKind.PATCH);
        this.setOutputStreamsFromEnv(newEnv);
        this.addOptionalGlobals();
        this.addArgumentsFromEnv(newEnv);
        if (this.localTimeZoneId != null) {
            this.localTimeZoneId = this.getTimeZoneFromEnv();
        }
        this.initTimeOffsetAndRandom();
        this.addStaticRegexResultProperties();
        this.getContext().resetSymbolUsageMarker();
        return true;
    }

    public void initialize() {
        CompilerAsserts.neverPartOfCompilation();
        if (this.getEnv().isPreInitialization()) {
            this.preinitializeObjects();
            return;
        }
        this.setOutputStreamsFromEnv(this.getEnv());
        this.addOptionalGlobals();
        this.addArgumentsFromEnv(this.getEnv());
        this.initTimeOffsetAndRandom();
        this.addStaticRegexResultProperties();
    }

    private void setOutputStreamsFromEnv(TruffleLanguage.Env newEnv) {
        if (newEnv.out() != this.outputWriter.getDelegate()) {
            this.setOutputWriter(newEnv.out());
        }
        if (newEnv.err() != this.errorWriter.getDelegate()) {
            this.setErrorWriter(newEnv.err());
        }
    }

    private void preinitializeObjects() {
        this.preinitIntlObject = this.createIntlObject();
        this.preinitConsoleBuiltinObject = this.createConsoleObject();
        this.preinitPerformanceObject = this.createPerformanceObject();
    }

    private void addArgumentsFromEnv(TruffleLanguage.Env newEnv) {
        String[] applicationArguments = newEnv.getApplicationArguments();
        if (this.getContextOptions().isGlobalArguments()) {
            TruffleString[] args = new TruffleString[applicationArguments.length];
            for (int i = 0; i < args.length; ++i) {
                args[i] = Strings.fromJavaString(applicationArguments[i]);
            }
            this.setArguments(args);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public JSRealm createChildRealm() {
        JSRealm childRealm = this.context.createRealm(this.getEnv(), this);
        childRealm.initialize();
        return childRealm;
    }

    public boolean isPreparingStackTrace() {
        return this.preparingStackTrace;
    }

    public void setPreparingStackTrace(boolean preparingStackTrace) {
        this.preparingStackTrace = preparingStackTrace;
    }

    public final TruffleContext getTruffleContext() {
        return this.getEnv().getContext();
    }

    public final Object getEmbedderData() {
        return this.embedderData;
    }

    public final void setEmbedderData(Object embedderData) {
        this.embedderData = embedderData;
    }

    public Object getStaticRegexResult(JSContext ctx, Node node, TRegexUtil.InvokeExecMethodNode invokeExec) {
        CompilerAsserts.partialEvaluationConstant((Object)ctx);
        assert (ctx.isOptionRegexpStaticResult());
        if (this.staticRegexResultCompiledRegex != null && ctx.getRegExpStaticResultUnusedAssumption().isValid()) {
            ctx.getRegExpStaticResultUnusedAssumption().invalidate();
            this.staticRegexResult = TRegexUtil.TRegexCompiledRegexAccessor.exec(this.staticRegexResultCompiledRegex, this.staticRegexResultOriginalInputString, this.staticRegexResultFromIndex, node, invokeExec);
        }
        if (this.staticRegexResult == null) {
            this.staticRegexResult = ctx.getTRegexEmptyResult();
        }
        return this.staticRegexResult;
    }

    public void setStaticRegexResult(JSContext ctx, Object compiledRegex, TruffleString input, long fromIndex, Object result) {
        CompilerAsserts.partialEvaluationConstant((Object)ctx);
        assert (ctx.isOptionRegexpStaticResult());
        this.staticRegexResultInvalidated = false;
        this.staticRegexResultCompiledRegex = compiledRegex;
        this.staticRegexResultInputString = input;
        this.staticRegexResultOriginalInputString = input;
        if (ctx.getRegExpStaticResultUnusedAssumption().isValid()) {
            this.staticRegexResultFromIndex = fromIndex;
        } else {
            assert (TRegexUtil.InteropReadBooleanMemberNode.getUncached().execute(null, result, "isMatch"));
            this.staticRegexResult = result;
        }
    }

    public void invalidateStaticRegexResult() {
        this.staticRegexResultInvalidated = true;
    }

    public boolean isRegexResultInvalidated() {
        return this.staticRegexResultInvalidated;
    }

    public Object getStaticRegexResultCompiledRegex() {
        return this.staticRegexResultCompiledRegex;
    }

    public TruffleString getStaticRegexResultInputString() {
        return this.staticRegexResultInputString;
    }

    public void setStaticRegexResultInputString(TruffleString inputString) {
        this.staticRegexResultInputString = inputString;
    }

    public TruffleString getStaticRegexResultOriginalInputString() {
        return this.staticRegexResultOriginalInputString;
    }

    public OptionValues getOptions() {
        return this.getEnv().getOptions();
    }

    public final PrintWriter getOutputWriter() {
        return this.outputWriter;
    }

    public final PrintWriter getErrorWriter() {
        return this.errorWriter;
    }

    private void setOutputWriter(OutputStream stream) {
        this.outputWriter.setDelegate(stream);
    }

    private void setErrorWriter(OutputStream stream) {
        this.errorWriter.setDelegate(stream);
    }

    public long nanoTime() {
        long ns = System.nanoTime() + this.nanoToZeroTimeOffset;
        return this.updateResolution(ns);
    }

    public long nanoTimeWallClock() {
        Instant instant = Instant.now();
        long ns = instant.getEpochSecond() * 1000000000L + (long)instant.getNano();
        return this.updateResolution(ns);
    }

    private long updateResolution(long nanos) {
        long last;
        long ns = nanos;
        long resolution = this.getContext().getTimerResolution();
        if (resolution > 0L) {
            return Math.floorDiv(ns, resolution) * resolution;
        }
        long fuzz = this.random.nextLong(1000000L) + 1L;
        if ((ns -= ns % fuzz) > (last = this.lastFuzzyTime)) {
            this.lastFuzzyTime = ns;
            return ns;
        }
        return last;
    }

    @CompilerDirectives.TruffleBoundary
    public long currentTimeMillis() {
        return Math.floorDiv(this.nanoTimeWallClock(), 1000000L);
    }

    public JSConsoleUtil getConsoleUtil() {
        return this.consoleUtil;
    }

    public JSModuleLoader getModuleLoader() {
        if (this.moduleLoader == null) {
            this.createModuleLoader();
        }
        return this.moduleLoader;
    }

    @CompilerDirectives.TruffleBoundary
    private synchronized void createModuleLoader() {
        if (this.moduleLoader == null) {
            this.moduleLoader = this.getContextOptions().isCommonJSRequire() ? NpmCompatibleESModuleLoader.create(this) : DefaultESModuleLoader.create(this);
        }
    }

    public final JSAgent getAgent() {
        assert (this.agent != null);
        return this.agent;
    }

    public void setAgent(JSAgent newAgent) {
        CompilerAsserts.neverPartOfCompilation((String)"Assigning agent to context in compiled code");
        this.agent = Objects.requireNonNull(newAgent, "agent");
    }

    public TimeZone getLocalTimeZone() {
        TimeZone timeZone = this.localTimeZone;
        if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (timeZone == null ? 1 : 0) != 0)) {
            timeZone = this.getICUTimeZoneFromEnv();
        }
        return timeZone;
    }

    @CompilerDirectives.TruffleBoundary
    private TimeZone getICUTimeZoneFromEnv() {
        return IntlUtil.getICUTimeZone(this.getLocalTimeZoneId(), this.getContext());
    }

    public ZoneId getLocalTimeZoneId() {
        ZoneId id = this.localTimeZoneId;
        if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (id == null ? 1 : 0) != 0)) {
            this.localTimeZoneId = id = this.getTimeZoneFromEnv();
        }
        return id;
    }

    @CompilerDirectives.TruffleBoundary
    private ZoneId getTimeZoneFromEnv() {
        OptionValues options = this.getEnv().getOptions();
        String zoneId = (String)JSContextOptions.TIME_ZONE.getValue(options);
        if (!zoneId.isEmpty()) {
            try {
                return ZoneId.of(zoneId);
            }
            catch (DateTimeException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }
        return this.getEnv().getTimeZone();
    }

    private void initTimeOffsetAndRandom() {
        assert (!this.getEnv().isPreInitialization());
        this.random = new SplittableRandom();
        this.nanoToZeroTimeOffset = -System.nanoTime();
        this.lastFuzzyTime = Long.MIN_VALUE;
    }

    public final SplittableRandom getRandom() {
        return this.random;
    }

    public JSRealm getParent() {
        return this.parentRealm;
    }

    public boolean isMainRealm() {
        return this.getParent() == null;
    }

    public JavaScriptBaseNode getCallNode() {
        return this.callNode;
    }

    public void setCallNode(JavaScriptBaseNode callNode) {
        this.callNode = callNode;
    }

    void initRealmList() {
        CompilerAsserts.neverPartOfCompilation();
        assert (this.isMainRealm());
        this.realmList = new ArrayList<JSRealm>();
    }

    void addToRealmList(JSRealm newRealm) {
        CompilerAsserts.neverPartOfCompilation();
        assert (this.isMainRealm());
        assert (!this.realmList.contains(newRealm));
        this.realmList.add(newRealm);
    }

    public JSRealm getFromRealmList(int idx) {
        CompilerAsserts.neverPartOfCompilation();
        assert (this.isMainRealm());
        return 0 <= idx && idx < this.realmList.size() ? this.realmList.get(idx) : null;
    }

    public void setInRealmList(int idx, JSRealm realm) {
        CompilerAsserts.neverPartOfCompilation();
        assert (this.isMainRealm());
        this.realmList.set(idx, realm);
    }

    public int getIndexFromRealmList(JSRealm rlm) {
        CompilerAsserts.neverPartOfCompilation();
        assert (this.isMainRealm());
        return this.realmList.indexOf(rlm);
    }

    public void removeFromRealmList(int idx) {
        CompilerAsserts.neverPartOfCompilation();
        assert (this.isMainRealm());
        this.realmList.set(idx, null);
    }

    public JSRealm getCurrentV8Realm() {
        assert (this.isMainRealm());
        return this.v8RealmCurrent;
    }

    public void setCurrentV8Realm(JSRealm realm) {
        assert (this.isMainRealm());
        this.v8RealmCurrent = realm;
    }

    public void registerCustomEsmPathMappingCallback(Object callback) {
        assert (this.context.isOptionMleBuiltin());
        assert (JSRuntime.isCallableForeign(callback));
        this.customEsmPathMappingCallback = callback;
    }

    public TruffleString getCustomEsmPathMapping(TruffleString refPath, TruffleString specifier) {
        CompilerAsserts.neverPartOfCompilation();
        if (this.getContext().isOptionMleBuiltin() && this.customEsmPathMappingCallback != null) {
            Object[] args = new Object[]{JSRuntime.toJSNull(refPath), specifier};
            Object custom = JSInteropUtil.call(this.customEsmPathMappingCallback, args);
            InteropLibrary interopLibrary = InteropLibrary.getUncached();
            if (interopLibrary.isString(custom)) {
                return Strings.interopAsTruffleString(custom);
            }
            throw Errors.createError("Cannot load ES module: " + String.valueOf(specifier));
        }
        return null;
    }

    public boolean joinStackPush(Object o, Node node, InlinedBranchProfile growProfile) {
        InteropLibrary interop = o instanceof JSObject ? null : (InteropLibrary)InteropLibrary.getFactory().getUncached(o);
        for (int i = 0; i < this.joinStack.size(); ++i) {
            Object element = this.joinStack.get(i);
            if (!(interop == null ? o == element : interop.isIdentical(o, element, (InteropLibrary)InteropLibrary.getFactory().getUncached(element)))) continue;
            return false;
        }
        this.joinStack.add(o, node, growProfile);
        return true;
    }

    public void joinStackPop() {
        this.joinStack.pop();
    }

    public final Map<TruffleFile, JSDynamicObject> getCommonJSRequireCache() {
        assert (this.getContextOptions().isCommonJSRequire());
        return this.commonJSRequireCache;
    }

    private LanguageInfo ensureWasmLanguageAvailable() {
        LanguageInfo wasmLanguageInfo = (LanguageInfo)this.truffleLanguageEnv.getInternalLanguages().get("wasm");
        if (wasmLanguageInfo == null || !this.truffleLanguageEnv.isPolyglotBindingsAccessAllowed()) {
            throw new IllegalStateException("WebAssembly API enabled but \"wasm\" language cannot be accessed! Make sure the \"wasm\" language is found on the module path and one of the permitted languages when creating the Context, and that both polyglot eval and bindings access are allowed for \"js\" and \"wasm\" using `contextBuilder.allowPolyglotAccess(PolyglotAccess.ALL)` or more restricted PolyglotAccess.");
        }
        return wasmLanguageInfo;
    }

    public Object getWASMModuleInstantiate() {
        return this.wasmModuleInstantiate;
    }

    public Object getWASMModuleExports() {
        return this.wasmModuleExports;
    }

    public Object getWASMModuleImports() {
        return this.wasmModuleImports;
    }

    public Object getWASMCustomSections() {
        return this.wasmCustomSections;
    }

    public Object getWASMTableAlloc() {
        return this.wasmTableAlloc;
    }

    public Object getWASMTableGrow() {
        return this.wasmTableGrow;
    }

    public Object getWASMTableRead() {
        return this.wasmTableRead;
    }

    public Object getWASMTableWrite() {
        return this.wasmTableWrite;
    }

    public Object getWASMTableLength() {
        return this.wasmTableLength;
    }

    public Object getWASMFuncType() {
        return this.wasmFuncType;
    }

    public Object getWASMIsFunc() {
        return this.wasmIsFunc;
    }

    public Object getWASMMemAlloc() {
        return this.wasmMemAlloc;
    }

    public Object getWASMMemGrow() {
        return this.wasmMemGrow;
    }

    public Object getWASMGlobalAlloc() {
        return this.wasmGlobalAlloc;
    }

    public Object getWASMGlobalRead() {
        return this.wasmGlobalRead;
    }

    public Object getWASMGlobalWrite() {
        return this.wasmGlobalWrite;
    }

    public Object getWASMInstanceExport() {
        return this.wasmInstanceExport;
    }

    public Object getWASMEmbedderDataGet() {
        return this.wasmEmbedderDataGet;
    }

    public Object getWASMEmbedderDataSet() {
        return this.wasmEmbedderDataSet;
    }

    public Object getWASMMemAsByteBuffer() {
        return this.wasmMemAsByteBuffer;
    }

    public Object getWasmRefNull() {
        return this.wasmRefNull;
    }

    public JSFunctionObject getWebAssemblyModuleConstructor() {
        return this.webAssemblyModuleConstructor;
    }

    public JSDynamicObject getWebAssemblyModulePrototype() {
        return this.webAssemblyModulePrototype;
    }

    public JSDynamicObject getWebAssemblyInstancePrototype() {
        return this.webAssemblyInstancePrototype;
    }

    public JSDynamicObject getWebAssemblyMemoryPrototype() {
        return this.webAssemblyMemoryPrototype;
    }

    public JSDynamicObject getWebAssemblyTablePrototype() {
        return this.webAssemblyTablePrototype;
    }

    public JSDynamicObject getWebAssemblyGlobalPrototype() {
        return this.webAssemblyGlobalPrototype;
    }

    public JSDynamicObject getTextDecoderPrototype() {
        return this.textDecoderPrototype;
    }

    public JSDynamicObject getTextEncoderPrototype() {
        return this.textEncoderPrototype;
    }

    public JSDynamicObject getForeignIterablePrototype() {
        return this.foreignIterablePrototype;
    }

    public JSDynamicObject getForeignIteratorPrototype() {
        return this.foreignIteratorPrototype;
    }

    public DateFormat getJSDateISOFormat(double time) {
        long milliseconds = (long)time;
        if (milliseconds < -62167219200000L) {
            if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (this.jsDateFormatBeforeYear0 == null ? 1 : 0) != 0)) {
                this.enterOncePerContextBranch();
                this.jsDateFormatBeforeYear0 = this.createDateFormat("uuuuuu-MM-dd'T'HH:mm:ss.SSS'Z'", false);
            }
            return this.jsDateFormatBeforeYear0;
        }
        if (milliseconds >= 253402300800000L) {
            if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (this.jsDateFormatAfterYear9999 == null ? 1 : 0) != 0)) {
                this.enterOncePerContextBranch();
                this.jsDateFormatAfterYear9999 = this.createDateFormat("+uuuuuu-MM-dd'T'HH:mm:ss.SSS'Z'", false);
            }
            return this.jsDateFormatAfterYear9999;
        }
        if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (this.jsDateFormat == null ? 1 : 0) != 0)) {
            this.enterOncePerContextBranch();
            this.jsDateFormat = this.createDateFormat("uuuu-MM-dd'T'HH:mm:ss.SSS'Z'", false);
        }
        return this.jsDateFormat;
    }

    public DateFormat getJSDateUTCFormat() {
        DateFormat dateFormat = this.jsDateFormatISO;
        if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (dateFormat == null ? 1 : 0) != 0)) {
            this.enterOncePerContextBranch();
            this.jsDateFormatISO = dateFormat = this.createDateFormat("EEE, dd MMM uuuu HH:mm:ss 'GMT'", false);
        }
        return dateFormat;
    }

    public DateFormat getJSShortDateFormat() {
        DateFormat dateFormat = this.jsShortDateFormat;
        if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (dateFormat == null ? 1 : 0) != 0)) {
            this.jsShortDateFormat = dateFormat = this.createDateFormat("EEE MMM dd uuuu", true);
        }
        return dateFormat;
    }

    public DateFormat getJSShortDateLocalFormat() {
        DateFormat dateFormat = this.jsShortDateLocalFormat;
        if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (dateFormat == null ? 1 : 0) != 0)) {
            this.jsShortDateLocalFormat = dateFormat = this.createDateFormat("uuuu-MM-dd", true);
        }
        return dateFormat;
    }

    public DateFormat getJSShortTimeFormat() {
        DateFormat dateFormat = this.jsShortTimeFormat;
        if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (dateFormat == null ? 1 : 0) != 0)) {
            this.jsShortTimeFormat = dateFormat = this.createDateFormat(this.appendTimeZoneNameFormat("HH:mm:ss 'GMT'xx"), true);
        }
        return dateFormat;
    }

    public DateFormat getJSShortTimeLocalFormat() {
        DateFormat dateFormat = this.jsShortTimeLocalFormat;
        if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (dateFormat == null ? 1 : 0) != 0)) {
            this.jsShortTimeLocalFormat = dateFormat = this.createDateFormat("HH:mm:ss", true);
        }
        return dateFormat;
    }

    public DateFormat getDateToStringFormat() {
        DateFormat dateFormat = this.jsDateToStringFormat;
        if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (dateFormat == null ? 1 : 0) != 0)) {
            this.jsDateToStringFormat = dateFormat = this.createDateFormat(this.appendTimeZoneNameFormat("EEE MMM dd uuuu HH:mm:ss 'GMT'xx"), true);
        }
        return dateFormat;
    }

    @CompilerDirectives.TruffleBoundary
    private String appendTimeZoneNameFormat(String format) {
        String timeZoneNameFormat = this.getContext().isOptionV8CompatibilityMode() ? "zzzz" : "z";
        return format + " (" + timeZoneNameFormat + ")";
    }

    @CompilerDirectives.TruffleBoundary
    private DateFormat createDateFormat(String pattern, boolean local) {
        Calendar calendar;
        SimpleDateFormat format = new SimpleDateFormat(pattern, Locale.US);
        format.setTimeZone(local ? this.getLocalTimeZone() : TimeZone.GMT_ZONE);
        if (!pattern.contains("zzzz")) {
            TimeZoneFormat tzFormat = format.getTimeZoneFormat().cloneAsThawed();
            tzFormat.setTimeZoneNames(TimeZoneNames.getTZDBInstance((ULocale)ULocale.US));
            format.setTimeZoneFormat(tzFormat);
        }
        if ((calendar = format.getCalendar()) instanceof GregorianCalendar) {
            ((GregorianCalendar)calendar).setGregorianChange(new Date(Long.MIN_VALUE));
        }
        return format;
    }

    @CompilerDirectives.TruffleBoundary
    public void setLocalTimeZone(String tzId) {
        TimeZone newTimeZone;
        ZoneId newZoneId;
        try {
            if (tzId != null) {
                newZoneId = ZoneId.of(tzId);
                newTimeZone = IntlUtil.getICUTimeZone(tzId, this.getContext());
            } else {
                newZoneId = null;
                newTimeZone = null;
            }
        }
        catch (DateTimeException e) {
            return;
        }
        this.localTimeZoneId = newZoneId;
        this.localTimeZone = newTimeZone;
        this.jsDateToStringFormat = null;
        this.jsShortTimeFormat = null;
        this.jsShortTimeLocalFormat = null;
        this.jsShortDateFormat = null;
        this.jsShortDateLocalFormat = null;
    }

    private void enterOncePerContextBranch() {
        if (CompilerDirectives.isPartialEvaluationConstant((Object)this)) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
        }
    }

    public Charset getCharset() {
        return this.charset;
    }

    @CompilerDirectives.TruffleBoundary
    private Charset getCharsetImpl() {
        String name = this.getContextOptions().getCharset();
        if (name.isEmpty()) {
            return Charset.defaultCharset();
        }
        return Charset.forName(name);
    }

    public long nextAsyncEvaluationOrder() {
        return ++this.lastAsyncEvaluationOrder;
    }

    @CompilerDirectives.TruffleBoundary
    public void putCachedCompiledRegex(Source regexSource, Object compiledRegex) {
        int regexCacheSize = this.getContextOptions().getRegexCacheSize();
        if (regexCacheSize > 0) {
            if (this.compiledRegexCache == null) {
                this.compiledRegexCache = new LRUCache<Source, Object>(regexCacheSize);
            }
            this.compiledRegexCache.put(regexSource, compiledRegex);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public Object getCachedCompiledRegex(Source regexSource) {
        int regexCacheSize = this.getContextOptions().getRegexCacheSize();
        if (regexCacheSize > 0 && this.compiledRegexCache != null) {
            return this.compiledRegexCache.get(regexSource);
        }
        return null;
    }

    public void storeParentPromise(JSDynamicObject promise) {
        this.parentPromise = promise;
    }

    public JSDynamicObject fetchParentPromise() {
        JSDynamicObject parent = this.parentPromise;
        if (parent == null) {
            parent = Undefined.instance;
        } else {
            this.parentPromise = null;
        }
        return parent;
    }

    public int getOperatorCounter() {
        assert (this.isMainRealm());
        return this.operatorCounter;
    }

    public void incOperatorCounter() {
        assert (this.isMainRealm());
        ++this.operatorCounter;
    }

    private static final class RealmSharedPropertyProxy
    extends PropertyProxy {
        private RealmSharedPropertyProxy() {
        }

        @Override
        public Object get(JSDynamicObject store) {
            return RealmSharedPropertyProxy.topLevelRealm().v8RealmShared;
        }

        @Override
        public boolean set(JSDynamicObject store, Object value) {
            RealmSharedPropertyProxy.topLevelRealm().v8RealmShared = value;
            return true;
        }

        private static JSRealm topLevelRealm() {
            return JSRealm.getMain(null);
        }
    }
}

