/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalConstants;

@ImportStatic(value={TemporalConstants.class})
public abstract class ToFractionalSecondDigitsNode
extends JavaScriptBaseNode {
    public static final int AUTO = -1;

    public abstract int execute(Object var1);

    @Specialization
    protected int toFractionalSecondDigits(Object normalizedOptions, @Cached(value="create(FRACTIONAL_SECOND_DIGITS, getJSContext())") PropertyGetNode getFractionalSecondDigits, @Cached JSToStringNode toStringNode, @Cached TruffleString.EqualNode equalNode, @Cached InlinedBranchProfile errorBranch) {
        Object digitsValue = getFractionalSecondDigits.getValue(normalizedOptions);
        if (digitsValue == Undefined.instance) {
            return -1;
        }
        if (digitsValue instanceof Number) {
            Number numberValue = (Number)digitsValue;
            if (JSRuntime.isNaN(numberValue)) {
                errorBranch.enter((Node)this);
                throw ToFractionalSecondDigitsNode.invalidDigits();
            }
            double digitCount = Math.floor(JSRuntime.toDouble(numberValue));
            if (digitCount < 0.0 || digitCount > 9.0) {
                errorBranch.enter((Node)this);
                throw ToFractionalSecondDigitsNode.invalidDigits();
            }
            return (int)digitCount;
        }
        TruffleString stringValue = toStringNode.executeString(digitsValue);
        if (!Strings.equals(equalNode, TemporalConstants.AUTO, stringValue)) {
            errorBranch.enter((Node)this);
            throw ToFractionalSecondDigitsNode.invalidDigits();
        }
        return -1;
    }

    private static JSException invalidDigits() {
        return Errors.createRangeError("Invalid fractionalSecondDigits");
    }
}

