/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.array.JSGetLengthNode;
import com.oracle.truffle.js.nodes.array.TypedArrayLengthNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSArrayObject;
import com.oracle.truffle.js.runtime.builtins.JSTypedArrayObject;

@GenerateInline
@GenerateCached(value=false)
abstract class ArrayIteratorGetLengthNode
extends Node {
    ArrayIteratorGetLengthNode() {
    }

    abstract long execute(Node var1, Object var2, JSContext var3);

    @Specialization
    static long doArray(JSArrayObject array, JSContext context) {
        return JSArray.arrayGetLength(array);
    }

    @Specialization
    static long doTypedArray(Node node, JSTypedArrayObject typedArray, JSContext context, @Cached TypedArrayLengthNode typedArrayLengthNode, @Cached InlinedBranchProfile errorBranch) {
        if (JSArrayBufferView.isOutOfBounds(typedArray, context)) {
            errorBranch.enter(node);
            throw Errors.createTypeError("Cannot perform Array Iterator.prototype.next on a detached ArrayBuffer");
        }
        return typedArrayLengthNode.execute(node, typedArray, context);
    }

    @Fallback
    static long doArrayLike(Object array, JSContext context, @Cached(value="create(context)", inline=false) JSGetLengthNode getLengthNode) {
        return getLengthNode.executeLong(array);
    }
}

