/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes;

import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorNode;

public abstract class TRegexExecutorLocals {
    private final TruffleString input;
    private final int fromIndex;
    private final int maxIndex;
    private final int regionFrom;
    private final int regionTo;
    private int index;
    private int nextIndex;
    private int loopCount;

    public TRegexExecutorLocals(TruffleString input, int fromIndex, int maxIndex, int regionFrom, int regionTo, int index) {
        this.input = input;
        this.fromIndex = fromIndex;
        this.maxIndex = maxIndex;
        this.regionFrom = regionFrom;
        this.regionTo = regionTo;
        this.index = index;
    }

    public final TruffleString getInput() {
        return this.input;
    }

    public final int getFromIndex() {
        return this.fromIndex;
    }

    public final int getMaxIndex() {
        return this.maxIndex;
    }

    public int getRegionFrom() {
        return this.regionFrom;
    }

    public int getRegionTo() {
        return this.regionTo;
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int index) {
        this.index = index;
    }

    public final int getNextIndex() {
        return this.nextIndex;
    }

    public final void setNextIndex(int nextIndex) {
        this.nextIndex = nextIndex;
    }

    public final void incLoopCount(TRegexExecutorNode executorNode) {
        if ((++this.loopCount & 0xFFFF) == 0) {
            LoopNode.reportLoopCount((Node)executorNode, (int)65536);
        }
    }
}

