/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.dfa;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.regex.RegexOptions;
import com.oracle.truffle.regex.UnsupportedRegexException;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.CodePointSetAccumulator;
import com.oracle.truffle.regex.charset.CompressedCodePointSet;
import com.oracle.truffle.regex.charset.Constants;
import com.oracle.truffle.regex.result.PreCalculatedResultFactory;
import com.oracle.truffle.regex.tregex.TRegexCompilationRequest;
import com.oracle.truffle.regex.tregex.automaton.AbstractTransition;
import com.oracle.truffle.regex.tregex.automaton.BasicState;
import com.oracle.truffle.regex.tregex.automaton.StateSet;
import com.oracle.truffle.regex.tregex.automaton.StateSetToIntMap;
import com.oracle.truffle.regex.tregex.automaton.TransitionBuilder;
import com.oracle.truffle.regex.tregex.automaton.TransitionConstraint;
import com.oracle.truffle.regex.tregex.automaton.TransitionOp;
import com.oracle.truffle.regex.tregex.automaton.TransitionSet;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.buffer.IntArrayBuffer;
import com.oracle.truffle.regex.tregex.buffer.IntRangesBuffer;
import com.oracle.truffle.regex.tregex.buffer.LongArrayBuffer;
import com.oracle.truffle.regex.tregex.buffer.ObjectArrayBuffer;
import com.oracle.truffle.regex.tregex.buffer.ShortArrayBuffer;
import com.oracle.truffle.regex.tregex.dfa.DFACaptureGroupLazyTransitionBuilder;
import com.oracle.truffle.regex.tregex.dfa.DFACaptureGroupTransitionBuilder;
import com.oracle.truffle.regex.tregex.dfa.DFAStateNodeBuilder;
import com.oracle.truffle.regex.tregex.dfa.DFAStateTransitionBuilder;
import com.oracle.truffle.regex.tregex.dfa.DFATransitionCanonicalizer;
import com.oracle.truffle.regex.tregex.nfa.NFA;
import com.oracle.truffle.regex.tregex.nfa.NFAState;
import com.oracle.truffle.regex.tregex.nfa.NFAStateTransition;
import com.oracle.truffle.regex.tregex.nodes.dfa.AllTransitionsInOneTreeMatcher;
import com.oracle.truffle.regex.tregex.nodes.dfa.CGTrackingAnchoredFinalTransitionNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.CGTrackingDFAStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.CGTrackingPreFinalTransitionNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.CGTrackingTransitionNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.CounterTracker;
import com.oracle.truffle.regex.tregex.nodes.dfa.CounterTrackerData;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAAbstractNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAAbstractStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAAbstractTransitionNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFABQTrackingStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFABQTrackingTransitionConstraintsNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFABQTrackingTransitionOpsNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFACaptureGroupLazyTransition;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFACaptureGroupPartialTransition;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAFindInnerLiteralStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAInitialStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFASimpleCGTrackingStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFASimpleCGTransition;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.Matchers;
import com.oracle.truffle.regex.tregex.nodes.dfa.SequentialMatchers;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorDebugRecorder;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorProperties;
import com.oracle.truffle.regex.tregex.nodes.dfa.TraceFinderDFAStateNode;
import com.oracle.truffle.regex.tregex.parser.Counter;
import com.oracle.truffle.regex.tregex.parser.RegexProperties;
import com.oracle.truffle.regex.tregex.parser.ast.CharacterClass;
import com.oracle.truffle.regex.tregex.parser.ast.Group;
import com.oracle.truffle.regex.tregex.parser.ast.GroupBoundaries;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTNode;
import com.oracle.truffle.regex.tregex.parser.ast.Sequence;
import com.oracle.truffle.regex.tregex.parser.ast.Term;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.AddToSetVisitor;
import com.oracle.truffle.regex.tregex.string.Encodings;
import com.oracle.truffle.regex.tregex.util.MathUtil;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import com.oracle.truffle.regex.util.BitSets;
import com.oracle.truffle.regex.util.EmptyArrays;
import com.oracle.truffle.regex.util.TBitSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PrimitiveIterator;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;

public final class DFAGenerator
implements JsonConvertible {
    private static final DFAStateTransitionBuilder[] EMPTY_TRANSITIONS_ARRAY = new DFAStateTransitionBuilder[0];
    private final TRegexCompilationRequest compilationRequest;
    private final NFA nfa;
    private final TRegexDFAExecutorProperties executorProps;
    private final CompilationBuffer compilationBuffer;
    private final boolean pruneUnambiguousPaths;
    private final Map<DFAStateNodeBuilder, DFAStateNodeBuilder> stateMap = new HashMap<DFAStateNodeBuilder, DFAStateNodeBuilder>();
    private final Map<DFAAbstractTransitionNode, DFAAbstractTransitionNode> dfaTransitionsDedupMap = new HashMap<DFAAbstractTransitionNode, DFAAbstractTransitionNode>();
    private final ArrayDeque<DFAStateNodeBuilder> expansionQueue = new ArrayDeque();
    private final int[] boundedQuantifierTrackerSizes;
    private final TBitSet bqTrivialAlwaysReEnter;
    private final TBitSet bqTrivialNeverReEnter;
    private DFAStateNodeBuilder[] stateIndexMap = null;
    private short nextID = 1;
    private final DFAStateNodeBuilder lookupDummyState;
    private final Counter transitionIDCounter;
    private final Counter cgPartialTransitionIDCounter = new Counter.ThresholdCounter(3000, "too many partial transitions");
    private int maxNumberOfNfaStates = 1;
    private boolean hasAmbiguousStates = false;
    private boolean doSimpleCG = false;
    private boolean simpleCGMustCopy = false;
    private final StateSet<NFA, NFAState> nfaFirstStates;
    private DFAStateNodeBuilder[] entryStates;
    private DFACaptureGroupTransitionBuilder[] initialCGTransitions;
    private final List<DFACaptureGroupTransitionBuilder.PartialTransitionDebugInfo> cgPartialTransitions;
    private final DFATransitionCanonicalizer canonicalizer;
    private List<DFAStateTransitionBuilder[]> bfsTraversalCur;
    private List<DFAStateTransitionBuilder[]> bfsTraversalNext;
    private EconomicMap<Integer, DFAAbstractStateNode> stateReplacements;
    private TRegexDFAExecutorNode innerLiteralPrefixMatcher = null;
    private final SequentialMatchers.Builder matchersBuilder;
    private final List<TruffleString.CodePointSet> indexOfParams = new ArrayList<TruffleString.CodePointSet>();

    public DFAGenerator(TRegexCompilationRequest compilationRequest, NFA nfa, TRegexDFAExecutorProperties executorProps, CompilationBuffer compilationBuffer) {
        this.transitionIDCounter = new Counter.ThresholdCounter(nfa.getAst().getOptions().getMaxDFASize(), "too many transitions");
        this.compilationRequest = compilationRequest;
        this.nfa = nfa;
        this.executorProps = executorProps;
        this.pruneUnambiguousPaths = executorProps.isBackward() && nfa.isTraceFinderNFA() && nfa.hasReverseUnAnchoredEntry();
        this.compilationBuffer = compilationBuffer;
        this.cgPartialTransitions = this.debugMode() ? new ArrayList() : null;
        this.bfsTraversalCur = this.needBFSTraversalLists() ? new ArrayList() : null;
        this.bfsTraversalNext = this.needBFSTraversalLists() ? new ArrayList() : null;
        this.cgPartialTransitionIDCounter.inc();
        this.lookupDummyState = new DFAStateNodeBuilder(-1, null, false, false, this.isForward(), this.isForward() && !this.isBooleanMatch());
        if (this.debugMode()) {
            this.registerCGPartialTransitionDebugInfo(new DFACaptureGroupTransitionBuilder.PartialTransitionDebugInfo(DFACaptureGroupPartialTransition.getEmptyInstance()));
        }
        assert (!nfa.isDead());
        this.canonicalizer = new DFATransitionCanonicalizer(this);
        this.matchersBuilder = nfa.getAst().getEncoding().createMatchersBuilder();
        this.nfaFirstStates = StateSet.create(nfa);
        this.boundedQuantifierTrackerSizes = new int[nfa.getAst().getQuantifierCount()];
        this.bqTrivialAlwaysReEnter = new TBitSet(this.boundedQuantifierTrackerSizes.length);
        this.bqTrivialNeverReEnter = new TBitSet(this.boundedQuantifierTrackerSizes.length);
    }

    public NFA getNfa() {
        return this.nfa;
    }

    public DFAStateNodeBuilder[] getEntryStates() {
        return this.entryStates;
    }

    private DFAStateNodeBuilder getAnchoredInitialState() {
        return this.entryStates[0];
    }

    private DFAStateNodeBuilder getMaxOffsetAnchoredInitialState() {
        return this.entryStates[this.nfa.getAnchoredEntry().length - 1];
    }

    private DFAStateNodeBuilder getUnanchoredInitialState() {
        return this.entryStates[this.nfa.getAnchoredEntry().length];
    }

    public Map<DFAStateNodeBuilder, DFAStateNodeBuilder> getStateMap() {
        return this.stateMap;
    }

    public TRegexDFAExecutorProperties getProps() {
        return this.executorProps;
    }

    public boolean isForward() {
        return this.executorProps.isForward();
    }

    public boolean isGenericCG() {
        return this.executorProps.isGenericCG();
    }

    public boolean isSearching() {
        return this.executorProps.isSearching();
    }

    public RegexOptions getOptions() {
        return this.nfa.getAst().getOptions();
    }

    private Encodings.Encoding getEncoding() {
        return this.nfa.getAst().getEncoding();
    }

    private boolean isBooleanMatch() {
        return this.getOptions().isBooleanMatch();
    }

    public CompilationBuffer getCompilationBuffer() {
        return this.compilationBuffer;
    }

    private DFAStateNodeBuilder[] getStateIndexMap() {
        if (this.stateIndexMap == null) {
            this.createStateIndexMap(this.nextID);
        }
        return this.stateIndexMap;
    }

    public DFAStateNodeBuilder getState(short stateNodeID) {
        assert (this.debugMode());
        this.getStateIndexMap();
        return this.stateIndexMap[stateNodeID];
    }

    private void createStateIndexMap(int size) {
        assert (this.debugMode());
        this.stateIndexMap = new DFAStateNodeBuilder[size];
        Iterator<DFAStateNodeBuilder> iterator = this.stateMap.values().iterator();
        while (iterator.hasNext()) {
            DFAStateNodeBuilder s;
            this.stateIndexMap[s.getId()] = s = iterator.next();
        }
    }

    public Counter getCgPartialTransitionIDCounter() {
        return this.cgPartialTransitionIDCounter;
    }

    public void registerCGPartialTransitionDebugInfo(DFACaptureGroupTransitionBuilder.PartialTransitionDebugInfo partialTransition) {
        if (this.cgPartialTransitions.size() == partialTransition.getNode().getId()) {
            this.cgPartialTransitions.add(partialTransition);
        } else assert (partialTransition.getNode() == this.cgPartialTransitions.get(partialTransition.getNode().getId()).getNode());
    }

    private boolean needBFSTraversalLists() {
        return this.pruneUnambiguousPaths || this.nfa.getAst().getProperties().hasInnerLiteral() || this.trackBoundedQuantifiers();
    }

    private void bfsExpand(DFAStateNodeBuilder s) {
        if (s.getSuccessors() != null) {
            this.bfsTraversalNext.add((DFAStateTransitionBuilder[])s.getSuccessors());
        }
    }

    private void bfsSwapLists() {
        List<DFAStateTransitionBuilder[]> tmp = this.bfsTraversalCur;
        this.bfsTraversalCur = this.bfsTraversalNext;
        this.bfsTraversalNext = tmp;
    }

    private boolean trackBoundedQuantifiers() {
        return this.nfa.getAst().getRoot().hasQuantifiers();
    }

    private boolean trackPredecessors() {
        return this.isGenericCG() || this.trackBoundedQuantifiers();
    }

    @CompilerDirectives.TruffleBoundary
    public void calcDFA() {
        if (this.isForward()) {
            this.createInitialStatesForward();
            this.addSuccessors(this.nfaFirstStates, this.nfa.getUnAnchoredInitialState());
            this.addSuccessors(this.nfaFirstStates, this.nfa.getAnchoredInitialState());
        } else {
            this.createInitialStatesBackward();
        }
        while (!this.expansionQueue.isEmpty()) {
            this.expandState(this.expansionQueue.pop());
        }
        this.optimizeDFA();
    }

    private void addSuccessors(StateSet<NFA, NFAState> stateSet, NFAState state) {
        if (state != null) {
            for (NFAStateTransition t : (NFAStateTransition[])state.getSuccessors()) {
                stateSet.add((NFAState)t.getTarget(this.isForward()));
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    public TRegexDFAExecutorNode createDFAExecutor() {
        ObjectArrayBuffer<DFAAbstractNode> nodes = this.createDFAExecutorStates();
        short[] entryStateIDs = new short[this.entryStates.length];
        short[] cgLastTransition = this.isGenericCG() ? new short[this.entryStates.length] : null;
        for (int i = 0; i < this.entryStates.length; ++i) {
            if (this.entryStates[i] == null) {
                entryStateIDs[i] = -1;
                continue;
            }
            entryStateIDs[i] = (short)this.entryStates[i].getId();
            if (this.isGenericCG()) {
                DFACaptureGroupLazyTransitionBuilder lt = this.getLazyTransitionBuilder(this.initialCGTransitions[i]);
                cgLastTransition[i] = lt.getLastTransitionIndex();
                continue;
            }
            if (this.isForward() || !this.doSimpleCG) continue;
            entryStateIDs[i] = this.createAndDedupSimpleCGTransition(nodes, entryStateIDs[i], this.entryStates[i].getNfaTransitionSet().getTransition(0));
        }
        if (this.executorProps.canFindStart()) {
            assert (this.isForward() && this.getReplacement(this.getUnanchoredInitialState().getId()) instanceof DFAFindInnerLiteralStateNode);
            entryStateIDs = new short[]{(short)this.getUnanchoredInitialState().getId(), (short)this.getUnanchoredInitialState().getId()};
        }
        assert (nodes.get(0) == null);
        nodes.set(0, new DFAInitialStateNode(entryStateIDs, cgLastTransition));
        this.executorProps.setSimpleCG(this.doSimpleCG);
        this.executorProps.setSimpleCGMustCopy(this.simpleCGMustCopy);
        TRegexDFAExecutorDebugRecorder debugRecorder = TRegexDFAExecutorDebugRecorder.create(this.getOptions(), this);
        int[] quantifierBounds = this.nfa.getAst().getAllQuantifierBounds();
        CounterTrackerData.Builder counterDataBuilder = new CounterTrackerData.Builder();
        CounterTracker[] counterTrackers = CounterTracker.build(quantifierBounds, this.boundedQuantifierTrackerSizes, counterDataBuilder, this.bqTrivialAlwaysReEnter, this.bqTrivialNeverReEnter, this.getOptions().isRegressionTestMode());
        DFAGenerator.checkIfAllQuantifierOperationsAreSupported(nodes, counterTrackers);
        return new TRegexDFAExecutorNode(this.nfa.getAst().getSource(), this.executorProps, this.getNfa().getAst().getNumberOfCaptureGroups(), this.maxNumberOfNfaStates, (TruffleString.CodePointSet[])this.indexOfParams.toArray(TruffleString.CodePointSet[]::new), (DFAAbstractNode[])nodes.toArray(DFAAbstractNode[]::new), debugRecorder, this.innerLiteralPrefixMatcher, counterDataBuilder, counterTrackers, this.nfa.getNumberOfStates(), this.getOptions().isRegressionTestMode());
    }

    /*
     * Could not resolve type clashes
     */
    private void optimizeBoundedQuantifierDataMapping() {
        if (!this.trackBoundedQuantifiers()) {
            return;
        }
        int quantifierCount = this.nfa.getAst().getQuantifierCount();
        QuantifierMappingBuilder[] mappings = new QuantifierMappingBuilder[quantifierCount];
        for (int i = 0; i < mappings.length; ++i) {
            mappings[i] = new QuantifierMappingBuilder(new StateMapping[this.nextID]);
        }
        for (DFAStateNodeBuilder state : this.stateMap.values()) {
            for (QuantifierMappingBuilder mapping : mappings) {
                mapping.stateMappings[state.getId()] = new StateMapping(StateSet.create(this.nfa));
            }
            for (QuantifierMappingBuilder unAnchoredFinalConstraints : (QuantifierMappingBuilder[])state.getUnAnchoredFinalConstraints()) {
                for (Object cs : unAnchoredFinalConstraints) {
                    mappings[TransitionConstraint.getQuantifierID((long)cs)].addState(state, this.nfa.getState(TransitionConstraint.getStateID((long)cs)));
                }
            }
            for (QuantifierMappingBuilder anchoredFinalConstraints : (QuantifierMappingBuilder[])state.getAnchoredFinalConstraints()) {
                for (Object cs : anchoredFinalConstraints) {
                    mappings[TransitionConstraint.getQuantifierID((long)cs)].addState(state, this.nfa.getState(TransitionConstraint.getStateID((long)cs)));
                }
            }
            for (QuantifierMappingBuilder transition : (DFAStateTransitionBuilder[])state.getSuccessors()) {
                for (Object cs : (Object)((TransitionBuilder)((Object)transition)).getConstraints()) {
                    mappings[TransitionConstraint.getQuantifierID((long)cs)].addState(state, this.nfa.getState(TransitionConstraint.getStateID((long)cs)));
                }
                if (((DFAStateTransitionBuilder)((Object)transition)).getTarget().isUnAnchoredFinalState()) {
                    ((TransitionBuilder)((Object)transition)).setOperations(TransitionOp.NO_OP);
                    continue;
                }
                for (Object op : (Object)((TransitionBuilder)((Object)transition)).getOperations()) {
                    if (TransitionOp.getSource((long)op) == 65535) continue;
                    mappings[TransitionOp.getQuantifierID((long)op)].addState(state, this.nfa.getState(TransitionOp.getSource((long)op)));
                }
            }
        }
        DFAStateNodeBuilder anchoredInitialState = this.getAnchoredInitialState();
        DFAStateNodeBuilder unAnchoredInitialState = this.getUnanchoredInitialState();
        TBitSet visited = new TBitSet(this.nextID);
        visited.set(anchoredInitialState.getId());
        anchoredInitialState.setReachable();
        this.bfsTraversalCur.clear();
        this.bfsTraversalCur.add((DFAStateTransitionBuilder[])anchoredInitialState.getSuccessors());
        if (unAnchoredInitialState != null && anchoredInitialState != unAnchoredInitialState) {
            visited.set(unAnchoredInitialState.getId());
            unAnchoredInitialState.setReachable();
            this.bfsTraversalCur.add((DFAStateTransitionBuilder[])unAnchoredInitialState.getSuccessors());
        }
        for (Iterator<DFAStateTransitionBuilder[]> m : mappings) {
            ((QuantifierMappingBuilder)((Object)m)).initBuffers();
        }
        LongArrayBuffer opsNormalized = new LongArrayBuffer();
        LongArrayBuffer opsDeferred = new LongArrayBuffer();
        ObjectArrayBuffer<StateSetToIntMap<NFAState, NFAStateTransition>> propagatedMaps = new ObjectArrayBuffer<StateSetToIntMap<NFAState, NFAStateTransition>>();
        while (!this.bfsTraversalCur.isEmpty()) {
            this.bfsTraversalNext.clear();
            for (DFAStateTransitionBuilder[] cur : this.bfsTraversalCur) {
                for (DFAStateTransitionBuilder transition : cur) {
                    int nfaTargetMapped;
                    int nfaSourceMapped;
                    StateSetToIntMap<NFAState, NFAStateTransition> targetMap;
                    StateSetToIntMap<NFAState, NFAStateTransition> sourceMap;
                    int nfaTarget;
                    int nfaSource;
                    QuantifierMappingBuilder mb;
                    for (QuantifierMappingBuilder mb2 : mappings) {
                        mb2.resetBuffers();
                    }
                    opsNormalized.clear();
                    opsDeferred.clear();
                    DFAStateNodeBuilder target = transition.getTarget();
                    target.setReachable();
                    transition.setConstraints(DFAGenerator.rewriteConstraints(transition.getSource(), mappings, transition.getConstraints()));
                    for (long op : transition.getOperations()) {
                        int quantifierID = TransitionOp.getQuantifierID(op);
                        int nfaTarget2 = TransitionOp.getTarget(op);
                        mb = mappings[quantifierID];
                        StateMapping targetStateMapping = mb.stateMappings[transition.getTarget().getId()];
                        if (!targetStateMapping.states.contains(this.nfa.getState(nfaTarget2))) continue;
                        opsNormalized.add(op);
                    }
                    TransitionOp.normalize(opsNormalized);
                    Object object = opsNormalized.iterator();
                    while (object.hasNext()) {
                        long op = (Long)object.next();
                        int quantifierID = TransitionOp.getQuantifierID(op);
                        nfaSource = TransitionOp.getSource(op);
                        nfaTarget = TransitionOp.getTarget(op);
                        QuantifierMappingBuilder mb3 = mappings[quantifierID];
                        StateMapping targetStateMapping = mb3.stateMappings[transition.getTarget().getId()];
                        if (!targetStateMapping.hasMapping()) {
                            targetStateMapping.createMapping();
                            propagatedMaps.add(targetStateMapping.getMapping());
                        }
                        if (nfaSource == 65535) continue;
                        sourceMap = mb3.stateMappings[transition.getSource().getId()].getMappingOrDefault();
                        targetMap = targetStateMapping.getMapping();
                        nfaSourceMapped = sourceMap.getValue(nfaSource);
                        if (targetMap.getValue(nfaTarget) != -1 || targetMap.isValueUsed(nfaSourceMapped)) continue;
                        targetMap.put(nfaTarget, nfaSourceMapped);
                    }
                    for (StateSetToIntMap propagated : propagatedMaps) {
                        propagated.fillRest();
                    }
                    propagatedMaps.clear();
                    object = opsNormalized.iterator();
                    while (object.hasNext()) {
                        long op = (Long)object.next();
                        int quantifierID = TransitionOp.getQuantifierID(op);
                        nfaSource = TransitionOp.getSource(op);
                        nfaTarget = TransitionOp.getTarget(op);
                        int kind = TransitionOp.getKind(op);
                        mb = mappings[quantifierID];
                        sourceMap = mb.stateMappings[transition.getSource().getId()].getMapping();
                        targetMap = mb.stateMappings[transition.getTarget().getId()].getMapping();
                        nfaSourceMapped = nfaSource == 65535 ? 65535 : sourceMap.getValue(nfaSource);
                        nfaTargetMapped = targetMap.getValue(nfaTarget);
                        assert (nfaTargetMapped >= 0);
                        if (nfaSourceMapped != 65535) {
                            if (mb.copySource[nfaSourceMapped] < 0) {
                                if (mb.newOrder[nfaTargetMapped] < 0) {
                                    mb.newOrder[nfaTargetMapped] = nfaSourceMapped;
                                    mb.copySource[nfaSourceMapped] = nfaTargetMapped;
                                    if (kind == 0) {
                                        mb.targetsUsed.set(nfaTargetMapped);
                                        continue;
                                    }
                                    mb.ops.add(TransitionOp.create(quantifierID, nfaTargetMapped, nfaTargetMapped, kind, 0));
                                    continue;
                                }
                                opsDeferred.add(op);
                                continue;
                            }
                            mb.ops.add(TransitionOp.create(quantifierID, mb.copySource[nfaSourceMapped], nfaTargetMapped, kind, 0));
                            continue;
                        }
                        assert (kind == 2);
                        mb.opsSet1.add(TransitionOp.create(quantifierID, 65535, nfaTargetMapped, 2));
                    }
                    for (QuantifierMappingBuilder mb4 : mappings) {
                        int order = 0;
                        for (int i = 0; i < mb4.newOrder.length; ++i) {
                            if (mb4.newOrder[i] != -1) continue;
                            while (mb4.copySource[order] >= 0) {
                                ++order;
                            }
                            mb4.newOrder[i] = order;
                            mb4.copySource[order++] = i;
                        }
                    }
                    object = opsDeferred.iterator();
                    while (object.hasNext()) {
                        long op = (Long)object.next();
                        int quantifierID = TransitionOp.getQuantifierID(op);
                        nfaSource = TransitionOp.getSource(op);
                        nfaTarget = TransitionOp.getTarget(op);
                        int kind = TransitionOp.getKind(op);
                        mb = mappings[quantifierID];
                        sourceMap = mb.stateMappings[transition.getSource().getId()].getMapping();
                        targetMap = mb.stateMappings[transition.getTarget().getId()].getMapping();
                        assert (nfaSource != 65535);
                        nfaSourceMapped = sourceMap.getValue(nfaSource);
                        nfaTargetMapped = targetMap.getValue(nfaTarget);
                        assert (nfaTargetMapped >= 0);
                        int copySource = mb.copySource[nfaSourceMapped];
                        mb.ops.add(TransitionOp.create(quantifierID, copySource, nfaTargetMapped, kind, 0));
                    }
                    opsDeferred.clear();
                    for (int quantifierID = 0; quantifierID < mappings.length; ++quantifierID) {
                        QuantifierMappingBuilder mb5 = mappings[quantifierID];
                        mb5.scheduleOps();
                        DFAGenerator.newOrderToSequenceOfSwaps(quantifierID, mb5.newOrder, opsDeferred);
                    }
                    for (QuantifierMappingBuilder mb6 : mappings) {
                        int nfaTarget3;
                        long op;
                        PrimitiveIterator.OfLong ofLong = mb6.ops.iterator();
                        while (ofLong.hasNext()) {
                            op = (Long)ofLong.next();
                            nfaTarget3 = TransitionOp.getTarget(op);
                            opsDeferred.add(TransitionOp.setModifier(mb6.targetsUsed.get(nfaTarget3) ? 2 : 1, op));
                            mb6.targetsUsed.set(nfaTarget3);
                        }
                        ofLong = mb6.opsSet1.iterator();
                        while (ofLong.hasNext()) {
                            op = (Long)ofLong.next();
                            nfaTarget3 = TransitionOp.getTarget(op);
                            opsDeferred.add(TransitionOp.setModifier(mb6.targetsUsed.get(nfaTarget3) ? 2 : 1, op));
                            mb6.targetsUsed.set(nfaTarget3);
                        }
                    }
                    transition.setOperations(opsDeferred.toArray());
                    if (visited.get(target.getId())) continue;
                    visited.set(target.getId());
                    this.bfsExpand(target);
                }
            }
            this.bfsSwapLists();
        }
        for (DFAStateNodeBuilder state : this.stateMap.values()) {
            DFAGenerator.rewriteConstraints(state, mappings, state.getUnAnchoredFinalConstraints());
            DFAGenerator.rewriteConstraints(state, mappings, state.getAnchoredFinalConstraints());
        }
        for (int i = 0; i < mappings.length; ++i) {
            this.boundedQuantifierTrackerSizes[i] = mappings[i].maxMapSize;
        }
        this.checkTrivialQuantifiers();
    }

    private static void newOrderToSequenceOfSwaps(int quantifierID, int[] newOrder, LongArrayBuffer swapOps) {
        int lengthBefore = swapOps.length();
        for (int i = 0; i < newOrder.length; ++i) {
            int swapSource;
            int swapTarget = swapSource = newOrder[i];
            if (swapSource == i) continue;
            do {
                swapSource = swapTarget;
                swapTarget = newOrder[swapTarget];
                swapOps.add(TransitionOp.create(quantifierID, swapSource, swapTarget, 0, 3));
                newOrder[swapSource] = swapSource;
            } while (swapTarget != i);
        }
        assert (swapOps.length() - lengthBefore < newOrder.length || newOrder.length == 0);
    }

    /*
     * Unable to fully structure code
     */
    private void createBQTransitions(ObjectArrayBuffer<DFAAbstractNode> nodes) {
        bucketStack = new ArrayList<EconomicMap>();
        bucketStack.add(EconomicMap.create());
        block0: for (DFAStateNodeBuilder s : this.stateMap.values()) {
            predecessors = (DFAStateTransitionBuilder[])s.getPredecessors();
            if (predecessors.length == 0) continue;
            if (predecessors.length == 1) {
                if (predecessors[0].getOperations() == null || predecessors[0].getOperations().length == 0) continue;
                v0 = this.nextID;
                this.nextID = (short)(v0 + 1);
                predecessors[0].setBqTransition(DFAGenerator.insertNode(nodes, new DFABQTrackingTransitionOpsNode(v0, (short)s.getId(), predecessors[0].getOperations())));
                continue;
            }
            topLevelBuckets = (EconomicMap)bucketStack.get(0);
            for (DFAStateTransitionBuilder t : predecessors) {
                if (t == null || (ops = t.getOperations()) == null || ops.length == 0) continue;
                lastOp = ops[ops.length - 1];
                bucket = (BQOpBucket)topLevelBuckets.get((Object)lastOp);
                if (bucket == null) {
                    bucket = new BQOpBucket();
                    topLevelBuckets.put((Object)lastOp, (Object)bucket);
                }
                bucket.transitions.add(t);
            }
            level = 0;
            block2: while (true) {
                if ((curLevel = (EconomicMap)bucketStack.get(level)).isEmpty()) {
                    if (level == 0) continue block0;
                    --level;
                    continue;
                }
                cursor = curLevel.getEntries();
                cursor.advance();
                curBucket = (BQOpBucket)cursor.getValue();
                cursor.remove();
                if (++level == bucketStack.size()) {
                    bucketStack.add(EconomicMap.create());
                }
                nextLevel = (EconomicMap)bucketStack.get(level);
                if (!DFAGenerator.$assertionsDisabled && !nextLevel.isEmpty()) {
                    throw new AssertionError();
                }
                var12_16 = curBucket.transitions.iterator();
                while (true) {
                    if (var12_16.hasNext()) ** break;
                    continue block2;
                    t = var12_16.next();
                    ops = t.getOperations();
                    i = ops.length - (level + 1);
                    if (i < 0) {
                        t.setBqTransition(curBucket.getBQTransition(this, nodes, t, level));
                        continue;
                    }
                    lastOp = ops[i];
                    nextBucket = (BQOpBucket)nextLevel.get((Object)lastOp);
                    if (nextBucket == null) {
                        if (nextLevel.size() == 1) {
                            curBucket.getBQTransition(this, nodes, t, level);
                        }
                        nextBucket = new BQOpBucket();
                        nextBucket.parent = curBucket;
                        nextLevel.put((Object)lastOp, (Object)nextBucket);
                    }
                    nextBucket.transitions.add(t);
                }
                break;
            }
        }
    }

    private static void rewriteConstraints(DFAStateNodeBuilder state, QuantifierMappingBuilder[] mappings, long[][] constraints) {
        for (int i = 0; i < constraints.length; ++i) {
            constraints[i] = DFAGenerator.rewriteConstraints(state, mappings, constraints[i]);
        }
    }

    private static long[] rewriteConstraints(DFAStateNodeBuilder state, QuantifierMappingBuilder[] mappings, long[] constraints) {
        long[] ret = new long[constraints.length];
        for (int i = 0; i < constraints.length; ++i) {
            long cs = constraints[i];
            QuantifierMappingBuilder mb = mappings[TransitionConstraint.getQuantifierID(cs)];
            StateSetToIntMap<NFAState, NFAStateTransition> mapping = mb.stateMappings[state.getId()].getMappingOrDefault();
            ret[i] = TransitionConstraint.setStateID(cs, mapping.getValue(TransitionConstraint.getStateID(cs)));
        }
        return ret;
    }

    private void checkTrivialQuantifiers() {
        if (this.boundedQuantifierTrackerSizes.length == 0) {
            return;
        }
        this.bqTrivialAlwaysReEnter.setRange(0, this.boundedQuantifierTrackerSizes.length - 1);
        this.bqTrivialNeverReEnter.setRange(0, this.boundedQuantifierTrackerSizes.length - 1);
        ArrayList<TBitSet> inc = new ArrayList<TBitSet>();
        ArrayList<TBitSet> set1 = new ArrayList<TBitSet>();
        for (int numberOfCells : this.boundedQuantifierTrackerSizes) {
            if (inc.size() >= numberOfCells) continue;
            for (int i = inc.size(); i < numberOfCells; ++i) {
                inc.add(new TBitSet(this.boundedQuantifierTrackerSizes.length));
                set1.add(new TBitSet(this.boundedQuantifierTrackerSizes.length));
            }
        }
        Object object = this.stateMap.values().iterator();
        while (object.hasNext()) {
            DFAStateNodeBuilder state = (DFAStateNodeBuilder)object.next();
            if (!state.isReachable()) continue;
            for (DFAStateTransitionBuilder t : (DFAStateTransitionBuilder[])state.getSuccessors()) {
                block8: for (long operation : t.getOperations()) {
                    int qId = TransitionOp.getQuantifierID(operation);
                    int kind = TransitionOp.getKind(operation);
                    int target = TransitionOp.getTarget(operation);
                    int modifier = TransitionOp.getModifier(operation);
                    if (modifier == 2) {
                        this.bqTrivialNeverReEnter.clear(qId);
                    }
                    switch (kind) {
                        case 1: {
                            ((TBitSet)inc.get(target)).set(qId);
                            continue block8;
                        }
                        case 2: {
                            ((TBitSet)set1.get(target)).set(qId);
                        }
                    }
                }
                for (int i = 0; i < inc.size(); ++i) {
                    ((TBitSet)inc.get(i)).subtract((TBitSet)set1.get(i));
                    this.bqTrivialAlwaysReEnter.subtract((TBitSet)inc.get(i));
                    ((TBitSet)inc.get(i)).clear();
                    ((TBitSet)set1.get(i)).clear();
                }
            }
        }
    }

    private static void checkIfAllQuantifierOperationsAreSupported(ObjectArrayBuffer<DFAAbstractNode> nodes, CounterTracker[] counterTrackers) {
        for (DFAAbstractNode node : nodes) {
            if (!(node instanceof DFABQTrackingTransitionOpsNode)) continue;
            DFABQTrackingTransitionOpsNode t = (DFABQTrackingTransitionOpsNode)node;
            for (long op : t.getOperations()) {
                int qId = TransitionOp.getQuantifierID(op);
                if (counterTrackers[qId].support(op)) continue;
                throw new UnsupportedRegexException("Regex has unsupported bounded quantifier");
            }
        }
    }

    private void createInitialStatesForward() {
        int numberOfEntryPoints = this.nfa.getAnchoredEntry().length;
        this.entryStates = new DFAStateNodeBuilder[numberOfEntryPoints * 2];
        this.nfa.setInitialLoopBack(this.isSearching() && !this.nfa.getAst().getFlags().isSticky());
        for (int i = 0; i < numberOfEntryPoints; ++i) {
            if (this.nfa.getAnchoredEntry()[i] == null) {
                assert (this.nfa.getUnAnchoredEntry()[i] == null);
                this.entryStates[i] = null;
                this.entryStates[numberOfEntryPoints + i] = null;
                continue;
            }
            if (this.nfa.getUnAnchoredEntry()[i] == null) {
                this.entryStates[i] = this.createInitialState(this.createTransitionBuilder(this.createNFATransitionSet(this.nfa.getAnchoredEntry()[i])));
                this.entryStates[numberOfEntryPoints + i] = null;
                continue;
            }
            this.entryStates[i] = this.createInitialState(this.createTransitionBuilder(this.createNFATransitionSet(this.nfa.getAnchoredEntry()[i], this.nfa.getUnAnchoredEntry()[i])));
            this.entryStates[numberOfEntryPoints + i] = this.createInitialState(this.createTransitionBuilder(this.createNFATransitionSet(this.nfa.getUnAnchoredEntry()[i])));
        }
    }

    private void createInitialStatesBackward() {
        this.entryStates = new DFAStateNodeBuilder[]{null, null};
        if (this.nfa.hasReverseUnAnchoredEntry()) {
            this.entryStates[0] = this.createInitialStateBackward(this.nfa.getReverseAnchoredEntry(), this.nfa.getReverseUnAnchoredEntry());
            this.entryStates[1] = this.createInitialStateBackward(this.nfa.getReverseUnAnchoredEntry());
        } else {
            this.entryStates[0] = this.createInitialStateBackward(this.nfa.getReverseAnchoredEntry());
            this.entryStates[1] = null;
        }
    }

    private DFAStateNodeBuilder createInitialStateBackward(NFAStateTransition ... entries) {
        ObjectArrayBuffer<NFAStateTransition> transitionSet = this.compilationBuffer.getObjectBuffer1();
        StateSet stateSet = StateSet.create(this.nfa);
        CodePointSet cps = null;
        GroupBoundaries groupBoundaries = null;
        for (NFAStateTransition entry : entries) {
            for (NFAStateTransition predecessor : (NFAStateTransition[])((NFAState)entry.getTarget(false)).getPredecessors()) {
                if (groupBoundaries == null) {
                    cps = predecessor.getCodePointSet();
                    groupBoundaries = predecessor.getGroupBoundaries();
                } else if (!predecessor.getGroupBoundaries().equals(groupBoundaries) || !predecessor.getCodePointSet().equals(cps)) {
                    this.hasAmbiguousStates = true;
                }
                stateSet.add((NFAState)predecessor.getTarget(false));
                transitionSet.add(predecessor);
            }
        }
        return this.createInitialState(this.createTransitionBuilder(new TransitionSet((AbstractTransition[])((NFAStateTransition[])transitionSet.toArray(NFAStateTransition[]::new)), stateSet)));
    }

    private DFAStateNodeBuilder createInitialState(DFAStateTransitionBuilder transition) {
        DFAStateNodeBuilder lookup = this.lookupState(transition.getTransitionSet(), false);
        if (lookup == null) {
            lookup = this.createState(transition.getTransitionSet(), false, true);
            lookup.updateFinalStateData(this);
            if (this.isGenericCG()) {
                lookup.incPredecessors();
            }
        }
        transition.setTarget(lookup);
        return lookup;
    }

    private void expandState(DFAStateNodeBuilder state) {
        if (this.pruneUnambiguousPaths && this.tryPruneTraceFinderState(state)) {
            return;
        }
        boolean anyPrefixStateSuccessors = false;
        boolean allPrefixStateSuccessors = true;
        block0: for (NFAStateTransition transition : (NFAStateTransition[])state.getNfaTransitionSet().getTransitions()) {
            NFAState nFAState = (NFAState)transition.getTarget(this.isForward());
            if (this.isForward()) {
                for (NFAStateTransition nfaTransition : (NFAStateTransition[])nFAState.getSuccessors(true)) {
                    NFAState target = (NFAState)nfaTransition.getTarget(true);
                    if (!target.isFinalState(true)) {
                        this.canonicalizer.addArgument(nfaTransition, nfaTransition.getCodePointSet(), nfaTransition.getConstraints(), nfaTransition.getOperations());
                        continue;
                    }
                    if (!target.isUnAnchoredFinalState() || nfaTransition.getConstraints().length != 0) continue;
                    assert (target == this.nfa.getReverseUnAnchoredEntry().getSource());
                    break block0;
                }
                continue;
            }
            if (nFAState.isFinalState(false) || state.isBackwardPrefixState() && !nFAState.hasPrefixStates()) continue;
            for (NFAStateTransition nfaTransition : (NFAStateTransition[])nFAState.getSuccessors(false)) {
                anyPrefixStateSuccessors |= nFAState.hasPrefixStates();
                allPrefixStateSuccessors &= nFAState.hasPrefixStates();
                this.canonicalizer.addArgument(nfaTransition, nfaTransition.getCodePointSet(), nfaTransition.getConstraints(), nfaTransition.getOperations());
            }
        }
        if (!this.isForward() && anyPrefixStateSuccessors) {
            if (allPrefixStateSuccessors) {
                state.setBackwardPrefixState((short)state.getId());
            } else {
                assert (!state.isBackwardPrefixState());
                DFAStateNodeBuilder lookup = this.lookupState(state.getNfaTransitionSet(), true);
                if (lookup == null) {
                    lookup = this.createState(state.getNfaTransitionSet(), true, false);
                }
                state.setBackwardPrefixState((short)lookup.getId());
            }
        }
        AbstractTransition[] transitions = (DFAStateTransitionBuilder[])this.canonicalizer.run(this.compilationBuffer);
        Arrays.sort(transitions, Comparator.comparing(TransitionBuilder::getCodePointSet));
        for (DFAStateTransitionBuilder dFAStateTransitionBuilder : transitions) {
            assert (!dFAStateTransitionBuilder.getTransitionSet().isEmpty());
            dFAStateTransitionBuilder.setId(this.transitionIDCounter.inc());
            dFAStateTransitionBuilder.setSource(state);
            DFAStateNodeBuilder successorState = this.lookupState(dFAStateTransitionBuilder.getTransitionSet(), state.isBackwardPrefixState());
            if (successorState == null) {
                successorState = this.createState(dFAStateTransitionBuilder.getTransitionSet(), state.isBackwardPrefixState(), false);
            } else if (this.pruneUnambiguousPaths) {
                this.reScheduleFinalStateSuccessors(state, successorState);
            }
            if (this.pruneUnambiguousPaths && (state.isUnAnchoredFinalState() || state.isFinalStateSuccessor())) {
                state.setFinalStateSuccessor();
                successorState.setFinalStateSuccessor();
            }
            dFAStateTransitionBuilder.setTarget(successorState);
            successorState.updateFinalStateData(this);
            if (this.trackPredecessors()) {
                dFAStateTransitionBuilder.getTarget().incPredecessors();
            }
            if (!state.isUnAnchoredFinalState() || successorState == state) continue;
            this.simpleCGMustCopy = true;
        }
        state.setSuccessors(transitions);
    }

    private DFAStateTransitionBuilder createTransitionBuilder(TransitionSet<NFA, NFAState, NFAStateTransition> transitionSet) {
        if (this.isGenericCG()) {
            return new DFACaptureGroupTransitionBuilder(transitionSet, null, TransitionConstraint.NO_CONSTRAINTS, TransitionOp.NO_OP, this);
        }
        return new DFAStateTransitionBuilder(transitionSet, null, TransitionConstraint.NO_CONSTRAINTS, TransitionOp.NO_OP);
    }

    private TransitionSet<NFA, NFAState, NFAStateTransition> createNFATransitionSet(NFAStateTransition initialTransition) {
        return new TransitionSet((AbstractTransition[])new NFAStateTransition[]{initialTransition}, StateSet.create(this.nfa, (NFAState)initialTransition.getTarget(this.isForward())));
    }

    private TransitionSet<NFA, NFAState, NFAStateTransition> createNFATransitionSet(NFAStateTransition t1, NFAStateTransition t2) {
        if (t1 == t2) {
            return this.createNFATransitionSet(t1);
        }
        StateSet<NFA, NFAState> targetStateSet = StateSet.create(this.nfa, (NFAState)t1.getTarget(this.isForward()));
        targetStateSet.add((NFAState)t2.getTarget(this.isForward()));
        return new TransitionSet((AbstractTransition[])new NFAStateTransition[]{t1, t2}, targetStateSet);
    }

    private boolean tryPruneTraceFinderState(DFAStateNodeBuilder state) {
        assert (this.nfa.isTraceFinderNFA());
        if (state.isFinalStateSuccessor()) {
            return false;
        }
        PreCalculatedResultFactory result = null;
        int resultIndex = -1;
        assert (!state.getNfaTransitionSet().isEmpty());
        for (NFAStateTransition transition : (NFAStateTransition[])state.getNfaTransitionSet().getTransitions()) {
            NFAState nfaState = (NFAState)transition.getTarget(this.isForward());
            PrimitiveIterator.OfInt ofInt = nfaState.getPossibleResults().iterator();
            while (ofInt.hasNext()) {
                int i = (Integer)ofInt.next();
                if (result == null) {
                    result = this.nfa.getPreCalculatedResults()[i];
                    resultIndex = (byte)i;
                    continue;
                }
                if (result == this.nfa.getPreCalculatedResults()[i]) continue;
                return false;
            }
        }
        if (resultIndex >= 0) {
            state.setOverrideFinalState(true);
            state.updatePreCalcUnAnchoredResult(resultIndex);
            state.setSuccessors(EMPTY_TRANSITIONS_ARRAY);
            return true;
        }
        return false;
    }

    private void reScheduleFinalStateSuccessors(DFAStateNodeBuilder state, DFAStateNodeBuilder successorState) {
        assert (this.nfa.isTraceFinderNFA());
        if ((state.isUnAnchoredFinalState() || state.isFinalStateSuccessor()) && !successorState.isFinalStateSuccessor()) {
            this.reScheduleFinalStateSuccessor(successorState);
            this.bfsTraversalCur.clear();
            if (successorState.getSuccessors() != null) {
                this.bfsTraversalCur.add((DFAStateTransitionBuilder[])successorState.getSuccessors());
            }
            while (!this.bfsTraversalCur.isEmpty()) {
                this.bfsTraversalNext.clear();
                for (DFAStateTransitionBuilder[] cur : this.bfsTraversalCur) {
                    for (DFAStateTransitionBuilder t : cur) {
                        if (t.getTarget().isFinalStateSuccessor()) continue;
                        this.bfsExpand(t.getTarget());
                        this.reScheduleFinalStateSuccessor(t.getTarget());
                    }
                }
                this.bfsSwapLists();
            }
        }
    }

    private void reScheduleFinalStateSuccessor(DFAStateNodeBuilder finalStateSuccessor) {
        finalStateSuccessor.setFinalStateSuccessor();
        finalStateSuccessor.setOverrideFinalState(false);
        finalStateSuccessor.clearPreCalculatedResults();
        finalStateSuccessor.updateFinalStateData(this);
        this.expansionQueue.push(finalStateSuccessor);
    }

    private DFAStateNodeBuilder lookupState(TransitionSet<NFA, NFAState, NFAStateTransition> transitionSet, boolean isBackWardPrefixState) {
        this.lookupDummyState.setNfaTransitionSet(transitionSet);
        this.lookupDummyState.setIsBackwardPrefixState(isBackWardPrefixState);
        return this.stateMap.get(this.lookupDummyState);
    }

    private DFAStateNodeBuilder createState(TransitionSet<NFA, NFAState, NFAStateTransition> transitionSet, boolean isBackwardPrefixState, boolean isInitialState) {
        assert (this.stateIndexMap == null) : "state index map created before dfa generation!";
        short s = this.nextID;
        this.nextID = (short)(s + 1);
        DFAStateNodeBuilder dfaState = new DFAStateNodeBuilder(s, transitionSet, isBackwardPrefixState, isInitialState, this.isForward(), this.isForward() && !this.isBooleanMatch());
        this.stateMap.put(dfaState, dfaState);
        if (this.stateMap.size() + (this.isForward() ? this.expansionQueue.size() : 0) > 1300) {
            throw new UnsupportedRegexException((this.isForward() ? (this.isGenericCG() ? "CG" : "Forward") : "Backward") + " DFA explosion");
        }
        if (!this.hasAmbiguousStates && (transitionSet.size() > 2 || transitionSet.size() == 2 && transitionSet.getTransition(1) != this.nfa.getInitialLoopBackTransition())) {
            this.hasAmbiguousStates = true;
        }
        if (!this.isBooleanMatch() || !dfaState.updateFinalStateData(this).isUnAnchoredFinalState()) {
            this.expansionQueue.push(dfaState);
        }
        return dfaState;
    }

    private void optimizeDFA() {
        RegexProperties props = this.nfa.getAst().getProperties();
        Group root = this.nfa.getAst().getRoot();
        boolean doSimpleCGBackward = !(props.hasQuantifiers() || props.hasEmptyCaptureGroups() || root.hasCaret() && !root.startsWithCaret() || root.hasDollar() && !root.endsWithDollar());
        this.doSimpleCG = !(!this.isForward() && !doSimpleCGBackward || this.isBooleanMatch() || !this.executorProps.isAllowSimpleCG() || this.hasAmbiguousStates || this.nfa.isTraceFinderNFA() || this.isGenericCG() || props.hasQuantifiers() || !this.isSearching() && !props.hasCaptureGroups() || !props.hasAlternations() && !props.hasLookAroundAssertions());
        this.tryInnerLiteralOptimization();
    }

    private void tryInnerLiteralOptimization() {
        RegexProperties props = this.nfa.getAst().getProperties();
        if (!this.isForward() || !this.isSearching() || this.isGenericCG() || this.nfa.getAst().getFlags().isSticky() || !props.hasInnerLiteral() || this.getUnanchoredInitialState() == null) {
            return;
        }
        int literalEnd = props.getInnerLiteralEnd();
        int literalStart = props.getInnerLiteralStart();
        Sequence rootSeq = this.nfa.getAst().getRoot().getFirstAlternative();
        boolean boundedQuantifiersInPrefix = false;
        boolean maybeOverlappingLookArounds = false;
        StateSet<RegexAST, RegexASTNode> prefixAstNodes = StateSet.create(this.nfa.getAst());
        for (int i = 0; i < literalStart; ++i) {
            Term t = rootSeq.getTerms().get(i);
            boundedQuantifiersInPrefix |= t.hasQuantifiers();
            maybeOverlappingLookArounds |= t.hasLookArounds();
            AddToSetVisitor.addCharacterClasses(prefixAstNodes, t);
        }
        if (boundedQuantifiersInPrefix) {
            return;
        }
        boolean lookBehindsAfterLiteral = false;
        for (int i = literalEnd; i < rootSeq.size(); ++i) {
            Term t = rootSeq.getTerms().get(i);
            lookBehindsAfterLiteral |= t.hasLookBehinds();
        }
        maybeOverlappingLookArounds |= lookBehindsAfterLiteral;
        StateSet<NFA, NFAState> prefixNFAStates = StateSet.create(this.nfa);
        NFAState unAnchoredInitialState = this.nfa.getMaxOffsetUnAnchoredInitialState();
        if (unAnchoredInitialState != null) {
            prefixNFAStates.add(unAnchoredInitialState);
        }
        NFAState literalFirstState = null;
        NFAState literalLastState = null;
        for (NFAState s : this.nfa.getStates()) {
            if (s == null) continue;
            if (!maybeOverlappingLookArounds && !s.getStateSet().isEmpty() && prefixAstNodes.containsAll(s.getStateSet())) {
                prefixNFAStates.add(s);
            }
            if (s.getStateSet().contains(rootSeq.getTerms().get(literalStart))) {
                if (literalFirstState != null) {
                    return;
                }
                literalFirstState = s;
            }
            if (!s.getStateSet().contains(rootSeq.getTerms().get(literalEnd - 1))) continue;
            if (literalLastState != null) {
                return;
            }
            literalLastState = s;
        }
        if (maybeOverlappingLookArounds) {
            ArrayList<NFAState> bfsCur = new ArrayList<NFAState>(prefixNFAStates);
            ArrayList<NFAState> bfsNext = new ArrayList<NFAState>();
            NFAState anchoredInitialState = this.nfa.getMaxOffsetAnchoredInitialState();
            if (anchoredInitialState != null) {
                bfsCur.add(anchoredInitialState);
            }
            while (!bfsCur.isEmpty()) {
                for (NFAState nFAState : bfsCur) {
                    for (NFAStateTransition t : (NFAStateTransition[])nFAState.getSuccessors()) {
                        NFAState target = t.getTarget();
                        if (target == literalFirstState || !prefixNFAStates.add(target)) continue;
                        bfsNext.add(target);
                    }
                }
                ArrayList<NFAState> tmp = bfsCur;
                bfsCur = bfsNext;
                bfsNext = tmp;
                bfsNext.clear();
            }
        }
        if (literalFirstState == null || literalLastState == null) {
            return;
        }
        DFAStateNodeBuilder literalFirstDFAState = null;
        BasicState literalLastDFAState = null;
        DFAStateNodeBuilder unanchoredInitialState = this.getUnanchoredInitialState();
        TBitSet visited = new TBitSet(this.nextID);
        visited.set(unanchoredInitialState.getId());
        this.bfsTraversalCur.clear();
        this.bfsTraversalCur.add((DFAStateTransitionBuilder[])unanchoredInitialState.getSuccessors());
        block6: while (!this.bfsTraversalCur.isEmpty()) {
            this.bfsTraversalNext.clear();
            for (DFAStateTransitionBuilder[] dFAStateTransitionBuilderArray : this.bfsTraversalCur) {
                for (DFAStateTransitionBuilder t : dFAStateTransitionBuilderArray) {
                    DFAStateNodeBuilder target = t.getTarget();
                    if (visited.get(target.getId())) continue;
                    visited.set(target.getId());
                    StateSet<NFA, NFAState> targetStateSet = target.getNfaTransitionSet().getTargetStateSet();
                    if (literalFirstDFAState == null && targetStateSet.contains(literalFirstState)) {
                        literalFirstDFAState = target;
                    }
                    if (targetStateSet.contains(literalLastState)) {
                        literalLastDFAState = target;
                        this.bfsTraversalNext.clear();
                        break block6;
                    }
                    this.bfsExpand(target);
                }
            }
            this.bfsSwapLists();
        }
        if (literalFirstDFAState == null || literalLastDFAState == null) {
            return;
        }
        if (literalStart > 0 || lookBehindsAfterLiteral) {
            this.nfa.setInitialLoopBack(false);
            if (this.innerLiteralMatchesPrefix(prefixNFAStates)) {
                this.nfa.setInitialLoopBack(true);
                return;
            }
            this.nfa.setInitialLoopBack(true);
            CodePointSetAccumulator codePointSetAccumulator = this.compilationBuffer.getCodePointSetAccumulator1();
            for (DFAStateNodeBuilder s : this.stateMap.values()) {
                codePointSetAccumulator.clear();
                if (prefixNFAStates.containsAll(s.getNfaTransitionSet().getTargetStateSet())) continue;
                TransitionBuilder mergedTransition = null;
                ObjectArrayBuffer<DFAStateTransitionBuilder> newTransitions = null;
                for (int i = 0; i < ((DFAStateTransitionBuilder[])s.getSuccessors()).length; ++i) {
                    DFAStateTransitionBuilder t = ((DFAStateTransitionBuilder[])s.getSuccessors())[i];
                    if (t.hasNoConstraints() && prefixNFAStates.containsAll(t.getTarget().getNfaTransitionSet().getTargetStateSet())) {
                        if (mergedTransition == null) {
                            if (this.trackPredecessors()) {
                                t.getTarget().decPredecessors();
                                unanchoredInitialState.incPredecessors();
                            }
                            t.setTarget(unanchoredInitialState);
                            mergedTransition = t;
                            continue;
                        }
                        if (newTransitions == null) {
                            newTransitions = this.compilationBuffer.getObjectBuffer1();
                            newTransitions.addAll(s.getSuccessors(), 0, i);
                            codePointSetAccumulator.addSet(mergedTransition.getCodePointSet());
                            codePointSetAccumulator.addSet(t.getCodePointSet());
                            continue;
                        }
                        codePointSetAccumulator.addSet(t.getCodePointSet());
                        continue;
                    }
                    if (newTransitions == null) continue;
                    newTransitions.add(t);
                }
                if (newTransitions == null || mergedTransition == null) continue;
                mergedTransition.setMatcherBuilder(codePointSetAccumulator.toCodePointSet());
                s.setSuccessors(newTransitions.toArray(new DFAStateTransitionBuilder[newTransitions.length()]));
                Arrays.sort((DFAStateTransitionBuilder[])s.getSuccessors(), Comparator.comparing(TransitionBuilder::getCodePointSet));
            }
            this.nfa.setInitialLoopBack(false);
            NFAState nFAState = this.nfa.getReverseAnchoredEntry().getSource();
            NFAState reverseUnAnchoredInitialState = this.nfa.getReverseUnAnchoredEntry().getSource();
            this.nfa.getReverseAnchoredEntry().setSource(literalFirstState);
            this.nfa.getReverseUnAnchoredEntry().setSource(literalFirstState);
            assert (this.innerLiteralPrefixMatcher == null);
            int minResultLength = rootSeq.getTerms().get(literalStart).getMinPath() - 1;
            this.innerLiteralPrefixMatcher = this.compilationRequest.createDFAExecutor(this.nfa, new TRegexDFAExecutorProperties(false, false, false, this.doSimpleCG, false, minResultLength), "innerLiteralPrefix");
            this.innerLiteralPrefixMatcher.getProperties().setSimpleCGMustCopy(false);
            this.doSimpleCG = this.doSimpleCG && this.innerLiteralPrefixMatcher.isSimpleCG();
            this.nfa.setInitialLoopBack(true);
            this.nfa.getReverseAnchoredEntry().setSource(nFAState);
            this.nfa.getReverseUnAnchoredEntry().setSource(reverseUnAnchoredInitialState);
        }
        this.executorProps.setCanFindStart(this.innerLiteralCanFindMatchStart(unanchoredInitialState, (DFAStateNodeBuilder)literalLastDFAState));
        this.registerStateReplacement(unanchoredInitialState.getId(), new DFAFindInnerLiteralStateNode((short)unanchoredInitialState.getId(), new short[]{(short)literalLastDFAState.getId()}, this.nfa.getAst().extractInnerLiteral()));
    }

    private boolean innerLiteralCanFindMatchStart(DFAStateNodeBuilder unanchoredInitialState, DFAStateNodeBuilder literalLastDFAState) {
        if (!literalLastDFAState.getNfaTransitionSet().getTargetStateSet().isDisjoint(this.nfaFirstStates)) {
            return false;
        }
        TBitSet visited = new TBitSet(this.nextID);
        visited.set(literalLastDFAState.getId());
        visited.set(unanchoredInitialState.getId());
        this.bfsTraversalCur.clear();
        this.bfsTraversalCur.add((DFAStateTransitionBuilder[])literalLastDFAState.getSuccessors());
        while (!this.bfsTraversalCur.isEmpty()) {
            this.bfsTraversalNext.clear();
            for (DFAStateTransitionBuilder[] cur : this.bfsTraversalCur) {
                for (DFAStateTransitionBuilder t : cur) {
                    DFAStateNodeBuilder target = t.getTarget();
                    if (visited.get(target.getId())) continue;
                    visited.set(target.getId());
                    if (!target.getNfaTransitionSet().getTargetStateSet().isDisjoint(this.nfaFirstStates)) {
                        this.bfsTraversalNext.clear();
                        return false;
                    }
                    this.bfsExpand(target);
                }
            }
            this.bfsSwapLists();
        }
        return true;
    }

    private boolean innerLiteralMatchesPrefix(StateSet<NFA, NFAState> prefixNFAStates) {
        if (this.innerLiteralTryMatchPrefix(prefixNFAStates, this.getMaxOffsetAnchoredInitialState().getNfaTransitionSet().getTargetStateSet().copy())) {
            return true;
        }
        for (NFAState s : prefixNFAStates) {
            StateSet<NFA, NFAState> start = StateSet.create(this.nfa);
            start.add(s);
            if (!this.innerLiteralTryMatchPrefix(prefixNFAStates, start)) continue;
            return true;
        }
        return false;
    }

    private boolean innerLiteralTryMatchPrefix(StateSet<NFA, NFAState> prefixNFAStates, StateSet<NFA, NFAState> start) {
        int literalEnd = this.nfa.getAst().getProperties().getInnerLiteralEnd();
        int literalStart = this.nfa.getAst().getProperties().getInnerLiteralStart();
        Sequence rootSeq = this.nfa.getAst().getRoot().getFirstAlternative();
        StateSet<NFA, NFAState> curState = start.copy();
        StateSet<NFA, Object> nextState = StateSet.create(this.nfa);
        for (int i = literalStart; i < literalEnd; ++i) {
            CodePointSet c = ((CharacterClass)rootSeq.getTerms().get(i)).getCharSet();
            for (NFAState s : curState) {
                for (NFAStateTransition t : (NFAStateTransition[])s.getSuccessors()) {
                    if (i == literalStart && !prefixNFAStates.contains(t.getTarget()) || !c.intersects(t.getCodePointSet())) continue;
                    nextState.add(t.getTarget());
                }
            }
            if (nextState.isEmpty()) {
                return false;
            }
            StateSet<NFA, NFAState> tmp = curState;
            curState = nextState;
            nextState = tmp;
            nextState.clear();
        }
        return true;
    }

    private void registerStateReplacement(int id, DFAAbstractStateNode replacement) {
        if (this.stateReplacements == null) {
            this.stateReplacements = EconomicMap.create();
        }
        this.stateReplacements.put((Object)id, (Object)replacement);
    }

    private DFAAbstractStateNode getReplacement(int id) {
        return this.stateReplacements == null ? null : (DFAAbstractStateNode)this.stateReplacements.get((Object)id);
    }

    private ObjectArrayBuffer<DFAAbstractNode> createDFAExecutorStates() {
        if (this.isGenericCG()) {
            this.initialCGTransitions = new DFACaptureGroupTransitionBuilder[this.entryStates.length];
            for (DFAStateNodeBuilder s : this.stateMap.values()) {
                if (!s.isInitialState()) continue;
                DFACaptureGroupTransitionBuilder dFACaptureGroupTransitionBuilder = this.createInitialCGTransition(s);
                s.addPredecessorUnchecked(dFACaptureGroupTransitionBuilder);
                for (int i = 0; i < this.entryStates.length; ++i) {
                    if (this.entryStates[i] != s) continue;
                    assert (this.initialCGTransitions[i] == null);
                    this.initialCGTransitions[i] = dFACaptureGroupTransitionBuilder;
                }
            }
        }
        if (this.trackPredecessors()) {
            for (DFAStateNodeBuilder s : this.stateMap.values()) {
                for (DFAStateTransitionBuilder t : (DFAStateTransitionBuilder[])s.getSuccessors()) {
                    t.getTarget().addPredecessor(t);
                }
            }
        }
        ObjectArrayBuffer<DFAAbstractNode> nodes = new ObjectArrayBuffer<DFAAbstractNode>(this.stateMap.size() + 1);
        nodes.setLength(this.stateMap.size() + 1);
        this.optimizeBoundedQuantifierDataMapping();
        this.createBQTransitions(nodes);
        boolean utf16MustDecode = false;
        ObjectArrayBuffer<ObjectArrayBuffer<long[]>> objectArrayBuffer = new ObjectArrayBuffer<ObjectArrayBuffer<long[]>>();
        for (DFAStateNodeBuilder s : this.stateMap.values()) {
            DFAStateNode stateNode;
            int nSuccessors;
            this.matchersBuilder.reset(((DFAStateTransitionBuilder[])s.getSuccessors()).length);
            objectArrayBuffer.clear();
            assert (s.getId() <= Short.MAX_VALUE);
            short id = (short)s.getId();
            DFAAbstractStateNode replacement = this.getReplacement(id);
            if (replacement != null) {
                nodes.set(id, replacement);
                continue;
            }
            int nRanges = 0;
            int estimatedTransitionsCost = 0;
            boolean coversCharSpace = s.coversFullCharSpace(this.compilationBuffer);
            boolean anyConstraints = false;
            boolean anyOps = false;
            for (int i = 0; i < ((DFAStateTransitionBuilder[])s.getSuccessors()).length; ++i) {
                DFAStateTransitionBuilder t = ((DFAStateTransitionBuilder[])s.getSuccessors())[i];
                anyConstraints |= t.hasConstraints();
                anyOps |= t.hasOperations();
                utf16MustDecode |= Constants.ASTRAL_SYMBOLS_AND_LONE_SURROGATES.intersects(t.getCodePointSet());
                if (!this.trackBoundedQuantifiers()) continue;
                if (i == 0 || !t.getCodePointSet().equals(((DFAStateTransitionBuilder[])s.getSuccessors())[i - 1].getCodePointSet())) {
                    objectArrayBuffer.ensureCapacity(objectArrayBuffer.length() + 1);
                    objectArrayBuffer.setLength(objectArrayBuffer.length() + 1);
                    if (objectArrayBuffer.peek() == null) {
                        objectArrayBuffer.set(objectArrayBuffer.length() - 1, new ObjectArrayBuffer());
                    } else {
                        objectArrayBuffer.peek().clear();
                    }
                }
                objectArrayBuffer.peek().add(t.getConstraints());
            }
            assert (!this.trackBoundedQuantifiers() || DFAGenerator.noOverlappingCharacterMatchersAfterDeduplication(s, objectArrayBuffer));
            int n = nSuccessors = this.trackBoundedQuantifiers() ? objectArrayBuffer.length() : ((DFAStateTransitionBuilder[])s.getSuccessors()).length;
            short[] successors = nSuccessors > 0 || s.hasBackwardPrefixState() ? new short[nSuccessors + (s.hasBackwardPrefixState() ? 1 : 0)] : EmptyArrays.SHORT;
            short indexOfNodeId = -1;
            byte indexOfIsFast = 0;
            short loopToSelf = -1;
            int iT = 0;
            for (int i = 0; i < nSuccessors; ++i) {
                DFAStateTransitionBuilder t = ((DFAStateTransitionBuilder[])s.getSuccessors())[iT];
                CodePointSet cps = t.getCodePointSet();
                if (!anyConstraints && t.getTarget().getId() == id && t.getOperations().length == 0) {
                    TruffleString.CodePointSet indexOfParam;
                    loopToSelf = (short)i;
                    CodePointSet loopMB = t.getCodePointSet();
                    CodePointSet inverse = loopMB.createInverse(this.getEncoding());
                    if (!(!coversCharSpace || loopMB.matchesEverything(this.getEncoding()) || this.getEncoding() == Encodings.UTF_16 && inverse.intersects(Constants.SURROGATES) || (indexOfIsFast = DFAGenerator.checkIndexOfIsFast(indexOfParam = TruffleString.CodePointSet.fromRanges((int[])inverse.getRanges(), (TruffleString.Encoding)this.getEncoding().getTStringEncoding()))) == 0)) {
                        this.indexOfParams.add(indexOfParam);
                        assert (this.indexOfParams.size() <= Short.MAX_VALUE);
                        indexOfNodeId = (short)(this.indexOfParams.size() - 1);
                    }
                }
                if (i == nSuccessors - 1 && (coversCharSpace || this.pruneUnambiguousPaths && !s.isFinalStateSuccessor())) {
                    this.matchersBuilder.setNoMatchSuccessor((short)i);
                } else {
                    nRanges += cps.size();
                    this.getEncoding().createMatcher(this.matchersBuilder, i, cps, this.compilationBuffer);
                }
                estimatedTransitionsCost += this.matchersBuilder.estimatedCost(i);
                if (this.doSimpleCG) {
                    assert (t.getTransitionSet().size() <= 2);
                    assert (t.getTransitionSet().size() == 1 || t.getTransitionSet().getTransition(0) != this.nfa.getInitialLoopBackTransition());
                    successors[i] = this.createAndDedupSimpleCGTransition(nodes, (short)t.getTarget().getId(), (NFAStateTransition)t.getTransitionSet().getTransition(0));
                } else if (this.trackBoundedQuantifiers()) {
                    assert (!objectArrayBuffer.get(i).isEmpty());
                    if (objectArrayBuffer.get(i).length() == 1 && objectArrayBuffer.get(i).peek().length == 0) {
                        successors[i] = t.getBqSuccessor();
                    } else {
                        long[][] tConstraints = (long[][])objectArrayBuffer.get(i).toArray(x$0 -> new long[x$0][]);
                        short[] tSuccessors = new short[tConstraints.length];
                        for (int j = 0; j < tConstraints.length; ++j) {
                            tSuccessors[j] = ((DFAStateTransitionBuilder[])s.getSuccessors())[iT + j].getBqSuccessor();
                        }
                        short s2 = this.nextID;
                        this.nextID = (short)(s2 + 1);
                        successors[i] = DFAGenerator.insertNode(nodes, new DFABQTrackingTransitionConstraintsNode(s2, tSuccessors, tConstraints)).getId();
                    }
                } else {
                    successors[i] = (short)t.getTarget().getId();
                }
                assert (successors[i] >= 0 && successors[i] < nodes.length());
                iT += this.trackBoundedQuantifiers() ? objectArrayBuffer.get(i).length() : 1;
            }
            boolean useTreeTransitionMatcher = nRanges > 1 && MathUtil.log2ceil(nRanges + 2) * 8 < estimatedTransitionsCost && !anyConstraints;
            Matchers matchers = useTreeTransitionMatcher ? this.createAllTransitionsInOneTreeMatcher(s, coversCharSpace) : this.getEncoding().toMatchers(this.matchersBuilder);
            if (s.hasBackwardPrefixState()) {
                successors[successors.length - 1] = s.getBackwardPrefixState();
            }
            byte flags = DFAStateNode.buildFlags(s.isUnAnchoredFinalState(), s.isAnchoredFinalState(), s.hasBackwardPrefixState(), utf16MustDecode, s.isGuardedUnAnchoredFinalState(), s.isGuardedAnchoredFinalState());
            if (this.isGenericCG()) {
                stateNode = this.createCGTrackingDFAState(nodes, s, id, matchers, successors, indexOfNodeId, indexOfIsFast, loopToSelf, flags);
            } else if (this.nfa.isTraceFinderNFA()) {
                stateNode = new TraceFinderDFAStateNode(id, flags, loopToSelf, indexOfNodeId, indexOfIsFast, successors, matchers, s.getPreCalculatedUnAnchoredResult(), s.getPreCalculatedAnchoredResult());
            } else if (anyConstraints || anyOps || s.isGuardedFinalState()) {
                assert (this.isBooleanMatch());
                stateNode = new DFABQTrackingStateNode(id, flags, loopToSelf, indexOfNodeId, indexOfIsFast, successors, matchers, s.getUnAnchoredFinalConstraints(), s.getAnchoredFinalConstraints());
            } else {
                stateNode = this.doSimpleCG ? new DFASimpleCGTrackingStateNode(id, flags, loopToSelf, indexOfNodeId, indexOfIsFast, successors, matchers, this.createSimpleCGTransition((short)-1, (short)-1, s.getUnAnchoredFinalStateTransition()), this.createAndDedupSimpleCGTransition(nodes, (short)-1, s.getAnchoredFinalStateTransition())) : new DFAStateNode(id, flags, loopToSelf, indexOfNodeId, indexOfIsFast, successors, matchers, -1);
            }
            nodes.set(id, stateNode);
        }
        if (this.isGenericCG()) {
            for (DFAStateNodeBuilder s : this.stateMap.values()) {
                CGTrackingDFAStateNode cgTrackingStateNode = (CGTrackingDFAStateNode)nodes.get(s.getId());
                DFACaptureGroupLazyTransition[] lazyTransitions = s.getLazyTransitions();
                short[] successors = cgTrackingStateNode.getSuccessors();
                for (int i = 0; i < successors.length; ++i) {
                    successors[i] = this.dedupDFATransition(nodes, successors[i], CGTrackingTransitionNode.create(this.nextID, successors[i], lazyTransitions[i], this.getLazyTransitionBuilder(((DFAStateTransitionBuilder[])s.getSuccessors())[i]).getLastTransitionIndex()));
                }
            }
        }
        return nodes;
    }

    private static boolean noOverlappingCharacterMatchersAfterDeduplication(DFAStateNodeBuilder s, ObjectArrayBuffer<ObjectArrayBuffer<long[]>> constraints) {
        int iT = 0;
        for (int i = 0; i < constraints.length(); ++i) {
            int jT = 0;
            for (int j = 0; j < constraints.length(); ++j) {
                assert (i == j || !((DFAStateTransitionBuilder[])s.getSuccessors())[iT].getCodePointSet().intersects(((DFAStateTransitionBuilder[])s.getSuccessors())[jT].getCodePointSet()));
                jT += constraints.get(j).length();
            }
            iT += constraints.get(i).length();
        }
        return true;
    }

    private static byte checkIndexOfIsFast(TruffleString.CodePointSet indexOfParam) {
        byte indexOfIsFast = 0;
        for (TruffleString.CodeRange codeRange : TruffleString.CodeRange.values()) {
            if (!indexOfParam.isIntrinsicCandidate(codeRange)) continue;
            assert (codeRange.ordinal() < 8);
            indexOfIsFast = (byte)(indexOfIsFast | 1 << codeRange.ordinal());
        }
        return indexOfIsFast;
    }

    private CGTrackingDFAStateNode createCGTrackingDFAState(ObjectArrayBuffer<DFAAbstractNode> nodes, DFAStateNodeBuilder s, short id, Matchers matchers, short[] successors, short indexOfNodeId, byte indexOfIsFast, short loopToSelf, byte flags) {
        short preAnchoredFinalTransition;
        DFACaptureGroupLazyTransition lazyPreFinalTransition;
        DFACaptureGroupLazyTransition lazyPreAnchoredFinalTransition;
        int i;
        DFACaptureGroupLazyTransition[] lazyTransitions = new DFACaptureGroupLazyTransition[((DFAStateTransitionBuilder[])s.getSuccessors()).length];
        DFACaptureGroupLazyTransitionBuilder firstPredecessor = this.getLazyTransitionBuilder(((DFAStateTransitionBuilder[])s.getPredecessors())[0]);
        int nMaps = ((DFAStateTransitionBuilder[])s.getSuccessors()).length;
        int iTransitionToFinalState = firstPredecessor.getTransitionToFinalState() == null ? -1 : nMaps++;
        int iTransitionToAnchoredFinalState = firstPredecessor.getTransitionToAnchoredFinalState() == null ? -1 : nMaps++;
        EconomicMap[] maps = new EconomicMap[nMaps];
        int maxDedupSize = 0;
        for (i = 0; i < maps.length; ++i) {
            EconomicMap dedup;
            maps[i] = dedup = EconomicMap.create();
            for (int j = 0; j < ((DFAStateTransitionBuilder[])s.getPredecessors()).length; ++j) {
                DFACaptureGroupPartialTransition partialTransition;
                DFACaptureGroupLazyTransitionBuilder predecessor = this.getLazyTransitionBuilder(((DFAStateTransitionBuilder[])s.getPredecessors())[j]);
                assert (iTransitionToFinalState >= 0 || predecessor.getTransitionToFinalState() == null);
                assert (iTransitionToAnchoredFinalState >= 0 || predecessor.getTransitionToAnchoredFinalState() == null);
                if (i < predecessor.getPartialTransitions().length) {
                    partialTransition = predecessor.getPartialTransitions()[i];
                } else if (i == iTransitionToAnchoredFinalState) {
                    partialTransition = predecessor.getTransitionToAnchoredFinalState();
                } else {
                    assert (i == iTransitionToFinalState);
                    partialTransition = predecessor.getTransitionToFinalState();
                }
                assert (partialTransition != null);
                if (dedup.containsKey((Object)partialTransition)) {
                    ((ArrayList)dedup.get((Object)partialTransition)).add(j);
                    continue;
                }
                ArrayList<Integer> list = new ArrayList<Integer>();
                list.add(j);
                dedup.put((Object)partialTransition, list);
            }
            maxDedupSize = Math.max(maxDedupSize, dedup.size());
        }
        if (nMaps == 0 || maxDedupSize == 1) {
            for (DFAStateTransitionBuilder p : (DFAStateTransitionBuilder[])s.getPredecessors()) {
                this.getLazyTransitionBuilder(p).setLastTransitionIndex(-1);
            }
            lazyPreAnchoredFinalTransition = DFAGenerator.createSingleLazyTransition(maps, iTransitionToAnchoredFinalState);
            lazyPreFinalTransition = DFAGenerator.createSingleLazyTransition(maps, iTransitionToFinalState);
            for (i = 0; i < lazyTransitions.length; ++i) {
                lazyTransitions[i] = DFAGenerator.createSingleLazyTransition(maps, i);
            }
        } else if (DFAGenerator.allSameValues(maps)) {
            int iPartialTransition = 0;
            MapCursor cursor = maps[0].getEntries();
            while (cursor.advance()) {
                Iterator j = ((ArrayList)cursor.getValue()).iterator();
                while (j.hasNext()) {
                    int i2 = (Integer)j.next();
                    this.getLazyTransitionBuilder(((DFAStateTransitionBuilder[])s.getPredecessors())[i2]).setLastTransitionIndex(iPartialTransition);
                }
                ++iPartialTransition;
            }
            for (int i3 = 0; i3 < lazyTransitions.length; ++i3) {
                lazyTransitions[i3] = this.createBranchesDirect(s, maps, i3);
            }
            lazyPreAnchoredFinalTransition = this.createBranchesDirect(s, maps, iTransitionToAnchoredFinalState);
            lazyPreFinalTransition = this.createBranchesDirect(s, maps, iTransitionToFinalState);
        } else {
            for (i = 0; i < ((DFAStateTransitionBuilder[])s.getPredecessors()).length; ++i) {
                this.getLazyTransitionBuilder(((DFAStateTransitionBuilder[])s.getPredecessors())[i]).setLastTransitionIndex(i);
            }
            for (i = 0; i < lazyTransitions.length; ++i) {
                lazyTransitions[i] = this.createWithLookup(s, maps, i);
            }
            lazyPreAnchoredFinalTransition = this.createWithLookup(s, maps, iTransitionToAnchoredFinalState);
            lazyPreFinalTransition = this.createWithLookup(s, maps, iTransitionToFinalState);
        }
        s.setLazyTransitions(lazyTransitions);
        DFACaptureGroupPartialTransition cgLoopToSelf = null;
        boolean cgLoopToSelfHasDependency = false;
        if (loopToSelf >= 0) {
            cgLoopToSelf = this.getLazyTransitionBuilder(((DFAStateTransitionBuilder[])s.getSuccessors())[loopToSelf]).getPartialTransitions()[loopToSelf];
            cgLoopToSelfHasDependency = this.calcCGLoopToSelfDependency(cgLoopToSelf);
        }
        if (s.getAnchoredFinalStateTransition() == null) {
            preAnchoredFinalTransition = -1;
        } else {
            short anchoredFinalTransition = this.dedupDFATransition(nodes, (short)-1, new CGTrackingAnchoredFinalTransitionNode(this.nextID, this.createCGFinalTransition(s.getAnchoredFinalStateTransition())));
            preAnchoredFinalTransition = this.dedupDFATransition(nodes, anchoredFinalTransition, CGTrackingPreFinalTransitionNode.create(this.nextID, anchoredFinalTransition, lazyPreAnchoredFinalTransition));
        }
        return new CGTrackingDFAStateNode(id, flags, loopToSelf, indexOfNodeId, indexOfIsFast, successors, matchers, preAnchoredFinalTransition, lazyPreFinalTransition, this.createCGFinalTransition(s.getUnAnchoredFinalStateTransition()), cgLoopToSelf, cgLoopToSelfHasDependency);
    }

    /*
     * WARNING - void declaration
     */
    private boolean calcCGLoopToSelfDependency(DFACaptureGroupPartialTransition cgLoopToSelf) {
        void var7_10;
        byte[] arrayCopies = cgLoopToSelf.getArrayCopies();
        if (cgLoopToSelf.doesReorderResults() || arrayCopies.length == 0) {
            return false;
        }
        int maxArrayIndex = 0;
        for (byte by : arrayCopies) {
            maxArrayIndex = Math.max(maxArrayIndex, Byte.toUnsignedInt(by));
        }
        TBitSet[] updates = new TBitSet[maxArrayIndex + 1];
        DFACaptureGroupPartialTransition.IndexOperation[] indexOperationArray = cgLoopToSelf.getIndexUpdates();
        int n = indexOperationArray.length;
        boolean bl = false;
        while (var7_10 < n) {
            DFACaptureGroupPartialTransition.IndexOperation op = indexOperationArray[var7_10];
            if (op.getTargetArray() <= maxArrayIndex) {
                TBitSet bs = new TBitSet(this.nfa.getAst().getNumberOfCaptureGroups() * 2);
                for (int i = 0; i < op.getNumberOfIndices(); ++i) {
                    bs.set(op.getIndex(i));
                }
                assert (updates[op.getTargetArray()] == null);
                updates[op.getTargetArray()] = bs;
            }
            ++var7_10;
        }
        TBitSet cmp = new TBitSet(this.nfa.getAst().getNumberOfCaptureGroups() * 2);
        for (int i = 0; i < arrayCopies.length; i += 2) {
            int n2 = Byte.toUnsignedInt(arrayCopies[i]);
            int dst = Byte.toUnsignedInt(arrayCopies[i + 1]);
            if (updates[n2] == null) continue;
            if (updates[dst] == null) {
                return true;
            }
            cmp.clear();
            cmp.union(updates[n2]);
            cmp.subtract(updates[dst]);
            if (cmp.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private DFACaptureGroupLazyTransition createWithLookup(DFAStateNodeBuilder s, EconomicMap<DFACaptureGroupPartialTransition, ArrayList<Integer>>[] maps, int i) {
        if (i < 0) {
            return null;
        }
        EconomicMap<DFACaptureGroupPartialTransition, ArrayList<Integer>> map = maps[i];
        if (map.size() == 1) {
            return DFAGenerator.createSingleLazyTransition(maps, i);
        }
        DFACaptureGroupPartialTransition[] transitions = new DFACaptureGroupPartialTransition[map.size()];
        if (DFAGenerator.lookupTableRequired(map)) {
            if (map.size() > 255) {
                throw new UnsupportedRegexException("too many branches in capture group tracking DFA", this.getNfa().getAst().getSource());
            }
            byte[] lookupTable = new byte[((DFAStateTransitionBuilder[])s.getPredecessors()).length];
            MapCursor cursor = map.getEntries();
            int iCursor = 0;
            while (cursor.advance()) {
                transitions[iCursor] = (DFACaptureGroupPartialTransition)cursor.getKey();
                Iterator iterator = ((ArrayList)cursor.getValue()).iterator();
                while (iterator.hasNext()) {
                    int t = (Integer)iterator.next();
                    lookupTable[t] = (byte)iCursor;
                }
                ++iCursor;
            }
            return DFACaptureGroupLazyTransition.BranchesWithLookupTable.create(transitions, lookupTable);
        }
        short[] possibleValues = new short[map.size() - 1];
        MapCursor cursor = map.getEntries();
        int iCursor = 0;
        DFACaptureGroupPartialTransition last = null;
        while (cursor.advance()) {
            if (((ArrayList)cursor.getValue()).size() == 1 && iCursor < transitions.length - 1) {
                transitions[iCursor] = (DFACaptureGroupPartialTransition)cursor.getKey();
                possibleValues[iCursor] = ((Integer)((ArrayList)cursor.getValue()).get(0)).shortValue();
                ++iCursor;
                continue;
            }
            assert (last == null);
            last = (DFACaptureGroupPartialTransition)cursor.getKey();
        }
        if (last != null) {
            transitions[transitions.length - 1] = last;
        }
        return DFACaptureGroupLazyTransition.BranchesIndirect.create(transitions, possibleValues);
    }

    private static boolean lookupTableRequired(EconomicMap<DFACaptureGroupPartialTransition, ArrayList<Integer>> map) {
        boolean foundSizeGreaterOne = false;
        for (ArrayList l : map.getValues()) {
            if (l.size() <= 1) continue;
            if (foundSizeGreaterOne) {
                return true;
            }
            foundSizeGreaterOne = true;
        }
        return false;
    }

    private DFACaptureGroupLazyTransition.BranchesDirect createBranchesDirect(DFAStateNodeBuilder s, EconomicMap<DFACaptureGroupPartialTransition, ArrayList<Integer>>[] maps, int i) {
        if (i < 0) {
            return null;
        }
        DFACaptureGroupPartialTransition[] transitions = new DFACaptureGroupPartialTransition[maps[0].size()];
        MapCursor cursor = maps[i].getEntries();
        while (cursor.advance()) {
            short iT = this.getLazyTransitionBuilder(((DFAStateTransitionBuilder[])s.getPredecessors())[(Integer)((ArrayList)cursor.getValue()).get(0)]).getLastTransitionIndex();
            assert (iT >= 0);
            Iterator iterator = ((ArrayList)cursor.getValue()).iterator();
            while (iterator.hasNext()) {
                int j = (Integer)iterator.next();
                assert (this.getLazyTransitionBuilder(((DFAStateTransitionBuilder[])s.getPredecessors())[j]).getLastTransitionIndex() == iT);
            }
            assert (transitions[iT] == null);
            transitions[iT] = (DFACaptureGroupPartialTransition)cursor.getKey();
        }
        return DFACaptureGroupLazyTransition.BranchesDirect.create(transitions);
    }

    private static DFACaptureGroupLazyTransition.Single createSingleLazyTransition(EconomicMap<DFACaptureGroupPartialTransition, ArrayList<Integer>>[] maps, int i) {
        if (i < 0) {
            return null;
        }
        return DFACaptureGroupLazyTransition.Single.create((DFACaptureGroupPartialTransition)maps[i].getKeys().iterator().next());
    }

    private DFACaptureGroupTransitionBuilder createInitialCGTransition(DFAStateNodeBuilder target) {
        assert (target.isInitialState());
        DFACaptureGroupTransitionBuilder ret = new DFACaptureGroupTransitionBuilder(null, null, null, null, null);
        Object[] partialTransitions = new DFACaptureGroupPartialTransition[((DFAStateTransitionBuilder[])target.getSuccessors()).length];
        Arrays.fill(partialTransitions, DFACaptureGroupPartialTransition.getEmptyInstance());
        short id = (short)this.transitionIDCounter.inc();
        DFACaptureGroupLazyTransitionBuilder emptyInitialTransition = new DFACaptureGroupLazyTransitionBuilder(id, (DFACaptureGroupPartialTransition[])partialTransitions, target.isUnAnchoredFinalState() ? DFACaptureGroupPartialTransition.getEmptyInstance() : null, target.isAnchoredFinalState() ? DFACaptureGroupPartialTransition.getEmptyInstance() : null);
        ret.setId(id);
        ret.setLazyTransition(emptyInitialTransition);
        return ret;
    }

    private DFACaptureGroupLazyTransitionBuilder getLazyTransitionBuilder(DFAStateTransitionBuilder precedingTransitions) {
        return ((DFACaptureGroupTransitionBuilder)precedingTransitions).toLazyTransitionBuilder(this.compilationBuffer);
    }

    private static boolean allSameValues(EconomicMap<DFACaptureGroupPartialTransition, ArrayList<Integer>>[] maps) {
        for (int i = 1; i < maps.length; ++i) {
            if (maps[0].size() == maps[i].size()) continue;
            return false;
        }
        for (ArrayList value : maps[0].getValues()) {
            for (int i = 1; i < maps.length; ++i) {
                if (DFAGenerator.allSameValuesInner(maps[i], value)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean allSameValuesInner(EconomicMap<DFACaptureGroupPartialTransition, ArrayList<Integer>> map, ArrayList<Integer> value) {
        for (ArrayList v : map.getValues()) {
            if (!value.equals(v)) continue;
            return true;
        }
        return false;
    }

    private short createAndDedupSimpleCGTransition(ObjectArrayBuffer<DFAAbstractNode> nodes, short successor, NFAStateTransition nfaTransition) {
        return this.dedupDFATransition(nodes, successor, this.createSimpleCGTransition(this.nextID, successor, nfaTransition));
    }

    private DFASimpleCGTransition createSimpleCGTransition(short id, short successor, NFAStateTransition nfaTransition) {
        boolean fullClear = this.isForward() && nfaTransition != null && this.nfa.getInitialLoopBackTransition() != null && nfaTransition.getSource() == this.nfa.getInitialLoopBackTransition().getSource();
        boolean isFinalTransition = nfaTransition != null && ((NFAState)nfaTransition.getTarget(this.isForward())).isFinalState();
        return DFASimpleCGTransition.create(id, successor, nfaTransition, fullClear, isFinalTransition);
    }

    private short dedupDFATransition(ObjectArrayBuffer<DFAAbstractNode> nodes, short successor, DFAAbstractTransitionNode t) {
        if (t == null) {
            return successor;
        }
        DFAAbstractTransitionNode existing = this.dfaTransitionsDedupMap.get(t);
        if (existing == null) {
            this.nextID = (short)(this.nextID + 1);
            DFAGenerator.insertNode(nodes, t);
            this.dfaTransitionsDedupMap.put(t, t);
            return t.getId();
        }
        return existing.getId();
    }

    private static <T extends DFAAbstractNode> T insertNode(ObjectArrayBuffer<DFAAbstractNode> nodes, T t) {
        int length = Math.max(nodes.length(), t.getId() + 1);
        nodes.ensureCapacity(length);
        nodes.setLength(length);
        assert (nodes.get(t.getId()) == null);
        nodes.set(t.getId(), t);
        return t;
    }

    private AllTransitionsInOneTreeMatcher createAllTransitionsInOneTreeMatcher(DFAStateNodeBuilder state, boolean coversCharSpace) {
        DFAStateTransitionBuilder[] transitions = (DFAStateTransitionBuilder[])state.getSuccessors();
        CompressedCodePointSet[] ccpss = new CompressedCodePointSet[coversCharSpace ? transitions.length - 1 : transitions.length];
        for (int i = 0; i < ccpss.length; ++i) {
            ccpss[i] = CompressedCodePointSet.create(transitions[i].getCodePointSet(), this.compilationBuffer);
        }
        IntRangesBuffer ranges = this.compilationBuffer.getIntRangesBuffer1();
        IntArrayBuffer iterators = this.compilationBuffer.getIntRangesBuffer2().asFixedSizeArray(ccpss.length, 0);
        IntRangesBuffer byteRanges = this.compilationBuffer.getIntRangesBuffer3();
        ShortArrayBuffer successors = this.compilationBuffer.getShortArrayBuffer1();
        ShortArrayBuffer byteSuccessors = this.compilationBuffer.getShortArrayBuffer2();
        ObjectArrayBuffer<long[]> byteBitSets = this.compilationBuffer.getObjectBuffer1();
        ObjectArrayBuffer<AllTransitionsInOneTreeMatcher.AllTransitionsInOneTreeLeafMatcher> byteMatchers = this.compilationBuffer.getObjectBuffer2();
        short noMatchSuccessor = (short)(coversCharSpace ? transitions.length - 1 : -1);
        int lastHi = 0;
        while (true) {
            int i;
            int minLo = Integer.MAX_VALUE;
            int minCPS = -1;
            for (i = 0; i < ccpss.length; ++i) {
                if (iterators.get(i) >= ccpss[i].size() || ccpss[i].getLo(iterators.get(i)) >= minLo) continue;
                minLo = ccpss[i].getLo(iterators.get(i));
                minCPS = i;
            }
            if (minCPS == -1) break;
            if (minLo != lastHi) {
                successors.add(noMatchSuccessor);
                ranges.add(minLo);
            }
            lastHi = ccpss[minCPS].getHi(iterators.get(minCPS)) + 1;
            if (ccpss[minCPS].hasBitSet(iterators.get(minCPS))) {
                byteRanges.clear();
                byteSuccessors.clear();
                byteBitSets.clear();
                for (i = 0; i < ccpss.length; ++i) {
                    if (iterators.get(i) >= ccpss[i].size() || !ccpss[i].hasBitSet(iterators.get(i)) || BitSets.highByte(ccpss[i].getLo(iterators.get(i))) != BitSets.highByte(lastHi - 1)) continue;
                    byteBitSets.add(ccpss[i].getBitSet(iterators.get(i)));
                    lastHi = Math.max(lastHi, ccpss[i].getHi(iterators.get(i)) + 1);
                    iterators.inc(i);
                    byteSuccessors.add((short)i);
                }
                int byteLastHi = minLo;
                while (true) {
                    int byteMinLo = lastHi;
                    int byteMinCPS = -1;
                    for (int i2 = 0; i2 < ccpss.length; ++i2) {
                        if (iterators.get(i2) >= ccpss[i2].size() || ccpss[i2].getLo(iterators.get(i2)) >= byteMinLo) continue;
                        assert (!ccpss[i2].hasBitSet(iterators.get(i2)));
                        assert (ccpss[i2].getHi(iterators.get(i2)) < lastHi);
                        byteMinLo = ccpss[i2].getLo(iterators.get(i2));
                        byteMinCPS = i2;
                    }
                    if (byteMinCPS == -1) break;
                    if (byteMinLo != byteLastHi) {
                        byteSuccessors.add(noMatchSuccessor);
                        byteRanges.add(byteMinLo);
                    }
                    byteSuccessors.add((short)byteMinCPS);
                    byteLastHi = ccpss[byteMinCPS].getHi(iterators.get(byteMinCPS)) + 1;
                    if (byteLastHi < lastHi) {
                        byteRanges.add(byteLastHi);
                    }
                    iterators.inc(byteMinCPS);
                }
                if (byteLastHi != lastHi) {
                    byteSuccessors.add(noMatchSuccessor);
                }
                successors.add((short)((byteMatchers.length() + 2) * -1));
                byteMatchers.add(new AllTransitionsInOneTreeMatcher.AllTransitionsInOneTreeLeafMatcher((long[][])byteBitSets.toArray((ST[])new long[byteBitSets.length()][]), byteSuccessors.toArray(), byteRanges.toArray()));
            } else {
                successors.add((short)minCPS);
                iterators.inc(minCPS);
            }
            if (lastHi > this.getEncoding().getMaxValue()) continue;
            ranges.add(lastHi);
        }
        if (lastHi != this.getEncoding().getMaxValue() + 1) {
            successors.add(noMatchSuccessor);
        }
        return new AllTransitionsInOneTreeMatcher(ranges.toArray(), successors.toArray(), byteMatchers.toArray(new AllTransitionsInOneTreeMatcher.AllTransitionsInOneTreeLeafMatcher[byteMatchers.length()]));
    }

    private DFACaptureGroupPartialTransition createCGFinalTransition(NFAStateTransition transition) {
        if (transition == null) {
            return null;
        }
        GroupBoundaries groupBoundaries = transition.getGroupBoundaries();
        DFACaptureGroupPartialTransition.IndexOperation[] indexUpdates = DFACaptureGroupPartialTransition.EMPTY_INDEX_OPS;
        DFACaptureGroupPartialTransition.IndexOperation[] indexClears = DFACaptureGroupPartialTransition.EMPTY_INDEX_OPS;
        DFACaptureGroupPartialTransition.LastGroupUpdate[] lastGroupUpdates = DFACaptureGroupPartialTransition.EMPTY_LAST_GROUP_UPDATES;
        if (groupBoundaries.hasIndexUpdates()) {
            indexUpdates = new DFACaptureGroupPartialTransition.IndexOperation[]{new DFACaptureGroupPartialTransition.IndexOperation(0, groupBoundaries.updatesToByteArray())};
        }
        if (groupBoundaries.hasIndexClears()) {
            indexClears = new DFACaptureGroupPartialTransition.IndexOperation[]{new DFACaptureGroupPartialTransition.IndexOperation(0, groupBoundaries.clearsToByteArray())};
        }
        if (groupBoundaries.hasLastGroup()) {
            lastGroupUpdates = new DFACaptureGroupPartialTransition.LastGroupUpdate[]{new DFACaptureGroupPartialTransition.LastGroupUpdate(0, groupBoundaries.getLastGroup())};
        }
        DFACaptureGroupPartialTransition partialTransitionNode = DFACaptureGroupPartialTransition.create(this, DFACaptureGroupPartialTransition.EMPTY, DFACaptureGroupPartialTransition.EMPTY, indexUpdates, indexClears, lastGroupUpdates, (byte)0);
        if (this.debugMode()) {
            DFACaptureGroupTransitionBuilder.PartialTransitionDebugInfo debugInfo = new DFACaptureGroupTransitionBuilder.PartialTransitionDebugInfo(partialTransitionNode, 1);
            debugInfo.mapResultToNFATransition(0, transition);
            this.registerCGPartialTransitionDebugInfo(debugInfo);
        }
        return partialTransitionNode;
    }

    void updateMaxNumberOfNFAStatesInOneTransition(int value) {
        if (value > this.maxNumberOfNfaStates) {
            this.maxNumberOfNfaStates = value;
            if (this.maxNumberOfNfaStates > 255) {
                throw new UnsupportedRegexException("DFA transition size explosion");
            }
        }
    }

    private boolean debugMode() {
        return this.getOptions().isDumpAutomata() || this.getOptions().isStepExecution();
    }

    public String getDebugDumpName(String name) {
        return name == null ? this.getDebugDumpName() : name;
    }

    public String getDebugDumpName() {
        if (this.isForward()) {
            if (this.isGenericCG()) {
                if (this.isSearching()) {
                    return "eagerCG";
                }
                return "lazyCG";
            }
            return "forward";
        }
        if (this.nfa.isTraceFinderNFA()) {
            return "traceFinder";
        }
        return "backward";
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        if (this.isForward()) {
            this.nfa.setInitialLoopBack(this.isSearching() && !this.nfa.getAst().getFlags().isSticky());
        }
        DFAStateTransitionBuilder[] transitionList = new DFAStateTransitionBuilder[this.transitionIDCounter.getCount()];
        for (DFAStateNodeBuilder s : this.getStateIndexMap()) {
            if (s == null) continue;
            DFAStateTransitionBuilder[] dFAStateTransitionBuilderArray = (DFAStateTransitionBuilder[])s.getSuccessors();
            int n = dFAStateTransitionBuilderArray.length;
            for (int i = 0; i < n; ++i) {
                DFAStateTransitionBuilder t;
                transitionList[t.getId()] = t = dFAStateTransitionBuilderArray[i];
            }
        }
        return Json.obj(Json.prop("pattern", this.nfa.getAst().getSource().toString()), Json.prop("nfa", this.nfa.toJson(this.isForward())), Json.prop("dfa", Json.obj(Json.prop("states", Arrays.stream(this.getStateIndexMap())), Json.prop("transitions", Arrays.stream(transitionList)), Json.prop("captureGroupPartialTransitions", this.cgPartialTransitions), Json.prop("entryStates", Arrays.stream(this.entryStates).filter(Objects::nonNull).map(x -> Json.val(x.getId()))))));
    }

    private static final class QuantifierMappingBuilder {
        private final StateMapping[] stateMappings;
        private int maxMapSize = 0;
        private int[] newOrder;
        private int[] copySource;
        private TBitSet targetsUsed;
        private TBitSet copyTargets;
        private final LongArrayBuffer ops = new LongArrayBuffer();
        private final LongArrayBuffer opsSet1 = new LongArrayBuffer();

        private QuantifierMappingBuilder(StateMapping[] stateMappings) {
            this.stateMappings = stateMappings;
        }

        private void addState(DFAStateNodeBuilder state, NFAState mapState) {
            StateSet<NFA, NFAState> states = this.stateMappings[state.getId()].states;
            if (states.add(mapState)) {
                this.maxMapSize = Math.max(this.maxMapSize, states.size());
                if (this.maxMapSize > 255) {
                    throw new UnsupportedRegexException("too many parallel NFA states in one DFA state for bounded quantifier tracking");
                }
            }
        }

        private void initBuffers() {
            this.newOrder = new int[this.maxMapSize];
            this.copySource = new int[this.maxMapSize];
            this.targetsUsed = new TBitSet(this.maxMapSize);
            this.copyTargets = new TBitSet(this.maxMapSize);
        }

        private void resetBuffers() {
            Arrays.fill(this.newOrder, -1);
            Arrays.fill(this.copySource, -1);
            this.targetsUsed.clear();
            this.copyTargets.clear();
            this.opsSet1.clear();
            this.ops.clear();
        }

        private void scheduleOps() {
            if (this.ops.length() <= 1) {
                return;
            }
            for (int last = this.ops.length() - 1; last > 0; --last) {
                int toSchedule = this.scheduleOpsFindCandidate(last);
                if (toSchedule == -1) {
                    throw new UnsupportedRegexException("dependency cycle");
                }
                long tmp = this.ops.get(last);
                this.ops.set(last, this.ops.get(toSchedule));
                this.ops.set(toSchedule, tmp);
            }
        }

        private int scheduleOpsFindCandidate(int last) {
            block0: for (int i = 0; i <= last; ++i) {
                int source = TransitionOp.getSource(this.ops.get(i));
                for (int j = 0; j <= last; ++j) {
                    if (i != j && TransitionOp.getTarget(this.ops.get(j)) == source) continue block0;
                }
                return i;
            }
            return -1;
        }

        private void resolveDependencyCycle(int length) {
            int i;
            TBitSet[] unions = new TBitSet[this.maxMapSize];
            TBitSet[] inc = new TBitSet[this.maxMapSize];
            for (i = 0; i < length; ++i) {
                long op = this.ops.get(i);
                int kind = TransitionOp.getKind(op);
                int source = TransitionOp.getSource(op);
                int target = TransitionOp.getTarget(op);
                if (unions[target] == null) {
                    unions[target] = new TBitSet(this.maxMapSize);
                    inc[target] = new TBitSet(this.maxMapSize);
                }
                unions[target].set(source);
                if (TransitionOp.getModifier(op) == 2) {
                    unions[target].set(target);
                }
                if (kind != 1) continue;
                inc[target].set(source);
            }
            for (i = 0; i < unions.length; ++i) {
                TBitSet bs = unions[i];
                System.out.println("unions " + i + ": " + String.valueOf(bs));
            }
            for (i = 0; i < inc.length; ++i) {
                TBitSet bs = inc[i];
                System.out.println("inc " + i + ": " + String.valueOf(bs));
            }
        }
    }

    private static final class StateMapping {
        private final StateSet<NFA, NFAState> states;
        private StateSetToIntMap<NFAState, NFAStateTransition> mapping;

        private StateMapping(StateSet<NFA, NFAState> states) {
            this.states = states;
        }

        private boolean hasMapping() {
            return this.mapping != null;
        }

        private StateSetToIntMap<NFAState, NFAStateTransition> getMappingOrDefault() {
            if (this.mapping == null) {
                this.mapping = StateSetToIntMap.create(this.states);
                int i = 0;
                for (NFAState s : this.states) {
                    this.mapping.put(s, i++);
                }
            }
            return this.mapping;
        }

        private StateSetToIntMap<NFAState, NFAStateTransition> createMapping() {
            this.mapping = StateSetToIntMap.create(this.states);
            return this.mapping;
        }

        public StateSetToIntMap<NFAState, NFAStateTransition> getMapping() {
            return this.mapping;
        }
    }

    private static final class BQOpBucket {
        private final ArrayList<DFAStateTransitionBuilder> transitions = new ArrayList();
        private DFABQTrackingTransitionOpsNode bqTransition = null;
        private BQOpBucket parent;

        private BQOpBucket() {
        }

        DFABQTrackingTransitionOpsNode getBQTransition(DFAGenerator dfaGen, ObjectArrayBuffer<DFAAbstractNode> nodes, DFAStateTransitionBuilder t, int curLevel) {
            short successorID;
            int fromIndex;
            if (this.bqTransition != null) {
                return this.bqTransition;
            }
            long[] ops = t.getOperations();
            int toIndex = fromIndex = ops.length - curLevel;
            BQOpBucket curBucket = this;
            DFABQTrackingTransitionOpsNode parentTransition = null;
            while ((parentTransition = curBucket.bqTransition) == null) {
                ++toIndex;
                curBucket = curBucket.parent;
                if (curBucket != null) continue;
            }
            short s = successorID = parentTransition == null ? (short)t.getTarget().getId() : parentTransition.getId();
            assert (fromIndex >= 0 && fromIndex < ops.length && toIndex > fromIndex && toIndex <= ops.length);
            long[] opsSlice = Arrays.copyOfRange(ops, fromIndex, toIndex);
            short s2 = dfaGen.nextID;
            dfaGen.nextID = (short)(s2 + 1);
            this.bqTransition = DFAGenerator.insertNode(nodes, new DFABQTrackingTransitionOpsNode(s2, successorID, opsSlice));
            return this.bqTransition;
        }
    }
}

