/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.automaton;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.tregex.automaton.AbstractState;
import com.oracle.truffle.regex.tregex.automaton.AbstractTransition;
import com.oracle.truffle.regex.tregex.automaton.StateIndex;
import com.oracle.truffle.regex.tregex.automaton.StateSet;
import com.oracle.truffle.regex.tregex.automaton.TransitionSet;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFABQTrackingTransitionOpsNode;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;

public class TransitionBuilder<SI extends StateIndex<? super S>, S extends AbstractState<S, T>, T extends AbstractTransition<S, T>>
implements JsonConvertible {
    private final TransitionSet<SI, S, T> transitionSet;
    private CodePointSet cps;
    private long[] constraints;
    private long[] operations;
    private DFABQTrackingTransitionOpsNode bqTransition;

    public TransitionBuilder(T[] transitions, StateSet<SI, S> targetStateSet, CodePointSet matcherBuilder, long[] constraints, long[] operations) {
        this(new TransitionSet(transitions, targetStateSet), matcherBuilder, constraints, operations);
    }

    public TransitionBuilder(TransitionSet<SI, S, T> transitionSet, CodePointSet matcherBuilder, long[] constraints, long[] operations) {
        this.transitionSet = transitionSet;
        this.cps = matcherBuilder;
        this.constraints = constraints;
        this.operations = operations;
    }

    public TransitionSet<SI, S, T> getTransitionSet() {
        return this.transitionSet;
    }

    public CodePointSet getCodePointSet() {
        return this.cps;
    }

    public void setMatcherBuilder(CodePointSet cps) {
        this.cps = cps;
    }

    public long[] getConstraints() {
        return this.constraints;
    }

    public void setConstraints(long[] constraints) {
        this.constraints = constraints;
    }

    public boolean hasConstraints() {
        return this.constraints.length > 0;
    }

    public boolean hasNoConstraints() {
        return this.constraints.length == 0;
    }

    public long[] getOperations() {
        return this.operations;
    }

    public void setOperations(long[] operations) {
        this.operations = operations;
    }

    public boolean hasOperations() {
        return this.operations.length > 0;
    }

    public boolean hasBqTransition() {
        return this.bqTransition != null;
    }

    public DFABQTrackingTransitionOpsNode getBqTransition() {
        return this.bqTransition;
    }

    public void setBqTransition(DFABQTrackingTransitionOpsNode bqTransition) {
        assert (this.bqTransition == null);
        this.bqTransition = bqTransition;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return Json.obj(Json.prop("matcherBuilder", this.getCodePointSet()));
    }
}

