/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.log;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.snowflake.client.jdbc.SnowflakeUtil;

enum CommonsLoggingWrapperMode {
    ALL,
    DEFAULT,
    OFF;

    static final String JAVA_PROPERTY = "net.snowflake.jdbc.commons_logging_wrapper";

    static CommonsLoggingWrapperMode detect() {
        String value = SnowflakeUtil.systemGetProperty(JAVA_PROPERTY);
        if (value == null) {
            return DEFAULT;
        }
        try {
            return CommonsLoggingWrapperMode.valueOf(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unknown commons logging wrapper value '" + value + "', expected one of: " + Stream.of(CommonsLoggingWrapperMode.values()).map(Enum::name).collect(Collectors.joining(", ")));
        }
    }
}

