/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.ThreadSafe;
import net.snowflake.client.jdbc.internal.opentelemetry.context.Context;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.CompletableResultCode;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.MultiSpanProcessor;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.NoopSpanProcessor;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.ReadWriteSpan;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.ReadableSpan;

@ThreadSafe
public interface SpanProcessor
extends Closeable {
    public static SpanProcessor composite(SpanProcessor ... processors) {
        return SpanProcessor.composite(Arrays.asList(processors));
    }

    public static SpanProcessor composite(Iterable<SpanProcessor> processors) {
        ArrayList<SpanProcessor> processorsList = new ArrayList<SpanProcessor>();
        for (SpanProcessor processor : processors) {
            processorsList.add(processor);
        }
        if (processorsList.isEmpty()) {
            return NoopSpanProcessor.getInstance();
        }
        if (processorsList.size() == 1) {
            return (SpanProcessor)processorsList.get(0);
        }
        return MultiSpanProcessor.create(processorsList);
    }

    public void onStart(Context var1, ReadWriteSpan var2);

    public boolean isStartRequired();

    public void onEnd(ReadableSpan var1);

    public boolean isEndRequired();

    default public CompletableResultCode shutdown() {
        return this.forceFlush();
    }

    default public CompletableResultCode forceFlush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    default public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }
}

